// services/network/public/mojom/sri_message_signature.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/sri_message_signature.mojom-shared-internal.h"

#include "services/network/public/mojom/sri_message_signature.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SRIMessageSignatureError, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SRIMessageSignatureComponentParameterDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureComponentParameterDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureComponentParameter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::SRIMessageSignatureComponentParameter_Type>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SRIMessageSignatureComponentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureComponentDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureComponent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in SRIMessageSignatureComponent struct");

      decltype(Traits::params(input)) in_params = Traits::params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->params)::BaseType>
          params_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentParameterDataView>, send_validation>(
        in_params,
        params_fragment,
        &params_validate_params);

      fragment->params.Set(
          params_fragment.is_null() ? nullptr : params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in SRIMessageSignatureComponent struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SRIMessageSignatureDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in SRIMessageSignature struct");

      decltype(Traits::signature(input)) in_signature = Traits::signature(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature)::BaseType>
          signature_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_signature,
        signature_fragment,
        &signature_validate_params);

      fragment->signature.Set(
          signature_fragment.is_null() ? nullptr : signature_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signature.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in SRIMessageSignature struct");

      decltype(Traits::components(input)) in_components = Traits::components(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->components)::BaseType>
          components_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& components_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentDataView>, send_validation>(
        in_components,
        components_fragment,
        &components_validate_params);

      fragment->components.Set(
          components_fragment.is_null() ? nullptr : components_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->components.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null components in SRIMessageSignature struct");
      fragment->created_$flag = Traits::created(input).has_value();
      if (Traits::created(input).has_value()) {
        fragment->created_$value = Traits::created(input).value();
      }
      fragment->expires_$flag = Traits::expires(input).has_value();
      if (Traits::expires(input).has_value()) {
        fragment->expires_$value = Traits::expires(input).value();
      }

      decltype(Traits::keyid(input)) in_keyid = Traits::keyid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keyid)::BaseType>
          keyid_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& keyid_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_keyid,
        keyid_fragment,
        &keyid_validate_params);

      fragment->keyid.Set(
          keyid_fragment.is_null() ? nullptr : keyid_fragment.data());

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      decltype(Traits::tag(input)) in_tag = Traits::tag(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tag)::BaseType> tag_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_tag,
        tag_fragment);

      fragment->tag.Set(
          tag_fragment.is_null() ? nullptr : tag_fragment.data());

      decltype(Traits::serialized_signature_params(input)) in_serialized_signature_params = Traits::serialized_signature_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serialized_signature_params)::BaseType> serialized_signature_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_serialized_signature_params,
        serialized_signature_params_fragment);

      fragment->serialized_signature_params.Set(
          serialized_signature_params_fragment.is_null() ? nullptr : serialized_signature_params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->serialized_signature_params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serialized_signature_params in SRIMessageSignature struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SRIMessageSignatureIssueDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureIssueDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureIssue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::SRIMessageSignatureError>(
        Traits::error(input),
        &fragment->error);

      decltype(Traits::signature_base(input)) in_signature_base = Traits::signature_base(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signature_base)::BaseType> signature_base_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_signature_base,
        signature_base_fragment);

      fragment->signature_base.Set(
          signature_base_fragment.is_null() ? nullptr : signature_base_fragment.data());

      decltype(Traits::integrity_assertions(input)) in_integrity_assertions = Traits::integrity_assertions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->integrity_assertions)::BaseType>
          integrity_assertions_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& integrity_assertions_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_integrity_assertions,
        integrity_assertions_fragment,
        &integrity_assertions_validate_params);

      fragment->integrity_assertions.Set(
          integrity_assertions_fragment.is_null() ? nullptr : integrity_assertions_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SRIMessageSignaturesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignaturesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::signatures(input)) in_signatures = Traits::signatures(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->signatures)::BaseType>
          signatures_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& signatures_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureDataView>, send_validation>(
        in_signatures,
        signatures_fragment,
        &signatures_validate_params);

      fragment->signatures.Set(
          signatures_fragment.is_null() ? nullptr : signatures_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->signatures.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signatures in SRIMessageSignatures struct");

      decltype(Traits::issues(input)) in_issues = Traits::issues(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issues)::BaseType>
          issues_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>, send_validation>(
        in_issues,
        issues_fragment,
        &issues_validate_params);

      fragment->issues.Set(
          issues_fragment.is_null() ? nullptr : issues_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->issues.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issues in SRIMessageSignatures struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SEND_VALIDATION_H_