// services/network/public/mojom/socket_broker.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.AddressFamily');
goog.require('network.mojom.TransferableSocket');






goog.provide('network.mojom.SocketBroker');
goog.provide('network.mojom.SocketBrokerReceiver');
goog.provide('network.mojom.SocketBrokerCallbackRouter');
goog.provide('network.mojom.SocketBrokerInterface');
goog.provide('network.mojom.SocketBrokerRemote');
goog.provide('network.mojom.SocketBrokerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SocketBrokerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SocketBroker.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SocketBrokerInterface = class {
  
  /**
   * @param { !network.mojom.AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network.mojom.TransferableSocket,
        rv: !number,
   *  }>}
   */

  createTcpSocket(addressFamily) {}
  
  /**
   * @param { !network.mojom.AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network.mojom.TransferableSocket,
        rv: !number,
   *  }>}
   */

  createUdpSocket(addressFamily) {}
};

/**
 * @export
 * @implements { network.mojom.SocketBrokerInterface }
 */
network.mojom.SocketBrokerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SocketBrokerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SocketBrokerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SocketBrokerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network.mojom.TransferableSocket,
        rv: !number,
   *  }>}
   */

  createTcpSocket(
      addressFamily) {
    return this.proxy.sendMessage(
        0,
        network.mojom.SocketBroker_CreateTcpSocket_ParamsSpec.$,
        network.mojom.SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
        [
          addressFamily
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.AddressFamily } addressFamily
   * @return {!Promise<{
        createdSocket: !network.mojom.TransferableSocket,
        rv: !number,
   *  }>}
   */

  createUdpSocket(
      addressFamily) {
    return this.proxy.sendMessage(
        1,
        network.mojom.SocketBroker_CreateUdpSocket_ParamsSpec.$,
        network.mojom.SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
        [
          addressFamily
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SocketBroker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SocketBrokerReceiver = class {
  /**
   * @param {!network.mojom.SocketBrokerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SocketBrokerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SocketBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SocketBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SocketBroker_CreateTcpSocket_ParamsSpec.$,
        network.mojom.SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
        impl.createTcpSocket.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.SocketBroker_CreateUdpSocket_ParamsSpec.$,
        network.mojom.SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
        impl.createUdpSocket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SocketBroker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SocketBroker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SocketBrokerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SocketBrokerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SocketBroker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SocketBrokerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SocketBrokerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SocketBrokerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createTcpSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SocketBroker_CreateTcpSocket_ParamsSpec.$,
        network.mojom.SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
        this.createTcpSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createUdpSocket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.SocketBroker_CreateUdpSocket_ParamsSpec.$,
        network.mojom.SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
        this.createUdpSocket.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SocketBroker_CreateTcpSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SocketBroker_CreateTcpSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SocketBroker_CreateTcpSocket_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SocketBroker_CreateTcpSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SocketBroker_CreateUdpSocket_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SocketBroker_CreateUdpSocket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SocketBroker_CreateUdpSocket_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SocketBroker_CreateUdpSocket_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.SocketBroker_CreateTcpSocket_ParamsSpec.$,
    'SocketBroker_CreateTcpSocket_Params',
    [
      mojo.internal.StructField(
        'addressFamily', 0,
        0,
        network.mojom.AddressFamilySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SocketBroker_CreateTcpSocket_Params');

/** @record */
network.mojom.SocketBroker_CreateTcpSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.AddressFamily } */
    this.addressFamily;
  }
};



mojo.internal.Struct(
    network.mojom.SocketBroker_CreateTcpSocket_ResponseParamsSpec.$,
    'SocketBroker_CreateTcpSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'createdSocket', 0,
        0,
        network.mojom.TransferableSocketSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rv', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SocketBroker_CreateTcpSocket_ResponseParams');

/** @record */
network.mojom.SocketBroker_CreateTcpSocket_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.TransferableSocket } */
    this.createdSocket;
    /** @export { !number } */
    this.rv;
  }
};



mojo.internal.Struct(
    network.mojom.SocketBroker_CreateUdpSocket_ParamsSpec.$,
    'SocketBroker_CreateUdpSocket_Params',
    [
      mojo.internal.StructField(
        'addressFamily', 0,
        0,
        network.mojom.AddressFamilySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SocketBroker_CreateUdpSocket_Params');

/** @record */
network.mojom.SocketBroker_CreateUdpSocket_Params = class {
  constructor() {
    /** @export { !network.mojom.AddressFamily } */
    this.addressFamily;
  }
};



mojo.internal.Struct(
    network.mojom.SocketBroker_CreateUdpSocket_ResponseParamsSpec.$,
    'SocketBroker_CreateUdpSocket_ResponseParams',
    [
      mojo.internal.StructField(
        'createdSocket', 0,
        0,
        network.mojom.TransferableSocketSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rv', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.SocketBroker_CreateUdpSocket_ResponseParams');

/** @record */
network.mojom.SocketBroker_CreateUdpSocket_ResponseParams = class {
  constructor() {
    /** @export { !network.mojom.TransferableSocket } */
    this.createdSocket;
    /** @export { !number } */
    this.rv;
  }
};

