// services/network/public/mojom/socket_broker.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/socket_broker.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/socket_broker.mojom-params-data.h"
#include "services/network/public/mojom/socket_broker.mojom-shared-message-ids.h"

#include "services/network/public/mojom/socket_broker.mojom-blink-import-headers.h"
#include "services/network/public/mojom/socket_broker.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
// The declaration includes the definition on other builds.

SocketBroker::IPCStableHashFunction SocketBroker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SocketBroker>(message.name())) {
    case messages::SocketBroker::kCreateTcpSocket: {
      return &SocketBroker::CreateTcpSocket_Sym::IPCStableHash;
    }
    case messages::SocketBroker::kCreateUdpSocket: {
      return &SocketBroker::CreateUdpSocket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SocketBroker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SocketBroker>(message.name())) {
      case messages::SocketBroker::kCreateTcpSocket:
            return "Receive network::mojom::SocketBroker::CreateTcpSocket";
      case messages::SocketBroker::kCreateUdpSocket:
            return "Receive network::mojom::SocketBroker::CreateUdpSocket";
    }
  } else {
    switch (static_cast<messages::SocketBroker>(message.name())) {
      case messages::SocketBroker::kCreateTcpSocket:
            return "Receive reply network::mojom::SocketBroker::CreateTcpSocket";
      case messages::SocketBroker::kCreateUdpSocket:
            return "Receive reply network::mojom::SocketBroker::CreateUdpSocket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SocketBroker::CreateTcpSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x703e205c;  // IPCStableHash for network::mojom::SocketBroker::CreateTcpSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SocketBroker::CreateUdpSocket_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24c19b7e;  // IPCStableHash for network::mojom::SocketBroker::CreateUdpSocket
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SocketBroker_CreateTcpSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SocketBroker_CreateTcpSocket_ForwardToCallback(
      SocketBroker::CreateTcpSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  SocketBroker_CreateTcpSocket_ForwardToCallback(const SocketBroker_CreateTcpSocket_ForwardToCallback&) = delete;
  SocketBroker_CreateTcpSocket_ForwardToCallback& operator=(const SocketBroker_CreateTcpSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SocketBroker::CreateTcpSocketCallback callback_;
};

class SocketBroker_CreateUdpSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SocketBroker_CreateUdpSocket_ForwardToCallback(
      SocketBroker::CreateUdpSocketCallback callback
      ) : callback_(std::move(callback)) {
  }

  SocketBroker_CreateUdpSocket_ForwardToCallback(const SocketBroker_CreateUdpSocket_ForwardToCallback&) = delete;
  SocketBroker_CreateUdpSocket_ForwardToCallback& operator=(const SocketBroker_CreateUdpSocket_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SocketBroker::CreateUdpSocketCallback callback_;
};

SocketBrokerProxy::SocketBrokerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SocketBrokerProxy::CreateTcpSocket(
    ::net::AddressFamily in_address_family, CreateTcpSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SocketBroker::CreateTcpSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address_family"), in_address_family,
                        "<value of type ::net::AddressFamily>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SocketBroker::kCreateTcpSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketBroker_CreateTcpSocket_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::AddressFamily>(
    in_address_family,
    &params->address_family);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketBroker::Name_);
  message.set_method_name("CreateTcpSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SocketBroker_CreateTcpSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SocketBrokerProxy::CreateUdpSocket(
    ::net::AddressFamily in_address_family, CreateUdpSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SocketBroker::CreateUdpSocket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("address_family"), in_address_family,
                        "<value of type ::net::AddressFamily>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SocketBroker::kCreateUdpSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketBroker_CreateUdpSocket_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::AddressFamily>(
    in_address_family,
    &params->address_family);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketBroker::Name_);
  message.set_method_name("CreateUdpSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SocketBroker_CreateUdpSocket_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SocketBroker_CreateTcpSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SocketBroker::CreateTcpSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SocketBroker_CreateTcpSocket_ProxyToResponder> proxy(
        new SocketBroker_CreateTcpSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SocketBroker_CreateTcpSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SocketBroker_CreateTcpSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SocketBroker_CreateTcpSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SocketBroker::CreateTcpSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::blink::TransferableSocketPtr in_created_socket, int32_t in_rv);
};

bool SocketBroker_CreateTcpSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SocketBroker_CreateTcpSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SocketBroker_CreateTcpSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SocketBroker.0
  bool success = true;
  ::network::mojom::blink::TransferableSocketPtr p_created_socket{};
  int32_t p_rv{};
  SocketBroker_CreateTcpSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCreatedSocket(&p_created_socket))
    success = false;
  if (success)
    p_rv = input_data_view.rv();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SocketBroker::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_created_socket), 
std::move(p_rv));
  }
  return true;
}

void SocketBroker_CreateTcpSocket_ProxyToResponder::Run(
    ::network::mojom::blink::TransferableSocketPtr in_created_socket, int32_t in_rv) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SocketBroker::CreateTcpSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("created_socket"), in_created_socket,
                        "<value of type ::network::mojom::blink::TransferableSocketPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rv"), in_rv,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SocketBroker::kCreateTcpSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketBroker_CreateTcpSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->created_socket)::BaseType> created_socket_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::TransferableSocketDataView>(
    in_created_socket,
    created_socket_fragment);

  params->created_socket.Set(
      created_socket_fragment.is_null() ? nullptr : created_socket_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->created_socket.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null created_socket in ");

  params->rv = in_rv;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketBroker::Name_);
  message.set_method_name("CreateTcpSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SocketBroker_CreateUdpSocket_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SocketBroker::CreateUdpSocketCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SocketBroker_CreateUdpSocket_ProxyToResponder> proxy(
        new SocketBroker_CreateUdpSocket_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SocketBroker_CreateUdpSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SocketBroker_CreateUdpSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SocketBroker_CreateUdpSocket_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SocketBroker::CreateUdpSocketCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::blink::TransferableSocketPtr in_created_socket, int32_t in_rv);
};

bool SocketBroker_CreateUdpSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SocketBroker_CreateUdpSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SocketBroker_CreateUdpSocket_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SocketBroker.1
  bool success = true;
  ::network::mojom::blink::TransferableSocketPtr p_created_socket{};
  int32_t p_rv{};
  SocketBroker_CreateUdpSocket_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCreatedSocket(&p_created_socket))
    success = false;
  if (success)
    p_rv = input_data_view.rv();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SocketBroker::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_created_socket), 
std::move(p_rv));
  }
  return true;
}

void SocketBroker_CreateUdpSocket_ProxyToResponder::Run(
    ::network::mojom::blink::TransferableSocketPtr in_created_socket, int32_t in_rv) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::SocketBroker::CreateUdpSocket", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("created_socket"), in_created_socket,
                        "<value of type ::network::mojom::blink::TransferableSocketPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rv"), in_rv,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SocketBroker::kCreateUdpSocket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SocketBroker_CreateUdpSocket_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->created_socket)::BaseType> created_socket_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::TransferableSocketDataView>(
    in_created_socket,
    created_socket_fragment);

  params->created_socket.Set(
      created_socket_fragment.is_null() ? nullptr : created_socket_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->created_socket.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null created_socket in ");

  params->rv = in_rv;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SocketBroker::Name_);
  message.set_method_name("CreateUdpSocket");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SocketBrokerStubDispatch::Accept(
    SocketBroker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SocketBroker>(message->header()->name)) {
    case messages::SocketBroker::kCreateTcpSocket: {
      break;
    }
    case messages::SocketBroker::kCreateUdpSocket: {
      break;
    }
  }
  return false;
}

// static
bool SocketBrokerStubDispatch::AcceptWithResponder(
    SocketBroker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SocketBroker>(message->header()->name)) {
    case messages::SocketBroker::kCreateTcpSocket: {
      internal::SocketBroker_CreateTcpSocket_Params_Data* params =
          reinterpret_cast<
              internal::SocketBroker_CreateTcpSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SocketBroker.0
      bool success = true;
      ::net::AddressFamily p_address_family{};
      SocketBroker_CreateTcpSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddressFamily(&p_address_family))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SocketBroker::Name_, 0, false);
        return false;
      }
      auto callback =
          SocketBroker_CreateTcpSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTcpSocket(        
        std::move(p_address_family), std::move(callback));
      return true;
    }
    case messages::SocketBroker::kCreateUdpSocket: {
      internal::SocketBroker_CreateUdpSocket_Params_Data* params =
          reinterpret_cast<
              internal::SocketBroker_CreateUdpSocket_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SocketBroker.1
      bool success = true;
      ::net::AddressFamily p_address_family{};
      SocketBroker_CreateUdpSocket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAddressFamily(&p_address_family))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SocketBroker::Name_, 1, false);
        return false;
      }
      auto callback =
          SocketBroker_CreateUdpSocket_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateUdpSocket(        
        std::move(p_address_family), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSocketBrokerValidationInfo[] = {
    { &internal::SocketBroker_CreateTcpSocket_Params_Data::Validate,
     &internal::SocketBroker_CreateTcpSocket_ResponseParams_Data::Validate},
    { &internal::SocketBroker_CreateUdpSocket_Params_Data::Validate,
     &internal::SocketBroker_CreateUdpSocket_ResponseParams_Data::Validate},
};

bool SocketBrokerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::SocketBroker::Name_,
    kSocketBrokerValidationInfo);
}

bool SocketBrokerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::blink::SocketBroker::Name_,
    kSocketBrokerValidationInfo);
}


}  // network::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void SocketBrokerInterceptorForTesting::CreateTcpSocket(::net::AddressFamily address_family, CreateTcpSocketCallback callback) {
  GetForwardingInterface()->CreateTcpSocket(
    std::move(address_family)
    , std::move(callback));
}
void SocketBrokerInterceptorForTesting::CreateUdpSocket(::net::AddressFamily address_family, CreateUdpSocketCallback callback) {
  GetForwardingInterface()->CreateUdpSocket(
    std::move(address_family)
    , std::move(callback));
}
SocketBrokerAsyncWaiter::SocketBrokerAsyncWaiter(
    SocketBroker* proxy) : proxy_(proxy) {}

SocketBrokerAsyncWaiter::~SocketBrokerAsyncWaiter() = default;


void SocketBrokerAsyncWaiter::CreateTcpSocket(
    ::net::AddressFamily address_family, ::network::mojom::blink::TransferableSocketPtr* out_created_socket, int32_t* out_rv) {
  base::RunLoop loop;
  proxy_->CreateTcpSocket(
      std::move(address_family),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::blink::TransferableSocketPtr* out_created_socket
,
             int32_t* out_rv
,
             ::network::mojom::blink::TransferableSocketPtr created_socket,
             int32_t rv) {*out_created_socket = std::move(created_socket);*out_rv = std::move(rv);
            loop->Quit();
          },
          &loop,
          out_created_socket,
          out_rv));
  loop.Run();
}



void SocketBrokerAsyncWaiter::CreateUdpSocket(
    ::net::AddressFamily address_family, ::network::mojom::blink::TransferableSocketPtr* out_created_socket, int32_t* out_rv) {
  base::RunLoop loop;
  proxy_->CreateUdpSocket(
      std::move(address_family),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::blink::TransferableSocketPtr* out_created_socket
,
             int32_t* out_rv
,
             ::network::mojom::blink::TransferableSocketPtr created_socket,
             int32_t rv) {*out_created_socket = std::move(created_socket);*out_rv = std::move(rv);
            loop->Quit();
          },
          &loop,
          out_created_socket,
          out_rv));
  loop.Run();
}








}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif