// services/network/public/mojom/restricted_udp_socket.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/restricted_udp_socket.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/restricted_udp_socket.mojom-params-data.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/restricted_udp_socket.mojom-blink-import-headers.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
RestrictedUDPSocketParams::RestrictedUDPSocketParams()
    : socket_options() {}

RestrictedUDPSocketParams::RestrictedUDPSocketParams(
    ::network::mojom::blink::UDPSocketOptionsPtr socket_options_in)
    : socket_options(std::move(socket_options_in)) {}

RestrictedUDPSocketParams::~RestrictedUDPSocketParams() = default;

void RestrictedUDPSocketParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "socket_options"), this->socket_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::UDPSocketOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RestrictedUDPSocketParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

RestrictedUDPSocket::IPCStableHashFunction RestrictedUDPSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RestrictedUDPSocket>(message.name())) {
    case messages::RestrictedUDPSocket::kJoinGroup: {
      return &RestrictedUDPSocket::JoinGroup_Sym::IPCStableHash;
    }
    case messages::RestrictedUDPSocket::kLeaveGroup: {
      return &RestrictedUDPSocket::LeaveGroup_Sym::IPCStableHash;
    }
    case messages::RestrictedUDPSocket::kReceiveMore: {
      return &RestrictedUDPSocket::ReceiveMore_Sym::IPCStableHash;
    }
    case messages::RestrictedUDPSocket::kSend: {
      return &RestrictedUDPSocket::Send_Sym::IPCStableHash;
    }
    case messages::RestrictedUDPSocket::kSendTo: {
      return &RestrictedUDPSocket::SendTo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RestrictedUDPSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RestrictedUDPSocket>(message.name())) {
      case messages::RestrictedUDPSocket::kJoinGroup:
            return "Receive network::mojom::RestrictedUDPSocket::JoinGroup";
      case messages::RestrictedUDPSocket::kLeaveGroup:
            return "Receive network::mojom::RestrictedUDPSocket::LeaveGroup";
      case messages::RestrictedUDPSocket::kReceiveMore:
            return "Receive network::mojom::RestrictedUDPSocket::ReceiveMore";
      case messages::RestrictedUDPSocket::kSend:
            return "Receive network::mojom::RestrictedUDPSocket::Send";
      case messages::RestrictedUDPSocket::kSendTo:
            return "Receive network::mojom::RestrictedUDPSocket::SendTo";
    }
  } else {
    switch (static_cast<messages::RestrictedUDPSocket>(message.name())) {
      case messages::RestrictedUDPSocket::kJoinGroup:
            return "Receive reply network::mojom::RestrictedUDPSocket::JoinGroup";
      case messages::RestrictedUDPSocket::kLeaveGroup:
            return "Receive reply network::mojom::RestrictedUDPSocket::LeaveGroup";
      case messages::RestrictedUDPSocket::kReceiveMore:
            return "Receive reply network::mojom::RestrictedUDPSocket::ReceiveMore";
      case messages::RestrictedUDPSocket::kSend:
            return "Receive reply network::mojom::RestrictedUDPSocket::Send";
      case messages::RestrictedUDPSocket::kSendTo:
            return "Receive reply network::mojom::RestrictedUDPSocket::SendTo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RestrictedUDPSocket::JoinGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9268d663;  // IPCStableHash for network::mojom::RestrictedUDPSocket::JoinGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedUDPSocket::LeaveGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa49530cf;  // IPCStableHash for network::mojom::RestrictedUDPSocket::LeaveGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedUDPSocket::ReceiveMore_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e20114a;  // IPCStableHash for network::mojom::RestrictedUDPSocket::ReceiveMore
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedUDPSocket::Send_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99878f0a;  // IPCStableHash for network::mojom::RestrictedUDPSocket::Send
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedUDPSocket::SendTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c49d238;  // IPCStableHash for network::mojom::RestrictedUDPSocket::SendTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RestrictedUDPSocket_JoinGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedUDPSocket_JoinGroup_ForwardToCallback(
      RestrictedUDPSocket::JoinGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedUDPSocket_JoinGroup_ForwardToCallback(const RestrictedUDPSocket_JoinGroup_ForwardToCallback&) = delete;
  RestrictedUDPSocket_JoinGroup_ForwardToCallback& operator=(const RestrictedUDPSocket_JoinGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedUDPSocket::JoinGroupCallback callback_;
};

class RestrictedUDPSocket_LeaveGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedUDPSocket_LeaveGroup_ForwardToCallback(
      RestrictedUDPSocket::LeaveGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedUDPSocket_LeaveGroup_ForwardToCallback(const RestrictedUDPSocket_LeaveGroup_ForwardToCallback&) = delete;
  RestrictedUDPSocket_LeaveGroup_ForwardToCallback& operator=(const RestrictedUDPSocket_LeaveGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedUDPSocket::LeaveGroupCallback callback_;
};

class RestrictedUDPSocket_Send_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedUDPSocket_Send_ForwardToCallback(
      RestrictedUDPSocket::SendCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedUDPSocket_Send_ForwardToCallback(const RestrictedUDPSocket_Send_ForwardToCallback&) = delete;
  RestrictedUDPSocket_Send_ForwardToCallback& operator=(const RestrictedUDPSocket_Send_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedUDPSocket::SendCallback callback_;
};

class RestrictedUDPSocket_SendTo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedUDPSocket_SendTo_ForwardToCallback(
      RestrictedUDPSocket::SendToCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedUDPSocket_SendTo_ForwardToCallback(const RestrictedUDPSocket_SendTo_ForwardToCallback&) = delete;
  RestrictedUDPSocket_SendTo_ForwardToCallback& operator=(const RestrictedUDPSocket_SendTo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedUDPSocket::SendToCallback callback_;
};

RestrictedUDPSocketProxy::RestrictedUDPSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RestrictedUDPSocketProxy::JoinGroup(
    const ::net::IPAddress& in_group_address, JoinGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedUDPSocket::JoinGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_address"), in_group_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kJoinGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_JoinGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_address)::BaseType> group_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
    in_group_address,
    group_address_fragment);

  params->group_address.Set(
      group_address_fragment.is_null() ? nullptr : group_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_address in RestrictedUDPSocket.JoinGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("JoinGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedUDPSocket_JoinGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RestrictedUDPSocketProxy::LeaveGroup(
    const ::net::IPAddress& in_group_address, LeaveGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedUDPSocket::LeaveGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_address"), in_group_address,
                        "<value of type const ::net::IPAddress&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kLeaveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_LeaveGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_address)::BaseType> group_address_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
    in_group_address,
    group_address_fragment);

  params->group_address.Set(
      group_address_fragment.is_null() ? nullptr : group_address_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_address.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_address in RestrictedUDPSocket.LeaveGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("LeaveGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedUDPSocket_LeaveGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RestrictedUDPSocketProxy::ReceiveMore(
    uint32_t in_num_additional_datagrams) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedUDPSocket::ReceiveMore", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("num_additional_datagrams"), in_num_additional_datagrams,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kReceiveMore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_ReceiveMore_Params_Data> params(
          message);
  params.Allocate();

  params->num_additional_datagrams = in_num_additional_datagrams;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("ReceiveMore");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RestrictedUDPSocketProxy::Send(
    ::base::span<const ::uint8_t> in_data, SendCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedUDPSocket::Send", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kSend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_Send_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in RestrictedUDPSocket.Send request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("Send");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedUDPSocket_Send_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RestrictedUDPSocketProxy::SendTo(
    ::base::span<const ::uint8_t> in_data, const ::net::HostPortPair& in_dest_addr, ::net::DnsQueryType in_dns_query_type, SendToCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedUDPSocket::SendTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::base::span<const ::uint8_t>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dest_addr"), in_dest_addr,
                        "<value of type const ::net::HostPortPair&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dns_query_type"), in_dns_query_type,
                        "<value of type ::net::DnsQueryType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kSendTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_SendTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in RestrictedUDPSocket.SendTo request");
  mojo::internal::MessageFragment<
      typename decltype(params->dest_addr)::BaseType> dest_addr_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
    in_dest_addr,
    dest_addr_fragment);

  params->dest_addr.Set(
      dest_addr_fragment.is_null() ? nullptr : dest_addr_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dest_addr.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dest_addr in RestrictedUDPSocket.SendTo request");

  
  mojo::internal::Serialize<::network::mojom::DnsQueryType>(
    in_dns_query_type,
    &params->dns_query_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("SendTo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedUDPSocket_SendTo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RestrictedUDPSocket_JoinGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedUDPSocket::JoinGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedUDPSocket_JoinGroup_ProxyToResponder> proxy(
        new RestrictedUDPSocket_JoinGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedUDPSocket_JoinGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedUDPSocket_JoinGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedUDPSocket_JoinGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedUDPSocket::JoinGroupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool RestrictedUDPSocket_JoinGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedUDPSocket_JoinGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedUDPSocket_JoinGroup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedUDPSocket.0
  bool success = true;
  int32_t p_result{};
  RestrictedUDPSocket_JoinGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedUDPSocket::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void RestrictedUDPSocket_JoinGroup_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedUDPSocket::JoinGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kJoinGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_JoinGroup_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("JoinGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedUDPSocket_LeaveGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedUDPSocket::LeaveGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedUDPSocket_LeaveGroup_ProxyToResponder> proxy(
        new RestrictedUDPSocket_LeaveGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedUDPSocket_LeaveGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedUDPSocket_LeaveGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedUDPSocket_LeaveGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedUDPSocket::LeaveGroupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool RestrictedUDPSocket_LeaveGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedUDPSocket_LeaveGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedUDPSocket_LeaveGroup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedUDPSocket.1
  bool success = true;
  int32_t p_result{};
  RestrictedUDPSocket_LeaveGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedUDPSocket::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void RestrictedUDPSocket_LeaveGroup_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedUDPSocket::LeaveGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kLeaveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_LeaveGroup_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("LeaveGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedUDPSocket_Send_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedUDPSocket::SendCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedUDPSocket_Send_ProxyToResponder> proxy(
        new RestrictedUDPSocket_Send_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedUDPSocket_Send_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedUDPSocket_Send_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedUDPSocket_Send_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedUDPSocket::SendCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool RestrictedUDPSocket_Send_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedUDPSocket_Send_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedUDPSocket_Send_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedUDPSocket.3
  bool success = true;
  int32_t p_result{};
  RestrictedUDPSocket_Send_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedUDPSocket::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void RestrictedUDPSocket_Send_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedUDPSocket::Send", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kSend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_Send_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("Send");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedUDPSocket_SendTo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedUDPSocket::SendToCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedUDPSocket_SendTo_ProxyToResponder> proxy(
        new RestrictedUDPSocket_SendTo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedUDPSocket_SendTo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedUDPSocket_SendTo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedUDPSocket_SendTo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedUDPSocket::SendToCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result);
};

bool RestrictedUDPSocket_SendTo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedUDPSocket_SendTo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedUDPSocket_SendTo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedUDPSocket.4
  bool success = true;
  int32_t p_result{};
  RestrictedUDPSocket_SendTo_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedUDPSocket::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void RestrictedUDPSocket_SendTo_ProxyToResponder::Run(
    int32_t in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedUDPSocket::SendTo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedUDPSocket::kSendTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedUDPSocket_SendTo_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->result = in_result;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedUDPSocket::Name_);
  message.set_method_name("SendTo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RestrictedUDPSocketStubDispatch::Accept(
    RestrictedUDPSocket* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RestrictedUDPSocket>(message->header()->name)) {
    case messages::RestrictedUDPSocket::kJoinGroup: {
      break;
    }
    case messages::RestrictedUDPSocket::kLeaveGroup: {
      break;
    }
    case messages::RestrictedUDPSocket::kReceiveMore: {
      DCHECK(message->is_serialized());
      internal::RestrictedUDPSocket_ReceiveMore_Params_Data* params =
          reinterpret_cast<internal::RestrictedUDPSocket_ReceiveMore_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RestrictedUDPSocket.2
      bool success = true;
      uint32_t p_num_additional_datagrams{};
      RestrictedUDPSocket_ReceiveMore_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_num_additional_datagrams = input_data_view.num_additional_datagrams();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedUDPSocket::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceiveMore(        
        std::move(p_num_additional_datagrams));
      return true;
    }
    case messages::RestrictedUDPSocket::kSend: {
      break;
    }
    case messages::RestrictedUDPSocket::kSendTo: {
      break;
    }
  }
  return false;
}

// static
bool RestrictedUDPSocketStubDispatch::AcceptWithResponder(
    RestrictedUDPSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RestrictedUDPSocket>(message->header()->name)) {
    case messages::RestrictedUDPSocket::kJoinGroup: {
      internal::RestrictedUDPSocket_JoinGroup_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedUDPSocket_JoinGroup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedUDPSocket.0
      bool success = true;
      ::net::IPAddress p_group_address{};
      RestrictedUDPSocket_JoinGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupAddress(&p_group_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedUDPSocket::Name_, 0, false);
        return false;
      }
      auto callback =
          RestrictedUDPSocket_JoinGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->JoinGroup(        
        std::move(p_group_address), std::move(callback));
      return true;
    }
    case messages::RestrictedUDPSocket::kLeaveGroup: {
      internal::RestrictedUDPSocket_LeaveGroup_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedUDPSocket_LeaveGroup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedUDPSocket.1
      bool success = true;
      ::net::IPAddress p_group_address{};
      RestrictedUDPSocket_LeaveGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupAddress(&p_group_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedUDPSocket::Name_, 1, false);
        return false;
      }
      auto callback =
          RestrictedUDPSocket_LeaveGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LeaveGroup(        
        std::move(p_group_address), std::move(callback));
      return true;
    }
    case messages::RestrictedUDPSocket::kReceiveMore: {
      break;
    }
    case messages::RestrictedUDPSocket::kSend: {
      internal::RestrictedUDPSocket_Send_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedUDPSocket_Send_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedUDPSocket.3
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      RestrictedUDPSocket_Send_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedUDPSocket::Name_, 3, false);
        return false;
      }
      auto callback =
          RestrictedUDPSocket_Send_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Send(        
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::RestrictedUDPSocket::kSendTo: {
      internal::RestrictedUDPSocket_SendTo_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedUDPSocket_SendTo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedUDPSocket.4
      bool success = true;
      ::base::span<const ::uint8_t> p_data{};
      ::net::HostPortPair p_dest_addr{};
      ::net::DnsQueryType p_dns_query_type{};
      RestrictedUDPSocket_SendTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadDestAddr(&p_dest_addr))
        success = false;
      if (success && !input_data_view.ReadDnsQueryType(&p_dns_query_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedUDPSocket::Name_, 4, false);
        return false;
      }
      auto callback =
          RestrictedUDPSocket_SendTo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendTo(        
        std::move(p_data), 
        std::move(p_dest_addr), 
        std::move(p_dns_query_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRestrictedUDPSocketValidationInfo[] = {
    { &internal::RestrictedUDPSocket_JoinGroup_Params_Data::Validate,
     &internal::RestrictedUDPSocket_JoinGroup_ResponseParams_Data::Validate},
    { &internal::RestrictedUDPSocket_LeaveGroup_Params_Data::Validate,
     &internal::RestrictedUDPSocket_LeaveGroup_ResponseParams_Data::Validate},
    { &internal::RestrictedUDPSocket_ReceiveMore_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RestrictedUDPSocket_Send_Params_Data::Validate,
     &internal::RestrictedUDPSocket_Send_ResponseParams_Data::Validate},
    { &internal::RestrictedUDPSocket_SendTo_Params_Data::Validate,
     &internal::RestrictedUDPSocket_SendTo_ResponseParams_Data::Validate},
};

bool RestrictedUDPSocketRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::RestrictedUDPSocket::Name_,
    kRestrictedUDPSocketValidationInfo);
}

bool RestrictedUDPSocketResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::blink::RestrictedUDPSocket::Name_,
    kRestrictedUDPSocketValidationInfo);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::RestrictedUDPSocketParams::DataView, ::network::mojom::blink::RestrictedUDPSocketParamsPtr>::Read(
    ::network::mojom::blink::RestrictedUDPSocketParams::DataView input,
    ::network::mojom::blink::RestrictedUDPSocketParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::RestrictedUDPSocketParamsPtr result(::network::mojom::blink::RestrictedUDPSocketParams::New());
  
      if (success && !input.ReadSocketOptions(&result->socket_options))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void RestrictedUDPSocketInterceptorForTesting::JoinGroup(const ::net::IPAddress& group_address, JoinGroupCallback callback) {
  GetForwardingInterface()->JoinGroup(
    std::move(group_address)
    , std::move(callback));
}
void RestrictedUDPSocketInterceptorForTesting::LeaveGroup(const ::net::IPAddress& group_address, LeaveGroupCallback callback) {
  GetForwardingInterface()->LeaveGroup(
    std::move(group_address)
    , std::move(callback));
}
void RestrictedUDPSocketInterceptorForTesting::ReceiveMore(uint32_t num_additional_datagrams) {
  GetForwardingInterface()->ReceiveMore(
    std::move(num_additional_datagrams)
    );
}
void RestrictedUDPSocketInterceptorForTesting::Send(::base::span<const ::uint8_t> data, SendCallback callback) {
  GetForwardingInterface()->Send(
    std::move(data)
    , std::move(callback));
}
void RestrictedUDPSocketInterceptorForTesting::SendTo(::base::span<const ::uint8_t> data, const ::net::HostPortPair& dest_addr, ::net::DnsQueryType dns_query_type, SendToCallback callback) {
  GetForwardingInterface()->SendTo(
    std::move(data)
    , 
    std::move(dest_addr)
    , 
    std::move(dns_query_type)
    , std::move(callback));
}
RestrictedUDPSocketAsyncWaiter::RestrictedUDPSocketAsyncWaiter(
    RestrictedUDPSocket* proxy) : proxy_(proxy) {}

RestrictedUDPSocketAsyncWaiter::~RestrictedUDPSocketAsyncWaiter() = default;


void RestrictedUDPSocketAsyncWaiter::JoinGroup(
    const ::net::IPAddress& group_address, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->JoinGroup(
      std::move(group_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t RestrictedUDPSocketAsyncWaiter::JoinGroup(
    const ::net::IPAddress& group_address) {
  int32_t async_wait_result;
  JoinGroup(std::move(group_address),&async_wait_result);
  return async_wait_result;
}

void RestrictedUDPSocketAsyncWaiter::LeaveGroup(
    const ::net::IPAddress& group_address, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->LeaveGroup(
      std::move(group_address),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t RestrictedUDPSocketAsyncWaiter::LeaveGroup(
    const ::net::IPAddress& group_address) {
  int32_t async_wait_result;
  LeaveGroup(std::move(group_address),&async_wait_result);
  return async_wait_result;
}

void RestrictedUDPSocketAsyncWaiter::Send(
    ::base::span<const ::uint8_t> data, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->Send(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t RestrictedUDPSocketAsyncWaiter::Send(
    ::base::span<const ::uint8_t> data) {
  int32_t async_wait_result;
  Send(std::move(data),&async_wait_result);
  return async_wait_result;
}

void RestrictedUDPSocketAsyncWaiter::SendTo(
    ::base::span<const ::uint8_t> data, const ::net::HostPortPair& dest_addr, ::net::DnsQueryType dns_query_type, int32_t* out_result) {
  base::RunLoop loop;
  proxy_->SendTo(
      std::move(data),
      std::move(dest_addr),
      std::move(dns_query_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_result
,
             int32_t result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

int32_t RestrictedUDPSocketAsyncWaiter::SendTo(
    ::base::span<const ::uint8_t> data, const ::net::HostPortPair& dest_addr, ::net::DnsQueryType dns_query_type) {
  int32_t async_wait_result;
  SendTo(std::move(data),std::move(dest_addr),std::move(dns_query_type),&async_wait_result);
  return async_wait_result;
}






}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif