// services/network/public/mojom/network_service_test.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_service_test.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_service_test.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_service_test.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom-blink-forward.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "services/network/public/mojom/address_list.mojom-blink-forward.h"
#include "services/network/public/mojom/host_resolver.mojom-blink-forward.h"
#include "services/network/public/mojom/network_change_manager.mojom-blink-forward.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-blink-forward.h"
#include "services/network/public/mojom/network_param.mojom-blink-forward.h"
#include "services/network/public/mojom/network_types.mojom-blink-forward.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-blink-forward.h"
#include "services/network/public/mojom/ip_endpoint.mojom-blink.h"
#include "services/network/public/mojom/transferable_socket.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class SimpleCacheEntryProxy;

template <typename ImplRefTraits>
class SimpleCacheEntryStub;

class SimpleCacheEntryRequestValidator;
class SimpleCacheEntryResponseValidator;


class BLINK_PLATFORM_EXPORT SimpleCacheEntry
    : public SimpleCacheEntryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SimpleCacheEntry";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SimpleCacheEntryInterfaceBase;
  using Proxy_ = SimpleCacheEntryProxy;

  template <typename ImplRefTraits>
  using Stub_ = SimpleCacheEntryStub<ImplRefTraits>;

  using RequestValidator_ = SimpleCacheEntryRequestValidator;
  using ResponseValidator_ = SimpleCacheEntryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kWriteDataMinVersion = 0,
    kReadDataMinVersion = 0,
    kWriteSparseDataMinVersion = 0,
    kReadSparseDataMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct WriteData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteSparseData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadSparseData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SimpleCacheEntry() = default;

  using WriteDataCallback = base::OnceCallback<void(int32_t)>;
  using WriteDataMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void WriteData(int32_t index, int32_t offset, const ::blink::Vector<uint8_t>& data, bool truncate, WriteDataCallback callback) = 0;

  using ReadDataCallback = base::OnceCallback<void(const ::blink::Vector<uint8_t>&, int32_t)>;
  using ReadDataMojoCallback = base::OnceCallback<void(const ::blink::Vector<uint8_t>&, int32_t)>;

  virtual void ReadData(int32_t index, int32_t offset, uint32_t length, ReadDataCallback callback) = 0;

  using WriteSparseDataCallback = base::OnceCallback<void(int32_t)>;
  using WriteSparseDataMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void WriteSparseData(int32_t offset, const ::blink::Vector<uint8_t>& data, WriteSparseDataCallback callback) = 0;

  using ReadSparseDataCallback = base::OnceCallback<void(const ::blink::Vector<uint8_t>&, int32_t)>;
  using ReadSparseDataMojoCallback = base::OnceCallback<void(const ::blink::Vector<uint8_t>&, int32_t)>;

  virtual void ReadSparseData(int32_t offset, uint32_t length, ReadSparseDataCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(CloseCallback callback) = 0;
};

class SimpleCacheEntryEnumeratorProxy;

template <typename ImplRefTraits>
class SimpleCacheEntryEnumeratorStub;

class SimpleCacheEntryEnumeratorRequestValidator;
class SimpleCacheEntryEnumeratorResponseValidator;


class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumerator
    : public SimpleCacheEntryEnumeratorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SimpleCacheEntryEnumerator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SimpleCacheEntryEnumeratorInterfaceBase;
  using Proxy_ = SimpleCacheEntryEnumeratorProxy;

  template <typename ImplRefTraits>
  using Stub_ = SimpleCacheEntryEnumeratorStub<ImplRefTraits>;

  using RequestValidator_ = SimpleCacheEntryEnumeratorRequestValidator;
  using ResponseValidator_ = SimpleCacheEntryEnumeratorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetNextMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetNext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SimpleCacheEntryEnumerator() = default;

  using GetNextCallback = base::OnceCallback<void(SimpleCacheOpenEntryResultPtr)>;
  using GetNextMojoCallback = base::OnceCallback<void(SimpleCacheOpenEntryResultPtr)>;

  virtual void GetNext(GetNextCallback callback) = 0;
};

class SimpleCacheProxy;

template <typename ImplRefTraits>
class SimpleCacheStub;

class SimpleCacheRequestValidator;
class SimpleCacheResponseValidator;


class BLINK_PLATFORM_EXPORT SimpleCache
    : public SimpleCacheInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SimpleCache";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SimpleCacheInterfaceBase;
  using Proxy_ = SimpleCacheProxy;

  template <typename ImplRefTraits>
  using Stub_ = SimpleCacheStub<ImplRefTraits>;

  using RequestValidator_ = SimpleCacheRequestValidator;
  using ResponseValidator_ = SimpleCacheResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateEntryMinVersion = 0,
    kOpenEntryMinVersion = 0,
    kDoomEntryMinVersion = 0,
    kDoomAllEntriesMinVersion = 0,
    kEnumerateEntriesMinVersion = 0,
    kDetachMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DoomEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DoomAllEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnumerateEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Detach_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SimpleCache() = default;

  using CreateEntryCallback = base::OnceCallback<void(::mojo::PendingRemote<SimpleCacheEntry>, int32_t)>;
  using CreateEntryMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<SimpleCacheEntry>, int32_t)>;

  virtual void CreateEntry(const ::blink::String& key, CreateEntryCallback callback) = 0;

  using OpenEntryCallback = base::OnceCallback<void(::mojo::PendingRemote<SimpleCacheEntry>, int32_t)>;
  using OpenEntryMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<SimpleCacheEntry>, int32_t)>;

  virtual void OpenEntry(const ::blink::String& key, OpenEntryCallback callback) = 0;

  using DoomEntryCallback = base::OnceCallback<void(int32_t)>;
  using DoomEntryMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void DoomEntry(const ::blink::String& key, DoomEntryCallback callback) = 0;

  using DoomAllEntriesCallback = base::OnceCallback<void(int32_t)>;
  using DoomAllEntriesMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void DoomAllEntries(DoomAllEntriesCallback callback) = 0;

  virtual void EnumerateEntries(::mojo::PendingReceiver<SimpleCacheEntryEnumerator> receiver) = 0;

  using DetachCallback = base::OnceCallback<void()>;
  using DetachMojoCallback = base::OnceCallback<void()>;

  virtual void Detach(DetachCallback callback) = 0;
};

class NetworkServiceTestProxy;

template <typename ImplRefTraits>
class NetworkServiceTestStub;

class NetworkServiceTestRequestValidator;
class NetworkServiceTestResponseValidator;


class BLINK_PLATFORM_EXPORT NetworkServiceTest
    : public NetworkServiceTestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.NetworkServiceTest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    5, 
    6, 
    8, 
    9, 
    10, 
    13, 
    14, 
    15, 
    16, 
    18, 
    25
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkServiceTestInterfaceBase;
  using Proxy_ = NetworkServiceTestProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkServiceTestStub<ImplRefTraits>;

  using RequestValidator_ = NetworkServiceTestRequestValidator;
  using ResponseValidator_ = NetworkServiceTestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddRulesMinVersion = 0,
    kSimulateNetworkChangeMinVersion = 0,
    kSimulateNetworkQualityChangeMinVersion = 0,
    kForceNetworkQualityEstimatorReportWifiAsSlow2GMinVersion = 0,
    kSimulateCrashMinVersion = 0,
    kMockCertVerifierSetDefaultResultMinVersion = 0,
    kMockCertVerifierAddResultForCertAndHostMinVersion = 0,
    kSetTransportSecurityStateTestSourceMinVersion = 0,
    kSetAllowNetworkAccessToHostResolutionsMinVersion = 0,
    kReplaceSystemDnsConfigMinVersion = 0,
    kSetTestDohConfigMinVersion = 0,
    kCrashOnResolveHostMinVersion = 0,
    kCrashOnGetCookieListMinVersion = 0,
    kGetLatestMemoryPressureLevelMinVersion = 0,
    kGetPeerToPeerConnectionsCountChangeMinVersion = 0,
    kGetEnvironmentVariableValueMinVersion = 0,
    kLogMinVersion = 0,
    kActivateFieldTrialMinVersion = 0,
    kSetSCTAuditingRetryDelayMinVersion = 0,
    kOpenFileMinVersion = 0,
    kEnumerateFilesMinVersion = 0,
    kCreateSimpleCacheMinVersion = 0,
    kMakeRequestToServerMinVersion = 0,
    kResolveOwnHostnameWithSystemDnsMinVersion = 0,
    kSetIPv6ProbeResultMinVersion = 0,
    kAllowsGSSAPILibraryLoadMinVersion = 0,
    kIsHappyEyeballsV3EnabledMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddRules_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateNetworkChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateNetworkQualityChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceNetworkQualityEstimatorReportWifiAsSlow2G_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateCrash_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MockCertVerifierSetDefaultResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MockCertVerifierAddResultForCertAndHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTransportSecurityStateTestSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAllowNetworkAccessToHostResolutions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReplaceSystemDnsConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTestDohConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CrashOnResolveHost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CrashOnGetCookieList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLatestMemoryPressureLevel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPeerToPeerConnectionsCountChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEnvironmentVariableValue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Log_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ActivateFieldTrial_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSCTAuditingRetryDelay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnumerateFiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSimpleCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeRequestToServer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolveOwnHostnameWithSystemDns_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIPv6ProbeResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllowsGSSAPILibraryLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsHappyEyeballsV3Enabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkServiceTest() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AddRules(::blink::Vector<RulePtr> rules);
  using AddRulesCallback = base::OnceCallback<void()>;
  using AddRulesMojoCallback = base::OnceCallback<void()>;

  virtual void AddRules(::blink::Vector<RulePtr> rules, AddRulesCallback callback) = 0;

  using SimulateNetworkChangeCallback = base::OnceCallback<void()>;
  using SimulateNetworkChangeMojoCallback = base::OnceCallback<void()>;

  virtual void SimulateNetworkChange(::network::mojom::blink::ConnectionType type, SimulateNetworkChangeCallback callback) = 0;

  using SimulateNetworkQualityChangeCallback = base::OnceCallback<void()>;
  using SimulateNetworkQualityChangeMojoCallback = base::OnceCallback<void()>;

  virtual void SimulateNetworkQualityChange(::network::mojom::blink::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) = 0;

  using ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback = base::OnceCallback<void()>;
  using ForceNetworkQualityEstimatorReportWifiAsSlow2GMojoCallback = base::OnceCallback<void()>;

  virtual void ForceNetworkQualityEstimatorReportWifiAsSlow2G(ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback) = 0;

  virtual void SimulateCrash() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MockCertVerifierSetDefaultResult(int32_t default_result);
  using MockCertVerifierSetDefaultResultCallback = base::OnceCallback<void()>;
  using MockCertVerifierSetDefaultResultMojoCallback = base::OnceCallback<void()>;

  virtual void MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MockCertVerifierAddResultForCertAndHost(::network::mojom::blink::X509CertificatePtr cert, const ::blink::String& host_pattern, ::network::mojom::blink::CertVerifyResultPtr verify_result, int32_t rv);
  using MockCertVerifierAddResultForCertAndHostCallback = base::OnceCallback<void()>;
  using MockCertVerifierAddResultForCertAndHostMojoCallback = base::OnceCallback<void()>;

  virtual void MockCertVerifierAddResultForCertAndHost(::network::mojom::blink::X509CertificatePtr cert, const ::blink::String& host_pattern, ::network::mojom::blink::CertVerifyResultPtr verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) = 0;

  using SetTransportSecurityStateTestSourceCallback = base::OnceCallback<void()>;
  using SetTransportSecurityStateTestSourceMojoCallback = base::OnceCallback<void()>;

  virtual void SetTransportSecurityStateTestSource(bool enable_unittest_source, SetTransportSecurityStateTestSourceCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetAllowNetworkAccessToHostResolutions();
  using SetAllowNetworkAccessToHostResolutionsCallback = base::OnceCallback<void()>;
  using SetAllowNetworkAccessToHostResolutionsMojoCallback = base::OnceCallback<void()>;

  virtual void SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReplaceSystemDnsConfig();
  using ReplaceSystemDnsConfigCallback = base::OnceCallback<void()>;
  using ReplaceSystemDnsConfigMojoCallback = base::OnceCallback<void()>;

  virtual void ReplaceSystemDnsConfig(ReplaceSystemDnsConfigCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetTestDohConfig(::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr doh_config);
  using SetTestDohConfigCallback = base::OnceCallback<void()>;
  using SetTestDohConfigMojoCallback = base::OnceCallback<void()>;

  virtual void SetTestDohConfig(::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr doh_config, SetTestDohConfigCallback callback) = 0;

  virtual void CrashOnResolveHost(const ::blink::String& host) = 0;

  virtual void CrashOnGetCookieList() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetLatestMemoryPressureLevel(::mojo_base::mojom::blink::MemoryPressureLevel* out_memory_pressure_level);
  using GetLatestMemoryPressureLevelCallback = base::OnceCallback<void(::mojo_base::mojom::blink::MemoryPressureLevel)>;
  using GetLatestMemoryPressureLevelMojoCallback = base::OnceCallback<void(::mojo_base::mojom::blink::MemoryPressureLevel)>;

  virtual void GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPeerToPeerConnectionsCountChange(uint32_t* out_connection_count);
  using GetPeerToPeerConnectionsCountChangeCallback = base::OnceCallback<void(uint32_t)>;
  using GetPeerToPeerConnectionsCountChangeMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetEnvironmentVariableValue(const ::blink::String& name, ::blink::String* out_value);
  using GetEnvironmentVariableValueCallback = base::OnceCallback<void(const ::blink::String&)>;
  using GetEnvironmentVariableValueMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void GetEnvironmentVariableValue(const ::blink::String& name, GetEnvironmentVariableValueCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Log(const ::blink::String& message);
  using LogCallback = base::OnceCallback<void()>;
  using LogMojoCallback = base::OnceCallback<void()>;

  virtual void Log(const ::blink::String& message, LogCallback callback) = 0;

  virtual void ActivateFieldTrial(const ::blink::String& field_trial_name) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay);
  using SetSCTAuditingRetryDelayCallback = base::OnceCallback<void()>;
  using SetSCTAuditingRetryDelayMojoCallback = base::OnceCallback<void()>;

  virtual void SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay, SetSCTAuditingRetryDelayCallback callback) = 0;

  using OpenFileCallback = base::OnceCallback<void(bool)>;
  using OpenFileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OpenFile(const ::base::FilePath& path, OpenFileCallback callback) = 0;

  using EnumerateFilesCallback = base::OnceCallback<void(::blink::Vector<::network::mojom::blink::FileEnumerationEntryPtr>, bool)>;
  using EnumerateFilesMojoCallback = base::OnceCallback<void(::blink::Vector<::network::mojom::blink::FileEnumerationEntryPtr>, bool)>;

  virtual void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, EnumerateFilesCallback callback) = 0;

  using CreateSimpleCacheCallback = base::OnceCallback<void(::mojo::PendingRemote<SimpleCache>)>;
  using CreateSimpleCacheMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<SimpleCache>)>;

  virtual void CreateSimpleCache(::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, CreateSimpleCacheCallback callback) = 0;

  using MakeRequestToServerCallback = base::OnceCallback<void(bool)>;
  using MakeRequestToServerMojoCallback = base::OnceCallback<void(bool)>;

  virtual void MakeRequestToServer(::network::mojom::blink::TransferableSocketPtr s, const ::net::IPEndPoint& endpoint, MakeRequestToServerCallback callback) = 0;

  using ResolveOwnHostnameWithSystemDnsCallback = base::OnceCallback<void(::network::mojom::blink::AddressListPtr, int32_t, int32_t)>;
  using ResolveOwnHostnameWithSystemDnsMojoCallback = base::OnceCallback<void(::network::mojom::blink::AddressListPtr, int32_t, int32_t)>;

  virtual void ResolveOwnHostnameWithSystemDns(ResolveOwnHostnameWithSystemDnsCallback callback) = 0;

  using SetIPv6ProbeResultCallback = base::OnceCallback<void()>;
  using SetIPv6ProbeResultMojoCallback = base::OnceCallback<void()>;

  virtual void SetIPv6ProbeResult(bool success, SetIPv6ProbeResultCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AllowsGSSAPILibraryLoad(bool* out_allow_gssapi_library_load);
  using AllowsGSSAPILibraryLoadCallback = base::OnceCallback<void(bool)>;
  using AllowsGSSAPILibraryLoadMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AllowsGSSAPILibraryLoad(AllowsGSSAPILibraryLoadCallback callback) = 0;

  using IsHappyEyeballsV3EnabledCallback = base::OnceCallback<void(bool)>;
  using IsHappyEyeballsV3EnabledMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsHappyEyeballsV3Enabled(IsHappyEyeballsV3EnabledCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT SimpleCacheEntryProxy
    : public SimpleCacheEntry {
 public:
  using InterfaceType = SimpleCacheEntry;

  explicit SimpleCacheEntryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WriteData(int32_t index, int32_t offset, const ::blink::Vector<uint8_t>& data, bool truncate, WriteDataCallback callback) final;
  
  void ReadData(int32_t index, int32_t offset, uint32_t length, ReadDataCallback callback) final;
  
  void WriteSparseData(int32_t offset, const ::blink::Vector<uint8_t>& data, WriteSparseDataCallback callback) final;
  
  void ReadSparseData(int32_t offset, uint32_t length, ReadSparseDataCallback callback) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumeratorProxy
    : public SimpleCacheEntryEnumerator {
 public:
  using InterfaceType = SimpleCacheEntryEnumerator;

  explicit SimpleCacheEntryEnumeratorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetNext(GetNextCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT SimpleCacheProxy
    : public SimpleCache {
 public:
  using InterfaceType = SimpleCache;

  explicit SimpleCacheProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateEntry(const ::blink::String& key, CreateEntryCallback callback) final;
  
  void OpenEntry(const ::blink::String& key, OpenEntryCallback callback) final;
  
  void DoomEntry(const ::blink::String& key, DoomEntryCallback callback) final;
  
  void DoomAllEntries(DoomAllEntriesCallback callback) final;
  
  void EnumerateEntries(::mojo::PendingReceiver<SimpleCacheEntryEnumerator> receiver) final;
  
  void Detach(DetachCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT NetworkServiceTestProxy
    : public NetworkServiceTest {
 public:
  using InterfaceType = NetworkServiceTest;

  explicit NetworkServiceTestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool AddRules(::blink::Vector<RulePtr> rules) final;
  
  void AddRules(::blink::Vector<RulePtr> rules, AddRulesCallback callback) final;
  
  void SimulateNetworkChange(::network::mojom::blink::ConnectionType type, SimulateNetworkChangeCallback callback) final;
  
  void SimulateNetworkQualityChange(::network::mojom::blink::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) final;
  
  void ForceNetworkQualityEstimatorReportWifiAsSlow2G(ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback) final;
  
  void SimulateCrash() final;
  
  bool MockCertVerifierSetDefaultResult(int32_t default_result) final;
  
  void MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) final;
  
  bool MockCertVerifierAddResultForCertAndHost(::network::mojom::blink::X509CertificatePtr cert, const ::blink::String& host_pattern, ::network::mojom::blink::CertVerifyResultPtr verify_result, int32_t rv) final;
  
  void MockCertVerifierAddResultForCertAndHost(::network::mojom::blink::X509CertificatePtr cert, const ::blink::String& host_pattern, ::network::mojom::blink::CertVerifyResultPtr verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) final;
  
  void SetTransportSecurityStateTestSource(bool enable_unittest_source, SetTransportSecurityStateTestSourceCallback callback) final;
  
  bool SetAllowNetworkAccessToHostResolutions() final;
  
  void SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) final;
  
  bool ReplaceSystemDnsConfig() final;
  
  void ReplaceSystemDnsConfig(ReplaceSystemDnsConfigCallback callback) final;
  
  bool SetTestDohConfig(::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr doh_config) final;
  
  void SetTestDohConfig(::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr doh_config, SetTestDohConfigCallback callback) final;
  
  void CrashOnResolveHost(const ::blink::String& host) final;
  
  void CrashOnGetCookieList() final;
  
  bool GetLatestMemoryPressureLevel(::mojo_base::mojom::blink::MemoryPressureLevel* out_memory_pressure_level) final;
  
  void GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) final;
  
  bool GetPeerToPeerConnectionsCountChange(uint32_t* out_connection_count) final;
  
  void GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) final;
  
  bool GetEnvironmentVariableValue(const ::blink::String& name, ::blink::String* out_value) final;
  
  void GetEnvironmentVariableValue(const ::blink::String& name, GetEnvironmentVariableValueCallback callback) final;
  
  bool Log(const ::blink::String& message) final;
  
  void Log(const ::blink::String& message, LogCallback callback) final;
  
  void ActivateFieldTrial(const ::blink::String& field_trial_name) final;
  
  bool SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay) final;
  
  void SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay, SetSCTAuditingRetryDelayCallback callback) final;
  
  void OpenFile(const ::base::FilePath& path, OpenFileCallback callback) final;
  
  void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, EnumerateFilesCallback callback) final;
  
  void CreateSimpleCache(::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, CreateSimpleCacheCallback callback) final;
  
  void MakeRequestToServer(::network::mojom::blink::TransferableSocketPtr s, const ::net::IPEndPoint& endpoint, MakeRequestToServerCallback callback) final;
  
  void ResolveOwnHostnameWithSystemDns(ResolveOwnHostnameWithSystemDnsCallback callback) final;
  
  void SetIPv6ProbeResult(bool success, SetIPv6ProbeResultCallback callback) final;
  
  bool AllowsGSSAPILibraryLoad(bool* out_allow_gssapi_library_load) final;
  
  void AllowsGSSAPILibraryLoad(AllowsGSSAPILibraryLoadCallback callback) final;
  
  void IsHappyEyeballsV3Enabled(IsHappyEyeballsV3EnabledCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryStubDispatch {
 public:
  static bool Accept(SimpleCacheEntry* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SimpleCacheEntry* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SimpleCacheEntry>>
class SimpleCacheEntryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SimpleCacheEntryStub() = default;
  ~SimpleCacheEntryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SimpleCacheEntryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SimpleCacheEntryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumeratorStubDispatch {
 public:
  static bool Accept(SimpleCacheEntryEnumerator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SimpleCacheEntryEnumerator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SimpleCacheEntryEnumerator>>
class SimpleCacheEntryEnumeratorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SimpleCacheEntryEnumeratorStub() = default;
  ~SimpleCacheEntryEnumeratorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SimpleCacheEntryEnumeratorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SimpleCacheEntryEnumeratorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SimpleCacheStubDispatch {
 public:
  static bool Accept(SimpleCache* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SimpleCache* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SimpleCache>>
class SimpleCacheStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SimpleCacheStub() = default;
  ~SimpleCacheStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SimpleCacheStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SimpleCacheStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT NetworkServiceTestStubDispatch {
 public:
  static bool Accept(NetworkServiceTest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkServiceTest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkServiceTest>>
class NetworkServiceTestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkServiceTestStub() = default;
  ~NetworkServiceTestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceTestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceTestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumeratorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT NetworkServiceTestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumeratorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT NetworkServiceTestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_PLATFORM_EXPORT Rule {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Rule, T>::value>;
  using DataView = RuleDataView;
  using Data_ = internal::Rule_Data;

  template <typename... Args>
  static RulePtr New(Args&&... args) {
    return RulePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RulePtr From(const U& u) {
    return mojo::TypeConverter<RulePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Rule>::Convert(*this);
  }


  Rule();

  Rule(
      ResolverType resolver_type,
      const ::blink::String& host_pattern,
      const ::blink::String& replacement,
      int32_t host_resolver_flags,
      ::blink::Vector<::blink::String> dns_aliases);


  ~Rule();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RulePtr>
  RulePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Rule::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Rule::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Rule::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Rule::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Rule::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Rule::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Rule_UnserializedMessageContext<
            UserType, Rule::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Rule::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Rule::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Rule_UnserializedMessageContext<
            UserType, Rule::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Rule::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ResolverType resolver_type;
  
  ::blink::String host_pattern;
  
  ::blink::String replacement;
  
  int32_t host_resolver_flags;
  
  ::blink::Vector<::blink::String> dns_aliases;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT SimpleCacheOpenEntryResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SimpleCacheOpenEntryResult, T>::value>;
  using DataView = SimpleCacheOpenEntryResultDataView;
  using Data_ = internal::SimpleCacheOpenEntryResult_Data;

  template <typename... Args>
  static SimpleCacheOpenEntryResultPtr New(Args&&... args) {
    return SimpleCacheOpenEntryResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SimpleCacheOpenEntryResultPtr From(const U& u) {
    return mojo::TypeConverter<SimpleCacheOpenEntryResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SimpleCacheOpenEntryResult>::Convert(*this);
  }


  SimpleCacheOpenEntryResult();

  SimpleCacheOpenEntryResult(
      int32_t error,
      const ::blink::String& key,
      ::mojo::PendingRemote<SimpleCacheEntry> entry);

SimpleCacheOpenEntryResult(const SimpleCacheOpenEntryResult&) = delete;
SimpleCacheOpenEntryResult& operator=(const SimpleCacheOpenEntryResult&) = delete;

  ~SimpleCacheOpenEntryResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SimpleCacheOpenEntryResultPtr>
  SimpleCacheOpenEntryResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SimpleCacheOpenEntryResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SimpleCacheOpenEntryResult_UnserializedMessageContext<
            UserType, SimpleCacheOpenEntryResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SimpleCacheOpenEntryResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SimpleCacheOpenEntryResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SimpleCacheOpenEntryResult_UnserializedMessageContext<
            UserType, SimpleCacheOpenEntryResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SimpleCacheOpenEntryResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t error;
  
  ::blink::String key;
  
  ::mojo::PendingRemote<SimpleCacheEntry> entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RulePtr Rule::Clone() const {
  return New(
      mojo::Clone(resolver_type),
      mojo::Clone(host_pattern),
      mojo::Clone(replacement),
      mojo::Clone(host_resolver_flags),
      mojo::Clone(dns_aliases)
  );
}

template <typename T, Rule::EnableIfSame<T>*>
bool Rule::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resolver_type, other_struct.resolver_type))
    return false;
  if (!mojo::Equals(this->host_pattern, other_struct.host_pattern))
    return false;
  if (!mojo::Equals(this->replacement, other_struct.replacement))
    return false;
  if (!mojo::Equals(this->host_resolver_flags, other_struct.host_resolver_flags))
    return false;
  if (!mojo::Equals(this->dns_aliases, other_struct.dns_aliases))
    return false;
  return true;
}

template <typename T, Rule::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.resolver_type < rhs.resolver_type)
    return true;
  if (rhs.resolver_type < lhs.resolver_type)
    return false;
  if (lhs.host_pattern < rhs.host_pattern)
    return true;
  if (rhs.host_pattern < lhs.host_pattern)
    return false;
  if (lhs.replacement < rhs.replacement)
    return true;
  if (rhs.replacement < lhs.replacement)
    return false;
  if (lhs.host_resolver_flags < rhs.host_resolver_flags)
    return true;
  if (rhs.host_resolver_flags < lhs.host_resolver_flags)
    return false;
  if (lhs.dns_aliases < rhs.dns_aliases)
    return true;
  if (rhs.dns_aliases < lhs.dns_aliases)
    return false;
  return false;
}
template <typename StructPtrType>
SimpleCacheOpenEntryResultPtr SimpleCacheOpenEntryResult::Clone() const {
  return New(
      mojo::Clone(error),
      mojo::Clone(key),
      mojo::Clone(entry)
  );
}

template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>*>
bool SimpleCacheOpenEntryResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->entry, other_struct.entry))
    return false;
  return true;
}

template <typename T, SimpleCacheOpenEntryResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.entry < rhs.entry)
    return true;
  if (rhs.entry < lhs.entry)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::Rule::DataView,
                                         ::network::mojom::blink::RulePtr> {
  static bool IsNull(const ::network::mojom::blink::RulePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::RulePtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::Rule::resolver_type) resolver_type(
      const ::network::mojom::blink::RulePtr& input) {
    return input->resolver_type;
  }

  static const decltype(::network::mojom::blink::Rule::host_pattern)& host_pattern(
      const ::network::mojom::blink::RulePtr& input) {
    return input->host_pattern;
  }

  static const decltype(::network::mojom::blink::Rule::replacement)& replacement(
      const ::network::mojom::blink::RulePtr& input) {
    return input->replacement;
  }

  static decltype(::network::mojom::blink::Rule::host_resolver_flags) host_resolver_flags(
      const ::network::mojom::blink::RulePtr& input) {
    return input->host_resolver_flags;
  }

  static const decltype(::network::mojom::blink::Rule::dns_aliases)& dns_aliases(
      const ::network::mojom::blink::RulePtr& input) {
    return input->dns_aliases;
  }

  static bool Read(::network::mojom::blink::Rule::DataView input, ::network::mojom::blink::RulePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SimpleCacheOpenEntryResult::DataView,
                                         ::network::mojom::blink::SimpleCacheOpenEntryResultPtr> {
  static bool IsNull(const ::network::mojom::blink::SimpleCacheOpenEntryResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SimpleCacheOpenEntryResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::SimpleCacheOpenEntryResult::error) error(
      const ::network::mojom::blink::SimpleCacheOpenEntryResultPtr& input) {
    return input->error;
  }

  static const decltype(::network::mojom::blink::SimpleCacheOpenEntryResult::key)& key(
      const ::network::mojom::blink::SimpleCacheOpenEntryResultPtr& input) {
    return input->key;
  }

  static  decltype(::network::mojom::blink::SimpleCacheOpenEntryResult::entry)& entry(
       ::network::mojom::blink::SimpleCacheOpenEntryResultPtr& input) {
    return input->entry;
  }

  static bool Read(::network::mojom::blink::SimpleCacheOpenEntryResult::DataView input, ::network::mojom::blink::SimpleCacheOpenEntryResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_BLINK_H_