// services/network/public/mojom/network_isolation_key.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_isolation_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"




#include "services/network/public/mojom/network_isolation_key.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::EmptyNetworkIsolationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EmptyNetworkIsolationKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EmptyNetworkIsolationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::network::mojom::internal::EmptyNetworkIsolationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::EmptyNetworkIsolationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NonEmptyNetworkIsolationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NonEmptyNetworkIsolationKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NonEmptyNetworkIsolationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::top_frame_site(input)) in_top_frame_site = Traits::top_frame_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_site)::BaseType> top_frame_site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_top_frame_site,
      top_frame_site_fragment);

    fragment->top_frame_site.Set(
        top_frame_site_fragment.is_null() ? nullptr : top_frame_site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->top_frame_site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_site in NonEmptyNetworkIsolationKey struct");

    decltype(Traits::frame_site(input)) in_frame_site = Traits::frame_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_site)::BaseType> frame_site_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_frame_site,
      frame_site_fragment);

    fragment->frame_site.Set(
        frame_site_fragment.is_null() ? nullptr : frame_site_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_site.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_site in NonEmptyNetworkIsolationKey struct");

    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_nonce,
      nonce_fragment);

    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::NetworkIsolationPartition>(
      Traits::network_isolation_partition(input),
      &fragment->network_isolation_partition);
  }

  static bool Deserialize(::network::mojom::internal::NonEmptyNetworkIsolationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NonEmptyNetworkIsolationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkIsolationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::NetworkIsolationKeyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::NetworkIsolationKey_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::NetworkIsolationKeyDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_empty)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::EmptyNetworkIsolationKeyDataView>(
  in_empty,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null empty in NetworkIsolationKey union");
    fragment->data.f_empty.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::NetworkIsolationKeyDataView::Tag::kNonEmpty: {
    decltype(Traits::non_empty(input))
    in_non_empty = Traits::non_empty(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_non_empty)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::NonEmptyNetworkIsolationKeyDataView>(
  in_non_empty,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null non_empty in NetworkIsolationKey union");
    fragment->data.f_non_empty.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::NetworkIsolationKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkIsolationKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {



inline void NonEmptyNetworkIsolationKeyDataView::GetTopFrameSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->top_frame_site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void NonEmptyNetworkIsolationKeyDataView::GetFrameSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->frame_site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void NonEmptyNetworkIsolationKeyDataView::GetNonceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void NetworkIsolationKeyDataView::GetEmptyDataView(
    EmptyNetworkIsolationKeyDataView* output) const {
  CHECK(is_empty());
  *output = EmptyNetworkIsolationKeyDataView(data_->data.f_empty.Get(), message_);
}
inline void NetworkIsolationKeyDataView::GetNonEmptyDataView(
    NonEmptyNetworkIsolationKeyDataView* output) const {
  CHECK(is_non_empty());
  *output = NonEmptyNetworkIsolationKeyDataView(data_->data.f_non_empty.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SHARED_H_