// services/network/public/mojom/network_context.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/network_context.mojom.h"


namespace network::mojom {


class  CustomProxyConnectionObserverInterceptorForTesting : public CustomProxyConnectionObserver {
  virtual CustomProxyConnectionObserver* GetForwardingInterface() = 0;
  void OnFallback(const ::net::ProxyChain& bad_chain, int32_t net_error) override;
  void OnTunnelHeadersReceived(const ::net::ProxyChain& proxy_chain, uint64_t chain_index, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers) override;
};
class  CustomProxyConnectionObserverAsyncWaiter {
 public:
  explicit CustomProxyConnectionObserverAsyncWaiter(CustomProxyConnectionObserver* proxy);

  CustomProxyConnectionObserverAsyncWaiter(const CustomProxyConnectionObserverAsyncWaiter&) = delete;
  CustomProxyConnectionObserverAsyncWaiter& operator=(const CustomProxyConnectionObserverAsyncWaiter&) = delete;

  ~CustomProxyConnectionObserverAsyncWaiter();

 private:
  CustomProxyConnectionObserver* const proxy_;
};


class  CustomProxyConfigClientInterceptorForTesting : public CustomProxyConfigClient {
  virtual CustomProxyConfigClient* GetForwardingInterface() = 0;
  void OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config, OnCustomProxyConfigUpdatedCallback callback) override;
};
class  CustomProxyConfigClientAsyncWaiter {
 public:
  explicit CustomProxyConfigClientAsyncWaiter(CustomProxyConfigClient* proxy);

  CustomProxyConfigClientAsyncWaiter(const CustomProxyConfigClientAsyncWaiter&) = delete;
  CustomProxyConfigClientAsyncWaiter& operator=(const CustomProxyConfigClientAsyncWaiter&) = delete;

  ~CustomProxyConfigClientAsyncWaiter();
  void OnCustomProxyConfigUpdated(
      CustomProxyConfigPtr proxy_config);
  

 private:
  CustomProxyConfigClient* const proxy_;
};


class  TrustedHeaderClientInterceptorForTesting : public TrustedHeaderClient {
  virtual TrustedHeaderClient* GetForwardingInterface() = 0;
  void OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) override;
  void OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) override;
};
class  TrustedHeaderClientAsyncWaiter {
 public:
  explicit TrustedHeaderClientAsyncWaiter(TrustedHeaderClient* proxy);

  TrustedHeaderClientAsyncWaiter(const TrustedHeaderClientAsyncWaiter&) = delete;
  TrustedHeaderClientAsyncWaiter& operator=(const TrustedHeaderClientAsyncWaiter&) = delete;

  ~TrustedHeaderClientAsyncWaiter();
  void OnBeforeSendHeaders(
      const ::net::HttpRequestHeaders& headers, int32_t* out_result, std::optional<::net::HttpRequestHeaders>* out_headers);
  
  void OnHeadersReceived(
      const std::string& headers, const ::net::IPEndPoint& remote_endpoint, int32_t* out_result, std::optional<std::string>* out_headers, std::optional<::GURL>* out_preserve_fragment_on_redirect_url);
  

 private:
  TrustedHeaderClient* const proxy_;
};


class  TrustedURLLoaderHeaderClientInterceptorForTesting : public TrustedURLLoaderHeaderClient {
  virtual TrustedURLLoaderHeaderClient* GetForwardingInterface() = 0;
  void OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) override;
  void OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) override;
};
class  TrustedURLLoaderHeaderClientAsyncWaiter {
 public:
  explicit TrustedURLLoaderHeaderClientAsyncWaiter(TrustedURLLoaderHeaderClient* proxy);

  TrustedURLLoaderHeaderClientAsyncWaiter(const TrustedURLLoaderHeaderClientAsyncWaiter&) = delete;
  TrustedURLLoaderHeaderClientAsyncWaiter& operator=(const TrustedURLLoaderHeaderClientAsyncWaiter&) = delete;

  ~TrustedURLLoaderHeaderClientAsyncWaiter();

 private:
  TrustedURLLoaderHeaderClient* const proxy_;
};


class  PreloadedSharedDictionaryInfoHandleInterceptorForTesting : public PreloadedSharedDictionaryInfoHandle {
  virtual PreloadedSharedDictionaryInfoHandle* GetForwardingInterface() = 0;
};
class  PreloadedSharedDictionaryInfoHandleAsyncWaiter {
 public:
  explicit PreloadedSharedDictionaryInfoHandleAsyncWaiter(PreloadedSharedDictionaryInfoHandle* proxy);

  PreloadedSharedDictionaryInfoHandleAsyncWaiter(const PreloadedSharedDictionaryInfoHandleAsyncWaiter&) = delete;
  PreloadedSharedDictionaryInfoHandleAsyncWaiter& operator=(const PreloadedSharedDictionaryInfoHandleAsyncWaiter&) = delete;

  ~PreloadedSharedDictionaryInfoHandleAsyncWaiter();

 private:
  PreloadedSharedDictionaryInfoHandle* const proxy_;
};


class  DurableMessageCollectorInterceptorForTesting : public DurableMessageCollector {
  virtual DurableMessageCollector* GetForwardingInterface() = 0;
  void Configure(NetworkDurableMessageConfigPtr config) override;
  void Retrieve(const std::string& devtools_request_id, RetrieveCallback callback) override;
};
class  DurableMessageCollectorAsyncWaiter {
 public:
  explicit DurableMessageCollectorAsyncWaiter(DurableMessageCollector* proxy);

  DurableMessageCollectorAsyncWaiter(const DurableMessageCollectorAsyncWaiter&) = delete;
  DurableMessageCollectorAsyncWaiter& operator=(const DurableMessageCollectorAsyncWaiter&) = delete;

  ~DurableMessageCollectorAsyncWaiter();
  void Retrieve(
      const std::string& devtools_request_id, std::optional<::mojo_base::BigBuffer>* out_message);
  std::optional<::mojo_base::BigBuffer> Retrieve(const std::string& devtools_request_id);

 private:
  DurableMessageCollector* const proxy_;
};


class  NetworkContextInterceptorForTesting : public NetworkContext {
  virtual NetworkContext* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingRemote<::network::mojom::NetworkContextClient> client) override;
  void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) override;
  void ResetURLLoaderFactories() override;
  void GetViaObliviousHttp(::network::mojom::ObliviousHttpRequestPtr request, ::mojo::PendingRemote<::network::mojom::ObliviousHttpClient> client) override;
  void GetCookieManager(::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager) override;
  void GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole role, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const ::net::CookieSettingOverrides& cookie_setting_overrides, const ::net::CookieSettingOverrides& devtools_cookie_setting_overrides, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer) override;
  void GetTrustTokenQueryAnswerer(::mojo::PendingReceiver<::network::mojom::TrustTokenQueryAnswerer> trust_token_query_answerer, const ::url::Origin& top_frame_origin) override;
  void ClearTrustTokenData(::network::mojom::ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) override;
  void ClearTrustTokenSessionOnlyData(ClearTrustTokenSessionOnlyDataCallback callback) override;
  void GetStoredTrustTokenCounts(GetStoredTrustTokenCountsCallback callback) override;
  void GetPrivateStateTokenRedemptionRecords(GetPrivateStateTokenRedemptionRecordsCallback callback) override;
  void GetIpProxyStatus(GetIpProxyStatusCallback callback) override;
  void SetBypassIpProtectionProxy(bool bypass_proxy) override;
  void DeleteStoredTrustTokens(const ::url::Origin& issuer, DeleteStoredTrustTokensCallback callback) override;
  void SetBlockTrustTokens(bool block) override;
  void SetTrackingProtectionContentSetting(const std::vector<::ContentSettingPatternSource>& settings) override;
  void ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) override;
  void ClearHttpCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearHttpCacheCallback callback) override;
  void ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) override;
  void NotifyBrowserIdle() override;
  void NotifyExternalCacheHit(const ::GURL& url, const std::string& http_method, const ::net::NetworkIsolationKey& key, bool include_credentials) override;
  void ClearHostCache(::network::mojom::ClearDataFilterPtr filter, ClearHostCacheCallback callback) override;
  void ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearHttpAuthCacheCallback callback) override;
  void ClearCorsPreflightCache(::network::mojom::ClearDataFilterPtr filter, ClearCorsPreflightCacheCallback callback) override;
  void ClearReportingCacheReports(::network::mojom::ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) override;
  void ClearReportingCacheClients(::network::mojom::ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) override;
  void ClearNetworkErrorLogging(::network::mojom::ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) override;
  void ClearDomainReliability(::network::mojom::ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) override;
  void ClearSharedDictionaryCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter, ClearSharedDictionaryCacheCallback callback) override;
  void ClearSharedDictionaryCacheForIsolationKey(const ::net::SharedDictionaryIsolationKey& isolation_key, ClearSharedDictionaryCacheForIsolationKeyCallback callback) override;
  void SetDocumentReportingEndpoints(const ::base::UnguessableToken& reporting_source, const ::url::Origin& origin, const ::net::IsolationInfo& isolation_info, const base::flat_map<std::string, std::string>& endpoints) override;
  void SetEnterpriseReportingEndpoints(const base::flat_map<std::string, ::GURL>& endpoints) override;
  void SendReportsAndRemoveSource(const ::base::UnguessableToken& reporting_source) override;
  void QueueReport(const std::string& type, const std::string& group, const ::GURL& url, const std::optional<::base::UnguessableToken>& reporting_source, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::base::Value::Dict body) override;
  void QueueEnterpriseReport(const std::string& type, const std::string& group, const ::GURL& url, ::base::Value::Dict body) override;
  void QueueSignedExchangeReport(SignedExchangeReportPtr report, const ::net::NetworkAnonymizationKey& network_anonymization_key) override;
  void CloseAllConnections(CloseAllConnectionsCallback callback) override;
  void CloseIdleConnections(CloseIdleConnectionsCallback callback) override;
  void SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, std::vector<MatchedNetworkConditionsPtr> conditions) override;
  void EnableDurableMessageCollector(const ::base::UnguessableToken& throttling_profile_id, ::mojo::PendingReceiver<DurableMessageCollector> receiver) override;
  void SetAcceptLanguage(const std::string& new_accept_language) override;
  void SetEnableReferrers(bool enable_referrers) override;
  void SetCTPolicy(CTPolicyPtr ct_policy) override;
  void CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener) override;
  void CreateRestrictedUDPSocket(const ::net::IPEndPoint& addr, ::network::mojom::RestrictedUDPSocketMode mode, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::RestrictedUDPSocketParamsPtr params, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, bool allow_multicast, CreateRestrictedUDPSocketCallback callback) override;
  void CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, ::network::mojom::TCPServerSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) override;
  void CreateTCPConnectedSocket(const std::optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) override;
  void CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) override;
  void CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> factory) override;
  void LookUpProxyForURL(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> proxy_lookup_client) override;
  void ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) override;
  void ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) override;
  void CreateWebSocket(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, ::net::StorageAccessApiStatus storage_access_api_status, const ::net::IsolationInfo& isolation_info, std::vector<::network::mojom::HttpHeaderPtr> additional_headers, int32_t process_id, const ::url::Origin& origin, ::network::mojom::ClientSecurityStatePtr client_security_state, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::mojo::PendingRemote<::network::mojom::WebSocketAuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client, const std::optional<::base::UnguessableToken>& throttling_profile_id) override;
  void CreateWebTransport(const ::GURL& url, const ::url::Origin& origin, const ::net::NetworkAnonymizationKey& network_anonymization_key, std::vector<::network::mojom::WebTransportCertificateFingerprintPtr> fingerprints, const std::vector<std::string>& application_protocols, ::mojo::PendingRemote<::network::mojom::WebTransportHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::network::mojom::ClientSecurityStatePtr client_security_state) override;
  void CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::NetLogExporter> receiver) override;
  void PreconnectSockets(uint32_t num_streams, const ::GURL& url, ::network::mojom::CredentialsMode credentials_mode, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::net::ConnectionKeepAliveConfig>& keepalive_config, ::mojo::PendingRemote<::network::mojom::ConnectionChangeObserverClient> observer_client) override;
  void CreateP2PSocketManager(const ::net::NetworkAnonymizationKey& network_anonymization_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> socket_manager) override;
  void CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::MdnsResponder> responder_receiver) override;
  void ResolveHost(::network::mojom::HostResolverHostPtr host, const ::net::NetworkAnonymizationKey& network_anonymization_key, ::network::mojom::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> response_client) override;
  void CreateHostResolver(const std::optional<::net::DnsConfigOverrides>& config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> host_resolver) override;
  void VerifyCert(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, VerifyCertCallback callback) override;
  void VerifyCertForSignedExchange(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, VerifyCertForSignedExchangeCallback callback) override;
  void Verify2QwacCertBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, Verify2QwacCertBindingCallback callback) override;
  void AddHSTS(const std::string& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) override;
  void IsHSTSActiveForHost(const std::string& host, bool is_top_level_nav, IsHSTSActiveForHostCallback callback) override;
  void GetHSTSState(const std::string& domain, GetHSTSStateCallback callback) override;
  void SetCorsOriginAccessListsForOrigin(const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) override;
  void DeleteDynamicDataForHost(const std::string& host, DeleteDynamicDataForHostCallback callback) override;
  void SetSplitAuthCacheByNetworkAnonymizationKey(bool split_auth_cache_by_network_anonymization_key) override;
  void SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) override;
  void LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) override;
  void AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::AuthCredentials& credentials, AddAuthCacheEntryCallback callback) override;
  void SetCorsNonWildcardRequestHeadersSupport(bool value) override;
  void EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) override;
  void VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, VerifyCertificateForTestingCallback callback) override;
  void GetTrustAnchorIDsForTesting(GetTrustAnchorIDsForTestingCallback callback) override;
  void AddDomainReliabilityContextForTesting(const ::url::Origin& origin, const ::GURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) override;
  void ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) override;
  void SetSCTAuditingMode(SCTAuditingMode mode) override;
  void AddReportingApiObserver(::mojo::PendingRemote<::network::mojom::ReportingApiObserver> observer) override;
  void GetSharedDictionaryUsageInfo(GetSharedDictionaryUsageInfoCallback callback) override;
  void GetSharedDictionaryInfo(const ::net::SharedDictionaryIsolationKey& isolation_key, GetSharedDictionaryInfoCallback callback) override;
  void GetSharedDictionaryOriginsBetween(::base::Time start_time, ::base::Time end_time, GetSharedDictionaryOriginsBetweenCallback callback) override;
  void SetSharedDictionaryCacheMaxSize(uint64_t cache_max_size) override;
  void PreloadSharedDictionaryInfoForDocument(const std::vector<::GURL>& urls, ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle> preload_handle) override;
  void HasPreloadedSharedDictionaryInfoForTesting(HasPreloadedSharedDictionaryInfoForTestingCallback callback) override;
  void FlushCachedClientCertIfNeeded(const ::net::HostPortPair& host, const ::scoped_refptr<::net::X509Certificate>& certificate) override;
  void FlushMatchingCachedClientCert(const ::scoped_refptr<::net::X509Certificate>& certificate) override;
  void SetCookieDeprecationLabel(const std::optional<std::string>& label) override;
  void RevokeNetworkForNonces(const std::vector<::base::UnguessableToken>& nonces, RevokeNetworkForNoncesCallback callback) override;
  void ClearNonces(const std::vector<::base::UnguessableToken>& nonces) override;
  void ExemptUrlFromNetworkRevocationForNonce(const ::GURL& exempted_url, const ::base::UnguessableToken& nonce, ExemptUrlFromNetworkRevocationForNonceCallback callback) override;
  void Prefetch(int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) override;
  void GetBoundNetworkForTesting(GetBoundNetworkForTestingCallback callback) override;
  void GetDeviceBoundSessionManager(::mojo::PendingReceiver<::network::mojom::DeviceBoundSessionManager> device_bound_session_manager) override;
  void AddQuicHints(const std::vector<::url::SchemeHostPort>& origins, const ::net::NetworkAnonymizationKey& network_anonymization_key) override;
};
class  NetworkContextAsyncWaiter {
 public:
  explicit NetworkContextAsyncWaiter(NetworkContext* proxy);

  NetworkContextAsyncWaiter(const NetworkContextAsyncWaiter&) = delete;
  NetworkContextAsyncWaiter& operator=(const NetworkContextAsyncWaiter&) = delete;

  ~NetworkContextAsyncWaiter();
  void ClearTrustTokenData(
      ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearTrustTokenSessionOnlyData(
      bool* out_any_data_deleted);
  bool ClearTrustTokenSessionOnlyData();
  void GetStoredTrustTokenCounts(
      std::vector<::network::mojom::StoredTrustTokensForIssuerPtr>* out_tokens);
  std::vector<::network::mojom::StoredTrustTokensForIssuerPtr> GetStoredTrustTokenCounts();
  void GetPrivateStateTokenRedemptionRecords(
      base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>>* out_issuer_redemption_record_map);
  base::flat_map<::url::Origin, std::vector<::network::mojom::ToplevelRedemptionRecordPtr>> GetPrivateStateTokenRedemptionRecords();
  void GetIpProxyStatus(
      ::ip_protection::IpProxyStatus* out_status);
  ::ip_protection::IpProxyStatus GetIpProxyStatus();
  void DeleteStoredTrustTokens(
      const ::url::Origin& issuer, ::network::mojom::DeleteStoredTrustTokensStatus* out_status);
  ::network::mojom::DeleteStoredTrustTokensStatus DeleteStoredTrustTokens(const ::url::Origin& issuer);
  void ClearNetworkingHistoryBetween(
      ::base::Time start_time, ::base::Time end_time);
  
  void ClearHttpCache(
      ::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter);
  
  void ComputeHttpCacheSize(
      ::base::Time start_time, ::base::Time end_time, bool* out_is_upper_bound, int64_t* out_size_or_error);
  
  void ClearHostCache(
      ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearHttpAuthCache(
      ::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearCorsPreflightCache(
      ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearReportingCacheReports(
      ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearReportingCacheClients(
      ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearNetworkErrorLogging(
      ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearDomainReliability(
      ::network::mojom::ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode);
  
  void ClearSharedDictionaryCache(
      ::base::Time start_time, ::base::Time end_time, ::network::mojom::ClearDataFilterPtr filter);
  
  void ClearSharedDictionaryCacheForIsolationKey(
      const ::net::SharedDictionaryIsolationKey& isolation_key);
  
  void CloseAllConnections(
      );
  
  void CloseIdleConnections(
      );
  
  void CreateRestrictedUDPSocket(
      const ::net::IPEndPoint& addr, ::network::mojom::RestrictedUDPSocketMode mode, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::RestrictedUDPSocketParamsPtr params, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, bool allow_multicast, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out);
  
  void CreateTCPServerSocket(
      const ::net::IPEndPoint& local_addr, ::network::mojom::TCPServerSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out);
  
  void CreateTCPConnectedSocket(
      const std::optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream);
  
  void CreateTCPBoundSocket(
      const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr);
  
  void ForceReloadProxyConfig(
      );
  
  void ClearBadProxiesCache(
      );
  
  void VerifyCert(
      const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code, ::net::CertVerifyResult* out_cv_result, bool* out_pkp_bypassed);
  
  void VerifyCertForSignedExchange(
      const ::scoped_refptr<::net::X509Certificate>& certificate, const ::net::HostPortPair& host_port, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code, ::net::CertVerifyResult* out_cv_result, bool* out_pkp_bypassed);
  
  void Verify2QwacCertBinding(
      const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, ::scoped_refptr<::net::X509Certificate>* out_verified_cert);
  ::scoped_refptr<::net::X509Certificate> Verify2QwacCertBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate);
  void AddHSTS(
      const std::string& host, ::base::Time expiry, bool include_subdomains);
  
  void IsHSTSActiveForHost(
      const std::string& host, bool is_top_level_nav, bool* out_result);
  bool IsHSTSActiveForHost(const std::string& host, bool is_top_level_nav);
  void GetHSTSState(
      const std::string& domain, ::base::Value::Dict* out_state);
  ::base::Value::Dict GetHSTSState(const std::string& domain);
  void SetCorsOriginAccessListsForOrigin(
      const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns);
  
  void DeleteDynamicDataForHost(
      const std::string& host, bool* out_result);
  bool DeleteDynamicDataForHost(const std::string& host);
  void SaveHttpAuthCacheProxyEntries(
      ::base::UnguessableToken* out_cache_key);
  ::base::UnguessableToken SaveHttpAuthCacheProxyEntries();
  void LoadHttpAuthCacheProxyEntries(
      const ::base::UnguessableToken& cache_key);
  
  void AddAuthCacheEntry(
      const ::net::AuthChallengeInfo& challenge, const ::net::NetworkAnonymizationKey& network_anonymization_key, const ::net::AuthCredentials& credentials);
  
  void EnableStaticKeyPinningForTesting(
      );
  
  void VerifyCertificateForTesting(
      const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code);
  int32_t VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list);
  void GetTrustAnchorIDsForTesting(
      std::vector<std::vector<uint8_t>>* out_trust_anchor_ids);
  std::vector<std::vector<uint8_t>> GetTrustAnchorIDsForTesting();
  void AddDomainReliabilityContextForTesting(
      const ::url::Origin& origin, const ::GURL& upload_url);
  
  void ForceDomainReliabilityUploadsForTesting(
      );
  
  void GetSharedDictionaryUsageInfo(
      std::vector<::net::SharedDictionaryUsageInfo>* out_usage_info);
  std::vector<::net::SharedDictionaryUsageInfo> GetSharedDictionaryUsageInfo();
  void GetSharedDictionaryInfo(
      const ::net::SharedDictionaryIsolationKey& isolation_key, std::vector<SharedDictionaryInfoPtr>* out_dictionaries);
  std::vector<SharedDictionaryInfoPtr> GetSharedDictionaryInfo(const ::net::SharedDictionaryIsolationKey& isolation_key);
  void GetSharedDictionaryOriginsBetween(
      ::base::Time start_time, ::base::Time end_time, std::vector<::url::Origin>* out_origins);
  std::vector<::url::Origin> GetSharedDictionaryOriginsBetween(::base::Time start_time, ::base::Time end_time);
  void HasPreloadedSharedDictionaryInfoForTesting(
      bool* out_value);
  bool HasPreloadedSharedDictionaryInfoForTesting();
  void RevokeNetworkForNonces(
      const std::vector<::base::UnguessableToken>& nonces);
  
  void ExemptUrlFromNetworkRevocationForNonce(
      const ::GURL& exempted_url, const ::base::UnguessableToken& nonce);
  
  void GetBoundNetworkForTesting(
      int64_t* out_bound_network);
  int64_t GetBoundNetworkForTesting();

 private:
  NetworkContext* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_TEST_UTILS_H_