// services/network/public/mojom/network_context.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/network_context.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "components/ip_protection/mojom/core.mojom-shared.h"
#include "components/ip_protection/mojom/data_types.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/connection_change_observer_client.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_encryption_provider.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/default_credentials.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-shared.h"
#include "services/network/public/mojom/hash_value.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/mdns_responder.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/net_log.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_context_client.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/oblivious_http_request.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom-shared.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-shared.h"
#include "services/network/public/mojom/reporting_service.mojom-shared.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/socket_broker.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"
#include "services/network/public/mojom/transferable_directory.mojom-shared.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/udp_socket.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_transport.mojom-shared.h"
#include "services/network/public/mojom/websocket.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/p2p.mojom-shared.h"
#include "services/network/public/mojom/p2p_trusted.mojom-shared.h"

#include "services/network/public/mojom/network_context.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::TrustTokenOperationPolicyVerdict, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SCTAuditingMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CustomProxyConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CustomProxyConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CustomProxyConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::rules(input)) in_rules = Traits::rules(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rules)::BaseType> rules_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyRulesDataView, send_validation>(
        in_rules,
        rules_fragment);

      fragment->rules.Set(
          rules_fragment.is_null() ? nullptr : rules_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rules.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rules in CustomProxyConfig struct");

      fragment->should_override_existing_config = Traits::should_override_existing_config(input);

      fragment->allow_non_idempotent_methods = Traits::allow_non_idempotent_methods(input);

      decltype(Traits::connect_tunnel_headers(input)) in_connect_tunnel_headers = Traits::connect_tunnel_headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->connect_tunnel_headers)::BaseType> connect_tunnel_headers_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView, send_validation>(
        in_connect_tunnel_headers,
        connect_tunnel_headers_fragment);

      fragment->connect_tunnel_headers.Set(
          connect_tunnel_headers_fragment.is_null() ? nullptr : connect_tunnel_headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->connect_tunnel_headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connect_tunnel_headers in CustomProxyConfig struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CertVerifierServiceRemoteParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CertVerifierServiceRemoteParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CertVerifierServiceRemoteParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cert_verifier_service(input)) in_cert_verifier_service = Traits::cert_verifier_service(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierServiceInterfaceBase>>(
        in_cert_verifier_service,
        &fragment->cert_verifier_service,
        &fragment.message());

      decltype(Traits::cert_verifier_service_client_receiver(input)) in_cert_verifier_service_client_receiver = Traits::cert_verifier_service_client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceClientInterfaceBase>>(
        in_cert_verifier_service_client_receiver,
        &fragment->cert_verifier_service_client_receiver,
        &fragment.message());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::HttpAuthStaticNetworkContextParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpAuthStaticNetworkContextParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpAuthStaticNetworkContextParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::DefaultCredentials>(
        Traits::allow_default_credentials(input),
        &fragment->allow_default_credentials);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CTPolicyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CTPolicyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CTPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::excluded_hosts(input)) in_excluded_hosts = Traits::excluded_hosts(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->excluded_hosts)::BaseType>
          excluded_hosts_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& excluded_hosts_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_excluded_hosts,
        excluded_hosts_fragment,
        &excluded_hosts_validate_params);

      fragment->excluded_hosts.Set(
          excluded_hosts_fragment.is_null() ? nullptr : excluded_hosts_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->excluded_hosts.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null excluded_hosts in CTPolicy struct");

      decltype(Traits::excluded_spkis(input)) in_excluded_spkis = Traits::excluded_spkis(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->excluded_spkis)::BaseType>
          excluded_spkis_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& excluded_spkis_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_excluded_spkis,
        excluded_spkis_fragment,
        &excluded_spkis_validate_params);

      fragment->excluded_spkis.Set(
          excluded_spkis_fragment.is_null() ? nullptr : excluded_spkis_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->excluded_spkis.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null excluded_spkis in CTPolicy struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkContextFilePathsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkContextFilePathsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkContextFilePaths_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::shared_dictionary_directory(input)) in_shared_dictionary_directory = Traits::shared_dictionary_directory(input);
      mojo::internal::MessageFragment<decltype(fragment->shared_dictionary_directory)>
          shared_dictionary_directory_fragment(fragment.message());
      shared_dictionary_directory_fragment.Claim(&fragment->shared_dictionary_directory);
      
      mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView, send_validation>(
        in_shared_dictionary_directory,
        shared_dictionary_directory_fragment,
        true);

      decltype(Traits::http_cache_directory(input)) in_http_cache_directory = Traits::http_cache_directory(input);
      mojo::internal::MessageFragment<decltype(fragment->http_cache_directory)>
          http_cache_directory_fragment(fragment.message());
      http_cache_directory_fragment.Claim(&fragment->http_cache_directory);
      
      mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView, send_validation>(
        in_http_cache_directory,
        http_cache_directory_fragment,
        true);

      decltype(Traits::no_vary_search_directory(input)) in_no_vary_search_directory = Traits::no_vary_search_directory(input);
      mojo::internal::MessageFragment<decltype(fragment->no_vary_search_directory)>
          no_vary_search_directory_fragment(fragment.message());
      no_vary_search_directory_fragment.Claim(&fragment->no_vary_search_directory);
      
      mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView, send_validation>(
        in_no_vary_search_directory,
        no_vary_search_directory_fragment,
        true);

      decltype(Traits::data_directory(input)) in_data_directory = Traits::data_directory(input);
      mojo::internal::MessageFragment<decltype(fragment->data_directory)>
          data_directory_fragment(fragment.message());
      data_directory_fragment.Claim(&fragment->data_directory);
      
      mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView, send_validation>(
        in_data_directory,
        data_directory_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->data_directory.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_directory in NetworkContextFilePaths struct");

      decltype(Traits::unsandboxed_data_path(input)) in_unsandboxed_data_path = Traits::unsandboxed_data_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->unsandboxed_data_path)::BaseType> unsandboxed_data_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_unsandboxed_data_path,
        unsandboxed_data_path_fragment);

      fragment->unsandboxed_data_path.Set(
          unsandboxed_data_path_fragment.is_null() ? nullptr : unsandboxed_data_path_fragment.data());

      decltype(Traits::cookie_database_name(input)) in_cookie_database_name = Traits::cookie_database_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_database_name)::BaseType> cookie_database_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_cookie_database_name,
        cookie_database_name_fragment);

      fragment->cookie_database_name.Set(
          cookie_database_name_fragment.is_null() ? nullptr : cookie_database_name_fragment.data());

      decltype(Traits::device_bound_sessions_database_name(input)) in_device_bound_sessions_database_name = Traits::device_bound_sessions_database_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_bound_sessions_database_name)::BaseType> device_bound_sessions_database_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_device_bound_sessions_database_name,
        device_bound_sessions_database_name_fragment);

      fragment->device_bound_sessions_database_name.Set(
          device_bound_sessions_database_name_fragment.is_null() ? nullptr : device_bound_sessions_database_name_fragment.data());

      decltype(Traits::trust_token_database_name(input)) in_trust_token_database_name = Traits::trust_token_database_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_token_database_name)::BaseType> trust_token_database_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_trust_token_database_name,
        trust_token_database_name_fragment);

      fragment->trust_token_database_name.Set(
          trust_token_database_name_fragment.is_null() ? nullptr : trust_token_database_name_fragment.data());

      decltype(Traits::http_server_properties_file_name(input)) in_http_server_properties_file_name = Traits::http_server_properties_file_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->http_server_properties_file_name)::BaseType> http_server_properties_file_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_http_server_properties_file_name,
        http_server_properties_file_name_fragment);

      fragment->http_server_properties_file_name.Set(
          http_server_properties_file_name_fragment.is_null() ? nullptr : http_server_properties_file_name_fragment.data());

      decltype(Traits::transport_security_persister_file_name(input)) in_transport_security_persister_file_name = Traits::transport_security_persister_file_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transport_security_persister_file_name)::BaseType> transport_security_persister_file_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_transport_security_persister_file_name,
        transport_security_persister_file_name_fragment);

      fragment->transport_security_persister_file_name.Set(
          transport_security_persister_file_name_fragment.is_null() ? nullptr : transport_security_persister_file_name_fragment.data());

      decltype(Traits::reporting_and_nel_store_database_name(input)) in_reporting_and_nel_store_database_name = Traits::reporting_and_nel_store_database_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_and_nel_store_database_name)::BaseType> reporting_and_nel_store_database_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_reporting_and_nel_store_database_name,
        reporting_and_nel_store_database_name_fragment);

      fragment->reporting_and_nel_store_database_name.Set(
          reporting_and_nel_store_database_name_fragment.is_null() ? nullptr : reporting_and_nel_store_database_name_fragment.data());

      decltype(Traits::sct_auditing_pending_reports_file_name(input)) in_sct_auditing_pending_reports_file_name = Traits::sct_auditing_pending_reports_file_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sct_auditing_pending_reports_file_name)::BaseType> sct_auditing_pending_reports_file_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_sct_auditing_pending_reports_file_name,
        sct_auditing_pending_reports_file_name_fragment);

      fragment->sct_auditing_pending_reports_file_name.Set(
          sct_auditing_pending_reports_file_name_fragment.is_null() ? nullptr : sct_auditing_pending_reports_file_name_fragment.data());

      fragment->trigger_migration = Traits::trigger_migration(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkContextParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkContextParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkContextParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::user_agent(input)) in_user_agent = Traits::user_agent(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_agent)::BaseType> user_agent_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_user_agent,
        user_agent_fragment);

      fragment->user_agent.Set(
          user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_agent.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_agent in NetworkContextParams struct");

      decltype(Traits::accept_language(input)) in_accept_language = Traits::accept_language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accept_language)::BaseType> accept_language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_accept_language,
        accept_language_fragment);

      fragment->accept_language.Set(
          accept_language_fragment.is_null() ? nullptr : accept_language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accept_language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept_language in NetworkContextParams struct");

      fragment->enable_brotli = Traits::enable_brotli(input);

      fragment->enable_zstd = Traits::enable_zstd(input);

      fragment->enable_referrers = Traits::enable_referrers(input);

      fragment->validate_referrer_policy_on_initial_request = Traits::validate_referrer_policy_on_initial_request(input);

      decltype(Traits::proxy_resolver_factory(input)) in_proxy_resolver_factory = Traits::proxy_resolver_factory(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverFactoryInterfaceBase>>(
        in_proxy_resolver_factory,
        &fragment->proxy_resolver_factory,
        &fragment.message());

      fragment->enable_encrypted_cookies = Traits::enable_encrypted_cookies(input);

      fragment->restore_old_session_cookies = Traits::restore_old_session_cookies(input);

      fragment->persist_session_cookies = Traits::persist_session_cookies(input);

      fragment->http_cache_enabled = Traits::http_cache_enabled(input);

      fragment->http_cache_max_size = Traits::http_cache_max_size(input);

      decltype(Traits::http_cache_file_operations_factory(input)) in_http_cache_file_operations_factory = Traits::http_cache_file_operations_factory(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::HttpCacheBackendFileOperationsFactoryInterfaceBase>>(
        in_http_cache_file_operations_factory,
        &fragment->http_cache_file_operations_factory,
        &fragment.message());

      fragment->disable_idle_sockets_close_on_memory_pressure = Traits::disable_idle_sockets_close_on_memory_pressure(input);

      decltype(Traits::initial_ssl_config(input)) in_initial_ssl_config = Traits::initial_ssl_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_ssl_config)::BaseType> initial_ssl_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SSLConfigDataView, send_validation>(
        in_initial_ssl_config,
        initial_ssl_config_fragment);

      fragment->initial_ssl_config.Set(
          initial_ssl_config_fragment.is_null() ? nullptr : initial_ssl_config_fragment.data());

      decltype(Traits::ssl_config_client_receiver(input)) in_ssl_config_client_receiver = Traits::ssl_config_client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::SSLConfigClientInterfaceBase>>(
        in_ssl_config_client_receiver,
        &fragment->ssl_config_client_receiver,
        &fragment.message());

      decltype(Traits::initial_proxy_config(input)) in_initial_proxy_config = Traits::initial_proxy_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_proxy_config)::BaseType> initial_proxy_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyConfigWithAnnotationDataView, send_validation>(
        in_initial_proxy_config,
        initial_proxy_config_fragment);

      fragment->initial_proxy_config.Set(
          initial_proxy_config_fragment.is_null() ? nullptr : initial_proxy_config_fragment.data());

      decltype(Traits::proxy_config_client_receiver(input)) in_proxy_config_client_receiver = Traits::proxy_config_client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyConfigClientInterfaceBase>>(
        in_proxy_config_client_receiver,
        &fragment->proxy_config_client_receiver,
        &fragment.message());

      decltype(Traits::initial_custom_proxy_config(input)) in_initial_custom_proxy_config = Traits::initial_custom_proxy_config(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_custom_proxy_config)::BaseType> initial_custom_proxy_config_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CustomProxyConfigDataView, send_validation>(
        in_initial_custom_proxy_config,
        initial_custom_proxy_config_fragment);

      fragment->initial_custom_proxy_config.Set(
          initial_custom_proxy_config_fragment.is_null() ? nullptr : initial_custom_proxy_config_fragment.data());

      decltype(Traits::custom_proxy_config_client_receiver(input)) in_custom_proxy_config_client_receiver = Traits::custom_proxy_config_client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CustomProxyConfigClientInterfaceBase>>(
        in_custom_proxy_config_client_receiver,
        &fragment->custom_proxy_config_client_receiver,
        &fragment.message());

      decltype(Traits::custom_proxy_connection_observer_remote(input)) in_custom_proxy_connection_observer_remote = Traits::custom_proxy_connection_observer_remote(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CustomProxyConnectionObserverInterfaceBase>>(
        in_custom_proxy_connection_observer_remote,
        &fragment->custom_proxy_connection_observer_remote,
        &fragment.message());

      decltype(Traits::proxy_config_poller_client(input)) in_proxy_config_poller_client = Traits::proxy_config_poller_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ProxyConfigPollerClientInterfaceBase>>(
        in_proxy_config_poller_client,
        &fragment->proxy_config_poller_client,
        &fragment.message());

      decltype(Traits::proxy_error_client(input)) in_proxy_error_client = Traits::proxy_error_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ProxyErrorClientInterfaceBase>>(
        in_proxy_error_client,
        &fragment->proxy_error_client,
        &fragment.message());

      decltype(Traits::ip_protection_core_host(input)) in_ip_protection_core_host = Traits::ip_protection_core_host(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::ip_protection::mojom::CoreHostInterfaceBase>>(
        in_ip_protection_core_host,
        &fragment->ip_protection_core_host,
        &fragment.message());

      decltype(Traits::ip_protection_control(input)) in_ip_protection_control = Traits::ip_protection_control(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::ip_protection::mojom::CoreControlInterfaceBase>>(
        in_ip_protection_control,
        &fragment->ip_protection_control,
        &fragment.message());

      fragment->enable_ip_protection = Traits::enable_ip_protection(input);

      fragment->ip_protection_incognito = Traits::ip_protection_incognito(input);

      decltype(Traits::initial_ip_protection_tokens(input)) in_initial_ip_protection_tokens = Traits::initial_ip_protection_tokens(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_ip_protection_tokens)::BaseType>
          initial_ip_protection_tokens_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& initial_ip_protection_tokens_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ip_protection::mojom::internal::ProxyLayer_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::ip_protection::mojom::ProxyLayer, mojo::ArrayDataView<::ip_protection::mojom::BlindSignedAuthTokenDataView>>, send_validation>(
        in_initial_ip_protection_tokens,
        initial_ip_protection_tokens_fragment,
        &initial_ip_protection_tokens_validate_params);

      fragment->initial_ip_protection_tokens.Set(
          initial_ip_protection_tokens_fragment.is_null() ? nullptr : initial_ip_protection_tokens_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->initial_ip_protection_tokens.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initial_ip_protection_tokens in NetworkContextParams struct");

      decltype(Traits::ip_protection_data_directory(input)) in_ip_protection_data_directory = Traits::ip_protection_data_directory(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ip_protection_data_directory)::BaseType> ip_protection_data_directory_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_ip_protection_data_directory,
        ip_protection_data_directory_fragment);

      fragment->ip_protection_data_directory.Set(
          ip_protection_data_directory_fragment.is_null() ? nullptr : ip_protection_data_directory_fragment.data());

      fragment->pac_quick_check_enabled = Traits::pac_quick_check_enabled(input);

      fragment->enable_certificate_reporting = Traits::enable_certificate_reporting(input);

      fragment->enforce_chrome_ct_policy = Traits::enforce_chrome_ct_policy(input);

      
      mojo::internal::Serialize<::network::mojom::SCTAuditingMode>(
        Traits::sct_auditing_mode(input),
        &fragment->sct_auditing_mode);

      decltype(Traits::ct_policy(input)) in_ct_policy = Traits::ct_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ct_policy)::BaseType> ct_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CTPolicyDataView, send_validation>(
        in_ct_policy,
        ct_policy_fragment);

      fragment->ct_policy.Set(
          ct_policy_fragment.is_null() ? nullptr : ct_policy_fragment.data());

      decltype(Traits::cert_verifier_params(input)) in_cert_verifier_params = Traits::cert_verifier_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cert_verifier_params)::BaseType> cert_verifier_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CertVerifierServiceRemoteParamsDataView, send_validation>(
        in_cert_verifier_params,
        cert_verifier_params_fragment);

      fragment->cert_verifier_params.Set(
          cert_verifier_params_fragment.is_null() ? nullptr : cert_verifier_params_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cert_verifier_params.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert_verifier_params in NetworkContextParams struct");

      decltype(Traits::cookie_manager_params(input)) in_cookie_manager_params = Traits::cookie_manager_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_manager_params)::BaseType> cookie_manager_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieManagerParamsDataView, send_validation>(
        in_cookie_manager_params,
        cookie_manager_params_fragment);

      fragment->cookie_manager_params.Set(
          cookie_manager_params_fragment.is_null() ? nullptr : cookie_manager_params_fragment.data());

      fragment->enable_domain_reliability = Traits::enable_domain_reliability(input);

      decltype(Traits::domain_reliability_upload_reporter(input)) in_domain_reliability_upload_reporter = Traits::domain_reliability_upload_reporter(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain_reliability_upload_reporter)::BaseType> domain_reliability_upload_reporter_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain_reliability_upload_reporter,
        domain_reliability_upload_reporter_fragment);

      fragment->domain_reliability_upload_reporter.Set(
          domain_reliability_upload_reporter_fragment.is_null() ? nullptr : domain_reliability_upload_reporter_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain_reliability_upload_reporter.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain_reliability_upload_reporter in NetworkContextParams struct");

      fragment->discard_domain_reliablity_uploads = Traits::discard_domain_reliablity_uploads(input);

      decltype(Traits::reporting_delivery_interval(input)) in_reporting_delivery_interval = Traits::reporting_delivery_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_delivery_interval)::BaseType> reporting_delivery_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_reporting_delivery_interval,
        reporting_delivery_interval_fragment);

      fragment->reporting_delivery_interval.Set(
          reporting_delivery_interval_fragment.is_null() ? nullptr : reporting_delivery_interval_fragment.data());

      fragment->skip_reporting_send_permission_check = Traits::skip_reporting_send_permission_check(input);

      decltype(Traits::cors_origin_access_list(input)) in_cors_origin_access_list = Traits::cors_origin_access_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cors_origin_access_list)::BaseType>
          cors_origin_access_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cors_origin_access_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>, send_validation>(
        in_cors_origin_access_list,
        cors_origin_access_list_fragment,
        &cors_origin_access_list_validate_params);

      fragment->cors_origin_access_list.Set(
          cors_origin_access_list_fragment.is_null() ? nullptr : cors_origin_access_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cors_origin_access_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_origin_access_list in NetworkContextParams struct");

      decltype(Traits::cors_exempt_header_list(input)) in_cors_exempt_header_list = Traits::cors_exempt_header_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cors_exempt_header_list)::BaseType>
          cors_exempt_header_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cors_exempt_header_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_cors_exempt_header_list,
        cors_exempt_header_list_fragment,
        &cors_exempt_header_list_validate_params);

      fragment->cors_exempt_header_list.Set(
          cors_exempt_header_list_fragment.is_null() ? nullptr : cors_exempt_header_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cors_exempt_header_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_exempt_header_list in NetworkContextParams struct");

      fragment->allow_any_cors_exempt_header_for_browser = Traits::allow_any_cors_exempt_header_for_browser(input);

      decltype(Traits::hsts_policy_bypass_list(input)) in_hsts_policy_bypass_list = Traits::hsts_policy_bypass_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hsts_policy_bypass_list)::BaseType>
          hsts_policy_bypass_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& hsts_policy_bypass_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_hsts_policy_bypass_list,
        hsts_policy_bypass_list_fragment,
        &hsts_policy_bypass_list_validate_params);

      fragment->hsts_policy_bypass_list.Set(
          hsts_policy_bypass_list_fragment.is_null() ? nullptr : hsts_policy_bypass_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hsts_policy_bypass_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hsts_policy_bypass_list in NetworkContextParams struct");

      decltype(Traits::http_auth_static_network_context_params(input)) in_http_auth_static_network_context_params = Traits::http_auth_static_network_context_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->http_auth_static_network_context_params)::BaseType> http_auth_static_network_context_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::HttpAuthStaticNetworkContextParamsDataView, send_validation>(
        in_http_auth_static_network_context_params,
        http_auth_static_network_context_params_fragment);

      fragment->http_auth_static_network_context_params.Set(
          http_auth_static_network_context_params_fragment.is_null() ? nullptr : http_auth_static_network_context_params_fragment.data());

      fragment->reset_http_cache_backend = Traits::reset_http_cache_backend(input);

      fragment->split_auth_cache_by_network_anonymization_key = Traits::split_auth_cache_by_network_anonymization_key(input);

      fragment->require_network_anonymization_key = Traits::require_network_anonymization_key(input);

      decltype(Traits::file_paths(input)) in_file_paths = Traits::file_paths(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->file_paths)::BaseType> file_paths_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::NetworkContextFilePathsDataView, send_validation>(
        in_file_paths,
        file_paths_fragment);

      fragment->file_paths.Set(
          file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());

      fragment->block_trust_tokens = Traits::block_trust_tokens(input);

      fragment->shared_dictionary_enabled = Traits::shared_dictionary_enabled(input);

      fragment->shared_dictionary_cache_max_size = Traits::shared_dictionary_cache_max_size(input);

      decltype(Traits::first_party_sets_access_delegate_params(input)) in_first_party_sets_access_delegate_params = Traits::first_party_sets_access_delegate_params(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->first_party_sets_access_delegate_params)::BaseType> first_party_sets_access_delegate_params_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::FirstPartySetsAccessDelegateParamsDataView, send_validation>(
        in_first_party_sets_access_delegate_params,
        first_party_sets_access_delegate_params_fragment);

      fragment->first_party_sets_access_delegate_params.Set(
          first_party_sets_access_delegate_params_fragment.is_null() ? nullptr : first_party_sets_access_delegate_params_fragment.data());

      decltype(Traits::first_party_sets_access_delegate_receiver(input)) in_first_party_sets_access_delegate_receiver = Traits::first_party_sets_access_delegate_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::FirstPartySetsAccessDelegateInterfaceBase>>(
        in_first_party_sets_access_delegate_receiver,
        &fragment->first_party_sets_access_delegate_receiver,
        &fragment.message());

      fragment->acam_preflight_spec_conformant = Traits::acam_preflight_spec_conformant(input);

      decltype(Traits::cookie_deprecation_label(input)) in_cookie_deprecation_label = Traits::cookie_deprecation_label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_deprecation_label)::BaseType> cookie_deprecation_label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cookie_deprecation_label,
        cookie_deprecation_label_fragment);

      fragment->cookie_deprecation_label.Set(
          cookie_deprecation_label_fragment.is_null() ? nullptr : cookie_deprecation_label_fragment.data());

      decltype(Traits::cookie_encryption_provider(input)) in_cookie_encryption_provider = Traits::cookie_encryption_provider(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieEncryptionProviderInterfaceBase>>(
        in_cookie_encryption_provider,
        &fragment->cookie_encryption_provider,
        &fragment.message());

      fragment->device_bound_sessions_enabled = Traits::device_bound_sessions_enabled(input);

      fragment->bound_network = Traits::bound_network(input);

      decltype(Traits::enterprise_reporting_endpoints(input)) in_enterprise_reporting_endpoints = Traits::enterprise_reporting_endpoints(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->enterprise_reporting_endpoints)::BaseType>
          enterprise_reporting_endpoints_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& enterprise_reporting_endpoints_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>, send_validation>(
        in_enterprise_reporting_endpoints,
        enterprise_reporting_endpoints_fragment,
        &enterprise_reporting_endpoints_validate_params);

      fragment->enterprise_reporting_endpoints.Set(
          enterprise_reporting_endpoints_fragment.is_null() ? nullptr : enterprise_reporting_endpoints_fragment.data());
      fragment->quic_idle_connection_timeout_seconds_$flag = Traits::quic_idle_connection_timeout_seconds(input).has_value();
      if (Traits::quic_idle_connection_timeout_seconds(input).has_value()) {
        fragment->quic_idle_connection_timeout_seconds_$value = Traits::quic_idle_connection_timeout_seconds(input).value();
      }

      decltype(Traits::tracking_protection_content_settings(input)) in_tracking_protection_content_settings = Traits::tracking_protection_content_settings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->tracking_protection_content_settings)::BaseType>
          tracking_protection_content_settings_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& tracking_protection_content_settings_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>, send_validation>(
        in_tracking_protection_content_settings,
        tracking_protection_content_settings_fragment,
        &tracking_protection_content_settings_validate_params);

      fragment->tracking_protection_content_settings.Set(
          tracking_protection_content_settings_fragment.is_null() ? nullptr : tracking_protection_content_settings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->tracking_protection_content_settings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tracking_protection_content_settings in NetworkContextParams struct");

      fragment->enable_encrypted_http_cache = Traits::enable_encrypted_http_cache(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkConditionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkConditionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkConditions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->offline = Traits::offline(input);

      decltype(Traits::latency(input)) in_latency = Traits::latency(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->latency)::BaseType> latency_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_latency,
        latency_fragment);

      fragment->latency.Set(
          latency_fragment.is_null() ? nullptr : latency_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->latency.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in NetworkConditions struct");

      fragment->download_throughput = Traits::download_throughput(input);

      fragment->upload_throughput = Traits::upload_throughput(input);

      fragment->packet_loss = Traits::packet_loss(input);

      fragment->packet_queue_length = Traits::packet_queue_length(input);

      fragment->packet_reordering = Traits::packet_reordering(input);

      decltype(Traits::rule_id(input)) in_rule_id = Traits::rule_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rule_id)::BaseType> rule_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_rule_id,
        rule_id_fragment);

      fragment->rule_id.Set(
          rule_id_fragment.is_null() ? nullptr : rule_id_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::MatchedNetworkConditionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::MatchedNetworkConditionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::MatchedNetworkConditions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::pattern(input)) in_pattern = Traits::pattern(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pattern)::BaseType> pattern_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_pattern,
        pattern_fragment);

      fragment->pattern.Set(
          pattern_fragment.is_null() ? nullptr : pattern_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pattern.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pattern in MatchedNetworkConditions struct");

      decltype(Traits::conditions(input)) in_conditions = Traits::conditions(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->conditions)::BaseType> conditions_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::NetworkConditionsDataView, send_validation>(
        in_conditions,
        conditions_fragment);

      fragment->conditions.Set(
          conditions_fragment.is_null() ? nullptr : conditions_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->conditions.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null conditions in MatchedNetworkConditions struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkDurableMessageConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkDurableMessageConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkDurableMessageConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->http_storage_max_size = Traits::http_storage_max_size(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SharedDictionaryInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedDictionaryInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedDictionaryInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::match(input)) in_match = Traits::match(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->match)::BaseType> match_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_match,
        match_fragment);

      fragment->match.Set(
          match_fragment.is_null() ? nullptr : match_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->match.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null match in SharedDictionaryInfo struct");

      decltype(Traits::match_dest(input)) in_match_dest = Traits::match_dest(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->match_dest)::BaseType>
          match_dest_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& match_dest_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::RequestDestination_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::RequestDestination>, send_validation>(
        in_match_dest,
        match_dest_fragment,
        &match_dest_validate_params);

      fragment->match_dest.Set(
          match_dest_fragment.is_null() ? nullptr : match_dest_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->match_dest.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null match_dest in SharedDictionaryInfo struct");

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in SharedDictionaryInfo struct");

      decltype(Traits::dictionary_url(input)) in_dictionary_url = Traits::dictionary_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dictionary_url)::BaseType> dictionary_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_dictionary_url,
        dictionary_url_fragment);

      fragment->dictionary_url.Set(
          dictionary_url_fragment.is_null() ? nullptr : dictionary_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dictionary_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dictionary_url in SharedDictionaryInfo struct");

      decltype(Traits::last_fetch_time(input)) in_last_fetch_time = Traits::last_fetch_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_fetch_time)::BaseType> last_fetch_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_fetch_time,
        last_fetch_time_fragment);

      fragment->last_fetch_time.Set(
          last_fetch_time_fragment.is_null() ? nullptr : last_fetch_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_fetch_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_fetch_time in SharedDictionaryInfo struct");

      decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_time)::BaseType> response_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_response_time,
        response_time_fragment);

      fragment->response_time.Set(
          response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_time in SharedDictionaryInfo struct");

      decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiration)::BaseType> expiration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_expiration,
        expiration_fragment);

      fragment->expiration.Set(
          expiration_fragment.is_null() ? nullptr : expiration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in SharedDictionaryInfo struct");

      decltype(Traits::last_used_time(input)) in_last_used_time = Traits::last_used_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_used_time)::BaseType> last_used_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_used_time,
        last_used_time_fragment);

      fragment->last_used_time.Set(
          last_used_time_fragment.is_null() ? nullptr : last_used_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_used_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_used_time in SharedDictionaryInfo struct");

      fragment->size = Traits::size(input);

      decltype(Traits::hash(input)) in_hash = Traits::hash(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hash)::BaseType> hash_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SHA256HashValueDataView, send_validation>(
        in_hash,
        hash_fragment);

      fragment->hash.Set(
          hash_fragment.is_null() ? nullptr : hash_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hash.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hash in SharedDictionaryInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SignedExchangeReportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SignedExchangeReportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SignedExchangeReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->success = Traits::success(input);

      decltype(Traits::type(input)) in_type = Traits::type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->type)::BaseType> type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_type,
        type_fragment);

      fragment->type.Set(
          type_fragment.is_null() ? nullptr : type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in SignedExchangeReport struct");

      decltype(Traits::outer_url(input)) in_outer_url = Traits::outer_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->outer_url)::BaseType> outer_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_outer_url,
        outer_url_fragment);

      fragment->outer_url.Set(
          outer_url_fragment.is_null() ? nullptr : outer_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->outer_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outer_url in SignedExchangeReport struct");

      decltype(Traits::inner_url(input)) in_inner_url = Traits::inner_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->inner_url)::BaseType> inner_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_inner_url,
        inner_url_fragment);

      fragment->inner_url.Set(
          inner_url_fragment.is_null() ? nullptr : inner_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->inner_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inner_url in SignedExchangeReport struct");

      decltype(Traits::cert_url(input)) in_cert_url = Traits::cert_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cert_url)::BaseType> cert_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_cert_url,
        cert_url_fragment);

      fragment->cert_url.Set(
          cert_url_fragment.is_null() ? nullptr : cert_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cert_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert_url in SignedExchangeReport struct");

      decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->referrer)::BaseType> referrer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_referrer,
        referrer_fragment);

      fragment->referrer.Set(
          referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->referrer.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in SignedExchangeReport struct");

      decltype(Traits::server_ip_address(input)) in_server_ip_address = Traits::server_ip_address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->server_ip_address)::BaseType> server_ip_address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPAddressDataView, send_validation>(
        in_server_ip_address,
        server_ip_address_fragment);

      fragment->server_ip_address.Set(
          server_ip_address_fragment.is_null() ? nullptr : server_ip_address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->server_ip_address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_ip_address in SignedExchangeReport struct");

      decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protocol)::BaseType> protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_protocol,
        protocol_fragment);

      fragment->protocol.Set(
          protocol_fragment.is_null() ? nullptr : protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol in SignedExchangeReport struct");

      decltype(Traits::method(input)) in_method = Traits::method(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->method)::BaseType> method_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_method,
        method_fragment);

      fragment->method.Set(
          method_fragment.is_null() ? nullptr : method_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->method.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in SignedExchangeReport struct");

      fragment->status_code = Traits::status_code(input);

      decltype(Traits::elapsed_time(input)) in_elapsed_time = Traits::elapsed_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->elapsed_time)::BaseType> elapsed_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_elapsed_time,
        elapsed_time_fragment);

      fragment->elapsed_time.Set(
          elapsed_time_fragment.is_null() ? nullptr : elapsed_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->elapsed_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elapsed_time in SignedExchangeReport struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::URLLoaderFactoryOverrideDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderFactoryOverrideDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderFactoryOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::overriding_factory(input)) in_overriding_factory = Traits::overriding_factory(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
        in_overriding_factory,
        &fragment->overriding_factory,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->overriding_factory)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid overriding_factory in URLLoaderFactoryOverride struct");

      decltype(Traits::overridden_factory_receiver(input)) in_overridden_factory_receiver = Traits::overridden_factory_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
        in_overridden_factory_receiver,
        &fragment->overridden_factory_receiver,
        &fragment.message());

      fragment->skip_cors_enabled_scheme_check = Traits::skip_cors_enabled_scheme_check(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::URLLoaderFactoryParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderFactoryParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderFactoryParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->process_id = Traits::process_id(input);

      decltype(Traits::request_initiator_origin_lock(input)) in_request_initiator_origin_lock = Traits::request_initiator_origin_lock(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_initiator_origin_lock)::BaseType> request_initiator_origin_lock_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_request_initiator_origin_lock,
        request_initiator_origin_lock_fragment);

      fragment->request_initiator_origin_lock.Set(
          request_initiator_origin_lock_fragment.is_null() ? nullptr : request_initiator_origin_lock_fragment.data());

      fragment->is_orb_enabled = Traits::is_orb_enabled(input);

      fragment->ignore_isolated_world_origin = Traits::ignore_isolated_world_origin(input);

      fragment->unsafe_non_webby_initiator = Traits::unsafe_non_webby_initiator(input);

      fragment->disable_web_security = Traits::disable_web_security(input);

      decltype(Traits::header_client(input)) in_header_client = Traits::header_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustedURLLoaderHeaderClientInterfaceBase>>(
        in_header_client,
        &fragment->header_client,
        &fragment.message());

      decltype(Traits::isolation_info(input)) in_isolation_info = Traits::isolation_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->isolation_info)::BaseType> isolation_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IsolationInfoDataView, send_validation>(
        in_isolation_info,
        isolation_info_fragment);

      fragment->isolation_info.Set(
          isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->isolation_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null isolation_info in URLLoaderFactoryParams struct");

      fragment->disable_secure_dns = Traits::disable_secure_dns(input);

      fragment->is_trusted = Traits::is_trusted(input);

      fragment->automatically_assign_isolation_info = Traits::automatically_assign_isolation_info(input);

      decltype(Traits::top_frame_id(input)) in_top_frame_id = Traits::top_frame_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_id)::BaseType> top_frame_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_top_frame_id,
        top_frame_id_fragment);

      fragment->top_frame_id.Set(
          top_frame_id_fragment.is_null() ? nullptr : top_frame_id_fragment.data());

      decltype(Traits::factory_override(input)) in_factory_override = Traits::factory_override(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->factory_override)::BaseType> factory_override_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::URLLoaderFactoryOverrideDataView, send_validation>(
        in_factory_override,
        factory_override_fragment);

      fragment->factory_override.Set(
          factory_override_fragment.is_null() ? nullptr : factory_override_fragment.data());

      decltype(Traits::client_security_state(input)) in_client_security_state = Traits::client_security_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->client_security_state)::BaseType> client_security_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView, send_validation>(
        in_client_security_state,
        client_security_state_fragment);

      fragment->client_security_state.Set(
          client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());

      decltype(Traits::coep_reporter(input)) in_coep_reporter = Traits::coep_reporter(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
        in_coep_reporter,
        &fragment->coep_reporter,
        &fragment.message());

      decltype(Traits::dip_reporter(input)) in_dip_reporter = Traits::dip_reporter(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DocumentIsolationPolicyReporterInterfaceBase>>(
        in_dip_reporter,
        &fragment->dip_reporter,
        &fragment.message());

      decltype(Traits::cookie_observer(input)) in_cookie_observer = Traits::cookie_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
        in_cookie_observer,
        &fragment->cookie_observer,
        &fragment.message());

      decltype(Traits::trust_token_observer(input)) in_trust_token_observer = Traits::trust_token_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
        in_trust_token_observer,
        &fragment->trust_token_observer,
        &fragment.message());

      decltype(Traits::shared_dictionary_observer(input)) in_shared_dictionary_observer = Traits::shared_dictionary_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
        in_shared_dictionary_observer,
        &fragment->shared_dictionary_observer,
        &fragment.message());

      decltype(Traits::url_loader_network_observer(input)) in_url_loader_network_observer = Traits::url_loader_network_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
        in_url_loader_network_observer,
        &fragment->url_loader_network_observer,
        &fragment.message());

      decltype(Traits::devtools_observer(input)) in_devtools_observer = Traits::devtools_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
        in_devtools_observer,
        &fragment->devtools_observer,
        &fragment.message());

      decltype(Traits::device_bound_session_observer(input)) in_device_bound_session_observer = Traits::device_bound_session_observer(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
        in_device_bound_session_observer,
        &fragment->device_bound_session_observer,
        &fragment.message());

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        Traits::trust_token_issuance_policy(input),
        &fragment->trust_token_issuance_policy);

      
      mojo::internal::Serialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        Traits::trust_token_redemption_policy(input),
        &fragment->trust_token_redemption_policy);

      decltype(Traits::debug_tag(input)) in_debug_tag = Traits::debug_tag(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->debug_tag)::BaseType> debug_tag_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_debug_tag,
        debug_tag_fragment);

      fragment->debug_tag.Set(
          debug_tag_fragment.is_null() ? nullptr : debug_tag_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->debug_tag.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_tag in URLLoaderFactoryParams struct");

      decltype(Traits::cookie_setting_overrides(input)) in_cookie_setting_overrides = Traits::cookie_setting_overrides(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_setting_overrides)::BaseType> cookie_setting_overrides_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView, send_validation>(
        in_cookie_setting_overrides,
        cookie_setting_overrides_fragment);

      fragment->cookie_setting_overrides.Set(
          cookie_setting_overrides_fragment.is_null() ? nullptr : cookie_setting_overrides_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie_setting_overrides.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_setting_overrides in URLLoaderFactoryParams struct");

      decltype(Traits::devtools_cookie_setting_overrides(input)) in_devtools_cookie_setting_overrides = Traits::devtools_cookie_setting_overrides(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->devtools_cookie_setting_overrides)::BaseType> devtools_cookie_setting_overrides_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView, send_validation>(
        in_devtools_cookie_setting_overrides,
        devtools_cookie_setting_overrides_fragment);

      fragment->devtools_cookie_setting_overrides.Set(
          devtools_cookie_setting_overrides_fragment.is_null() ? nullptr : devtools_cookie_setting_overrides_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->devtools_cookie_setting_overrides.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_cookie_setting_overrides in URLLoaderFactoryParams struct");

      fragment->require_cross_site_request_for_cookies = Traits::require_cross_site_request_for_cookies(input);

      fragment->ignore_factory_reset = Traits::ignore_factory_reset(input);

      fragment->is_main_frame_origin_recently_accessed = Traits::is_main_frame_origin_recently_accessed(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SEND_VALIDATION_H_