// services/network/public/mojom/load_timing_internal_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/load_timing_internal_info.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/load_timing_internal_info.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/load_timing_internal_info.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/network/public/cpp/load_timing_internal_info_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class BLINK_PLATFORM_EXPORT LoadTimingInternalInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadTimingInternalInfo, T>::value>;
  using DataView = LoadTimingInternalInfoDataView;
  using Data_ = internal::LoadTimingInternalInfo_Data;

  template <typename... Args>
  static LoadTimingInternalInfoPtr New(Args&&... args) {
    return LoadTimingInternalInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadTimingInternalInfoPtr From(const U& u) {
    return mojo::TypeConverter<LoadTimingInternalInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadTimingInternalInfo>::Convert(*this);
  }


  LoadTimingInternalInfo();

  LoadTimingInternalInfo(
      ::base::TimeDelta create_stream_delay,
      ::base::TimeDelta connected_callback_delay,
      ::base::TimeDelta initialize_stream_delay,
      std::optional<SessionSource> session_source,
      AdvertisedAltSvcState advertised_alt_svc_state,
      bool http_network_session_quic_enabled);


  ~LoadTimingInternalInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadTimingInternalInfoPtr>
  LoadTimingInternalInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInternalInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadTimingInternalInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadTimingInternalInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadTimingInternalInfo_UnserializedMessageContext<
            UserType, LoadTimingInternalInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadTimingInternalInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadTimingInternalInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadTimingInternalInfo_UnserializedMessageContext<
            UserType, LoadTimingInternalInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadTimingInternalInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta create_stream_delay;
  
  ::base::TimeDelta connected_callback_delay;
  
  ::base::TimeDelta initialize_stream_delay;
  
  std::optional<SessionSource> session_source;
  
  AdvertisedAltSvcState advertised_alt_svc_state;
  
  bool http_network_session_quic_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadTimingInternalInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LoadTimingInternalInfoPtr LoadTimingInternalInfo::Clone() const {
  return New(
      mojo::Clone(create_stream_delay),
      mojo::Clone(connected_callback_delay),
      mojo::Clone(initialize_stream_delay),
      mojo::Clone(session_source),
      mojo::Clone(advertised_alt_svc_state),
      mojo::Clone(http_network_session_quic_enabled)
  );
}

template <typename T, LoadTimingInternalInfo::EnableIfSame<T>*>
bool LoadTimingInternalInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->create_stream_delay, other_struct.create_stream_delay))
    return false;
  if (!mojo::Equals(this->connected_callback_delay, other_struct.connected_callback_delay))
    return false;
  if (!mojo::Equals(this->initialize_stream_delay, other_struct.initialize_stream_delay))
    return false;
  if (!mojo::Equals(this->session_source, other_struct.session_source))
    return false;
  if (!mojo::Equals(this->advertised_alt_svc_state, other_struct.advertised_alt_svc_state))
    return false;
  if (!mojo::Equals(this->http_network_session_quic_enabled, other_struct.http_network_session_quic_enabled))
    return false;
  return true;
}

template <typename T, LoadTimingInternalInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.create_stream_delay < rhs.create_stream_delay)
    return true;
  if (rhs.create_stream_delay < lhs.create_stream_delay)
    return false;
  if (lhs.connected_callback_delay < rhs.connected_callback_delay)
    return true;
  if (rhs.connected_callback_delay < lhs.connected_callback_delay)
    return false;
  if (lhs.initialize_stream_delay < rhs.initialize_stream_delay)
    return true;
  if (rhs.initialize_stream_delay < lhs.initialize_stream_delay)
    return false;
  if (lhs.session_source < rhs.session_source)
    return true;
  if (rhs.session_source < lhs.session_source)
    return false;
  if (lhs.advertised_alt_svc_state < rhs.advertised_alt_svc_state)
    return true;
  if (rhs.advertised_alt_svc_state < lhs.advertised_alt_svc_state)
    return false;
  if (lhs.http_network_session_quic_enabled < rhs.http_network_session_quic_enabled)
    return true;
  if (rhs.http_network_session_quic_enabled < lhs.http_network_session_quic_enabled)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::LoadTimingInternalInfo::DataView,
                                         ::network::mojom::blink::LoadTimingInternalInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::LoadTimingInternalInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::LoadTimingInternalInfo::create_stream_delay)& create_stream_delay(
      const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) {
    return input->create_stream_delay;
  }

  static const decltype(::network::mojom::blink::LoadTimingInternalInfo::connected_callback_delay)& connected_callback_delay(
      const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) {
    return input->connected_callback_delay;
  }

  static const decltype(::network::mojom::blink::LoadTimingInternalInfo::initialize_stream_delay)& initialize_stream_delay(
      const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) {
    return input->initialize_stream_delay;
  }

  static decltype(::network::mojom::blink::LoadTimingInternalInfo::session_source) session_source(
      const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) {
    return input->session_source;
  }

  static decltype(::network::mojom::blink::LoadTimingInternalInfo::advertised_alt_svc_state) advertised_alt_svc_state(
      const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) {
    return input->advertised_alt_svc_state;
  }

  static decltype(::network::mojom::blink::LoadTimingInternalInfo::http_network_session_quic_enabled) http_network_session_quic_enabled(
      const ::network::mojom::blink::LoadTimingInternalInfoPtr& input) {
    return input->http_network_session_quic_enabled;
  }

  static bool Read(::network::mojom::blink::LoadTimingInternalInfo::DataView input, ::network::mojom::blink::LoadTimingInternalInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_BLINK_H_