// services/network/public/mojom/key_pinning.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/key_pinning.mojom-shared-internal.h"
#include "services/network/public/mojom/hash_value.mojom-shared.h"

#include "services/network/public/mojom/key_pinning.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::PinSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PinSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PinSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in PinSet struct");

      decltype(Traits::static_spki_hashes(input)) in_static_spki_hashes = Traits::static_spki_hashes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->static_spki_hashes)::BaseType>
          static_spki_hashes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& static_spki_hashes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>, send_validation>(
        in_static_spki_hashes,
        static_spki_hashes_fragment,
        &static_spki_hashes_validate_params);

      fragment->static_spki_hashes.Set(
          static_spki_hashes_fragment.is_null() ? nullptr : static_spki_hashes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->static_spki_hashes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null static_spki_hashes in PinSet struct");

      decltype(Traits::bad_static_spki_hashes(input)) in_bad_static_spki_hashes = Traits::bad_static_spki_hashes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bad_static_spki_hashes)::BaseType>
          bad_static_spki_hashes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& bad_static_spki_hashes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SHA256HashValueDataView>, send_validation>(
        in_bad_static_spki_hashes,
        bad_static_spki_hashes_fragment,
        &bad_static_spki_hashes_validate_params);

      fragment->bad_static_spki_hashes.Set(
          bad_static_spki_hashes_fragment.is_null() ? nullptr : bad_static_spki_hashes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bad_static_spki_hashes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bad_static_spki_hashes in PinSet struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::PinSetInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PinSetInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PinSetInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::hostname(input)) in_hostname = Traits::hostname(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hostname)::BaseType> hostname_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_hostname,
        hostname_fragment);

      fragment->hostname.Set(
          hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hostname.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hostname in PinSetInfo struct");

      decltype(Traits::pinset_name(input)) in_pinset_name = Traits::pinset_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pinset_name)::BaseType> pinset_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_pinset_name,
        pinset_name_fragment);

      fragment->pinset_name.Set(
          pinset_name_fragment.is_null() ? nullptr : pinset_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pinset_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pinset_name in PinSetInfo struct");

      fragment->include_subdomains = Traits::include_subdomains(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::PinListDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::PinListDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::PinList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::pinsets(input)) in_pinsets = Traits::pinsets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pinsets)::BaseType>
          pinsets_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pinsets_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PinSetDataView>, send_validation>(
        in_pinsets,
        pinsets_fragment,
        &pinsets_validate_params);

      fragment->pinsets.Set(
          pinsets_fragment.is_null() ? nullptr : pinsets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pinsets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pinsets in PinList struct");

      decltype(Traits::host_pins(input)) in_host_pins = Traits::host_pins(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->host_pins)::BaseType>
          host_pins_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& host_pins_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::PinSetInfoDataView>, send_validation>(
        in_host_pins,
        host_pins_fragment,
        &host_pins_validate_params);

      fragment->host_pins.Set(
          host_pins_fragment.is_null() ? nullptr : host_pins_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->host_pins.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_pins in PinList struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_KEY_PINNING_MOJOM_SEND_VALIDATION_H_