// services/network/public/mojom/key_pinning.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/key_pinning.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/key_pinning.mojom-params-data.h"
#include "services/network/public/mojom/key_pinning.mojom-shared-message-ids.h"

#include "services/network/public/mojom/key_pinning.mojom-blink-import-headers.h"
#include "services/network/public/mojom/key_pinning.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
PinSet::PinSet()
    : name(),
      static_spki_hashes(),
      bad_static_spki_hashes() {}

PinSet::PinSet(
    const ::blink::String& name_in,
    ::blink::Vector<::network::mojom::blink::SHA256HashValuePtr> static_spki_hashes_in,
    ::blink::Vector<::network::mojom::blink::SHA256HashValuePtr> bad_static_spki_hashes_in)
    : name(std::move(name_in)),
      static_spki_hashes(std::move(static_spki_hashes_in)),
      bad_static_spki_hashes(std::move(bad_static_spki_hashes_in)) {}

PinSet::~PinSet() = default;

void PinSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "static_spki_hashes"), this->static_spki_hashes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::network::mojom::blink::SHA256HashValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bad_static_spki_hashes"), this->bad_static_spki_hashes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::network::mojom::blink::SHA256HashValuePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinSetInfo::PinSetInfo()
    : hostname(),
      pinset_name(),
      include_subdomains() {}

PinSetInfo::PinSetInfo(
    const ::blink::String& hostname_in,
    const ::blink::String& pinset_name_in,
    bool include_subdomains_in)
    : hostname(std::move(hostname_in)),
      pinset_name(std::move(pinset_name_in)),
      include_subdomains(std::move(include_subdomains_in)) {}

PinSetInfo::~PinSetInfo() = default;
size_t PinSetInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->hostname);
  seed = mojo::internal::WTFHash(seed, this->pinset_name);
  seed = mojo::internal::WTFHash(seed, this->include_subdomains);
  return seed;
}

void PinSetInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hostname"), this->hostname,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinset_name"), this->pinset_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_subdomains"), this->include_subdomains,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinSetInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinList::PinList()
    : pinsets(),
      host_pins() {}

PinList::PinList(
    ::blink::Vector<PinSetPtr> pinsets_in,
    ::blink::Vector<PinSetInfoPtr> host_pins_in)
    : pinsets(std::move(pinsets_in)),
      host_pins(std::move(host_pins_in)) {}

PinList::~PinList() = default;

void PinList::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinsets"), this->pinsets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<PinSetPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_pins"), this->host_pins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<PinSetInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::PinSet::DataView, ::network::mojom::blink::PinSetPtr>::Read(
    ::network::mojom::blink::PinSet::DataView input,
    ::network::mojom::blink::PinSetPtr* output) {
  bool success = true;
  ::network::mojom::blink::PinSetPtr result(::network::mojom::blink::PinSet::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadStaticSpkiHashes(&result->static_spki_hashes))
        success = false;
      if (success && !input.ReadBadStaticSpkiHashes(&result->bad_static_spki_hashes))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::PinSetInfo::DataView, ::network::mojom::blink::PinSetInfoPtr>::Read(
    ::network::mojom::blink::PinSetInfo::DataView input,
    ::network::mojom::blink::PinSetInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::PinSetInfoPtr result(::network::mojom::blink::PinSetInfo::New());
  
      if (success && !input.ReadHostname(&result->hostname))
        success = false;
      if (success && !input.ReadPinsetName(&result->pinset_name))
        success = false;
      if (success)
        result->include_subdomains = input.include_subdomains();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::PinList::DataView, ::network::mojom::blink::PinListPtr>::Read(
    ::network::mojom::blink::PinList::DataView input,
    ::network::mojom::blink::PinListPtr* output) {
  bool success = true;
  ::network::mojom::blink::PinListPtr result(::network::mojom::blink::PinList::New());
  
      if (success && !input.ReadPinsets(&result->pinsets))
        success = false;
      if (success && !input.ReadHostPins(&result->host_pins))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif