// services/network/public/mojom/first_party_sets_access_delegate.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.FirstPartySetsCacheFilter');
goog.require('network.mojom.FirstPartySetsContextConfig');






goog.provide('network.mojom.FirstPartySetsAccessDelegate');
goog.provide('network.mojom.FirstPartySetsAccessDelegateReceiver');
goog.provide('network.mojom.FirstPartySetsAccessDelegateCallbackRouter');
goog.provide('network.mojom.FirstPartySetsAccessDelegateInterface');
goog.provide('network.mojom.FirstPartySetsAccessDelegateRemote');
goog.provide('network.mojom.FirstPartySetsAccessDelegatePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.FirstPartySetsAccessDelegatePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.FirstPartySetsAccessDelegate.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.FirstPartySetsAccessDelegateInterface = class {
  
  /**
   * @param { !network.mojom.FirstPartySetsReadyEvent } readyEvent
   */

  notifyReady(readyEvent) {}
  
  /**
   * @param { !boolean } enabled
   */

  setEnabled(enabled) {}
};

/**
 * @export
 * @implements { network.mojom.FirstPartySetsAccessDelegateInterface }
 */
network.mojom.FirstPartySetsAccessDelegateRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.FirstPartySetsAccessDelegatePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.FirstPartySetsAccessDelegatePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.FirstPartySetsAccessDelegatePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.FirstPartySetsReadyEvent } readyEvent
   */

  notifyReady(
      readyEvent) {
    this.proxy.sendMessage(
        0,
        network.mojom.FirstPartySetsAccessDelegate_NotifyReady_ParamsSpec.$,
        null,
        [
          readyEvent
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  setEnabled(
      enabled) {
    this.proxy.sendMessage(
        1,
        network.mojom.FirstPartySetsAccessDelegate_SetEnabled_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FirstPartySetsAccessDelegate
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.FirstPartySetsAccessDelegateReceiver = class {
  /**
   * @param {!network.mojom.FirstPartySetsAccessDelegateInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.FirstPartySetsAccessDelegateRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.FirstPartySetsAccessDelegateRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.FirstPartySetsAccessDelegateRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.FirstPartySetsAccessDelegate_NotifyReady_ParamsSpec.$,
        null,
        impl.notifyReady.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.FirstPartySetsAccessDelegate_SetEnabled_ParamsSpec.$,
        null,
        impl.setEnabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.FirstPartySetsAccessDelegate = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.FirstPartySetsAccessDelegate";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.FirstPartySetsAccessDelegateRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.FirstPartySetsAccessDelegateRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FirstPartySetsAccessDelegate
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.FirstPartySetsAccessDelegateCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.FirstPartySetsAccessDelegateRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.FirstPartySetsAccessDelegateRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyReady =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.FirstPartySetsAccessDelegate_NotifyReady_ParamsSpec.$,
        null,
        this.notifyReady.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.FirstPartySetsAccessDelegate_SetEnabled_ParamsSpec.$,
        null,
        this.setEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.FirstPartySetsAccessDelegateParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FirstPartySetsAccessDelegateParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.FirstPartySetsReadyEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FirstPartySetsReadyEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.FirstPartySetsAccessDelegate_NotifyReady_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FirstPartySetsAccessDelegate_NotifyReady_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.FirstPartySetsAccessDelegate_SetEnabled_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.FirstPartySetsAccessDelegate_SetEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.FirstPartySetsAccessDelegateParamsSpec.$,
    'FirstPartySetsAccessDelegateParams',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.FirstPartySetsAccessDelegateParams');

/** @record */
network.mojom.FirstPartySetsAccessDelegateParams = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};



mojo.internal.Struct(
    network.mojom.FirstPartySetsReadyEventSpec.$,
    'FirstPartySetsReadyEvent',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        network.mojom.FirstPartySetsContextConfigSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cacheFilter', 8,
        0,
        network.mojom.FirstPartySetsCacheFilterSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.FirstPartySetsReadyEvent');

/** @record */
network.mojom.FirstPartySetsReadyEvent = class {
  constructor() {
    /** @export { !network.mojom.FirstPartySetsContextConfig } */
    this.config;
    /** @export { !network.mojom.FirstPartySetsCacheFilter } */
    this.cacheFilter;
  }
};



mojo.internal.Struct(
    network.mojom.FirstPartySetsAccessDelegate_NotifyReady_ParamsSpec.$,
    'FirstPartySetsAccessDelegate_NotifyReady_Params',
    [
      mojo.internal.StructField(
        'readyEvent', 0,
        0,
        network.mojom.FirstPartySetsReadyEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.FirstPartySetsAccessDelegate_NotifyReady_Params');

/** @record */
network.mojom.FirstPartySetsAccessDelegate_NotifyReady_Params = class {
  constructor() {
    /** @export { !network.mojom.FirstPartySetsReadyEvent } */
    this.readyEvent;
  }
};



mojo.internal.Struct(
    network.mojom.FirstPartySetsAccessDelegate_SetEnabled_ParamsSpec.$,
    'FirstPartySetsAccessDelegate_SetEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.FirstPartySetsAccessDelegate_SetEnabled_Params');

/** @record */
network.mojom.FirstPartySetsAccessDelegate_SetEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};

