// services/network/public/mojom/fetch_retry_options.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/fetch_retry_options.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/network/public/mojom/fetch_retry_options.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::FetchRetryOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FetchRetryOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FetchRetryOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->max_attempts = Traits::max_attempts(input);

      decltype(Traits::initial_delay(input)) in_initial_delay = Traits::initial_delay(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_delay)::BaseType> initial_delay_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_initial_delay,
        initial_delay_fragment);

      fragment->initial_delay.Set(
          initial_delay_fragment.is_null() ? nullptr : initial_delay_fragment.data());
      fragment->backoff_factor_$flag = Traits::backoff_factor(input).has_value();
      if (Traits::backoff_factor(input).has_value()) {
        fragment->backoff_factor_$value = Traits::backoff_factor(input).value();
      }

      decltype(Traits::max_age(input)) in_max_age = Traits::max_age(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_age)::BaseType> max_age_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_max_age,
        max_age_fragment);

      fragment->max_age.Set(
          max_age_fragment.is_null() ? nullptr : max_age_fragment.data());

      fragment->retry_after_unload = Traits::retry_after_unload(input);

      fragment->retry_non_idempotent = Traits::retry_non_idempotent(input);

      fragment->retry_only_if_server_unreached = Traits::retry_only_if_server_unreached(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FETCH_RETRY_OPTIONS_MOJOM_SEND_VALIDATION_H_