// services/network/public/mojom/cross_origin_opener_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cross_origin_opener_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var source_location$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_location.mojom', 'source_location.mojom.js');
  }


  var CoopAccessReportType = {};
  CoopAccessReportType.kAccessFromCoopPageToOpener = 0;
  CoopAccessReportType.kAccessFromCoopPageToOpenee = 1;
  CoopAccessReportType.kAccessFromCoopPageToOther = 2;
  CoopAccessReportType.kAccessToCoopPageFromOpener = 3;
  CoopAccessReportType.kAccessToCoopPageFromOpenee = 4;
  CoopAccessReportType.kAccessToCoopPageFromOther = 5;
  CoopAccessReportType.MIN_VALUE = 0;
  CoopAccessReportType.MAX_VALUE = 5;

  CoopAccessReportType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  CoopAccessReportType.toKnownEnumValue = function(value) {
    return value;
  };

  CoopAccessReportType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CrossOriginOpenerPolicyValue = {};
  CrossOriginOpenerPolicyValue.kUnsafeNone = 0;
  CrossOriginOpenerPolicyValue.kSameOriginAllowPopups = 1;
  CrossOriginOpenerPolicyValue.kSameOrigin = 2;
  CrossOriginOpenerPolicyValue.kSameOriginPlusCoep = 3;
  CrossOriginOpenerPolicyValue.kNoopenerAllowPopups = 4;
  CrossOriginOpenerPolicyValue.MIN_VALUE = 0;
  CrossOriginOpenerPolicyValue.MAX_VALUE = 4;

  CrossOriginOpenerPolicyValue.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  CrossOriginOpenerPolicyValue.toKnownEnumValue = function(value) {
    return value;
  };

  CrossOriginOpenerPolicyValue.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CrossOriginOpenerPolicyReporterParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CrossOriginOpenerPolicyReporterParams.prototype.initDefaults_ = function() {
    this.reportType = 0;
    this.reporter = new CrossOriginOpenerPolicyReporterPtr();
    this.endpointDefined = false;
    this.reportedWindowUrl = null;
  };
  CrossOriginOpenerPolicyReporterParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CrossOriginOpenerPolicyReporterParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicyReporterParams.reportType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CoopAccessReportType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicyReporterParams.reporter
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CrossOriginOpenerPolicyReporterParams.reportedWindowUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CrossOriginOpenerPolicyReporterParams.encodedSize = codec.kStructHeaderSize + 24;

  CrossOriginOpenerPolicyReporterParams.decode = function(decoder) {
    var packed;
    var val = new CrossOriginOpenerPolicyReporterParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportType =
        decoder.decodeStruct(new codec.Enum(CoopAccessReportType));
    val.reporter =
        decoder.decodeStruct(new codec.Interface(CrossOriginOpenerPolicyReporterPtr));
    packed = decoder.readUint8();
    val.endpointDefined = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.reportedWindowUrl =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CrossOriginOpenerPolicyReporterParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CrossOriginOpenerPolicyReporterParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reportType);
    encoder.encodeStruct(new codec.Interface(CrossOriginOpenerPolicyReporterPtr), val.reporter);
    packed = 0;
    packed |= (val.endpointDefined & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.reportedWindowUrl);
  };
  function CrossOriginOpenerPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CrossOriginOpenerPolicy.prototype.initDefaults_ = function() {
    this.value = CrossOriginOpenerPolicyValue.kUnsafeNone;
    this.reportOnlyValue = CrossOriginOpenerPolicyValue.kUnsafeNone;
    this.reportingEndpoint = null;
    this.reportOnlyReportingEndpoint = null;
    this.soapByDefaultValue = CrossOriginOpenerPolicyValue.kUnsafeNone;
  };
  CrossOriginOpenerPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CrossOriginOpenerPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicy.value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CrossOriginOpenerPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicy.reportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicy.reportOnlyValue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, CrossOriginOpenerPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicy.reportOnlyReportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicy.soapByDefaultValue
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, CrossOriginOpenerPolicyValue);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CrossOriginOpenerPolicy.encodedSize = codec.kStructHeaderSize + 32;

  CrossOriginOpenerPolicy.decode = function(decoder) {
    var packed;
    var val = new CrossOriginOpenerPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(new codec.Enum(CrossOriginOpenerPolicyValue));
    val.reportOnlyValue =
        decoder.decodeStruct(new codec.Enum(CrossOriginOpenerPolicyValue));
    val.reportingEndpoint =
        decoder.decodeStruct(codec.String);
    val.reportOnlyReportingEndpoint =
        decoder.decodeStruct(codec.String);
    val.soapByDefaultValue =
        decoder.decodeStruct(new codec.Enum(CrossOriginOpenerPolicyValue));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CrossOriginOpenerPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CrossOriginOpenerPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.value);
    encoder.encodeStruct(codec.Int32, val.reportOnlyValue);
    encoder.encodeStruct(codec.String, val.reportingEndpoint);
    encoder.encodeStruct(codec.String, val.reportOnlyReportingEndpoint);
    encoder.encodeStruct(codec.Int32, val.soapByDefaultValue);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CrossOriginOpenerPolicyReporter_QueueAccessReport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.prototype.initDefaults_ = function() {
    this.reportType = 0;
    this.property = null;
    this.sourceLocation = null;
    this.reportedWindowUrl = null;
  };
  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.reportType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CoopAccessReportType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.property
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.sourceLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, source_location$.SourceLocation, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.reportedWindowUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.encodedSize = codec.kStructHeaderSize + 32;

  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.decode = function(decoder) {
    var packed;
    var val = new CrossOriginOpenerPolicyReporter_QueueAccessReport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reportType =
        decoder.decodeStruct(new codec.Enum(CoopAccessReportType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.property =
        decoder.decodeStruct(codec.String);
    val.sourceLocation =
        decoder.decodeStructPointer(source_location$.SourceLocation);
    val.reportedWindowUrl =
        decoder.decodeStruct(codec.String);
    return val;
  };

  CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reportType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.property);
    encoder.encodeStructPointer(source_location$.SourceLocation, val.sourceLocation);
    encoder.encodeStruct(codec.String, val.reportedWindowUrl);
  };
  var kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name = 0;

  function CrossOriginOpenerPolicyReporterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CrossOriginOpenerPolicyReporter,
                                                   handleOrPtrInfo);
  }

  function CrossOriginOpenerPolicyReporterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CrossOriginOpenerPolicyReporter, associatedInterfacePtrInfo);
  }

  CrossOriginOpenerPolicyReporterAssociatedPtr.prototype =
      Object.create(CrossOriginOpenerPolicyReporterPtr.prototype);
  CrossOriginOpenerPolicyReporterAssociatedPtr.prototype.constructor =
      CrossOriginOpenerPolicyReporterAssociatedPtr;

  function CrossOriginOpenerPolicyReporterProxy(receiver) {
    this.receiver_ = receiver;
  }
  CrossOriginOpenerPolicyReporterPtr.prototype.queueAccessReport = function() {
    return CrossOriginOpenerPolicyReporterProxy.prototype.queueAccessReport
        .apply(this.ptr.getProxy(), arguments);
  };

  CrossOriginOpenerPolicyReporterProxy.prototype.queueAccessReport = function(reportType, property, sourceLocation, reportedWindowUrl) {
    var params_ = new CrossOriginOpenerPolicyReporter_QueueAccessReport_Params();
    params_.reportType = reportType;
    params_.property = property;
    params_.sourceLocation = sourceLocation;
    params_.reportedWindowUrl = reportedWindowUrl;
    var builder = new codec.MessageV0Builder(
        kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name,
        codec.align(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params.encodedSize));
    builder.encodeStruct(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CrossOriginOpenerPolicyReporterStub(delegate) {
    this.delegate_ = delegate;
  }
  CrossOriginOpenerPolicyReporterStub.prototype.queueAccessReport = function(reportType, property, sourceLocation, reportedWindowUrl) {
    return this.delegate_ && this.delegate_.queueAccessReport && this.delegate_.queueAccessReport(reportType, property, sourceLocation, reportedWindowUrl);
  }

  CrossOriginOpenerPolicyReporterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name:
      var params = reader.decodeStruct(CrossOriginOpenerPolicyReporter_QueueAccessReport_Params);
      this.queueAccessReport(params.reportType, params.property, params.sourceLocation, params.reportedWindowUrl);
      return true;
    default:
      return false;
    }
  };

  CrossOriginOpenerPolicyReporterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCrossOriginOpenerPolicyReporterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCrossOriginOpenerPolicyReporter_QueueAccessReport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CrossOriginOpenerPolicyReporter_QueueAccessReport_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCrossOriginOpenerPolicyReporterResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CrossOriginOpenerPolicyReporter = {
    name: 'network.mojom.CrossOriginOpenerPolicyReporter',
    kVersion: 0,
    ptrClass: CrossOriginOpenerPolicyReporterPtr,
    proxyClass: CrossOriginOpenerPolicyReporterProxy,
    stubClass: CrossOriginOpenerPolicyReporterStub,
    validateRequest: validateCrossOriginOpenerPolicyReporterRequest,
    validateResponse: null,
  };
  CrossOriginOpenerPolicyReporterStub.prototype.validator = validateCrossOriginOpenerPolicyReporterRequest;
  CrossOriginOpenerPolicyReporterProxy.prototype.validator = null;
  exports.CoopAccessReportType = CoopAccessReportType;
  exports.CrossOriginOpenerPolicyValue = CrossOriginOpenerPolicyValue;
  exports.CrossOriginOpenerPolicyReporterParams = CrossOriginOpenerPolicyReporterParams;
  exports.CrossOriginOpenerPolicy = CrossOriginOpenerPolicy;
  exports.CrossOriginOpenerPolicyReporter = CrossOriginOpenerPolicyReporter;
  exports.CrossOriginOpenerPolicyReporterPtr = CrossOriginOpenerPolicyReporterPtr;
  exports.CrossOriginOpenerPolicyReporterAssociatedPtr = CrossOriginOpenerPolicyReporterAssociatedPtr;
})();