// services/network/public/mojom/cross_origin_opener_policy.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/source_location.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/cross_origin_opener_policy_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class CrossOriginOpenerPolicyReporterProxy;

template <typename ImplRefTraits>
class CrossOriginOpenerPolicyReporterStub;

class CrossOriginOpenerPolicyReporterRequestValidator;


class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporter
    : public CrossOriginOpenerPolicyReporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.CrossOriginOpenerPolicyReporter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CrossOriginOpenerPolicyReporterInterfaceBase;
  using Proxy_ = CrossOriginOpenerPolicyReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = CrossOriginOpenerPolicyReporterStub<ImplRefTraits>;

  using RequestValidator_ = CrossOriginOpenerPolicyReporterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kQueueAccessReportMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct QueueAccessReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CrossOriginOpenerPolicyReporter() = default;

  virtual void QueueAccessReport(CoopAccessReportType report_type, const ::blink::String& property, ::network::mojom::blink::SourceLocationPtr source_location, const ::blink::String& reported_window_url) = 0;
};



class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterProxy
    : public CrossOriginOpenerPolicyReporter {
 public:
  using InterfaceType = CrossOriginOpenerPolicyReporter;

  explicit CrossOriginOpenerPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QueueAccessReport(CoopAccessReportType report_type, const ::blink::String& property, ::network::mojom::blink::SourceLocationPtr source_location, const ::blink::String& reported_window_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterStubDispatch {
 public:
  static bool Accept(CrossOriginOpenerPolicyReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CrossOriginOpenerPolicyReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CrossOriginOpenerPolicyReporter>>
class CrossOriginOpenerPolicyReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CrossOriginOpenerPolicyReporterStub() = default;
  ~CrossOriginOpenerPolicyReporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CrossOriginOpenerPolicyReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CrossOriginOpenerPolicyReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CrossOriginOpenerPolicyReporterParams, T>::value>;
  using DataView = CrossOriginOpenerPolicyReporterParamsDataView;
  using Data_ = internal::CrossOriginOpenerPolicyReporterParams_Data;

  template <typename... Args>
  static CrossOriginOpenerPolicyReporterParamsPtr New(Args&&... args) {
    return CrossOriginOpenerPolicyReporterParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CrossOriginOpenerPolicyReporterParamsPtr From(const U& u) {
    return mojo::TypeConverter<CrossOriginOpenerPolicyReporterParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CrossOriginOpenerPolicyReporterParams>::Convert(*this);
  }


  CrossOriginOpenerPolicyReporterParams();

  CrossOriginOpenerPolicyReporterParams(
      CoopAccessReportType report_type,
      ::mojo::PendingRemote<CrossOriginOpenerPolicyReporter> reporter,
      bool endpoint_defined,
      const ::blink::String& reported_window_url);

CrossOriginOpenerPolicyReporterParams(const CrossOriginOpenerPolicyReporterParams&) = delete;
CrossOriginOpenerPolicyReporterParams& operator=(const CrossOriginOpenerPolicyReporterParams&) = delete;

  ~CrossOriginOpenerPolicyReporterParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CrossOriginOpenerPolicyReporterParamsPtr>
  CrossOriginOpenerPolicyReporterParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CrossOriginOpenerPolicyReporterParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CrossOriginOpenerPolicyReporterParams_UnserializedMessageContext<
            UserType, CrossOriginOpenerPolicyReporterParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CrossOriginOpenerPolicyReporterParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CrossOriginOpenerPolicyReporterParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CrossOriginOpenerPolicyReporterParams_UnserializedMessageContext<
            UserType, CrossOriginOpenerPolicyReporterParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CrossOriginOpenerPolicyReporterParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CoopAccessReportType report_type;
  
  ::mojo::PendingRemote<CrossOriginOpenerPolicyReporter> reporter;
  
  bool endpoint_defined;
  
  ::blink::String reported_window_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CrossOriginOpenerPolicy, T>::value>;
  using DataView = CrossOriginOpenerPolicyDataView;
  using Data_ = internal::CrossOriginOpenerPolicy_Data;

  template <typename... Args>
  static CrossOriginOpenerPolicyPtr New(Args&&... args) {
    return CrossOriginOpenerPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CrossOriginOpenerPolicyPtr From(const U& u) {
    return mojo::TypeConverter<CrossOriginOpenerPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CrossOriginOpenerPolicy>::Convert(*this);
  }


  CrossOriginOpenerPolicy();

  CrossOriginOpenerPolicy(
      CrossOriginOpenerPolicyValue value,
      const ::blink::String& reporting_endpoint,
      CrossOriginOpenerPolicyValue report_only_value,
      const ::blink::String& report_only_reporting_endpoint,
      CrossOriginOpenerPolicyValue soap_by_default_value);


  ~CrossOriginOpenerPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CrossOriginOpenerPolicyPtr>
  CrossOriginOpenerPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CrossOriginOpenerPolicy::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CrossOriginOpenerPolicy::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CrossOriginOpenerPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CrossOriginOpenerPolicy_UnserializedMessageContext<
            UserType, CrossOriginOpenerPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CrossOriginOpenerPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CrossOriginOpenerPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CrossOriginOpenerPolicy_UnserializedMessageContext<
            UserType, CrossOriginOpenerPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CrossOriginOpenerPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CrossOriginOpenerPolicyValue value;
  
  ::blink::String reporting_endpoint;
  
  CrossOriginOpenerPolicyValue report_only_value;
  
  ::blink::String report_only_reporting_endpoint;
  
  CrossOriginOpenerPolicyValue soap_by_default_value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CrossOriginOpenerPolicyReporterParamsPtr CrossOriginOpenerPolicyReporterParams::Clone() const {
  return New(
      mojo::Clone(report_type),
      mojo::Clone(reporter),
      mojo::Clone(endpoint_defined),
      mojo::Clone(reported_window_url)
  );
}

template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>*>
bool CrossOriginOpenerPolicyReporterParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->report_type, other_struct.report_type))
    return false;
  if (!mojo::Equals(this->reporter, other_struct.reporter))
    return false;
  if (!mojo::Equals(this->endpoint_defined, other_struct.endpoint_defined))
    return false;
  if (!mojo::Equals(this->reported_window_url, other_struct.reported_window_url))
    return false;
  return true;
}

template <typename T, CrossOriginOpenerPolicyReporterParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.report_type < rhs.report_type)
    return true;
  if (rhs.report_type < lhs.report_type)
    return false;
  if (lhs.reporter < rhs.reporter)
    return true;
  if (rhs.reporter < lhs.reporter)
    return false;
  if (lhs.endpoint_defined < rhs.endpoint_defined)
    return true;
  if (rhs.endpoint_defined < lhs.endpoint_defined)
    return false;
  if (lhs.reported_window_url < rhs.reported_window_url)
    return true;
  if (rhs.reported_window_url < lhs.reported_window_url)
    return false;
  return false;
}
template <typename StructPtrType>
CrossOriginOpenerPolicyPtr CrossOriginOpenerPolicy::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(reporting_endpoint),
      mojo::Clone(report_only_value),
      mojo::Clone(report_only_reporting_endpoint),
      mojo::Clone(soap_by_default_value)
  );
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>*>
bool CrossOriginOpenerPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->reporting_endpoint, other_struct.reporting_endpoint))
    return false;
  if (!mojo::Equals(this->report_only_value, other_struct.report_only_value))
    return false;
  if (!mojo::Equals(this->report_only_reporting_endpoint, other_struct.report_only_reporting_endpoint))
    return false;
  if (!mojo::Equals(this->soap_by_default_value, other_struct.soap_by_default_value))
    return false;
  return true;
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.reporting_endpoint < rhs.reporting_endpoint)
    return true;
  if (rhs.reporting_endpoint < lhs.reporting_endpoint)
    return false;
  if (lhs.report_only_value < rhs.report_only_value)
    return true;
  if (rhs.report_only_value < lhs.report_only_value)
    return false;
  if (lhs.report_only_reporting_endpoint < rhs.report_only_reporting_endpoint)
    return true;
  if (rhs.report_only_reporting_endpoint < lhs.report_only_reporting_endpoint)
    return false;
  if (lhs.soap_by_default_value < rhs.soap_by_default_value)
    return true;
  if (rhs.soap_by_default_value < lhs.soap_by_default_value)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::DataView,
                                         ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::report_type) report_type(
      const ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr& input) {
    return input->report_type;
  }

  static  decltype(::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::reporter)& reporter(
       ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr& input) {
    return input->reporter;
  }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::endpoint_defined) endpoint_defined(
      const ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr& input) {
    return input->endpoint_defined;
  }

  static const decltype(::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::reported_window_url)& reported_window_url(
      const ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr& input) {
    return input->reported_window_url;
  }

  static bool Read(::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::DataView input, ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CrossOriginOpenerPolicy::DataView,
                                         ::network::mojom::blink::CrossOriginOpenerPolicyPtr> {
  static bool IsNull(const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CrossOriginOpenerPolicyPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicy::value) value(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->value;
  }

  static const decltype(::network::mojom::blink::CrossOriginOpenerPolicy::reporting_endpoint)& reporting_endpoint(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->reporting_endpoint;
  }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicy::report_only_value) report_only_value(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->report_only_value;
  }

  static const decltype(::network::mojom::blink::CrossOriginOpenerPolicy::report_only_reporting_endpoint)& report_only_reporting_endpoint(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->report_only_reporting_endpoint;
  }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicy::soap_by_default_value) soap_by_default_value(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->soap_by_default_value;
  }

  static bool Read(::network::mojom::blink::CrossOriginOpenerPolicy::DataView input, ::network::mojom::blink::CrossOriginOpenerPolicyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_H_