// services/network/public/mojom/cross_origin_opener_policy.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-params-data.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink-import-headers.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
CrossOriginOpenerPolicyReporterParams::CrossOriginOpenerPolicyReporterParams()
    : report_type(),
      reporter(),
      endpoint_defined(),
      reported_window_url() {}

CrossOriginOpenerPolicyReporterParams::CrossOriginOpenerPolicyReporterParams(
    CoopAccessReportType report_type_in,
    ::mojo::PendingRemote<CrossOriginOpenerPolicyReporter> reporter_in,
    bool endpoint_defined_in,
    const ::blink::String& reported_window_url_in)
    : report_type(std::move(report_type_in)),
      reporter(std::move(reporter_in)),
      endpoint_defined(std::move(endpoint_defined_in)),
      reported_window_url(std::move(reported_window_url_in)) {}

CrossOriginOpenerPolicyReporterParams::~CrossOriginOpenerPolicyReporterParams() = default;

void CrossOriginOpenerPolicyReporterParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_type"), this->report_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CoopAccessReportType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporter"), this->reporter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<CrossOriginOpenerPolicyReporter>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "endpoint_defined"), this->endpoint_defined,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reported_window_url"), this->reported_window_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CrossOriginOpenerPolicyReporterParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CrossOriginOpenerPolicy::CrossOriginOpenerPolicy()
    : value(CrossOriginOpenerPolicyValue::kUnsafeNone),
      reporting_endpoint(),
      report_only_value(CrossOriginOpenerPolicyValue::kUnsafeNone),
      report_only_reporting_endpoint(),
      soap_by_default_value(CrossOriginOpenerPolicyValue::kUnsafeNone) {}

CrossOriginOpenerPolicy::CrossOriginOpenerPolicy(
    CrossOriginOpenerPolicyValue value_in,
    const ::blink::String& reporting_endpoint_in,
    CrossOriginOpenerPolicyValue report_only_value_in,
    const ::blink::String& report_only_reporting_endpoint_in,
    CrossOriginOpenerPolicyValue soap_by_default_value_in)
    : value(std::move(value_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)),
      report_only_value(std::move(report_only_value_in)),
      report_only_reporting_endpoint(std::move(report_only_reporting_endpoint_in)),
      soap_by_default_value(std::move(soap_by_default_value_in)) {}

CrossOriginOpenerPolicy::~CrossOriginOpenerPolicy() = default;

void CrossOriginOpenerPolicy::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginOpenerPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoint"), this->reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_value"), this->report_only_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginOpenerPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_reporting_endpoint"), this->report_only_reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "soap_by_default_value"), this->soap_by_default_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginOpenerPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CrossOriginOpenerPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CrossOriginOpenerPolicyReporter::IPCStableHashFunction CrossOriginOpenerPolicyReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CrossOriginOpenerPolicyReporter>(message.name())) {
    case messages::CrossOriginOpenerPolicyReporter::kQueueAccessReport: {
      return &CrossOriginOpenerPolicyReporter::QueueAccessReport_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CrossOriginOpenerPolicyReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CrossOriginOpenerPolicyReporter>(message.name())) {
      case messages::CrossOriginOpenerPolicyReporter::kQueueAccessReport:
            return "Receive network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport";
    }
  } else {
    switch (static_cast<messages::CrossOriginOpenerPolicyReporter>(message.name())) {
      case messages::CrossOriginOpenerPolicyReporter::kQueueAccessReport:
            return "Receive reply network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CrossOriginOpenerPolicyReporter::QueueAccessReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae70a00f;  // IPCStableHash for network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CrossOriginOpenerPolicyReporterProxy::CrossOriginOpenerPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CrossOriginOpenerPolicyReporterProxy::QueueAccessReport(
    CoopAccessReportType in_report_type, const ::blink::String& in_property, ::network::mojom::blink::SourceLocationPtr in_source_location, const ::blink::String& in_reported_window_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CrossOriginOpenerPolicyReporter::QueueAccessReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_type"), in_report_type,
                        "<value of type CoopAccessReportType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("property"), in_property,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_location"), in_source_location,
                        "<value of type ::network::mojom::blink::SourceLocationPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reported_window_url"), in_reported_window_url,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CrossOriginOpenerPolicyReporter::kQueueAccessReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::CoopAccessReportType>(
    in_report_type,
    &params->report_type);
  mojo::internal::MessageFragment<
      typename decltype(params->property)::BaseType> property_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_property,
    property_fragment);

  params->property.Set(
      property_fragment.is_null() ? nullptr : property_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->property.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null property in CrossOriginOpenerPolicyReporter.QueueAccessReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_location)::BaseType> source_location_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
    in_source_location,
    source_location_fragment);

  params->source_location.Set(
      source_location_fragment.is_null() ? nullptr : source_location_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_location.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_location in CrossOriginOpenerPolicyReporter.QueueAccessReport request");
  mojo::internal::MessageFragment<
      typename decltype(params->reported_window_url)::BaseType> reported_window_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_reported_window_url,
    reported_window_url_fragment);

  params->reported_window_url.Set(
      reported_window_url_fragment.is_null() ? nullptr : reported_window_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->reported_window_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null reported_window_url in CrossOriginOpenerPolicyReporter.QueueAccessReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginOpenerPolicyReporter::Name_);
  message.set_method_name("QueueAccessReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CrossOriginOpenerPolicyReporterStubDispatch::Accept(
    CrossOriginOpenerPolicyReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CrossOriginOpenerPolicyReporter>(message->header()->name)) {
    case messages::CrossOriginOpenerPolicyReporter::kQueueAccessReport: {
      DCHECK(message->is_serialized());
      internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data* params =
          reinterpret_cast<internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CrossOriginOpenerPolicyReporter.0
      bool success = true;
      CoopAccessReportType p_report_type{};
      ::blink::String p_property{};
      ::network::mojom::blink::SourceLocationPtr p_source_location{};
      ::blink::String p_reported_window_url{};
      CrossOriginOpenerPolicyReporter_QueueAccessReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReportType(&p_report_type))
        success = false;
      if (success && !input_data_view.ReadProperty(&p_property))
        success = false;
      if (success && !input_data_view.ReadSourceLocation(&p_source_location))
        success = false;
      if (success && !input_data_view.ReadReportedWindowUrl(&p_reported_window_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginOpenerPolicyReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueAccessReport(        
        std::move(p_report_type), 
        std::move(p_property), 
        std::move(p_source_location), 
        std::move(p_reported_window_url));
      return true;
    }
  }
  return false;
}

// static
bool CrossOriginOpenerPolicyReporterStubDispatch::AcceptWithResponder(
    CrossOriginOpenerPolicyReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CrossOriginOpenerPolicyReporter>(message->header()->name)) {
    case messages::CrossOriginOpenerPolicyReporter::kQueueAccessReport: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCrossOriginOpenerPolicyReporterValidationInfo[] = {
    { &internal::CrossOriginOpenerPolicyReporter_QueueAccessReport_Params_Data::Validate,
     nullptr /* no response */},
};

bool CrossOriginOpenerPolicyReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::CrossOriginOpenerPolicyReporter::Name_,
    kCrossOriginOpenerPolicyReporterValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::DataView, ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr>::Read(
    ::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::DataView input,
    ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CrossOriginOpenerPolicyReporterParamsPtr result(::network::mojom::blink::CrossOriginOpenerPolicyReporterParams::New());
  
      if (success && !input.ReadReportType(&result->report_type))
        success = false;
      if (success) {
        result->reporter =
            input.TakeReporter<decltype(result->reporter)>();
      }
      if (success)
        result->endpoint_defined = input.endpoint_defined();
      if (success && !input.ReadReportedWindowUrl(&result->reported_window_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CrossOriginOpenerPolicy::DataView, ::network::mojom::blink::CrossOriginOpenerPolicyPtr>::Read(
    ::network::mojom::blink::CrossOriginOpenerPolicy::DataView input,
    ::network::mojom::blink::CrossOriginOpenerPolicyPtr* output) {
  bool success = true;
  ::network::mojom::blink::CrossOriginOpenerPolicyPtr result(::network::mojom::blink::CrossOriginOpenerPolicy::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
      if (success && !input.ReadReportOnlyValue(&result->report_only_value))
        success = false;
      if (success && !input.ReadReportOnlyReportingEndpoint(&result->report_only_reporting_endpoint))
        success = false;
      if (success && !input.ReadSoapByDefaultValue(&result->soap_by_default_value))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void CrossOriginOpenerPolicyReporterInterceptorForTesting::QueueAccessReport(CoopAccessReportType report_type, const ::blink::String& property, ::network::mojom::blink::SourceLocationPtr source_location, const ::blink::String& reported_window_url) {
  GetForwardingInterface()->QueueAccessReport(
    std::move(report_type)
    , 
    std::move(property)
    , 
    std::move(source_location)
    , 
    std::move(reported_window_url)
    );
}
CrossOriginOpenerPolicyReporterAsyncWaiter::CrossOriginOpenerPolicyReporterAsyncWaiter(
    CrossOriginOpenerPolicyReporter* proxy) : proxy_(proxy) {}

CrossOriginOpenerPolicyReporterAsyncWaiter::~CrossOriginOpenerPolicyReporterAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif