// services/network/public/mojom/cors.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cors.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cors.mojom-params-data.h"
#include "services/network/public/mojom/cors.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cors.mojom-import-headers.h"
#include "services/network/public/mojom/cors.mojom-test-utils.h"


namespace network::mojom {
CorsErrorStatus::CorsErrorStatus()
    : cors_error(),
      failed_parameter(),
      target_address_space(::network::mojom::IPAddressSpace::kUnknown),
      resource_address_space(::network::mojom::IPAddressSpace::kUnknown),
      has_authorization_covered_by_wildcard_on_preflight(false),
      issue_id() {}

CorsErrorStatus::CorsErrorStatus(
    CorsError cors_error_in,
    const std::string& failed_parameter_in,
    ::network::mojom::IPAddressSpace target_address_space_in,
    ::network::mojom::IPAddressSpace resource_address_space_in,
    bool has_authorization_covered_by_wildcard_on_preflight_in,
    const ::base::UnguessableToken& issue_id_in)
    : cors_error(std::move(cors_error_in)),
      failed_parameter(std::move(failed_parameter_in)),
      target_address_space(std::move(target_address_space_in)),
      resource_address_space(std::move(resource_address_space_in)),
      has_authorization_covered_by_wildcard_on_preflight(std::move(has_authorization_covered_by_wildcard_on_preflight_in)),
      issue_id(std::move(issue_id_in)) {}

CorsErrorStatus::~CorsErrorStatus() = default;

void CorsErrorStatus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cors_error"), this->cors_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CorsError>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "failed_parameter"), this->failed_parameter,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_address_space"), this->target_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_address_space"), this->resource_address_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IPAddressSpace>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_authorization_covered_by_wildcard_on_preflight"), this->has_authorization_covered_by_wildcard_on_preflight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issue_id"), this->issue_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CorsErrorStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::CorsErrorStatus::DataView, ::network::mojom::CorsErrorStatusPtr>::Read(
    ::network::mojom::CorsErrorStatus::DataView input,
    ::network::mojom::CorsErrorStatusPtr* output) {
  bool success = true;
  ::network::mojom::CorsErrorStatusPtr result(::network::mojom::CorsErrorStatus::New());
  
      if (success && !input.ReadCorsError(&result->cors_error))
        success = false;
      if (success && !input.ReadFailedParameter(&result->failed_parameter))
        success = false;
      if (success && !input.ReadTargetAddressSpace(&result->target_address_space))
        success = false;
      if (success && !input.ReadResourceAddressSpace(&result->resource_address_space))
        success = false;
      if (success)
        result->has_authorization_covered_by_wildcard_on_preflight = input.has_authorization_covered_by_wildcard_on_preflight();
      if (success && !input.ReadIssueId(&result->issue_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif