// services/network/public/mojom/cookie_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cookie_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var content_settings$ =
      mojo.internal.exposeNamespace('contentSettings.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/content_settings/core/common/content_settings.mojom', '../../../../components/content_settings/core/common/content_settings.mojom.js');
  }
  var content_settings_types$ =
      mojo.internal.exposeNamespace('contentSettings.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/content_settings/core/common/content_settings_types.mojom', '../../../../components/content_settings/core/common/content_settings_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../../sandbox/policy/mojom/context.mojom.js');
  }
  var cookie_partition_key$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_partition_key.mojom', 'cookie_partition_key.mojom.js');
  }
  var first_party_sets$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/first_party_sets.mojom', 'first_party_sets.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }


  var CookieAccessDelegateType = {};
  CookieAccessDelegateType.USE_CONTENT_SETTINGS = 0;
  CookieAccessDelegateType.ALWAYS_LEGACY = 1;
  CookieAccessDelegateType.ALWAYS_NONLEGACY = 2;
  CookieAccessDelegateType.MIN_VALUE = 0;
  CookieAccessDelegateType.MAX_VALUE = 2;

  CookieAccessDelegateType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CookieAccessDelegateType.toKnownEnumValue = function(value) {
    return value;
  };

  CookieAccessDelegateType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookiePriority = {};
  CookiePriority.LOW = 0;
  CookiePriority.MEDIUM = 1;
  CookiePriority.HIGH = 2;
  CookiePriority.MIN_VALUE = 0;
  CookiePriority.MAX_VALUE = 2;

  CookiePriority.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CookiePriority.toKnownEnumValue = function(value) {
    return value;
  };

  CookiePriority.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieSourceScheme = {};
  CookieSourceScheme.kUnset = 0;
  CookieSourceScheme.kNonSecure = 1;
  CookieSourceScheme.kSecure = 2;
  CookieSourceScheme.MIN_VALUE = 0;
  CookieSourceScheme.MAX_VALUE = 2;

  CookieSourceScheme.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CookieSourceScheme.toKnownEnumValue = function(value) {
    return value;
  };

  CookieSourceScheme.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieSameSite = {};
  CookieSameSite.UNSPECIFIED = -1;
  CookieSameSite.NO_RESTRICTION = 0;
  CookieSameSite.LAX_MODE = 1;
  CookieSameSite.STRICT_MODE = 2;
  CookieSameSite.MIN_VALUE = -1;
  CookieSameSite.MAX_VALUE = 2;

  CookieSameSite.isKnownEnumValue = function(value) {
    switch (value) {
    case -1:
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CookieSameSite.toKnownEnumValue = function(value) {
    return value;
  };

  CookieSameSite.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieEffectiveSameSite = {};
  CookieEffectiveSameSite.kNoRestriction = 0;
  CookieEffectiveSameSite.kLaxMode = 1;
  CookieEffectiveSameSite.kStrictMode = 2;
  CookieEffectiveSameSite.kLaxModeAllowUnsafe = 3;
  CookieEffectiveSameSite.kUndefined = 4;
  CookieEffectiveSameSite.MIN_VALUE = 0;
  CookieEffectiveSameSite.MAX_VALUE = 4;

  CookieEffectiveSameSite.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  CookieEffectiveSameSite.toKnownEnumValue = function(value) {
    return value;
  };

  CookieEffectiveSameSite.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieExemptionReason = {};
  CookieExemptionReason.kNone = 0;
  CookieExemptionReason.kUserSetting = 1;
  CookieExemptionReason.k3PCDMetadata = 2;
  CookieExemptionReason.k3PCDDeprecationTrial = 3;
  CookieExemptionReason.kTopLevel3PCDDeprecationTrial = 4;
  CookieExemptionReason.k3PCDHeuristics = 5;
  CookieExemptionReason.kEnterprisePolicy = 6;
  CookieExemptionReason.kStorageAccess = 7;
  CookieExemptionReason.kTopLevelStorageAccess = 8;
  CookieExemptionReason.kScheme = 9;
  CookieExemptionReason.kSameSiteNoneCookiesInSandbox = 10;
  CookieExemptionReason.MIN_VALUE = 0;
  CookieExemptionReason.MAX_VALUE = 10;

  CookieExemptionReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  CookieExemptionReason.toKnownEnumValue = function(value) {
    return value;
  };

  CookieExemptionReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ContextType = {};
  ContextType.CROSS_SITE = 0;
  ContextType.SAME_SITE_LAX_METHOD_UNSAFE = 1;
  ContextType.SAME_SITE_LAX = 2;
  ContextType.SAME_SITE_STRICT = 3;
  ContextType.MIN_VALUE = 0;
  ContextType.MAX_VALUE = 3;

  ContextType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ContextType.toKnownEnumValue = function(value) {
    return value;
  };

  ContextType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieSameSiteContextMetadataDowngradeType = {};
  CookieSameSiteContextMetadataDowngradeType.kNoDowngrade = 0;
  CookieSameSiteContextMetadataDowngradeType.kStrictToLax = 1;
  CookieSameSiteContextMetadataDowngradeType.kStrictToCross = 2;
  CookieSameSiteContextMetadataDowngradeType.kLaxToCross = 3;
  CookieSameSiteContextMetadataDowngradeType.MIN_VALUE = 0;
  CookieSameSiteContextMetadataDowngradeType.MAX_VALUE = 3;

  CookieSameSiteContextMetadataDowngradeType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  CookieSameSiteContextMetadataDowngradeType.toKnownEnumValue = function(value) {
    return value;
  };

  CookieSameSiteContextMetadataDowngradeType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieSourceType = {};
  CookieSourceType.kUnknown = 0;
  CookieSourceType.kHTTP = 1;
  CookieSourceType.kScript = 2;
  CookieSourceType.kOther = 3;
  CookieSourceType.MIN_VALUE = 0;
  CookieSourceType.MAX_VALUE = 3;

  CookieSourceType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  CookieSourceType.toKnownEnumValue = function(value) {
    return value;
  };

  CookieSourceType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ContextRedirectTypeBug1221316 = {};
  ContextRedirectTypeBug1221316.kUnset = 0;
  ContextRedirectTypeBug1221316.kNoRedirect = 1;
  ContextRedirectTypeBug1221316.kCrossSiteRedirect = 2;
  ContextRedirectTypeBug1221316.kPartialSameSiteRedirect = 3;
  ContextRedirectTypeBug1221316.kAllSameSiteRedirect = 4;
  ContextRedirectTypeBug1221316.MIN_VALUE = 0;
  ContextRedirectTypeBug1221316.MAX_VALUE = 4;

  ContextRedirectTypeBug1221316.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ContextRedirectTypeBug1221316.toKnownEnumValue = function(value) {
    return value;
  };

  ContextRedirectTypeBug1221316.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HttpMethod = {};
  HttpMethod.kUnset = 0;
  HttpMethod.kUnknown = 1;
  HttpMethod.kGet = 2;
  HttpMethod.kHead = 3;
  HttpMethod.kPost = 4;
  HttpMethod.KPut = 5;
  HttpMethod.kDelete = 6;
  HttpMethod.kConnect = 7;
  HttpMethod.kOptions = 8;
  HttpMethod.kTrace = 9;
  HttpMethod.kPatch = 10;
  HttpMethod.MIN_VALUE = 0;
  HttpMethod.MAX_VALUE = 10;

  HttpMethod.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return true;
    }
    return false;
  };

  HttpMethod.toKnownEnumValue = function(value) {
    return value;
  };

  HttpMethod.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieAccessSemantics = {};
  CookieAccessSemantics.UNKNOWN = -1;
  CookieAccessSemantics.NONLEGACY = 0;
  CookieAccessSemantics.LEGACY = 1;
  CookieAccessSemantics.MIN_VALUE = -1;
  CookieAccessSemantics.MAX_VALUE = 1;

  CookieAccessSemantics.isKnownEnumValue = function(value) {
    switch (value) {
    case -1:
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CookieAccessSemantics.toKnownEnumValue = function(value) {
    return value;
  };

  CookieAccessSemantics.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieScopeSemantics = {};
  CookieScopeSemantics.UNKNOWN = -1;
  CookieScopeSemantics.NONLEGACY = 0;
  CookieScopeSemantics.LEGACY = 1;
  CookieScopeSemantics.MIN_VALUE = -1;
  CookieScopeSemantics.MAX_VALUE = 1;

  CookieScopeSemantics.isKnownEnumValue = function(value) {
    switch (value) {
    case -1:
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CookieScopeSemantics.toKnownEnumValue = function(value) {
    return value;
  };

  CookieScopeSemantics.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieChangeCause = {};
  CookieChangeCause.INSERTED = 0;
  CookieChangeCause.EXPLICIT = 1;
  CookieChangeCause.UNKNOWN_DELETION = 2;
  CookieChangeCause.OVERWRITE = 3;
  CookieChangeCause.EXPIRED = 4;
  CookieChangeCause.EVICTED = 5;
  CookieChangeCause.EXPIRED_OVERWRITE = 6;
  CookieChangeCause.INSERTED_NO_CHANGE_OVERWRITE = 7;
  CookieChangeCause.MIN_VALUE = 0;
  CookieChangeCause.MAX_VALUE = 7;

  CookieChangeCause.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  CookieChangeCause.toKnownEnumValue = function(value) {
    return value;
  };

  CookieChangeCause.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CookieDeletionSessionControl = {};
  CookieDeletionSessionControl.IGNORE_CONTROL = 0;
  CookieDeletionSessionControl.SESSION_COOKIES = 1;
  CookieDeletionSessionControl.PERSISTENT_COOKIES = 2;
  CookieDeletionSessionControl.MIN_VALUE = 0;
  CookieDeletionSessionControl.MAX_VALUE = 2;

  CookieDeletionSessionControl.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CookieDeletionSessionControl.toKnownEnumValue = function(value) {
    return value;
  };

  CookieDeletionSessionControl.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CookieManagerParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManagerParams.prototype.initDefaults_ = function() {
    this.blockThirdPartyCookies = false;
    this.trackingProtectionEnabledFor3pcd = false;
    this.mitigationsEnabledFor3pcd = false;
    this.allowFileSchemeCookies = false;
    this.cookieAccessDelegateType = CookieAccessDelegateType.USE_CONTENT_SETTINGS;
    this.contentSettings = null;
    this.secureOriginCookiesAllowedSchemes = null;
    this.matchingSchemeCookiesAllowedSchemes = null;
    this.thirdPartyCookiesAllowedSchemes = null;
  };
  CookieManagerParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManagerParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate CookieManagerParams.contentSettings
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.Enum(content_settings_types$.ContentSettingsType), new codec.ArrayOf(new codec.PointerTo(content_settings$.ContentSettingPatternSource)), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManagerParams.secureOriginCookiesAllowedSchemes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManagerParams.matchingSchemeCookiesAllowedSchemes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManagerParams.thirdPartyCookiesAllowedSchemes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookieManagerParams.cookieAccessDelegateType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, CookieAccessDelegateType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManagerParams.encodedSize = codec.kStructHeaderSize + 40;

  CookieManagerParams.decode = function(decoder) {
    var packed;
    var val = new CookieManagerParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.blockThirdPartyCookies = (packed >> 0) & 1 ? true : false;
    val.trackingProtectionEnabledFor3pcd = (packed >> 1) & 1 ? true : false;
    val.mitigationsEnabledFor3pcd = (packed >> 2) & 1 ? true : false;
    val.allowFileSchemeCookies = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cookieAccessDelegateType =
        decoder.decodeStruct(new codec.Enum(CookieAccessDelegateType));
    val.contentSettings =
        decoder.decodeMapPointer(new codec.Enum(content_settings_types$.ContentSettingsType), new codec.ArrayOf(new codec.PointerTo(content_settings$.ContentSettingPatternSource)));
    val.secureOriginCookiesAllowedSchemes =
        decoder.decodeArrayPointer(codec.String);
    val.matchingSchemeCookiesAllowedSchemes =
        decoder.decodeArrayPointer(codec.String);
    val.thirdPartyCookiesAllowedSchemes =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  CookieManagerParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManagerParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.blockThirdPartyCookies & 1) << 0
    packed |= (val.trackingProtectionEnabledFor3pcd & 1) << 1
    packed |= (val.mitigationsEnabledFor3pcd & 1) << 2
    packed |= (val.allowFileSchemeCookies & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.cookieAccessDelegateType);
    encoder.encodeMapPointer(new codec.Enum(content_settings_types$.ContentSettingsType), new codec.ArrayOf(new codec.PointerTo(content_settings$.ContentSettingPatternSource)), val.contentSettings);
    encoder.encodeArrayPointer(codec.String, val.secureOriginCookiesAllowedSchemes);
    encoder.encodeArrayPointer(codec.String, val.matchingSchemeCookiesAllowedSchemes);
    encoder.encodeArrayPointer(codec.String, val.thirdPartyCookiesAllowedSchemes);
  };
  function CookieSameSiteContextMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieSameSiteContextMetadata.prototype.initDefaults_ = function() {
    this.crossSiteRedirectDowngrade = CookieSameSiteContextMetadataDowngradeType.kNoDowngrade;
    this.redirectTypeBug1221316 = ContextRedirectTypeBug1221316.kUnset;
  };
  CookieSameSiteContextMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieSameSiteContextMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieSameSiteContextMetadata.crossSiteRedirectDowngrade
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CookieSameSiteContextMetadataDowngradeType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieSameSiteContextMetadata.redirectTypeBug1221316
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ContextRedirectTypeBug1221316);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieSameSiteContextMetadata.encodedSize = codec.kStructHeaderSize + 8;

  CookieSameSiteContextMetadata.decode = function(decoder) {
    var packed;
    var val = new CookieSameSiteContextMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.crossSiteRedirectDowngrade =
        decoder.decodeStruct(new codec.Enum(CookieSameSiteContextMetadataDowngradeType));
    val.redirectTypeBug1221316 =
        decoder.decodeStruct(new codec.Enum(ContextRedirectTypeBug1221316));
    return val;
  };

  CookieSameSiteContextMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieSameSiteContextMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.crossSiteRedirectDowngrade);
    encoder.encodeStruct(codec.Int32, val.redirectTypeBug1221316);
  };
  function CookieSameSiteContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieSameSiteContext.prototype.initDefaults_ = function() {
    this.context = ContextType.CROSS_SITE;
    this.schemefulContext = ContextType.CROSS_SITE;
    this.metadata = null;
    this.schemefulMetadata = null;
  };
  CookieSameSiteContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieSameSiteContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieSameSiteContext.context
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ContextType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieSameSiteContext.schemefulContext
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ContextType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieSameSiteContext.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CookieSameSiteContextMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieSameSiteContext.schemefulMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, CookieSameSiteContextMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieSameSiteContext.encodedSize = codec.kStructHeaderSize + 24;

  CookieSameSiteContext.decode = function(decoder) {
    var packed;
    var val = new CookieSameSiteContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.context =
        decoder.decodeStruct(new codec.Enum(ContextType));
    val.schemefulContext =
        decoder.decodeStruct(new codec.Enum(ContextType));
    val.metadata =
        decoder.decodeStructPointer(CookieSameSiteContextMetadata);
    val.schemefulMetadata =
        decoder.decodeStructPointer(CookieSameSiteContextMetadata);
    return val;
  };

  CookieSameSiteContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieSameSiteContext.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.context);
    encoder.encodeStruct(codec.Int32, val.schemefulContext);
    encoder.encodeStructPointer(CookieSameSiteContextMetadata, val.metadata);
    encoder.encodeStructPointer(CookieSameSiteContextMetadata, val.schemefulMetadata);
  };
  function CookieOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieOptions.prototype.initDefaults_ = function() {
    this.excludeHttponly = true;
    this.updateAccessTime = true;
    this.returnExcludedCookies = false;
    this.sameSiteCookieContext = null;
  };
  CookieOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CookieOptions.sameSiteCookieContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CookieSameSiteContext, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  CookieOptions.encodedSize = codec.kStructHeaderSize + 16;

  CookieOptions.decode = function(decoder) {
    var packed;
    var val = new CookieOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.excludeHttponly = (packed >> 0) & 1 ? true : false;
    val.updateAccessTime = (packed >> 1) & 1 ? true : false;
    val.returnExcludedCookies = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sameSiteCookieContext =
        decoder.decodeStructPointer(CookieSameSiteContext);
    return val;
  };

  CookieOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieOptions.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.excludeHttponly & 1) << 0
    packed |= (val.updateAccessTime & 1) << 1
    packed |= (val.returnExcludedCookies & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(CookieSameSiteContext, val.sameSiteCookieContext);
  };
  function CanonicalCookie(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CanonicalCookie.prototype.initDefaults_ = function() {
    this.name = null;
    this.value = null;
    this.domain = null;
    this.path = null;
    this.creation = null;
    this.expiry = null;
    this.lastAccess = null;
    this.lastUpdate = null;
    this.secure = false;
    this.httponly = false;
    this.siteRestrictions = CookieSameSite.NO_RESTRICTION;
    this.priority = CookiePriority.MEDIUM;
    this.sourceScheme = CookieSourceScheme.kUnset;
    this.partitionKey = null;
    this.sourcePort = -1;
    this.sourceType = CookieSourceType.kUnknown;
  };
  CanonicalCookie.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CanonicalCookie.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.domain
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.creation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.expiry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.lastAccess
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.lastUpdate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CanonicalCookie.siteRestrictions
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 68, CookieSameSite);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.priority
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 72, CookiePriority);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.sourceScheme
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 76, CookieSourceScheme);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CanonicalCookie.partitionKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, cookie_partition_key$.CookiePartitionKey, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CanonicalCookie.sourceType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 92, CookieSourceType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CanonicalCookie.encodedSize = codec.kStructHeaderSize + 96;

  CanonicalCookie.decode = function(decoder) {
    var packed;
    var val = new CanonicalCookie();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    val.domain =
        decoder.decodeStruct(codec.String);
    val.path =
        decoder.decodeStruct(codec.String);
    val.creation =
        decoder.decodeStructPointer(time$.Time);
    val.expiry =
        decoder.decodeStructPointer(time$.Time);
    val.lastAccess =
        decoder.decodeStructPointer(time$.Time);
    val.lastUpdate =
        decoder.decodeStructPointer(time$.Time);
    packed = decoder.readUint8();
    val.secure = (packed >> 0) & 1 ? true : false;
    val.httponly = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.siteRestrictions =
        decoder.decodeStruct(new codec.Enum(CookieSameSite));
    val.priority =
        decoder.decodeStruct(new codec.Enum(CookiePriority));
    val.sourceScheme =
        decoder.decodeStruct(new codec.Enum(CookieSourceScheme));
    val.partitionKey =
        decoder.decodeStructPointer(cookie_partition_key$.CookiePartitionKey);
    val.sourcePort =
        decoder.decodeStruct(codec.Int32);
    val.sourceType =
        decoder.decodeStruct(new codec.Enum(CookieSourceType));
    return val;
  };

  CanonicalCookie.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CanonicalCookie.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.value);
    encoder.encodeStruct(codec.String, val.domain);
    encoder.encodeStruct(codec.String, val.path);
    encoder.encodeStructPointer(time$.Time, val.creation);
    encoder.encodeStructPointer(time$.Time, val.expiry);
    encoder.encodeStructPointer(time$.Time, val.lastAccess);
    encoder.encodeStructPointer(time$.Time, val.lastUpdate);
    packed = 0;
    packed |= (val.secure & 1) << 0
    packed |= (val.httponly & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.siteRestrictions);
    encoder.encodeStruct(codec.Int32, val.priority);
    encoder.encodeStruct(codec.Int32, val.sourceScheme);
    encoder.encodeStructPointer(cookie_partition_key$.CookiePartitionKey, val.partitionKey);
    encoder.encodeStruct(codec.Int32, val.sourcePort);
    encoder.encodeStruct(codec.Int32, val.sourceType);
  };
  function ExclusionReasons(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ExclusionReasons.prototype.initDefaults_ = function() {
    this.exclusionsBitmask = 0;
  };
  ExclusionReasons.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ExclusionReasons.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ExclusionReasons.encodedSize = codec.kStructHeaderSize + 8;

  ExclusionReasons.decode = function(decoder) {
    var packed;
    var val = new ExclusionReasons();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.exclusionsBitmask =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  ExclusionReasons.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ExclusionReasons.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.exclusionsBitmask);
  };
  function WarningReasons(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WarningReasons.prototype.initDefaults_ = function() {
    this.warningsBitmask = 0;
  };
  WarningReasons.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WarningReasons.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WarningReasons.encodedSize = codec.kStructHeaderSize + 8;

  WarningReasons.decode = function(decoder) {
    var packed;
    var val = new WarningReasons();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.warningsBitmask =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  WarningReasons.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WarningReasons.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.warningsBitmask);
  };
  function CookieInclusionStatus(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieInclusionStatus.prototype.initDefaults_ = function() {
    this.exclusionReasons = null;
    this.warningReasons = null;
    this.exemptionReason = 0;
  };
  CookieInclusionStatus.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieInclusionStatus.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieInclusionStatus.exclusionReasons
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ExclusionReasons, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieInclusionStatus.warningReasons
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, WarningReasons, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieInclusionStatus.exemptionReason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, CookieExemptionReason);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieInclusionStatus.encodedSize = codec.kStructHeaderSize + 24;

  CookieInclusionStatus.decode = function(decoder) {
    var packed;
    var val = new CookieInclusionStatus();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.exclusionReasons =
        decoder.decodeStructPointer(ExclusionReasons);
    val.warningReasons =
        decoder.decodeStructPointer(WarningReasons);
    val.exemptionReason =
        decoder.decodeStruct(new codec.Enum(CookieExemptionReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieInclusionStatus.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieInclusionStatus.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ExclusionReasons, val.exclusionReasons);
    encoder.encodeStructPointer(WarningReasons, val.warningReasons);
    encoder.encodeStruct(codec.Int32, val.exemptionReason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieAndLineWithAccessResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieAndLineWithAccessResult.prototype.initDefaults_ = function() {
    this.cookie = null;
    this.cookieString = null;
    this.accessResult = null;
  };
  CookieAndLineWithAccessResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieAndLineWithAccessResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAndLineWithAccessResult.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CanonicalCookie, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAndLineWithAccessResult.cookieString
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAndLineWithAccessResult.accessResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, CookieAccessResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieAndLineWithAccessResult.encodedSize = codec.kStructHeaderSize + 24;

  CookieAndLineWithAccessResult.decode = function(decoder) {
    var packed;
    var val = new CookieAndLineWithAccessResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(CanonicalCookie);
    val.cookieString =
        decoder.decodeStruct(codec.String);
    val.accessResult =
        decoder.decodeStructPointer(CookieAccessResult);
    return val;
  };

  CookieAndLineWithAccessResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieAndLineWithAccessResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CanonicalCookie, val.cookie);
    encoder.encodeStruct(codec.String, val.cookieString);
    encoder.encodeStructPointer(CookieAccessResult, val.accessResult);
  };
  function CookieOrLineWithAccessResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieOrLineWithAccessResult.prototype.initDefaults_ = function() {
    this.cookieOrLine = null;
    this.accessResult = null;
  };
  CookieOrLineWithAccessResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieOrLineWithAccessResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieOrLineWithAccessResult.cookieOrLine
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, CookieOrLine, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieOrLineWithAccessResult.accessResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, CookieAccessResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieOrLineWithAccessResult.encodedSize = codec.kStructHeaderSize + 24;

  CookieOrLineWithAccessResult.decode = function(decoder) {
    var packed;
    var val = new CookieOrLineWithAccessResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookieOrLine =
        decoder.decodeStruct(CookieOrLine);
    val.accessResult =
        decoder.decodeStructPointer(CookieAccessResult);
    return val;
  };

  CookieOrLineWithAccessResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieOrLineWithAccessResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(CookieOrLine, val.cookieOrLine);
    encoder.encodeStructPointer(CookieAccessResult, val.accessResult);
  };
  function CookieAccessResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieAccessResult.prototype.initDefaults_ = function() {
    this.effectiveSameSite = 0;
    this.accessSemantics = 0;
    this.scopeSemantics = 0;
    this.isAllowedToAccessSecureCookies = false;
    this.status = null;
  };
  CookieAccessResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieAccessResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAccessResult.effectiveSameSite
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, CookieEffectiveSameSite);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAccessResult.accessSemantics
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, CookieAccessSemantics);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAccessResult.scopeSemantics
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, CookieScopeSemantics);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieAccessResult.status
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, CookieInclusionStatus, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieAccessResult.encodedSize = codec.kStructHeaderSize + 24;

  CookieAccessResult.decode = function(decoder) {
    var packed;
    var val = new CookieAccessResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.effectiveSameSite =
        decoder.decodeStruct(new codec.Enum(CookieEffectiveSameSite));
    val.accessSemantics =
        decoder.decodeStruct(new codec.Enum(CookieAccessSemantics));
    val.scopeSemantics =
        decoder.decodeStruct(new codec.Enum(CookieScopeSemantics));
    packed = decoder.readUint8();
    val.isAllowedToAccessSecureCookies = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.status =
        decoder.decodeStructPointer(CookieInclusionStatus);
    return val;
  };

  CookieAccessResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieAccessResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.effectiveSameSite);
    encoder.encodeStruct(codec.Int32, val.accessSemantics);
    encoder.encodeStruct(codec.Int32, val.scopeSemantics);
    packed = 0;
    packed |= (val.isAllowedToAccessSecureCookies & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(CookieInclusionStatus, val.status);
  };
  function CookieWithAccessResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieWithAccessResult.prototype.initDefaults_ = function() {
    this.cookie = null;
    this.accessResult = null;
  };
  CookieWithAccessResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieWithAccessResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieWithAccessResult.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CanonicalCookie, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieWithAccessResult.accessResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CookieAccessResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieWithAccessResult.encodedSize = codec.kStructHeaderSize + 16;

  CookieWithAccessResult.decode = function(decoder) {
    var packed;
    var val = new CookieWithAccessResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(CanonicalCookie);
    val.accessResult =
        decoder.decodeStructPointer(CookieAccessResult);
    return val;
  };

  CookieWithAccessResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieWithAccessResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CanonicalCookie, val.cookie);
    encoder.encodeStructPointer(CookieAccessResult, val.accessResult);
  };
  function CookieChangeInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieChangeInfo.prototype.initDefaults_ = function() {
    this.cookie = null;
    this.accessResult = null;
    this.cause = 0;
  };
  CookieChangeInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieChangeInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeInfo.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CanonicalCookie, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeInfo.accessResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CookieAccessResult, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeInfo.cause
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, CookieChangeCause);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieChangeInfo.encodedSize = codec.kStructHeaderSize + 24;

  CookieChangeInfo.decode = function(decoder) {
    var packed;
    var val = new CookieChangeInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(CanonicalCookie);
    val.accessResult =
        decoder.decodeStructPointer(CookieAccessResult);
    val.cause =
        decoder.decodeStruct(new codec.Enum(CookieChangeCause));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieChangeInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieChangeInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CanonicalCookie, val.cookie);
    encoder.encodeStructPointer(CookieAccessResult, val.accessResult);
    encoder.encodeStruct(codec.Int32, val.cause);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieDeletionFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieDeletionFilter.prototype.initDefaults_ = function() {
    this.createdAfterTime = null;
    this.createdBeforeTime = null;
    this.excludingDomains = null;
    this.includingDomains = null;
    this.cookieName = null;
    this.hostName = null;
    this.url = null;
    this.sessionControl = CookieDeletionSessionControl.IGNORE_CONTROL;
    this.partitionedStateOnly = false;
    this.cookiePartitionKeyCollection = null;
  };
  CookieDeletionFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieDeletionFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.createdAfterTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.createdBeforeTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.excludingDomains
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.includingDomains
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.cookieName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.hostName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.sessionControl
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, CookieDeletionSessionControl);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieDeletionFilter.cookiePartitionKeyCollection
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, cookie_partition_key$.CookiePartitionKeyCollection, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieDeletionFilter.encodedSize = codec.kStructHeaderSize + 72;

  CookieDeletionFilter.decode = function(decoder) {
    var packed;
    var val = new CookieDeletionFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.createdAfterTime =
        decoder.decodeStructPointer(time$.Time);
    val.createdBeforeTime =
        decoder.decodeStructPointer(time$.Time);
    val.excludingDomains =
        decoder.decodeArrayPointer(codec.String);
    val.includingDomains =
        decoder.decodeArrayPointer(codec.String);
    val.cookieName =
        decoder.decodeStruct(codec.String);
    val.hostName =
        decoder.decodeStruct(codec.String);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.sessionControl =
        decoder.decodeStruct(new codec.Enum(CookieDeletionSessionControl));
    packed = decoder.readUint8();
    val.partitionedStateOnly = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.cookiePartitionKeyCollection =
        decoder.decodeStructPointer(cookie_partition_key$.CookiePartitionKeyCollection);
    return val;
  };

  CookieDeletionFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieDeletionFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.createdAfterTime);
    encoder.encodeStructPointer(time$.Time, val.createdBeforeTime);
    encoder.encodeArrayPointer(codec.String, val.excludingDomains);
    encoder.encodeArrayPointer(codec.String, val.includingDomains);
    encoder.encodeStruct(codec.String, val.cookieName);
    encoder.encodeStruct(codec.String, val.hostName);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.Int32, val.sessionControl);
    packed = 0;
    packed |= (val.partitionedStateOnly & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(cookie_partition_key$.CookiePartitionKeyCollection, val.cookiePartitionKeyCollection);
  };
  function CookieChangeListener_OnCookieChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieChangeListener_OnCookieChange_Params.prototype.initDefaults_ = function() {
    this.change = null;
  };
  CookieChangeListener_OnCookieChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieChangeListener_OnCookieChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieChangeListener_OnCookieChange_Params.change
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CookieChangeInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieChangeListener_OnCookieChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieChangeListener_OnCookieChange_Params.decode = function(decoder) {
    var packed;
    var val = new CookieChangeListener_OnCookieChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.change =
        decoder.decodeStructPointer(CookieChangeInfo);
    return val;
  };

  CookieChangeListener_OnCookieChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieChangeListener_OnCookieChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CookieChangeInfo, val.change);
  };
  function CookieManager_GetAllCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_GetAllCookies_Params.prototype.initDefaults_ = function() {
  };
  CookieManager_GetAllCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_GetAllCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_GetAllCookies_Params.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_GetAllCookies_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_GetAllCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_GetAllCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_GetAllCookies_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_GetAllCookies_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_GetAllCookies_ResponseParams.prototype.initDefaults_ = function() {
    this.cookies = null;
  };
  CookieManager_GetAllCookies_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_GetAllCookies_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetAllCookies_ResponseParams.cookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CanonicalCookie), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_GetAllCookies_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_GetAllCookies_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_GetAllCookies_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookies =
        decoder.decodeArrayPointer(new codec.PointerTo(CanonicalCookie));
    return val;
  };

  CookieManager_GetAllCookies_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_GetAllCookies_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CanonicalCookie), val.cookies);
  };
  function CookieManager_GetAllCookiesWithAccessSemantics_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_GetAllCookiesWithAccessSemantics_Params.prototype.initDefaults_ = function() {
  };
  CookieManager_GetAllCookiesWithAccessSemantics_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_GetAllCookiesWithAccessSemantics_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_GetAllCookiesWithAccessSemantics_Params.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_GetAllCookiesWithAccessSemantics_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_GetAllCookiesWithAccessSemantics_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_GetAllCookiesWithAccessSemantics_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_GetAllCookiesWithAccessSemantics_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.prototype.initDefaults_ = function() {
    this.cookies = null;
    this.accessSemanticsList = null;
  };
  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.cookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CanonicalCookie), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.accessSemanticsList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 4, new codec.Enum(CookieAccessSemantics), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookies =
        decoder.decodeArrayPointer(new codec.PointerTo(CanonicalCookie));
    val.accessSemanticsList =
        decoder.decodeArrayPointer(new codec.Enum(CookieAccessSemantics));
    return val;
  };

  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CanonicalCookie), val.cookies);
    encoder.encodeArrayPointer(new codec.Enum(CookieAccessSemantics), val.accessSemanticsList);
  };
  function CookieManager_GetCookieList_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_GetCookieList_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.cookieOptions = null;
    this.cookiePartitionKeyCollection = null;
  };
  CookieManager_GetCookieList_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_GetCookieList_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetCookieList_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetCookieList_Params.cookieOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, CookieOptions, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetCookieList_Params.cookiePartitionKeyCollection
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, cookie_partition_key$.CookiePartitionKeyCollection, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_GetCookieList_Params.encodedSize = codec.kStructHeaderSize + 24;

  CookieManager_GetCookieList_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_GetCookieList_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.cookieOptions =
        decoder.decodeStructPointer(CookieOptions);
    val.cookiePartitionKeyCollection =
        decoder.decodeStructPointer(cookie_partition_key$.CookiePartitionKeyCollection);
    return val;
  };

  CookieManager_GetCookieList_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_GetCookieList_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(CookieOptions, val.cookieOptions);
    encoder.encodeStructPointer(cookie_partition_key$.CookiePartitionKeyCollection, val.cookiePartitionKeyCollection);
  };
  function CookieManager_GetCookieList_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_GetCookieList_ResponseParams.prototype.initDefaults_ = function() {
    this.cookies = null;
    this.excludedCookies = null;
  };
  CookieManager_GetCookieList_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_GetCookieList_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetCookieList_ResponseParams.cookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CookieWithAccessResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_GetCookieList_ResponseParams.excludedCookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CookieWithAccessResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_GetCookieList_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CookieManager_GetCookieList_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_GetCookieList_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookies =
        decoder.decodeArrayPointer(new codec.PointerTo(CookieWithAccessResult));
    val.excludedCookies =
        decoder.decodeArrayPointer(new codec.PointerTo(CookieWithAccessResult));
    return val;
  };

  CookieManager_GetCookieList_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_GetCookieList_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CookieWithAccessResult), val.cookies);
    encoder.encodeArrayPointer(new codec.PointerTo(CookieWithAccessResult), val.excludedCookies);
  };
  function CookieManager_SetCanonicalCookie_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetCanonicalCookie_Params.prototype.initDefaults_ = function() {
    this.cookie = null;
    this.sourceUrl = null;
    this.cookieOptions = null;
  };
  CookieManager_SetCanonicalCookie_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetCanonicalCookie_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetCanonicalCookie_Params.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CanonicalCookie, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetCanonicalCookie_Params.sourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetCanonicalCookie_Params.cookieOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, CookieOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_SetCanonicalCookie_Params.encodedSize = codec.kStructHeaderSize + 24;

  CookieManager_SetCanonicalCookie_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetCanonicalCookie_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(CanonicalCookie);
    val.sourceUrl =
        decoder.decodeStructPointer(url$.Url);
    val.cookieOptions =
        decoder.decodeStructPointer(CookieOptions);
    return val;
  };

  CookieManager_SetCanonicalCookie_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetCanonicalCookie_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CanonicalCookie, val.cookie);
    encoder.encodeStructPointer(url$.Url, val.sourceUrl);
    encoder.encodeStructPointer(CookieOptions, val.cookieOptions);
  };
  function CookieManager_SetCanonicalCookie_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetCanonicalCookie_ResponseParams.prototype.initDefaults_ = function() {
    this.accessResult = null;
  };
  CookieManager_SetCanonicalCookie_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetCanonicalCookie_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetCanonicalCookie_ResponseParams.accessResult
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CookieAccessResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_SetCanonicalCookie_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_SetCanonicalCookie_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetCanonicalCookie_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.accessResult =
        decoder.decodeStructPointer(CookieAccessResult);
    return val;
  };

  CookieManager_SetCanonicalCookie_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetCanonicalCookie_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CookieAccessResult, val.accessResult);
  };
  function CookieManager_DeleteCanonicalCookie_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteCanonicalCookie_Params.prototype.initDefaults_ = function() {
    this.cookie = null;
  };
  CookieManager_DeleteCanonicalCookie_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteCanonicalCookie_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_DeleteCanonicalCookie_Params.cookie
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CanonicalCookie, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_DeleteCanonicalCookie_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_DeleteCanonicalCookie_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteCanonicalCookie_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cookie =
        decoder.decodeStructPointer(CanonicalCookie);
    return val;
  };

  CookieManager_DeleteCanonicalCookie_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteCanonicalCookie_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CanonicalCookie, val.cookie);
  };
  function CookieManager_DeleteCanonicalCookie_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteCanonicalCookie_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  CookieManager_DeleteCanonicalCookie_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteCanonicalCookie_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_DeleteCanonicalCookie_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_DeleteCanonicalCookie_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteCanonicalCookie_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_DeleteCanonicalCookie_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteCanonicalCookie_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_DeleteCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteCookies_Params.prototype.initDefaults_ = function() {
    this.filter = null;
  };
  CookieManager_DeleteCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_DeleteCookies_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CookieDeletionFilter, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_DeleteCookies_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_DeleteCookies_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeStructPointer(CookieDeletionFilter);
    return val;
  };

  CookieManager_DeleteCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteCookies_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CookieDeletionFilter, val.filter);
  };
  function CookieManager_DeleteCookies_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteCookies_ResponseParams.prototype.initDefaults_ = function() {
    this.numDeleted = 0;
  };
  CookieManager_DeleteCookies_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteCookies_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_DeleteCookies_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_DeleteCookies_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteCookies_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numDeleted =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_DeleteCookies_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteCookies_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numDeleted);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_DeleteSessionOnlyCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteSessionOnlyCookies_Params.prototype.initDefaults_ = function() {
  };
  CookieManager_DeleteSessionOnlyCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteSessionOnlyCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_DeleteSessionOnlyCookies_Params.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_DeleteSessionOnlyCookies_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteSessionOnlyCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_DeleteSessionOnlyCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteSessionOnlyCookies_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_DeleteSessionOnlyCookies_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteSessionOnlyCookies_ResponseParams.prototype.initDefaults_ = function() {
    this.numDeleted = 0;
  };
  CookieManager_DeleteSessionOnlyCookies_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteSessionOnlyCookies_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_DeleteSessionOnlyCookies_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_DeleteSessionOnlyCookies_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteSessionOnlyCookies_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numDeleted =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_DeleteSessionOnlyCookies_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteSessionOnlyCookies_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numDeleted);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_DeleteStaleSessionOnlyCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteStaleSessionOnlyCookies_Params.prototype.initDefaults_ = function() {
  };
  CookieManager_DeleteStaleSessionOnlyCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteStaleSessionOnlyCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_DeleteStaleSessionOnlyCookies_Params.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_DeleteStaleSessionOnlyCookies_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteStaleSessionOnlyCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_DeleteStaleSessionOnlyCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteStaleSessionOnlyCookies_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.prototype.initDefaults_ = function() {
    this.numDeleted = 0;
  };
  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numDeleted =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numDeleted);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_AddCookieChangeListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_AddCookieChangeListener_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.name = null;
    this.listener = new CookieChangeListenerPtr();
  };
  CookieManager_AddCookieChangeListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_AddCookieChangeListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_AddCookieChangeListener_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_AddCookieChangeListener_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_AddCookieChangeListener_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_AddCookieChangeListener_Params.encodedSize = codec.kStructHeaderSize + 24;

  CookieManager_AddCookieChangeListener_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_AddCookieChangeListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.name =
        decoder.decodeStruct(codec.String);
    val.listener =
        decoder.decodeStruct(new codec.Interface(CookieChangeListenerPtr));
    return val;
  };

  CookieManager_AddCookieChangeListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_AddCookieChangeListener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(new codec.Interface(CookieChangeListenerPtr), val.listener);
  };
  function CookieManager_AddGlobalChangeListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_AddGlobalChangeListener_Params.prototype.initDefaults_ = function() {
    this.notificationPointer = new CookieChangeListenerPtr();
  };
  CookieManager_AddGlobalChangeListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_AddGlobalChangeListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_AddGlobalChangeListener_Params.notificationPointer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_AddGlobalChangeListener_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_AddGlobalChangeListener_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_AddGlobalChangeListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.notificationPointer =
        decoder.decodeStruct(new codec.Interface(CookieChangeListenerPtr));
    return val;
  };

  CookieManager_AddGlobalChangeListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_AddGlobalChangeListener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(CookieChangeListenerPtr), val.notificationPointer);
  };
  function CookieManager_CloneInterface_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_CloneInterface_Params.prototype.initDefaults_ = function() {
    this.newInterface = new bindings.InterfaceRequest();
  };
  CookieManager_CloneInterface_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_CloneInterface_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_CloneInterface_Params.newInterface
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_CloneInterface_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_CloneInterface_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_CloneInterface_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newInterface =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_CloneInterface_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_CloneInterface_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.newInterface);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_FlushCookieStore_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_FlushCookieStore_Params.prototype.initDefaults_ = function() {
  };
  CookieManager_FlushCookieStore_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_FlushCookieStore_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_FlushCookieStore_Params.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_FlushCookieStore_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_FlushCookieStore_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_FlushCookieStore_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_FlushCookieStore_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_FlushCookieStore_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_FlushCookieStore_ResponseParams.prototype.initDefaults_ = function() {
  };
  CookieManager_FlushCookieStore_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_FlushCookieStore_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_FlushCookieStore_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_FlushCookieStore_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_FlushCookieStore_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_FlushCookieStore_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_FlushCookieStore_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_AllowFileSchemeCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_AllowFileSchemeCookies_Params.prototype.initDefaults_ = function() {
    this.allow = false;
  };
  CookieManager_AllowFileSchemeCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_AllowFileSchemeCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_AllowFileSchemeCookies_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_AllowFileSchemeCookies_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_AllowFileSchemeCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allow = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_AllowFileSchemeCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_AllowFileSchemeCookies_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allow & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_AllowFileSchemeCookies_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_AllowFileSchemeCookies_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  CookieManager_AllowFileSchemeCookies_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_AllowFileSchemeCookies_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_AllowFileSchemeCookies_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_AllowFileSchemeCookies_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_AllowFileSchemeCookies_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_AllowFileSchemeCookies_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_AllowFileSchemeCookies_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_SetContentSettings_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetContentSettings_Params.prototype.initDefaults_ = function() {
    this.contentSettingsType = 0;
    this.settings = null;
  };
  CookieManager_SetContentSettings_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetContentSettings_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetContentSettings_Params.contentSettingsType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, content_settings_types$.ContentSettingsType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetContentSettings_Params.settings
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(content_settings$.ContentSettingPatternSource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_SetContentSettings_Params.encodedSize = codec.kStructHeaderSize + 16;

  CookieManager_SetContentSettings_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetContentSettings_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.contentSettingsType =
        decoder.decodeStruct(new codec.Enum(content_settings_types$.ContentSettingsType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.settings =
        decoder.decodeArrayPointer(new codec.PointerTo(content_settings$.ContentSettingPatternSource));
    return val;
  };

  CookieManager_SetContentSettings_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetContentSettings_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.contentSettingsType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(content_settings$.ContentSettingPatternSource), val.settings);
  };
  function CookieManager_SetContentSettings_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetContentSettings_ResponseParams.prototype.initDefaults_ = function() {
  };
  CookieManager_SetContentSettings_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetContentSettings_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_SetContentSettings_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_SetContentSettings_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetContentSettings_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_SetContentSettings_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetContentSettings_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_SetForceKeepSessionState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetForceKeepSessionState_Params.prototype.initDefaults_ = function() {
  };
  CookieManager_SetForceKeepSessionState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetForceKeepSessionState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_SetForceKeepSessionState_Params.encodedSize = codec.kStructHeaderSize + 0;

  CookieManager_SetForceKeepSessionState_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetForceKeepSessionState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CookieManager_SetForceKeepSessionState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetForceKeepSessionState_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CookieManager_BlockThirdPartyCookies_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_BlockThirdPartyCookies_Params.prototype.initDefaults_ = function() {
    this.block = false;
  };
  CookieManager_BlockThirdPartyCookies_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_BlockThirdPartyCookies_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_BlockThirdPartyCookies_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_BlockThirdPartyCookies_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_BlockThirdPartyCookies_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.block = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_BlockThirdPartyCookies_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_BlockThirdPartyCookies_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.block & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_SetMitigationsEnabledFor3pcd_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetMitigationsEnabledFor3pcd_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  CookieManager_SetMitigationsEnabledFor3pcd_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetMitigationsEnabledFor3pcd_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_SetMitigationsEnabledFor3pcd_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_SetMitigationsEnabledFor3pcd_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetMitigationsEnabledFor3pcd_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_SetMitigationsEnabledFor3pcd_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetMitigationsEnabledFor3pcd_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_SetTrackingProtectionEnabledFor3pcd_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetTrackingProtectionEnabledFor3pcd_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CookieManager_SetPreCommitCallbackDelayForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CookieManager_SetPreCommitCallbackDelayForTesting_Params.prototype.initDefaults_ = function() {
    this.delay = null;
  };
  CookieManager_SetPreCommitCallbackDelayForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CookieManager_SetPreCommitCallbackDelayForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CookieManager_SetPreCommitCallbackDelayForTesting_Params.delay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CookieManager_SetPreCommitCallbackDelayForTesting_Params.encodedSize = codec.kStructHeaderSize + 8;

  CookieManager_SetPreCommitCallbackDelayForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CookieManager_SetPreCommitCallbackDelayForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.delay =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  CookieManager_SetPreCommitCallbackDelayForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CookieManager_SetPreCommitCallbackDelayForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.delay);
  };

  function CookieOrLine(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  CookieOrLine.Tags = {
    cookie: 0,
    cookieString: 1,
  };

  CookieOrLine.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  CookieOrLine.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "cookie",
        "cookieString",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a CookieOrLine member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(CookieOrLine.prototype, "cookie", {
    get: function() {
      if (this.$tag != CookieOrLine.Tags.cookie) {
        throw new ReferenceError(
            "CookieOrLine.cookie is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CookieOrLine.Tags.cookie;
      this.$data = value;
    }
  });
  Object.defineProperty(CookieOrLine.prototype, "cookieString", {
    get: function() {
      if (this.$tag != CookieOrLine.Tags.cookieString) {
        throw new ReferenceError(
            "CookieOrLine.cookieString is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = CookieOrLine.Tags.cookieString;
      this.$data = value;
    }
  });


    CookieOrLine.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case CookieOrLine.Tags.cookie:
          encoder.encodeStructPointer(CanonicalCookie, val.cookie);
          break;
        case CookieOrLine.Tags.cookieString:
          encoder.encodeStruct(codec.String, val.cookieString);
          break;
      }
      encoder.align();
    };


    CookieOrLine.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new CookieOrLine();
      var tag = decoder.readUint32();
      switch (tag) {
        case CookieOrLine.Tags.cookie:
          result.cookie = decoder.decodeStructPointer(CanonicalCookie);
          break;
        case CookieOrLine.Tags.cookieString:
          result.cookieString = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    CookieOrLine.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case CookieOrLine.Tags.cookie:
          

    // validate CookieOrLine.cookie
    err = messageValidator.validateStructPointer(data_offset, CanonicalCookie, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case CookieOrLine.Tags.cookieString:
          

    // validate CookieOrLine.cookieString
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  CookieOrLine.encodedSize = 16;
  var kCookieChangeListener_OnCookieChange_Name = 0;

  function CookieChangeListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CookieChangeListener,
                                                   handleOrPtrInfo);
  }

  function CookieChangeListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CookieChangeListener, associatedInterfacePtrInfo);
  }

  CookieChangeListenerAssociatedPtr.prototype =
      Object.create(CookieChangeListenerPtr.prototype);
  CookieChangeListenerAssociatedPtr.prototype.constructor =
      CookieChangeListenerAssociatedPtr;

  function CookieChangeListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  CookieChangeListenerPtr.prototype.onCookieChange = function() {
    return CookieChangeListenerProxy.prototype.onCookieChange
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieChangeListenerProxy.prototype.onCookieChange = function(change) {
    var params_ = new CookieChangeListener_OnCookieChange_Params();
    params_.change = change;
    var builder = new codec.MessageV0Builder(
        kCookieChangeListener_OnCookieChange_Name,
        codec.align(CookieChangeListener_OnCookieChange_Params.encodedSize));
    builder.encodeStruct(CookieChangeListener_OnCookieChange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CookieChangeListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  CookieChangeListenerStub.prototype.onCookieChange = function(change) {
    return this.delegate_ && this.delegate_.onCookieChange && this.delegate_.onCookieChange(change);
  }

  CookieChangeListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCookieChangeListener_OnCookieChange_Name:
      var params = reader.decodeStruct(CookieChangeListener_OnCookieChange_Params);
      this.onCookieChange(params.change);
      return true;
    default:
      return false;
    }
  };

  CookieChangeListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCookieChangeListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCookieChangeListener_OnCookieChange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieChangeListener_OnCookieChange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCookieChangeListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CookieChangeListener = {
    name: 'network.mojom.CookieChangeListener',
    kVersion: 0,
    ptrClass: CookieChangeListenerPtr,
    proxyClass: CookieChangeListenerProxy,
    stubClass: CookieChangeListenerStub,
    validateRequest: validateCookieChangeListenerRequest,
    validateResponse: null,
  };
  CookieChangeListenerStub.prototype.validator = validateCookieChangeListenerRequest;
  CookieChangeListenerProxy.prototype.validator = null;
  var kCookieManager_GetAllCookies_Name = 0;
  var kCookieManager_GetAllCookiesWithAccessSemantics_Name = 1;
  var kCookieManager_GetCookieList_Name = 2;
  var kCookieManager_SetCanonicalCookie_Name = 3;
  var kCookieManager_DeleteCanonicalCookie_Name = 4;
  var kCookieManager_DeleteCookies_Name = 5;
  var kCookieManager_DeleteSessionOnlyCookies_Name = 6;
  var kCookieManager_DeleteStaleSessionOnlyCookies_Name = 7;
  var kCookieManager_AddCookieChangeListener_Name = 8;
  var kCookieManager_AddGlobalChangeListener_Name = 9;
  var kCookieManager_CloneInterface_Name = 10;
  var kCookieManager_FlushCookieStore_Name = 11;
  var kCookieManager_AllowFileSchemeCookies_Name = 12;
  var kCookieManager_SetContentSettings_Name = 13;
  var kCookieManager_SetForceKeepSessionState_Name = 14;
  var kCookieManager_BlockThirdPartyCookies_Name = 15;
  var kCookieManager_SetMitigationsEnabledFor3pcd_Name = 16;
  var kCookieManager_SetTrackingProtectionEnabledFor3pcd_Name = 17;
  var kCookieManager_SetPreCommitCallbackDelayForTesting_Name = 18;

  function CookieManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CookieManager,
                                                   handleOrPtrInfo);
  }

  function CookieManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CookieManager, associatedInterfacePtrInfo);
  }

  CookieManagerAssociatedPtr.prototype =
      Object.create(CookieManagerPtr.prototype);
  CookieManagerAssociatedPtr.prototype.constructor =
      CookieManagerAssociatedPtr;

  function CookieManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  CookieManagerPtr.prototype.getAllCookies = function() {
    return CookieManagerProxy.prototype.getAllCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.getAllCookies = function() {
    var params_ = new CookieManager_GetAllCookies_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_GetAllCookies_Name,
          codec.align(CookieManager_GetAllCookies_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_GetAllCookies_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_GetAllCookies_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.getAllCookiesWithAccessSemantics = function() {
    return CookieManagerProxy.prototype.getAllCookiesWithAccessSemantics
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.getAllCookiesWithAccessSemantics = function() {
    var params_ = new CookieManager_GetAllCookiesWithAccessSemantics_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_GetAllCookiesWithAccessSemantics_Name,
          codec.align(CookieManager_GetAllCookiesWithAccessSemantics_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_GetAllCookiesWithAccessSemantics_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.getCookieList = function() {
    return CookieManagerProxy.prototype.getCookieList
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.getCookieList = function(url, cookieOptions, cookiePartitionKeyCollection) {
    var params_ = new CookieManager_GetCookieList_Params();
    params_.url = url;
    params_.cookieOptions = cookieOptions;
    params_.cookiePartitionKeyCollection = cookiePartitionKeyCollection;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_GetCookieList_Name,
          codec.align(CookieManager_GetCookieList_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_GetCookieList_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_GetCookieList_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.setCanonicalCookie = function() {
    return CookieManagerProxy.prototype.setCanonicalCookie
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.setCanonicalCookie = function(cookie, sourceUrl, cookieOptions) {
    var params_ = new CookieManager_SetCanonicalCookie_Params();
    params_.cookie = cookie;
    params_.sourceUrl = sourceUrl;
    params_.cookieOptions = cookieOptions;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_SetCanonicalCookie_Name,
          codec.align(CookieManager_SetCanonicalCookie_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_SetCanonicalCookie_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_SetCanonicalCookie_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.deleteCanonicalCookie = function() {
    return CookieManagerProxy.prototype.deleteCanonicalCookie
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.deleteCanonicalCookie = function(cookie) {
    var params_ = new CookieManager_DeleteCanonicalCookie_Params();
    params_.cookie = cookie;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_DeleteCanonicalCookie_Name,
          codec.align(CookieManager_DeleteCanonicalCookie_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_DeleteCanonicalCookie_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_DeleteCanonicalCookie_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.deleteCookies = function() {
    return CookieManagerProxy.prototype.deleteCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.deleteCookies = function(filter) {
    var params_ = new CookieManager_DeleteCookies_Params();
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_DeleteCookies_Name,
          codec.align(CookieManager_DeleteCookies_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_DeleteCookies_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_DeleteCookies_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.deleteSessionOnlyCookies = function() {
    return CookieManagerProxy.prototype.deleteSessionOnlyCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.deleteSessionOnlyCookies = function() {
    var params_ = new CookieManager_DeleteSessionOnlyCookies_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_DeleteSessionOnlyCookies_Name,
          codec.align(CookieManager_DeleteSessionOnlyCookies_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_DeleteSessionOnlyCookies_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_DeleteSessionOnlyCookies_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.deleteStaleSessionOnlyCookies = function() {
    return CookieManagerProxy.prototype.deleteStaleSessionOnlyCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.deleteStaleSessionOnlyCookies = function() {
    var params_ = new CookieManager_DeleteStaleSessionOnlyCookies_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_DeleteStaleSessionOnlyCookies_Name,
          codec.align(CookieManager_DeleteStaleSessionOnlyCookies_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_DeleteStaleSessionOnlyCookies_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.addCookieChangeListener = function() {
    return CookieManagerProxy.prototype.addCookieChangeListener
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.addCookieChangeListener = function(url, name, listener) {
    var params_ = new CookieManager_AddCookieChangeListener_Params();
    params_.url = url;
    params_.name = name;
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kCookieManager_AddCookieChangeListener_Name,
        codec.align(CookieManager_AddCookieChangeListener_Params.encodedSize));
    builder.encodeStruct(CookieManager_AddCookieChangeListener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.addGlobalChangeListener = function() {
    return CookieManagerProxy.prototype.addGlobalChangeListener
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.addGlobalChangeListener = function(notificationPointer) {
    var params_ = new CookieManager_AddGlobalChangeListener_Params();
    params_.notificationPointer = notificationPointer;
    var builder = new codec.MessageV0Builder(
        kCookieManager_AddGlobalChangeListener_Name,
        codec.align(CookieManager_AddGlobalChangeListener_Params.encodedSize));
    builder.encodeStruct(CookieManager_AddGlobalChangeListener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.cloneInterface = function() {
    return CookieManagerProxy.prototype.cloneInterface
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.cloneInterface = function(newInterface) {
    var params_ = new CookieManager_CloneInterface_Params();
    params_.newInterface = newInterface;
    var builder = new codec.MessageV0Builder(
        kCookieManager_CloneInterface_Name,
        codec.align(CookieManager_CloneInterface_Params.encodedSize));
    builder.encodeStruct(CookieManager_CloneInterface_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.flushCookieStore = function() {
    return CookieManagerProxy.prototype.flushCookieStore
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.flushCookieStore = function() {
    var params_ = new CookieManager_FlushCookieStore_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_FlushCookieStore_Name,
          codec.align(CookieManager_FlushCookieStore_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_FlushCookieStore_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_FlushCookieStore_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.allowFileSchemeCookies = function() {
    return CookieManagerProxy.prototype.allowFileSchemeCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.allowFileSchemeCookies = function(allow) {
    var params_ = new CookieManager_AllowFileSchemeCookies_Params();
    params_.allow = allow;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_AllowFileSchemeCookies_Name,
          codec.align(CookieManager_AllowFileSchemeCookies_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_AllowFileSchemeCookies_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_AllowFileSchemeCookies_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.setContentSettings = function() {
    return CookieManagerProxy.prototype.setContentSettings
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.setContentSettings = function(contentSettingsType, settings) {
    var params_ = new CookieManager_SetContentSettings_Params();
    params_.contentSettingsType = contentSettingsType;
    params_.settings = settings;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCookieManager_SetContentSettings_Name,
          codec.align(CookieManager_SetContentSettings_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CookieManager_SetContentSettings_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CookieManager_SetContentSettings_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CookieManagerPtr.prototype.setForceKeepSessionState = function() {
    return CookieManagerProxy.prototype.setForceKeepSessionState
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.setForceKeepSessionState = function() {
    var params_ = new CookieManager_SetForceKeepSessionState_Params();
    var builder = new codec.MessageV0Builder(
        kCookieManager_SetForceKeepSessionState_Name,
        codec.align(CookieManager_SetForceKeepSessionState_Params.encodedSize));
    builder.encodeStruct(CookieManager_SetForceKeepSessionState_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.blockThirdPartyCookies = function() {
    return CookieManagerProxy.prototype.blockThirdPartyCookies
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.blockThirdPartyCookies = function(block) {
    var params_ = new CookieManager_BlockThirdPartyCookies_Params();
    params_.block = block;
    var builder = new codec.MessageV0Builder(
        kCookieManager_BlockThirdPartyCookies_Name,
        codec.align(CookieManager_BlockThirdPartyCookies_Params.encodedSize));
    builder.encodeStruct(CookieManager_BlockThirdPartyCookies_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.setMitigationsEnabledFor3pcd = function() {
    return CookieManagerProxy.prototype.setMitigationsEnabledFor3pcd
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.setMitigationsEnabledFor3pcd = function(enable) {
    var params_ = new CookieManager_SetMitigationsEnabledFor3pcd_Params();
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kCookieManager_SetMitigationsEnabledFor3pcd_Name,
        codec.align(CookieManager_SetMitigationsEnabledFor3pcd_Params.encodedSize));
    builder.encodeStruct(CookieManager_SetMitigationsEnabledFor3pcd_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.setTrackingProtectionEnabledFor3pcd = function() {
    return CookieManagerProxy.prototype.setTrackingProtectionEnabledFor3pcd
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.setTrackingProtectionEnabledFor3pcd = function(enable) {
    var params_ = new CookieManager_SetTrackingProtectionEnabledFor3pcd_Params();
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kCookieManager_SetTrackingProtectionEnabledFor3pcd_Name,
        codec.align(CookieManager_SetTrackingProtectionEnabledFor3pcd_Params.encodedSize));
    builder.encodeStruct(CookieManager_SetTrackingProtectionEnabledFor3pcd_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CookieManagerPtr.prototype.setPreCommitCallbackDelayForTesting = function() {
    return CookieManagerProxy.prototype.setPreCommitCallbackDelayForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CookieManagerProxy.prototype.setPreCommitCallbackDelayForTesting = function(delay) {
    var params_ = new CookieManager_SetPreCommitCallbackDelayForTesting_Params();
    params_.delay = delay;
    var builder = new codec.MessageV0Builder(
        kCookieManager_SetPreCommitCallbackDelayForTesting_Name,
        codec.align(CookieManager_SetPreCommitCallbackDelayForTesting_Params.encodedSize));
    builder.encodeStruct(CookieManager_SetPreCommitCallbackDelayForTesting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CookieManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  CookieManagerStub.prototype.getAllCookies = function() {
    return this.delegate_ && this.delegate_.getAllCookies && this.delegate_.getAllCookies();
  }
  CookieManagerStub.prototype.getAllCookiesWithAccessSemantics = function() {
    return this.delegate_ && this.delegate_.getAllCookiesWithAccessSemantics && this.delegate_.getAllCookiesWithAccessSemantics();
  }
  CookieManagerStub.prototype.getCookieList = function(url, cookieOptions, cookiePartitionKeyCollection) {
    return this.delegate_ && this.delegate_.getCookieList && this.delegate_.getCookieList(url, cookieOptions, cookiePartitionKeyCollection);
  }
  CookieManagerStub.prototype.setCanonicalCookie = function(cookie, sourceUrl, cookieOptions) {
    return this.delegate_ && this.delegate_.setCanonicalCookie && this.delegate_.setCanonicalCookie(cookie, sourceUrl, cookieOptions);
  }
  CookieManagerStub.prototype.deleteCanonicalCookie = function(cookie) {
    return this.delegate_ && this.delegate_.deleteCanonicalCookie && this.delegate_.deleteCanonicalCookie(cookie);
  }
  CookieManagerStub.prototype.deleteCookies = function(filter) {
    return this.delegate_ && this.delegate_.deleteCookies && this.delegate_.deleteCookies(filter);
  }
  CookieManagerStub.prototype.deleteSessionOnlyCookies = function() {
    return this.delegate_ && this.delegate_.deleteSessionOnlyCookies && this.delegate_.deleteSessionOnlyCookies();
  }
  CookieManagerStub.prototype.deleteStaleSessionOnlyCookies = function() {
    return this.delegate_ && this.delegate_.deleteStaleSessionOnlyCookies && this.delegate_.deleteStaleSessionOnlyCookies();
  }
  CookieManagerStub.prototype.addCookieChangeListener = function(url, name, listener) {
    return this.delegate_ && this.delegate_.addCookieChangeListener && this.delegate_.addCookieChangeListener(url, name, listener);
  }
  CookieManagerStub.prototype.addGlobalChangeListener = function(notificationPointer) {
    return this.delegate_ && this.delegate_.addGlobalChangeListener && this.delegate_.addGlobalChangeListener(notificationPointer);
  }
  CookieManagerStub.prototype.cloneInterface = function(newInterface) {
    return this.delegate_ && this.delegate_.cloneInterface && this.delegate_.cloneInterface(newInterface);
  }
  CookieManagerStub.prototype.flushCookieStore = function() {
    return this.delegate_ && this.delegate_.flushCookieStore && this.delegate_.flushCookieStore();
  }
  CookieManagerStub.prototype.allowFileSchemeCookies = function(allow) {
    return this.delegate_ && this.delegate_.allowFileSchemeCookies && this.delegate_.allowFileSchemeCookies(allow);
  }
  CookieManagerStub.prototype.setContentSettings = function(contentSettingsType, settings) {
    return this.delegate_ && this.delegate_.setContentSettings && this.delegate_.setContentSettings(contentSettingsType, settings);
  }
  CookieManagerStub.prototype.setForceKeepSessionState = function() {
    return this.delegate_ && this.delegate_.setForceKeepSessionState && this.delegate_.setForceKeepSessionState();
  }
  CookieManagerStub.prototype.blockThirdPartyCookies = function(block) {
    return this.delegate_ && this.delegate_.blockThirdPartyCookies && this.delegate_.blockThirdPartyCookies(block);
  }
  CookieManagerStub.prototype.setMitigationsEnabledFor3pcd = function(enable) {
    return this.delegate_ && this.delegate_.setMitigationsEnabledFor3pcd && this.delegate_.setMitigationsEnabledFor3pcd(enable);
  }
  CookieManagerStub.prototype.setTrackingProtectionEnabledFor3pcd = function(enable) {
    return this.delegate_ && this.delegate_.setTrackingProtectionEnabledFor3pcd && this.delegate_.setTrackingProtectionEnabledFor3pcd(enable);
  }
  CookieManagerStub.prototype.setPreCommitCallbackDelayForTesting = function(delay) {
    return this.delegate_ && this.delegate_.setPreCommitCallbackDelayForTesting && this.delegate_.setPreCommitCallbackDelayForTesting(delay);
  }

  CookieManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCookieManager_AddCookieChangeListener_Name:
      var params = reader.decodeStruct(CookieManager_AddCookieChangeListener_Params);
      this.addCookieChangeListener(params.url, params.name, params.listener);
      return true;
    case kCookieManager_AddGlobalChangeListener_Name:
      var params = reader.decodeStruct(CookieManager_AddGlobalChangeListener_Params);
      this.addGlobalChangeListener(params.notificationPointer);
      return true;
    case kCookieManager_CloneInterface_Name:
      var params = reader.decodeStruct(CookieManager_CloneInterface_Params);
      this.cloneInterface(params.newInterface);
      return true;
    case kCookieManager_SetForceKeepSessionState_Name:
      var params = reader.decodeStruct(CookieManager_SetForceKeepSessionState_Params);
      this.setForceKeepSessionState();
      return true;
    case kCookieManager_BlockThirdPartyCookies_Name:
      var params = reader.decodeStruct(CookieManager_BlockThirdPartyCookies_Params);
      this.blockThirdPartyCookies(params.block);
      return true;
    case kCookieManager_SetMitigationsEnabledFor3pcd_Name:
      var params = reader.decodeStruct(CookieManager_SetMitigationsEnabledFor3pcd_Params);
      this.setMitigationsEnabledFor3pcd(params.enable);
      return true;
    case kCookieManager_SetTrackingProtectionEnabledFor3pcd_Name:
      var params = reader.decodeStruct(CookieManager_SetTrackingProtectionEnabledFor3pcd_Params);
      this.setTrackingProtectionEnabledFor3pcd(params.enable);
      return true;
    case kCookieManager_SetPreCommitCallbackDelayForTesting_Name:
      var params = reader.decodeStruct(CookieManager_SetPreCommitCallbackDelayForTesting_Params);
      this.setPreCommitCallbackDelayForTesting(params.delay);
      return true;
    default:
      return false;
    }
  };

  CookieManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCookieManager_GetAllCookies_Name:
      var params = reader.decodeStruct(CookieManager_GetAllCookies_Params);
      this.getAllCookies().then(function(response) {
        var responseParams =
            new CookieManager_GetAllCookies_ResponseParams();
        responseParams.cookies = response.cookies;
        var builder = new codec.MessageV1Builder(
            kCookieManager_GetAllCookies_Name,
            codec.align(CookieManager_GetAllCookies_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_GetAllCookies_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_GetAllCookiesWithAccessSemantics_Name:
      var params = reader.decodeStruct(CookieManager_GetAllCookiesWithAccessSemantics_Params);
      this.getAllCookiesWithAccessSemantics().then(function(response) {
        var responseParams =
            new CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams();
        responseParams.cookies = response.cookies;
        responseParams.accessSemanticsList = response.accessSemanticsList;
        var builder = new codec.MessageV1Builder(
            kCookieManager_GetAllCookiesWithAccessSemantics_Name,
            codec.align(CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_GetCookieList_Name:
      var params = reader.decodeStruct(CookieManager_GetCookieList_Params);
      this.getCookieList(params.url, params.cookieOptions, params.cookiePartitionKeyCollection).then(function(response) {
        var responseParams =
            new CookieManager_GetCookieList_ResponseParams();
        responseParams.cookies = response.cookies;
        responseParams.excludedCookies = response.excludedCookies;
        var builder = new codec.MessageV1Builder(
            kCookieManager_GetCookieList_Name,
            codec.align(CookieManager_GetCookieList_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_GetCookieList_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_SetCanonicalCookie_Name:
      var params = reader.decodeStruct(CookieManager_SetCanonicalCookie_Params);
      this.setCanonicalCookie(params.cookie, params.sourceUrl, params.cookieOptions).then(function(response) {
        var responseParams =
            new CookieManager_SetCanonicalCookie_ResponseParams();
        responseParams.accessResult = response.accessResult;
        var builder = new codec.MessageV1Builder(
            kCookieManager_SetCanonicalCookie_Name,
            codec.align(CookieManager_SetCanonicalCookie_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_SetCanonicalCookie_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_DeleteCanonicalCookie_Name:
      var params = reader.decodeStruct(CookieManager_DeleteCanonicalCookie_Params);
      this.deleteCanonicalCookie(params.cookie).then(function(response) {
        var responseParams =
            new CookieManager_DeleteCanonicalCookie_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kCookieManager_DeleteCanonicalCookie_Name,
            codec.align(CookieManager_DeleteCanonicalCookie_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_DeleteCanonicalCookie_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_DeleteCookies_Name:
      var params = reader.decodeStruct(CookieManager_DeleteCookies_Params);
      this.deleteCookies(params.filter).then(function(response) {
        var responseParams =
            new CookieManager_DeleteCookies_ResponseParams();
        responseParams.numDeleted = response.numDeleted;
        var builder = new codec.MessageV1Builder(
            kCookieManager_DeleteCookies_Name,
            codec.align(CookieManager_DeleteCookies_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_DeleteCookies_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_DeleteSessionOnlyCookies_Name:
      var params = reader.decodeStruct(CookieManager_DeleteSessionOnlyCookies_Params);
      this.deleteSessionOnlyCookies().then(function(response) {
        var responseParams =
            new CookieManager_DeleteSessionOnlyCookies_ResponseParams();
        responseParams.numDeleted = response.numDeleted;
        var builder = new codec.MessageV1Builder(
            kCookieManager_DeleteSessionOnlyCookies_Name,
            codec.align(CookieManager_DeleteSessionOnlyCookies_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_DeleteSessionOnlyCookies_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_DeleteStaleSessionOnlyCookies_Name:
      var params = reader.decodeStruct(CookieManager_DeleteStaleSessionOnlyCookies_Params);
      this.deleteStaleSessionOnlyCookies().then(function(response) {
        var responseParams =
            new CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams();
        responseParams.numDeleted = response.numDeleted;
        var builder = new codec.MessageV1Builder(
            kCookieManager_DeleteStaleSessionOnlyCookies_Name,
            codec.align(CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_FlushCookieStore_Name:
      var params = reader.decodeStruct(CookieManager_FlushCookieStore_Params);
      this.flushCookieStore().then(function(response) {
        var responseParams =
            new CookieManager_FlushCookieStore_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kCookieManager_FlushCookieStore_Name,
            codec.align(CookieManager_FlushCookieStore_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_FlushCookieStore_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_AllowFileSchemeCookies_Name:
      var params = reader.decodeStruct(CookieManager_AllowFileSchemeCookies_Params);
      this.allowFileSchemeCookies(params.allow).then(function(response) {
        var responseParams =
            new CookieManager_AllowFileSchemeCookies_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kCookieManager_AllowFileSchemeCookies_Name,
            codec.align(CookieManager_AllowFileSchemeCookies_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_AllowFileSchemeCookies_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCookieManager_SetContentSettings_Name:
      var params = reader.decodeStruct(CookieManager_SetContentSettings_Params);
      this.setContentSettings(params.contentSettingsType, params.settings).then(function(response) {
        var responseParams =
            new CookieManager_SetContentSettings_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kCookieManager_SetContentSettings_Name,
            codec.align(CookieManager_SetContentSettings_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CookieManager_SetContentSettings_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCookieManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCookieManager_GetAllCookies_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_GetAllCookies_Params;
      break;
      case kCookieManager_GetAllCookiesWithAccessSemantics_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_GetAllCookiesWithAccessSemantics_Params;
      break;
      case kCookieManager_GetCookieList_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_GetCookieList_Params;
      break;
      case kCookieManager_SetCanonicalCookie_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_SetCanonicalCookie_Params;
      break;
      case kCookieManager_DeleteCanonicalCookie_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_DeleteCanonicalCookie_Params;
      break;
      case kCookieManager_DeleteCookies_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_DeleteCookies_Params;
      break;
      case kCookieManager_DeleteSessionOnlyCookies_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_DeleteSessionOnlyCookies_Params;
      break;
      case kCookieManager_DeleteStaleSessionOnlyCookies_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_DeleteStaleSessionOnlyCookies_Params;
      break;
      case kCookieManager_AddCookieChangeListener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_AddCookieChangeListener_Params;
      break;
      case kCookieManager_AddGlobalChangeListener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_AddGlobalChangeListener_Params;
      break;
      case kCookieManager_CloneInterface_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_CloneInterface_Params;
      break;
      case kCookieManager_FlushCookieStore_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_FlushCookieStore_Params;
      break;
      case kCookieManager_AllowFileSchemeCookies_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_AllowFileSchemeCookies_Params;
      break;
      case kCookieManager_SetContentSettings_Name:
        if (message.expectsResponse())
          paramsClass = CookieManager_SetContentSettings_Params;
      break;
      case kCookieManager_SetForceKeepSessionState_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_SetForceKeepSessionState_Params;
      break;
      case kCookieManager_BlockThirdPartyCookies_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_BlockThirdPartyCookies_Params;
      break;
      case kCookieManager_SetMitigationsEnabledFor3pcd_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_SetMitigationsEnabledFor3pcd_Params;
      break;
      case kCookieManager_SetTrackingProtectionEnabledFor3pcd_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_SetTrackingProtectionEnabledFor3pcd_Params;
      break;
      case kCookieManager_SetPreCommitCallbackDelayForTesting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CookieManager_SetPreCommitCallbackDelayForTesting_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCookieManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCookieManager_GetAllCookies_Name:
        if (message.isResponse())
          paramsClass = CookieManager_GetAllCookies_ResponseParams;
        break;
      case kCookieManager_GetAllCookiesWithAccessSemantics_Name:
        if (message.isResponse())
          paramsClass = CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams;
        break;
      case kCookieManager_GetCookieList_Name:
        if (message.isResponse())
          paramsClass = CookieManager_GetCookieList_ResponseParams;
        break;
      case kCookieManager_SetCanonicalCookie_Name:
        if (message.isResponse())
          paramsClass = CookieManager_SetCanonicalCookie_ResponseParams;
        break;
      case kCookieManager_DeleteCanonicalCookie_Name:
        if (message.isResponse())
          paramsClass = CookieManager_DeleteCanonicalCookie_ResponseParams;
        break;
      case kCookieManager_DeleteCookies_Name:
        if (message.isResponse())
          paramsClass = CookieManager_DeleteCookies_ResponseParams;
        break;
      case kCookieManager_DeleteSessionOnlyCookies_Name:
        if (message.isResponse())
          paramsClass = CookieManager_DeleteSessionOnlyCookies_ResponseParams;
        break;
      case kCookieManager_DeleteStaleSessionOnlyCookies_Name:
        if (message.isResponse())
          paramsClass = CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams;
        break;
      case kCookieManager_FlushCookieStore_Name:
        if (message.isResponse())
          paramsClass = CookieManager_FlushCookieStore_ResponseParams;
        break;
      case kCookieManager_AllowFileSchemeCookies_Name:
        if (message.isResponse())
          paramsClass = CookieManager_AllowFileSchemeCookies_ResponseParams;
        break;
      case kCookieManager_SetContentSettings_Name:
        if (message.isResponse())
          paramsClass = CookieManager_SetContentSettings_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CookieManager = {
    name: 'network.mojom.CookieManager',
    kVersion: 0,
    ptrClass: CookieManagerPtr,
    proxyClass: CookieManagerProxy,
    stubClass: CookieManagerStub,
    validateRequest: validateCookieManagerRequest,
    validateResponse: validateCookieManagerResponse,
  };
  CookieManagerStub.prototype.validator = validateCookieManagerRequest;
  CookieManagerProxy.prototype.validator = validateCookieManagerResponse;
  exports.CookieAccessDelegateType = CookieAccessDelegateType;
  exports.CookiePriority = CookiePriority;
  exports.CookieSourceScheme = CookieSourceScheme;
  exports.CookieSameSite = CookieSameSite;
  exports.CookieEffectiveSameSite = CookieEffectiveSameSite;
  exports.CookieExemptionReason = CookieExemptionReason;
  exports.ContextType = ContextType;
  exports.CookieSameSiteContextMetadataDowngradeType = CookieSameSiteContextMetadataDowngradeType;
  exports.CookieSourceType = CookieSourceType;
  exports.ContextRedirectTypeBug1221316 = ContextRedirectTypeBug1221316;
  exports.HttpMethod = HttpMethod;
  exports.CookieAccessSemantics = CookieAccessSemantics;
  exports.CookieScopeSemantics = CookieScopeSemantics;
  exports.CookieChangeCause = CookieChangeCause;
  exports.CookieDeletionSessionControl = CookieDeletionSessionControl;
  exports.CookieManagerParams = CookieManagerParams;
  exports.CookieSameSiteContextMetadata = CookieSameSiteContextMetadata;
  exports.CookieSameSiteContext = CookieSameSiteContext;
  exports.CookieOptions = CookieOptions;
  exports.CanonicalCookie = CanonicalCookie;
  exports.ExclusionReasons = ExclusionReasons;
  exports.WarningReasons = WarningReasons;
  exports.CookieInclusionStatus = CookieInclusionStatus;
  exports.CookieAndLineWithAccessResult = CookieAndLineWithAccessResult;
  exports.CookieOrLineWithAccessResult = CookieOrLineWithAccessResult;
  exports.CookieAccessResult = CookieAccessResult;
  exports.CookieWithAccessResult = CookieWithAccessResult;
  exports.CookieChangeInfo = CookieChangeInfo;
  exports.CookieDeletionFilter = CookieDeletionFilter;
  exports.CookieOrLine = CookieOrLine;
  exports.CookieChangeListener = CookieChangeListener;
  exports.CookieChangeListenerPtr = CookieChangeListenerPtr;
  exports.CookieChangeListenerAssociatedPtr = CookieChangeListenerAssociatedPtr;
  exports.CookieManager = CookieManager;
  exports.CookieManagerPtr = CookieManagerPtr;
  exports.CookieManagerAssociatedPtr = CookieManagerAssociatedPtr;
})();