// services/network/public/mojom/cookie_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cookie_manager.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "components/content_settings/core/common/content_settings_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/cookie_manager.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::CookieAccessDelegateType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieAccessDelegateType> {};

template <>
struct hash<::network::mojom::CookiePriority>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookiePriority> {};

template <>
struct hash<::network::mojom::CookieSourceScheme>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieSourceScheme> {};

template <>
struct hash<::network::mojom::CookieSameSite>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieSameSite> {};

template <>
struct hash<::network::mojom::CookieEffectiveSameSite>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieEffectiveSameSite> {};

template <>
struct hash<::network::mojom::CookieExemptionReason>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieExemptionReason> {};

template <>
struct hash<::network::mojom::ContextType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContextType> {};

template <>
struct hash<::network::mojom::CookieSameSiteContextMetadataDowngradeType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieSameSiteContextMetadataDowngradeType> {};

template <>
struct hash<::network::mojom::CookieSourceType>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieSourceType> {};

template <>
struct hash<::network::mojom::ContextRedirectTypeBug1221316>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContextRedirectTypeBug1221316> {};

template <>
struct hash<::network::mojom::HttpMethod>
    : public mojo::internal::EnumHashImpl<::network::mojom::HttpMethod> {};

template <>
struct hash<::network::mojom::CookieAccessSemantics>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieAccessSemantics> {};

template <>
struct hash<::network::mojom::CookieScopeSemantics>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieScopeSemantics> {};

template <>
struct hash<::network::mojom::CookieChangeCause>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieChangeCause> {};

template <>
struct hash<::network::mojom::CookieDeletionSessionControl>
    : public mojo::internal::EnumHashImpl<::network::mojom::CookieDeletionSessionControl> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessDelegateType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieAccessDelegateType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieAccessDelegateType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookiePriority, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookiePriority, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookiePriority>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSourceScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieSourceScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieSourceScheme>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSameSite, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieSameSite, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieSameSite>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieEffectiveSameSite, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieEffectiveSameSite, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieEffectiveSameSite>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieExemptionReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieExemptionReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieExemptionReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContextType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContextType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ContextType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSameSiteContextMetadataDowngradeType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieSameSiteContextMetadataDowngradeType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieSameSiteContextMetadataDowngradeType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSourceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieSourceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieSourceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContextRedirectTypeBug1221316, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContextRedirectTypeBug1221316, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ContextRedirectTypeBug1221316>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpMethod, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::HttpMethod, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::HttpMethod>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessSemantics, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieAccessSemantics, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieAccessSemantics>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieScopeSemantics, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieScopeSemantics, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieScopeSemantics>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieChangeCause, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieChangeCause, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieChangeCause>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieDeletionSessionControl, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CookieDeletionSessionControl, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CookieDeletionSessionControl>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieManagerParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieManagerParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieManagerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->block_third_party_cookies = Traits::block_third_party_cookies(input);

    fragment->tracking_protection_enabled_for_3pcd = Traits::tracking_protection_enabled_for_3pcd(input);

    fragment->mitigations_enabled_for_3pcd = Traits::mitigations_enabled_for_3pcd(input);

    decltype(Traits::content_settings(input)) in_content_settings = Traits::content_settings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_settings)::BaseType>
        content_settings_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_settings_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::content_settings::mojom::internal::ContentSettingsType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::content_settings::mojom::ContentSettingsType, mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>>(
      in_content_settings,
      content_settings_fragment,
      &content_settings_validate_params);

    fragment->content_settings.Set(
        content_settings_fragment.is_null() ? nullptr : content_settings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_settings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_settings in CookieManagerParams struct");

    decltype(Traits::secure_origin_cookies_allowed_schemes(input)) in_secure_origin_cookies_allowed_schemes = Traits::secure_origin_cookies_allowed_schemes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->secure_origin_cookies_allowed_schemes)::BaseType>
        secure_origin_cookies_allowed_schemes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& secure_origin_cookies_allowed_schemes_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_secure_origin_cookies_allowed_schemes,
      secure_origin_cookies_allowed_schemes_fragment,
      &secure_origin_cookies_allowed_schemes_validate_params);

    fragment->secure_origin_cookies_allowed_schemes.Set(
        secure_origin_cookies_allowed_schemes_fragment.is_null() ? nullptr : secure_origin_cookies_allowed_schemes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->secure_origin_cookies_allowed_schemes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null secure_origin_cookies_allowed_schemes in CookieManagerParams struct");

    decltype(Traits::matching_scheme_cookies_allowed_schemes(input)) in_matching_scheme_cookies_allowed_schemes = Traits::matching_scheme_cookies_allowed_schemes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->matching_scheme_cookies_allowed_schemes)::BaseType>
        matching_scheme_cookies_allowed_schemes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& matching_scheme_cookies_allowed_schemes_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_matching_scheme_cookies_allowed_schemes,
      matching_scheme_cookies_allowed_schemes_fragment,
      &matching_scheme_cookies_allowed_schemes_validate_params);

    fragment->matching_scheme_cookies_allowed_schemes.Set(
        matching_scheme_cookies_allowed_schemes_fragment.is_null() ? nullptr : matching_scheme_cookies_allowed_schemes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->matching_scheme_cookies_allowed_schemes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null matching_scheme_cookies_allowed_schemes in CookieManagerParams struct");

    decltype(Traits::third_party_cookies_allowed_schemes(input)) in_third_party_cookies_allowed_schemes = Traits::third_party_cookies_allowed_schemes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->third_party_cookies_allowed_schemes)::BaseType>
        third_party_cookies_allowed_schemes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& third_party_cookies_allowed_schemes_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_third_party_cookies_allowed_schemes,
      third_party_cookies_allowed_schemes_fragment,
      &third_party_cookies_allowed_schemes_validate_params);

    fragment->third_party_cookies_allowed_schemes.Set(
        third_party_cookies_allowed_schemes_fragment.is_null() ? nullptr : third_party_cookies_allowed_schemes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->third_party_cookies_allowed_schemes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null third_party_cookies_allowed_schemes in CookieManagerParams struct");

    fragment->allow_file_scheme_cookies = Traits::allow_file_scheme_cookies(input);

    
    mojo::internal::Serialize<::network::mojom::CookieAccessDelegateType>(
      Traits::cookie_access_delegate_type(input),
      &fragment->cookie_access_delegate_type);
  }

  static bool Deserialize(::network::mojom::internal::CookieManagerParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieManagerParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSameSiteContextMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieSameSiteContextMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieSameSiteContextMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::CookieSameSiteContextMetadataDowngradeType>(
      Traits::cross_site_redirect_downgrade(input),
      &fragment->cross_site_redirect_downgrade);

    
    mojo::internal::Serialize<::network::mojom::ContextRedirectTypeBug1221316>(
      Traits::redirect_type_bug_1221316(input),
      &fragment->redirect_type_bug_1221316);
  }

  static bool Deserialize(::network::mojom::internal::CookieSameSiteContextMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieSameSiteContextMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieSameSiteContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieSameSiteContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieSameSiteContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::ContextType>(
      Traits::context(input),
      &fragment->context);

    
    mojo::internal::Serialize<::network::mojom::ContextType>(
      Traits::schemeful_context(input),
      &fragment->schemeful_context);

    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieSameSiteContextMetadataDataView>(
      in_metadata,
      metadata_fragment);

    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->metadata.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in CookieSameSiteContext struct");

    decltype(Traits::schemeful_metadata(input)) in_schemeful_metadata = Traits::schemeful_metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->schemeful_metadata)::BaseType> schemeful_metadata_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieSameSiteContextMetadataDataView>(
      in_schemeful_metadata,
      schemeful_metadata_fragment);

    fragment->schemeful_metadata.Set(
        schemeful_metadata_fragment.is_null() ? nullptr : schemeful_metadata_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->schemeful_metadata.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null schemeful_metadata in CookieSameSiteContext struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieSameSiteContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieSameSiteContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->exclude_httponly = Traits::exclude_httponly(input);

    decltype(Traits::same_site_cookie_context(input)) in_same_site_cookie_context = Traits::same_site_cookie_context(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->same_site_cookie_context)::BaseType> same_site_cookie_context_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieSameSiteContextDataView>(
      in_same_site_cookie_context,
      same_site_cookie_context_fragment);

    fragment->same_site_cookie_context.Set(
        same_site_cookie_context_fragment.is_null() ? nullptr : same_site_cookie_context_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->same_site_cookie_context.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null same_site_cookie_context in CookieOptions struct");

    fragment->update_access_time = Traits::update_access_time(input);

    fragment->return_excluded_cookies = Traits::return_excluded_cookies(input);
  }

  static bool Deserialize(::network::mojom::internal::CookieOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CanonicalCookieDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CanonicalCookieDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CanonicalCookie_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in CanonicalCookie struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in CanonicalCookie struct");

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in CanonicalCookie struct");

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in CanonicalCookie struct");

    decltype(Traits::creation(input)) in_creation = Traits::creation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation)::BaseType> creation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_creation,
      creation_fragment);

    fragment->creation.Set(
        creation_fragment.is_null() ? nullptr : creation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation in CanonicalCookie struct");

    decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiry)::BaseType> expiry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expiry,
      expiry_fragment);

    fragment->expiry.Set(
        expiry_fragment.is_null() ? nullptr : expiry_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->expiry.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiry in CanonicalCookie struct");

    decltype(Traits::last_access(input)) in_last_access = Traits::last_access(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_access)::BaseType> last_access_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_access,
      last_access_fragment);

    fragment->last_access.Set(
        last_access_fragment.is_null() ? nullptr : last_access_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_access.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_access in CanonicalCookie struct");

    decltype(Traits::last_update(input)) in_last_update = Traits::last_update(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_update)::BaseType> last_update_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_update,
      last_update_fragment);

    fragment->last_update.Set(
        last_update_fragment.is_null() ? nullptr : last_update_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_update.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_update in CanonicalCookie struct");

    fragment->secure = Traits::secure(input);

    fragment->httponly = Traits::httponly(input);

    
    mojo::internal::Serialize<::network::mojom::CookieSameSite>(
      Traits::site_restrictions(input),
      &fragment->site_restrictions);

    
    mojo::internal::Serialize<::network::mojom::CookiePriority>(
      Traits::priority(input),
      &fragment->priority);

    
    mojo::internal::Serialize<::network::mojom::CookieSourceScheme>(
      Traits::source_scheme(input),
      &fragment->source_scheme);

    decltype(Traits::partition_key(input)) in_partition_key = Traits::partition_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partition_key)::BaseType> partition_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookiePartitionKeyDataView>(
      in_partition_key,
      partition_key_fragment);

    fragment->partition_key.Set(
        partition_key_fragment.is_null() ? nullptr : partition_key_fragment.data());

    fragment->source_port = Traits::source_port(input);

    
    mojo::internal::Serialize<::network::mojom::CookieSourceType>(
      Traits::source_type(input),
      &fragment->source_type);
  }

  static bool Deserialize(::network::mojom::internal::CanonicalCookie_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CanonicalCookieDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ExclusionReasonsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ExclusionReasonsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ExclusionReasons_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->exclusions_bitmask = Traits::exclusions_bitmask(input);
  }

  static bool Deserialize(::network::mojom::internal::ExclusionReasons_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ExclusionReasonsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WarningReasonsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WarningReasonsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WarningReasons_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->warnings_bitmask = Traits::warnings_bitmask(input);
  }

  static bool Deserialize(::network::mojom::internal::WarningReasons_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WarningReasonsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieInclusionStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieInclusionStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieInclusionStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::exclusion_reasons(input)) in_exclusion_reasons = Traits::exclusion_reasons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclusion_reasons)::BaseType> exclusion_reasons_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ExclusionReasonsDataView>(
      in_exclusion_reasons,
      exclusion_reasons_fragment);

    fragment->exclusion_reasons.Set(
        exclusion_reasons_fragment.is_null() ? nullptr : exclusion_reasons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->exclusion_reasons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null exclusion_reasons in CookieInclusionStatus struct");

    decltype(Traits::warning_reasons(input)) in_warning_reasons = Traits::warning_reasons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->warning_reasons)::BaseType> warning_reasons_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::WarningReasonsDataView>(
      in_warning_reasons,
      warning_reasons_fragment);

    fragment->warning_reasons.Set(
        warning_reasons_fragment.is_null() ? nullptr : warning_reasons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->warning_reasons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null warning_reasons in CookieInclusionStatus struct");

    
    mojo::internal::Serialize<::network::mojom::CookieExemptionReason>(
      Traits::exemption_reason(input),
      &fragment->exemption_reason);
  }

  static bool Deserialize(::network::mojom::internal::CookieInclusionStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieInclusionStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAndLineWithAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAndLineWithAccessResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieAndLineWithAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie)::BaseType> cookie_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie,
      cookie_fragment);

    fragment->cookie.Set(
        cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

    decltype(Traits::cookie_string(input)) in_cookie_string = Traits::cookie_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_string)::BaseType> cookie_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cookie_string,
      cookie_string_fragment);

    fragment->cookie_string.Set(
        cookie_string_fragment.is_null() ? nullptr : cookie_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_string in CookieAndLineWithAccessResult struct");

    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_result)::BaseType> access_result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
      in_access_result,
      access_result_fragment);

    fragment->access_result.Set(
        access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_result in CookieAndLineWithAccessResult struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieAndLineWithAccessResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieAndLineWithAccessResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieOrLineWithAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieOrLineWithAccessResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieOrLineWithAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cookie_or_line(input)) in_cookie_or_line = Traits::cookie_or_line(input);
    mojo::internal::MessageFragment<decltype(fragment->cookie_or_line)>
        cookie_or_line_fragment(fragment.message());
    cookie_or_line_fragment.Claim(&fragment->cookie_or_line);
    
    mojo::internal::Serialize<::network::mojom::CookieOrLineDataView>(
      in_cookie_or_line,
      cookie_or_line_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie_or_line.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie_or_line in CookieOrLineWithAccessResult struct");

    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_result)::BaseType> access_result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
      in_access_result,
      access_result_fragment);

    fragment->access_result.Set(
        access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_result in CookieOrLineWithAccessResult struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieOrLineWithAccessResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieOrLineWithAccessResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAccessResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::CookieEffectiveSameSite>(
      Traits::effective_same_site(input),
      &fragment->effective_same_site);

    
    mojo::internal::Serialize<::network::mojom::CookieAccessSemantics>(
      Traits::access_semantics(input),
      &fragment->access_semantics);

    
    mojo::internal::Serialize<::network::mojom::CookieScopeSemantics>(
      Traits::scope_semantics(input),
      &fragment->scope_semantics);

    decltype(Traits::status(input)) in_status = Traits::status(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->status)::BaseType> status_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieInclusionStatusDataView>(
      in_status,
      status_fragment);

    fragment->status.Set(
        status_fragment.is_null() ? nullptr : status_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->status.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in CookieAccessResult struct");

    fragment->is_allowed_to_access_secure_cookies = Traits::is_allowed_to_access_secure_cookies(input);
  }

  static bool Deserialize(::network::mojom::internal::CookieAccessResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieAccessResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieWithAccessResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieWithAccessResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieWithAccessResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie)::BaseType> cookie_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie,
      cookie_fragment);

    fragment->cookie.Set(
        cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieWithAccessResult struct");

    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_result)::BaseType> access_result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
      in_access_result,
      access_result_fragment);

    fragment->access_result.Set(
        access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_result in CookieWithAccessResult struct");
  }

  static bool Deserialize(::network::mojom::internal::CookieWithAccessResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieWithAccessResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieChangeInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieChangeInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieChangeInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie)::BaseType> cookie_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
      in_cookie,
      cookie_fragment);

    fragment->cookie.Set(
        cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieChangeInfo struct");

    decltype(Traits::access_result(input)) in_access_result = Traits::access_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_result)::BaseType> access_result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookieAccessResultDataView>(
      in_access_result,
      access_result_fragment);

    fragment->access_result.Set(
        access_result_fragment.is_null() ? nullptr : access_result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_result in CookieChangeInfo struct");

    
    mojo::internal::Serialize<::network::mojom::CookieChangeCause>(
      Traits::cause(input),
      &fragment->cause);
  }

  static bool Deserialize(::network::mojom::internal::CookieChangeInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieChangeInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieDeletionFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieDeletionFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieDeletionFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::created_after_time(input)) in_created_after_time = Traits::created_after_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->created_after_time)::BaseType> created_after_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_created_after_time,
      created_after_time_fragment);

    fragment->created_after_time.Set(
        created_after_time_fragment.is_null() ? nullptr : created_after_time_fragment.data());

    decltype(Traits::created_before_time(input)) in_created_before_time = Traits::created_before_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->created_before_time)::BaseType> created_before_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_created_before_time,
      created_before_time_fragment);

    fragment->created_before_time.Set(
        created_before_time_fragment.is_null() ? nullptr : created_before_time_fragment.data());

    decltype(Traits::excluding_domains(input)) in_excluding_domains = Traits::excluding_domains(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->excluding_domains)::BaseType>
        excluding_domains_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& excluding_domains_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_excluding_domains,
      excluding_domains_fragment,
      &excluding_domains_validate_params);

    fragment->excluding_domains.Set(
        excluding_domains_fragment.is_null() ? nullptr : excluding_domains_fragment.data());

    decltype(Traits::including_domains(input)) in_including_domains = Traits::including_domains(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->including_domains)::BaseType>
        including_domains_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& including_domains_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_including_domains,
      including_domains_fragment,
      &including_domains_validate_params);

    fragment->including_domains.Set(
        including_domains_fragment.is_null() ? nullptr : including_domains_fragment.data());

    decltype(Traits::cookie_name(input)) in_cookie_name = Traits::cookie_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_name)::BaseType> cookie_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_cookie_name,
      cookie_name_fragment);

    fragment->cookie_name.Set(
        cookie_name_fragment.is_null() ? nullptr : cookie_name_fragment.data());

    decltype(Traits::host_name(input)) in_host_name = Traits::host_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_name)::BaseType> host_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_host_name,
      host_name_fragment);

    fragment->host_name.Set(
        host_name_fragment.is_null() ? nullptr : host_name_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::CookieDeletionSessionControl>(
      Traits::session_control(input),
      &fragment->session_control);

    decltype(Traits::cookie_partition_key_collection(input)) in_cookie_partition_key_collection = Traits::cookie_partition_key_collection(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_partition_key_collection)::BaseType> cookie_partition_key_collection_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CookiePartitionKeyCollectionDataView>(
      in_cookie_partition_key_collection,
      cookie_partition_key_collection_fragment);

    fragment->cookie_partition_key_collection.Set(
        cookie_partition_key_collection_fragment.is_null() ? nullptr : cookie_partition_key_collection_fragment.data());

    fragment->partitioned_state_only = Traits::partitioned_state_only(input);
  }

  static bool Deserialize(::network::mojom::internal::CookieDeletionFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieDeletionFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CookieOrLineDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::CookieOrLineDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::CookieOrLine_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::CookieOrLineDataView::Tag::kCookie: {
    decltype(Traits::cookie(input))
    in_cookie = Traits::cookie(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cookie)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
  in_cookie,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cookie in CookieOrLine union");
    fragment->data.f_cookie.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::CookieOrLineDataView::Tag::kCookieString: {
    decltype(Traits::cookie_string(input))
    in_cookie_string = Traits::cookie_string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cookie_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_cookie_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cookie_string in CookieOrLine union");
    fragment->data.f_cookie_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::CookieOrLine_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CookieOrLineDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CookieManagerParamsDataView::GetContentSettingsDataView(
    mojo::MapDataView<::content_settings::mojom::ContentSettingsType, mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>* output) {
  auto pointer = data_->content_settings.Get();
  *output = mojo::MapDataView<::content_settings::mojom::ContentSettingsType, mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(pointer, message_);
}
inline void CookieManagerParamsDataView::GetSecureOriginCookiesAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->secure_origin_cookies_allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CookieManagerParamsDataView::GetMatchingSchemeCookiesAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->matching_scheme_cookies_allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CookieManagerParamsDataView::GetThirdPartyCookiesAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->third_party_cookies_allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}




inline void CookieSameSiteContextDataView::GetMetadataDataView(
    CookieSameSiteContextMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = CookieSameSiteContextMetadataDataView(pointer, message_);
}
inline void CookieSameSiteContextDataView::GetSchemefulMetadataDataView(
    CookieSameSiteContextMetadataDataView* output) {
  auto pointer = data_->schemeful_metadata.Get();
  *output = CookieSameSiteContextMetadataDataView(pointer, message_);
}


inline void CookieOptionsDataView::GetSameSiteCookieContextDataView(
    CookieSameSiteContextDataView* output) {
  auto pointer = data_->same_site_cookie_context.Get();
  *output = CookieSameSiteContextDataView(pointer, message_);
}


inline void CanonicalCookieDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetCreationDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->creation.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetExpiryDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiry.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetLastAccessDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_access.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetLastUpdateDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_update.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CanonicalCookieDataView::GetPartitionKeyDataView(
    ::network::mojom::CookiePartitionKeyDataView* output) {
  auto pointer = data_->partition_key.Get();
  *output = ::network::mojom::CookiePartitionKeyDataView(pointer, message_);
}






inline void CookieInclusionStatusDataView::GetExclusionReasonsDataView(
    ExclusionReasonsDataView* output) {
  auto pointer = data_->exclusion_reasons.Get();
  *output = ExclusionReasonsDataView(pointer, message_);
}
inline void CookieInclusionStatusDataView::GetWarningReasonsDataView(
    WarningReasonsDataView* output) {
  auto pointer = data_->warning_reasons.Get();
  *output = WarningReasonsDataView(pointer, message_);
}


inline void CookieAndLineWithAccessResultDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, message_);
}
inline void CookieAndLineWithAccessResultDataView::GetCookieStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieAndLineWithAccessResultDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, message_);
}


inline void CookieOrLineWithAccessResultDataView::GetCookieOrLineDataView(
    CookieOrLineDataView* output) {
  auto pointer = &data_->cookie_or_line;
  *output = CookieOrLineDataView(pointer, message_);
}
inline void CookieOrLineWithAccessResultDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, message_);
}


inline void CookieAccessResultDataView::GetStatusDataView(
    CookieInclusionStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = CookieInclusionStatusDataView(pointer, message_);
}


inline void CookieWithAccessResultDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, message_);
}
inline void CookieWithAccessResultDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, message_);
}


inline void CookieChangeInfoDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, message_);
}
inline void CookieChangeInfoDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, message_);
}


inline void CookieDeletionFilterDataView::GetCreatedAfterTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->created_after_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetCreatedBeforeTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->created_before_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetExcludingDomainsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excluding_domains.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetIncludingDomainsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->including_domains.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetCookieNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetHostNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieDeletionFilterDataView::GetCookiePartitionKeyCollectionDataView(
    ::network::mojom::CookiePartitionKeyCollectionDataView* output) {
  auto pointer = data_->cookie_partition_key_collection.Get();
  *output = ::network::mojom::CookiePartitionKeyCollectionDataView(pointer, message_);
}


inline void CookieOrLineDataView::GetCookieDataView(
    CanonicalCookieDataView* output) const {
  CHECK(is_cookie());
  *output = CanonicalCookieDataView(data_->data.f_cookie.Get(), message_);
}
inline void CookieOrLineDataView::GetCookieStringDataView(
    mojo::StringDataView* output) const {
  CHECK(is_cookie_string());
  *output = mojo::StringDataView(data_->data.f_cookie_string.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieAccessDelegateType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieAccessDelegateType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookiePriority> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookiePriority value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieSourceScheme> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieSourceScheme value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieSameSite> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieSameSite value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieEffectiveSameSite> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieEffectiveSameSite value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieExemptionReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieExemptionReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ContextType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ContextType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieSameSiteContextMetadataDowngradeType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieSameSiteContextMetadataDowngradeType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieSourceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieSourceType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ContextRedirectTypeBug1221316> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ContextRedirectTypeBug1221316 value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::HttpMethod> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::HttpMethod value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieAccessSemantics> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieAccessSemantics value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieScopeSemantics> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieScopeSemantics value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieChangeCause> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieChangeCause value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CookieDeletionSessionControl> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CookieDeletionSessionControl value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_SHARED_H_