// services/network/public/mojom/connection_change_observer_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/connection_change_observer_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-params-data.h"
#include "services/network/public/mojom/connection_change_observer_client.mojom-shared-message-ids.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-import-headers.h"
#include "services/network/public/mojom/connection_change_observer_client.mojom-test-utils.h"


namespace network::mojom {
ConnectionKeepAliveConfig::ConnectionKeepAliveConfig()
    : idle_timeout_in_seconds(0),
      ping_interval_in_seconds(0),
      enable_connection_keep_alive(false),
      quic_connection_options("") {}

ConnectionKeepAliveConfig::ConnectionKeepAliveConfig(
    int32_t idle_timeout_in_seconds_in,
    int32_t ping_interval_in_seconds_in,
    bool enable_connection_keep_alive_in,
    const std::string& quic_connection_options_in)
    : idle_timeout_in_seconds(std::move(idle_timeout_in_seconds_in)),
      ping_interval_in_seconds(std::move(ping_interval_in_seconds_in)),
      enable_connection_keep_alive(std::move(enable_connection_keep_alive_in)),
      quic_connection_options(std::move(quic_connection_options_in)) {}

ConnectionKeepAliveConfig::~ConnectionKeepAliveConfig() = default;

void ConnectionKeepAliveConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "idle_timeout_in_seconds"), this->idle_timeout_in_seconds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ping_interval_in_seconds"), this->ping_interval_in_seconds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_connection_keep_alive"), this->enable_connection_keep_alive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quic_connection_options"), this->quic_connection_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConnectionKeepAliveConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ConnectionChangeObserverClient::IPCStableHashFunction ConnectionChangeObserverClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ConnectionChangeObserverClient>(message.name())) {
    case messages::ConnectionChangeObserverClient::kOnSessionClosed: {
      return &ConnectionChangeObserverClient::OnSessionClosed_Sym::IPCStableHash;
    }
    case messages::ConnectionChangeObserverClient::kOnNetworkEvent: {
      return &ConnectionChangeObserverClient::OnNetworkEvent_Sym::IPCStableHash;
    }
    case messages::ConnectionChangeObserverClient::kOnConnectionFailed: {
      return &ConnectionChangeObserverClient::OnConnectionFailed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ConnectionChangeObserverClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ConnectionChangeObserverClient>(message.name())) {
      case messages::ConnectionChangeObserverClient::kOnSessionClosed:
            return "Receive network::mojom::ConnectionChangeObserverClient::OnSessionClosed";
      case messages::ConnectionChangeObserverClient::kOnNetworkEvent:
            return "Receive network::mojom::ConnectionChangeObserverClient::OnNetworkEvent";
      case messages::ConnectionChangeObserverClient::kOnConnectionFailed:
            return "Receive network::mojom::ConnectionChangeObserverClient::OnConnectionFailed";
    }
  } else {
    switch (static_cast<messages::ConnectionChangeObserverClient>(message.name())) {
      case messages::ConnectionChangeObserverClient::kOnSessionClosed:
            return "Receive reply network::mojom::ConnectionChangeObserverClient::OnSessionClosed";
      case messages::ConnectionChangeObserverClient::kOnNetworkEvent:
            return "Receive reply network::mojom::ConnectionChangeObserverClient::OnNetworkEvent";
      case messages::ConnectionChangeObserverClient::kOnConnectionFailed:
            return "Receive reply network::mojom::ConnectionChangeObserverClient::OnConnectionFailed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ConnectionChangeObserverClient::OnSessionClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8fed8f09;  // IPCStableHash for network::mojom::ConnectionChangeObserverClient::OnSessionClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ConnectionChangeObserverClient::OnNetworkEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca0660d4;  // IPCStableHash for network::mojom::ConnectionChangeObserverClient::OnNetworkEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ConnectionChangeObserverClient::OnConnectionFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfaba568d;  // IPCStableHash for network::mojom::ConnectionChangeObserverClient::OnConnectionFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ConnectionChangeObserverClientProxy::ConnectionChangeObserverClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ConnectionChangeObserverClientProxy::OnSessionClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ConnectionChangeObserverClient::OnSessionClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ConnectionChangeObserverClient::kOnSessionClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ConnectionChangeObserverClient_OnSessionClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConnectionChangeObserverClient::Name_);
  message.set_method_name("OnSessionClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ConnectionChangeObserverClientProxy::OnNetworkEvent(
    ::net::NetworkChangeEvent in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ConnectionChangeObserverClient::OnNetworkEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::net::NetworkChangeEvent>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ConnectionChangeObserverClient::kOnNetworkEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ConnectionChangeObserverClient_OnNetworkEvent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::NetworkChangeEvent>(
    in_event,
    &params->event);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConnectionChangeObserverClient::Name_);
  message.set_method_name("OnNetworkEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ConnectionChangeObserverClientProxy::OnConnectionFailed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ConnectionChangeObserverClient::OnConnectionFailed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ConnectionChangeObserverClient::kOnConnectionFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ConnectionChangeObserverClient_OnConnectionFailed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ConnectionChangeObserverClient::Name_);
  message.set_method_name("OnConnectionFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ConnectionChangeObserverClientStubDispatch::Accept(
    ConnectionChangeObserverClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ConnectionChangeObserverClient>(message->header()->name)) {
    case messages::ConnectionChangeObserverClient::kOnSessionClosed: {
      DCHECK(message->is_serialized());
      internal::ConnectionChangeObserverClient_OnSessionClosed_Params_Data* params =
          reinterpret_cast<internal::ConnectionChangeObserverClient_OnSessionClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ConnectionChangeObserverClient.0
      bool success = true;
      ConnectionChangeObserverClient_OnSessionClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConnectionChangeObserverClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionClosed(        );
      return true;
    }
    case messages::ConnectionChangeObserverClient::kOnNetworkEvent: {
      DCHECK(message->is_serialized());
      internal::ConnectionChangeObserverClient_OnNetworkEvent_Params_Data* params =
          reinterpret_cast<internal::ConnectionChangeObserverClient_OnNetworkEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ConnectionChangeObserverClient.1
      bool success = true;
      ::net::NetworkChangeEvent p_event{};
      ConnectionChangeObserverClient_OnNetworkEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConnectionChangeObserverClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkEvent(        
        std::move(p_event));
      return true;
    }
    case messages::ConnectionChangeObserverClient::kOnConnectionFailed: {
      DCHECK(message->is_serialized());
      internal::ConnectionChangeObserverClient_OnConnectionFailed_Params_Data* params =
          reinterpret_cast<internal::ConnectionChangeObserverClient_OnConnectionFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ConnectionChangeObserverClient.2
      bool success = true;
      ConnectionChangeObserverClient_OnConnectionFailed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ConnectionChangeObserverClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnConnectionFailed(        );
      return true;
    }
  }
  return false;
}

// static
bool ConnectionChangeObserverClientStubDispatch::AcceptWithResponder(
    ConnectionChangeObserverClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ConnectionChangeObserverClient>(message->header()->name)) {
    case messages::ConnectionChangeObserverClient::kOnSessionClosed: {
      break;
    }
    case messages::ConnectionChangeObserverClient::kOnNetworkEvent: {
      break;
    }
    case messages::ConnectionChangeObserverClient::kOnConnectionFailed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kConnectionChangeObserverClientValidationInfo[] = {
    { &internal::ConnectionChangeObserverClient_OnSessionClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ConnectionChangeObserverClient_OnNetworkEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ConnectionChangeObserverClient_OnConnectionFailed_Params_Data::Validate,
     nullptr /* no response */},
};

bool ConnectionChangeObserverClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::ConnectionChangeObserverClient::Name_,
    kConnectionChangeObserverClientValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ConnectionKeepAliveConfig::DataView, ::network::mojom::ConnectionKeepAliveConfigPtr>::Read(
    ::network::mojom::ConnectionKeepAliveConfig::DataView input,
    ::network::mojom::ConnectionKeepAliveConfigPtr* output) {
  bool success = true;
  ::network::mojom::ConnectionKeepAliveConfigPtr result(::network::mojom::ConnectionKeepAliveConfig::New());
  
      if (success)
        result->idle_timeout_in_seconds = input.idle_timeout_in_seconds();
      if (success)
        result->ping_interval_in_seconds = input.ping_interval_in_seconds();
      if (success)
        result->enable_connection_keep_alive = input.enable_connection_keep_alive();
      if (success && !input.ReadQuicConnectionOptions(&result->quic_connection_options))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void ConnectionChangeObserverClientInterceptorForTesting::OnSessionClosed() {
  GetForwardingInterface()->OnSessionClosed();
}
void ConnectionChangeObserverClientInterceptorForTesting::OnNetworkEvent(::net::NetworkChangeEvent event) {
  GetForwardingInterface()->OnNetworkEvent(
    std::move(event)
    );
}
void ConnectionChangeObserverClientInterceptorForTesting::OnConnectionFailed() {
  GetForwardingInterface()->OnConnectionFailed();
}
ConnectionChangeObserverClientAsyncWaiter::ConnectionChangeObserverClientAsyncWaiter(
    ConnectionChangeObserverClient* proxy) : proxy_(proxy) {}

ConnectionChangeObserverClientAsyncWaiter::~ConnectionChangeObserverClientAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif