// services/network/public/mojom/connection_change_observer_client.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-shared-internal.h"


namespace network::mojom {
class ConnectionKeepAliveConfigDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ConnectionKeepAliveConfigDataView> {
  using Data = ::network::mojom::internal::ConnectionKeepAliveConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class NetworkChangeEvent : int32_t {
  
  kSoonToDisconnect = 0,
  
  kDisconnected = 1,
  
  kConnected = 2,
  
  kDefaultNetworkChanged = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, NetworkChangeEvent value);
inline bool IsKnownEnumValue(NetworkChangeEvent value) {
  return internal::NetworkChangeEvent_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ConnectionChangeObserverClientInterfaceBase {};

using ConnectionChangeObserverClientPtrDataView =
    mojo::InterfacePtrDataView<ConnectionChangeObserverClientInterfaceBase>;
using ConnectionChangeObserverClientRequestDataView =
    mojo::InterfaceRequestDataView<ConnectionChangeObserverClientInterfaceBase>;
using ConnectionChangeObserverClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ConnectionChangeObserverClientInterfaceBase>;
using ConnectionChangeObserverClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ConnectionChangeObserverClientInterfaceBase>;


class ConnectionKeepAliveConfigDataView {
 public:
  ConnectionKeepAliveConfigDataView() = default;

  ConnectionKeepAliveConfigDataView(
      internal::ConnectionKeepAliveConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t idle_timeout_in_seconds() const {
    return data_->idle_timeout_in_seconds;
  }
  int32_t ping_interval_in_seconds() const {
    return data_->ping_interval_in_seconds;
  }
  bool enable_connection_keep_alive() const {
    return data_->enable_connection_keep_alive;
  }
  inline void GetQuicConnectionOptionsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuicConnectionOptions(UserType* output) {
    
    auto* pointer = data_->quic_connection_options.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ConnectionKeepAliveConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_DATA_VIEW_H_