// services/network/public/mojom/connection_allowlist.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/connection_allowlist.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');


  var ConnectionAllowlistIssue = {};
  ConnectionAllowlistIssue.kInvalidHeader = 0;
  ConnectionAllowlistIssue.kMoreThanOneList = 1;
  ConnectionAllowlistIssue.kItemNotInnerList = 2;
  ConnectionAllowlistIssue.kInvalidAllowlistItemType = 3;
  ConnectionAllowlistIssue.kReportingEndpointNotToken = 4;
  ConnectionAllowlistIssue.MIN_VALUE = 0;
  ConnectionAllowlistIssue.MAX_VALUE = 4;

  ConnectionAllowlistIssue.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ConnectionAllowlistIssue.toKnownEnumValue = function(value) {
    return value;
  };

  ConnectionAllowlistIssue.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ConnectionAllowlist(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionAllowlist.prototype.initDefaults_ = function() {
    this.allowlist = null;
    this.reportingEndpoint = null;
    this.issues = null;
  };
  ConnectionAllowlist.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionAllowlist.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionAllowlist.allowlist
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionAllowlist.reportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionAllowlist.issues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, new codec.Enum(ConnectionAllowlistIssue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionAllowlist.encodedSize = codec.kStructHeaderSize + 24;

  ConnectionAllowlist.decode = function(decoder) {
    var packed;
    var val = new ConnectionAllowlist();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allowlist =
        decoder.decodeArrayPointer(codec.String);
    val.reportingEndpoint =
        decoder.decodeStruct(codec.String);
    val.issues =
        decoder.decodeArrayPointer(new codec.Enum(ConnectionAllowlistIssue));
    return val;
  };

  ConnectionAllowlist.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionAllowlist.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.allowlist);
    encoder.encodeStruct(codec.String, val.reportingEndpoint);
    encoder.encodeArrayPointer(new codec.Enum(ConnectionAllowlistIssue), val.issues);
  };
  function ConnectionAllowlists(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionAllowlists.prototype.initDefaults_ = function() {
    this.enforced = null;
    this.reportOnly = null;
  };
  ConnectionAllowlists.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionAllowlists.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionAllowlists.enforced
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ConnectionAllowlist, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionAllowlists.reportOnly
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ConnectionAllowlist, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionAllowlists.encodedSize = codec.kStructHeaderSize + 16;

  ConnectionAllowlists.decode = function(decoder) {
    var packed;
    var val = new ConnectionAllowlists();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.enforced =
        decoder.decodeStructPointer(ConnectionAllowlist);
    val.reportOnly =
        decoder.decodeStructPointer(ConnectionAllowlist);
    return val;
  };

  ConnectionAllowlists.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionAllowlists.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ConnectionAllowlist, val.enforced);
    encoder.encodeStructPointer(ConnectionAllowlist, val.reportOnly);
  };
  exports.ConnectionAllowlistIssue = ConnectionAllowlistIssue;
  exports.ConnectionAllowlist = ConnectionAllowlist;
  exports.ConnectionAllowlists = ConnectionAllowlists;
})();