// services/network/public/mojom/connection_allowlist.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/connection_allowlist.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/connection_allowlist.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* ConnectionAllowlistIssueToStringHelper(ConnectionAllowlistIssue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ConnectionAllowlistIssue::kInvalidHeader:
      return "kInvalidHeader";
    case ConnectionAllowlistIssue::kMoreThanOneList:
      return "kMoreThanOneList";
    case ConnectionAllowlistIssue::kItemNotInnerList:
      return "kItemNotInnerList";
    case ConnectionAllowlistIssue::kInvalidAllowlistItemType:
      return "kInvalidAllowlistItemType";
    case ConnectionAllowlistIssue::kReportingEndpointNotToken:
      return "kReportingEndpointNotToken";
    default:
      return nullptr;
  }
}

std::string ConnectionAllowlistIssueToString(ConnectionAllowlistIssue value) {
  const char *str = ConnectionAllowlistIssueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ConnectionAllowlistIssue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ConnectionAllowlistIssue value) {
  return os << ConnectionAllowlistIssueToString(value);
}

namespace internal {


// static
bool ConnectionAllowlist_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectionAllowlist_Data* object =
      static_cast<const ConnectionAllowlist_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allowlist, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allowlist_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->allowlist, validation_context,
                                         &allowlist_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& reporting_endpoint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issues, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::ConnectionAllowlistIssue_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->issues, validation_context,
                                         &issues_validate_params)) {
    return false;
  }

  return true;
}

ConnectionAllowlist_Data::ConnectionAllowlist_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConnectionAllowlists_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConnectionAllowlists_Data* object =
      static_cast<const ConnectionAllowlists_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->enforced, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->report_only, validation_context))
    return false;

  return true;
}

ConnectionAllowlists_Data::ConnectionAllowlists_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::ConnectionAllowlistIssue>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::ConnectionAllowlistIssue value) {
  return std::move(context).WriteString(::network::mojom::ConnectionAllowlistIssueToString(value));
}

} // namespace perfetto