// services/network/public/mojom/cert_verifier_service_updater.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/network_context.mojom-shared.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::CIDRDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CIDRDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CIDR_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::ip(input)) in_ip = Traits::ip(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ip)::BaseType> ip_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPAddressDataView, send_validation>(
        in_ip,
        ip_fragment);

      fragment->ip.Set(
          ip_fragment.is_null() ? nullptr : ip_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ip.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ip in CIDR struct");

      decltype(Traits::mask(input)) in_mask = Traits::mask(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mask)::BaseType> mask_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPAddressDataView, send_validation>(
        in_mask,
        mask_fragment);

      fragment->mask.Set(
          mask_fragment.is_null() ? nullptr : mask_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mask.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mask in CIDR struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::CertWithConstraintsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertWithConstraintsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CertWithConstraints_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::certificate(input)) in_certificate = Traits::certificate(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->certificate)::BaseType>
          certificate_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& certificate_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_certificate,
        certificate_fragment,
        &certificate_validate_params);

      fragment->certificate.Set(
          certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->certificate.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null certificate in CertWithConstraints struct");

      decltype(Traits::permitted_dns_names(input)) in_permitted_dns_names = Traits::permitted_dns_names(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->permitted_dns_names)::BaseType>
          permitted_dns_names_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& permitted_dns_names_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_permitted_dns_names,
        permitted_dns_names_fragment,
        &permitted_dns_names_validate_params);

      fragment->permitted_dns_names.Set(
          permitted_dns_names_fragment.is_null() ? nullptr : permitted_dns_names_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->permitted_dns_names.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permitted_dns_names in CertWithConstraints struct");

      decltype(Traits::permitted_cidrs(input)) in_permitted_cidrs = Traits::permitted_cidrs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->permitted_cidrs)::BaseType>
          permitted_cidrs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& permitted_cidrs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CIDRDataView>, send_validation>(
        in_permitted_cidrs,
        permitted_cidrs_fragment,
        &permitted_cidrs_validate_params);

      fragment->permitted_cidrs.Set(
          permitted_cidrs_fragment.is_null() ? nullptr : permitted_cidrs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->permitted_cidrs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null permitted_cidrs in CertWithConstraints struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::AdditionalCertificatesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::AdditionalCertificatesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::AdditionalCertificates_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::all_certificates(input)) in_all_certificates = Traits::all_certificates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->all_certificates)::BaseType>
          all_certificates_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& all_certificates_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_all_certificates,
        all_certificates_fragment,
        &all_certificates_validate_params);

      fragment->all_certificates.Set(
          all_certificates_fragment.is_null() ? nullptr : all_certificates_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->all_certificates.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null all_certificates in AdditionalCertificates struct");

      decltype(Traits::trust_anchors(input)) in_trust_anchors = Traits::trust_anchors(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_anchors)::BaseType>
          trust_anchors_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trust_anchors_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_trust_anchors,
        trust_anchors_fragment,
        &trust_anchors_validate_params);

      fragment->trust_anchors.Set(
          trust_anchors_fragment.is_null() ? nullptr : trust_anchors_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trust_anchors.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trust_anchors in AdditionalCertificates struct");

      decltype(Traits::trust_anchors_with_enforced_constraints(input)) in_trust_anchors_with_enforced_constraints = Traits::trust_anchors_with_enforced_constraints(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_anchors_with_enforced_constraints)::BaseType>
          trust_anchors_with_enforced_constraints_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trust_anchors_with_enforced_constraints_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_trust_anchors_with_enforced_constraints,
        trust_anchors_with_enforced_constraints_fragment,
        &trust_anchors_with_enforced_constraints_validate_params);

      fragment->trust_anchors_with_enforced_constraints.Set(
          trust_anchors_with_enforced_constraints_fragment.is_null() ? nullptr : trust_anchors_with_enforced_constraints_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trust_anchors_with_enforced_constraints.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trust_anchors_with_enforced_constraints in AdditionalCertificates struct");

      decltype(Traits::trust_anchors_with_additional_constraints(input)) in_trust_anchors_with_additional_constraints = Traits::trust_anchors_with_additional_constraints(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_anchors_with_additional_constraints)::BaseType>
          trust_anchors_with_additional_constraints_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trust_anchors_with_additional_constraints_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>, send_validation>(
        in_trust_anchors_with_additional_constraints,
        trust_anchors_with_additional_constraints_fragment,
        &trust_anchors_with_additional_constraints_validate_params);

      fragment->trust_anchors_with_additional_constraints.Set(
          trust_anchors_with_additional_constraints_fragment.is_null() ? nullptr : trust_anchors_with_additional_constraints_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trust_anchors_with_additional_constraints.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trust_anchors_with_additional_constraints in AdditionalCertificates struct");

      decltype(Traits::trust_anchors_and_leafs(input)) in_trust_anchors_and_leafs = Traits::trust_anchors_and_leafs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_anchors_and_leafs)::BaseType>
          trust_anchors_and_leafs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trust_anchors_and_leafs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>, send_validation>(
        in_trust_anchors_and_leafs,
        trust_anchors_and_leafs_fragment,
        &trust_anchors_and_leafs_validate_params);

      fragment->trust_anchors_and_leafs.Set(
          trust_anchors_and_leafs_fragment.is_null() ? nullptr : trust_anchors_and_leafs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trust_anchors_and_leafs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trust_anchors_and_leafs in AdditionalCertificates struct");

      decltype(Traits::trust_leafs(input)) in_trust_leafs = Traits::trust_leafs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_leafs)::BaseType>
          trust_leafs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trust_leafs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>, send_validation>(
        in_trust_leafs,
        trust_leafs_fragment,
        &trust_leafs_validate_params);

      fragment->trust_leafs.Set(
          trust_leafs_fragment.is_null() ? nullptr : trust_leafs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trust_leafs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trust_leafs in AdditionalCertificates struct");

      decltype(Traits::distrusted_spkis(input)) in_distrusted_spkis = Traits::distrusted_spkis(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->distrusted_spkis)::BaseType>
          distrusted_spkis_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& distrusted_spkis_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_distrusted_spkis,
        distrusted_spkis_fragment,
        &distrusted_spkis_validate_params);

      fragment->distrusted_spkis.Set(
          distrusted_spkis_fragment.is_null() ? nullptr : distrusted_spkis_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->distrusted_spkis.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null distrusted_spkis in AdditionalCertificates struct");

      fragment->include_system_trust_store = Traits::include_system_trust_store(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_SEND_VALIDATION_H_