// services/metrics/public/mojom/ukm_interface.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('ukm.mojom.SingularUkmInterface');
goog.provide('ukm.mojom.SingularUkmInterfaceReceiver');
goog.provide('ukm.mojom.SingularUkmInterfaceCallbackRouter');
goog.provide('ukm.mojom.SingularUkmInterfaceInterface');
goog.provide('ukm.mojom.SingularUkmInterfaceRemote');
goog.provide('ukm.mojom.SingularUkmInterfacePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ukm.mojom.SingularUkmInterfacePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ukm.mojom.SingularUkmInterface.$interfaceName,
        scope);
  }
};

/** @interface */
ukm.mojom.SingularUkmInterfaceInterface = class {
  
  /**
   * @param { !ukm.mojom.UkmEntry } entry
   */

  submit(entry) {}
};

/**
 * @export
 * @implements { ukm.mojom.SingularUkmInterfaceInterface }
 */
ukm.mojom.SingularUkmInterfaceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ukm.mojom.SingularUkmInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ukm.mojom.SingularUkmInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ukm.mojom.SingularUkmInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ukm.mojom.UkmEntry } entry
   */

  submit(
      entry) {
    this.proxy.sendMessage(
        0,
        ukm.mojom.SingularUkmInterface_Submit_ParamsSpec.$,
        null,
        [
          entry
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SingularUkmInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ukm.mojom.SingularUkmInterfaceReceiver = class {
  /**
   * @param {!ukm.mojom.SingularUkmInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ukm.mojom.SingularUkmInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ukm.mojom.SingularUkmInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.SingularUkmInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.SingularUkmInterface_Submit_ParamsSpec.$,
        null,
        impl.submit.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ukm.mojom.SingularUkmInterface = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.SingularUkmInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ukm.mojom.SingularUkmInterfaceRemote}
   * @export
   */
  static getRemote() {
    let remote = new ukm.mojom.SingularUkmInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SingularUkmInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ukm.mojom.SingularUkmInterfaceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ukm.mojom.SingularUkmInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.SingularUkmInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.SingularUkmInterface_Submit_ParamsSpec.$,
        null,
        this.submit.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ukm.mojom.UkmRecorderClientInterface');
goog.provide('ukm.mojom.UkmRecorderClientInterfaceReceiver');
goog.provide('ukm.mojom.UkmRecorderClientInterfaceCallbackRouter');
goog.provide('ukm.mojom.UkmRecorderClientInterfaceInterface');
goog.provide('ukm.mojom.UkmRecorderClientInterfaceRemote');
goog.provide('ukm.mojom.UkmRecorderClientInterfacePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ukm.mojom.UkmRecorderClientInterfacePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ukm.mojom.UkmRecorderClientInterface.$interfaceName,
        scope);
  }
};

/** @interface */
ukm.mojom.UkmRecorderClientInterfaceInterface = class {
  
  /**
   * @param { !ukm.mojom.UkmRecorderParameters } params
   */

  setParameters(params) {}
};

/**
 * @export
 * @implements { ukm.mojom.UkmRecorderClientInterfaceInterface }
 */
ukm.mojom.UkmRecorderClientInterfaceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ukm.mojom.UkmRecorderClientInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ukm.mojom.UkmRecorderClientInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ukm.mojom.UkmRecorderClientInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ukm.mojom.UkmRecorderParameters } params
   */

  setParameters(
      params) {
    this.proxy.sendMessage(
        0,
        ukm.mojom.UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UkmRecorderClientInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ukm.mojom.UkmRecorderClientInterfaceReceiver = class {
  /**
   * @param {!ukm.mojom.UkmRecorderClientInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ukm.mojom.UkmRecorderClientInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ukm.mojom.UkmRecorderClientInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.UkmRecorderClientInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
        null,
        impl.setParameters.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ukm.mojom.UkmRecorderClientInterface = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.UkmRecorderClientInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ukm.mojom.UkmRecorderClientInterfaceRemote}
   * @export
   */
  static getRemote() {
    let remote = new ukm.mojom.UkmRecorderClientInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UkmRecorderClientInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ukm.mojom.UkmRecorderClientInterfaceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ukm.mojom.UkmRecorderClientInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.UkmRecorderClientInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setParameters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
        null,
        this.setParameters.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ukm.mojom.UkmRecorderInterface');
goog.provide('ukm.mojom.UkmRecorderInterfaceReceiver');
goog.provide('ukm.mojom.UkmRecorderInterfaceCallbackRouter');
goog.provide('ukm.mojom.UkmRecorderInterfaceInterface');
goog.provide('ukm.mojom.UkmRecorderInterfaceRemote');
goog.provide('ukm.mojom.UkmRecorderInterfacePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ukm.mojom.UkmRecorderInterfacePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ukm.mojom.UkmRecorderInterface.$interfaceName,
        scope);
  }
};

/** @interface */
ukm.mojom.UkmRecorderInterfaceInterface = class {
  
  /**
   * @param { !ukm.mojom.UkmEntry } entry
   */

  addEntry(entry) {}
  
  /**
   * @param { !bigint } sourceId
   * @param { !string } url
   */

  updateSourceURL(sourceId, url) {}
};

/**
 * @export
 * @implements { ukm.mojom.UkmRecorderInterfaceInterface }
 */
ukm.mojom.UkmRecorderInterfaceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ukm.mojom.UkmRecorderInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ukm.mojom.UkmRecorderInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ukm.mojom.UkmRecorderInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ukm.mojom.UkmEntry } entry
   */

  addEntry(
      entry) {
    this.proxy.sendMessage(
        0,
        ukm.mojom.UkmRecorderInterface_AddEntry_ParamsSpec.$,
        null,
        [
          entry
        ],
        false);
  }

  
  /**
   * @param { !bigint } sourceId
   * @param { !string } url
   */

  updateSourceURL(
      sourceId,
      url) {
    this.proxy.sendMessage(
        1,
        ukm.mojom.UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
        null,
        [
          sourceId,
          url
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UkmRecorderInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ukm.mojom.UkmRecorderInterfaceReceiver = class {
  /**
   * @param {!ukm.mojom.UkmRecorderInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ukm.mojom.UkmRecorderInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ukm.mojom.UkmRecorderInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.UkmRecorderInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.UkmRecorderInterface_AddEntry_ParamsSpec.$,
        null,
        impl.addEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ukm.mojom.UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
        null,
        impl.updateSourceURL.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ukm.mojom.UkmRecorderInterface = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.UkmRecorderInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ukm.mojom.UkmRecorderInterfaceRemote}
   * @export
   */
  static getRemote() {
    let remote = new ukm.mojom.UkmRecorderInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UkmRecorderInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ukm.mojom.UkmRecorderInterfaceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ukm.mojom.UkmRecorderInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.UkmRecorderInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.UkmRecorderInterface_AddEntry_ParamsSpec.$,
        null,
        this.addEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSourceURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ukm.mojom.UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
        null,
        this.updateSourceURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ukm.mojom.UkmRecorderFactory');
goog.provide('ukm.mojom.UkmRecorderFactoryReceiver');
goog.provide('ukm.mojom.UkmRecorderFactoryCallbackRouter');
goog.provide('ukm.mojom.UkmRecorderFactoryInterface');
goog.provide('ukm.mojom.UkmRecorderFactoryRemote');
goog.provide('ukm.mojom.UkmRecorderFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ukm.mojom.UkmRecorderFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ukm.mojom.UkmRecorderFactory.$interfaceName,
        scope);
  }
};

/** @interface */
ukm.mojom.UkmRecorderFactoryInterface = class {
  
  /**
   * @param { !ukm.mojom.UkmRecorderInterfacePendingReceiver } receiver
   * @param { ?ukm.mojom.UkmRecorderClientInterfaceRemote } clientRemote
   */

  createUkmRecorder(receiver, clientRemote) {}
};

/**
 * @export
 * @implements { ukm.mojom.UkmRecorderFactoryInterface }
 */
ukm.mojom.UkmRecorderFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ukm.mojom.UkmRecorderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ukm.mojom.UkmRecorderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ukm.mojom.UkmRecorderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ukm.mojom.UkmRecorderInterfacePendingReceiver } receiver
   * @param { ?ukm.mojom.UkmRecorderClientInterfaceRemote } clientRemote
   */

  createUkmRecorder(
      receiver,
      clientRemote) {
    this.proxy.sendMessage(
        0,
        ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
        null,
        [
          receiver,
          clientRemote
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UkmRecorderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ukm.mojom.UkmRecorderFactoryReceiver = class {
  /**
   * @param {!ukm.mojom.UkmRecorderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ukm.mojom.UkmRecorderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ukm.mojom.UkmRecorderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.UkmRecorderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
        null,
        impl.createUkmRecorder.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ukm.mojom.UkmRecorderFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.UkmRecorderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ukm.mojom.UkmRecorderFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new ukm.mojom.UkmRecorderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UkmRecorderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ukm.mojom.UkmRecorderFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ukm.mojom.UkmRecorderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ukm.mojom.UkmRecorderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createUkmRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
        null,
        this.createUkmRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ukm.mojom.UkmEntrySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.UkmEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ukm.mojom.UkmRecorderParametersSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.UkmRecorderParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ukm.mojom.SingularUkmInterface_Submit_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.SingularUkmInterface_Submit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ukm.mojom.UkmRecorderClientInterface_SetParameters_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.UkmRecorderClientInterface_SetParameters_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ukm.mojom.UkmRecorderInterface_AddEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.UkmRecorderInterface_AddEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ukm.mojom.UkmRecorderInterface_UpdateSourceURL_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.UkmRecorderInterface_UpdateSourceURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ukm.mojom.UkmEntrySpec.$,
    'UkmEntry',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventHash', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metrics', 16,
        0,
        mojo.internal.Map(mojo.internal.Uint64, mojo.internal.Int64, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('ukm.mojom.UkmEntry');

/** @record */
ukm.mojom.UkmEntry = class {
  constructor() {
    /** @export { !bigint } */
    this.sourceId;
    /** @export { !bigint } */
    this.eventHash;
    /** @export { !Map<!bigint, !bigint> } */
    this.metrics;
  }
};



mojo.internal.Struct(
    ukm.mojom.UkmRecorderParametersSpec.$,
    'UkmRecorderParameters',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventHashBypassList', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint64, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ukm.mojom.UkmRecorderParameters');

/** @record */
ukm.mojom.UkmRecorderParameters = class {
  constructor() {
    /** @export { !boolean } */
    this.isEnabled;
    /** @export { !Array<!bigint> } */
    this.eventHashBypassList;
  }
};



mojo.internal.Struct(
    ukm.mojom.SingularUkmInterface_Submit_ParamsSpec.$,
    'SingularUkmInterface_Submit_Params',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        ukm.mojom.UkmEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ukm.mojom.SingularUkmInterface_Submit_Params');

/** @record */
ukm.mojom.SingularUkmInterface_Submit_Params = class {
  constructor() {
    /** @export { !ukm.mojom.UkmEntry } */
    this.entry;
  }
};



mojo.internal.Struct(
    ukm.mojom.UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
    'UkmRecorderClientInterface_SetParameters_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        ukm.mojom.UkmRecorderParametersSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ukm.mojom.UkmRecorderClientInterface_SetParameters_Params');

/** @record */
ukm.mojom.UkmRecorderClientInterface_SetParameters_Params = class {
  constructor() {
    /** @export { !ukm.mojom.UkmRecorderParameters } */
    this.params;
  }
};



mojo.internal.Struct(
    ukm.mojom.UkmRecorderInterface_AddEntry_ParamsSpec.$,
    'UkmRecorderInterface_AddEntry_Params',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        ukm.mojom.UkmEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ukm.mojom.UkmRecorderInterface_AddEntry_Params');

/** @record */
ukm.mojom.UkmRecorderInterface_AddEntry_Params = class {
  constructor() {
    /** @export { !ukm.mojom.UkmEntry } */
    this.entry;
  }
};



mojo.internal.Struct(
    ukm.mojom.UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
    'UkmRecorderInterface_UpdateSourceURL_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ukm.mojom.UkmRecorderInterface_UpdateSourceURL_Params');

/** @record */
ukm.mojom.UkmRecorderInterface_UpdateSourceURL_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.sourceId;
    /** @export { !string } */
    this.url;
  }
};



mojo.internal.Struct(
    ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
    'UkmRecorderFactory_CreateUkmRecorder_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ukm.mojom.UkmRecorderInterfacePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientRemote', 4,
        0,
        mojo.internal.InterfaceProxy(ukm.mojom.UkmRecorderClientInterfaceRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_Params');

/** @record */
ukm.mojom.UkmRecorderFactory_CreateUkmRecorder_Params = class {
  constructor() {
    /** @export { !ukm.mojom.UkmRecorderInterfacePendingReceiver } */
    this.receiver;
    /** @export { (ukm.mojom.UkmRecorderClientInterfaceRemote|undefined) } */
    this.clientRemote;
  }
};

