// services/media_session/public/mojom/media_session.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_TEST_UTILS_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_TEST_UTILS_H_

#include "services/media_session/public/mojom/media_session.mojom.h"


namespace media_session::mojom {


class  MediaSessionObserverInterceptorForTesting : public MediaSessionObserver {
  virtual MediaSessionObserver* GetForwardingInterface() = 0;
  void MediaSessionInfoChanged(MediaSessionInfoPtr info) override;
  void MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) override;
  void MediaSessionActionsChanged(const std::vector<MediaSessionAction>& action) override;
  void MediaSessionImagesChanged(const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& images) override;
  void MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) override;
};
class  MediaSessionObserverAsyncWaiter {
 public:
  explicit MediaSessionObserverAsyncWaiter(MediaSessionObserver* proxy);

  MediaSessionObserverAsyncWaiter(const MediaSessionObserverAsyncWaiter&) = delete;
  MediaSessionObserverAsyncWaiter& operator=(const MediaSessionObserverAsyncWaiter&) = delete;

  ~MediaSessionObserverAsyncWaiter();

 private:
  MediaSessionObserver* const proxy_;
};


class  MediaSessionInterceptorForTesting : public MediaSession {
  virtual MediaSession* GetForwardingInterface() = 0;
  void GetMediaSessionInfo(GetMediaSessionInfoCallback callback) override;
  void GetDebugInfo(GetDebugInfoCallback callback) override;
  void StartDucking() override;
  void StopDucking() override;
  void Suspend(MediaSession::SuspendType suspend_type) override;
  void Resume(MediaSession::SuspendType suspend_type) override;
  void AddObserver(::mojo::PendingRemote<MediaSessionObserver> observer) override;
  void PreviousTrack() override;
  void NextTrack() override;
  void Seek(::base::TimeDelta seek_time) override;
  void Stop(MediaSession::SuspendType suspend_type) override;
  void SkipAd() override;
  void GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, GetMediaImageBitmapCallback callback) override;
  void SeekTo(::base::TimeDelta seek_time) override;
  void ScrubTo(::base::TimeDelta seek_time) override;
  void EnterPictureInPicture() override;
  void ExitPictureInPicture() override;
  void SetAudioSinkId(const std::optional<std::string>& id) override;
  void ToggleMicrophone() override;
  void ToggleCamera() override;
  void HangUp() override;
  void Raise() override;
  void SetMute(bool mute) override;
  void RequestMediaRemoting() override;
  void PreviousSlide() override;
  void NextSlide() override;
  void EnterAutoPictureInPicture() override;
  void GetVisibility(GetVisibilityCallback callback) override;
};
class  MediaSessionAsyncWaiter {
 public:
  explicit MediaSessionAsyncWaiter(MediaSession* proxy);

  MediaSessionAsyncWaiter(const MediaSessionAsyncWaiter&) = delete;
  MediaSessionAsyncWaiter& operator=(const MediaSessionAsyncWaiter&) = delete;

  ~MediaSessionAsyncWaiter();
  void GetMediaSessionInfo(
      MediaSessionInfoPtr* out_info);
  MediaSessionInfoPtr GetMediaSessionInfo();
  void GetDebugInfo(
      MediaSessionDebugInfoPtr* out_info);
  MediaSessionDebugInfoPtr GetDebugInfo();
  void GetMediaImageBitmap(
      const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, ::SkBitmap* out_image);
  ::SkBitmap GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px);
  void GetVisibility(
      bool* out_has_sufficiently_visible_video);
  bool GetVisibility();

 private:
  MediaSession* const proxy_;
};




}  // media_session::mojom

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_TEST_UTILS_H_