// services/media_session/public/mojom/media_controller.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/media_session/public/mojom/media_controller.mojom-features.h"  // IWYU pragma: export
#include "services/media_session/public/mojom/media_controller.mojom-shared.h"  // IWYU pragma: export
#include "services/media_session/public/mojom/media_controller.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/token.h"




namespace media_session::mojom {

class MediaControllerManagerProxy;

template <typename ImplRefTraits>
class MediaControllerManagerStub;

class MediaControllerManagerRequestValidator;


class MediaControllerManager
    : public MediaControllerManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.MediaControllerManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 2221156829214820475ULL,
                                      13231378062651348515ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaControllerManagerInterfaceBase;
  using Proxy_ = MediaControllerManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaControllerManagerStub<ImplRefTraits>;

  using RequestValidator_ = MediaControllerManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateMediaControllerForSessionMinVersion = 0,
    kCreateActiveMediaControllerMinVersion = 0,
    kSuspendAllSessionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateMediaControllerForSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateActiveMediaController_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SuspendAllSessions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaControllerManager() = default;

  virtual void CreateMediaControllerForSession(::mojo::PendingReceiver<MediaController> receiver, const ::base::UnguessableToken& request_id) = 0;

  virtual void CreateActiveMediaController(::mojo::PendingReceiver<MediaController> receiver) = 0;

  virtual void SuspendAllSessions() = 0;
};

class MediaControllerProxy;

template <typename ImplRefTraits>
class MediaControllerStub;

class MediaControllerRequestValidator;


class MediaController
    : public MediaControllerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.MediaController";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 6;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaControllerInterfaceBase;
  using Proxy_ = MediaControllerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaControllerStub<ImplRefTraits>;

  using RequestValidator_ = MediaControllerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kStopMinVersion = 0,
    kToggleSuspendResumeMinVersion = 0,
    kAddObserverMinVersion = 0,
    kPreviousTrackMinVersion = 0,
    kNextTrackMinVersion = 0,
    kSeekMinVersion = 0,
    kObserveImagesMinVersion = 0,
    kSeekToMinVersion = 0,
    kScrubToMinVersion = 0,
    kEnterPictureInPictureMinVersion = 0,
    kExitPictureInPictureMinVersion = 0,
    kSetAudioSinkIdMinVersion = 0,
    kToggleMicrophoneMinVersion = 1,
    kToggleCameraMinVersion = 1,
    kHangUpMinVersion = 1,
    kRaiseMinVersion = 2,
    kSetMuteMinVersion = 3,
    kRequestMediaRemotingMinVersion = 4,
    kEnterAutoPictureInPictureMinVersion = 5,
    kSkipAdMinVersion = 6,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Suspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleSuspendResume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreviousTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NextTrack_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Seek_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ObserveImages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SeekTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ScrubTo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnterPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAudioSinkId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleMicrophone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleCamera_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HangUp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Raise_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMute_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestMediaRemoting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnterAutoPictureInPicture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SkipAd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaController() = default;

  virtual void Suspend() = 0;

  virtual void Resume() = 0;

  virtual void Stop() = 0;

  virtual void ToggleSuspendResume() = 0;

  virtual void AddObserver(::mojo::PendingRemote<MediaControllerObserver> observer) = 0;

  virtual void PreviousTrack() = 0;

  virtual void NextTrack() = 0;

  virtual void Seek(::base::TimeDelta seek_time) = 0;

  virtual void ObserveImages(::media_session::mojom::MediaSessionImageType type, int32_t minimum_size_px, int32_t desired_size_px, ::mojo::PendingRemote<MediaControllerImageObserver> observer) = 0;

  virtual void SeekTo(::base::TimeDelta seek_time) = 0;

  virtual void ScrubTo(::base::TimeDelta seek_time) = 0;

  virtual void EnterPictureInPicture() = 0;

  virtual void ExitPictureInPicture() = 0;

  virtual void SetAudioSinkId(const std::optional<std::string>& id) = 0;

  virtual void ToggleMicrophone() = 0;

  virtual void ToggleCamera() = 0;

  virtual void HangUp() = 0;

  virtual void Raise() = 0;

  virtual void SetMute(bool mute) = 0;

  virtual void RequestMediaRemoting() = 0;

  virtual void EnterAutoPictureInPicture() = 0;

  virtual void SkipAd() = 0;
};

class MediaControllerObserverProxy;

template <typename ImplRefTraits>
class MediaControllerObserverStub;

class MediaControllerObserverRequestValidator;


class MediaControllerObserver
    : public MediaControllerObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.MediaControllerObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaControllerObserverInterfaceBase;
  using Proxy_ = MediaControllerObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaControllerObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaControllerObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMediaSessionInfoChangedMinVersion = 0,
    kMediaSessionMetadataChangedMinVersion = 0,
    kMediaSessionActionsChangedMinVersion = 0,
    kMediaSessionChangedMinVersion = 0,
    kMediaSessionPositionChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MediaSessionInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionMetadataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionActionsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionPositionChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaControllerObserver() = default;

  virtual void MediaSessionInfoChanged(::media_session::mojom::MediaSessionInfoPtr info) = 0;

  virtual void MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) = 0;

  virtual void MediaSessionActionsChanged(const std::vector<::media_session::mojom::MediaSessionAction>& action) = 0;

  virtual void MediaSessionChanged(const std::optional<::base::UnguessableToken>& request_id) = 0;

  virtual void MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) = 0;
};

class MediaControllerImageObserverProxy;

template <typename ImplRefTraits>
class MediaControllerImageObserverStub;

class MediaControllerImageObserverRequestValidator;


class MediaControllerImageObserver
    : public MediaControllerImageObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.MediaControllerImageObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 7;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaControllerImageObserverInterfaceBase;
  using Proxy_ = MediaControllerImageObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaControllerImageObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaControllerImageObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMediaControllerImageChangedMinVersion = 0,
    kMediaControllerChapterImageChangedMinVersion = 7,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct MediaControllerImageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaControllerChapterImageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaControllerImageObserver() = default;

  virtual void MediaControllerImageChanged(::media_session::mojom::MediaSessionImageType type, const ::SkBitmap& bitmap) = 0;

  virtual void MediaControllerChapterImageChanged(int32_t index, const ::SkBitmap& bitmap) = 0;
};



class  MediaControllerManagerProxy
    : public MediaControllerManager {
 public:
  using InterfaceType = MediaControllerManager;

  explicit MediaControllerManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateMediaControllerForSession(::mojo::PendingReceiver<MediaController> receiver, const ::base::UnguessableToken& request_id) final;
  
  void CreateActiveMediaController(::mojo::PendingReceiver<MediaController> receiver) final;
  
  void SuspendAllSessions() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaControllerProxy
    : public MediaController {
 public:
  using InterfaceType = MediaController;

  explicit MediaControllerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Suspend() final;
  
  void Resume() final;
  
  void Stop() final;
  
  void ToggleSuspendResume() final;
  
  void AddObserver(::mojo::PendingRemote<MediaControllerObserver> observer) final;
  
  void PreviousTrack() final;
  
  void NextTrack() final;
  
  void Seek(::base::TimeDelta seek_time) final;
  
  void ObserveImages(::media_session::mojom::MediaSessionImageType type, int32_t minimum_size_px, int32_t desired_size_px, ::mojo::PendingRemote<MediaControllerImageObserver> observer) final;
  
  void SeekTo(::base::TimeDelta seek_time) final;
  
  void ScrubTo(::base::TimeDelta seek_time) final;
  
  void EnterPictureInPicture() final;
  
  void ExitPictureInPicture() final;
  
  void SetAudioSinkId(const std::optional<std::string>& id) final;
  
  void ToggleMicrophone() final;
  
  void ToggleCamera() final;
  
  void HangUp() final;
  
  void Raise() final;
  
  void SetMute(bool mute) final;
  
  void RequestMediaRemoting() final;
  
  void EnterAutoPictureInPicture() final;
  
  void SkipAd() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaControllerObserverProxy
    : public MediaControllerObserver {
 public:
  using InterfaceType = MediaControllerObserver;

  explicit MediaControllerObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MediaSessionInfoChanged(::media_session::mojom::MediaSessionInfoPtr info) final;
  
  void MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) final;
  
  void MediaSessionActionsChanged(const std::vector<::media_session::mojom::MediaSessionAction>& action) final;
  
  void MediaSessionChanged(const std::optional<::base::UnguessableToken>& request_id) final;
  
  void MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaControllerImageObserverProxy
    : public MediaControllerImageObserver {
 public:
  using InterfaceType = MediaControllerImageObserver;

  explicit MediaControllerImageObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MediaControllerImageChanged(::media_session::mojom::MediaSessionImageType type, const ::SkBitmap& bitmap) final;
  
  void MediaControllerChapterImageChanged(int32_t index, const ::SkBitmap& bitmap) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaControllerManagerStubDispatch {
 public:
  static bool Accept(MediaControllerManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaControllerManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaControllerManager>>
class MediaControllerManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaControllerManagerStub() = default;
  ~MediaControllerManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaControllerStubDispatch {
 public:
  static bool Accept(MediaController* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaController* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaController>>
class MediaControllerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaControllerStub() = default;
  ~MediaControllerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaControllerObserverStubDispatch {
 public:
  static bool Accept(MediaControllerObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaControllerObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaControllerObserver>>
class MediaControllerObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaControllerObserverStub() = default;
  ~MediaControllerObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaControllerImageObserverStubDispatch {
 public:
  static bool Accept(MediaControllerImageObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaControllerImageObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaControllerImageObserver>>
class MediaControllerImageObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaControllerImageObserverStub() = default;
  ~MediaControllerImageObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerImageObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaControllerImageObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaControllerManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaControllerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaControllerObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaControllerImageObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media_session::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_H_