// services/device/public/mojom/usb_manager_client.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_manager_client.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_manager_client.mojom-params-data.h"
#include "services/device/public/mojom/usb_manager_client.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_manager_client.mojom-blink-import-headers.h"
#include "services/device/public/mojom/usb_manager_client.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
// The declaration includes the definition on other builds.

UsbDeviceManagerClient::IPCStableHashFunction UsbDeviceManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UsbDeviceManagerClient>(message.name())) {
    case messages::UsbDeviceManagerClient::kOnDeviceAdded: {
      return &UsbDeviceManagerClient::OnDeviceAdded_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManagerClient::kOnDeviceRemoved: {
      return &UsbDeviceManagerClient::OnDeviceRemoved_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UsbDeviceManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UsbDeviceManagerClient>(message.name())) {
      case messages::UsbDeviceManagerClient::kOnDeviceAdded:
            return "Receive device::mojom::UsbDeviceManagerClient::OnDeviceAdded";
      case messages::UsbDeviceManagerClient::kOnDeviceRemoved:
            return "Receive device::mojom::UsbDeviceManagerClient::OnDeviceRemoved";
    }
  } else {
    switch (static_cast<messages::UsbDeviceManagerClient>(message.name())) {
      case messages::UsbDeviceManagerClient::kOnDeviceAdded:
            return "Receive reply device::mojom::UsbDeviceManagerClient::OnDeviceAdded";
      case messages::UsbDeviceManagerClient::kOnDeviceRemoved:
            return "Receive reply device::mojom::UsbDeviceManagerClient::OnDeviceRemoved";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UsbDeviceManagerClient::OnDeviceAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbd8a35b2;  // IPCStableHash for device::mojom::UsbDeviceManagerClient::OnDeviceAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManagerClient::OnDeviceRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6275c5b;  // IPCStableHash for device::mojom::UsbDeviceManagerClient::OnDeviceRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

UsbDeviceManagerClientProxy::UsbDeviceManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UsbDeviceManagerClientProxy::OnDeviceAdded(
    ::device::mojom::blink::UsbDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManagerClient::OnDeviceAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::device::mojom::blink::UsbDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerClient::kOnDeviceAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::UsbDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in UsbDeviceManagerClient.OnDeviceAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerClient::Name_);
  message.set_method_name("OnDeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void UsbDeviceManagerClientProxy::OnDeviceRemoved(
    ::device::mojom::blink::UsbDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManagerClient::OnDeviceRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::device::mojom::blink::UsbDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerClient::kOnDeviceRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::UsbDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in UsbDeviceManagerClient.OnDeviceRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerClient::Name_);
  message.set_method_name("OnDeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool UsbDeviceManagerClientStubDispatch::Accept(
    UsbDeviceManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UsbDeviceManagerClient>(message->header()->name)) {
    case messages::UsbDeviceManagerClient::kOnDeviceAdded: {
      DCHECK(message->is_serialized());
      internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UsbDeviceManagerClient.0
      bool success = true;
      ::device::mojom::blink::UsbDeviceInfoPtr p_device_info{};
      UsbDeviceManagerClient_OnDeviceAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceAdded(        
        std::move(p_device_info));
      return true;
    }
    case messages::UsbDeviceManagerClient::kOnDeviceRemoved: {
      DCHECK(message->is_serialized());
      internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for UsbDeviceManagerClient.1
      bool success = true;
      ::device::mojom::blink::UsbDeviceInfoPtr p_device_info{};
      UsbDeviceManagerClient_OnDeviceRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceRemoved(        
        std::move(p_device_info));
      return true;
    }
  }
  return false;
}

// static
bool UsbDeviceManagerClientStubDispatch::AcceptWithResponder(
    UsbDeviceManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UsbDeviceManagerClient>(message->header()->name)) {
    case messages::UsbDeviceManagerClient::kOnDeviceAdded: {
      break;
    }
    case messages::UsbDeviceManagerClient::kOnDeviceRemoved: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUsbDeviceManagerClientValidationInfo[] = {
    { &internal::UsbDeviceManagerClient_OnDeviceAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::UsbDeviceManagerClient_OnDeviceRemoved_Params_Data::Validate,
     nullptr /* no response */},
};

bool UsbDeviceManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::UsbDeviceManagerClient::Name_,
    kUsbDeviceManagerClientValidationInfo);
}



}  // device::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void UsbDeviceManagerClientInterceptorForTesting::OnDeviceAdded(::device::mojom::blink::UsbDeviceInfoPtr device_info) {
  GetForwardingInterface()->OnDeviceAdded(
    std::move(device_info)
    );
}
void UsbDeviceManagerClientInterceptorForTesting::OnDeviceRemoved(::device::mojom::blink::UsbDeviceInfoPtr device_info) {
  GetForwardingInterface()->OnDeviceRemoved(
    std::move(device_info)
    );
}
UsbDeviceManagerClientAsyncWaiter::UsbDeviceManagerClientAsyncWaiter(
    UsbDeviceManagerClient* proxy) : proxy_(proxy) {}

UsbDeviceManagerClientAsyncWaiter::~UsbDeviceManagerClientAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif