// services/device/public/mojom/smart_card.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/smart_card.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var SmartCardSuccess = {};
  SmartCardSuccess.kOk = 0;
  SmartCardSuccess.MIN_VALUE = 0;
  SmartCardSuccess.MAX_VALUE = 0;

  SmartCardSuccess.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  SmartCardSuccess.toKnownEnumValue = function(value) {
    return value;
  };

  SmartCardSuccess.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SmartCardError = {};
  SmartCardError.kRemovedCard = 0;
  SmartCardError.kResetCard = 1;
  SmartCardError.kUnpoweredCard = 2;
  SmartCardError.kUnresponsiveCard = 3;
  SmartCardError.kUnsupportedCard = 4;
  SmartCardError.kReaderUnavailable = 5;
  SmartCardError.kSharingViolation = 6;
  SmartCardError.kNotTransacted = 7;
  SmartCardError.kNoSmartcard = 8;
  SmartCardError.kProtoMismatch = 9;
  SmartCardError.kSystemCancelled = 10;
  SmartCardError.kNotReady = 11;
  SmartCardError.kCancelled = 12;
  SmartCardError.kInsufficientBuffer = 13;
  SmartCardError.kInvalidHandle = 14;
  SmartCardError.kInvalidParameter = 15;
  SmartCardError.kInvalidValue = 16;
  SmartCardError.kNoMemory = 17;
  SmartCardError.kTimeout = 18;
  SmartCardError.kUnknownReader = 19;
  SmartCardError.kUnsupportedFeature = 20;
  SmartCardError.kNoReadersAvailable = 21;
  SmartCardError.kServiceStopped = 22;
  SmartCardError.kNoService = 23;
  SmartCardError.kCommError = 24;
  SmartCardError.kInternalError = 25;
  SmartCardError.kUnknownError = 26;
  SmartCardError.kServerTooBusy = 27;
  SmartCardError.kUnexpected = 28;
  SmartCardError.kShutdown = 29;
  SmartCardError.kUnknown = 30;
  SmartCardError.kPermissionDenied = 31;
  SmartCardError.MIN_VALUE = 0;
  SmartCardError.MAX_VALUE = 31;

  SmartCardError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
      return true;
    }
    return false;
  };

  SmartCardError.toKnownEnumValue = function(value) {
    return value;
  };

  SmartCardError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SmartCardShareMode = {};
  SmartCardShareMode.kShared = 0;
  SmartCardShareMode.kExclusive = 1;
  SmartCardShareMode.kDirect = 2;
  SmartCardShareMode.MIN_VALUE = 0;
  SmartCardShareMode.MAX_VALUE = 2;

  SmartCardShareMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SmartCardShareMode.toKnownEnumValue = function(value) {
    return value;
  };

  SmartCardShareMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SmartCardProtocol = {};
  SmartCardProtocol.kUndefined = 0;
  SmartCardProtocol.kT0 = 1;
  SmartCardProtocol.kT1 = 2;
  SmartCardProtocol.kRaw = 3;
  SmartCardProtocol.MIN_VALUE = 0;
  SmartCardProtocol.MAX_VALUE = 3;

  SmartCardProtocol.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SmartCardProtocol.toKnownEnumValue = function(value) {
    return value;
  };

  SmartCardProtocol.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SmartCardDisposition = {};
  SmartCardDisposition.kLeave = 0;
  SmartCardDisposition.kReset = 1;
  SmartCardDisposition.kUnpower = 2;
  SmartCardDisposition.kEject = 3;
  SmartCardDisposition.MIN_VALUE = 0;
  SmartCardDisposition.MAX_VALUE = 3;

  SmartCardDisposition.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SmartCardDisposition.toKnownEnumValue = function(value) {
    return value;
  };

  SmartCardDisposition.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SmartCardConnectionState = {};
  SmartCardConnectionState.kAbsent = 0;
  SmartCardConnectionState.kPresent = 1;
  SmartCardConnectionState.kSwallowed = 2;
  SmartCardConnectionState.kPowered = 3;
  SmartCardConnectionState.kNegotiable = 4;
  SmartCardConnectionState.kSpecific = 5;
  SmartCardConnectionState.MIN_VALUE = 0;
  SmartCardConnectionState.MAX_VALUE = 5;

  SmartCardConnectionState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  SmartCardConnectionState.toKnownEnumValue = function(value) {
    return value;
  };

  SmartCardConnectionState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SmartCardReaderStateFlags(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardReaderStateFlags.prototype.initDefaults_ = function() {
    this.unaware = false;
    this.ignore = false;
    this.changed = false;
    this.unknown = false;
    this.unavailable = false;
    this.empty = false;
    this.present = false;
    this.exclusive = false;
    this.inuse = false;
    this.mute = false;
    this.unpowered = false;
  };
  SmartCardReaderStateFlags.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardReaderStateFlags.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;












    return validator.validationError.NONE;
  };

  SmartCardReaderStateFlags.encodedSize = codec.kStructHeaderSize + 8;

  SmartCardReaderStateFlags.decode = function(decoder) {
    var packed;
    var val = new SmartCardReaderStateFlags();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.unaware = (packed >> 0) & 1 ? true : false;
    val.ignore = (packed >> 1) & 1 ? true : false;
    val.changed = (packed >> 2) & 1 ? true : false;
    val.unknown = (packed >> 3) & 1 ? true : false;
    val.unavailable = (packed >> 4) & 1 ? true : false;
    val.empty = (packed >> 5) & 1 ? true : false;
    val.present = (packed >> 6) & 1 ? true : false;
    val.exclusive = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.inuse = (packed >> 0) & 1 ? true : false;
    val.mute = (packed >> 1) & 1 ? true : false;
    val.unpowered = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardReaderStateFlags.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardReaderStateFlags.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.unaware & 1) << 0
    packed |= (val.ignore & 1) << 1
    packed |= (val.changed & 1) << 2
    packed |= (val.unknown & 1) << 3
    packed |= (val.unavailable & 1) << 4
    packed |= (val.empty & 1) << 5
    packed |= (val.present & 1) << 6
    packed |= (val.exclusive & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.inuse & 1) << 0
    packed |= (val.mute & 1) << 1
    packed |= (val.unpowered & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardReaderStateIn(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardReaderStateIn.prototype.initDefaults_ = function() {
    this.reader = null;
    this.currentState = null;
    this.currentCount = 0;
  };
  SmartCardReaderStateIn.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardReaderStateIn.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardReaderStateIn.reader
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardReaderStateIn.currentState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SmartCardReaderStateFlags, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SmartCardReaderStateIn.encodedSize = codec.kStructHeaderSize + 24;

  SmartCardReaderStateIn.decode = function(decoder) {
    var packed;
    var val = new SmartCardReaderStateIn();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reader =
        decoder.decodeStruct(codec.String);
    val.currentState =
        decoder.decodeStructPointer(SmartCardReaderStateFlags);
    val.currentCount =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardReaderStateIn.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardReaderStateIn.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.reader);
    encoder.encodeStructPointer(SmartCardReaderStateFlags, val.currentState);
    encoder.encodeStruct(codec.Uint16, val.currentCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardReaderStateOut(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardReaderStateOut.prototype.initDefaults_ = function() {
    this.reader = null;
    this.eventState = null;
    this.eventCount = 0;
    this.answerToReset = null;
  };
  SmartCardReaderStateOut.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardReaderStateOut.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardReaderStateOut.reader
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardReaderStateOut.eventState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SmartCardReaderStateFlags, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SmartCardReaderStateOut.answerToReset
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardReaderStateOut.encodedSize = codec.kStructHeaderSize + 32;

  SmartCardReaderStateOut.decode = function(decoder) {
    var packed;
    var val = new SmartCardReaderStateOut();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reader =
        decoder.decodeStruct(codec.String);
    val.eventState =
        decoder.decodeStructPointer(SmartCardReaderStateFlags);
    val.eventCount =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.answerToReset =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SmartCardReaderStateOut.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardReaderStateOut.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.reader);
    encoder.encodeStructPointer(SmartCardReaderStateFlags, val.eventState);
    encoder.encodeStruct(codec.Uint16, val.eventCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.answerToReset);
  };
  function SmartCardProtocols(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardProtocols.prototype.initDefaults_ = function() {
    this.t0 = false;
    this.t1 = false;
    this.raw = false;
  };
  SmartCardProtocols.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardProtocols.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  SmartCardProtocols.encodedSize = codec.kStructHeaderSize + 8;

  SmartCardProtocols.decode = function(decoder) {
    var packed;
    var val = new SmartCardProtocols();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.t0 = (packed >> 0) & 1 ? true : false;
    val.t1 = (packed >> 1) & 1 ? true : false;
    val.raw = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardProtocols.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardProtocols.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.t0 & 1) << 0
    packed |= (val.t1 & 1) << 1
    packed |= (val.raw & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardStatus(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardStatus.prototype.initDefaults_ = function() {
    this.readerName = null;
    this.state = 0;
    this.protocol = 0;
    this.answerToReset = null;
  };
  SmartCardStatus.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardStatus.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardStatus.readerName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardStatus.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SmartCardConnectionState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardStatus.protocol
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, SmartCardProtocol);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardStatus.answerToReset
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardStatus.encodedSize = codec.kStructHeaderSize + 24;

  SmartCardStatus.decode = function(decoder) {
    var packed;
    var val = new SmartCardStatus();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.readerName =
        decoder.decodeStruct(codec.String);
    val.state =
        decoder.decodeStruct(new codec.Enum(SmartCardConnectionState));
    val.protocol =
        decoder.decodeStruct(new codec.Enum(SmartCardProtocol));
    val.answerToReset =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SmartCardStatus.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardStatus.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.readerName);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.encodeStruct(codec.Int32, val.protocol);
    encoder.encodeArrayPointer(codec.Uint8, val.answerToReset);
  };
  function SmartCardConnectSuccess(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnectSuccess.prototype.initDefaults_ = function() {
    this.connection = new SmartCardConnectionPtr();
    this.activeProtocol = 0;
  };
  SmartCardConnectSuccess.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnectSuccess.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnectSuccess.connection
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnectSuccess.activeProtocol
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SmartCardProtocol);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnectSuccess.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnectSuccess.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnectSuccess();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.connection =
        decoder.decodeStruct(new codec.Interface(SmartCardConnectionPtr));
    val.activeProtocol =
        decoder.decodeStruct(new codec.Enum(SmartCardProtocol));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardConnectSuccess.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnectSuccess.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SmartCardConnectionPtr), val.connection);
    encoder.encodeStruct(codec.Int32, val.activeProtocol);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardTransaction_EndTransaction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardTransaction_EndTransaction_Params.prototype.initDefaults_ = function() {
    this.disposition = 0;
  };
  SmartCardTransaction_EndTransaction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardTransaction_EndTransaction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardTransaction_EndTransaction_Params.disposition
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SmartCardDisposition);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardTransaction_EndTransaction_Params.encodedSize = codec.kStructHeaderSize + 8;

  SmartCardTransaction_EndTransaction_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardTransaction_EndTransaction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.disposition =
        decoder.decodeStruct(new codec.Enum(SmartCardDisposition));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardTransaction_EndTransaction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardTransaction_EndTransaction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.disposition);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardTransaction_EndTransaction_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardTransaction_EndTransaction_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardTransaction_EndTransaction_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardTransaction_EndTransaction_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardTransaction_EndTransaction_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardTransaction_EndTransaction_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardTransaction_EndTransaction_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardTransaction_EndTransaction_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardResult);
    return val;
  };

  SmartCardTransaction_EndTransaction_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardTransaction_EndTransaction_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardResult, val.result);
  };
  function SmartCardConnection_Disconnect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Disconnect_Params.prototype.initDefaults_ = function() {
    this.disposition = 0;
  };
  SmartCardConnection_Disconnect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Disconnect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Disconnect_Params.disposition
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SmartCardDisposition);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Disconnect_Params.encodedSize = codec.kStructHeaderSize + 8;

  SmartCardConnection_Disconnect_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Disconnect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.disposition =
        decoder.decodeStruct(new codec.Enum(SmartCardDisposition));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardConnection_Disconnect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Disconnect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.disposition);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardConnection_Disconnect_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Disconnect_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_Disconnect_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Disconnect_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Disconnect_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Disconnect_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_Disconnect_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Disconnect_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardResult);
    return val;
  };

  SmartCardConnection_Disconnect_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Disconnect_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardResult, val.result);
  };
  function SmartCardConnection_Transmit_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Transmit_Params.prototype.initDefaults_ = function() {
    this.protocol = 0;
    this.data = null;
  };
  SmartCardConnection_Transmit_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Transmit_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Transmit_Params.protocol
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SmartCardProtocol);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Transmit_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Transmit_Params.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_Transmit_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Transmit_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.protocol =
        decoder.decodeStruct(new codec.Enum(SmartCardProtocol));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SmartCardConnection_Transmit_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Transmit_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.protocol);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function SmartCardConnection_Transmit_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Transmit_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_Transmit_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Transmit_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Transmit_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardDataResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Transmit_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_Transmit_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Transmit_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardDataResult);
    return val;
  };

  SmartCardConnection_Transmit_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Transmit_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardDataResult, val.result);
  };
  function SmartCardConnection_Control_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Control_Params.prototype.initDefaults_ = function() {
    this.controlCode = 0;
    this.data = null;
  };
  SmartCardConnection_Control_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Control_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SmartCardConnection_Control_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Control_Params.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_Control_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Control_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.controlCode =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SmartCardConnection_Control_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Control_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.controlCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function SmartCardConnection_Control_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Control_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_Control_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Control_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Control_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardDataResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Control_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_Control_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Control_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardDataResult);
    return val;
  };

  SmartCardConnection_Control_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Control_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardDataResult, val.result);
  };
  function SmartCardConnection_GetAttrib_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_GetAttrib_Params.prototype.initDefaults_ = function() {
    this.id = 0;
  };
  SmartCardConnection_GetAttrib_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_GetAttrib_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SmartCardConnection_GetAttrib_Params.encodedSize = codec.kStructHeaderSize + 8;

  SmartCardConnection_GetAttrib_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_GetAttrib_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SmartCardConnection_GetAttrib_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_GetAttrib_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SmartCardConnection_GetAttrib_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_GetAttrib_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_GetAttrib_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_GetAttrib_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_GetAttrib_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardDataResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_GetAttrib_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_GetAttrib_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_GetAttrib_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardDataResult);
    return val;
  };

  SmartCardConnection_GetAttrib_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_GetAttrib_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardDataResult, val.result);
  };
  function SmartCardConnection_SetAttrib_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_SetAttrib_Params.prototype.initDefaults_ = function() {
    this.id = 0;
    this.data = null;
  };
  SmartCardConnection_SetAttrib_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_SetAttrib_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate SmartCardConnection_SetAttrib_Params.data
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_SetAttrib_Params.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_SetAttrib_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_SetAttrib_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SmartCardConnection_SetAttrib_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_SetAttrib_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.data);
  };
  function SmartCardConnection_SetAttrib_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_SetAttrib_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_SetAttrib_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_SetAttrib_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_SetAttrib_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_SetAttrib_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_SetAttrib_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_SetAttrib_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardResult);
    return val;
  };

  SmartCardConnection_SetAttrib_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_SetAttrib_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardResult, val.result);
  };
  function SmartCardConnection_Status_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Status_Params.prototype.initDefaults_ = function() {
  };
  SmartCardConnection_Status_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Status_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Status_Params.encodedSize = codec.kStructHeaderSize + 0;

  SmartCardConnection_Status_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Status_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SmartCardConnection_Status_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Status_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SmartCardConnection_Status_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_Status_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_Status_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_Status_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_Status_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardStatusResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_Status_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_Status_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_Status_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardStatusResult);
    return val;
  };

  SmartCardConnection_Status_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_Status_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardStatusResult, val.result);
  };
  function SmartCardConnection_BeginTransaction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_BeginTransaction_Params.prototype.initDefaults_ = function() {
  };
  SmartCardConnection_BeginTransaction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_BeginTransaction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_BeginTransaction_Params.encodedSize = codec.kStructHeaderSize + 0;

  SmartCardConnection_BeginTransaction_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_BeginTransaction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SmartCardConnection_BeginTransaction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_BeginTransaction_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SmartCardConnection_BeginTransaction_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnection_BeginTransaction_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardConnection_BeginTransaction_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnection_BeginTransaction_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardConnection_BeginTransaction_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardTransactionResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnection_BeginTransaction_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardConnection_BeginTransaction_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnection_BeginTransaction_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardTransactionResult);
    return val;
  };

  SmartCardConnection_BeginTransaction_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnection_BeginTransaction_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardTransactionResult, val.result);
  };
  function SmartCardConnectionWatcher_NotifyConnectionUsed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardConnectionWatcher_NotifyConnectionUsed_Params.prototype.initDefaults_ = function() {
  };
  SmartCardConnectionWatcher_NotifyConnectionUsed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardConnectionWatcher_NotifyConnectionUsed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardConnectionWatcher_NotifyConnectionUsed_Params.encodedSize = codec.kStructHeaderSize + 0;

  SmartCardConnectionWatcher_NotifyConnectionUsed_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardConnectionWatcher_NotifyConnectionUsed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SmartCardConnectionWatcher_NotifyConnectionUsed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardConnectionWatcher_NotifyConnectionUsed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SmartCardContext_ListReaders_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_ListReaders_Params.prototype.initDefaults_ = function() {
  };
  SmartCardContext_ListReaders_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_ListReaders_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_ListReaders_Params.encodedSize = codec.kStructHeaderSize + 0;

  SmartCardContext_ListReaders_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_ListReaders_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SmartCardContext_ListReaders_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_ListReaders_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SmartCardContext_ListReaders_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_ListReaders_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardContext_ListReaders_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_ListReaders_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_ListReaders_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardListReadersResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_ListReaders_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardContext_ListReaders_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_ListReaders_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardListReadersResult);
    return val;
  };

  SmartCardContext_ListReaders_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_ListReaders_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardListReadersResult, val.result);
  };
  function SmartCardContext_GetStatusChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_GetStatusChange_Params.prototype.initDefaults_ = function() {
    this.timeout = null;
    this.readerStates = null;
  };
  SmartCardContext_GetStatusChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_GetStatusChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_GetStatusChange_Params.timeout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_GetStatusChange_Params.readerStates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SmartCardReaderStateIn), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_GetStatusChange_Params.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardContext_GetStatusChange_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_GetStatusChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.timeout =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.readerStates =
        decoder.decodeArrayPointer(new codec.PointerTo(SmartCardReaderStateIn));
    return val;
  };

  SmartCardContext_GetStatusChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_GetStatusChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.timeout);
    encoder.encodeArrayPointer(new codec.PointerTo(SmartCardReaderStateIn), val.readerStates);
  };
  function SmartCardContext_GetStatusChange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_GetStatusChange_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardContext_GetStatusChange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_GetStatusChange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_GetStatusChange_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardStatusChangeResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_GetStatusChange_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardContext_GetStatusChange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_GetStatusChange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardStatusChangeResult);
    return val;
  };

  SmartCardContext_GetStatusChange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_GetStatusChange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardStatusChangeResult, val.result);
  };
  function SmartCardContext_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_Cancel_Params.prototype.initDefaults_ = function() {
  };
  SmartCardContext_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  SmartCardContext_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SmartCardContext_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SmartCardContext_Cancel_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_Cancel_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardContext_Cancel_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_Cancel_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_Cancel_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_Cancel_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardContext_Cancel_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_Cancel_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardResult);
    return val;
  };

  SmartCardContext_Cancel_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_Cancel_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardResult, val.result);
  };
  function SmartCardContext_Connect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_Connect_Params.prototype.initDefaults_ = function() {
    this.reader = null;
    this.shareMode = 0;
    this.preferredProtocols = null;
    this.connectionWatcher = new SmartCardConnectionWatcherPtr();
  };
  SmartCardContext_Connect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_Connect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_Connect_Params.reader
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_Connect_Params.shareMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SmartCardShareMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_Connect_Params.preferredProtocols
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, SmartCardProtocols, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_Connect_Params.connectionWatcher
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_Connect_Params.encodedSize = codec.kStructHeaderSize + 32;

  SmartCardContext_Connect_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_Connect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reader =
        decoder.decodeStruct(codec.String);
    val.shareMode =
        decoder.decodeStruct(new codec.Enum(SmartCardShareMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.preferredProtocols =
        decoder.decodeStructPointer(SmartCardProtocols);
    val.connectionWatcher =
        decoder.decodeStruct(new codec.NullableInterface(SmartCardConnectionWatcherPtr));
    return val;
  };

  SmartCardContext_Connect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_Connect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.reader);
    encoder.encodeStruct(codec.Int32, val.shareMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SmartCardProtocols, val.preferredProtocols);
    encoder.encodeStruct(new codec.NullableInterface(SmartCardConnectionWatcherPtr), val.connectionWatcher);
  };
  function SmartCardContext_Connect_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContext_Connect_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardContext_Connect_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContext_Connect_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContext_Connect_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardConnectResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContext_Connect_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardContext_Connect_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardContext_Connect_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardConnectResult);
    return val;
  };

  SmartCardContext_Connect_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContext_Connect_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardConnectResult, val.result);
  };
  function SmartCardContextFactory_CreateContext_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContextFactory_CreateContext_Params.prototype.initDefaults_ = function() {
  };
  SmartCardContextFactory_CreateContext_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContextFactory_CreateContext_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContextFactory_CreateContext_Params.encodedSize = codec.kStructHeaderSize + 0;

  SmartCardContextFactory_CreateContext_Params.decode = function(decoder) {
    var packed;
    var val = new SmartCardContextFactory_CreateContext_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SmartCardContextFactory_CreateContext_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContextFactory_CreateContext_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SmartCardContextFactory_CreateContext_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SmartCardContextFactory_CreateContext_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  SmartCardContextFactory_CreateContext_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SmartCardContextFactory_CreateContext_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SmartCardContextFactory_CreateContext_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, SmartCardCreateContextResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SmartCardContextFactory_CreateContext_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  SmartCardContextFactory_CreateContext_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SmartCardContextFactory_CreateContext_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(SmartCardCreateContextResult);
    return val;
  };

  SmartCardContextFactory_CreateContext_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SmartCardContextFactory_CreateContext_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(SmartCardCreateContextResult, val.result);
  };

  function SmartCardResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardResult.Tags = {
    success: 0,
    error: 1,
  };

  SmartCardResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardResult.prototype, "success", {
    get: function() {
      if (this.$tag != SmartCardResult.Tags.success) {
        throw new ReferenceError(
            "SmartCardResult.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardResult.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardResult.Tags.success:
          encoder.encodeStruct(codec.Int32, val.success);
          break;
        case SmartCardResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardResult.Tags.success:
          result.success = decoder.decodeStruct(new codec.Enum(SmartCardSuccess));
          break;
        case SmartCardResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardResult.Tags.success:
          

    // validate SmartCardResult.success
    err = messageValidator.validateEnum(data_offset, SmartCardSuccess);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardResult.Tags.error:
          

    // validate SmartCardResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardResult.encodedSize = 16;

  function SmartCardStatusChangeResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardStatusChangeResult.Tags = {
    readerStates: 0,
    error: 1,
  };

  SmartCardStatusChangeResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardStatusChangeResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "readerStates",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardStatusChangeResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardStatusChangeResult.prototype, "readerStates", {
    get: function() {
      if (this.$tag != SmartCardStatusChangeResult.Tags.readerStates) {
        throw new ReferenceError(
            "SmartCardStatusChangeResult.readerStates is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardStatusChangeResult.Tags.readerStates;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardStatusChangeResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardStatusChangeResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardStatusChangeResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardStatusChangeResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardStatusChangeResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardStatusChangeResult.Tags.readerStates:
          encoder.encodeArrayPointer(new codec.PointerTo(SmartCardReaderStateOut), val.readerStates);
          break;
        case SmartCardStatusChangeResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardStatusChangeResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardStatusChangeResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardStatusChangeResult.Tags.readerStates:
          result.readerStates = decoder.decodeArrayPointer(new codec.PointerTo(SmartCardReaderStateOut));
          break;
        case SmartCardStatusChangeResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardStatusChangeResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardStatusChangeResult.Tags.readerStates:
          

    // validate SmartCardStatusChangeResult.readerStates
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(SmartCardReaderStateOut), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardStatusChangeResult.Tags.error:
          

    // validate SmartCardStatusChangeResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardStatusChangeResult.encodedSize = 16;

  function SmartCardListReadersResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardListReadersResult.Tags = {
    readers: 0,
    error: 1,
  };

  SmartCardListReadersResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardListReadersResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "readers",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardListReadersResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardListReadersResult.prototype, "readers", {
    get: function() {
      if (this.$tag != SmartCardListReadersResult.Tags.readers) {
        throw new ReferenceError(
            "SmartCardListReadersResult.readers is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardListReadersResult.Tags.readers;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardListReadersResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardListReadersResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardListReadersResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardListReadersResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardListReadersResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardListReadersResult.Tags.readers:
          encoder.encodeArrayPointer(codec.String, val.readers);
          break;
        case SmartCardListReadersResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardListReadersResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardListReadersResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardListReadersResult.Tags.readers:
          result.readers = decoder.decodeArrayPointer(codec.String);
          break;
        case SmartCardListReadersResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardListReadersResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardListReadersResult.Tags.readers:
          

    // validate SmartCardListReadersResult.readers
    err = messageValidator.validateArrayPointer(data_offset, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardListReadersResult.Tags.error:
          

    // validate SmartCardListReadersResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardListReadersResult.encodedSize = 16;

  function SmartCardCreateContextResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardCreateContextResult.Tags = {
    context: 0,
    error: 1,
  };

  SmartCardCreateContextResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardCreateContextResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "context",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardCreateContextResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardCreateContextResult.prototype, "context", {
    get: function() {
      if (this.$tag != SmartCardCreateContextResult.Tags.context) {
        throw new ReferenceError(
            "SmartCardCreateContextResult.context is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardCreateContextResult.Tags.context;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardCreateContextResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardCreateContextResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardCreateContextResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardCreateContextResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardCreateContextResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardCreateContextResult.Tags.context:
          encoder.encodeStruct(new codec.Interface(SmartCardContextPtr), val.context);
          break;
        case SmartCardCreateContextResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardCreateContextResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardCreateContextResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardCreateContextResult.Tags.context:
          result.context = decoder.decodeStruct(new codec.Interface(SmartCardContextPtr));
          break;
        case SmartCardCreateContextResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardCreateContextResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardCreateContextResult.Tags.context:
          

    // validate SmartCardCreateContextResult.context
    err = messageValidator.validateInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardCreateContextResult.Tags.error:
          

    // validate SmartCardCreateContextResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardCreateContextResult.encodedSize = 16;

  function SmartCardConnectResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardConnectResult.Tags = {
    success: 0,
    error: 1,
  };

  SmartCardConnectResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardConnectResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "success",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardConnectResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardConnectResult.prototype, "success", {
    get: function() {
      if (this.$tag != SmartCardConnectResult.Tags.success) {
        throw new ReferenceError(
            "SmartCardConnectResult.success is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardConnectResult.Tags.success;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardConnectResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardConnectResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardConnectResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardConnectResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardConnectResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardConnectResult.Tags.success:
          encoder.encodeStructPointer(SmartCardConnectSuccess, val.success);
          break;
        case SmartCardConnectResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardConnectResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardConnectResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardConnectResult.Tags.success:
          result.success = decoder.decodeStructPointer(SmartCardConnectSuccess);
          break;
        case SmartCardConnectResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardConnectResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardConnectResult.Tags.success:
          

    // validate SmartCardConnectResult.success
    err = messageValidator.validateStructPointer(data_offset, SmartCardConnectSuccess, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardConnectResult.Tags.error:
          

    // validate SmartCardConnectResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardConnectResult.encodedSize = 16;

  function SmartCardDataResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardDataResult.Tags = {
    data: 0,
    error: 1,
  };

  SmartCardDataResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardDataResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "data",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardDataResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardDataResult.prototype, "data", {
    get: function() {
      if (this.$tag != SmartCardDataResult.Tags.data) {
        throw new ReferenceError(
            "SmartCardDataResult.data is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardDataResult.Tags.data;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardDataResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardDataResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardDataResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardDataResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardDataResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardDataResult.Tags.data:
          encoder.encodeArrayPointer(codec.Uint8, val.data);
          break;
        case SmartCardDataResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardDataResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardDataResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardDataResult.Tags.data:
          result.data = decoder.decodeArrayPointer(codec.Uint8);
          break;
        case SmartCardDataResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardDataResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardDataResult.Tags.data:
          

    // validate SmartCardDataResult.data
    err = messageValidator.validateArrayPointer(data_offset, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardDataResult.Tags.error:
          

    // validate SmartCardDataResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardDataResult.encodedSize = 16;

  function SmartCardStatusResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardStatusResult.Tags = {
    status: 0,
    error: 1,
  };

  SmartCardStatusResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardStatusResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "status",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardStatusResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardStatusResult.prototype, "status", {
    get: function() {
      if (this.$tag != SmartCardStatusResult.Tags.status) {
        throw new ReferenceError(
            "SmartCardStatusResult.status is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardStatusResult.Tags.status;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardStatusResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardStatusResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardStatusResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardStatusResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardStatusResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardStatusResult.Tags.status:
          encoder.encodeStructPointer(SmartCardStatus, val.status);
          break;
        case SmartCardStatusResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardStatusResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardStatusResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardStatusResult.Tags.status:
          result.status = decoder.decodeStructPointer(SmartCardStatus);
          break;
        case SmartCardStatusResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardStatusResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardStatusResult.Tags.status:
          

    // validate SmartCardStatusResult.status
    err = messageValidator.validateStructPointer(data_offset, SmartCardStatus, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardStatusResult.Tags.error:
          

    // validate SmartCardStatusResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardStatusResult.encodedSize = 16;

  function SmartCardTransactionResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  SmartCardTransactionResult.Tags = {
    transaction: 0,
    error: 1,
  };

  SmartCardTransactionResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  SmartCardTransactionResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "transaction",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a SmartCardTransactionResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(SmartCardTransactionResult.prototype, "transaction", {
    get: function() {
      if (this.$tag != SmartCardTransactionResult.Tags.transaction) {
        throw new ReferenceError(
            "SmartCardTransactionResult.transaction is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardTransactionResult.Tags.transaction;
      this.$data = value;
    }
  });
  Object.defineProperty(SmartCardTransactionResult.prototype, "error", {
    get: function() {
      if (this.$tag != SmartCardTransactionResult.Tags.error) {
        throw new ReferenceError(
            "SmartCardTransactionResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = SmartCardTransactionResult.Tags.error;
      this.$data = value;
    }
  });


    SmartCardTransactionResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case SmartCardTransactionResult.Tags.transaction:
          encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.transaction);
          break;
        case SmartCardTransactionResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
      }
      encoder.align();
    };


    SmartCardTransactionResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new SmartCardTransactionResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case SmartCardTransactionResult.Tags.transaction:
          result.transaction = decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
          break;
        case SmartCardTransactionResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(SmartCardError));
          break;
      }
      decoder.align();

      return result;
    };


    SmartCardTransactionResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case SmartCardTransactionResult.Tags.transaction:
          

    // validate SmartCardTransactionResult.transaction
    err = messageValidator.validateAssociatedInterface(data_offset, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case SmartCardTransactionResult.Tags.error:
          

    // validate SmartCardTransactionResult.error
    err = messageValidator.validateEnum(data_offset, SmartCardError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  SmartCardTransactionResult.encodedSize = 16;
  var kSmartCardTransaction_EndTransaction_Name = 0;

  function SmartCardTransactionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SmartCardTransaction,
                                                   handleOrPtrInfo);
  }

  function SmartCardTransactionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SmartCardTransaction, associatedInterfacePtrInfo);
  }

  SmartCardTransactionAssociatedPtr.prototype =
      Object.create(SmartCardTransactionPtr.prototype);
  SmartCardTransactionAssociatedPtr.prototype.constructor =
      SmartCardTransactionAssociatedPtr;

  function SmartCardTransactionProxy(receiver) {
    this.receiver_ = receiver;
  }
  SmartCardTransactionPtr.prototype.endTransaction = function() {
    return SmartCardTransactionProxy.prototype.endTransaction
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardTransactionProxy.prototype.endTransaction = function(disposition) {
    var params_ = new SmartCardTransaction_EndTransaction_Params();
    params_.disposition = disposition;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardTransaction_EndTransaction_Name,
          codec.align(SmartCardTransaction_EndTransaction_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardTransaction_EndTransaction_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardTransaction_EndTransaction_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SmartCardTransactionStub(delegate) {
    this.delegate_ = delegate;
  }
  SmartCardTransactionStub.prototype.endTransaction = function(disposition) {
    return this.delegate_ && this.delegate_.endTransaction && this.delegate_.endTransaction(disposition);
  }

  SmartCardTransactionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SmartCardTransactionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSmartCardTransaction_EndTransaction_Name:
      var params = reader.decodeStruct(SmartCardTransaction_EndTransaction_Params);
      this.endTransaction(params.disposition).then(function(response) {
        var responseParams =
            new SmartCardTransaction_EndTransaction_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardTransaction_EndTransaction_Name,
            codec.align(SmartCardTransaction_EndTransaction_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardTransaction_EndTransaction_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSmartCardTransactionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSmartCardTransaction_EndTransaction_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardTransaction_EndTransaction_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSmartCardTransactionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSmartCardTransaction_EndTransaction_Name:
        if (message.isResponse())
          paramsClass = SmartCardTransaction_EndTransaction_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SmartCardTransaction = {
    name: 'device.mojom.SmartCardTransaction',
    kVersion: 0,
    ptrClass: SmartCardTransactionPtr,
    proxyClass: SmartCardTransactionProxy,
    stubClass: SmartCardTransactionStub,
    validateRequest: validateSmartCardTransactionRequest,
    validateResponse: validateSmartCardTransactionResponse,
  };
  SmartCardTransactionStub.prototype.validator = validateSmartCardTransactionRequest;
  SmartCardTransactionProxy.prototype.validator = validateSmartCardTransactionResponse;
  var kSmartCardConnection_Disconnect_Name = 0;
  var kSmartCardConnection_Transmit_Name = 1;
  var kSmartCardConnection_Control_Name = 2;
  var kSmartCardConnection_GetAttrib_Name = 3;
  var kSmartCardConnection_SetAttrib_Name = 4;
  var kSmartCardConnection_Status_Name = 5;
  var kSmartCardConnection_BeginTransaction_Name = 6;

  function SmartCardConnectionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SmartCardConnection,
                                                   handleOrPtrInfo);
  }

  function SmartCardConnectionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SmartCardConnection, associatedInterfacePtrInfo);
  }

  SmartCardConnectionAssociatedPtr.prototype =
      Object.create(SmartCardConnectionPtr.prototype);
  SmartCardConnectionAssociatedPtr.prototype.constructor =
      SmartCardConnectionAssociatedPtr;

  function SmartCardConnectionProxy(receiver) {
    this.receiver_ = receiver;
  }
  SmartCardConnectionPtr.prototype.disconnect = function() {
    return SmartCardConnectionProxy.prototype.disconnect
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.disconnect = function(disposition) {
    var params_ = new SmartCardConnection_Disconnect_Params();
    params_.disposition = disposition;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardConnection_Disconnect_Name,
          codec.align(SmartCardConnection_Disconnect_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardConnection_Disconnect_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_Disconnect_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardConnectionPtr.prototype.transmit = function() {
    return SmartCardConnectionProxy.prototype.transmit
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.transmit = function(protocol, data) {
    var params_ = new SmartCardConnection_Transmit_Params();
    params_.protocol = protocol;
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardConnection_Transmit_Name,
          codec.align(SmartCardConnection_Transmit_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardConnection_Transmit_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_Transmit_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardConnectionPtr.prototype.control = function() {
    return SmartCardConnectionProxy.prototype.control
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.control = function(controlCode, data) {
    var params_ = new SmartCardConnection_Control_Params();
    params_.controlCode = controlCode;
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardConnection_Control_Name,
          codec.align(SmartCardConnection_Control_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardConnection_Control_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_Control_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardConnectionPtr.prototype.getAttrib = function() {
    return SmartCardConnectionProxy.prototype.getAttrib
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.getAttrib = function(id) {
    var params_ = new SmartCardConnection_GetAttrib_Params();
    params_.id = id;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardConnection_GetAttrib_Name,
          codec.align(SmartCardConnection_GetAttrib_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardConnection_GetAttrib_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_GetAttrib_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardConnectionPtr.prototype.setAttrib = function() {
    return SmartCardConnectionProxy.prototype.setAttrib
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.setAttrib = function(id, data) {
    var params_ = new SmartCardConnection_SetAttrib_Params();
    params_.id = id;
    params_.data = data;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardConnection_SetAttrib_Name,
          codec.align(SmartCardConnection_SetAttrib_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardConnection_SetAttrib_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_SetAttrib_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardConnectionPtr.prototype.status = function() {
    return SmartCardConnectionProxy.prototype.status
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.status = function() {
    var params_ = new SmartCardConnection_Status_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardConnection_Status_Name,
          codec.align(SmartCardConnection_Status_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardConnection_Status_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_Status_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardConnectionPtr.prototype.beginTransaction = function() {
    return SmartCardConnectionProxy.prototype.beginTransaction
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionProxy.prototype.beginTransaction = function() {
    var params_ = new SmartCardConnection_BeginTransaction_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kSmartCardConnection_BeginTransaction_Name,
          codec.align(SmartCardConnection_BeginTransaction_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(SmartCardConnection_BeginTransaction_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardConnection_BeginTransaction_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SmartCardConnectionStub(delegate) {
    this.delegate_ = delegate;
  }
  SmartCardConnectionStub.prototype.disconnect = function(disposition) {
    return this.delegate_ && this.delegate_.disconnect && this.delegate_.disconnect(disposition);
  }
  SmartCardConnectionStub.prototype.transmit = function(protocol, data) {
    return this.delegate_ && this.delegate_.transmit && this.delegate_.transmit(protocol, data);
  }
  SmartCardConnectionStub.prototype.control = function(controlCode, data) {
    return this.delegate_ && this.delegate_.control && this.delegate_.control(controlCode, data);
  }
  SmartCardConnectionStub.prototype.getAttrib = function(id) {
    return this.delegate_ && this.delegate_.getAttrib && this.delegate_.getAttrib(id);
  }
  SmartCardConnectionStub.prototype.setAttrib = function(id, data) {
    return this.delegate_ && this.delegate_.setAttrib && this.delegate_.setAttrib(id, data);
  }
  SmartCardConnectionStub.prototype.status = function() {
    return this.delegate_ && this.delegate_.status && this.delegate_.status();
  }
  SmartCardConnectionStub.prototype.beginTransaction = function() {
    return this.delegate_ && this.delegate_.beginTransaction && this.delegate_.beginTransaction();
  }

  SmartCardConnectionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SmartCardConnectionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSmartCardConnection_Disconnect_Name:
      var params = reader.decodeStruct(SmartCardConnection_Disconnect_Params);
      this.disconnect(params.disposition).then(function(response) {
        var responseParams =
            new SmartCardConnection_Disconnect_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardConnection_Disconnect_Name,
            codec.align(SmartCardConnection_Disconnect_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardConnection_Disconnect_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardConnection_Transmit_Name:
      var params = reader.decodeStruct(SmartCardConnection_Transmit_Params);
      this.transmit(params.protocol, params.data).then(function(response) {
        var responseParams =
            new SmartCardConnection_Transmit_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardConnection_Transmit_Name,
            codec.align(SmartCardConnection_Transmit_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardConnection_Transmit_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardConnection_Control_Name:
      var params = reader.decodeStruct(SmartCardConnection_Control_Params);
      this.control(params.controlCode, params.data).then(function(response) {
        var responseParams =
            new SmartCardConnection_Control_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardConnection_Control_Name,
            codec.align(SmartCardConnection_Control_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardConnection_Control_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardConnection_GetAttrib_Name:
      var params = reader.decodeStruct(SmartCardConnection_GetAttrib_Params);
      this.getAttrib(params.id).then(function(response) {
        var responseParams =
            new SmartCardConnection_GetAttrib_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardConnection_GetAttrib_Name,
            codec.align(SmartCardConnection_GetAttrib_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardConnection_GetAttrib_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardConnection_SetAttrib_Name:
      var params = reader.decodeStruct(SmartCardConnection_SetAttrib_Params);
      this.setAttrib(params.id, params.data).then(function(response) {
        var responseParams =
            new SmartCardConnection_SetAttrib_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardConnection_SetAttrib_Name,
            codec.align(SmartCardConnection_SetAttrib_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardConnection_SetAttrib_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardConnection_Status_Name:
      var params = reader.decodeStruct(SmartCardConnection_Status_Params);
      this.status().then(function(response) {
        var responseParams =
            new SmartCardConnection_Status_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardConnection_Status_Name,
            codec.align(SmartCardConnection_Status_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardConnection_Status_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardConnection_BeginTransaction_Name:
      var params = reader.decodeStruct(SmartCardConnection_BeginTransaction_Params);
      this.beginTransaction().then(function(response) {
        var responseParams =
            new SmartCardConnection_BeginTransaction_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV2Builder(
            kSmartCardConnection_BeginTransaction_Name,
            codec.align(SmartCardConnection_BeginTransaction_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(SmartCardConnection_BeginTransaction_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSmartCardConnectionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSmartCardConnection_Disconnect_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_Disconnect_Params;
      break;
      case kSmartCardConnection_Transmit_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_Transmit_Params;
      break;
      case kSmartCardConnection_Control_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_Control_Params;
      break;
      case kSmartCardConnection_GetAttrib_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_GetAttrib_Params;
      break;
      case kSmartCardConnection_SetAttrib_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_SetAttrib_Params;
      break;
      case kSmartCardConnection_Status_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_Status_Params;
      break;
      case kSmartCardConnection_BeginTransaction_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardConnection_BeginTransaction_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSmartCardConnectionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSmartCardConnection_Disconnect_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_Disconnect_ResponseParams;
        break;
      case kSmartCardConnection_Transmit_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_Transmit_ResponseParams;
        break;
      case kSmartCardConnection_Control_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_Control_ResponseParams;
        break;
      case kSmartCardConnection_GetAttrib_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_GetAttrib_ResponseParams;
        break;
      case kSmartCardConnection_SetAttrib_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_SetAttrib_ResponseParams;
        break;
      case kSmartCardConnection_Status_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_Status_ResponseParams;
        break;
      case kSmartCardConnection_BeginTransaction_Name:
        if (message.isResponse())
          paramsClass = SmartCardConnection_BeginTransaction_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SmartCardConnection = {
    name: 'device.mojom.SmartCardConnection',
    kVersion: 0,
    ptrClass: SmartCardConnectionPtr,
    proxyClass: SmartCardConnectionProxy,
    stubClass: SmartCardConnectionStub,
    validateRequest: validateSmartCardConnectionRequest,
    validateResponse: validateSmartCardConnectionResponse,
  };
  SmartCardConnectionStub.prototype.validator = validateSmartCardConnectionRequest;
  SmartCardConnectionProxy.prototype.validator = validateSmartCardConnectionResponse;
  var kSmartCardConnectionWatcher_NotifyConnectionUsed_Name = 0;

  function SmartCardConnectionWatcherPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SmartCardConnectionWatcher,
                                                   handleOrPtrInfo);
  }

  function SmartCardConnectionWatcherAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SmartCardConnectionWatcher, associatedInterfacePtrInfo);
  }

  SmartCardConnectionWatcherAssociatedPtr.prototype =
      Object.create(SmartCardConnectionWatcherPtr.prototype);
  SmartCardConnectionWatcherAssociatedPtr.prototype.constructor =
      SmartCardConnectionWatcherAssociatedPtr;

  function SmartCardConnectionWatcherProxy(receiver) {
    this.receiver_ = receiver;
  }
  SmartCardConnectionWatcherPtr.prototype.notifyConnectionUsed = function() {
    return SmartCardConnectionWatcherProxy.prototype.notifyConnectionUsed
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardConnectionWatcherProxy.prototype.notifyConnectionUsed = function() {
    var params_ = new SmartCardConnectionWatcher_NotifyConnectionUsed_Params();
    var builder = new codec.MessageV0Builder(
        kSmartCardConnectionWatcher_NotifyConnectionUsed_Name,
        codec.align(SmartCardConnectionWatcher_NotifyConnectionUsed_Params.encodedSize));
    builder.encodeStruct(SmartCardConnectionWatcher_NotifyConnectionUsed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SmartCardConnectionWatcherStub(delegate) {
    this.delegate_ = delegate;
  }
  SmartCardConnectionWatcherStub.prototype.notifyConnectionUsed = function() {
    return this.delegate_ && this.delegate_.notifyConnectionUsed && this.delegate_.notifyConnectionUsed();
  }

  SmartCardConnectionWatcherStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSmartCardConnectionWatcher_NotifyConnectionUsed_Name:
      var params = reader.decodeStruct(SmartCardConnectionWatcher_NotifyConnectionUsed_Params);
      this.notifyConnectionUsed();
      return true;
    default:
      return false;
    }
  };

  SmartCardConnectionWatcherStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSmartCardConnectionWatcherRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSmartCardConnectionWatcher_NotifyConnectionUsed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SmartCardConnectionWatcher_NotifyConnectionUsed_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSmartCardConnectionWatcherResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SmartCardConnectionWatcher = {
    name: 'device.mojom.SmartCardConnectionWatcher',
    kVersion: 0,
    ptrClass: SmartCardConnectionWatcherPtr,
    proxyClass: SmartCardConnectionWatcherProxy,
    stubClass: SmartCardConnectionWatcherStub,
    validateRequest: validateSmartCardConnectionWatcherRequest,
    validateResponse: null,
  };
  SmartCardConnectionWatcherStub.prototype.validator = validateSmartCardConnectionWatcherRequest;
  SmartCardConnectionWatcherProxy.prototype.validator = null;
  var kSmartCardContext_ListReaders_Name = 0;
  var kSmartCardContext_GetStatusChange_Name = 1;
  var kSmartCardContext_Cancel_Name = 2;
  var kSmartCardContext_Connect_Name = 3;

  function SmartCardContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SmartCardContext,
                                                   handleOrPtrInfo);
  }

  function SmartCardContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SmartCardContext, associatedInterfacePtrInfo);
  }

  SmartCardContextAssociatedPtr.prototype =
      Object.create(SmartCardContextPtr.prototype);
  SmartCardContextAssociatedPtr.prototype.constructor =
      SmartCardContextAssociatedPtr;

  function SmartCardContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  SmartCardContextPtr.prototype.listReaders = function() {
    return SmartCardContextProxy.prototype.listReaders
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardContextProxy.prototype.listReaders = function() {
    var params_ = new SmartCardContext_ListReaders_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardContext_ListReaders_Name,
          codec.align(SmartCardContext_ListReaders_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardContext_ListReaders_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardContext_ListReaders_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardContextPtr.prototype.getStatusChange = function() {
    return SmartCardContextProxy.prototype.getStatusChange
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardContextProxy.prototype.getStatusChange = function(timeout, readerStates) {
    var params_ = new SmartCardContext_GetStatusChange_Params();
    params_.timeout = timeout;
    params_.readerStates = readerStates;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardContext_GetStatusChange_Name,
          codec.align(SmartCardContext_GetStatusChange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardContext_GetStatusChange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardContext_GetStatusChange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardContextPtr.prototype.cancel = function() {
    return SmartCardContextProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardContextProxy.prototype.cancel = function() {
    var params_ = new SmartCardContext_Cancel_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardContext_Cancel_Name,
          codec.align(SmartCardContext_Cancel_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardContext_Cancel_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardContext_Cancel_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SmartCardContextPtr.prototype.connect = function() {
    return SmartCardContextProxy.prototype.connect
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardContextProxy.prototype.connect = function(reader, shareMode, preferredProtocols, connectionWatcher) {
    var params_ = new SmartCardContext_Connect_Params();
    params_.reader = reader;
    params_.shareMode = shareMode;
    params_.preferredProtocols = preferredProtocols;
    params_.connectionWatcher = connectionWatcher;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardContext_Connect_Name,
          codec.align(SmartCardContext_Connect_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardContext_Connect_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardContext_Connect_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SmartCardContextStub(delegate) {
    this.delegate_ = delegate;
  }
  SmartCardContextStub.prototype.listReaders = function() {
    return this.delegate_ && this.delegate_.listReaders && this.delegate_.listReaders();
  }
  SmartCardContextStub.prototype.getStatusChange = function(timeout, readerStates) {
    return this.delegate_ && this.delegate_.getStatusChange && this.delegate_.getStatusChange(timeout, readerStates);
  }
  SmartCardContextStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }
  SmartCardContextStub.prototype.connect = function(reader, shareMode, preferredProtocols, connectionWatcher) {
    return this.delegate_ && this.delegate_.connect && this.delegate_.connect(reader, shareMode, preferredProtocols, connectionWatcher);
  }

  SmartCardContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SmartCardContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSmartCardContext_ListReaders_Name:
      var params = reader.decodeStruct(SmartCardContext_ListReaders_Params);
      this.listReaders().then(function(response) {
        var responseParams =
            new SmartCardContext_ListReaders_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardContext_ListReaders_Name,
            codec.align(SmartCardContext_ListReaders_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardContext_ListReaders_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardContext_GetStatusChange_Name:
      var params = reader.decodeStruct(SmartCardContext_GetStatusChange_Params);
      this.getStatusChange(params.timeout, params.readerStates).then(function(response) {
        var responseParams =
            new SmartCardContext_GetStatusChange_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardContext_GetStatusChange_Name,
            codec.align(SmartCardContext_GetStatusChange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardContext_GetStatusChange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardContext_Cancel_Name:
      var params = reader.decodeStruct(SmartCardContext_Cancel_Params);
      this.cancel().then(function(response) {
        var responseParams =
            new SmartCardContext_Cancel_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardContext_Cancel_Name,
            codec.align(SmartCardContext_Cancel_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardContext_Cancel_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSmartCardContext_Connect_Name:
      var params = reader.decodeStruct(SmartCardContext_Connect_Params);
      this.connect(params.reader, params.shareMode, params.preferredProtocols, params.connectionWatcher).then(function(response) {
        var responseParams =
            new SmartCardContext_Connect_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardContext_Connect_Name,
            codec.align(SmartCardContext_Connect_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardContext_Connect_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSmartCardContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSmartCardContext_ListReaders_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardContext_ListReaders_Params;
      break;
      case kSmartCardContext_GetStatusChange_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardContext_GetStatusChange_Params;
      break;
      case kSmartCardContext_Cancel_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardContext_Cancel_Params;
      break;
      case kSmartCardContext_Connect_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardContext_Connect_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSmartCardContextResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSmartCardContext_ListReaders_Name:
        if (message.isResponse())
          paramsClass = SmartCardContext_ListReaders_ResponseParams;
        break;
      case kSmartCardContext_GetStatusChange_Name:
        if (message.isResponse())
          paramsClass = SmartCardContext_GetStatusChange_ResponseParams;
        break;
      case kSmartCardContext_Cancel_Name:
        if (message.isResponse())
          paramsClass = SmartCardContext_Cancel_ResponseParams;
        break;
      case kSmartCardContext_Connect_Name:
        if (message.isResponse())
          paramsClass = SmartCardContext_Connect_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SmartCardContext = {
    name: 'device.mojom.SmartCardContext',
    kVersion: 0,
    ptrClass: SmartCardContextPtr,
    proxyClass: SmartCardContextProxy,
    stubClass: SmartCardContextStub,
    validateRequest: validateSmartCardContextRequest,
    validateResponse: validateSmartCardContextResponse,
  };
  SmartCardContextStub.prototype.validator = validateSmartCardContextRequest;
  SmartCardContextProxy.prototype.validator = validateSmartCardContextResponse;
  var kSmartCardContextFactory_CreateContext_Name = 0;

  function SmartCardContextFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SmartCardContextFactory,
                                                   handleOrPtrInfo);
  }

  function SmartCardContextFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SmartCardContextFactory, associatedInterfacePtrInfo);
  }

  SmartCardContextFactoryAssociatedPtr.prototype =
      Object.create(SmartCardContextFactoryPtr.prototype);
  SmartCardContextFactoryAssociatedPtr.prototype.constructor =
      SmartCardContextFactoryAssociatedPtr;

  function SmartCardContextFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  SmartCardContextFactoryPtr.prototype.createContext = function() {
    return SmartCardContextFactoryProxy.prototype.createContext
        .apply(this.ptr.getProxy(), arguments);
  };

  SmartCardContextFactoryProxy.prototype.createContext = function() {
    var params_ = new SmartCardContextFactory_CreateContext_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSmartCardContextFactory_CreateContext_Name,
          codec.align(SmartCardContextFactory_CreateContext_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SmartCardContextFactory_CreateContext_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SmartCardContextFactory_CreateContext_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SmartCardContextFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  SmartCardContextFactoryStub.prototype.createContext = function() {
    return this.delegate_ && this.delegate_.createContext && this.delegate_.createContext();
  }

  SmartCardContextFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SmartCardContextFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSmartCardContextFactory_CreateContext_Name:
      var params = reader.decodeStruct(SmartCardContextFactory_CreateContext_Params);
      this.createContext().then(function(response) {
        var responseParams =
            new SmartCardContextFactory_CreateContext_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kSmartCardContextFactory_CreateContext_Name,
            codec.align(SmartCardContextFactory_CreateContext_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SmartCardContextFactory_CreateContext_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSmartCardContextFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSmartCardContextFactory_CreateContext_Name:
        if (message.expectsResponse())
          paramsClass = SmartCardContextFactory_CreateContext_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSmartCardContextFactoryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSmartCardContextFactory_CreateContext_Name:
        if (message.isResponse())
          paramsClass = SmartCardContextFactory_CreateContext_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SmartCardContextFactory = {
    name: 'device.mojom.SmartCardContextFactory',
    kVersion: 0,
    ptrClass: SmartCardContextFactoryPtr,
    proxyClass: SmartCardContextFactoryProxy,
    stubClass: SmartCardContextFactoryStub,
    validateRequest: validateSmartCardContextFactoryRequest,
    validateResponse: validateSmartCardContextFactoryResponse,
  };
  SmartCardContextFactoryStub.prototype.validator = validateSmartCardContextFactoryRequest;
  SmartCardContextFactoryProxy.prototype.validator = validateSmartCardContextFactoryResponse;
  exports.SmartCardSuccess = SmartCardSuccess;
  exports.SmartCardError = SmartCardError;
  exports.SmartCardShareMode = SmartCardShareMode;
  exports.SmartCardProtocol = SmartCardProtocol;
  exports.SmartCardDisposition = SmartCardDisposition;
  exports.SmartCardConnectionState = SmartCardConnectionState;
  exports.SmartCardReaderStateFlags = SmartCardReaderStateFlags;
  exports.SmartCardReaderStateIn = SmartCardReaderStateIn;
  exports.SmartCardReaderStateOut = SmartCardReaderStateOut;
  exports.SmartCardProtocols = SmartCardProtocols;
  exports.SmartCardStatus = SmartCardStatus;
  exports.SmartCardConnectSuccess = SmartCardConnectSuccess;
  exports.SmartCardResult = SmartCardResult;
  exports.SmartCardStatusChangeResult = SmartCardStatusChangeResult;
  exports.SmartCardListReadersResult = SmartCardListReadersResult;
  exports.SmartCardCreateContextResult = SmartCardCreateContextResult;
  exports.SmartCardConnectResult = SmartCardConnectResult;
  exports.SmartCardDataResult = SmartCardDataResult;
  exports.SmartCardStatusResult = SmartCardStatusResult;
  exports.SmartCardTransactionResult = SmartCardTransactionResult;
  exports.SmartCardTransaction = SmartCardTransaction;
  exports.SmartCardTransactionPtr = SmartCardTransactionPtr;
  exports.SmartCardTransactionAssociatedPtr = SmartCardTransactionAssociatedPtr;
  exports.SmartCardConnection = SmartCardConnection;
  exports.SmartCardConnectionPtr = SmartCardConnectionPtr;
  exports.SmartCardConnectionAssociatedPtr = SmartCardConnectionAssociatedPtr;
  exports.SmartCardConnectionWatcher = SmartCardConnectionWatcher;
  exports.SmartCardConnectionWatcherPtr = SmartCardConnectionWatcherPtr;
  exports.SmartCardConnectionWatcherAssociatedPtr = SmartCardConnectionWatcherAssociatedPtr;
  exports.SmartCardContext = SmartCardContext;
  exports.SmartCardContextPtr = SmartCardContextPtr;
  exports.SmartCardContextAssociatedPtr = SmartCardContextAssociatedPtr;
  exports.SmartCardContextFactory = SmartCardContextFactory;
  exports.SmartCardContextFactoryPtr = SmartCardContextFactoryPtr;
  exports.SmartCardContextFactoryAssociatedPtr = SmartCardContextFactoryAssociatedPtr;
})();