// services/device/public/mojom/smart_card.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_BLINK_TEST_UTILS_H_

#include "services/device/public/mojom/smart_card.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace device::mojom::blink {


class BLINK_PLATFORM_EXPORT SmartCardTransactionInterceptorForTesting : public SmartCardTransaction {
  virtual SmartCardTransaction* GetForwardingInterface() = 0;
  void EndTransaction(SmartCardDisposition disposition, EndTransactionCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SmartCardTransactionAsyncWaiter {
 public:
  explicit SmartCardTransactionAsyncWaiter(SmartCardTransaction* proxy);

  SmartCardTransactionAsyncWaiter(const SmartCardTransactionAsyncWaiter&) = delete;
  SmartCardTransactionAsyncWaiter& operator=(const SmartCardTransactionAsyncWaiter&) = delete;

  ~SmartCardTransactionAsyncWaiter();
  void EndTransaction(
      SmartCardDisposition disposition, SmartCardResultPtr* out_result);
  SmartCardResultPtr EndTransaction(SmartCardDisposition disposition);

 private:
  SmartCardTransaction* const proxy_;
};


class BLINK_PLATFORM_EXPORT SmartCardConnectionInterceptorForTesting : public SmartCardConnection {
  virtual SmartCardConnection* GetForwardingInterface() = 0;
  void Disconnect(SmartCardDisposition disposition, DisconnectCallback callback) override;
  void Transmit(SmartCardProtocol protocol, const ::blink::Vector<uint8_t>& data, TransmitCallback callback) override;
  void Control(uint32_t control_code, const ::blink::Vector<uint8_t>& data, ControlCallback callback) override;
  void GetAttrib(uint32_t id, GetAttribCallback callback) override;
  void SetAttrib(uint32_t id, const ::blink::Vector<uint8_t>& data, SetAttribCallback callback) override;
  void Status(StatusCallback callback) override;
  void BeginTransaction(BeginTransactionCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SmartCardConnectionAsyncWaiter {
 public:
  explicit SmartCardConnectionAsyncWaiter(SmartCardConnection* proxy);

  SmartCardConnectionAsyncWaiter(const SmartCardConnectionAsyncWaiter&) = delete;
  SmartCardConnectionAsyncWaiter& operator=(const SmartCardConnectionAsyncWaiter&) = delete;

  ~SmartCardConnectionAsyncWaiter();
  void Disconnect(
      SmartCardDisposition disposition, SmartCardResultPtr* out_result);
  SmartCardResultPtr Disconnect(SmartCardDisposition disposition);
  void Transmit(
      SmartCardProtocol protocol, const ::blink::Vector<uint8_t>& data, SmartCardDataResultPtr* out_result);
  SmartCardDataResultPtr Transmit(SmartCardProtocol protocol, const ::blink::Vector<uint8_t>& data);
  void Control(
      uint32_t control_code, const ::blink::Vector<uint8_t>& data, SmartCardDataResultPtr* out_result);
  SmartCardDataResultPtr Control(uint32_t control_code, const ::blink::Vector<uint8_t>& data);
  void GetAttrib(
      uint32_t id, SmartCardDataResultPtr* out_result);
  SmartCardDataResultPtr GetAttrib(uint32_t id);
  void SetAttrib(
      uint32_t id, const ::blink::Vector<uint8_t>& data, SmartCardResultPtr* out_result);
  SmartCardResultPtr SetAttrib(uint32_t id, const ::blink::Vector<uint8_t>& data);
  void Status(
      SmartCardStatusResultPtr* out_result);
  SmartCardStatusResultPtr Status();
  void BeginTransaction(
      SmartCardTransactionResultPtr* out_result);
  SmartCardTransactionResultPtr BeginTransaction();

 private:
  SmartCardConnection* const proxy_;
};


class BLINK_PLATFORM_EXPORT SmartCardConnectionWatcherInterceptorForTesting : public SmartCardConnectionWatcher {
  virtual SmartCardConnectionWatcher* GetForwardingInterface() = 0;
  void NotifyConnectionUsed() override;
};
class BLINK_PLATFORM_EXPORT SmartCardConnectionWatcherAsyncWaiter {
 public:
  explicit SmartCardConnectionWatcherAsyncWaiter(SmartCardConnectionWatcher* proxy);

  SmartCardConnectionWatcherAsyncWaiter(const SmartCardConnectionWatcherAsyncWaiter&) = delete;
  SmartCardConnectionWatcherAsyncWaiter& operator=(const SmartCardConnectionWatcherAsyncWaiter&) = delete;

  ~SmartCardConnectionWatcherAsyncWaiter();

 private:
  SmartCardConnectionWatcher* const proxy_;
};


class BLINK_PLATFORM_EXPORT SmartCardContextInterceptorForTesting : public SmartCardContext {
  virtual SmartCardContext* GetForwardingInterface() = 0;
  void ListReaders(ListReadersCallback callback) override;
  void GetStatusChange(::base::TimeDelta timeout, ::blink::Vector<SmartCardReaderStateInPtr> reader_states, GetStatusChangeCallback callback) override;
  void Cancel(CancelCallback callback) override;
  void Connect(const ::blink::String& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, ::mojo::PendingRemote<SmartCardConnectionWatcher> connection_watcher, ConnectCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SmartCardContextAsyncWaiter {
 public:
  explicit SmartCardContextAsyncWaiter(SmartCardContext* proxy);

  SmartCardContextAsyncWaiter(const SmartCardContextAsyncWaiter&) = delete;
  SmartCardContextAsyncWaiter& operator=(const SmartCardContextAsyncWaiter&) = delete;

  ~SmartCardContextAsyncWaiter();
  void ListReaders(
      SmartCardListReadersResultPtr* out_result);
  SmartCardListReadersResultPtr ListReaders();
  void GetStatusChange(
      ::base::TimeDelta timeout, ::blink::Vector<SmartCardReaderStateInPtr> reader_states, SmartCardStatusChangeResultPtr* out_result);
  SmartCardStatusChangeResultPtr GetStatusChange(::base::TimeDelta timeout, ::blink::Vector<SmartCardReaderStateInPtr> reader_states);
  void Cancel(
      SmartCardResultPtr* out_result);
  SmartCardResultPtr Cancel();
  void Connect(
      const ::blink::String& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, ::mojo::PendingRemote<SmartCardConnectionWatcher> connection_watcher, SmartCardConnectResultPtr* out_result);
  SmartCardConnectResultPtr Connect(const ::blink::String& reader, SmartCardShareMode share_mode, SmartCardProtocolsPtr preferred_protocols, ::mojo::PendingRemote<SmartCardConnectionWatcher> connection_watcher);

 private:
  SmartCardContext* const proxy_;
};


class BLINK_PLATFORM_EXPORT SmartCardContextFactoryInterceptorForTesting : public SmartCardContextFactory {
  virtual SmartCardContextFactory* GetForwardingInterface() = 0;
  void CreateContext(CreateContextCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SmartCardContextFactoryAsyncWaiter {
 public:
  explicit SmartCardContextFactoryAsyncWaiter(SmartCardContextFactory* proxy);

  SmartCardContextFactoryAsyncWaiter(const SmartCardContextFactoryAsyncWaiter&) = delete;
  SmartCardContextFactoryAsyncWaiter& operator=(const SmartCardContextFactoryAsyncWaiter&) = delete;

  ~SmartCardContextFactoryAsyncWaiter();
  void CreateContext(
      SmartCardCreateContextResultPtr* out_result);
  SmartCardCreateContextResultPtr CreateContext();

 private:
  SmartCardContextFactory* const proxy_;
};




}  // device::mojom::blink

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_BLINK_TEST_UTILS_H_