// services/device/public/mojom/serial.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/serial.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/serial.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/serial.mojom-forward.h"  // IWYU pragma: export
#include "device/bluetooth/public/mojom/uuid.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace device::mojom {

class SerialPortManagerProxy;

template <typename ImplRefTraits>
class SerialPortManagerStub;

class SerialPortManagerRequestValidator;
class SerialPortManagerResponseValidator;


class SerialPortManager
    : public SerialPortManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SerialPortManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialPortManagerInterfaceBase;
  using Proxy_ = SerialPortManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialPortManagerStub<ImplRefTraits>;

  using RequestValidator_ = SerialPortManagerRequestValidator;
  using ResponseValidator_ = SerialPortManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kOpenPortMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenPort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialPortManager() = default;

  virtual void SetClient(::mojo::PendingRemote<SerialPortManagerClient> client) = 0;

  using GetDevicesCallback = base::OnceCallback<void(std::vector<SerialPortInfoPtr>)>;
  using GetDevicesMojoCallback = base::OnceCallback<void(std::vector<SerialPortInfoPtr>)>;

  virtual void GetDevices(GetDevicesCallback callback) = 0;

  using OpenPortCallback = base::OnceCallback<void(::mojo::PendingRemote<SerialPort>)>;
  using OpenPortMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<SerialPort>)>;

  virtual void OpenPort(const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher, OpenPortCallback callback) = 0;
};

class SerialPortManagerClientProxy;

template <typename ImplRefTraits>
class SerialPortManagerClientStub;

class SerialPortManagerClientRequestValidator;


class SerialPortManagerClient
    : public SerialPortManagerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SerialPortManagerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialPortManagerClientInterfaceBase;
  using Proxy_ = SerialPortManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialPortManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = SerialPortManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPortAddedMinVersion = 0,
    kOnPortRemovedMinVersion = 0,
    kOnPortConnectedStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPortAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPortRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPortConnectedStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialPortManagerClient() = default;

  virtual void OnPortAdded(SerialPortInfoPtr port_info) = 0;

  virtual void OnPortRemoved(SerialPortInfoPtr port_info) = 0;

  virtual void OnPortConnectedStateChanged(SerialPortInfoPtr port_info) = 0;
};

class SerialPortProxy;

template <typename ImplRefTraits>
class SerialPortStub;

class SerialPortRequestValidator;
class SerialPortResponseValidator;


class SerialPort
    : public SerialPortInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SerialPort";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialPortInterfaceBase;
  using Proxy_ = SerialPortProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialPortStub<ImplRefTraits>;

  using RequestValidator_ = SerialPortRequestValidator;
  using ResponseValidator_ = SerialPortResponseValidator;
  enum MethodMinVersions : uint32_t {
    kStartWritingMinVersion = 0,
    kStartReadingMinVersion = 0,
    kFlushMinVersion = 0,
    kDrainMinVersion = 0,
    kGetControlSignalsMinVersion = 0,
    kSetControlSignalsMinVersion = 0,
    kConfigurePortMinVersion = 0,
    kGetPortInfoMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartWriting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartReading_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Drain_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetControlSignals_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetControlSignals_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConfigurePort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPortInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialPort() = default;

  virtual void StartWriting(::mojo::ScopedDataPipeConsumerHandle consumer) = 0;

  virtual void StartReading(::mojo::ScopedDataPipeProducerHandle producer) = 0;

  using FlushCallback = base::OnceCallback<void()>;
  using FlushMojoCallback = base::OnceCallback<void()>;

  virtual void Flush(SerialPortFlushMode mode, FlushCallback callback) = 0;

  using DrainCallback = base::OnceCallback<void()>;
  using DrainMojoCallback = base::OnceCallback<void()>;

  virtual void Drain(DrainCallback callback) = 0;

  using GetControlSignalsCallback = base::OnceCallback<void(SerialPortControlSignalsPtr)>;
  using GetControlSignalsMojoCallback = base::OnceCallback<void(SerialPortControlSignalsPtr)>;

  virtual void GetControlSignals(GetControlSignalsCallback callback) = 0;

  using SetControlSignalsCallback = base::OnceCallback<void(bool)>;
  using SetControlSignalsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetControlSignals(SerialHostControlSignalsPtr signals, SetControlSignalsCallback callback) = 0;

  using ConfigurePortCallback = base::OnceCallback<void(bool)>;
  using ConfigurePortMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ConfigurePort(SerialConnectionOptionsPtr options, ConfigurePortCallback callback) = 0;

  using GetPortInfoCallback = base::OnceCallback<void(SerialConnectionInfoPtr)>;
  using GetPortInfoMojoCallback = base::OnceCallback<void(SerialConnectionInfoPtr)>;

  virtual void GetPortInfo(GetPortInfoCallback callback) = 0;

  using CloseCallback = base::OnceCallback<void()>;
  using CloseMojoCallback = base::OnceCallback<void()>;

  virtual void Close(bool flush, CloseCallback callback) = 0;
};

class SerialPortClientProxy;

template <typename ImplRefTraits>
class SerialPortClientStub;

class SerialPortClientRequestValidator;


class SerialPortClient
    : public SerialPortClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SerialPortClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialPortClientInterfaceBase;
  using Proxy_ = SerialPortClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialPortClientStub<ImplRefTraits>;

  using RequestValidator_ = SerialPortClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnReadErrorMinVersion = 0,
    kOnSendErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnReadError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSendError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialPortClient() = default;

  virtual void OnReadError(SerialReceiveError error) = 0;

  virtual void OnSendError(SerialSendError error) = 0;
};

class SerialPortConnectionWatcherProxy;

template <typename ImplRefTraits>
class SerialPortConnectionWatcherStub;

class SerialPortConnectionWatcherRequestValidator;


class SerialPortConnectionWatcher
    : public SerialPortConnectionWatcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.SerialPortConnectionWatcher";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SerialPortConnectionWatcherInterfaceBase;
  using Proxy_ = SerialPortConnectionWatcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = SerialPortConnectionWatcherStub<ImplRefTraits>;

  using RequestValidator_ = SerialPortConnectionWatcherRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SerialPortConnectionWatcher() = default;
};



class  SerialPortManagerProxy
    : public SerialPortManager {
 public:
  using InterfaceType = SerialPortManager;

  explicit SerialPortManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<SerialPortManagerClient> client) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void OpenPort(const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher, OpenPortCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SerialPortManagerClientProxy
    : public SerialPortManagerClient {
 public:
  using InterfaceType = SerialPortManagerClient;

  explicit SerialPortManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPortAdded(SerialPortInfoPtr port_info) final;
  
  void OnPortRemoved(SerialPortInfoPtr port_info) final;
  
  void OnPortConnectedStateChanged(SerialPortInfoPtr port_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SerialPortProxy
    : public SerialPort {
 public:
  using InterfaceType = SerialPort;

  explicit SerialPortProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartWriting(::mojo::ScopedDataPipeConsumerHandle consumer) final;
  
  void StartReading(::mojo::ScopedDataPipeProducerHandle producer) final;
  
  void Flush(SerialPortFlushMode mode, FlushCallback callback) final;
  
  void Drain(DrainCallback callback) final;
  
  void GetControlSignals(GetControlSignalsCallback callback) final;
  
  void SetControlSignals(SerialHostControlSignalsPtr signals, SetControlSignalsCallback callback) final;
  
  void ConfigurePort(SerialConnectionOptionsPtr options, ConfigurePortCallback callback) final;
  
  void GetPortInfo(GetPortInfoCallback callback) final;
  
  void Close(bool flush, CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SerialPortClientProxy
    : public SerialPortClient {
 public:
  using InterfaceType = SerialPortClient;

  explicit SerialPortClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnReadError(SerialReceiveError error) final;
  
  void OnSendError(SerialSendError error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SerialPortConnectionWatcherProxy
    : public SerialPortConnectionWatcher {
 public:
  using InterfaceType = SerialPortConnectionWatcher;

  explicit SerialPortConnectionWatcherProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SerialPortManagerStubDispatch {
 public:
  static bool Accept(SerialPortManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialPortManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialPortManager>>
class SerialPortManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialPortManagerStub() = default;
  ~SerialPortManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SerialPortManagerClientStubDispatch {
 public:
  static bool Accept(SerialPortManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialPortManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialPortManagerClient>>
class SerialPortManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialPortManagerClientStub() = default;
  ~SerialPortManagerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SerialPortStubDispatch {
 public:
  static bool Accept(SerialPort* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialPort* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialPort>>
class SerialPortStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialPortStub() = default;
  ~SerialPortStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SerialPortClientStubDispatch {
 public:
  static bool Accept(SerialPortClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialPortClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialPortClient>>
class SerialPortClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialPortClientStub() = default;
  ~SerialPortClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SerialPortConnectionWatcherStubDispatch {
 public:
  static bool Accept(SerialPortConnectionWatcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SerialPortConnectionWatcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SerialPortConnectionWatcher>>
class SerialPortConnectionWatcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SerialPortConnectionWatcherStub() = default;
  ~SerialPortConnectionWatcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortConnectionWatcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SerialPortConnectionWatcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SerialPortManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SerialPortManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SerialPortRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SerialPortClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SerialPortConnectionWatcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SerialPortManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SerialPortResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  SerialPortControlSignals {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialPortControlSignals, T>::value>;
  using DataView = SerialPortControlSignalsDataView;
  using Data_ = internal::SerialPortControlSignals_Data;

  template <typename... Args>
  static SerialPortControlSignalsPtr New(Args&&... args) {
    return SerialPortControlSignalsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialPortControlSignalsPtr From(const U& u) {
    return mojo::TypeConverter<SerialPortControlSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialPortControlSignals>::Convert(*this);
  }


  SerialPortControlSignals();

  SerialPortControlSignals(
      bool dcd,
      bool cts,
      bool ri,
      bool dsr);


  ~SerialPortControlSignals();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialPortControlSignalsPtr>
  SerialPortControlSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialPortControlSignals::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialPortControlSignals::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialPortControlSignals::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialPortControlSignals_UnserializedMessageContext<
            UserType, SerialPortControlSignals::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialPortControlSignals::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialPortControlSignals::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialPortControlSignals_UnserializedMessageContext<
            UserType, SerialPortControlSignals::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialPortControlSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool dcd;
  
  bool cts;
  
  bool ri;
  
  bool dsr;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialPortControlSignals::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  SerialPortInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialPortInfo, T>::value>;
  using DataView = SerialPortInfoDataView;
  using Data_ = internal::SerialPortInfo_Data;

  template <typename... Args>
  static SerialPortInfoPtr New(Args&&... args) {
    return SerialPortInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialPortInfoPtr From(const U& u) {
    return mojo::TypeConverter<SerialPortInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialPortInfo>::Convert(*this);
  }


  SerialPortInfo();

  SerialPortInfo(
      const ::base::UnguessableToken& token,
      const ::base::FilePath& path,
      SerialPortType type,
      const std::optional<::base::FilePath>& alternate_path,
      const std::optional<std::string>& usb_driver_name,
      uint16_t vendor_id,
      bool has_vendor_id,
      uint16_t product_id,
      bool has_product_id,
      const std::optional<::device::BluetoothUUID>& bluetooth_service_class_id,
      const std::optional<std::string>& display_name,
      const std::optional<std::string>& serial_number,
      bool connected);


  ~SerialPortInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialPortInfoPtr>
  SerialPortInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialPortInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialPortInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialPortInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialPortInfo_UnserializedMessageContext<
            UserType, SerialPortInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialPortInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialPortInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialPortInfo_UnserializedMessageContext<
            UserType, SerialPortInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialPortInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken token;
  
  ::base::FilePath path;
  
  SerialPortType type;
  
  std::optional<::base::FilePath> alternate_path;
  
  std::optional<std::string> usb_driver_name;
  
  uint16_t vendor_id;
  
  bool has_vendor_id;
  
  uint16_t product_id;
  
  bool has_product_id;
  
  std::optional<::device::BluetoothUUID> bluetooth_service_class_id;
  
  std::optional<std::string> display_name;
  
  std::optional<std::string> serial_number;
  
  bool connected;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialPortInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SerialConnectionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialConnectionOptions, T>::value>;
  using DataView = SerialConnectionOptionsDataView;
  using Data_ = internal::SerialConnectionOptions_Data;

  template <typename... Args>
  static SerialConnectionOptionsPtr New(Args&&... args) {
    return SerialConnectionOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialConnectionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<SerialConnectionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialConnectionOptions>::Convert(*this);
  }


  SerialConnectionOptions();

  SerialConnectionOptions(
      uint32_t bitrate,
      SerialDataBits data_bits,
      SerialParityBit parity_bit,
      SerialStopBits stop_bits,
      bool cts_flow_control,
      bool has_cts_flow_control);


  ~SerialConnectionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialConnectionOptionsPtr>
  SerialConnectionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialConnectionOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialConnectionOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialConnectionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialConnectionOptions_UnserializedMessageContext<
            UserType, SerialConnectionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialConnectionOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialConnectionOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialConnectionOptions_UnserializedMessageContext<
            UserType, SerialConnectionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialConnectionOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t bitrate;
  
  SerialDataBits data_bits;
  
  SerialParityBit parity_bit;
  
  SerialStopBits stop_bits;
  
  bool cts_flow_control;
  
  bool has_cts_flow_control;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialConnectionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SerialConnectionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialConnectionInfo, T>::value>;
  using DataView = SerialConnectionInfoDataView;
  using Data_ = internal::SerialConnectionInfo_Data;

  template <typename... Args>
  static SerialConnectionInfoPtr New(Args&&... args) {
    return SerialConnectionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialConnectionInfoPtr From(const U& u) {
    return mojo::TypeConverter<SerialConnectionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialConnectionInfo>::Convert(*this);
  }


  SerialConnectionInfo();

  SerialConnectionInfo(
      uint32_t bitrate,
      SerialDataBits data_bits,
      SerialParityBit parity_bit,
      SerialStopBits stop_bits,
      bool cts_flow_control);


  ~SerialConnectionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialConnectionInfoPtr>
  SerialConnectionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialConnectionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialConnectionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialConnectionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialConnectionInfo_UnserializedMessageContext<
            UserType, SerialConnectionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialConnectionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialConnectionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialConnectionInfo_UnserializedMessageContext<
            UserType, SerialConnectionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialConnectionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t bitrate;
  
  SerialDataBits data_bits;
  
  SerialParityBit parity_bit;
  
  SerialStopBits stop_bits;
  
  bool cts_flow_control;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialConnectionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SerialHostControlSignals {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerialHostControlSignals, T>::value>;
  using DataView = SerialHostControlSignalsDataView;
  using Data_ = internal::SerialHostControlSignals_Data;

  template <typename... Args>
  static SerialHostControlSignalsPtr New(Args&&... args) {
    return SerialHostControlSignalsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerialHostControlSignalsPtr From(const U& u) {
    return mojo::TypeConverter<SerialHostControlSignalsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerialHostControlSignals>::Convert(*this);
  }


  SerialHostControlSignals();

  SerialHostControlSignals(
      bool dtr,
      bool has_dtr,
      bool rts,
      bool has_rts,
      bool brk,
      bool has_brk);


  ~SerialHostControlSignals();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerialHostControlSignalsPtr>
  SerialHostControlSignalsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialHostControlSignals::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerialHostControlSignals::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerialHostControlSignals::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerialHostControlSignals_UnserializedMessageContext<
            UserType, SerialHostControlSignals::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerialHostControlSignals::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerialHostControlSignals::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerialHostControlSignals_UnserializedMessageContext<
            UserType, SerialHostControlSignals::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerialHostControlSignals::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool dtr;
  
  bool has_dtr;
  
  bool rts;
  
  bool has_rts;
  
  bool brk;
  
  bool has_brk;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerialHostControlSignals::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
SerialPortInfoPtr SerialPortInfo::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(path),
      mojo::Clone(type),
      mojo::Clone(alternate_path),
      mojo::Clone(usb_driver_name),
      mojo::Clone(vendor_id),
      mojo::Clone(has_vendor_id),
      mojo::Clone(product_id),
      mojo::Clone(has_product_id),
      mojo::Clone(bluetooth_service_class_id),
      mojo::Clone(display_name),
      mojo::Clone(serial_number),
      mojo::Clone(connected)
  );
}

template <typename T, SerialPortInfo::EnableIfSame<T>*>
bool SerialPortInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->alternate_path, other_struct.alternate_path))
    return false;
  if (!mojo::Equals(this->usb_driver_name, other_struct.usb_driver_name))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->has_vendor_id, other_struct.has_vendor_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->has_product_id, other_struct.has_product_id))
    return false;
  if (!mojo::Equals(this->bluetooth_service_class_id, other_struct.bluetooth_service_class_id))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  if (!mojo::Equals(this->connected, other_struct.connected))
    return false;
  return true;
}

template <typename T, SerialPortInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.alternate_path < rhs.alternate_path)
    return true;
  if (rhs.alternate_path < lhs.alternate_path)
    return false;
  if (lhs.usb_driver_name < rhs.usb_driver_name)
    return true;
  if (rhs.usb_driver_name < lhs.usb_driver_name)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.has_vendor_id < rhs.has_vendor_id)
    return true;
  if (rhs.has_vendor_id < lhs.has_vendor_id)
    return false;
  if (lhs.product_id < rhs.product_id)
    return true;
  if (rhs.product_id < lhs.product_id)
    return false;
  if (lhs.has_product_id < rhs.has_product_id)
    return true;
  if (rhs.has_product_id < lhs.has_product_id)
    return false;
  if (lhs.bluetooth_service_class_id < rhs.bluetooth_service_class_id)
    return true;
  if (rhs.bluetooth_service_class_id < lhs.bluetooth_service_class_id)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.serial_number < rhs.serial_number)
    return true;
  if (rhs.serial_number < lhs.serial_number)
    return false;
  if (lhs.connected < rhs.connected)
    return true;
  if (rhs.connected < lhs.connected)
    return false;
  return false;
}
template <typename StructPtrType>
SerialConnectionOptionsPtr SerialConnectionOptions::Clone() const {
  return New(
      mojo::Clone(bitrate),
      mojo::Clone(data_bits),
      mojo::Clone(parity_bit),
      mojo::Clone(stop_bits),
      mojo::Clone(cts_flow_control),
      mojo::Clone(has_cts_flow_control)
  );
}

template <typename T, SerialConnectionOptions::EnableIfSame<T>*>
bool SerialConnectionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitrate, other_struct.bitrate))
    return false;
  if (!mojo::Equals(this->data_bits, other_struct.data_bits))
    return false;
  if (!mojo::Equals(this->parity_bit, other_struct.parity_bit))
    return false;
  if (!mojo::Equals(this->stop_bits, other_struct.stop_bits))
    return false;
  if (!mojo::Equals(this->cts_flow_control, other_struct.cts_flow_control))
    return false;
  if (!mojo::Equals(this->has_cts_flow_control, other_struct.has_cts_flow_control))
    return false;
  return true;
}

template <typename T, SerialConnectionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitrate < rhs.bitrate)
    return true;
  if (rhs.bitrate < lhs.bitrate)
    return false;
  if (lhs.data_bits < rhs.data_bits)
    return true;
  if (rhs.data_bits < lhs.data_bits)
    return false;
  if (lhs.parity_bit < rhs.parity_bit)
    return true;
  if (rhs.parity_bit < lhs.parity_bit)
    return false;
  if (lhs.stop_bits < rhs.stop_bits)
    return true;
  if (rhs.stop_bits < lhs.stop_bits)
    return false;
  if (lhs.cts_flow_control < rhs.cts_flow_control)
    return true;
  if (rhs.cts_flow_control < lhs.cts_flow_control)
    return false;
  if (lhs.has_cts_flow_control < rhs.has_cts_flow_control)
    return true;
  if (rhs.has_cts_flow_control < lhs.has_cts_flow_control)
    return false;
  return false;
}
template <typename StructPtrType>
SerialConnectionInfoPtr SerialConnectionInfo::Clone() const {
  return New(
      mojo::Clone(bitrate),
      mojo::Clone(data_bits),
      mojo::Clone(parity_bit),
      mojo::Clone(stop_bits),
      mojo::Clone(cts_flow_control)
  );
}

template <typename T, SerialConnectionInfo::EnableIfSame<T>*>
bool SerialConnectionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bitrate, other_struct.bitrate))
    return false;
  if (!mojo::Equals(this->data_bits, other_struct.data_bits))
    return false;
  if (!mojo::Equals(this->parity_bit, other_struct.parity_bit))
    return false;
  if (!mojo::Equals(this->stop_bits, other_struct.stop_bits))
    return false;
  if (!mojo::Equals(this->cts_flow_control, other_struct.cts_flow_control))
    return false;
  return true;
}

template <typename T, SerialConnectionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bitrate < rhs.bitrate)
    return true;
  if (rhs.bitrate < lhs.bitrate)
    return false;
  if (lhs.data_bits < rhs.data_bits)
    return true;
  if (rhs.data_bits < lhs.data_bits)
    return false;
  if (lhs.parity_bit < rhs.parity_bit)
    return true;
  if (rhs.parity_bit < lhs.parity_bit)
    return false;
  if (lhs.stop_bits < rhs.stop_bits)
    return true;
  if (rhs.stop_bits < lhs.stop_bits)
    return false;
  if (lhs.cts_flow_control < rhs.cts_flow_control)
    return true;
  if (rhs.cts_flow_control < lhs.cts_flow_control)
    return false;
  return false;
}
template <typename StructPtrType>
SerialHostControlSignalsPtr SerialHostControlSignals::Clone() const {
  return New(
      mojo::Clone(dtr),
      mojo::Clone(has_dtr),
      mojo::Clone(rts),
      mojo::Clone(has_rts),
      mojo::Clone(brk),
      mojo::Clone(has_brk)
  );
}

template <typename T, SerialHostControlSignals::EnableIfSame<T>*>
bool SerialHostControlSignals::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dtr, other_struct.dtr))
    return false;
  if (!mojo::Equals(this->has_dtr, other_struct.has_dtr))
    return false;
  if (!mojo::Equals(this->rts, other_struct.rts))
    return false;
  if (!mojo::Equals(this->has_rts, other_struct.has_rts))
    return false;
  if (!mojo::Equals(this->brk, other_struct.brk))
    return false;
  if (!mojo::Equals(this->has_brk, other_struct.has_brk))
    return false;
  return true;
}

template <typename T, SerialHostControlSignals::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dtr < rhs.dtr)
    return true;
  if (rhs.dtr < lhs.dtr)
    return false;
  if (lhs.has_dtr < rhs.has_dtr)
    return true;
  if (rhs.has_dtr < lhs.has_dtr)
    return false;
  if (lhs.rts < rhs.rts)
    return true;
  if (rhs.rts < lhs.rts)
    return false;
  if (lhs.has_rts < rhs.has_rts)
    return true;
  if (rhs.has_rts < lhs.has_rts)
    return false;
  if (lhs.brk < rhs.brk)
    return true;
  if (rhs.brk < lhs.brk)
    return false;
  if (lhs.has_brk < rhs.has_brk)
    return true;
  if (rhs.has_brk < lhs.has_brk)
    return false;
  return false;
}
template <typename StructPtrType>
SerialPortControlSignalsPtr SerialPortControlSignals::Clone() const {
  return New(
      mojo::Clone(dcd),
      mojo::Clone(cts),
      mojo::Clone(ri),
      mojo::Clone(dsr)
  );
}

template <typename T, SerialPortControlSignals::EnableIfSame<T>*>
bool SerialPortControlSignals::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->dcd, other_struct.dcd))
    return false;
  if (!mojo::Equals(this->cts, other_struct.cts))
    return false;
  if (!mojo::Equals(this->ri, other_struct.ri))
    return false;
  if (!mojo::Equals(this->dsr, other_struct.dsr))
    return false;
  return true;
}

template <typename T, SerialPortControlSignals::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.dcd < rhs.dcd)
    return true;
  if (rhs.dcd < lhs.dcd)
    return false;
  if (lhs.cts < rhs.cts)
    return true;
  if (rhs.cts < lhs.cts)
    return false;
  if (lhs.ri < rhs.ri)
    return true;
  if (rhs.ri < lhs.ri)
    return false;
  if (lhs.dsr < rhs.dsr)
    return true;
  if (rhs.dsr < lhs.dsr)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct  StructTraits<::device::mojom::SerialPortInfo::DataView,
                                         ::device::mojom::SerialPortInfoPtr> {
  static bool IsNull(const ::device::mojom::SerialPortInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SerialPortInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::SerialPortInfo::token)& token(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->token;
  }

  static const decltype(::device::mojom::SerialPortInfo::path)& path(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->path;
  }

  static decltype(::device::mojom::SerialPortInfo::type) type(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->type;
  }

  static const decltype(::device::mojom::SerialPortInfo::alternate_path)& alternate_path(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->alternate_path;
  }

  static const decltype(::device::mojom::SerialPortInfo::usb_driver_name)& usb_driver_name(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->usb_driver_name;
  }

  static decltype(::device::mojom::SerialPortInfo::vendor_id) vendor_id(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->vendor_id;
  }

  static decltype(::device::mojom::SerialPortInfo::has_vendor_id) has_vendor_id(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->has_vendor_id;
  }

  static decltype(::device::mojom::SerialPortInfo::product_id) product_id(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->product_id;
  }

  static decltype(::device::mojom::SerialPortInfo::has_product_id) has_product_id(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->has_product_id;
  }

  static const decltype(::device::mojom::SerialPortInfo::bluetooth_service_class_id)& bluetooth_service_class_id(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->bluetooth_service_class_id;
  }

  static const decltype(::device::mojom::SerialPortInfo::display_name)& display_name(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->display_name;
  }

  static const decltype(::device::mojom::SerialPortInfo::serial_number)& serial_number(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->serial_number;
  }

  static decltype(::device::mojom::SerialPortInfo::connected) connected(
      const ::device::mojom::SerialPortInfoPtr& input) {
    return input->connected;
  }

  static bool Read(::device::mojom::SerialPortInfo::DataView input, ::device::mojom::SerialPortInfoPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SerialConnectionOptions::DataView,
                                         ::device::mojom::SerialConnectionOptionsPtr> {
  static bool IsNull(const ::device::mojom::SerialConnectionOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SerialConnectionOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::SerialConnectionOptions::bitrate) bitrate(
      const ::device::mojom::SerialConnectionOptionsPtr& input) {
    return input->bitrate;
  }

  static decltype(::device::mojom::SerialConnectionOptions::data_bits) data_bits(
      const ::device::mojom::SerialConnectionOptionsPtr& input) {
    return input->data_bits;
  }

  static decltype(::device::mojom::SerialConnectionOptions::parity_bit) parity_bit(
      const ::device::mojom::SerialConnectionOptionsPtr& input) {
    return input->parity_bit;
  }

  static decltype(::device::mojom::SerialConnectionOptions::stop_bits) stop_bits(
      const ::device::mojom::SerialConnectionOptionsPtr& input) {
    return input->stop_bits;
  }

  static decltype(::device::mojom::SerialConnectionOptions::cts_flow_control) cts_flow_control(
      const ::device::mojom::SerialConnectionOptionsPtr& input) {
    return input->cts_flow_control;
  }

  static decltype(::device::mojom::SerialConnectionOptions::has_cts_flow_control) has_cts_flow_control(
      const ::device::mojom::SerialConnectionOptionsPtr& input) {
    return input->has_cts_flow_control;
  }

  static bool Read(::device::mojom::SerialConnectionOptions::DataView input, ::device::mojom::SerialConnectionOptionsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SerialConnectionInfo::DataView,
                                         ::device::mojom::SerialConnectionInfoPtr> {
  static bool IsNull(const ::device::mojom::SerialConnectionInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SerialConnectionInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::SerialConnectionInfo::bitrate) bitrate(
      const ::device::mojom::SerialConnectionInfoPtr& input) {
    return input->bitrate;
  }

  static decltype(::device::mojom::SerialConnectionInfo::data_bits) data_bits(
      const ::device::mojom::SerialConnectionInfoPtr& input) {
    return input->data_bits;
  }

  static decltype(::device::mojom::SerialConnectionInfo::parity_bit) parity_bit(
      const ::device::mojom::SerialConnectionInfoPtr& input) {
    return input->parity_bit;
  }

  static decltype(::device::mojom::SerialConnectionInfo::stop_bits) stop_bits(
      const ::device::mojom::SerialConnectionInfoPtr& input) {
    return input->stop_bits;
  }

  static decltype(::device::mojom::SerialConnectionInfo::cts_flow_control) cts_flow_control(
      const ::device::mojom::SerialConnectionInfoPtr& input) {
    return input->cts_flow_control;
  }

  static bool Read(::device::mojom::SerialConnectionInfo::DataView input, ::device::mojom::SerialConnectionInfoPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SerialHostControlSignals::DataView,
                                         ::device::mojom::SerialHostControlSignalsPtr> {
  static bool IsNull(const ::device::mojom::SerialHostControlSignalsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SerialHostControlSignalsPtr* output) { output->reset(); }

  static decltype(::device::mojom::SerialHostControlSignals::dtr) dtr(
      const ::device::mojom::SerialHostControlSignalsPtr& input) {
    return input->dtr;
  }

  static decltype(::device::mojom::SerialHostControlSignals::has_dtr) has_dtr(
      const ::device::mojom::SerialHostControlSignalsPtr& input) {
    return input->has_dtr;
  }

  static decltype(::device::mojom::SerialHostControlSignals::rts) rts(
      const ::device::mojom::SerialHostControlSignalsPtr& input) {
    return input->rts;
  }

  static decltype(::device::mojom::SerialHostControlSignals::has_rts) has_rts(
      const ::device::mojom::SerialHostControlSignalsPtr& input) {
    return input->has_rts;
  }

  static decltype(::device::mojom::SerialHostControlSignals::brk) brk(
      const ::device::mojom::SerialHostControlSignalsPtr& input) {
    return input->brk;
  }

  static decltype(::device::mojom::SerialHostControlSignals::has_brk) has_brk(
      const ::device::mojom::SerialHostControlSignalsPtr& input) {
    return input->has_brk;
  }

  static bool Read(::device::mojom::SerialHostControlSignals::DataView input, ::device::mojom::SerialHostControlSignalsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::SerialPortControlSignals::DataView,
                                         ::device::mojom::SerialPortControlSignalsPtr> {
  static bool IsNull(const ::device::mojom::SerialPortControlSignalsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SerialPortControlSignalsPtr* output) { output->reset(); }

  static decltype(::device::mojom::SerialPortControlSignals::dcd) dcd(
      const ::device::mojom::SerialPortControlSignalsPtr& input) {
    return input->dcd;
  }

  static decltype(::device::mojom::SerialPortControlSignals::cts) cts(
      const ::device::mojom::SerialPortControlSignalsPtr& input) {
    return input->cts;
  }

  static decltype(::device::mojom::SerialPortControlSignals::ri) ri(
      const ::device::mojom::SerialPortControlSignalsPtr& input) {
    return input->ri;
  }

  static decltype(::device::mojom::SerialPortControlSignals::dsr) dsr(
      const ::device::mojom::SerialPortControlSignalsPtr& input) {
    return input->dsr;
  }

  static bool Read(::device::mojom::SerialPortControlSignals::DataView input, ::device::mojom::SerialPortControlSignalsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_H_