// services/device/public/mojom/serial.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/serial.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/serial.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* SerialSendErrorToStringHelper(SerialSendError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialSendError::NONE:
      return "NONE";
    case SerialSendError::DISCONNECTED:
      return "DISCONNECTED";
    case SerialSendError::SYSTEM_ERROR:
      return "SYSTEM_ERROR";
    default:
      return nullptr;
  }
}

std::string SerialSendErrorToString(SerialSendError value) {
  const char *str = SerialSendErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialSendError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialSendError value) {
  return os << SerialSendErrorToString(value);
}

NOINLINE static const char* SerialReceiveErrorToStringHelper(SerialReceiveError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialReceiveError::NONE:
      return "NONE";
    case SerialReceiveError::DISCONNECTED:
      return "DISCONNECTED";
    case SerialReceiveError::DEVICE_LOST:
      return "DEVICE_LOST";
    case SerialReceiveError::BREAK:
      return "BREAK";
    case SerialReceiveError::FRAME_ERROR:
      return "FRAME_ERROR";
    case SerialReceiveError::OVERRUN:
      return "OVERRUN";
    case SerialReceiveError::BUFFER_OVERFLOW:
      return "BUFFER_OVERFLOW";
    case SerialReceiveError::PARITY_ERROR:
      return "PARITY_ERROR";
    case SerialReceiveError::SYSTEM_ERROR:
      return "SYSTEM_ERROR";
    default:
      return nullptr;
  }
}

std::string SerialReceiveErrorToString(SerialReceiveError value) {
  const char *str = SerialReceiveErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialReceiveError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialReceiveError value) {
  return os << SerialReceiveErrorToString(value);
}

NOINLINE static const char* SerialDataBitsToStringHelper(SerialDataBits value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialDataBits::NONE:
      return "NONE";
    case SerialDataBits::SEVEN:
      return "SEVEN";
    case SerialDataBits::EIGHT:
      return "EIGHT";
    default:
      return nullptr;
  }
}

std::string SerialDataBitsToString(SerialDataBits value) {
  const char *str = SerialDataBitsToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialDataBits value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialDataBits value) {
  return os << SerialDataBitsToString(value);
}

NOINLINE static const char* SerialParityBitToStringHelper(SerialParityBit value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialParityBit::NONE:
      return "NONE";
    case SerialParityBit::NO_PARITY:
      return "NO_PARITY";
    case SerialParityBit::ODD:
      return "ODD";
    case SerialParityBit::EVEN:
      return "EVEN";
    default:
      return nullptr;
  }
}

std::string SerialParityBitToString(SerialParityBit value) {
  const char *str = SerialParityBitToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialParityBit value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialParityBit value) {
  return os << SerialParityBitToString(value);
}

NOINLINE static const char* SerialStopBitsToStringHelper(SerialStopBits value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialStopBits::NONE:
      return "NONE";
    case SerialStopBits::ONE:
      return "ONE";
    case SerialStopBits::TWO:
      return "TWO";
    default:
      return nullptr;
  }
}

std::string SerialStopBitsToString(SerialStopBits value) {
  const char *str = SerialStopBitsToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialStopBits value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialStopBits value) {
  return os << SerialStopBitsToString(value);
}

NOINLINE static const char* SerialPortFlushModeToStringHelper(SerialPortFlushMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialPortFlushMode::kReceiveAndTransmit:
      return "kReceiveAndTransmit";
    case SerialPortFlushMode::kReceive:
      return "kReceive";
    case SerialPortFlushMode::kTransmit:
      return "kTransmit";
    default:
      return nullptr;
  }
}

std::string SerialPortFlushModeToString(SerialPortFlushMode value) {
  const char *str = SerialPortFlushModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialPortFlushMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialPortFlushMode value) {
  return os << SerialPortFlushModeToString(value);
}

NOINLINE static const char* SerialPortTypeToStringHelper(SerialPortType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerialPortType::PLATFORM_SERIAL:
      return "PLATFORM_SERIAL";
    case SerialPortType::BLUETOOTH_CLASSIC_RFCOMM:
      return "BLUETOOTH_CLASSIC_RFCOMM";
    default:
      return nullptr;
  }
}

std::string SerialPortTypeToString(SerialPortType value) {
  const char *str = SerialPortTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerialPortType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerialPortType value) {
  return os << SerialPortTypeToString(value);
}

namespace internal {


// static
bool SerialPortInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortInfo_Data* object =
      static_cast<const SerialPortInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->path, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->path, validation_context))
    return false;


  if (!::device::mojom::internal::SerialPortType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->alternate_path, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& usb_driver_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->usb_driver_name, validation_context,
                                         &usb_driver_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->bluetooth_service_class_id, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& serial_number_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->serial_number, validation_context,
                                         &serial_number_validate_params)) {
    return false;
  }

  return true;
}

SerialPortInfo_Data::SerialPortInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialConnectionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialConnectionOptions_Data* object =
      static_cast<const SerialConnectionOptions_Data*>(data);


  if (!::device::mojom::internal::SerialDataBits_Data
        ::Validate(object->data_bits, validation_context))
    return false;


  if (!::device::mojom::internal::SerialParityBit_Data
        ::Validate(object->parity_bit, validation_context))
    return false;


  if (!::device::mojom::internal::SerialStopBits_Data
        ::Validate(object->stop_bits, validation_context))
    return false;

  return true;
}

SerialConnectionOptions_Data::SerialConnectionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialConnectionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialConnectionInfo_Data* object =
      static_cast<const SerialConnectionInfo_Data*>(data);


  if (!::device::mojom::internal::SerialDataBits_Data
        ::Validate(object->data_bits, validation_context))
    return false;


  if (!::device::mojom::internal::SerialParityBit_Data
        ::Validate(object->parity_bit, validation_context))
    return false;


  if (!::device::mojom::internal::SerialStopBits_Data
        ::Validate(object->stop_bits, validation_context))
    return false;

  return true;
}

SerialConnectionInfo_Data::SerialConnectionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialHostControlSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialHostControlSignals_Data* object =
      static_cast<const SerialHostControlSignals_Data*>(data);

  return true;
}

SerialHostControlSignals_Data::SerialHostControlSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortControlSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortControlSignals_Data* object =
      static_cast<const SerialPortControlSignals_Data*>(data);

  return true;
}

SerialPortControlSignals_Data::SerialPortControlSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManager_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManager_SetClient_Params_Data* object =
      static_cast<const SerialPortManager_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SerialPortManager_SetClient_Params_Data::SerialPortManager_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManager_GetDevices_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManager_GetDevices_Params_Data* object =
      static_cast<const SerialPortManager_GetDevices_Params_Data*>(data);

  return true;
}

SerialPortManager_GetDevices_Params_Data::SerialPortManager_GetDevices_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManager_GetDevices_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManager_GetDevices_ResponseParams_Data* object =
      static_cast<const SerialPortManager_GetDevices_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

SerialPortManager_GetDevices_ResponseParams_Data::SerialPortManager_GetDevices_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManager_OpenPort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManager_OpenPort_Params_Data* object =
      static_cast<const SerialPortManager_OpenPort_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->watcher,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SerialPortManager_OpenPort_Params_Data::SerialPortManager_OpenPort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManager_OpenPort_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManager_OpenPort_ResponseParams_Data* object =
      static_cast<const SerialPortManager_OpenPort_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->port,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SerialPortManager_OpenPort_ResponseParams_Data::SerialPortManager_OpenPort_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManagerClient_OnPortAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManagerClient_OnPortAdded_Params_Data* object =
      static_cast<const SerialPortManagerClient_OnPortAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_info, validation_context))
    return false;

  return true;
}

SerialPortManagerClient_OnPortAdded_Params_Data::SerialPortManagerClient_OnPortAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManagerClient_OnPortRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManagerClient_OnPortRemoved_Params_Data* object =
      static_cast<const SerialPortManagerClient_OnPortRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_info, validation_context))
    return false;

  return true;
}

SerialPortManagerClient_OnPortRemoved_Params_Data::SerialPortManagerClient_OnPortRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortManagerClient_OnPortConnectedStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortManagerClient_OnPortConnectedStateChanged_Params_Data* object =
      static_cast<const SerialPortManagerClient_OnPortConnectedStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->port_info, validation_context))
    return false;

  return true;
}

SerialPortManagerClient_OnPortConnectedStateChanged_Params_Data::SerialPortManagerClient_OnPortConnectedStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_StartWriting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_StartWriting_Params_Data* object =
      static_cast<const SerialPort_StartWriting_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->consumer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->consumer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SerialPort_StartWriting_Params_Data::SerialPort_StartWriting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_StartReading_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_StartReading_Params_Data* object =
      static_cast<const SerialPort_StartReading_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->producer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->producer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

SerialPort_StartReading_Params_Data::SerialPort_StartReading_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_Flush_Params_Data* object =
      static_cast<const SerialPort_Flush_Params_Data*>(data);


  if (!::device::mojom::internal::SerialPortFlushMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

SerialPort_Flush_Params_Data::SerialPort_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_Flush_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_Flush_ResponseParams_Data* object =
      static_cast<const SerialPort_Flush_ResponseParams_Data*>(data);

  return true;
}

SerialPort_Flush_ResponseParams_Data::SerialPort_Flush_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_Drain_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_Drain_Params_Data* object =
      static_cast<const SerialPort_Drain_Params_Data*>(data);

  return true;
}

SerialPort_Drain_Params_Data::SerialPort_Drain_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_Drain_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_Drain_ResponseParams_Data* object =
      static_cast<const SerialPort_Drain_ResponseParams_Data*>(data);

  return true;
}

SerialPort_Drain_ResponseParams_Data::SerialPort_Drain_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_GetControlSignals_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_GetControlSignals_Params_Data* object =
      static_cast<const SerialPort_GetControlSignals_Params_Data*>(data);

  return true;
}

SerialPort_GetControlSignals_Params_Data::SerialPort_GetControlSignals_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_GetControlSignals_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_GetControlSignals_ResponseParams_Data* object =
      static_cast<const SerialPort_GetControlSignals_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->signals, validation_context))
    return false;

  return true;
}

SerialPort_GetControlSignals_ResponseParams_Data::SerialPort_GetControlSignals_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_SetControlSignals_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_SetControlSignals_Params_Data* object =
      static_cast<const SerialPort_SetControlSignals_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signals, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->signals, validation_context))
    return false;

  return true;
}

SerialPort_SetControlSignals_Params_Data::SerialPort_SetControlSignals_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_SetControlSignals_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_SetControlSignals_ResponseParams_Data* object =
      static_cast<const SerialPort_SetControlSignals_ResponseParams_Data*>(data);

  return true;
}

SerialPort_SetControlSignals_ResponseParams_Data::SerialPort_SetControlSignals_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_ConfigurePort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_ConfigurePort_Params_Data* object =
      static_cast<const SerialPort_ConfigurePort_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SerialPort_ConfigurePort_Params_Data::SerialPort_ConfigurePort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_ConfigurePort_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_ConfigurePort_ResponseParams_Data* object =
      static_cast<const SerialPort_ConfigurePort_ResponseParams_Data*>(data);

  return true;
}

SerialPort_ConfigurePort_ResponseParams_Data::SerialPort_ConfigurePort_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_GetPortInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_GetPortInfo_Params_Data* object =
      static_cast<const SerialPort_GetPortInfo_Params_Data*>(data);

  return true;
}

SerialPort_GetPortInfo_Params_Data::SerialPort_GetPortInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_GetPortInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_GetPortInfo_ResponseParams_Data* object =
      static_cast<const SerialPort_GetPortInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

SerialPort_GetPortInfo_ResponseParams_Data::SerialPort_GetPortInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_Close_Params_Data* object =
      static_cast<const SerialPort_Close_Params_Data*>(data);

  return true;
}

SerialPort_Close_Params_Data::SerialPort_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPort_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPort_Close_ResponseParams_Data* object =
      static_cast<const SerialPort_Close_ResponseParams_Data*>(data);

  return true;
}

SerialPort_Close_ResponseParams_Data::SerialPort_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortClient_OnReadError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortClient_OnReadError_Params_Data* object =
      static_cast<const SerialPortClient_OnReadError_Params_Data*>(data);


  if (!::device::mojom::internal::SerialReceiveError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

SerialPortClient_OnReadError_Params_Data::SerialPortClient_OnReadError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerialPortClient_OnSendError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerialPortClient_OnSendError_Params_Data* object =
      static_cast<const SerialPortClient_OnSendError_Params_Data*>(data);


  if (!::device::mojom::internal::SerialSendError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

SerialPortClient_OnSendError_Params_Data::SerialPortClient_OnSendError_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialSendError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialSendError value) {
  return std::move(context).WriteString(::device::mojom::SerialSendErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialReceiveError>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialReceiveError value) {
  return std::move(context).WriteString(::device::mojom::SerialReceiveErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialDataBits>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialDataBits value) {
  return std::move(context).WriteString(::device::mojom::SerialDataBitsToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialParityBit>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialParityBit value) {
  return std::move(context).WriteString(::device::mojom::SerialParityBitToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialStopBits>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialStopBits value) {
  return std::move(context).WriteString(::device::mojom::SerialStopBitsToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialPortFlushMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialPortFlushMode value) {
  return std::move(context).WriteString(::device::mojom::SerialPortFlushModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::SerialPortType>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::SerialPortType value) {
  return std::move(context).WriteString(::device::mojom::SerialPortTypeToString(value));
}

} // namespace perfetto