// services/device/public/mojom/serial.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/serial.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "services/device/public/mojom/serial.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialSendError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialReceiveError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialDataBits, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialParityBit, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialStopBits, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialPortFlushMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SerialPortType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SerialPortInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SerialPortInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SerialPortInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::token(input)) in_token = Traits::token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->token)::BaseType> token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_token,
        token_fragment);

      fragment->token.Set(
          token_fragment.is_null() ? nullptr : token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in SerialPortInfo struct");

      decltype(Traits::path(input)) in_path = Traits::path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->path)::BaseType> path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_path,
        path_fragment);

      fragment->path.Set(
          path_fragment.is_null() ? nullptr : path_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->path.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in SerialPortInfo struct");

      
      mojo::internal::Serialize<::device::mojom::SerialPortType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::alternate_path(input)) in_alternate_path = Traits::alternate_path(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alternate_path)::BaseType> alternate_path_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
        in_alternate_path,
        alternate_path_fragment);

      fragment->alternate_path.Set(
          alternate_path_fragment.is_null() ? nullptr : alternate_path_fragment.data());

      decltype(Traits::usb_driver_name(input)) in_usb_driver_name = Traits::usb_driver_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usb_driver_name)::BaseType> usb_driver_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_usb_driver_name,
        usb_driver_name_fragment);

      fragment->usb_driver_name.Set(
          usb_driver_name_fragment.is_null() ? nullptr : usb_driver_name_fragment.data());

      fragment->vendor_id = Traits::vendor_id(input);

      fragment->has_vendor_id = Traits::has_vendor_id(input);

      fragment->product_id = Traits::product_id(input);

      fragment->has_product_id = Traits::has_product_id(input);

      decltype(Traits::bluetooth_service_class_id(input)) in_bluetooth_service_class_id = Traits::bluetooth_service_class_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bluetooth_service_class_id)::BaseType> bluetooth_service_class_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::bluetooth::mojom::UUIDDataView, send_validation>(
        in_bluetooth_service_class_id,
        bluetooth_service_class_id_fragment);

      fragment->bluetooth_service_class_id.Set(
          bluetooth_service_class_id_fragment.is_null() ? nullptr : bluetooth_service_class_id_fragment.data());

      decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_name)::BaseType> display_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_display_name,
        display_name_fragment);

      fragment->display_name.Set(
          display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

      decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_serial_number,
        serial_number_fragment);

      fragment->serial_number.Set(
          serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

      fragment->connected = Traits::connected(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SerialConnectionOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SerialConnectionOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SerialConnectionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->bitrate = Traits::bitrate(input);

      
      mojo::internal::Serialize<::device::mojom::SerialDataBits>(
        Traits::data_bits(input),
        &fragment->data_bits);

      
      mojo::internal::Serialize<::device::mojom::SerialParityBit>(
        Traits::parity_bit(input),
        &fragment->parity_bit);

      
      mojo::internal::Serialize<::device::mojom::SerialStopBits>(
        Traits::stop_bits(input),
        &fragment->stop_bits);

      fragment->cts_flow_control = Traits::cts_flow_control(input);

      fragment->has_cts_flow_control = Traits::has_cts_flow_control(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SerialConnectionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SerialConnectionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SerialConnectionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->bitrate = Traits::bitrate(input);

      
      mojo::internal::Serialize<::device::mojom::SerialDataBits>(
        Traits::data_bits(input),
        &fragment->data_bits);

      
      mojo::internal::Serialize<::device::mojom::SerialParityBit>(
        Traits::parity_bit(input),
        &fragment->parity_bit);

      
      mojo::internal::Serialize<::device::mojom::SerialStopBits>(
        Traits::stop_bits(input),
        &fragment->stop_bits);

      fragment->cts_flow_control = Traits::cts_flow_control(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SerialHostControlSignalsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SerialHostControlSignalsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SerialHostControlSignals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->dtr = Traits::dtr(input);

      fragment->has_dtr = Traits::has_dtr(input);

      fragment->rts = Traits::rts(input);

      fragment->has_rts = Traits::has_rts(input);

      fragment->brk = Traits::brk(input);

      fragment->has_brk = Traits::has_brk(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SerialPortControlSignalsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SerialPortControlSignalsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SerialPortControlSignals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->dcd = Traits::dcd(input);

      fragment->cts = Traits::cts(input);

      fragment->ri = Traits::ri(input);

      fragment->dsr = Traits::dsr(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_SEND_VALIDATION_H_