// services/device/public/mojom/sensor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/sensor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/sensor.mojom-params-data.h"
#include "services/device/public/mojom/sensor.mojom-shared-message-ids.h"

#include "services/device/public/mojom/sensor.mojom-blink-import-headers.h"
#include "services/device/public/mojom/sensor.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
SensorReadingRaw::SensorReadingRaw()
    : timestamp(),
      values() {}

SensorReadingRaw::SensorReadingRaw(
    double timestamp_in,
    ::blink::Vector<double> values_in)
    : timestamp(std::move(timestamp_in)),
      values(std::move(values_in)) {}

SensorReadingRaw::~SensorReadingRaw() = default;

void SensorReadingRaw::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "values"), this->values,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<double>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SensorReadingRaw::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SensorConfiguration::SensorConfiguration()
    : frequency() {}

SensorConfiguration::SensorConfiguration(
    double frequency_in)
    : frequency(std::move(frequency_in)) {}

SensorConfiguration::~SensorConfiguration() = default;
size_t SensorConfiguration::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->frequency);
  return seed;
}

void SensorConfiguration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frequency"), this->frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SensorConfiguration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Sensor::IPCStableHashFunction Sensor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Sensor>(message.name())) {
    case messages::Sensor::kGetDefaultConfiguration: {
      return &Sensor::GetDefaultConfiguration_Sym::IPCStableHash;
    }
    case messages::Sensor::kAddConfiguration: {
      return &Sensor::AddConfiguration_Sym::IPCStableHash;
    }
    case messages::Sensor::kRemoveConfiguration: {
      return &Sensor::RemoveConfiguration_Sym::IPCStableHash;
    }
    case messages::Sensor::kSuspend: {
      return &Sensor::Suspend_Sym::IPCStableHash;
    }
    case messages::Sensor::kResume: {
      return &Sensor::Resume_Sym::IPCStableHash;
    }
    case messages::Sensor::kConfigureReadingChangeNotifications: {
      return &Sensor::ConfigureReadingChangeNotifications_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Sensor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Sensor>(message.name())) {
      case messages::Sensor::kGetDefaultConfiguration:
            return "Receive device::mojom::Sensor::GetDefaultConfiguration";
      case messages::Sensor::kAddConfiguration:
            return "Receive device::mojom::Sensor::AddConfiguration";
      case messages::Sensor::kRemoveConfiguration:
            return "Receive device::mojom::Sensor::RemoveConfiguration";
      case messages::Sensor::kSuspend:
            return "Receive device::mojom::Sensor::Suspend";
      case messages::Sensor::kResume:
            return "Receive device::mojom::Sensor::Resume";
      case messages::Sensor::kConfigureReadingChangeNotifications:
            return "Receive device::mojom::Sensor::ConfigureReadingChangeNotifications";
    }
  } else {
    switch (static_cast<messages::Sensor>(message.name())) {
      case messages::Sensor::kGetDefaultConfiguration:
            return "Receive reply device::mojom::Sensor::GetDefaultConfiguration";
      case messages::Sensor::kAddConfiguration:
            return "Receive reply device::mojom::Sensor::AddConfiguration";
      case messages::Sensor::kRemoveConfiguration:
            return "Receive reply device::mojom::Sensor::RemoveConfiguration";
      case messages::Sensor::kSuspend:
            return "Receive reply device::mojom::Sensor::Suspend";
      case messages::Sensor::kResume:
            return "Receive reply device::mojom::Sensor::Resume";
      case messages::Sensor::kConfigureReadingChangeNotifications:
            return "Receive reply device::mojom::Sensor::ConfigureReadingChangeNotifications";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Sensor::GetDefaultConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb13cba3b;  // IPCStableHash for device::mojom::Sensor::GetDefaultConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Sensor::AddConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b1cab70;  // IPCStableHash for device::mojom::Sensor::AddConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Sensor::RemoveConfiguration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5e3d6aa;  // IPCStableHash for device::mojom::Sensor::RemoveConfiguration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Sensor::Suspend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x86be441d;  // IPCStableHash for device::mojom::Sensor::Suspend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Sensor::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0cc7bf80;  // IPCStableHash for device::mojom::Sensor::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Sensor::ConfigureReadingChangeNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce1c5b5b;  // IPCStableHash for device::mojom::Sensor::ConfigureReadingChangeNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Sensor_GetDefaultConfiguration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Sensor_GetDefaultConfiguration_ForwardToCallback(
      Sensor::GetDefaultConfigurationCallback callback
      ) : callback_(std::move(callback)) {
  }

  Sensor_GetDefaultConfiguration_ForwardToCallback(const Sensor_GetDefaultConfiguration_ForwardToCallback&) = delete;
  Sensor_GetDefaultConfiguration_ForwardToCallback& operator=(const Sensor_GetDefaultConfiguration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Sensor::GetDefaultConfigurationCallback callback_;
};

class Sensor_AddConfiguration_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Sensor_AddConfiguration_ForwardToCallback(
      Sensor::AddConfigurationCallback callback
      ) : callback_(std::move(callback)) {
  }

  Sensor_AddConfiguration_ForwardToCallback(const Sensor_AddConfiguration_ForwardToCallback&) = delete;
  Sensor_AddConfiguration_ForwardToCallback& operator=(const Sensor_AddConfiguration_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Sensor::AddConfigurationCallback callback_;
};

SensorProxy::SensorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SensorProxy::GetDefaultConfiguration(
    GetDefaultConfigurationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Sensor::GetDefaultConfiguration");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kGetDefaultConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_GetDefaultConfiguration_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("GetDefaultConfiguration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Sensor_GetDefaultConfiguration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SensorProxy::AddConfiguration(
    SensorConfigurationPtr in_configuration, AddConfigurationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Sensor::AddConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type SensorConfigurationPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kAddConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_AddConfiguration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configuration)::BaseType> configuration_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::SensorConfigurationDataView>(
    in_configuration,
    configuration_fragment);

  params->configuration.Set(
      configuration_fragment.is_null() ? nullptr : configuration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->configuration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null configuration in Sensor.AddConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("AddConfiguration");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Sensor_AddConfiguration_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SensorProxy::RemoveConfiguration(
    SensorConfigurationPtr in_configuration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Sensor::RemoveConfiguration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type SensorConfigurationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kRemoveConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_RemoveConfiguration_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configuration)::BaseType> configuration_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::SensorConfigurationDataView>(
    in_configuration,
    configuration_fragment);

  params->configuration.Set(
      configuration_fragment.is_null() ? nullptr : configuration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->configuration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null configuration in Sensor.RemoveConfiguration request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("RemoveConfiguration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SensorProxy::Suspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Sensor::Suspend");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_Suspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("Suspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SensorProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Sensor::Resume");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SensorProxy::ConfigureReadingChangeNotifications(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Sensor::ConfigureReadingChangeNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kConfigureReadingChangeNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_ConfigureReadingChangeNotifications_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("ConfigureReadingChangeNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Sensor_GetDefaultConfiguration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Sensor::GetDefaultConfigurationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Sensor_GetDefaultConfiguration_ProxyToResponder> proxy(
        new Sensor_GetDefaultConfiguration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Sensor_GetDefaultConfiguration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Sensor_GetDefaultConfiguration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Sensor_GetDefaultConfiguration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Sensor::GetDefaultConfigurationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SensorConfigurationPtr in_configuration);
};

bool Sensor_GetDefaultConfiguration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Sensor_GetDefaultConfiguration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Sensor_GetDefaultConfiguration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Sensor.0
  bool success = true;
  SensorConfigurationPtr p_configuration{};
  Sensor_GetDefaultConfiguration_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadConfiguration(&p_configuration))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Sensor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_configuration));
  }
  return true;
}

void Sensor_GetDefaultConfiguration_ProxyToResponder::Run(
    SensorConfigurationPtr in_configuration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Sensor::GetDefaultConfiguration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type SensorConfigurationPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kGetDefaultConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_GetDefaultConfiguration_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configuration)::BaseType> configuration_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::SensorConfigurationDataView>(
    in_configuration,
    configuration_fragment);

  params->configuration.Set(
      configuration_fragment.is_null() ? nullptr : configuration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->configuration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null configuration in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("GetDefaultConfiguration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Sensor_AddConfiguration_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Sensor::AddConfigurationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Sensor_AddConfiguration_ProxyToResponder> proxy(
        new Sensor_AddConfiguration_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Sensor_AddConfiguration_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Sensor_AddConfiguration_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Sensor_AddConfiguration_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Sensor::AddConfigurationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Sensor_AddConfiguration_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Sensor_AddConfiguration_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Sensor_AddConfiguration_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Sensor.1
  bool success = true;
  bool p_success{};
  Sensor_AddConfiguration_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Sensor::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Sensor_AddConfiguration_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Sensor::AddConfiguration", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Sensor::kAddConfiguration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Sensor_AddConfiguration_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Sensor::Name_);
  message.set_method_name("AddConfiguration");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SensorStubDispatch::Accept(
    Sensor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Sensor>(message->header()->name)) {
    case messages::Sensor::kGetDefaultConfiguration: {
      break;
    }
    case messages::Sensor::kAddConfiguration: {
      break;
    }
    case messages::Sensor::kRemoveConfiguration: {
      DCHECK(message->is_serialized());
      internal::Sensor_RemoveConfiguration_Params_Data* params =
          reinterpret_cast<internal::Sensor_RemoveConfiguration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Sensor.2
      bool success = true;
      SensorConfigurationPtr p_configuration{};
      Sensor_RemoveConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfiguration(&p_configuration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Sensor::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveConfiguration(        
        std::move(p_configuration));
      return true;
    }
    case messages::Sensor::kSuspend: {
      DCHECK(message->is_serialized());
      internal::Sensor_Suspend_Params_Data* params =
          reinterpret_cast<internal::Sensor_Suspend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Sensor.3
      bool success = true;
      Sensor_Suspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Sensor::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(        );
      return true;
    }
    case messages::Sensor::kResume: {
      DCHECK(message->is_serialized());
      internal::Sensor_Resume_Params_Data* params =
          reinterpret_cast<internal::Sensor_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Sensor.4
      bool success = true;
      Sensor_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Sensor::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        );
      return true;
    }
    case messages::Sensor::kConfigureReadingChangeNotifications: {
      DCHECK(message->is_serialized());
      internal::Sensor_ConfigureReadingChangeNotifications_Params_Data* params =
          reinterpret_cast<internal::Sensor_ConfigureReadingChangeNotifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Sensor.5
      bool success = true;
      bool p_enabled{};
      Sensor_ConfigureReadingChangeNotifications_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Sensor::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureReadingChangeNotifications(        
        std::move(p_enabled));
      return true;
    }
  }
  return false;
}

// static
bool SensorStubDispatch::AcceptWithResponder(
    Sensor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Sensor>(message->header()->name)) {
    case messages::Sensor::kGetDefaultConfiguration: {
      internal::Sensor_GetDefaultConfiguration_Params_Data* params =
          reinterpret_cast<
              internal::Sensor_GetDefaultConfiguration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Sensor.0
      bool success = true;
      Sensor_GetDefaultConfiguration_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Sensor::Name_, 0, false);
        return false;
      }
      auto callback =
          Sensor_GetDefaultConfiguration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDefaultConfiguration(std::move(callback));
      return true;
    }
    case messages::Sensor::kAddConfiguration: {
      internal::Sensor_AddConfiguration_Params_Data* params =
          reinterpret_cast<
              internal::Sensor_AddConfiguration_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Sensor.1
      bool success = true;
      SensorConfigurationPtr p_configuration{};
      Sensor_AddConfiguration_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfiguration(&p_configuration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Sensor::Name_, 1, false);
        return false;
      }
      auto callback =
          Sensor_AddConfiguration_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddConfiguration(        
        std::move(p_configuration), std::move(callback));
      return true;
    }
    case messages::Sensor::kRemoveConfiguration: {
      break;
    }
    case messages::Sensor::kSuspend: {
      break;
    }
    case messages::Sensor::kResume: {
      break;
    }
    case messages::Sensor::kConfigureReadingChangeNotifications: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSensorValidationInfo[] = {
    { &internal::Sensor_GetDefaultConfiguration_Params_Data::Validate,
     &internal::Sensor_GetDefaultConfiguration_ResponseParams_Data::Validate},
    { &internal::Sensor_AddConfiguration_Params_Data::Validate,
     &internal::Sensor_AddConfiguration_ResponseParams_Data::Validate},
    { &internal::Sensor_RemoveConfiguration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Sensor_Suspend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Sensor_Resume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Sensor_ConfigureReadingChangeNotifications_Params_Data::Validate,
     nullptr /* no response */},
};

bool SensorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::Sensor::Name_,
    kSensorValidationInfo);
}

bool SensorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::Sensor::Name_,
    kSensorValidationInfo);
}
// The declaration includes the definition on other builds.

SensorClient::IPCStableHashFunction SensorClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SensorClient>(message.name())) {
    case messages::SensorClient::kRaiseError: {
      return &SensorClient::RaiseError_Sym::IPCStableHash;
    }
    case messages::SensorClient::kSensorReadingChanged: {
      return &SensorClient::SensorReadingChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SensorClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SensorClient>(message.name())) {
      case messages::SensorClient::kRaiseError:
            return "Receive device::mojom::SensorClient::RaiseError";
      case messages::SensorClient::kSensorReadingChanged:
            return "Receive device::mojom::SensorClient::SensorReadingChanged";
    }
  } else {
    switch (static_cast<messages::SensorClient>(message.name())) {
      case messages::SensorClient::kRaiseError:
            return "Receive reply device::mojom::SensorClient::RaiseError";
      case messages::SensorClient::kSensorReadingChanged:
            return "Receive reply device::mojom::SensorClient::SensorReadingChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SensorClient::RaiseError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5c4bffd;  // IPCStableHash for device::mojom::SensorClient::RaiseError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SensorClient::SensorReadingChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b27f5bc;  // IPCStableHash for device::mojom::SensorClient::SensorReadingChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SensorClientProxy::SensorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SensorClientProxy::RaiseError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SensorClient::RaiseError");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorClient::kRaiseError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorClient_RaiseError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorClient::Name_);
  message.set_method_name("RaiseError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SensorClientProxy::SensorReadingChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::SensorClient::SensorReadingChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SensorClient::kSensorReadingChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::SensorClient_SensorReadingChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SensorClient::Name_);
  message.set_method_name("SensorReadingChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SensorClientStubDispatch::Accept(
    SensorClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SensorClient>(message->header()->name)) {
    case messages::SensorClient::kRaiseError: {
      DCHECK(message->is_serialized());
      internal::SensorClient_RaiseError_Params_Data* params =
          reinterpret_cast<internal::SensorClient_RaiseError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SensorClient.0
      bool success = true;
      SensorClient_RaiseError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RaiseError(        );
      return true;
    }
    case messages::SensorClient::kSensorReadingChanged: {
      DCHECK(message->is_serialized());
      internal::SensorClient_SensorReadingChanged_Params_Data* params =
          reinterpret_cast<internal::SensorClient_SensorReadingChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SensorClient.1
      bool success = true;
      SensorClient_SensorReadingChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SensorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SensorReadingChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool SensorClientStubDispatch::AcceptWithResponder(
    SensorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SensorClient>(message->header()->name)) {
    case messages::SensorClient::kRaiseError: {
      break;
    }
    case messages::SensorClient::kSensorReadingChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSensorClientValidationInfo[] = {
    { &internal::SensorClient_RaiseError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SensorClient_SensorReadingChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool SensorClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::SensorClient::Name_,
    kSensorClientValidationInfo);
}



}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::SensorReadingRaw::DataView, ::device::mojom::blink::SensorReadingRawPtr>::Read(
    ::device::mojom::blink::SensorReadingRaw::DataView input,
    ::device::mojom::blink::SensorReadingRawPtr* output) {
  bool success = true;
  ::device::mojom::blink::SensorReadingRawPtr result(::device::mojom::blink::SensorReadingRaw::New());
  
      if (success)
        result->timestamp = input.timestamp();
      if (success && !input.ReadValues(&result->values))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::SensorConfiguration::DataView, ::device::mojom::blink::SensorConfigurationPtr>::Read(
    ::device::mojom::blink::SensorConfiguration::DataView input,
    ::device::mojom::blink::SensorConfigurationPtr* output) {
  bool success = true;
  ::device::mojom::blink::SensorConfigurationPtr result(::device::mojom::blink::SensorConfiguration::New());
  
      if (success)
        result->frequency = input.frequency();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void SensorInterceptorForTesting::GetDefaultConfiguration(GetDefaultConfigurationCallback callback) {
  GetForwardingInterface()->GetDefaultConfiguration(std::move(callback));
}
void SensorInterceptorForTesting::AddConfiguration(SensorConfigurationPtr configuration, AddConfigurationCallback callback) {
  GetForwardingInterface()->AddConfiguration(
    std::move(configuration)
    , std::move(callback));
}
void SensorInterceptorForTesting::RemoveConfiguration(SensorConfigurationPtr configuration) {
  GetForwardingInterface()->RemoveConfiguration(
    std::move(configuration)
    );
}
void SensorInterceptorForTesting::Suspend() {
  GetForwardingInterface()->Suspend();
}
void SensorInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
void SensorInterceptorForTesting::ConfigureReadingChangeNotifications(bool enabled) {
  GetForwardingInterface()->ConfigureReadingChangeNotifications(
    std::move(enabled)
    );
}
SensorAsyncWaiter::SensorAsyncWaiter(
    Sensor* proxy) : proxy_(proxy) {}

SensorAsyncWaiter::~SensorAsyncWaiter() = default;


void SensorAsyncWaiter::GetDefaultConfiguration(
    SensorConfigurationPtr* out_configuration) {
  base::RunLoop loop;
  proxy_->GetDefaultConfiguration(
      base::BindOnce(
          [](base::RunLoop* loop,
             SensorConfigurationPtr* out_configuration
,
             SensorConfigurationPtr configuration) {*out_configuration = std::move(configuration);
            loop->Quit();
          },
          &loop,
          out_configuration));
  loop.Run();
}

SensorConfigurationPtr SensorAsyncWaiter::GetDefaultConfiguration(
    ) {
  SensorConfigurationPtr async_wait_result;
  GetDefaultConfiguration(&async_wait_result);
  return async_wait_result;
}

void SensorAsyncWaiter::AddConfiguration(
    SensorConfigurationPtr configuration, bool* out_success) {
  base::RunLoop loop;
  proxy_->AddConfiguration(
      std::move(configuration),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool SensorAsyncWaiter::AddConfiguration(
    SensorConfigurationPtr configuration) {
  bool async_wait_result;
  AddConfiguration(std::move(configuration),&async_wait_result);
  return async_wait_result;
}




void SensorClientInterceptorForTesting::RaiseError() {
  GetForwardingInterface()->RaiseError();
}
void SensorClientInterceptorForTesting::SensorReadingChanged() {
  GetForwardingInterface()->SensorReadingChanged();
}
SensorClientAsyncWaiter::SensorClientAsyncWaiter(
    SensorClient* proxy) : proxy_(proxy) {}

SensorClientAsyncWaiter::~SensorClientAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif