// services/device/public/mojom/pressure_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/pressure_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/pressure_manager.mojom-params-data.h"
#include "services/device/public/mojom/pressure_manager.mojom-shared-message-ids.h"

#include "services/device/public/mojom/pressure_manager.mojom-import-headers.h"
#include "services/device/public/mojom/pressure_manager.mojom-test-utils.h"


namespace device::mojom {
VirtualPressureSourceMetadata::VirtualPressureSourceMetadata()
    : available(true) {}

VirtualPressureSourceMetadata::VirtualPressureSourceMetadata(
    bool available_in)
    : available(std::move(available_in)) {}

VirtualPressureSourceMetadata::~VirtualPressureSourceMetadata() = default;
size_t VirtualPressureSourceMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->available);
  return seed;
}

void VirtualPressureSourceMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "available"), this->available,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VirtualPressureSourceMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PressureManager::IPCStableHashFunction PressureManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PressureManager>(message.name())) {
    case messages::PressureManager::kAddVirtualPressureSource: {
      return &PressureManager::AddVirtualPressureSource_Sym::IPCStableHash;
    }
    case messages::PressureManager::kRemoveVirtualPressureSource: {
      return &PressureManager::RemoveVirtualPressureSource_Sym::IPCStableHash;
    }
    case messages::PressureManager::kUpdateVirtualPressureSourceData: {
      return &PressureManager::UpdateVirtualPressureSourceData_Sym::IPCStableHash;
    }
    case messages::PressureManager::kAddClient: {
      return &PressureManager::AddClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PressureManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PressureManager>(message.name())) {
      case messages::PressureManager::kAddVirtualPressureSource:
            return "Receive device::mojom::PressureManager::AddVirtualPressureSource";
      case messages::PressureManager::kRemoveVirtualPressureSource:
            return "Receive device::mojom::PressureManager::RemoveVirtualPressureSource";
      case messages::PressureManager::kUpdateVirtualPressureSourceData:
            return "Receive device::mojom::PressureManager::UpdateVirtualPressureSourceData";
      case messages::PressureManager::kAddClient:
            return "Receive device::mojom::PressureManager::AddClient";
    }
  } else {
    switch (static_cast<messages::PressureManager>(message.name())) {
      case messages::PressureManager::kAddVirtualPressureSource:
            return "Receive reply device::mojom::PressureManager::AddVirtualPressureSource";
      case messages::PressureManager::kRemoveVirtualPressureSource:
            return "Receive reply device::mojom::PressureManager::RemoveVirtualPressureSource";
      case messages::PressureManager::kUpdateVirtualPressureSourceData:
            return "Receive reply device::mojom::PressureManager::UpdateVirtualPressureSourceData";
      case messages::PressureManager::kAddClient:
            return "Receive reply device::mojom::PressureManager::AddClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PressureManager::AddVirtualPressureSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6929ace;  // IPCStableHash for device::mojom::PressureManager::AddVirtualPressureSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PressureManager::RemoveVirtualPressureSource_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13370663;  // IPCStableHash for device::mojom::PressureManager::RemoveVirtualPressureSource
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PressureManager::UpdateVirtualPressureSourceData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74b32ac1;  // IPCStableHash for device::mojom::PressureManager::UpdateVirtualPressureSourceData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PressureManager::AddClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3f4b10b9;  // IPCStableHash for device::mojom::PressureManager::AddClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PressureManager_AddVirtualPressureSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_AddVirtualPressureSource_ForwardToCallback(
      PressureManager::AddVirtualPressureSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_AddVirtualPressureSource_ForwardToCallback(const PressureManager_AddVirtualPressureSource_ForwardToCallback&) = delete;
  PressureManager_AddVirtualPressureSource_ForwardToCallback& operator=(const PressureManager_AddVirtualPressureSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::AddVirtualPressureSourceCallback callback_;
};

class PressureManager_RemoveVirtualPressureSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_RemoveVirtualPressureSource_ForwardToCallback(
      PressureManager::RemoveVirtualPressureSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_RemoveVirtualPressureSource_ForwardToCallback(const PressureManager_RemoveVirtualPressureSource_ForwardToCallback&) = delete;
  PressureManager_RemoveVirtualPressureSource_ForwardToCallback& operator=(const PressureManager_RemoveVirtualPressureSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::RemoveVirtualPressureSourceCallback callback_;
};

class PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback(
      PressureManager::UpdateVirtualPressureSourceDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback(const PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback&) = delete;
  PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback& operator=(const PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::UpdateVirtualPressureSourceDataCallback callback_;
};

class PressureManager_AddClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_AddClient_ForwardToCallback(
      PressureManager::AddClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_AddClient_ForwardToCallback(const PressureManager_AddClient_ForwardToCallback&) = delete;
  PressureManager_AddClient_ForwardToCallback& operator=(const PressureManager_AddClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::AddClientCallback callback_;
};

PressureManagerProxy::PressureManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PressureManagerProxy::AddVirtualPressureSource(
    const ::base::UnguessableToken& in_token, ::device::mojom::PressureSource in_source, VirtualPressureSourceMetadataPtr in_metadata, AddVirtualPressureSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::AddVirtualPressureSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type VirtualPressureSourceMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddVirtualPressureSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in PressureManager.AddVirtualPressureSource request");

  
  mojo::internal::Serialize<::device::mojom::PressureSource>(
    in_source,
    &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::VirtualPressureSourceMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in PressureManager.AddVirtualPressureSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddVirtualPressureSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_AddVirtualPressureSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PressureManagerProxy::RemoveVirtualPressureSource(
    const ::base::UnguessableToken& in_token, ::device::mojom::PressureSource in_source, RemoveVirtualPressureSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::RemoveVirtualPressureSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::PressureSource>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kRemoveVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_RemoveVirtualPressureSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in PressureManager.RemoveVirtualPressureSource request");

  
  mojo::internal::Serialize<::device::mojom::PressureSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("RemoveVirtualPressureSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_RemoveVirtualPressureSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PressureManagerProxy::UpdateVirtualPressureSourceData(
    const ::base::UnguessableToken& in_token, ::device::mojom::PressureSource in_source, ::device::mojom::PressureState in_state, double in_own_contribution_estimate, UpdateVirtualPressureSourceDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::UpdateVirtualPressureSourceData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::device::mojom::PressureState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("own_contribution_estimate"), in_own_contribution_estimate,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kUpdateVirtualPressureSourceData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_UpdateVirtualPressureSourceData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in PressureManager.UpdateVirtualPressureSourceData request");

  
  mojo::internal::Serialize<::device::mojom::PressureSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::device::mojom::PressureState>(
    in_state,
    &params->state);

  params->own_contribution_estimate = in_own_contribution_estimate;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("UpdateVirtualPressureSourceData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PressureManagerProxy::AddClient(
    ::device::mojom::PressureSource in_source, const std::optional<::base::UnguessableToken>& in_token, ::mojo::PendingAssociatedRemote<PressureClient> in_client, AddClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<PressureClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::PressureSource>(
    in_source,
    &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  mojo::internal::Serialize<::device::mojom::PressureClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in PressureManager.AddClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_AddClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PressureManager_AddVirtualPressureSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::AddVirtualPressureSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_AddVirtualPressureSource_ProxyToResponder> proxy(
        new PressureManager_AddVirtualPressureSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_AddVirtualPressureSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_AddVirtualPressureSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_AddVirtualPressureSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PressureManager::AddVirtualPressureSourceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PressureManager_AddVirtualPressureSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PressureManager.0
  bool success = true;
  PressureManager_AddVirtualPressureSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PressureManager_AddVirtualPressureSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::PressureManager::AddVirtualPressureSource");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddVirtualPressureSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PressureManager_RemoveVirtualPressureSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::RemoveVirtualPressureSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_RemoveVirtualPressureSource_ProxyToResponder> proxy(
        new PressureManager_RemoveVirtualPressureSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_RemoveVirtualPressureSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_RemoveVirtualPressureSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_RemoveVirtualPressureSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PressureManager::RemoveVirtualPressureSourceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PressureManager_RemoveVirtualPressureSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PressureManager.1
  bool success = true;
  PressureManager_RemoveVirtualPressureSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PressureManager_RemoveVirtualPressureSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::PressureManager::RemoveVirtualPressureSource");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kRemoveVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("RemoveVirtualPressureSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::UpdateVirtualPressureSourceDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder> proxy(
        new PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PressureManager::UpdateVirtualPressureSourceDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PressureManager_UpdateVirtualPressureSourceData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PressureManager.2
  bool success = true;
  PressureManager_UpdateVirtualPressureSourceData_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::PressureManager::UpdateVirtualPressureSourceData");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kUpdateVirtualPressureSourceData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("UpdateVirtualPressureSourceData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PressureManager_AddClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::AddClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_AddClient_ProxyToResponder> proxy(
        new PressureManager_AddClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_AddClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_AddClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_AddClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PressureManager::AddClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PressureManagerAddClientResult in_result);
};

bool PressureManager_AddClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_AddClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_AddClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PressureManager.3
  bool success = true;
  PressureManagerAddClientResult p_result{};
  PressureManager_AddClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PressureManager_AddClient_ProxyToResponder::Run(
    PressureManagerAddClientResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::PressureManager::AddClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PressureManagerAddClientResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddClient_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::PressureManagerAddClientResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PressureManagerStubDispatch::Accept(
    PressureManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PressureManager>(message->header()->name)) {
    case messages::PressureManager::kAddVirtualPressureSource: {
      break;
    }
    case messages::PressureManager::kRemoveVirtualPressureSource: {
      break;
    }
    case messages::PressureManager::kUpdateVirtualPressureSourceData: {
      break;
    }
    case messages::PressureManager::kAddClient: {
      break;
    }
  }
  return false;
}

// static
bool PressureManagerStubDispatch::AcceptWithResponder(
    PressureManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PressureManager>(message->header()->name)) {
    case messages::PressureManager::kAddVirtualPressureSource: {
      internal::PressureManager_AddVirtualPressureSource_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_AddVirtualPressureSource_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PressureManager.0
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::PressureSource p_source{};
      VirtualPressureSourceMetadataPtr p_metadata{};
      PressureManager_AddVirtualPressureSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 0, false);
        return false;
      }
      auto callback =
          PressureManager_AddVirtualPressureSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVirtualPressureSource(        
        std::move(p_token), 
        std::move(p_source), 
        std::move(p_metadata), std::move(callback));
      return true;
    }
    case messages::PressureManager::kRemoveVirtualPressureSource: {
      internal::PressureManager_RemoveVirtualPressureSource_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_RemoveVirtualPressureSource_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PressureManager.1
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::PressureSource p_source{};
      PressureManager_RemoveVirtualPressureSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 1, false);
        return false;
      }
      auto callback =
          PressureManager_RemoveVirtualPressureSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveVirtualPressureSource(        
        std::move(p_token), 
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::PressureManager::kUpdateVirtualPressureSourceData: {
      internal::PressureManager_UpdateVirtualPressureSourceData_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_UpdateVirtualPressureSourceData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PressureManager.2
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::PressureSource p_source{};
      ::device::mojom::PressureState p_state{};
      double p_own_contribution_estimate{};
      PressureManager_UpdateVirtualPressureSourceData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (success)
        p_own_contribution_estimate = input_data_view.own_contribution_estimate();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 2, false);
        return false;
      }
      auto callback =
          PressureManager_UpdateVirtualPressureSourceData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVirtualPressureSourceData(        
        std::move(p_token), 
        std::move(p_source), 
        std::move(p_state), 
        std::move(p_own_contribution_estimate), std::move(callback));
      return true;
    }
    case messages::PressureManager::kAddClient: {
      internal::PressureManager_AddClient_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_AddClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PressureManager.3
      bool success = true;
      ::device::mojom::PressureSource p_source{};
      std::optional<::base::UnguessableToken> p_token{};
      ::mojo::PendingAssociatedRemote<PressureClient> p_client{};
      PressureManager_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 3, false);
        return false;
      }
      auto callback =
          PressureManager_AddClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(        
        std::move(p_source), 
        std::move(p_token), 
        std::move(p_client), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPressureManagerValidationInfo[] = {
    { &internal::PressureManager_AddVirtualPressureSource_Params_Data::Validate,
     &internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data::Validate},
    { &internal::PressureManager_RemoveVirtualPressureSource_Params_Data::Validate,
     &internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data::Validate},
    { &internal::PressureManager_UpdateVirtualPressureSourceData_Params_Data::Validate,
     &internal::PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data::Validate},
    { &internal::PressureManager_AddClient_Params_Data::Validate,
     &internal::PressureManager_AddClient_ResponseParams_Data::Validate},
};

bool PressureManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::PressureManager::Name_,
    kPressureManagerValidationInfo);
}

bool PressureManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::PressureManager::Name_,
    kPressureManagerValidationInfo);
}
// The declaration includes the definition on other builds.

PressureClient::IPCStableHashFunction PressureClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PressureClient>(message.name())) {
    case messages::PressureClient::kOnPressureUpdated: {
      return &PressureClient::OnPressureUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PressureClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PressureClient>(message.name())) {
      case messages::PressureClient::kOnPressureUpdated:
            return "Receive device::mojom::PressureClient::OnPressureUpdated";
    }
  } else {
    switch (static_cast<messages::PressureClient>(message.name())) {
      case messages::PressureClient::kOnPressureUpdated:
            return "Receive reply device::mojom::PressureClient::OnPressureUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PressureClient::OnPressureUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa96da013;  // IPCStableHash for device::mojom::PressureClient::OnPressureUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PressureClientProxy::PressureClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PressureClientProxy::OnPressureUpdated(
    ::device::mojom::PressureUpdatePtr in_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureClient::OnPressureUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update"), in_update,
                        "<value of type ::device::mojom::PressureUpdatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureClient::kOnPressureUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureClient_OnPressureUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update)::BaseType> update_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::PressureUpdateDataView>(
    in_update,
    update_fragment);

  params->update.Set(
      update_fragment.is_null() ? nullptr : update_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update in PressureClient.OnPressureUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureClient::Name_);
  message.set_method_name("OnPressureUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PressureClientStubDispatch::Accept(
    PressureClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PressureClient>(message->header()->name)) {
    case messages::PressureClient::kOnPressureUpdated: {
      DCHECK(message->is_serialized());
      internal::PressureClient_OnPressureUpdated_Params_Data* params =
          reinterpret_cast<internal::PressureClient_OnPressureUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PressureClient.0
      bool success = true;
      ::device::mojom::PressureUpdatePtr p_update{};
      PressureClient_OnPressureUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdate(&p_update))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPressureUpdated(        
        std::move(p_update));
      return true;
    }
  }
  return false;
}

// static
bool PressureClientStubDispatch::AcceptWithResponder(
    PressureClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PressureClient>(message->header()->name)) {
    case messages::PressureClient::kOnPressureUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPressureClientValidationInfo[] = {
    { &internal::PressureClient_OnPressureUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool PressureClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::PressureClient::Name_,
    kPressureClientValidationInfo);
}



}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::VirtualPressureSourceMetadata::DataView, ::device::mojom::VirtualPressureSourceMetadataPtr>::Read(
    ::device::mojom::VirtualPressureSourceMetadata::DataView input,
    ::device::mojom::VirtualPressureSourceMetadataPtr* output) {
  bool success = true;
  ::device::mojom::VirtualPressureSourceMetadataPtr result(::device::mojom::VirtualPressureSourceMetadata::New());
  
      if (success)
        result->available = input.available();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void PressureManagerInterceptorForTesting::AddVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::PressureSource source, VirtualPressureSourceMetadataPtr metadata, AddVirtualPressureSourceCallback callback) {
  GetForwardingInterface()->AddVirtualPressureSource(
    std::move(token)
    , 
    std::move(source)
    , 
    std::move(metadata)
    , std::move(callback));
}
void PressureManagerInterceptorForTesting::RemoveVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::PressureSource source, RemoveVirtualPressureSourceCallback callback) {
  GetForwardingInterface()->RemoveVirtualPressureSource(
    std::move(token)
    , 
    std::move(source)
    , std::move(callback));
}
void PressureManagerInterceptorForTesting::UpdateVirtualPressureSourceData(const ::base::UnguessableToken& token, ::device::mojom::PressureSource source, ::device::mojom::PressureState state, double own_contribution_estimate, UpdateVirtualPressureSourceDataCallback callback) {
  GetForwardingInterface()->UpdateVirtualPressureSourceData(
    std::move(token)
    , 
    std::move(source)
    , 
    std::move(state)
    , 
    std::move(own_contribution_estimate)
    , std::move(callback));
}
void PressureManagerInterceptorForTesting::AddClient(::device::mojom::PressureSource source, const std::optional<::base::UnguessableToken>& token, ::mojo::PendingAssociatedRemote<PressureClient> client, AddClientCallback callback) {
  GetForwardingInterface()->AddClient(
    std::move(source)
    , 
    std::move(token)
    , 
    std::move(client)
    , std::move(callback));
}
PressureManagerAsyncWaiter::PressureManagerAsyncWaiter(
    PressureManager* proxy) : proxy_(proxy) {}

PressureManagerAsyncWaiter::~PressureManagerAsyncWaiter() = default;


void PressureManagerAsyncWaiter::AddVirtualPressureSource(
    const ::base::UnguessableToken& token, ::device::mojom::PressureSource source, VirtualPressureSourceMetadataPtr metadata) {
  base::RunLoop loop;
  proxy_->AddVirtualPressureSource(
      std::move(token),
      std::move(source),
      std::move(metadata),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PressureManagerAsyncWaiter::RemoveVirtualPressureSource(
    const ::base::UnguessableToken& token, ::device::mojom::PressureSource source) {
  base::RunLoop loop;
  proxy_->RemoveVirtualPressureSource(
      std::move(token),
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PressureManagerAsyncWaiter::UpdateVirtualPressureSourceData(
    const ::base::UnguessableToken& token, ::device::mojom::PressureSource source, ::device::mojom::PressureState state, double own_contribution_estimate) {
  base::RunLoop loop;
  proxy_->UpdateVirtualPressureSourceData(
      std::move(token),
      std::move(source),
      std::move(state),
      std::move(own_contribution_estimate),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PressureManagerAsyncWaiter::AddClient(
    ::device::mojom::PressureSource source, const std::optional<::base::UnguessableToken>& token, ::mojo::PendingAssociatedRemote<PressureClient> client, PressureManagerAddClientResult* out_result) {
  base::RunLoop loop;
  proxy_->AddClient(
      std::move(source),
      std::move(token),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             PressureManagerAddClientResult* out_result
,
             PressureManagerAddClientResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

PressureManagerAddClientResult PressureManagerAsyncWaiter::AddClient(
    ::device::mojom::PressureSource source, const std::optional<::base::UnguessableToken>& token, ::mojo::PendingAssociatedRemote<PressureClient> client) {
  PressureManagerAddClientResult async_wait_result;
  AddClient(std::move(source),std::move(token),std::move(client),&async_wait_result);
  return async_wait_result;
}




void PressureClientInterceptorForTesting::OnPressureUpdated(::device::mojom::PressureUpdatePtr update) {
  GetForwardingInterface()->OnPressureUpdated(
    std::move(update)
    );
}
PressureClientAsyncWaiter::PressureClientAsyncWaiter(
    PressureClient* proxy) : proxy_(proxy) {}

PressureClientAsyncWaiter::~PressureClientAsyncWaiter() = default;







}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif