// services/device/public/mojom/geoposition.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/geoposition.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geoposition.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* GeopositionErrorCodeToStringHelper(GeopositionErrorCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GeopositionErrorCode::kPermissionDenied:
      return "kPermissionDenied";
    case GeopositionErrorCode::kPositionUnavailable:
      return "kPositionUnavailable";
    case GeopositionErrorCode::kWifiDisabled:
      return "kWifiDisabled";
    default:
      return nullptr;
  }
}

std::string GeopositionErrorCodeToString(GeopositionErrorCode value) {
  const char *str = GeopositionErrorCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GeopositionErrorCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GeopositionErrorCode value) {
  return os << GeopositionErrorCodeToString(value);
}

namespace internal {
// static
bool GeopositionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GeopositionResult_Data* object = static_cast<const GeopositionResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GeopositionResult_Tag::kPosition: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_position, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_position, validation_context))
        return false;
      return true;
    }
    case GeopositionResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GeopositionResult");
      return false;
    }
  }
}


// static
bool Geoposition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Geoposition_Data* object =
      static_cast<const Geoposition_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  return true;
}

Geoposition_Data::Geoposition_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeopositionError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeopositionError_Data* object =
      static_cast<const GeopositionError_Data*>(data);


  if (!::device::mojom::internal::GeopositionErrorCode_Data
        ::Validate(object->error_code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_technical, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_technical_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_technical, validation_context,
                                         &error_technical_validate_params)) {
    return false;
  }

  return true;
}

GeopositionError_Data::GeopositionError_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GeopositionErrorCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GeopositionErrorCode value) {
  return std::move(context).WriteString(::device::mojom::GeopositionErrorCodeToString(value));
}

} // namespace perfetto