// services/device/public/mojom/geolocation_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  GeopositionResultSpec as device_mojom_GeopositionResultSpec,
  GeopositionResult as device_mojom_GeopositionResult
} from './geoposition.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';





export const INVALID_RADIO_SIGNAL_STRENGTH: number = -2147483648;


export const INVALID_CHANNEL: number = -2147483648;


export const INVALID_SIGNAL_TO_NOISE: number = -2147483648;


export const LocationProviderManagerModeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum LocationProviderManagerMode {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kNetworkOnly = 0,
  kPlatformOnly = 1,
  kCustomOnly = 2,
  kHybridPlatform = 3,
  kHybridFallbackNetwork = 4,
  kHybridPlatform2 = 5,
}



export type GeolocationInternalsObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GeolocationInternalsObserverPendingReceiver>;

export class GeolocationInternalsObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GeolocationInternalsObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<GeolocationInternalsObserverPendingReceiver>;
  constructor(handle: MojoHandle|GeolocationInternalsObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.GeolocationInternalsObserver',
        scope);
  }
}

export interface GeolocationInternalsObserverInterface {
  onDiagnosticsChanged(diagnostics: GeolocationDiagnostics): void;
  onNetworkLocationRequested(accessPointData: AccessPointData[]): void;
  onNetworkLocationReceived(response: (NetworkLocationResponse | null)): void;
}

export class GeolocationInternalsObserverRemote implements GeolocationInternalsObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GeolocationInternalsObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GeolocationInternalsObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GeolocationInternalsObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GeolocationInternalsObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onDiagnosticsChanged(
      diagnostics: GeolocationDiagnostics): void {
    this.proxy.sendMessage(
        0,
        GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsSpec.$,
        null,
        [
          diagnostics
        ],
        false);
  }

  onNetworkLocationRequested(
      accessPointData: AccessPointData[]): void {
    this.proxy.sendMessage(
        1,
        GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsSpec.$,
        null,
        [
          accessPointData
        ],
        false);
  }

  onNetworkLocationReceived(
      response: (NetworkLocationResponse | null)): void {
    this.proxy.sendMessage(
        2,
        GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GeolocationInternalsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GeolocationInternalsObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GeolocationInternalsObserverRemote, GeolocationInternalsObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GeolocationInternalsObserverRemote, GeolocationInternalsObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GeolocationInternalsObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GeolocationInternalsObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsSpec.$,
        null,
        impl.onDiagnosticsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsSpec.$,
        null,
        impl.onNetworkLocationRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsSpec.$,
        null,
        impl.onNetworkLocationReceived.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GeolocationInternalsObserver {
  static get $interfaceName(): string {
    return "device.mojom.GeolocationInternalsObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GeolocationInternalsObserverRemote {
    let remote = new GeolocationInternalsObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GeolocationInternalsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GeolocationInternalsObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GeolocationInternalsObserverRemote, GeolocationInternalsObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GeolocationInternalsObserverRemote, GeolocationInternalsObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onDiagnosticsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onNetworkLocationRequested: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onNetworkLocationReceived: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GeolocationInternalsObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onDiagnosticsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsSpec.$,
        null,
        this.onDiagnosticsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onNetworkLocationRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsSpec.$,
        null,
        this.onNetworkLocationRequested.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onNetworkLocationReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsSpec.$,
        null,
        this.onNetworkLocationReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type GeolocationInternalsPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<GeolocationInternalsPendingReceiver>;

export class GeolocationInternalsPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<GeolocationInternals> {

  handle: mojo.internal.interfaceSupport.Endpoint<GeolocationInternalsPendingReceiver>;
  constructor(handle: MojoHandle|GeolocationInternalsPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.GeolocationInternals',
        scope);
  }
}

export interface GeolocationInternalsInterface {
  addInternalsObserver(observer: GeolocationInternalsObserverRemote): Promise<{
        diagnostics: (GeolocationDiagnostics | null), }>;
}

export class GeolocationInternalsRemote implements GeolocationInternalsInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<GeolocationInternalsPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<GeolocationInternalsPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|GeolocationInternalsPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GeolocationInternalsPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  addInternalsObserver(
      observer: GeolocationInternalsObserverRemote): Promise<{
        diagnostics: (GeolocationDiagnostics | null), }> {
    return this.proxy.sendMessage(
        0,
        GeolocationInternals_AddInternalsObserver_ParamsSpec.$,
        GeolocationInternals_AddInternalsObserver_ResponseParamsSpec.$,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GeolocationInternals
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GeolocationInternalsReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GeolocationInternalsRemote, GeolocationInternalsPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GeolocationInternalsRemote, GeolocationInternalsPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: GeolocationInternalsInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GeolocationInternalsRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GeolocationInternals_AddInternalsObserver_ParamsSpec.$,
        GeolocationInternals_AddInternalsObserver_ResponseParamsSpec.$,
        impl.addInternalsObserver.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GeolocationInternals {
  static get $interfaceName(): string {
    return "device.mojom.GeolocationInternals";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): GeolocationInternalsRemote {
    let remote = new GeolocationInternalsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the GeolocationInternals
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GeolocationInternalsCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    GeolocationInternalsRemote, GeolocationInternalsPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    GeolocationInternalsRemote, GeolocationInternalsPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  addInternalsObserver: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GeolocationInternalsRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.addInternalsObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GeolocationInternals_AddInternalsObserver_ParamsSpec.$,
        GeolocationInternals_AddInternalsObserver_ResponseParamsSpec.$,
        this.addInternalsObserver.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const AccessPointDataSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NetworkLocationDiagnosticsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PositionCacheDiagnosticsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const WifiPollingPolicyDiagnosticsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeolocationDiagnosticsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const NetworkLocationResponseSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeolocationInternals_AddInternalsObserver_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeolocationInternals_AddInternalsObserver_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface AccessPointDataMojoType {
  macAddress: string;
  radioSignalStrength: number;
  channel: number;
  signalToNoise: number;
  timestamp: (mojoBase_mojom_Time | null);
}


export type AccessPointData = AccessPointDataMojoType;
mojo.internal.Struct<AccessPointDataMojoType>(
    AccessPointDataSpec.$,
    'AccessPointData',
    [
      mojo.internal.StructField<AccessPointDataMojoType, string>(
        'macAddress', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AccessPointDataMojoType, number>(
        'radioSignalStrength', 8,
        0,
        mojo.internal.Int32,
        INVALID_RADIO_SIGNAL_STRENGTH,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AccessPointDataMojoType, number>(
        'channel', 12,
        0,
        mojo.internal.Int32,
        INVALID_CHANNEL,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AccessPointDataMojoType, number>(
        'signalToNoise', 16,
        0,
        mojo.internal.Int32,
        INVALID_SIGNAL_TO_NOISE,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AccessPointDataMojoType, mojoBase_mojom_Time>(
        'timestamp', 24,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface NetworkLocationDiagnosticsMojoType {
  accessPointData: AccessPointData[];
  wifiTimestamp: (mojoBase_mojom_Time | null);
}


export type NetworkLocationDiagnostics = NetworkLocationDiagnosticsMojoType;
mojo.internal.Struct<NetworkLocationDiagnosticsMojoType>(
    NetworkLocationDiagnosticsSpec.$,
    'NetworkLocationDiagnostics',
    [
      mojo.internal.StructField<NetworkLocationDiagnosticsMojoType, AccessPointData[]>(
        'accessPointData', 0,
        0,
        mojo.internal.Array(AccessPointDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NetworkLocationDiagnosticsMojoType, mojoBase_mojom_Time>(
        'wifiTimestamp', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PositionCacheDiagnosticsMojoType {
  cacheSize: number;
  hitRate: (number | null);
  lastHit: (mojoBase_mojom_Time | null);
  lastMiss: (mojoBase_mojom_Time | null);
  lastNetworkResult: (device_mojom_GeopositionResult | null);
}


export type PositionCacheDiagnostics = PositionCacheDiagnosticsMojoType;
mojo.internal.Struct<PositionCacheDiagnosticsMojoType>(
    PositionCacheDiagnosticsSpec.$,
    'PositionCacheDiagnostics',
    [
      mojo.internal.StructField<PositionCacheDiagnosticsMojoType, number>(
        'cacheSize', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PositionCacheDiagnosticsMojoType, mojoBase_mojom_Time>(
        'lastHit', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PositionCacheDiagnosticsMojoType, mojoBase_mojom_Time>(
        'lastMiss', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PositionCacheDiagnosticsMojoType, boolean>(
        'hit_rate_$flag', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "hit_rate_$value",
          originalFieldName: "hitRate",
        },
        undefined,
    ),
      mojo.internal.StructField<PositionCacheDiagnosticsMojoType, number>(
        'hit_rate_$value', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "hitRate",
        },
        undefined,
    ),
      mojo.internal.StructField<PositionCacheDiagnosticsMojoType, device_mojom_GeopositionResult>(
        'lastNetworkResult', 32,
        0,
        device_mojom_GeopositionResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface WifiPollingPolicyDiagnosticsMojoType {
  intervalStart: (mojoBase_mojom_Time | null);
  intervalDuration: mojoBase_mojom_TimeDelta;
  pollingInterval: mojoBase_mojom_TimeDelta;
  defaultInterval: mojoBase_mojom_TimeDelta;
  noChangeInterval: mojoBase_mojom_TimeDelta;
  twoNoChangeInterval: mojoBase_mojom_TimeDelta;
  noWifiInterval: mojoBase_mojom_TimeDelta;
}


export type WifiPollingPolicyDiagnostics = WifiPollingPolicyDiagnosticsMojoType;
mojo.internal.Struct<WifiPollingPolicyDiagnosticsMojoType>(
    WifiPollingPolicyDiagnosticsSpec.$,
    'WifiPollingPolicyDiagnostics',
    [
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_Time>(
        'intervalStart', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_TimeDelta>(
        'intervalDuration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_TimeDelta>(
        'pollingInterval', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_TimeDelta>(
        'defaultInterval', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_TimeDelta>(
        'noChangeInterval', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_TimeDelta>(
        'twoNoChangeInterval', 40,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<WifiPollingPolicyDiagnosticsMojoType, mojoBase_mojom_TimeDelta>(
        'noWifiInterval', 48,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);




export const GeolocationDiagnostics_ProviderStateSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum GeolocationDiagnostics_ProviderState {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kStopped = 0,
  kHighAccuracy = 1,
  kLowAccuracy = 2,
  kBlockedBySystemPermission = 3,
}


export interface GeolocationDiagnosticsMojoType {
  providerState: GeolocationDiagnostics_ProviderState;
  locationProviderManagerMode: (LocationProviderManagerMode | null);
  networkLocationDiagnostics: (NetworkLocationDiagnostics | null);
  positionCacheDiagnostics: (PositionCacheDiagnostics | null);
  wifiPollingPolicyDiagnostics: (WifiPollingPolicyDiagnostics | null);
}


export type GeolocationDiagnostics = GeolocationDiagnosticsMojoType;
mojo.internal.Struct<GeolocationDiagnosticsMojoType>(
    GeolocationDiagnosticsSpec.$,
    'GeolocationDiagnostics',
    [
      mojo.internal.StructField<GeolocationDiagnosticsMojoType, GeolocationDiagnostics_ProviderState>(
        'providerState', 0,
        0,
        GeolocationDiagnostics_ProviderStateSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeolocationDiagnosticsMojoType, NetworkLocationDiagnostics>(
        'networkLocationDiagnostics', 8,
        0,
        NetworkLocationDiagnosticsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeolocationDiagnosticsMojoType, PositionCacheDiagnostics>(
        'positionCacheDiagnostics', 16,
        0,
        PositionCacheDiagnosticsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeolocationDiagnosticsMojoType, WifiPollingPolicyDiagnostics>(
        'wifiPollingPolicyDiagnostics', 24,
        0,
        WifiPollingPolicyDiagnosticsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeolocationDiagnosticsMojoType, boolean>(
        'location_provider_manager_mode_$flag', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "location_provider_manager_mode_$value",
          originalFieldName: "locationProviderManagerMode",
        },
        undefined,
    ),
      mojo.internal.StructField<GeolocationDiagnosticsMojoType, LocationProviderManagerMode>(
        'location_provider_manager_mode_$value', 32,
        0,
        LocationProviderManagerModeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "locationProviderManagerMode",
        },
        undefined,
    ),
    ],
    [[0, 48],]);





export interface NetworkLocationResponseMojoType {
  latitude: number;
  longitude: number;
  accuracy: (number | null);
}


export type NetworkLocationResponse = NetworkLocationResponseMojoType;
mojo.internal.Struct<NetworkLocationResponseMojoType>(
    NetworkLocationResponseSpec.$,
    'NetworkLocationResponse',
    [
      mojo.internal.StructField<NetworkLocationResponseMojoType, number>(
        'latitude', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NetworkLocationResponseMojoType, number>(
        'longitude', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<NetworkLocationResponseMojoType, boolean>(
        'accuracy_$flag', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "accuracy_$value",
          originalFieldName: "accuracy",
        },
        undefined,
    ),
      mojo.internal.StructField<NetworkLocationResponseMojoType, number>(
        'accuracy_$value', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "accuracy",
        },
        undefined,
    ),
    ],
    [[0, 40],]);





export interface GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsMojoType {
  diagnostics: GeolocationDiagnostics;
}


export type GeolocationInternalsObserver_OnDiagnosticsChanged_Params = GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsMojoType;
mojo.internal.Struct<GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsMojoType>(
    GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsSpec.$,
    'GeolocationInternalsObserver_OnDiagnosticsChanged_Params',
    [
      mojo.internal.StructField<GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsMojoType, GeolocationDiagnostics>(
        'diagnostics', 0,
        0,
        GeolocationDiagnosticsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsMojoType {
  accessPointData: AccessPointData[];
}


export type GeolocationInternalsObserver_OnNetworkLocationRequested_Params = GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsMojoType;
mojo.internal.Struct<GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsMojoType>(
    GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsSpec.$,
    'GeolocationInternalsObserver_OnNetworkLocationRequested_Params',
    [
      mojo.internal.StructField<GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsMojoType, AccessPointData[]>(
        'accessPointData', 0,
        0,
        mojo.internal.Array(AccessPointDataSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsMojoType {
  response: (NetworkLocationResponse | null);
}


export type GeolocationInternalsObserver_OnNetworkLocationReceived_Params = GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsMojoType;
mojo.internal.Struct<GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsMojoType>(
    GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsSpec.$,
    'GeolocationInternalsObserver_OnNetworkLocationReceived_Params',
    [
      mojo.internal.StructField<GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsMojoType, NetworkLocationResponse>(
        'response', 0,
        0,
        NetworkLocationResponseSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GeolocationInternals_AddInternalsObserver_ParamsMojoType {
  observer: GeolocationInternalsObserverRemote;
}


export type GeolocationInternals_AddInternalsObserver_Params = GeolocationInternals_AddInternalsObserver_ParamsMojoType;
mojo.internal.Struct<GeolocationInternals_AddInternalsObserver_ParamsMojoType>(
    GeolocationInternals_AddInternalsObserver_ParamsSpec.$,
    'GeolocationInternals_AddInternalsObserver_Params',
    [
      mojo.internal.StructField<GeolocationInternals_AddInternalsObserver_ParamsMojoType, GeolocationInternalsObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(GeolocationInternalsObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface GeolocationInternals_AddInternalsObserver_ResponseParamsMojoType {
  diagnostics: (GeolocationDiagnostics | null);
}


export type GeolocationInternals_AddInternalsObserver_ResponseParams = GeolocationInternals_AddInternalsObserver_ResponseParamsMojoType;
mojo.internal.Struct<GeolocationInternals_AddInternalsObserver_ResponseParamsMojoType>(
    GeolocationInternals_AddInternalsObserver_ResponseParamsSpec.$,
    'GeolocationInternals_AddInternalsObserver_ResponseParams',
    [
      mojo.internal.StructField<GeolocationInternals_AddInternalsObserver_ResponseParamsMojoType, GeolocationDiagnostics>(
        'diagnostics', 0,
        0,
        GeolocationDiagnosticsSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



