// services/device/public/mojom/geolocation_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/geolocation_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geolocation_context.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* GeolocationPermissionLevelToStringHelper(GeolocationPermissionLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case GeolocationPermissionLevel::kDenied:
      return "kDenied";
    case GeolocationPermissionLevel::kApproximate:
      return "kApproximate";
    case GeolocationPermissionLevel::kPrecise:
      return "kPrecise";
    default:
      return nullptr;
  }
}

std::string GeolocationPermissionLevelToString(GeolocationPermissionLevel value) {
  const char *str = GeolocationPermissionLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown GeolocationPermissionLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, GeolocationPermissionLevel value) {
  return os << GeolocationPermissionLevelToString(value);
}

namespace internal {


// static
bool GeolocationContext_BindGeolocation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationContext_BindGeolocation_Params_Data* object =
      static_cast<const GeolocationContext_BindGeolocation_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requesting_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requesting_url, validation_context))
    return false;


  if (!::device::mojom::internal::GeolocationClientId_Data
        ::Validate(object->client_id, validation_context))
    return false;

  return true;
}

GeolocationContext_BindGeolocation_Params_Data::GeolocationContext_BindGeolocation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationContext_OnPermissionUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationContext_OnPermissionUpdated_Params_Data* object =
      static_cast<const GeolocationContext_OnPermissionUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;


  if (!::device::mojom::internal::GeolocationPermissionLevel_Data
        ::Validate(object->permission_level, validation_context))
    return false;

  return true;
}

GeolocationContext_OnPermissionUpdated_Params_Data::GeolocationContext_OnPermissionUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationContext_SetOverride_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationContext_SetOverride_Params_Data* object =
      static_cast<const GeolocationContext_SetOverride_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

GeolocationContext_SetOverride_Params_Data::GeolocationContext_SetOverride_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GeolocationContext_ClearOverride_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GeolocationContext_ClearOverride_Params_Data* object =
      static_cast<const GeolocationContext_ClearOverride_Params_Data*>(data);

  return true;
}

GeolocationContext_ClearOverride_Params_Data::GeolocationContext_ClearOverride_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::GeolocationPermissionLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::GeolocationPermissionLevel value) {
  return std::move(context).WriteString(::device::mojom::GeolocationPermissionLevelToString(value));
}

} // namespace perfetto