// services/data_decoder/public/mojom/data_decoder_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/data_decoder_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/data_decoder_service.mojom-params-data.h"
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/data_decoder_service.mojom-import-headers.h"
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-test-utils.h"


namespace data_decoder::mojom {
// The declaration includes the definition on other builds.

DataDecoderService::IPCStableHashFunction DataDecoderService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DataDecoderService>(message.name())) {
    case messages::DataDecoderService::kBindImageDecoder: {
      return &DataDecoderService::BindImageDecoder_Sym::IPCStableHash;
    }
    case messages::DataDecoderService::kBindXmlParser: {
      return &DataDecoderService::BindXmlParser_Sym::IPCStableHash;
    }
    case messages::DataDecoderService::kBindWebBundleParserFactory: {
      return &DataDecoderService::BindWebBundleParserFactory_Sym::IPCStableHash;
    }
    case messages::DataDecoderService::kBindGzipper: {
      return &DataDecoderService::BindGzipper_Sym::IPCStableHash;
    }
    case messages::DataDecoderService::kBindStructuredHeadersParser: {
      return &DataDecoderService::BindStructuredHeadersParser_Sym::IPCStableHash;
    }
    case messages::DataDecoderService::kBindCborParser: {
      return &DataDecoderService::BindCborParser_Sym::IPCStableHash;
    }
    case messages::DataDecoderService::kBindPixCodeValidator: {
      return &DataDecoderService::BindPixCodeValidator_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DataDecoderService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DataDecoderService>(message.name())) {
      case messages::DataDecoderService::kBindImageDecoder:
            return "Receive data_decoder::mojom::DataDecoderService::BindImageDecoder";
      case messages::DataDecoderService::kBindXmlParser:
            return "Receive data_decoder::mojom::DataDecoderService::BindXmlParser";
      case messages::DataDecoderService::kBindWebBundleParserFactory:
            return "Receive data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory";
      case messages::DataDecoderService::kBindGzipper:
            return "Receive data_decoder::mojom::DataDecoderService::BindGzipper";
      case messages::DataDecoderService::kBindStructuredHeadersParser:
            return "Receive data_decoder::mojom::DataDecoderService::BindStructuredHeadersParser";
      case messages::DataDecoderService::kBindCborParser:
            return "Receive data_decoder::mojom::DataDecoderService::BindCborParser";
      case messages::DataDecoderService::kBindPixCodeValidator:
            return "Receive data_decoder::mojom::DataDecoderService::BindPixCodeValidator";
    }
  } else {
    switch (static_cast<messages::DataDecoderService>(message.name())) {
      case messages::DataDecoderService::kBindImageDecoder:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindImageDecoder";
      case messages::DataDecoderService::kBindXmlParser:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindXmlParser";
      case messages::DataDecoderService::kBindWebBundleParserFactory:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory";
      case messages::DataDecoderService::kBindGzipper:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindGzipper";
      case messages::DataDecoderService::kBindStructuredHeadersParser:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindStructuredHeadersParser";
      case messages::DataDecoderService::kBindCborParser:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindCborParser";
      case messages::DataDecoderService::kBindPixCodeValidator:
            return "Receive reply data_decoder::mojom::DataDecoderService::BindPixCodeValidator";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DataDecoderService::BindImageDecoder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2894c26;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindImageDecoder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataDecoderService::BindXmlParser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc82301d;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindXmlParser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataDecoderService::BindWebBundleParserFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e4cef32;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataDecoderService::BindGzipper_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf92224a0;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindGzipper
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataDecoderService::BindStructuredHeadersParser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0fbe8f88;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindStructuredHeadersParser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataDecoderService::BindCborParser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16cb969f;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindCborParser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DataDecoderService::BindPixCodeValidator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf7c5603;  // IPCStableHash for data_decoder::mojom::DataDecoderService::BindPixCodeValidator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DataDecoderServiceProxy::DataDecoderServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DataDecoderServiceProxy::BindImageDecoder(
    ::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindImageDecoder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindImageDecoder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindImageDecoder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::ImageDecoderInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DataDecoderService.BindImageDecoder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindImageDecoder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataDecoderServiceProxy::BindXmlParser(
    ::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> in_reciever) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindXmlParser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reciever"), in_reciever,
                        "<value of type ::mojo::PendingReceiver<::data_decoder::mojom::XmlParser>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindXmlParser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindXmlParser_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::XmlParserInterfaceBase>>(
    in_reciever,
    &params->reciever,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->reciever)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid reciever in DataDecoderService.BindXmlParser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindXmlParser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataDecoderServiceProxy::BindWebBundleParserFactory(
    ::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindWebBundleParserFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindWebBundleParserFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindWebBundleParserFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::web_package::mojom::WebBundleParserFactoryInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DataDecoderService.BindWebBundleParserFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindWebBundleParserFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataDecoderServiceProxy::BindGzipper(
    ::mojo::PendingReceiver<::data_decoder::mojom::Gzipper> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindGzipper", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::data_decoder::mojom::Gzipper>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindGzipper), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindGzipper_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::GzipperInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DataDecoderService.BindGzipper request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindGzipper");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataDecoderServiceProxy::BindStructuredHeadersParser(
    ::mojo::PendingReceiver<::data_decoder::mojom::StructuredHeadersParser> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindStructuredHeadersParser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::data_decoder::mojom::StructuredHeadersParser>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindStructuredHeadersParser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindStructuredHeadersParser_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::StructuredHeadersParserInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DataDecoderService.BindStructuredHeadersParser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindStructuredHeadersParser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataDecoderServiceProxy::BindCborParser(
    ::mojo::PendingReceiver<::data_decoder::mojom::CborParser> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindCborParser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::data_decoder::mojom::CborParser>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindCborParser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindCborParser_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_decoder::mojom::CborParserInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DataDecoderService.BindCborParser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindCborParser");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DataDecoderServiceProxy::BindPixCodeValidator(
    ::mojo::PendingReceiver<::payments::facilitated::mojom::PixCodeValidator> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::DataDecoderService::BindPixCodeValidator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::payments::facilitated::mojom::PixCodeValidator>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DataDecoderService::kBindPixCodeValidator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::DataDecoderService_BindPixCodeValidator_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::payments::facilitated::mojom::PixCodeValidatorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DataDecoderService.BindPixCodeValidator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DataDecoderService::Name_);
  message.set_method_name("BindPixCodeValidator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DataDecoderServiceStubDispatch::Accept(
    DataDecoderService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DataDecoderService>(message->header()->name)) {
    case messages::DataDecoderService::kBindImageDecoder: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindImageDecoder_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindImageDecoder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.0
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> p_receiver{};
      DataDecoderService_BindImageDecoder_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindImageDecoder(        
        std::move(p_receiver));
      return true;
    }
    case messages::DataDecoderService::kBindXmlParser: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindXmlParser_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindXmlParser_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.1
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> p_reciever{};
      DataDecoderService_BindXmlParser_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_reciever =
            input_data_view.TakeReciever<decltype(p_reciever)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindXmlParser(        
        std::move(p_reciever));
      return true;
    }
    case messages::DataDecoderService::kBindWebBundleParserFactory: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindWebBundleParserFactory_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindWebBundleParserFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.2
      bool success = true;
      ::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> p_receiver{};
      DataDecoderService_BindWebBundleParserFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWebBundleParserFactory(        
        std::move(p_receiver));
      return true;
    }
    case messages::DataDecoderService::kBindGzipper: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindGzipper_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindGzipper_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.3
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::Gzipper> p_receiver{};
      DataDecoderService_BindGzipper_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGzipper(        
        std::move(p_receiver));
      return true;
    }
    case messages::DataDecoderService::kBindStructuredHeadersParser: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindStructuredHeadersParser_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindStructuredHeadersParser_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.4
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::StructuredHeadersParser> p_receiver{};
      DataDecoderService_BindStructuredHeadersParser_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindStructuredHeadersParser(        
        std::move(p_receiver));
      return true;
    }
    case messages::DataDecoderService::kBindCborParser: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindCborParser_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindCborParser_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.5
      bool success = true;
      ::mojo::PendingReceiver<::data_decoder::mojom::CborParser> p_receiver{};
      DataDecoderService_BindCborParser_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindCborParser(        
        std::move(p_receiver));
      return true;
    }
    case messages::DataDecoderService::kBindPixCodeValidator: {
      DCHECK(message->is_serialized());
      internal::DataDecoderService_BindPixCodeValidator_Params_Data* params =
          reinterpret_cast<internal::DataDecoderService_BindPixCodeValidator_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DataDecoderService.6
      bool success = true;
      ::mojo::PendingReceiver<::payments::facilitated::mojom::PixCodeValidator> p_receiver{};
      DataDecoderService_BindPixCodeValidator_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DataDecoderService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPixCodeValidator(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool DataDecoderServiceStubDispatch::AcceptWithResponder(
    DataDecoderService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DataDecoderService>(message->header()->name)) {
    case messages::DataDecoderService::kBindImageDecoder: {
      break;
    }
    case messages::DataDecoderService::kBindXmlParser: {
      break;
    }
    case messages::DataDecoderService::kBindWebBundleParserFactory: {
      break;
    }
    case messages::DataDecoderService::kBindGzipper: {
      break;
    }
    case messages::DataDecoderService::kBindStructuredHeadersParser: {
      break;
    }
    case messages::DataDecoderService::kBindCborParser: {
      break;
    }
    case messages::DataDecoderService::kBindPixCodeValidator: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDataDecoderServiceValidationInfo[] = {
    { &internal::DataDecoderService_BindImageDecoder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DataDecoderService_BindXmlParser_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DataDecoderService_BindWebBundleParserFactory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DataDecoderService_BindGzipper_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DataDecoderService_BindStructuredHeadersParser_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DataDecoderService_BindCborParser_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DataDecoderService_BindPixCodeValidator_Params_Data::Validate,
     nullptr /* no response */},
};

bool DataDecoderServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_decoder::mojom::DataDecoderService::Name_,
    kDataDecoderServiceValidationInfo);
}



}  // data_decoder::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace data_decoder::mojom {


void DataDecoderServiceInterceptorForTesting::BindImageDecoder(::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> receiver) {
  GetForwardingInterface()->BindImageDecoder(
    std::move(receiver)
    );
}
void DataDecoderServiceInterceptorForTesting::BindXmlParser(::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> reciever) {
  GetForwardingInterface()->BindXmlParser(
    std::move(reciever)
    );
}
void DataDecoderServiceInterceptorForTesting::BindWebBundleParserFactory(::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> receiver) {
  GetForwardingInterface()->BindWebBundleParserFactory(
    std::move(receiver)
    );
}
void DataDecoderServiceInterceptorForTesting::BindGzipper(::mojo::PendingReceiver<::data_decoder::mojom::Gzipper> receiver) {
  GetForwardingInterface()->BindGzipper(
    std::move(receiver)
    );
}
void DataDecoderServiceInterceptorForTesting::BindStructuredHeadersParser(::mojo::PendingReceiver<::data_decoder::mojom::StructuredHeadersParser> receiver) {
  GetForwardingInterface()->BindStructuredHeadersParser(
    std::move(receiver)
    );
}
void DataDecoderServiceInterceptorForTesting::BindCborParser(::mojo::PendingReceiver<::data_decoder::mojom::CborParser> receiver) {
  GetForwardingInterface()->BindCborParser(
    std::move(receiver)
    );
}
void DataDecoderServiceInterceptorForTesting::BindPixCodeValidator(::mojo::PendingReceiver<::payments::facilitated::mojom::PixCodeValidator> receiver) {
  GetForwardingInterface()->BindPixCodeValidator(
    std::move(receiver)
    );
}
DataDecoderServiceAsyncWaiter::DataDecoderServiceAsyncWaiter(
    DataDecoderService* proxy) : proxy_(proxy) {}

DataDecoderServiceAsyncWaiter::~DataDecoderServiceAsyncWaiter() = default;







}  // data_decoder::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif