// services/data_decoder/public/mojom/cbor_parser.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_CBOR_PARSER_MOJOM_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_CBOR_PARSER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/data_decoder/public/mojom/cbor_parser.mojom-features.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/cbor_parser.mojom-shared.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/cbor_parser.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace data_decoder::mojom {

class CborParserProxy;

template <typename ImplRefTraits>
class CborParserStub;

class CborParserRequestValidator;
class CborParserResponseValidator;


class CborParser
    : public CborParserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_decoder.mojom.CborParser";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CborParserInterfaceBase;
  using Proxy_ = CborParserProxy;

  template <typename ImplRefTraits>
  using Stub_ = CborParserStub<ImplRefTraits>;

  using RequestValidator_ = CborParserRequestValidator;
  using ResponseValidator_ = CborParserResponseValidator;
  enum MethodMinVersions : uint32_t {
    kParseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Parse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CborParser() = default;

  using ParseCallback = base::OnceCallback<void(std::optional<::base::Value>, const std::optional<std::string>&)>;
  using ParseMojoCallback = base::OnceCallback<void(std::optional<::base::Value>, const std::optional<std::string>&)>;

  virtual void Parse(::mojo_base::BigBuffer cbor, ParseCallback callback) = 0;
};



class  CborParserProxy
    : public CborParser {
 public:
  using InterfaceType = CborParser;

  explicit CborParserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Parse(::mojo_base::BigBuffer cbor, ParseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CborParserStubDispatch {
 public:
  static bool Accept(CborParser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CborParser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CborParser>>
class CborParserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CborParserStub() = default;
  ~CborParserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CborParserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CborParserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CborParserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CborParserResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // data_decoder::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_CBOR_PARSER_MOJOM_H_