// services/audio/public/mojom/audio_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/audio_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/audio_service.mojom-params-data.h"
#include "services/audio/public/mojom/audio_service.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/audio_service.mojom-import-headers.h"
#include "services/audio/public/mojom/audio_service.mojom-test-utils.h"


namespace audio::mojom {
// The declaration includes the definition on other builds.

AudioService::IPCStableHashFunction AudioService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AudioService>(message.name())) {
    case messages::AudioService::kBindSystemInfo: {
      return &AudioService::BindSystemInfo_Sym::IPCStableHash;
    }
    case messages::AudioService::kBindDebugRecording: {
      return &AudioService::BindDebugRecording_Sym::IPCStableHash;
    }
    case messages::AudioService::kBindStreamFactory: {
      return &AudioService::BindStreamFactory_Sym::IPCStableHash;
    }
    case messages::AudioService::kBindDeviceNotifier: {
      return &AudioService::BindDeviceNotifier_Sym::IPCStableHash;
    }
    case messages::AudioService::kBindLogFactoryManager: {
      return &AudioService::BindLogFactoryManager_Sym::IPCStableHash;
    }
    case messages::AudioService::kBindTestingApi: {
      return &AudioService::BindTestingApi_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AudioService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AudioService>(message.name())) {
      case messages::AudioService::kBindSystemInfo:
            return "Receive audio::mojom::AudioService::BindSystemInfo";
      case messages::AudioService::kBindDebugRecording:
            return "Receive audio::mojom::AudioService::BindDebugRecording";
      case messages::AudioService::kBindStreamFactory:
            return "Receive audio::mojom::AudioService::BindStreamFactory";
      case messages::AudioService::kBindDeviceNotifier:
            return "Receive audio::mojom::AudioService::BindDeviceNotifier";
      case messages::AudioService::kBindLogFactoryManager:
            return "Receive audio::mojom::AudioService::BindLogFactoryManager";
      case messages::AudioService::kBindTestingApi:
            return "Receive audio::mojom::AudioService::BindTestingApi";
    }
  } else {
    switch (static_cast<messages::AudioService>(message.name())) {
      case messages::AudioService::kBindSystemInfo:
            return "Receive reply audio::mojom::AudioService::BindSystemInfo";
      case messages::AudioService::kBindDebugRecording:
            return "Receive reply audio::mojom::AudioService::BindDebugRecording";
      case messages::AudioService::kBindStreamFactory:
            return "Receive reply audio::mojom::AudioService::BindStreamFactory";
      case messages::AudioService::kBindDeviceNotifier:
            return "Receive reply audio::mojom::AudioService::BindDeviceNotifier";
      case messages::AudioService::kBindLogFactoryManager:
            return "Receive reply audio::mojom::AudioService::BindLogFactoryManager";
      case messages::AudioService::kBindTestingApi:
            return "Receive reply audio::mojom::AudioService::BindTestingApi";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AudioService::BindSystemInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x684a9aff;  // IPCStableHash for audio::mojom::AudioService::BindSystemInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioService::BindDebugRecording_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80a6e19e;  // IPCStableHash for audio::mojom::AudioService::BindDebugRecording
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioService::BindStreamFactory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe304cdf4;  // IPCStableHash for audio::mojom::AudioService::BindStreamFactory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioService::BindDeviceNotifier_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x589b4da2;  // IPCStableHash for audio::mojom::AudioService::BindDeviceNotifier
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioService::BindLogFactoryManager_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x728a4a05;  // IPCStableHash for audio::mojom::AudioService::BindLogFactoryManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AudioService::BindTestingApi_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00e076f4;  // IPCStableHash for audio::mojom::AudioService::BindTestingApi
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AudioServiceProxy::AudioServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AudioServiceProxy::BindSystemInfo(
    ::mojo::PendingReceiver<::audio::mojom::SystemInfo> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::AudioService::BindSystemInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::audio::mojom::SystemInfo>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioService::kBindSystemInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::AudioService_BindSystemInfo_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::audio::mojom::SystemInfoInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioService.BindSystemInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioService::Name_);
  message.set_method_name("BindSystemInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioServiceProxy::BindDebugRecording(
    ::mojo::PendingReceiver<::audio::mojom::DebugRecording> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::AudioService::BindDebugRecording", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::audio::mojom::DebugRecording>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioService::kBindDebugRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::AudioService_BindDebugRecording_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::audio::mojom::DebugRecordingInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioService.BindDebugRecording request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioService::Name_);
  message.set_method_name("BindDebugRecording");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioServiceProxy::BindStreamFactory(
    ::mojo::PendingReceiver<::media::mojom::AudioStreamFactory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::AudioService::BindStreamFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::AudioStreamFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioService::kBindStreamFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::AudioService_BindStreamFactory_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::AudioStreamFactoryInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioService.BindStreamFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioService::Name_);
  message.set_method_name("BindStreamFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioServiceProxy::BindDeviceNotifier(
    ::mojo::PendingReceiver<::audio::mojom::DeviceNotifier> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::AudioService::BindDeviceNotifier", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::audio::mojom::DeviceNotifier>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioService::kBindDeviceNotifier), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::AudioService_BindDeviceNotifier_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::audio::mojom::DeviceNotifierInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioService.BindDeviceNotifier request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioService::Name_);
  message.set_method_name("BindDeviceNotifier");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioServiceProxy::BindLogFactoryManager(
    ::mojo::PendingReceiver<::audio::mojom::LogFactoryManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::AudioService::BindLogFactoryManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::audio::mojom::LogFactoryManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioService::kBindLogFactoryManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::AudioService_BindLogFactoryManager_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::audio::mojom::LogFactoryManagerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioService.BindLogFactoryManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioService::Name_);
  message.set_method_name("BindLogFactoryManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AudioServiceProxy::BindTestingApi(
    ::mojo::PendingReceiver<::audio::mojom::TestingApi> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::AudioService::BindTestingApi", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::audio::mojom::TestingApi>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AudioService::kBindTestingApi), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::AudioService_BindTestingApi_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::audio::mojom::TestingApiInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in AudioService.BindTestingApi request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AudioService::Name_);
  message.set_method_name("BindTestingApi");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AudioServiceStubDispatch::Accept(
    AudioService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AudioService>(message->header()->name)) {
    case messages::AudioService::kBindSystemInfo: {
      DCHECK(message->is_serialized());
      internal::AudioService_BindSystemInfo_Params_Data* params =
          reinterpret_cast<internal::AudioService_BindSystemInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioService.0
      bool success = true;
      ::mojo::PendingReceiver<::audio::mojom::SystemInfo> p_receiver{};
      AudioService_BindSystemInfo_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSystemInfo(        
        std::move(p_receiver));
      return true;
    }
    case messages::AudioService::kBindDebugRecording: {
      DCHECK(message->is_serialized());
      internal::AudioService_BindDebugRecording_Params_Data* params =
          reinterpret_cast<internal::AudioService_BindDebugRecording_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioService.1
      bool success = true;
      ::mojo::PendingReceiver<::audio::mojom::DebugRecording> p_receiver{};
      AudioService_BindDebugRecording_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDebugRecording(        
        std::move(p_receiver));
      return true;
    }
    case messages::AudioService::kBindStreamFactory: {
      DCHECK(message->is_serialized());
      internal::AudioService_BindStreamFactory_Params_Data* params =
          reinterpret_cast<internal::AudioService_BindStreamFactory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioService.2
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::AudioStreamFactory> p_receiver{};
      AudioService_BindStreamFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindStreamFactory(        
        std::move(p_receiver));
      return true;
    }
    case messages::AudioService::kBindDeviceNotifier: {
      DCHECK(message->is_serialized());
      internal::AudioService_BindDeviceNotifier_Params_Data* params =
          reinterpret_cast<internal::AudioService_BindDeviceNotifier_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioService.3
      bool success = true;
      ::mojo::PendingReceiver<::audio::mojom::DeviceNotifier> p_receiver{};
      AudioService_BindDeviceNotifier_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDeviceNotifier(        
        std::move(p_receiver));
      return true;
    }
    case messages::AudioService::kBindLogFactoryManager: {
      DCHECK(message->is_serialized());
      internal::AudioService_BindLogFactoryManager_Params_Data* params =
          reinterpret_cast<internal::AudioService_BindLogFactoryManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioService.4
      bool success = true;
      ::mojo::PendingReceiver<::audio::mojom::LogFactoryManager> p_receiver{};
      AudioService_BindLogFactoryManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindLogFactoryManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::AudioService::kBindTestingApi: {
      DCHECK(message->is_serialized());
      internal::AudioService_BindTestingApi_Params_Data* params =
          reinterpret_cast<internal::AudioService_BindTestingApi_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AudioService.5
      bool success = true;
      ::mojo::PendingReceiver<::audio::mojom::TestingApi> p_receiver{};
      AudioService_BindTestingApi_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AudioService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestingApi(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool AudioServiceStubDispatch::AcceptWithResponder(
    AudioService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AudioService>(message->header()->name)) {
    case messages::AudioService::kBindSystemInfo: {
      break;
    }
    case messages::AudioService::kBindDebugRecording: {
      break;
    }
    case messages::AudioService::kBindStreamFactory: {
      break;
    }
    case messages::AudioService::kBindDeviceNotifier: {
      break;
    }
    case messages::AudioService::kBindLogFactoryManager: {
      break;
    }
    case messages::AudioService::kBindTestingApi: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAudioServiceValidationInfo[] = {
    { &internal::AudioService_BindSystemInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioService_BindDebugRecording_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioService_BindStreamFactory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioService_BindDeviceNotifier_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioService_BindLogFactoryManager_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AudioService_BindTestingApi_Params_Data::Validate,
     nullptr /* no response */},
};

bool AudioServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::audio::mojom::AudioService::Name_,
    kAudioServiceValidationInfo);
}



}  // audio::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace audio::mojom {


void AudioServiceInterceptorForTesting::BindSystemInfo(::mojo::PendingReceiver<::audio::mojom::SystemInfo> receiver) {
  GetForwardingInterface()->BindSystemInfo(
    std::move(receiver)
    );
}
void AudioServiceInterceptorForTesting::BindDebugRecording(::mojo::PendingReceiver<::audio::mojom::DebugRecording> receiver) {
  GetForwardingInterface()->BindDebugRecording(
    std::move(receiver)
    );
}
void AudioServiceInterceptorForTesting::BindStreamFactory(::mojo::PendingReceiver<::media::mojom::AudioStreamFactory> receiver) {
  GetForwardingInterface()->BindStreamFactory(
    std::move(receiver)
    );
}
void AudioServiceInterceptorForTesting::BindDeviceNotifier(::mojo::PendingReceiver<::audio::mojom::DeviceNotifier> receiver) {
  GetForwardingInterface()->BindDeviceNotifier(
    std::move(receiver)
    );
}
void AudioServiceInterceptorForTesting::BindLogFactoryManager(::mojo::PendingReceiver<::audio::mojom::LogFactoryManager> receiver) {
  GetForwardingInterface()->BindLogFactoryManager(
    std::move(receiver)
    );
}
void AudioServiceInterceptorForTesting::BindTestingApi(::mojo::PendingReceiver<::audio::mojom::TestingApi> receiver) {
  GetForwardingInterface()->BindTestingApi(
    std::move(receiver)
    );
}
AudioServiceAsyncWaiter::AudioServiceAsyncWaiter(
    AudioService* proxy) : proxy_(proxy) {}

AudioServiceAsyncWaiter::~AudioServiceAsyncWaiter() = default;







}  // audio::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif