// owl/mojom/web_view_session_data.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/web_view_session_data.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_view_session_data.mojom-params-data.h"
#include "owl/mojom/web_view_session_data.mojom-shared-message-ids.h"

#include "owl/mojom/web_view_session_data.mojom-import-headers.h"
#include "owl/mojom/web_view_session_data.mojom-test-utils.h"


namespace owl::mojom {
WebViewSessionData::WebViewSessionData()
    : navigations(),
      selected_navigation() {}

WebViewSessionData::WebViewSessionData(
    std::vector<std::vector<uint8_t>> navigations_in,
    int32_t selected_navigation_in)
    : navigations(std::move(navigations_in)),
      selected_navigation(std::move(selected_navigation_in)) {}

WebViewSessionData::~WebViewSessionData() = default;

void WebViewSessionData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigations"), this->navigations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_navigation"), this->selected_navigation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebViewSessionData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebViewSessionDataDecoder::IPCStableHashFunction WebViewSessionDataDecoder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebViewSessionDataDecoder>(message.name())) {
    case messages::WebViewSessionDataDecoder::kDecode: {
      return &WebViewSessionDataDecoder::Decode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebViewSessionDataDecoder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebViewSessionDataDecoder>(message.name())) {
      case messages::WebViewSessionDataDecoder::kDecode:
            return "Receive owl::mojom::WebViewSessionDataDecoder::Decode";
    }
  } else {
    switch (static_cast<messages::WebViewSessionDataDecoder>(message.name())) {
      case messages::WebViewSessionDataDecoder::kDecode:
            return "Receive reply owl::mojom::WebViewSessionDataDecoder::Decode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebViewSessionDataDecoder::Decode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf507305c;  // IPCStableHash for owl::mojom::WebViewSessionDataDecoder::Decode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebViewSessionDataDecoder_Decode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewSessionDataDecoder_Decode_ForwardToCallback(
      WebViewSessionDataDecoder::DecodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewSessionDataDecoder_Decode_ForwardToCallback(const WebViewSessionDataDecoder_Decode_ForwardToCallback&) = delete;
  WebViewSessionDataDecoder_Decode_ForwardToCallback& operator=(const WebViewSessionDataDecoder_Decode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewSessionDataDecoder::DecodeCallback callback_;
};

WebViewSessionDataDecoderProxy::WebViewSessionDataDecoderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebViewSessionDataDecoderProxy::Decode(
    const std::vector<uint8_t>& in_session_data, DecodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewSessionDataDecoder::Decode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_data"), in_session_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewSessionDataDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewSessionDataDecoder_Decode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_data)::BaseType>
      session_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& session_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_session_data,
    session_data_fragment,
    &session_data_validate_params);

  params->session_data.Set(
      session_data_fragment.is_null() ? nullptr : session_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_data in WebViewSessionDataDecoder.Decode request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewSessionDataDecoder::Name_);
  message.set_method_name("Decode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewSessionDataDecoder_Decode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebViewSessionDataDecoder_Decode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewSessionDataDecoder::DecodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewSessionDataDecoder_Decode_ProxyToResponder> proxy(
        new WebViewSessionDataDecoder_Decode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewSessionDataDecoder_Decode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewSessionDataDecoder_Decode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewSessionDataDecoder_Decode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewSessionDataDecoder::DecodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::owl::mojom::NavigationEntryPtr> in_entries, int32_t in_selected_index);
};

bool WebViewSessionDataDecoder_Decode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewSessionDataDecoder_Decode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewSessionDataDecoder_Decode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewSessionDataDecoder.0
  bool success = true;
  std::vector<::owl::mojom::NavigationEntryPtr> p_entries{};
  int32_t p_selected_index{};
  WebViewSessionDataDecoder_Decode_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (success)
    p_selected_index = input_data_view.selected_index();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewSessionDataDecoder::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entries), 
std::move(p_selected_index));
  }
  return true;
}

void WebViewSessionDataDecoder_Decode_ProxyToResponder::Run(
    std::vector<::owl::mojom::NavigationEntryPtr> in_entries, int32_t in_selected_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewSessionDataDecoder::Decode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<::owl::mojom::NavigationEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_index"), in_selected_index,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewSessionDataDecoder::kDecode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewSessionDataDecoder_Decode_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::NavigationEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

  params->selected_index = in_selected_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewSessionDataDecoder::Name_);
  message.set_method_name("Decode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebViewSessionDataDecoderStubDispatch::Accept(
    WebViewSessionDataDecoder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebViewSessionDataDecoder>(message->header()->name)) {
    case messages::WebViewSessionDataDecoder::kDecode: {
      break;
    }
  }
  return false;
}

// static
bool WebViewSessionDataDecoderStubDispatch::AcceptWithResponder(
    WebViewSessionDataDecoder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebViewSessionDataDecoder>(message->header()->name)) {
    case messages::WebViewSessionDataDecoder::kDecode: {
      internal::WebViewSessionDataDecoder_Decode_Params_Data* params =
          reinterpret_cast<
              internal::WebViewSessionDataDecoder_Decode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewSessionDataDecoder.0
      bool success = true;
      std::vector<uint8_t> p_session_data{};
      WebViewSessionDataDecoder_Decode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionData(&p_session_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewSessionDataDecoder::Name_, 0, false);
        return false;
      }
      auto callback =
          WebViewSessionDataDecoder_Decode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Decode(        
        std::move(p_session_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebViewSessionDataDecoderValidationInfo[] = {
    { &internal::WebViewSessionDataDecoder_Decode_Params_Data::Validate,
     &internal::WebViewSessionDataDecoder_Decode_ResponseParams_Data::Validate},
};

bool WebViewSessionDataDecoderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebViewSessionDataDecoder::Name_,
    kWebViewSessionDataDecoderValidationInfo);
}

bool WebViewSessionDataDecoderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebViewSessionDataDecoder::Name_,
    kWebViewSessionDataDecoderValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::WebViewSessionData::DataView, ::owl::mojom::WebViewSessionDataPtr>::Read(
    ::owl::mojom::WebViewSessionData::DataView input,
    ::owl::mojom::WebViewSessionDataPtr* output) {
  bool success = true;
  ::owl::mojom::WebViewSessionDataPtr result(::owl::mojom::WebViewSessionData::New());
  
      if (success && !input.ReadNavigations(&result->navigations))
        success = false;
      if (success)
        result->selected_navigation = input.selected_navigation();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void WebViewSessionDataDecoderInterceptorForTesting::Decode(const std::vector<uint8_t>& session_data, DecodeCallback callback) {
  GetForwardingInterface()->Decode(
    std::move(session_data)
    , std::move(callback));
}
WebViewSessionDataDecoderAsyncWaiter::WebViewSessionDataDecoderAsyncWaiter(
    WebViewSessionDataDecoder* proxy) : proxy_(proxy) {}

WebViewSessionDataDecoderAsyncWaiter::~WebViewSessionDataDecoderAsyncWaiter() = default;


void WebViewSessionDataDecoderAsyncWaiter::Decode(
    const std::vector<uint8_t>& session_data, std::vector<::owl::mojom::NavigationEntryPtr>* out_entries, int32_t* out_selected_index) {
  base::RunLoop loop;
  proxy_->Decode(
      std::move(session_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::owl::mojom::NavigationEntryPtr>* out_entries
,
             int32_t* out_selected_index
,
             std::vector<::owl::mojom::NavigationEntryPtr> entries,
             int32_t selected_index) {*out_entries = std::move(entries);*out_selected_index = std::move(selected_index);
            loop->Quit();
          },
          &loop,
          out_entries,
          out_selected_index));
  loop.Run();
}








}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif