// owl/mojom/web_view_group.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/web_view_group.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_view_group.mojom-params-data.h"
#include "owl/mojom/web_view_group.mojom-shared-message-ids.h"

#include "owl/mojom/web_view_group.mojom-import-headers.h"
#include "owl/mojom/web_view_group.mojom-test-utils.h"


namespace owl::mojom {
CreateWebViewInitializationData_InitialData::CreateWebViewInitializationData_InitialData()
    : url(),
      navigation_type(),
      additional_headers() {}

CreateWebViewInitializationData_InitialData::CreateWebViewInitializationData_InitialData(
    const ::GURL& url_in,
    ::owl::mojom::NavigationType navigation_type_in,
    const std::string& additional_headers_in)
    : url(std::move(url_in)),
      navigation_type(std::move(navigation_type_in)),
      additional_headers(std::move(additional_headers_in)) {}

CreateWebViewInitializationData_InitialData::~CreateWebViewInitializationData_InitialData() = default;

void CreateWebViewInitializationData_InitialData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_type"), this->navigation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::owl::mojom::NavigationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_headers"), this->additional_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateWebViewInitializationData_InitialData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateWebViewInitializationData_RestoreData::CreateWebViewInitializationData_RestoreData()
    : session_data(),
      navigation_index_override() {}

CreateWebViewInitializationData_RestoreData::CreateWebViewInitializationData_RestoreData(
    std::vector<uint8_t> session_data_in,
    std::optional<int32_t> navigation_index_override_in)
    : session_data(std::move(session_data_in)),
      navigation_index_override(std::move(navigation_index_override_in)) {}

CreateWebViewInitializationData_RestoreData::~CreateWebViewInitializationData_RestoreData() = default;

void CreateWebViewInitializationData_RestoreData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_data"), this->session_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_index_override"), this->navigation_index_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateWebViewInitializationData_RestoreData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateWebViewParams::CreateWebViewParams()
    : foreground(),
      initialization_data(),
      initial_storage_partition() {}

CreateWebViewParams::CreateWebViewParams(
    bool foreground_in,
    CreateWebViewInitializationDataPtr initialization_data_in,
    ::owl::mojom::StoragePartitionDescriptorPtr initial_storage_partition_in)
    : foreground(std::move(foreground_in)),
      initialization_data(std::move(initialization_data_in)),
      initial_storage_partition(std::move(initial_storage_partition_in)) {}

CreateWebViewParams::~CreateWebViewParams() = default;

void CreateWebViewParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "foreground"), this->foreground,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initialization_data"), this->initialization_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CreateWebViewInitializationDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_storage_partition"), this->initial_storage_partition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::owl::mojom::StoragePartitionDescriptorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateWebViewParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreatedWebViewDetails::CreatedWebViewDetails()
    : web_content_id() {}

CreatedWebViewDetails::CreatedWebViewDetails(
    uint64_t web_content_id_in)
    : web_content_id(std::move(web_content_id_in)) {}

CreatedWebViewDetails::~CreatedWebViewDetails() = default;
size_t CreatedWebViewDetails::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->web_content_id);
  return seed;
}

void CreatedWebViewDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_content_id"), this->web_content_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreatedWebViewDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateWebViewInitializationDataPtr
CreateWebViewInitializationData::NewInitialData(
    CreateWebViewInitializationData_InitialDataPtr value) {
  return CreateWebViewInitializationDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kInitialData)>,
      std::move(value));
}

CreateWebViewInitializationDataPtr
CreateWebViewInitializationData::NewRestoreData(
    CreateWebViewInitializationData_RestoreDataPtr value) {
  return CreateWebViewInitializationDataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRestoreData)>,
      std::move(value));
}

CreateWebViewInitializationData::CreateWebViewInitializationData(
    std::in_place_index_t<static_cast<size_t>(Tag::kInitialData)>,
    CreateWebViewInitializationData_InitialDataPtr value)
    : tag_(Tag::kInitialData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kInitialData)>,
            std::move(value)) {}

CreateWebViewInitializationData::CreateWebViewInitializationData(
    std::in_place_index_t<static_cast<size_t>(Tag::kRestoreData)>,
    CreateWebViewInitializationData_RestoreDataPtr value)
    : tag_(Tag::kRestoreData),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRestoreData)>,
            std::move(value)) {}
CreateWebViewInitializationData::~CreateWebViewInitializationData() {
  DestroyActive();
}

void CreateWebViewInitializationData::set_initial_data(CreateWebViewInitializationData_InitialDataPtr initial_data) {
  if (tag_ == Tag::kInitialData) {
    data_.initial_data = std::move(initial_data);
  } else {
    DestroyActive();
    tag_ = Tag::kInitialData;
    new (&data_.initial_data) CreateWebViewInitializationData_InitialDataPtr(
        std::move(initial_data));
  }
}

void CreateWebViewInitializationData::set_restore_data(CreateWebViewInitializationData_RestoreDataPtr restore_data) {
  if (tag_ == Tag::kRestoreData) {
    data_.restore_data = std::move(restore_data);
  } else {
    DestroyActive();
    tag_ = Tag::kRestoreData;
    new (&data_.restore_data) CreateWebViewInitializationData_RestoreDataPtr(
        std::move(restore_data));
  }
}


CreateWebViewInitializationData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kInitialData)>,
    CreateWebViewInitializationData_InitialDataPtr value)
    : initial_data(std::move(value)) {}

CreateWebViewInitializationData::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRestoreData)>,
    CreateWebViewInitializationData_RestoreDataPtr value)
    : restore_data(std::move(value)) {}

void CreateWebViewInitializationData::DestroyActive() {
  switch (tag_) {

    case Tag::kInitialData:
      std::destroy_at(&data_.initial_data);
      break;
    case Tag::kRestoreData:
      std::destroy_at(&data_.restore_data);
      break;
  }
}

bool CreateWebViewInitializationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CreateWebViewResultPtr
CreateWebViewResult::NewFailure(
    const std::string& value) {
  return CreateWebViewResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

CreateWebViewResultPtr
CreateWebViewResult::NewSuccess(
    CreatedWebViewDetailsPtr value) {
  return CreateWebViewResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CreateWebViewResult::CreateWebViewResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    const std::string& value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}

CreateWebViewResult::CreateWebViewResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreatedWebViewDetailsPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}
CreateWebViewResult::~CreateWebViewResult() {
  DestroyActive();
}

void CreateWebViewResult::set_failure(const std::string& failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) std::string(
        std::move(failure));
  }
}

void CreateWebViewResult::set_success(CreatedWebViewDetailsPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) CreatedWebViewDetailsPtr(
        std::move(success));
  }
}


CreateWebViewResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    const std::string& value)
    : failure(std::move(value)) {}

CreateWebViewResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreatedWebViewDetailsPtr value)
    : success(std::move(value)) {}

void CreateWebViewResult::DestroyActive() {
  switch (tag_) {

    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
  }
}
size_t CreateWebViewResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kFailure:
      return mojo::internal::Hash(seed, data_.failure);
    case Tag::kSuccess:
      return mojo::internal::Hash(seed, data_.success);
    default:
      NOTREACHED();
  }
}

bool CreateWebViewResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebViewGroup::IPCStableHashFunction WebViewGroup::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebViewGroup>(message.name())) {
    case messages::WebViewGroup::kCreateWebView: {
      return &WebViewGroup::CreateWebView_Sym::IPCStableHash;
    }
    case messages::WebViewGroup::kTabStripDidBecomeActive: {
      return &WebViewGroup::TabStripDidBecomeActive_Sym::IPCStableHash;
    }
    case messages::WebViewGroup::kEnableNavigationValidation: {
      return &WebViewGroup::EnableNavigationValidation_Sym::IPCStableHash;
    }
    case messages::WebViewGroup::kEnableAgentModeRestrictions: {
      return &WebViewGroup::EnableAgentModeRestrictions_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebViewGroup::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebViewGroup>(message.name())) {
      case messages::WebViewGroup::kCreateWebView:
            return "Receive owl::mojom::WebViewGroup::CreateWebView";
      case messages::WebViewGroup::kTabStripDidBecomeActive:
            return "Receive owl::mojom::WebViewGroup::TabStripDidBecomeActive";
      case messages::WebViewGroup::kEnableNavigationValidation:
            return "Receive owl::mojom::WebViewGroup::EnableNavigationValidation";
      case messages::WebViewGroup::kEnableAgentModeRestrictions:
            return "Receive owl::mojom::WebViewGroup::EnableAgentModeRestrictions";
    }
  } else {
    switch (static_cast<messages::WebViewGroup>(message.name())) {
      case messages::WebViewGroup::kCreateWebView:
            return "Receive reply owl::mojom::WebViewGroup::CreateWebView";
      case messages::WebViewGroup::kTabStripDidBecomeActive:
            return "Receive reply owl::mojom::WebViewGroup::TabStripDidBecomeActive";
      case messages::WebViewGroup::kEnableNavigationValidation:
            return "Receive reply owl::mojom::WebViewGroup::EnableNavigationValidation";
      case messages::WebViewGroup::kEnableAgentModeRestrictions:
            return "Receive reply owl::mojom::WebViewGroup::EnableAgentModeRestrictions";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebViewGroup::CreateWebView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x376327d1;  // IPCStableHash for owl::mojom::WebViewGroup::CreateWebView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewGroup::TabStripDidBecomeActive_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe01670c4;  // IPCStableHash for owl::mojom::WebViewGroup::TabStripDidBecomeActive
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewGroup::EnableNavigationValidation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc46d0d0f;  // IPCStableHash for owl::mojom::WebViewGroup::EnableNavigationValidation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewGroup::EnableAgentModeRestrictions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b3d1cde;  // IPCStableHash for owl::mojom::WebViewGroup::EnableAgentModeRestrictions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebViewGroup_CreateWebView_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewGroup_CreateWebView_ForwardToCallback(
      WebViewGroup::CreateWebViewCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewGroup_CreateWebView_ForwardToCallback(const WebViewGroup_CreateWebView_ForwardToCallback&) = delete;
  WebViewGroup_CreateWebView_ForwardToCallback& operator=(const WebViewGroup_CreateWebView_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewGroup::CreateWebViewCallback callback_;
};

WebViewGroupProxy::WebViewGroupProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebViewGroupProxy::CreateWebView(
    CreateWebViewParamsPtr in_params, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> in_receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> in_client, CreateWebViewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewGroup::CreateWebView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type CreateWebViewParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroup::kCreateWebView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroup_CreateWebView_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CreateWebViewParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebViewGroup.CreateWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in WebViewGroup.CreateWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebViewGroup.CreateWebView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroup::Name_);
  message.set_method_name("CreateWebView");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewGroup_CreateWebView_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewGroupProxy::TabStripDidBecomeActive(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewGroup::TabStripDidBecomeActive");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroup::kTabStripDidBecomeActive), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroup_TabStripDidBecomeActive_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroup::Name_);
  message.set_method_name("TabStripDidBecomeActive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewGroupProxy::EnableNavigationValidation(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewGroup::EnableNavigationValidation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroup::kEnableNavigationValidation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroup_EnableNavigationValidation_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroup::Name_);
  message.set_method_name("EnableNavigationValidation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewGroupProxy::EnableAgentModeRestrictions(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewGroup::EnableAgentModeRestrictions");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroup::kEnableAgentModeRestrictions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroup_EnableAgentModeRestrictions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroup::Name_);
  message.set_method_name("EnableAgentModeRestrictions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebViewGroup_CreateWebView_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewGroup::CreateWebViewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewGroup_CreateWebView_ProxyToResponder> proxy(
        new WebViewGroup_CreateWebView_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewGroup_CreateWebView_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewGroup_CreateWebView_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewGroup_CreateWebView_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewGroup::CreateWebViewCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateWebViewResultPtr in_result);
};

bool WebViewGroup_CreateWebView_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewGroup_CreateWebView_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewGroup_CreateWebView_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewGroup.0
  bool success = true;
  CreateWebViewResultPtr p_result{};
  WebViewGroup_CreateWebView_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewGroup::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebViewGroup_CreateWebView_ProxyToResponder::Run(
    CreateWebViewResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewGroup::CreateWebView", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateWebViewResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroup::kCreateWebView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroup_CreateWebView_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::owl::mojom::CreateWebViewResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroup::Name_);
  message.set_method_name("CreateWebView");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebViewGroupStubDispatch::Accept(
    WebViewGroup* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebViewGroup>(message->header()->name)) {
    case messages::WebViewGroup::kCreateWebView: {
      break;
    }
    case messages::WebViewGroup::kTabStripDidBecomeActive: {
      DCHECK(message->is_serialized());
      internal::WebViewGroup_TabStripDidBecomeActive_Params_Data* params =
          reinterpret_cast<internal::WebViewGroup_TabStripDidBecomeActive_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewGroup.1
      bool success = true;
      WebViewGroup_TabStripDidBecomeActive_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroup::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabStripDidBecomeActive(        );
      return true;
    }
    case messages::WebViewGroup::kEnableNavigationValidation: {
      DCHECK(message->is_serialized());
      internal::WebViewGroup_EnableNavigationValidation_Params_Data* params =
          reinterpret_cast<internal::WebViewGroup_EnableNavigationValidation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewGroup.2
      bool success = true;
      bool p_enabled{};
      WebViewGroup_EnableNavigationValidation_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroup::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableNavigationValidation(        
        std::move(p_enabled));
      return true;
    }
    case messages::WebViewGroup::kEnableAgentModeRestrictions: {
      DCHECK(message->is_serialized());
      internal::WebViewGroup_EnableAgentModeRestrictions_Params_Data* params =
          reinterpret_cast<internal::WebViewGroup_EnableAgentModeRestrictions_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewGroup.3
      bool success = true;
      WebViewGroup_EnableAgentModeRestrictions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroup::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAgentModeRestrictions(        );
      return true;
    }
  }
  return false;
}

// static
bool WebViewGroupStubDispatch::AcceptWithResponder(
    WebViewGroup* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebViewGroup>(message->header()->name)) {
    case messages::WebViewGroup::kCreateWebView: {
      internal::WebViewGroup_CreateWebView_Params_Data* params =
          reinterpret_cast<
              internal::WebViewGroup_CreateWebView_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewGroup.0
      bool success = true;
      CreateWebViewParamsPtr p_params{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> p_receiver{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> p_client{};
      WebViewGroup_CreateWebView_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroup::Name_, 0, false);
        return false;
      }
      auto callback =
          WebViewGroup_CreateWebView_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebView(        
        std::move(p_params), 
        std::move(p_receiver), 
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::WebViewGroup::kTabStripDidBecomeActive: {
      break;
    }
    case messages::WebViewGroup::kEnableNavigationValidation: {
      break;
    }
    case messages::WebViewGroup::kEnableAgentModeRestrictions: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebViewGroupValidationInfo[] = {
    { &internal::WebViewGroup_CreateWebView_Params_Data::Validate,
     &internal::WebViewGroup_CreateWebView_ResponseParams_Data::Validate},
    { &internal::WebViewGroup_TabStripDidBecomeActive_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewGroup_EnableNavigationValidation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewGroup_EnableAgentModeRestrictions_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebViewGroupRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebViewGroup::Name_,
    kWebViewGroupValidationInfo);
}

bool WebViewGroupResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebViewGroup::Name_,
    kWebViewGroupValidationInfo);
}
// The declaration includes the definition on other builds.

WebViewGroupClient::IPCStableHashFunction WebViewGroupClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebViewGroupClient>(message.name())) {
    case messages::WebViewGroupClient::kOpenChromeURL: {
      return &WebViewGroupClient::OpenChromeURL_Sym::IPCStableHash;
    }
    case messages::WebViewGroupClient::kCreatedNewWebView: {
      return &WebViewGroupClient::CreatedNewWebView_Sym::IPCStableHash;
    }
    case messages::WebViewGroupClient::kValidateNavigation: {
      return &WebViewGroupClient::ValidateNavigation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebViewGroupClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebViewGroupClient>(message.name())) {
      case messages::WebViewGroupClient::kOpenChromeURL:
            return "Receive owl::mojom::WebViewGroupClient::OpenChromeURL";
      case messages::WebViewGroupClient::kCreatedNewWebView:
            return "Receive owl::mojom::WebViewGroupClient::CreatedNewWebView";
      case messages::WebViewGroupClient::kValidateNavigation:
            return "Receive owl::mojom::WebViewGroupClient::ValidateNavigation";
    }
  } else {
    switch (static_cast<messages::WebViewGroupClient>(message.name())) {
      case messages::WebViewGroupClient::kOpenChromeURL:
            return "Receive reply owl::mojom::WebViewGroupClient::OpenChromeURL";
      case messages::WebViewGroupClient::kCreatedNewWebView:
            return "Receive reply owl::mojom::WebViewGroupClient::CreatedNewWebView";
      case messages::WebViewGroupClient::kValidateNavigation:
            return "Receive reply owl::mojom::WebViewGroupClient::ValidateNavigation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebViewGroupClient::OpenChromeURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24c9cb43;  // IPCStableHash for owl::mojom::WebViewGroupClient::OpenChromeURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewGroupClient::CreatedNewWebView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0776a00b;  // IPCStableHash for owl::mojom::WebViewGroupClient::CreatedNewWebView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewGroupClient::ValidateNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdb2a6c2a;  // IPCStableHash for owl::mojom::WebViewGroupClient::ValidateNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebViewGroupClient_ValidateNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewGroupClient_ValidateNavigation_ForwardToCallback(
      WebViewGroupClient::ValidateNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewGroupClient_ValidateNavigation_ForwardToCallback(const WebViewGroupClient_ValidateNavigation_ForwardToCallback&) = delete;
  WebViewGroupClient_ValidateNavigation_ForwardToCallback& operator=(const WebViewGroupClient_ValidateNavigation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewGroupClient::ValidateNavigationCallback callback_;
};

WebViewGroupClientProxy::WebViewGroupClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebViewGroupClientProxy::OpenChromeURL(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewGroupClient::OpenChromeURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroupClient::kOpenChromeURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroupClient_OpenChromeURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebViewGroupClient.OpenChromeURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroupClient::Name_);
  message.set_method_name("OpenChromeURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewGroupClientProxy::CreatedNewWebView(
    uint64_t in_web_content_id, GroupScopedWebViewSource in_source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> in_web_view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> in_web_view_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewGroupClient::CreatedNewWebView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_content_id"), in_web_content_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type GroupScopedWebViewSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_view"), in_web_view,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::WebView>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_view_client"), in_web_view_client,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroupClient::kCreatedNewWebView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroupClient_CreatedNewWebView_Params_Data> params(
          message);
  params.Allocate();

  params->web_content_id = in_web_content_id;

  
  mojo::internal::Serialize<::owl::mojom::GroupScopedWebViewSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::owl::mojom::WebViewAssociatedPtrInfoDataView>(
    in_web_view,
    &params->web_view,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->web_view)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid web_view in WebViewGroupClient.CreatedNewWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewClientAssociatedRequestDataView>(
    in_web_view_client,
    &params->web_view_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->web_view_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid web_view_client in WebViewGroupClient.CreatedNewWebView request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroupClient::Name_);
  message.set_method_name("CreatedNewWebView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewGroupClientProxy::ValidateNavigation(
    const ::GURL& in_url, ValidateNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewGroupClient::ValidateNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroupClient::kValidateNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroupClient_ValidateNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebViewGroupClient.ValidateNavigation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroupClient::Name_);
  message.set_method_name("ValidateNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewGroupClient_ValidateNavigation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebViewGroupClient_ValidateNavigation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewGroupClient::ValidateNavigationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewGroupClient_ValidateNavigation_ProxyToResponder> proxy(
        new WebViewGroupClient_ValidateNavigation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewGroupClient_ValidateNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewGroupClient_ValidateNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewGroupClient_ValidateNavigation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewGroupClient::ValidateNavigationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      NavigationValidationResult in_result);
};

bool WebViewGroupClient_ValidateNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewGroupClient_ValidateNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewGroupClient_ValidateNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewGroupClient.2
  bool success = true;
  NavigationValidationResult p_result{};
  WebViewGroupClient_ValidateNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewGroupClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebViewGroupClient_ValidateNavigation_ProxyToResponder::Run(
    NavigationValidationResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewGroupClient::ValidateNavigation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type NavigationValidationResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewGroupClient::kValidateNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewGroupClient_ValidateNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::NavigationValidationResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewGroupClient::Name_);
  message.set_method_name("ValidateNavigation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebViewGroupClientStubDispatch::Accept(
    WebViewGroupClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebViewGroupClient>(message->header()->name)) {
    case messages::WebViewGroupClient::kOpenChromeURL: {
      DCHECK(message->is_serialized());
      internal::WebViewGroupClient_OpenChromeURL_Params_Data* params =
          reinterpret_cast<internal::WebViewGroupClient_OpenChromeURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewGroupClient.0
      bool success = true;
      ::GURL p_url{};
      WebViewGroupClient_OpenChromeURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroupClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenChromeURL(        
        std::move(p_url));
      return true;
    }
    case messages::WebViewGroupClient::kCreatedNewWebView: {
      DCHECK(message->is_serialized());
      internal::WebViewGroupClient_CreatedNewWebView_Params_Data* params =
          reinterpret_cast<internal::WebViewGroupClient_CreatedNewWebView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewGroupClient.1
      bool success = true;
      uint64_t p_web_content_id{};
      GroupScopedWebViewSource p_source{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> p_web_view{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> p_web_view_client{};
      WebViewGroupClient_CreatedNewWebView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_web_content_id = input_data_view.web_content_id();
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_web_view =
            input_data_view.TakeWebView<decltype(p_web_view)>();
      }
      if (success) {
        p_web_view_client =
            input_data_view.TakeWebViewClient<decltype(p_web_view_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroupClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatedNewWebView(        
        std::move(p_web_content_id), 
        std::move(p_source), 
        std::move(p_web_view), 
        std::move(p_web_view_client));
      return true;
    }
    case messages::WebViewGroupClient::kValidateNavigation: {
      break;
    }
  }
  return false;
}

// static
bool WebViewGroupClientStubDispatch::AcceptWithResponder(
    WebViewGroupClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebViewGroupClient>(message->header()->name)) {
    case messages::WebViewGroupClient::kOpenChromeURL: {
      break;
    }
    case messages::WebViewGroupClient::kCreatedNewWebView: {
      break;
    }
    case messages::WebViewGroupClient::kValidateNavigation: {
      internal::WebViewGroupClient_ValidateNavigation_Params_Data* params =
          reinterpret_cast<
              internal::WebViewGroupClient_ValidateNavigation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewGroupClient.2
      bool success = true;
      ::GURL p_url{};
      WebViewGroupClient_ValidateNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewGroupClient::Name_, 2, false);
        return false;
      }
      auto callback =
          WebViewGroupClient_ValidateNavigation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ValidateNavigation(        
        std::move(p_url), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebViewGroupClientValidationInfo[] = {
    { &internal::WebViewGroupClient_OpenChromeURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewGroupClient_CreatedNewWebView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewGroupClient_ValidateNavigation_Params_Data::Validate,
     &internal::WebViewGroupClient_ValidateNavigation_ResponseParams_Data::Validate},
};

bool WebViewGroupClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebViewGroupClient::Name_,
    kWebViewGroupClientValidationInfo);
}

bool WebViewGroupClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebViewGroupClient::Name_,
    kWebViewGroupClientValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::CreateWebViewInitializationData_InitialData::DataView, ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr>::Read(
    ::owl::mojom::CreateWebViewInitializationData_InitialData::DataView input,
    ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr* output) {
  bool success = true;
  ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr result(::owl::mojom::CreateWebViewInitializationData_InitialData::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadNavigationType(&result->navigation_type))
        success = false;
      if (success && !input.ReadAdditionalHeaders(&result->additional_headers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CreateWebViewInitializationData_RestoreData::DataView, ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr>::Read(
    ::owl::mojom::CreateWebViewInitializationData_RestoreData::DataView input,
    ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr* output) {
  bool success = true;
  ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr result(::owl::mojom::CreateWebViewInitializationData_RestoreData::New());
  
      if (success && !input.ReadSessionData(&result->session_data))
        success = false;
      if (success) {
        result->navigation_index_override = input.navigation_index_override();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CreateWebViewParams::DataView, ::owl::mojom::CreateWebViewParamsPtr>::Read(
    ::owl::mojom::CreateWebViewParams::DataView input,
    ::owl::mojom::CreateWebViewParamsPtr* output) {
  bool success = true;
  ::owl::mojom::CreateWebViewParamsPtr result(::owl::mojom::CreateWebViewParams::New());
  
      if (success)
        result->foreground = input.foreground();
      if (success && !input.ReadInitializationData(&result->initialization_data))
        success = false;
      if (success && !input.ReadInitialStoragePartition(&result->initial_storage_partition))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CreatedWebViewDetails::DataView, ::owl::mojom::CreatedWebViewDetailsPtr>::Read(
    ::owl::mojom::CreatedWebViewDetails::DataView input,
    ::owl::mojom::CreatedWebViewDetailsPtr* output) {
  bool success = true;
  ::owl::mojom::CreatedWebViewDetailsPtr result(::owl::mojom::CreatedWebViewDetails::New());
  
      if (success)
        result->web_content_id = input.web_content_id();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::owl::mojom::CreateWebViewInitializationData::DataView, ::owl::mojom::CreateWebViewInitializationDataPtr>::Read(
    ::owl::mojom::CreateWebViewInitializationData::DataView input,
    ::owl::mojom::CreateWebViewInitializationDataPtr* output) {
  using UnionType = ::owl::mojom::CreateWebViewInitializationData;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kInitialData: {
      ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr result_initial_data{};
      if (!input.ReadInitialData(&result_initial_data))
        return false;

      *output = UnionType::NewInitialData(
          std::move(result_initial_data));
      break;
    }
    case Tag::kRestoreData: {
      ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr result_restore_data{};
      if (!input.ReadRestoreData(&result_restore_data))
        return false;

      *output = UnionType::NewRestoreData(
          std::move(result_restore_data));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::owl::mojom::CreateWebViewResult::DataView, ::owl::mojom::CreateWebViewResultPtr>::Read(
    ::owl::mojom::CreateWebViewResult::DataView input,
    ::owl::mojom::CreateWebViewResultPtr* output) {
  using UnionType = ::owl::mojom::CreateWebViewResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFailure: {
      std::string result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    case Tag::kSuccess: {
      ::owl::mojom::CreatedWebViewDetailsPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void WebViewGroupInterceptorForTesting::CreateWebView(CreateWebViewParamsPtr params, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> client, CreateWebViewCallback callback) {
  GetForwardingInterface()->CreateWebView(
    std::move(params)
    , 
    std::move(receiver)
    , 
    std::move(client)
    , std::move(callback));
}
void WebViewGroupInterceptorForTesting::TabStripDidBecomeActive() {
  GetForwardingInterface()->TabStripDidBecomeActive();
}
void WebViewGroupInterceptorForTesting::EnableNavigationValidation(bool enabled) {
  GetForwardingInterface()->EnableNavigationValidation(
    std::move(enabled)
    );
}
void WebViewGroupInterceptorForTesting::EnableAgentModeRestrictions() {
  GetForwardingInterface()->EnableAgentModeRestrictions();
}
WebViewGroupAsyncWaiter::WebViewGroupAsyncWaiter(
    WebViewGroup* proxy) : proxy_(proxy) {}

WebViewGroupAsyncWaiter::~WebViewGroupAsyncWaiter() = default;


void WebViewGroupAsyncWaiter::CreateWebView(
    CreateWebViewParamsPtr params, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> client, CreateWebViewResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CreateWebView(
      std::move(params),
      std::move(receiver),
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateWebViewResultPtr* out_result
,
             CreateWebViewResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateWebViewResultPtr WebViewGroupAsyncWaiter::CreateWebView(
    CreateWebViewParamsPtr params, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> client) {
  CreateWebViewResultPtr async_wait_result;
  CreateWebView(std::move(params),std::move(receiver),std::move(client),&async_wait_result);
  return async_wait_result;
}




void WebViewGroupClientInterceptorForTesting::OpenChromeURL(const ::GURL& url) {
  GetForwardingInterface()->OpenChromeURL(
    std::move(url)
    );
}
void WebViewGroupClientInterceptorForTesting::CreatedNewWebView(uint64_t web_content_id, GroupScopedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> web_view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> web_view_client) {
  GetForwardingInterface()->CreatedNewWebView(
    std::move(web_content_id)
    , 
    std::move(source)
    , 
    std::move(web_view)
    , 
    std::move(web_view_client)
    );
}
void WebViewGroupClientInterceptorForTesting::ValidateNavigation(const ::GURL& url, ValidateNavigationCallback callback) {
  GetForwardingInterface()->ValidateNavigation(
    std::move(url)
    , std::move(callback));
}
WebViewGroupClientAsyncWaiter::WebViewGroupClientAsyncWaiter(
    WebViewGroupClient* proxy) : proxy_(proxy) {}

WebViewGroupClientAsyncWaiter::~WebViewGroupClientAsyncWaiter() = default;


void WebViewGroupClientAsyncWaiter::ValidateNavigation(
    const ::GURL& url, NavigationValidationResult* out_result) {
  base::RunLoop loop;
  proxy_->ValidateNavigation(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             NavigationValidationResult* out_result
,
             NavigationValidationResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

NavigationValidationResult WebViewGroupClientAsyncWaiter::ValidateNavigation(
    const ::GURL& url) {
  NavigationValidationResult async_wait_result;
  ValidateNavigation(std::move(url),&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif