// owl/mojom/web_view.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/web_view.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_view.mojom-params-data.h"
#include "owl/mojom/web_view.mojom-shared-message-ids.h"

#include "owl/mojom/web_view.mojom-import-headers.h"
#include "owl/mojom/web_view.mojom-test-utils.h"


namespace owl::mojom {
FindResult::FindResult()
    : current_match_index(),
      number_of_matches() {}

FindResult::FindResult(
    int32_t current_match_index_in,
    int32_t number_of_matches_in)
    : current_match_index(std::move(current_match_index_in)),
      number_of_matches(std::move(number_of_matches_in)) {}

FindResult::~FindResult() = default;
size_t FindResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->current_match_index);
  seed = mojo::internal::Hash(seed, this->number_of_matches);
  return seed;
}

void FindResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_match_index"), this->current_match_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_matches"), this->number_of_matches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FindResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DOMElementReference::DOMElementReference()
    : frame_routing_id(),
      frame_process_id(),
      x(),
      y() {}

DOMElementReference::DOMElementReference(
    int32_t frame_routing_id_in,
    int32_t frame_process_id_in,
    int32_t x_in,
    int32_t y_in)
    : frame_routing_id(std::move(frame_routing_id_in)),
      frame_process_id(std::move(frame_process_id_in)),
      x(std::move(x_in)),
      y(std::move(y_in)) {}

DOMElementReference::~DOMElementReference() = default;
size_t DOMElementReference::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->frame_routing_id);
  seed = mojo::internal::Hash(seed, this->frame_process_id);
  seed = mojo::internal::Hash(seed, this->x);
  seed = mojo::internal::Hash(seed, this->y);
  return seed;
}

void DOMElementReference::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_routing_id"), this->frame_routing_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_process_id"), this->frame_process_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DOMElementReference::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationEntry::NavigationEntry()
    : unique_id(),
      title(),
      url(),
      favicon_url() {}

NavigationEntry::NavigationEntry(
    int32_t unique_id_in,
    const ::std::u16string& title_in,
    const ::GURL& url_in,
    const std::optional<::GURL>& favicon_url_in)
    : unique_id(std::move(unique_id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      favicon_url(std::move(favicon_url_in)) {}

NavigationEntry::~NavigationEntry() = default;

void NavigationEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unique_id"), this->unique_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NavigationEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SerializedDomElementInfo::SerializedDomElementInfo()
    : tag(),
      selector(),
      visible_bounds(),
      click_point() {}

SerializedDomElementInfo::SerializedDomElementInfo(
    const std::string& tag_in,
    const std::string& selector_in,
    const std::optional<::gfx::Rect>& visible_bounds_in,
    const std::optional<::gfx::Point>& click_point_in)
    : tag(std::move(tag_in)),
      selector(std::move(selector_in)),
      visible_bounds(std::move(visible_bounds_in)),
      click_point(std::move(click_point_in)) {}

SerializedDomElementInfo::~SerializedDomElementInfo() = default;

void SerializedDomElementInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tag"), this->tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selector"), this->selector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_bounds"), this->visible_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "click_point"), this->click_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Point>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SerializedDomElementInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabRendererData::TabRendererData()
    : blocked(),
      crashed(),
      alert_states(),
      favicon_image(),
      network_state(),
      should_hide_loading_throbber(),
      title(),
      last_committed_url(),
      visible_url() {}

TabRendererData::TabRendererData(
    bool blocked_in,
    bool crashed_in,
    std::vector<TabAlertState> alert_states_in,
    const ::gfx::ImageSkia& favicon_image_in,
    TabNetworkState network_state_in,
    bool should_hide_loading_throbber_in,
    const ::std::u16string& title_in,
    const ::GURL& last_committed_url_in,
    const ::GURL& visible_url_in)
    : blocked(std::move(blocked_in)),
      crashed(std::move(crashed_in)),
      alert_states(std::move(alert_states_in)),
      favicon_image(std::move(favicon_image_in)),
      network_state(std::move(network_state_in)),
      should_hide_loading_throbber(std::move(should_hide_loading_throbber_in)),
      title(std::move(title_in)),
      last_committed_url(std::move(last_committed_url_in)),
      visible_url(std::move(visible_url_in)) {}

TabRendererData::~TabRendererData() = default;

void TabRendererData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked"), this->blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "crashed"), this->crashed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alert_states"), this->alert_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<TabAlertState>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_image"), this->favicon_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ImageSkia&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_state"), this->network_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabNetworkState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_hide_loading_throbber"), this->should_hide_loading_throbber,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_committed_url"), this->last_committed_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_url"), this->visible_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabRendererData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClipboardOverride::ClipboardOverride()
    : text(),
      html() {}

ClipboardOverride::ClipboardOverride(
    const std::optional<::std::u16string>& text_in,
    const std::optional<::std::u16string>& html_in)
    : text(std::move(text_in)),
      html(std::move(html_in)) {}

ClipboardOverride::~ClipboardOverride() = default;

void ClipboardOverride::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "html"), this->html,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClipboardOverride::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertificateChain::CertificateChain()
    : der_chain() {}

CertificateChain::CertificateChain(
    std::vector<std::vector<uint8_t>> der_chain_in)
    : der_chain(std::move(der_chain_in)) {}

CertificateChain::~CertificateChain() = default;

void CertificateChain::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "der_chain"), this->der_chain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertificateChain::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StoragePartitionDescriptor::StoragePartitionDescriptor()
    : partition_domain(),
      partition_name(),
      in_memory() {}

StoragePartitionDescriptor::StoragePartitionDescriptor(
    const std::string& partition_domain_in,
    const std::string& partition_name_in,
    bool in_memory_in)
    : partition_domain(std::move(partition_domain_in)),
      partition_name(std::move(partition_name_in)),
      in_memory(std::move(in_memory_in)) {}

StoragePartitionDescriptor::~StoragePartitionDescriptor() = default;
size_t StoragePartitionDescriptor::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->partition_domain);
  seed = mojo::internal::Hash(seed, this->partition_name);
  seed = mojo::internal::Hash(seed, this->in_memory);
  return seed;
}

void StoragePartitionDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partition_domain"), this->partition_domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partition_name"), this->partition_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_memory"), this->in_memory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StoragePartitionDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClientCertMetadata::ClientCertMetadata()
    : subject(),
      issuer(),
      serial() {}

ClientCertMetadata::ClientCertMetadata(
    const std::string& subject_in,
    const std::string& issuer_in,
    const std::string& serial_in)
    : subject(std::move(subject_in)),
      issuer(std::move(issuer_in)),
      serial(std::move(serial_in)) {}

ClientCertMetadata::~ClientCertMetadata() = default;
size_t ClientCertMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->subject);
  seed = mojo::internal::Hash(seed, this->issuer);
  seed = mojo::internal::Hash(seed, this->serial);
  return seed;
}

void ClientCertMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subject"), this->subject,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serial"), this->serial,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientCertMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PictureInPictureConfig::PictureInPictureConfig()
    : window_options() {}

PictureInPictureConfig::PictureInPictureConfig(
    ::blink::mojom::PictureInPictureWindowOptionsPtr window_options_in)
    : window_options(std::move(window_options_in)) {}

PictureInPictureConfig::~PictureInPictureConfig() = default;
size_t PictureInPictureConfig::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->window_options);
  return seed;
}

void PictureInPictureConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_options"), this->window_options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::PictureInPictureWindowOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PictureInPictureConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WindowOpenContext::WindowOpenContext()
    : disposition(),
      window_features() {}

WindowOpenContext::WindowOpenContext(
    ::WindowOpenDisposition disposition_in,
    ::blink::mojom::WindowFeaturesPtr window_features_in)
    : disposition(std::move(disposition_in)),
      window_features(std::move(window_features_in)) {}

WindowOpenContext::~WindowOpenContext() = default;

void WindowOpenContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disposition"), this->disposition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::WindowOpenDisposition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_features"), this->window_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::WindowFeaturesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WindowOpenContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ExtensionPopupContext::ExtensionPopupContext()
    : extension_id() {}

ExtensionPopupContext::ExtensionPopupContext(
    const std::string& extension_id_in)
    : extension_id(std::move(extension_id_in)) {}

ExtensionPopupContext::~ExtensionPopupContext() = default;
size_t ExtensionPopupContext::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->extension_id);
  return seed;
}

void ExtensionPopupContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extension_id"), this->extension_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionPopupContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DevToolsContext::DevToolsContext()
    : dock_side() {}

DevToolsContext::DevToolsContext(
    DevToolsDockSide dock_side_in)
    : dock_side(std::move(dock_side_in)) {}

DevToolsContext::~DevToolsContext() = default;
size_t DevToolsContext::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->dock_side);
  return seed;
}

void DevToolsContext::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dock_side"), this->dock_side,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DevToolsDockSide>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DevToolsContext::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackForwardState::BackForwardState()
    : can_go_back(),
      can_go_forward() {}

BackForwardState::BackForwardState(
    bool can_go_back_in,
    bool can_go_forward_in)
    : can_go_back(std::move(can_go_back_in)),
      can_go_forward(std::move(can_go_forward_in)) {}

BackForwardState::~BackForwardState() = default;
size_t BackForwardState::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->can_go_back);
  seed = mojo::internal::Hash(seed, this->can_go_forward);
  return seed;
}

void BackForwardState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_go_back"), this->can_go_back,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_go_forward"), this->can_go_forward,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackForwardState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationEntryState::NavigationEntryState()
    : url(),
      title(),
      back_forward_state() {}

NavigationEntryState::NavigationEntryState(
    NavigationEntryUrlPtr url_in,
    const std::optional<::std::u16string>& title_in,
    BackForwardStatePtr back_forward_state_in)
    : url(std::move(url_in)),
      title(std::move(title_in)),
      back_forward_state(std::move(back_forward_state_in)) {}

NavigationEntryState::~NavigationEntryState() = default;

void NavigationEntryState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NavigationEntryUrlPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_forward_state"), this->back_forward_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BackForwardStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NavigationEntryState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CommitDetails::CommitDetails()
    : transition_type(),
      is_redirect(),
      is_chatgpt_frontend(),
      did_replace_entry(),
      is_same_document(),
      entry_id(),
      removed_entry_ids(),
      main_frame_document_id(),
      removed_main_frame_document_ids(),
      entry_state() {}

CommitDetails::CommitDetails(
    TransitionType transition_type_in,
    bool is_redirect_in,
    bool is_chatgpt_frontend_in,
    bool did_replace_entry_in,
    bool is_same_document_in,
    int32_t entry_id_in,
    std::vector<int32_t> removed_entry_ids_in,
    int64_t main_frame_document_id_in,
    std::vector<int64_t> removed_main_frame_document_ids_in,
    NavigationEntryStatePtr entry_state_in)
    : transition_type(std::move(transition_type_in)),
      is_redirect(std::move(is_redirect_in)),
      is_chatgpt_frontend(std::move(is_chatgpt_frontend_in)),
      did_replace_entry(std::move(did_replace_entry_in)),
      is_same_document(std::move(is_same_document_in)),
      entry_id(std::move(entry_id_in)),
      removed_entry_ids(std::move(removed_entry_ids_in)),
      main_frame_document_id(std::move(main_frame_document_id_in)),
      removed_main_frame_document_ids(std::move(removed_main_frame_document_ids_in)),
      entry_state(std::move(entry_state_in)) {}

CommitDetails::~CommitDetails() = default;

void CommitDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition_type"), this->transition_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TransitionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_redirect"), this->is_redirect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_chatgpt_frontend"), this->is_chatgpt_frontend,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "did_replace_entry"), this->did_replace_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_same_document"), this->is_same_document,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entry_id"), this->entry_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "removed_entry_ids"), this->removed_entry_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_document_id"), this->main_frame_document_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "removed_main_frame_document_ids"), this->removed_main_frame_document_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int64_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entry_state"), this->entry_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NavigationEntryStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommitDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NavigationEntryUrl::NavigationEntryUrl()
    : url(),
      redirect_chain_start() {}

NavigationEntryUrl::NavigationEntryUrl(
    const ::GURL& url_in,
    const ::GURL& redirect_chain_start_in)
    : url(std::move(url_in)),
      redirect_chain_start(std::move(redirect_chain_start_in)) {}

NavigationEntryUrl::~NavigationEntryUrl() = default;

void NavigationEntryUrl::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "redirect_chain_start"), this->redirect_chain_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NavigationEntryUrl::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SnapshotResultPtr
SnapshotResult::NewImage(
    const ::SkBitmap& value) {
  return SnapshotResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kImage)>,
      std::move(value));
}

SnapshotResultPtr
SnapshotResult::NewError(
    const std::string& value) {
  return SnapshotResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

SnapshotResult::SnapshotResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
    const ::SkBitmap& value)
    : tag_(Tag::kImage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kImage)>,
            std::move(value)) {}

SnapshotResult::SnapshotResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
SnapshotResult::~SnapshotResult() {
  DestroyActive();
}

void SnapshotResult::set_image(const ::SkBitmap& image) {
  if (tag_ == Tag::kImage) {
    data_.image = std::move(image);
  } else {
    DestroyActive();
    tag_ = Tag::kImage;
    new (&data_.image) ::SkBitmap(
        std::move(image));
  }
}

void SnapshotResult::set_error(const std::string& error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) std::string(
        std::move(error));
  }
}


SnapshotResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
    const ::SkBitmap& value)
    : image(std::move(value)) {}

SnapshotResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : error(std::move(value)) {}

void SnapshotResult::DestroyActive() {
  switch (tag_) {

    case Tag::kImage:
      std::destroy_at(&data_.image);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool SnapshotResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
WebViewDispositionPtr
WebViewDisposition::NewWindowOpen(
    WindowOpenContextPtr value) {
  return WebViewDispositionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kWindowOpen)>,
      std::move(value));
}

WebViewDispositionPtr
WebViewDisposition::NewPictureInPicture(
    PictureInPictureConfigPtr value) {
  return WebViewDispositionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPictureInPicture)>,
      std::move(value));
}

WebViewDispositionPtr
WebViewDisposition::NewPrintPreview(
    bool value) {
  return WebViewDispositionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPrintPreview)>,
      std::move(value));
}

WebViewDispositionPtr
WebViewDisposition::NewExtensionPopup(
    ExtensionPopupContextPtr value) {
  return WebViewDispositionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kExtensionPopup)>,
      std::move(value));
}

WebViewDispositionPtr
WebViewDisposition::NewDevTools(
    DevToolsContextPtr value) {
  return WebViewDispositionPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDevTools)>,
      std::move(value));
}

WebViewDisposition::WebViewDisposition(
    std::in_place_index_t<static_cast<size_t>(Tag::kWindowOpen)>,
    WindowOpenContextPtr value)
    : tag_(Tag::kWindowOpen),
      data_(std::in_place_index<static_cast<size_t>(Tag::kWindowOpen)>,
            std::move(value)) {}

WebViewDisposition::WebViewDisposition(
    std::in_place_index_t<static_cast<size_t>(Tag::kPictureInPicture)>,
    PictureInPictureConfigPtr value)
    : tag_(Tag::kPictureInPicture),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPictureInPicture)>,
            std::move(value)) {}

WebViewDisposition::WebViewDisposition(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrintPreview)>,
    bool value)
    : tag_(Tag::kPrintPreview),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPrintPreview)>,
            std::move(value)) {}

WebViewDisposition::WebViewDisposition(
    std::in_place_index_t<static_cast<size_t>(Tag::kExtensionPopup)>,
    ExtensionPopupContextPtr value)
    : tag_(Tag::kExtensionPopup),
      data_(std::in_place_index<static_cast<size_t>(Tag::kExtensionPopup)>,
            std::move(value)) {}

WebViewDisposition::WebViewDisposition(
    std::in_place_index_t<static_cast<size_t>(Tag::kDevTools)>,
    DevToolsContextPtr value)
    : tag_(Tag::kDevTools),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDevTools)>,
            std::move(value)) {}
WebViewDisposition::~WebViewDisposition() {
  DestroyActive();
}

void WebViewDisposition::set_window_open(WindowOpenContextPtr window_open) {
  if (tag_ == Tag::kWindowOpen) {
    data_.window_open = std::move(window_open);
  } else {
    DestroyActive();
    tag_ = Tag::kWindowOpen;
    new (&data_.window_open) WindowOpenContextPtr(
        std::move(window_open));
  }
}

void WebViewDisposition::set_picture_in_picture(PictureInPictureConfigPtr picture_in_picture) {
  if (tag_ == Tag::kPictureInPicture) {
    data_.picture_in_picture = std::move(picture_in_picture);
  } else {
    DestroyActive();
    tag_ = Tag::kPictureInPicture;
    new (&data_.picture_in_picture) PictureInPictureConfigPtr(
        std::move(picture_in_picture));
  }
}

void WebViewDisposition::set_print_preview(bool print_preview) {
  if (tag_ != Tag::kPrintPreview) {
    DestroyActive();
    tag_ = Tag::kPrintPreview;
  }
  data_.print_preview = print_preview;
}

void WebViewDisposition::set_extension_popup(ExtensionPopupContextPtr extension_popup) {
  if (tag_ == Tag::kExtensionPopup) {
    data_.extension_popup = std::move(extension_popup);
  } else {
    DestroyActive();
    tag_ = Tag::kExtensionPopup;
    new (&data_.extension_popup) ExtensionPopupContextPtr(
        std::move(extension_popup));
  }
}

void WebViewDisposition::set_dev_tools(DevToolsContextPtr dev_tools) {
  if (tag_ == Tag::kDevTools) {
    data_.dev_tools = std::move(dev_tools);
  } else {
    DestroyActive();
    tag_ = Tag::kDevTools;
    new (&data_.dev_tools) DevToolsContextPtr(
        std::move(dev_tools));
  }
}


WebViewDisposition::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kWindowOpen)>,
    WindowOpenContextPtr value)
    : window_open(std::move(value)) {}

WebViewDisposition::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPictureInPicture)>,
    PictureInPictureConfigPtr value)
    : picture_in_picture(std::move(value)) {}

WebViewDisposition::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrintPreview)>,
    bool value)
    : print_preview(std::move(value)) {}

WebViewDisposition::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kExtensionPopup)>,
    ExtensionPopupContextPtr value)
    : extension_popup(std::move(value)) {}

WebViewDisposition::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDevTools)>,
    DevToolsContextPtr value)
    : dev_tools(std::move(value)) {}

void WebViewDisposition::DestroyActive() {
  switch (tag_) {

    case Tag::kWindowOpen:
      std::destroy_at(&data_.window_open);
      break;
    case Tag::kPictureInPicture:
      std::destroy_at(&data_.picture_in_picture);
      break;
    case Tag::kPrintPreview:
      std::destroy_at(&data_.print_preview);
      break;
    case Tag::kExtensionPopup:
      std::destroy_at(&data_.extension_popup);
      break;
    case Tag::kDevTools:
      std::destroy_at(&data_.dev_tools);
      break;
  }
}

bool WebViewDisposition::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FindClient::IPCStableHashFunction FindClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FindClient>(message.name())) {
    case messages::FindClient::kOnFindResult: {
      return &FindClient::OnFindResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FindClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FindClient>(message.name())) {
      case messages::FindClient::kOnFindResult:
            return "Receive owl::mojom::FindClient::OnFindResult";
    }
  } else {
    switch (static_cast<messages::FindClient>(message.name())) {
      case messages::FindClient::kOnFindResult:
            return "Receive reply owl::mojom::FindClient::OnFindResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FindClient::OnFindResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0eaa49d4;  // IPCStableHash for owl::mojom::FindClient::OnFindResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FindClientProxy::FindClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FindClientProxy::OnFindResult(
    FindResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::FindClient::OnFindResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type FindResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FindClient::kOnFindResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::FindClient_OnFindResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::FindResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in FindClient.OnFindResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FindClient::Name_);
  message.set_method_name("OnFindResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FindClientStubDispatch::Accept(
    FindClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FindClient>(message->header()->name)) {
    case messages::FindClient::kOnFindResult: {
      DCHECK(message->is_serialized());
      internal::FindClient_OnFindResult_Params_Data* params =
          reinterpret_cast<internal::FindClient_OnFindResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FindClient.0
      bool success = true;
      FindResultPtr p_result{};
      FindClient_OnFindResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FindClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFindResult(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool FindClientStubDispatch::AcceptWithResponder(
    FindClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FindClient>(message->header()->name)) {
    case messages::FindClient::kOnFindResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFindClientValidationInfo[] = {
    { &internal::FindClient_OnFindResult_Params_Data::Validate,
     nullptr /* no response */},
};

bool FindClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::FindClient::Name_,
    kFindClientValidationInfo);
}

// The declaration includes the definition on other builds.

DevToolsSession::IPCStableHashFunction DevToolsSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsSession>(message.name())) {
    case messages::DevToolsSession::kSendProtocolMessage: {
      return &DevToolsSession::SendProtocolMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsSession>(message.name())) {
      case messages::DevToolsSession::kSendProtocolMessage:
            return "Receive owl::mojom::DevToolsSession::SendProtocolMessage";
    }
  } else {
    switch (static_cast<messages::DevToolsSession>(message.name())) {
      case messages::DevToolsSession::kSendProtocolMessage:
            return "Receive reply owl::mojom::DevToolsSession::SendProtocolMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsSession::SendProtocolMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb701b9f0;  // IPCStableHash for owl::mojom::DevToolsSession::SendProtocolMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsSessionProxy::DevToolsSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsSessionProxy::SendProtocolMessage(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DevToolsSession::SendProtocolMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsSession::kSendProtocolMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DevToolsSession_SendProtocolMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in DevToolsSession.SendProtocolMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsSession::Name_);
  message.set_method_name("SendProtocolMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsSessionStubDispatch::Accept(
    DevToolsSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsSession>(message->header()->name)) {
    case messages::DevToolsSession::kSendProtocolMessage: {
      DCHECK(message->is_serialized());
      internal::DevToolsSession_SendProtocolMessage_Params_Data* params =
          reinterpret_cast<internal::DevToolsSession_SendProtocolMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsSession.0
      bool success = true;
      std::string p_message{};
      DevToolsSession_SendProtocolMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendProtocolMessage(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsSessionStubDispatch::AcceptWithResponder(
    DevToolsSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsSession>(message->header()->name)) {
    case messages::DevToolsSession::kSendProtocolMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsSessionValidationInfo[] = {
    { &internal::DevToolsSession_SendProtocolMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsSessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::DevToolsSession::Name_,
    kDevToolsSessionValidationInfo);
}

// The declaration includes the definition on other builds.

DevToolsSessionClient::IPCStableHashFunction DevToolsSessionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DevToolsSessionClient>(message.name())) {
    case messages::DevToolsSessionClient::kOnProtocolMessage: {
      return &DevToolsSessionClient::OnProtocolMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DevToolsSessionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DevToolsSessionClient>(message.name())) {
      case messages::DevToolsSessionClient::kOnProtocolMessage:
            return "Receive owl::mojom::DevToolsSessionClient::OnProtocolMessage";
    }
  } else {
    switch (static_cast<messages::DevToolsSessionClient>(message.name())) {
      case messages::DevToolsSessionClient::kOnProtocolMessage:
            return "Receive reply owl::mojom::DevToolsSessionClient::OnProtocolMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DevToolsSessionClient::OnProtocolMessage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f2bc4f8;  // IPCStableHash for owl::mojom::DevToolsSessionClient::OnProtocolMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DevToolsSessionClientProxy::DevToolsSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DevToolsSessionClientProxy::OnProtocolMessage(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::DevToolsSessionClient::OnProtocolMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DevToolsSessionClient::kOnProtocolMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::DevToolsSessionClient_OnProtocolMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in DevToolsSessionClient.OnProtocolMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DevToolsSessionClient::Name_);
  message.set_method_name("OnProtocolMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DevToolsSessionClientStubDispatch::Accept(
    DevToolsSessionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DevToolsSessionClient>(message->header()->name)) {
    case messages::DevToolsSessionClient::kOnProtocolMessage: {
      DCHECK(message->is_serialized());
      internal::DevToolsSessionClient_OnProtocolMessage_Params_Data* params =
          reinterpret_cast<internal::DevToolsSessionClient_OnProtocolMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DevToolsSessionClient.0
      bool success = true;
      std::string p_message{};
      DevToolsSessionClient_OnProtocolMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DevToolsSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProtocolMessage(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool DevToolsSessionClientStubDispatch::AcceptWithResponder(
    DevToolsSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DevToolsSessionClient>(message->header()->name)) {
    case messages::DevToolsSessionClient::kOnProtocolMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDevToolsSessionClientValidationInfo[] = {
    { &internal::DevToolsSessionClient_OnProtocolMessage_Params_Data::Validate,
     nullptr /* no response */},
};

bool DevToolsSessionClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::DevToolsSessionClient::Name_,
    kDevToolsSessionClientValidationInfo);
}

// The declaration includes the definition on other builds.

WebView::IPCStableHashFunction WebView::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebView>(message.name())) {
    case messages::WebView::kMoveToGroup: {
      return &WebView::MoveToGroup_Sym::IPCStableHash;
    }
    case messages::WebView::kNavigateTo: {
      return &WebView::NavigateTo_Sym::IPCStableHash;
    }
    case messages::WebView::kSetStoragePartition: {
      return &WebView::SetStoragePartition_Sym::IPCStableHash;
    }
    case messages::WebView::kCloseNow: {
      return &WebView::CloseNow_Sym::IPCStableHash;
    }
    case messages::WebView::kGoBack: {
      return &WebView::GoBack_Sym::IPCStableHash;
    }
    case messages::WebView::kGoForward: {
      return &WebView::GoForward_Sym::IPCStableHash;
    }
    case messages::WebView::kGoToNavigationEntry: {
      return &WebView::GoToNavigationEntry_Sym::IPCStableHash;
    }
    case messages::WebView::kLoadNavigationEntries: {
      return &WebView::LoadNavigationEntries_Sym::IPCStableHash;
    }
    case messages::WebView::kClearForwardHistory: {
      return &WebView::ClearForwardHistory_Sym::IPCStableHash;
    }
    case messages::WebView::kStop: {
      return &WebView::Stop_Sym::IPCStableHash;
    }
    case messages::WebView::kReload: {
      return &WebView::Reload_Sym::IPCStableHash;
    }
    case messages::WebView::kEvaluateJavaScript: {
      return &WebView::EvaluateJavaScript_Sym::IPCStableHash;
    }
    case messages::WebView::kEvaluateJavaScriptWithArguments: {
      return &WebView::EvaluateJavaScriptWithArguments_Sym::IPCStableHash;
    }
    case messages::WebView::kTakeSnapshot: {
      return &WebView::TakeSnapshot_Sym::IPCStableHash;
    }
    case messages::WebView::kFindInPage: {
      return &WebView::FindInPage_Sym::IPCStableHash;
    }
    case messages::WebView::kCancelFindInPage: {
      return &WebView::CancelFindInPage_Sym::IPCStableHash;
    }
    case messages::WebView::kSetForeground: {
      return &WebView::SetForeground_Sym::IPCStableHash;
    }
    case messages::WebView::kSetAuthenticationURLScheme: {
      return &WebView::SetAuthenticationURLScheme_Sym::IPCStableHash;
    }
    case messages::WebView::kCreateDevToolsSession: {
      return &WebView::CreateDevToolsSession_Sym::IPCStableHash;
    }
    case messages::WebView::kOpenDevTools: {
      return &WebView::OpenDevTools_Sym::IPCStableHash;
    }
    case messages::WebView::kZoomIn: {
      return &WebView::ZoomIn_Sym::IPCStableHash;
    }
    case messages::WebView::kZoomOut: {
      return &WebView::ZoomOut_Sym::IPCStableHash;
    }
    case messages::WebView::kResetZoom: {
      return &WebView::ResetZoom_Sym::IPCStableHash;
    }
    case messages::WebView::kMute: {
      return &WebView::Mute_Sym::IPCStableHash;
    }
    case messages::WebView::kUnmute: {
      return &WebView::Unmute_Sym::IPCStableHash;
    }
    case messages::WebView::kCopyImage: {
      return &WebView::CopyImage_Sym::IPCStableHash;
    }
    case messages::WebView::kSaveMedia: {
      return &WebView::SaveMedia_Sym::IPCStableHash;
    }
    case messages::WebView::kLoopPlayback: {
      return &WebView::LoopPlayback_Sym::IPCStableHash;
    }
    case messages::WebView::kShowPlaybackControls: {
      return &WebView::ShowPlaybackControls_Sym::IPCStableHash;
    }
    case messages::WebView::kCopyVideoFrame: {
      return &WebView::CopyVideoFrame_Sym::IPCStableHash;
    }
    case messages::WebView::kShowInPictureInPicture: {
      return &WebView::ShowInPictureInPicture_Sym::IPCStableHash;
    }
    case messages::WebView::kUndo: {
      return &WebView::Undo_Sym::IPCStableHash;
    }
    case messages::WebView::kRedo: {
      return &WebView::Redo_Sym::IPCStableHash;
    }
    case messages::WebView::kCut: {
      return &WebView::Cut_Sym::IPCStableHash;
    }
    case messages::WebView::kCopy: {
      return &WebView::Copy_Sym::IPCStableHash;
    }
    case messages::WebView::kPaste: {
      return &WebView::Paste_Sym::IPCStableHash;
    }
    case messages::WebView::kSelectAll: {
      return &WebView::SelectAll_Sym::IPCStableHash;
    }
    case messages::WebView::kReplaceMisspelledWord: {
      return &WebView::ReplaceMisspelledWord_Sym::IPCStableHash;
    }
    case messages::WebView::kAddToDictionary: {
      return &WebView::AddToDictionary_Sym::IPCStableHash;
    }
    case messages::WebView::kCaptureCopy: {
      return &WebView::CaptureCopy_Sym::IPCStableHash;
    }
    case messages::WebView::kInsertViaPaste: {
      return &WebView::InsertViaPaste_Sym::IPCStableHash;
    }
    case messages::WebView::kSetCancelOffOriginLinkLoads: {
      return &WebView::SetCancelOffOriginLinkLoads_Sym::IPCStableHash;
    }
    case messages::WebView::kForceRendererCrash: {
      return &WebView::ForceRendererCrash_Sym::IPCStableHash;
    }
    case messages::WebView::kFetchCertificateChain: {
      return &WebView::FetchCertificateChain_Sym::IPCStableHash;
    }
    case messages::WebView::kDisablePasswordManagement: {
      return &WebView::DisablePasswordManagement_Sym::IPCStableHash;
    }
    case messages::WebView::kExtractAnnotatedText: {
      return &WebView::ExtractAnnotatedText_Sym::IPCStableHash;
    }
    case messages::WebView::kExtractSerializedDom: {
      return &WebView::ExtractSerializedDom_Sym::IPCStableHash;
    }
    case messages::WebView::kExtractSerializedDomElementInfo: {
      return &WebView::ExtractSerializedDomElementInfo_Sym::IPCStableHash;
    }
    case messages::WebView::kWillExitFullScreenMode: {
      return &WebView::WillExitFullScreenMode_Sym::IPCStableHash;
    }
    case messages::WebView::kRequestPrintPreview: {
      return &WebView::RequestPrintPreview_Sym::IPCStableHash;
    }
    case messages::WebView::kRegisterProtocolHandler: {
      return &WebView::RegisterProtocolHandler_Sym::IPCStableHash;
    }
    case messages::WebView::kSetBackgroundColor: {
      return &WebView::SetBackgroundColor_Sym::IPCStableHash;
    }
    case messages::WebView::kNotifyUserActivation: {
      return &WebView::NotifyUserActivation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebView::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebView>(message.name())) {
      case messages::WebView::kMoveToGroup:
            return "Receive owl::mojom::WebView::MoveToGroup";
      case messages::WebView::kNavigateTo:
            return "Receive owl::mojom::WebView::NavigateTo";
      case messages::WebView::kSetStoragePartition:
            return "Receive owl::mojom::WebView::SetStoragePartition";
      case messages::WebView::kCloseNow:
            return "Receive owl::mojom::WebView::CloseNow";
      case messages::WebView::kGoBack:
            return "Receive owl::mojom::WebView::GoBack";
      case messages::WebView::kGoForward:
            return "Receive owl::mojom::WebView::GoForward";
      case messages::WebView::kGoToNavigationEntry:
            return "Receive owl::mojom::WebView::GoToNavigationEntry";
      case messages::WebView::kLoadNavigationEntries:
            return "Receive owl::mojom::WebView::LoadNavigationEntries";
      case messages::WebView::kClearForwardHistory:
            return "Receive owl::mojom::WebView::ClearForwardHistory";
      case messages::WebView::kStop:
            return "Receive owl::mojom::WebView::Stop";
      case messages::WebView::kReload:
            return "Receive owl::mojom::WebView::Reload";
      case messages::WebView::kEvaluateJavaScript:
            return "Receive owl::mojom::WebView::EvaluateJavaScript";
      case messages::WebView::kEvaluateJavaScriptWithArguments:
            return "Receive owl::mojom::WebView::EvaluateJavaScriptWithArguments";
      case messages::WebView::kTakeSnapshot:
            return "Receive owl::mojom::WebView::TakeSnapshot";
      case messages::WebView::kFindInPage:
            return "Receive owl::mojom::WebView::FindInPage";
      case messages::WebView::kCancelFindInPage:
            return "Receive owl::mojom::WebView::CancelFindInPage";
      case messages::WebView::kSetForeground:
            return "Receive owl::mojom::WebView::SetForeground";
      case messages::WebView::kSetAuthenticationURLScheme:
            return "Receive owl::mojom::WebView::SetAuthenticationURLScheme";
      case messages::WebView::kCreateDevToolsSession:
            return "Receive owl::mojom::WebView::CreateDevToolsSession";
      case messages::WebView::kOpenDevTools:
            return "Receive owl::mojom::WebView::OpenDevTools";
      case messages::WebView::kZoomIn:
            return "Receive owl::mojom::WebView::ZoomIn";
      case messages::WebView::kZoomOut:
            return "Receive owl::mojom::WebView::ZoomOut";
      case messages::WebView::kResetZoom:
            return "Receive owl::mojom::WebView::ResetZoom";
      case messages::WebView::kMute:
            return "Receive owl::mojom::WebView::Mute";
      case messages::WebView::kUnmute:
            return "Receive owl::mojom::WebView::Unmute";
      case messages::WebView::kCopyImage:
            return "Receive owl::mojom::WebView::CopyImage";
      case messages::WebView::kSaveMedia:
            return "Receive owl::mojom::WebView::SaveMedia";
      case messages::WebView::kLoopPlayback:
            return "Receive owl::mojom::WebView::LoopPlayback";
      case messages::WebView::kShowPlaybackControls:
            return "Receive owl::mojom::WebView::ShowPlaybackControls";
      case messages::WebView::kCopyVideoFrame:
            return "Receive owl::mojom::WebView::CopyVideoFrame";
      case messages::WebView::kShowInPictureInPicture:
            return "Receive owl::mojom::WebView::ShowInPictureInPicture";
      case messages::WebView::kUndo:
            return "Receive owl::mojom::WebView::Undo";
      case messages::WebView::kRedo:
            return "Receive owl::mojom::WebView::Redo";
      case messages::WebView::kCut:
            return "Receive owl::mojom::WebView::Cut";
      case messages::WebView::kCopy:
            return "Receive owl::mojom::WebView::Copy";
      case messages::WebView::kPaste:
            return "Receive owl::mojom::WebView::Paste";
      case messages::WebView::kSelectAll:
            return "Receive owl::mojom::WebView::SelectAll";
      case messages::WebView::kReplaceMisspelledWord:
            return "Receive owl::mojom::WebView::ReplaceMisspelledWord";
      case messages::WebView::kAddToDictionary:
            return "Receive owl::mojom::WebView::AddToDictionary";
      case messages::WebView::kCaptureCopy:
            return "Receive owl::mojom::WebView::CaptureCopy";
      case messages::WebView::kInsertViaPaste:
            return "Receive owl::mojom::WebView::InsertViaPaste";
      case messages::WebView::kSetCancelOffOriginLinkLoads:
            return "Receive owl::mojom::WebView::SetCancelOffOriginLinkLoads";
      case messages::WebView::kForceRendererCrash:
            return "Receive owl::mojom::WebView::ForceRendererCrash";
      case messages::WebView::kFetchCertificateChain:
            return "Receive owl::mojom::WebView::FetchCertificateChain";
      case messages::WebView::kDisablePasswordManagement:
            return "Receive owl::mojom::WebView::DisablePasswordManagement";
      case messages::WebView::kExtractAnnotatedText:
            return "Receive owl::mojom::WebView::ExtractAnnotatedText";
      case messages::WebView::kExtractSerializedDom:
            return "Receive owl::mojom::WebView::ExtractSerializedDom";
      case messages::WebView::kExtractSerializedDomElementInfo:
            return "Receive owl::mojom::WebView::ExtractSerializedDomElementInfo";
      case messages::WebView::kWillExitFullScreenMode:
            return "Receive owl::mojom::WebView::WillExitFullScreenMode";
      case messages::WebView::kRequestPrintPreview:
            return "Receive owl::mojom::WebView::RequestPrintPreview";
      case messages::WebView::kRegisterProtocolHandler:
            return "Receive owl::mojom::WebView::RegisterProtocolHandler";
      case messages::WebView::kSetBackgroundColor:
            return "Receive owl::mojom::WebView::SetBackgroundColor";
      case messages::WebView::kNotifyUserActivation:
            return "Receive owl::mojom::WebView::NotifyUserActivation";
    }
  } else {
    switch (static_cast<messages::WebView>(message.name())) {
      case messages::WebView::kMoveToGroup:
            return "Receive reply owl::mojom::WebView::MoveToGroup";
      case messages::WebView::kNavigateTo:
            return "Receive reply owl::mojom::WebView::NavigateTo";
      case messages::WebView::kSetStoragePartition:
            return "Receive reply owl::mojom::WebView::SetStoragePartition";
      case messages::WebView::kCloseNow:
            return "Receive reply owl::mojom::WebView::CloseNow";
      case messages::WebView::kGoBack:
            return "Receive reply owl::mojom::WebView::GoBack";
      case messages::WebView::kGoForward:
            return "Receive reply owl::mojom::WebView::GoForward";
      case messages::WebView::kGoToNavigationEntry:
            return "Receive reply owl::mojom::WebView::GoToNavigationEntry";
      case messages::WebView::kLoadNavigationEntries:
            return "Receive reply owl::mojom::WebView::LoadNavigationEntries";
      case messages::WebView::kClearForwardHistory:
            return "Receive reply owl::mojom::WebView::ClearForwardHistory";
      case messages::WebView::kStop:
            return "Receive reply owl::mojom::WebView::Stop";
      case messages::WebView::kReload:
            return "Receive reply owl::mojom::WebView::Reload";
      case messages::WebView::kEvaluateJavaScript:
            return "Receive reply owl::mojom::WebView::EvaluateJavaScript";
      case messages::WebView::kEvaluateJavaScriptWithArguments:
            return "Receive reply owl::mojom::WebView::EvaluateJavaScriptWithArguments";
      case messages::WebView::kTakeSnapshot:
            return "Receive reply owl::mojom::WebView::TakeSnapshot";
      case messages::WebView::kFindInPage:
            return "Receive reply owl::mojom::WebView::FindInPage";
      case messages::WebView::kCancelFindInPage:
            return "Receive reply owl::mojom::WebView::CancelFindInPage";
      case messages::WebView::kSetForeground:
            return "Receive reply owl::mojom::WebView::SetForeground";
      case messages::WebView::kSetAuthenticationURLScheme:
            return "Receive reply owl::mojom::WebView::SetAuthenticationURLScheme";
      case messages::WebView::kCreateDevToolsSession:
            return "Receive reply owl::mojom::WebView::CreateDevToolsSession";
      case messages::WebView::kOpenDevTools:
            return "Receive reply owl::mojom::WebView::OpenDevTools";
      case messages::WebView::kZoomIn:
            return "Receive reply owl::mojom::WebView::ZoomIn";
      case messages::WebView::kZoomOut:
            return "Receive reply owl::mojom::WebView::ZoomOut";
      case messages::WebView::kResetZoom:
            return "Receive reply owl::mojom::WebView::ResetZoom";
      case messages::WebView::kMute:
            return "Receive reply owl::mojom::WebView::Mute";
      case messages::WebView::kUnmute:
            return "Receive reply owl::mojom::WebView::Unmute";
      case messages::WebView::kCopyImage:
            return "Receive reply owl::mojom::WebView::CopyImage";
      case messages::WebView::kSaveMedia:
            return "Receive reply owl::mojom::WebView::SaveMedia";
      case messages::WebView::kLoopPlayback:
            return "Receive reply owl::mojom::WebView::LoopPlayback";
      case messages::WebView::kShowPlaybackControls:
            return "Receive reply owl::mojom::WebView::ShowPlaybackControls";
      case messages::WebView::kCopyVideoFrame:
            return "Receive reply owl::mojom::WebView::CopyVideoFrame";
      case messages::WebView::kShowInPictureInPicture:
            return "Receive reply owl::mojom::WebView::ShowInPictureInPicture";
      case messages::WebView::kUndo:
            return "Receive reply owl::mojom::WebView::Undo";
      case messages::WebView::kRedo:
            return "Receive reply owl::mojom::WebView::Redo";
      case messages::WebView::kCut:
            return "Receive reply owl::mojom::WebView::Cut";
      case messages::WebView::kCopy:
            return "Receive reply owl::mojom::WebView::Copy";
      case messages::WebView::kPaste:
            return "Receive reply owl::mojom::WebView::Paste";
      case messages::WebView::kSelectAll:
            return "Receive reply owl::mojom::WebView::SelectAll";
      case messages::WebView::kReplaceMisspelledWord:
            return "Receive reply owl::mojom::WebView::ReplaceMisspelledWord";
      case messages::WebView::kAddToDictionary:
            return "Receive reply owl::mojom::WebView::AddToDictionary";
      case messages::WebView::kCaptureCopy:
            return "Receive reply owl::mojom::WebView::CaptureCopy";
      case messages::WebView::kInsertViaPaste:
            return "Receive reply owl::mojom::WebView::InsertViaPaste";
      case messages::WebView::kSetCancelOffOriginLinkLoads:
            return "Receive reply owl::mojom::WebView::SetCancelOffOriginLinkLoads";
      case messages::WebView::kForceRendererCrash:
            return "Receive reply owl::mojom::WebView::ForceRendererCrash";
      case messages::WebView::kFetchCertificateChain:
            return "Receive reply owl::mojom::WebView::FetchCertificateChain";
      case messages::WebView::kDisablePasswordManagement:
            return "Receive reply owl::mojom::WebView::DisablePasswordManagement";
      case messages::WebView::kExtractAnnotatedText:
            return "Receive reply owl::mojom::WebView::ExtractAnnotatedText";
      case messages::WebView::kExtractSerializedDom:
            return "Receive reply owl::mojom::WebView::ExtractSerializedDom";
      case messages::WebView::kExtractSerializedDomElementInfo:
            return "Receive reply owl::mojom::WebView::ExtractSerializedDomElementInfo";
      case messages::WebView::kWillExitFullScreenMode:
            return "Receive reply owl::mojom::WebView::WillExitFullScreenMode";
      case messages::WebView::kRequestPrintPreview:
            return "Receive reply owl::mojom::WebView::RequestPrintPreview";
      case messages::WebView::kRegisterProtocolHandler:
            return "Receive reply owl::mojom::WebView::RegisterProtocolHandler";
      case messages::WebView::kSetBackgroundColor:
            return "Receive reply owl::mojom::WebView::SetBackgroundColor";
      case messages::WebView::kNotifyUserActivation:
            return "Receive reply owl::mojom::WebView::NotifyUserActivation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebView::MoveToGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xceb70ffb;  // IPCStableHash for owl::mojom::WebView::MoveToGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::NavigateTo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3c1be6fc;  // IPCStableHash for owl::mojom::WebView::NavigateTo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SetStoragePartition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31470204;  // IPCStableHash for owl::mojom::WebView::SetStoragePartition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::CloseNow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe049e9f4;  // IPCStableHash for owl::mojom::WebView::CloseNow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::GoBack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x898ec779;  // IPCStableHash for owl::mojom::WebView::GoBack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::GoForward_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42cdd7fc;  // IPCStableHash for owl::mojom::WebView::GoForward
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::GoToNavigationEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe6dd362;  // IPCStableHash for owl::mojom::WebView::GoToNavigationEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::LoadNavigationEntries_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24d0cd75;  // IPCStableHash for owl::mojom::WebView::LoadNavigationEntries
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ClearForwardHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc06802cf;  // IPCStableHash for owl::mojom::WebView::ClearForwardHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb059dbe;  // IPCStableHash for owl::mojom::WebView::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Reload_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87a6f040;  // IPCStableHash for owl::mojom::WebView::Reload
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::EvaluateJavaScript_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde9fde89;  // IPCStableHash for owl::mojom::WebView::EvaluateJavaScript
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::EvaluateJavaScriptWithArguments_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b17e859;  // IPCStableHash for owl::mojom::WebView::EvaluateJavaScriptWithArguments
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::TakeSnapshot_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00f1185d;  // IPCStableHash for owl::mojom::WebView::TakeSnapshot
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::FindInPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ede599c;  // IPCStableHash for owl::mojom::WebView::FindInPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::CancelFindInPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00928cbd;  // IPCStableHash for owl::mojom::WebView::CancelFindInPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SetForeground_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61547af8;  // IPCStableHash for owl::mojom::WebView::SetForeground
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SetAuthenticationURLScheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9db67d1;  // IPCStableHash for owl::mojom::WebView::SetAuthenticationURLScheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::CreateDevToolsSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f03165c;  // IPCStableHash for owl::mojom::WebView::CreateDevToolsSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::OpenDevTools_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x383aa417;  // IPCStableHash for owl::mojom::WebView::OpenDevTools
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ZoomIn_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70157fad;  // IPCStableHash for owl::mojom::WebView::ZoomIn
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ZoomOut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x771d6ed6;  // IPCStableHash for owl::mojom::WebView::ZoomOut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ResetZoom_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x228d1482;  // IPCStableHash for owl::mojom::WebView::ResetZoom
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Mute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x01e4bf0c;  // IPCStableHash for owl::mojom::WebView::Mute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Unmute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba399b1b;  // IPCStableHash for owl::mojom::WebView::Unmute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::CopyImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95efb736;  // IPCStableHash for owl::mojom::WebView::CopyImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SaveMedia_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6af718f7;  // IPCStableHash for owl::mojom::WebView::SaveMedia
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::LoopPlayback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd991ff55;  // IPCStableHash for owl::mojom::WebView::LoopPlayback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ShowPlaybackControls_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x099ed0a5;  // IPCStableHash for owl::mojom::WebView::ShowPlaybackControls
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::CopyVideoFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2b83ca1;  // IPCStableHash for owl::mojom::WebView::CopyVideoFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ShowInPictureInPicture_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x608c5d74;  // IPCStableHash for owl::mojom::WebView::ShowInPictureInPicture
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4342f971;  // IPCStableHash for owl::mojom::WebView::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Redo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54f96668;  // IPCStableHash for owl::mojom::WebView::Redo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Cut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e6e8489;  // IPCStableHash for owl::mojom::WebView::Cut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Copy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f49ba2f;  // IPCStableHash for owl::mojom::WebView::Copy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::Paste_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee4bb16f;  // IPCStableHash for owl::mojom::WebView::Paste
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SelectAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08fc3bfa;  // IPCStableHash for owl::mojom::WebView::SelectAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ReplaceMisspelledWord_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe9dbeccd;  // IPCStableHash for owl::mojom::WebView::ReplaceMisspelledWord
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::AddToDictionary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52020794;  // IPCStableHash for owl::mojom::WebView::AddToDictionary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::CaptureCopy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6673324a;  // IPCStableHash for owl::mojom::WebView::CaptureCopy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::InsertViaPaste_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa787a76;  // IPCStableHash for owl::mojom::WebView::InsertViaPaste
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SetCancelOffOriginLinkLoads_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b0f581a;  // IPCStableHash for owl::mojom::WebView::SetCancelOffOriginLinkLoads
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ForceRendererCrash_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21b567c9;  // IPCStableHash for owl::mojom::WebView::ForceRendererCrash
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::FetchCertificateChain_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9657bd1b;  // IPCStableHash for owl::mojom::WebView::FetchCertificateChain
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::DisablePasswordManagement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4921094;  // IPCStableHash for owl::mojom::WebView::DisablePasswordManagement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ExtractAnnotatedText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6c360323;  // IPCStableHash for owl::mojom::WebView::ExtractAnnotatedText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ExtractSerializedDom_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb5fd6e62;  // IPCStableHash for owl::mojom::WebView::ExtractSerializedDom
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::ExtractSerializedDomElementInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3cba03b;  // IPCStableHash for owl::mojom::WebView::ExtractSerializedDomElementInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::WillExitFullScreenMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18555074;  // IPCStableHash for owl::mojom::WebView::WillExitFullScreenMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::RequestPrintPreview_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc75ace9c;  // IPCStableHash for owl::mojom::WebView::RequestPrintPreview
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::RegisterProtocolHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c2d31e8;  // IPCStableHash for owl::mojom::WebView::RegisterProtocolHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::SetBackgroundColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7a267a1;  // IPCStableHash for owl::mojom::WebView::SetBackgroundColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebView::NotifyUserActivation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0270e449;  // IPCStableHash for owl::mojom::WebView::NotifyUserActivation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebView_LoadNavigationEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_LoadNavigationEntries_ForwardToCallback(
      WebView::LoadNavigationEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_LoadNavigationEntries_ForwardToCallback(const WebView_LoadNavigationEntries_ForwardToCallback&) = delete;
  WebView_LoadNavigationEntries_ForwardToCallback& operator=(const WebView_LoadNavigationEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::LoadNavigationEntriesCallback callback_;
};

class WebView_EvaluateJavaScript_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_EvaluateJavaScript_ForwardToCallback(
      WebView::EvaluateJavaScriptCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_EvaluateJavaScript_ForwardToCallback(const WebView_EvaluateJavaScript_ForwardToCallback&) = delete;
  WebView_EvaluateJavaScript_ForwardToCallback& operator=(const WebView_EvaluateJavaScript_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::EvaluateJavaScriptCallback callback_;
};

class WebView_EvaluateJavaScriptWithArguments_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_EvaluateJavaScriptWithArguments_ForwardToCallback(
      WebView::EvaluateJavaScriptWithArgumentsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_EvaluateJavaScriptWithArguments_ForwardToCallback(const WebView_EvaluateJavaScriptWithArguments_ForwardToCallback&) = delete;
  WebView_EvaluateJavaScriptWithArguments_ForwardToCallback& operator=(const WebView_EvaluateJavaScriptWithArguments_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::EvaluateJavaScriptWithArgumentsCallback callback_;
};

class WebView_TakeSnapshot_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_TakeSnapshot_ForwardToCallback(
      WebView::TakeSnapshotCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_TakeSnapshot_ForwardToCallback(const WebView_TakeSnapshot_ForwardToCallback&) = delete;
  WebView_TakeSnapshot_ForwardToCallback& operator=(const WebView_TakeSnapshot_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::TakeSnapshotCallback callback_;
};

class WebView_CaptureCopy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_CaptureCopy_ForwardToCallback(
      WebView::CaptureCopyCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_CaptureCopy_ForwardToCallback(const WebView_CaptureCopy_ForwardToCallback&) = delete;
  WebView_CaptureCopy_ForwardToCallback& operator=(const WebView_CaptureCopy_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::CaptureCopyCallback callback_;
};

class WebView_InsertViaPaste_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_InsertViaPaste_ForwardToCallback(
      WebView::InsertViaPasteCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_InsertViaPaste_ForwardToCallback(const WebView_InsertViaPaste_ForwardToCallback&) = delete;
  WebView_InsertViaPaste_ForwardToCallback& operator=(const WebView_InsertViaPaste_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::InsertViaPasteCallback callback_;
};

class WebView_FetchCertificateChain_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_FetchCertificateChain_ForwardToCallback(
      WebView::FetchCertificateChainCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_FetchCertificateChain_ForwardToCallback(const WebView_FetchCertificateChain_ForwardToCallback&) = delete;
  WebView_FetchCertificateChain_ForwardToCallback& operator=(const WebView_FetchCertificateChain_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::FetchCertificateChainCallback callback_;
};

class WebView_ExtractAnnotatedText_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_ExtractAnnotatedText_ForwardToCallback(
      WebView::ExtractAnnotatedTextCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_ExtractAnnotatedText_ForwardToCallback(const WebView_ExtractAnnotatedText_ForwardToCallback&) = delete;
  WebView_ExtractAnnotatedText_ForwardToCallback& operator=(const WebView_ExtractAnnotatedText_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::ExtractAnnotatedTextCallback callback_;
};

class WebView_ExtractSerializedDom_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_ExtractSerializedDom_ForwardToCallback(
      WebView::ExtractSerializedDomCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_ExtractSerializedDom_ForwardToCallback(const WebView_ExtractSerializedDom_ForwardToCallback&) = delete;
  WebView_ExtractSerializedDom_ForwardToCallback& operator=(const WebView_ExtractSerializedDom_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::ExtractSerializedDomCallback callback_;
};

class WebView_ExtractSerializedDomElementInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebView_ExtractSerializedDomElementInfo_ForwardToCallback(
      WebView::ExtractSerializedDomElementInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebView_ExtractSerializedDomElementInfo_ForwardToCallback(const WebView_ExtractSerializedDomElementInfo_ForwardToCallback&) = delete;
  WebView_ExtractSerializedDomElementInfo_ForwardToCallback& operator=(const WebView_ExtractSerializedDomElementInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebView::ExtractSerializedDomElementInfoCallback callback_;
};

WebViewProxy::WebViewProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebViewProxy::MoveToGroup(
    const std::string& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::MoveToGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kMoveToGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_MoveToGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in WebView.MoveToGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("MoveToGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::NavigateTo(
    const ::GURL& in_url, NavigationType in_type, const std::string& in_additional_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::NavigateTo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type NavigationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("additional_headers"), in_additional_headers,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kNavigateTo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_NavigateTo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebView.NavigateTo request");

  
  mojo::internal::Serialize<::owl::mojom::NavigationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->additional_headers)::BaseType> additional_headers_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_additional_headers,
    additional_headers_fragment);

  params->additional_headers.Set(
      additional_headers_fragment.is_null() ? nullptr : additional_headers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->additional_headers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null additional_headers in WebView.NavigateTo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("NavigateTo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::SetStoragePartition(
    StoragePartitionDescriptorPtr in_partition) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::SetStoragePartition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partition"), in_partition,
                        "<value of type StoragePartitionDescriptorPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSetStoragePartition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SetStoragePartition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->partition)::BaseType> partition_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::StoragePartitionDescriptorDataView>(
    in_partition,
    partition_fragment);

  params->partition.Set(
      partition_fragment.is_null() ? nullptr : partition_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SetStoragePartition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::CloseNow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::CloseNow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCloseNow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CloseNow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CloseNow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::GoBack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::GoBack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kGoBack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_GoBack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("GoBack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::GoForward(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::GoForward");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kGoForward), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_GoForward_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("GoForward");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::GoToNavigationEntry(
    int32_t in_navigation_entry_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::GoToNavigationEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_entry_id"), in_navigation_entry_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kGoToNavigationEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_GoToNavigationEntry_Params_Data> params(
          message);
  params.Allocate();

  params->navigation_entry_id = in_navigation_entry_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("GoToNavigationEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::LoadNavigationEntries(
    LoadNavigationEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::LoadNavigationEntries");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kLoadNavigationEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_LoadNavigationEntries_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("LoadNavigationEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_LoadNavigationEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::ClearForwardHistory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::ClearForwardHistory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kClearForwardHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ClearForwardHistory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ClearForwardHistory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Stop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Reload(
    bool in_skip_cache) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::Reload", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("skip_cache"), in_skip_cache,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kReload), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Reload_Params_Data> params(
          message);
  params.Allocate();

  params->skip_cache = in_skip_cache;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Reload");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::EvaluateJavaScript(
    const std::string& in_script, bool in_use_main_world, EvaluateJavaScriptCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::EvaluateJavaScript", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script"), in_script,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_main_world"), in_use_main_world,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kEvaluateJavaScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_EvaluateJavaScript_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script)::BaseType> script_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_script,
    script_fragment);

  params->script.Set(
      script_fragment.is_null() ? nullptr : script_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script in WebView.EvaluateJavaScript request");

  params->use_main_world = in_use_main_world;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("EvaluateJavaScript");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_EvaluateJavaScript_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::EvaluateJavaScriptWithArguments(
    const std::string& in_script, bool in_use_main_world, base::flat_map<std::string, ::base::Value> in_arguments, bool in_should_await, EvaluateJavaScriptWithArgumentsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::EvaluateJavaScriptWithArguments", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("script"), in_script,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_main_world"), in_use_main_world,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("arguments"), in_arguments,
                        "<value of type base::flat_map<std::string, ::base::Value>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_await"), in_should_await,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kEvaluateJavaScriptWithArguments), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_EvaluateJavaScriptWithArguments_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->script)::BaseType> script_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_script,
    script_fragment);

  params->script.Set(
      script_fragment.is_null() ? nullptr : script_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->script.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null script in WebView.EvaluateJavaScriptWithArguments request");

  params->use_main_world = in_use_main_world;
  mojo::internal::MessageFragment<
      typename decltype(params->arguments)::BaseType>
      arguments_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& arguments_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::ValueDataView>>(
    in_arguments,
    arguments_fragment,
    &arguments_validate_params);

  params->arguments.Set(
      arguments_fragment.is_null() ? nullptr : arguments_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->arguments.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null arguments in WebView.EvaluateJavaScriptWithArguments request");

  params->should_await = in_should_await;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("EvaluateJavaScriptWithArguments");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_EvaluateJavaScriptWithArguments_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::TakeSnapshot(
    std::optional<::base::TimeDelta> in_timeout, TakeSnapshotCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::TakeSnapshot", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timeout"), in_timeout,
                        "<value of type std::optional<::base::TimeDelta>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kTakeSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_TakeSnapshot_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timeout)::BaseType> timeout_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_timeout,
    timeout_fragment);

  params->timeout.Set(
      timeout_fragment.is_null() ? nullptr : timeout_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("TakeSnapshot");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_TakeSnapshot_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::FindInPage(
    const std::string& in_text, FindDirection in_direction, ::mojo::PendingAssociatedRemote<FindClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::FindInPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type FindDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<FindClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kFindInPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_FindInPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WebView.FindInPage request");

  
  mojo::internal::Serialize<::owl::mojom::FindDirection>(
    in_direction,
    &params->direction);

  
  mojo::internal::Serialize<::owl::mojom::FindClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebView.FindInPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("FindInPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::CancelFindInPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::CancelFindInPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCancelFindInPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CancelFindInPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CancelFindInPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::SetForeground(
    bool in_foreground) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::SetForeground", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("foreground"), in_foreground,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSetForeground), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SetForeground_Params_Data> params(
          message);
  params.Allocate();

  params->foreground = in_foreground;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SetForeground");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::SetAuthenticationURLScheme(
    const std::string& in_scheme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::SetAuthenticationURLScheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scheme"), in_scheme,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSetAuthenticationURLScheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SetAuthenticationURLScheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->scheme)::BaseType> scheme_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_scheme,
    scheme_fragment);

  params->scheme.Set(
      scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->scheme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null scheme in WebView.SetAuthenticationURLScheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SetAuthenticationURLScheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::CreateDevToolsSession(
    ::mojo::PendingAssociatedReceiver<DevToolsSession> in_session, ::mojo::PendingAssociatedRemote<DevToolsSessionClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::CreateDevToolsSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingAssociatedReceiver<DevToolsSession>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<DevToolsSessionClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCreateDevToolsSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CreateDevToolsSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::DevToolsSessionAssociatedRequestDataView>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid session in WebView.CreateDevToolsSession request");

  
  mojo::internal::Serialize<::owl::mojom::DevToolsSessionClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in WebView.CreateDevToolsSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CreateDevToolsSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::OpenDevTools(
    DevToolsPanel in_panel, DOMElementReferencePtr in_dom_element) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::OpenDevTools", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("panel"), in_panel,
                        "<value of type DevToolsPanel>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_element"), in_dom_element,
                        "<value of type DOMElementReferencePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kOpenDevTools), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_OpenDevTools_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::DevToolsPanel>(
    in_panel,
    &params->panel);
  mojo::internal::MessageFragment<
      typename decltype(params->dom_element)::BaseType> dom_element_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::DOMElementReferenceDataView>(
    in_dom_element,
    dom_element_fragment);

  params->dom_element.Set(
      dom_element_fragment.is_null() ? nullptr : dom_element_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("OpenDevTools");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ZoomIn(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::ZoomIn");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kZoomIn), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ZoomIn_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ZoomIn");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ZoomOut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::ZoomOut");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kZoomOut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ZoomOut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ZoomOut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ResetZoom(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::ResetZoom");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kResetZoom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ResetZoom_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ResetZoom");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Mute(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Mute");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kMute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Mute_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Mute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Unmute(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Unmute");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kUnmute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Unmute_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Unmute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::CopyImage(
    int32_t in_frame_routing_id, int32_t in_frame_process_id, int32_t in_x, int32_t in_y) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::CopyImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_routing_id"), in_frame_routing_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_process_id"), in_frame_process_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("x"), in_x,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("y"), in_y,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCopyImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CopyImage_Params_Data> params(
          message);
  params.Allocate();

  params->frame_routing_id = in_frame_routing_id;

  params->frame_process_id = in_frame_process_id;

  params->x = in_x;

  params->y = in_y;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CopyImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::SaveMedia(
    ::owl::mojom::ContextMenuParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::SaveMedia", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::owl::mojom::ContextMenuParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSaveMedia), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SaveMedia_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebView.SaveMedia request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SaveMedia");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::LoopPlayback(
    ::owl::mojom::ContextMenuParamsPtr in_params, bool in_loop_playback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::LoopPlayback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::owl::mojom::ContextMenuParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loop_playback"), in_loop_playback,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kLoopPlayback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_LoopPlayback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebView.LoopPlayback request");

  params->loop_playback = in_loop_playback;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("LoopPlayback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ShowPlaybackControls(
    ::owl::mojom::ContextMenuParamsPtr in_params, bool in_show_playback_controls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::ShowPlaybackControls", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::owl::mojom::ContextMenuParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show_playback_controls"), in_show_playback_controls,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kShowPlaybackControls), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ShowPlaybackControls_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebView.ShowPlaybackControls request");

  params->show_playback_controls = in_show_playback_controls;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ShowPlaybackControls");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::CopyVideoFrame(
    ::owl::mojom::ContextMenuParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::CopyVideoFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::owl::mojom::ContextMenuParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCopyVideoFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CopyVideoFrame_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebView.CopyVideoFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CopyVideoFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ShowInPictureInPicture(
    ::owl::mojom::ContextMenuParamsPtr in_params, bool in_show_in_picture_in_picture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::ShowInPictureInPicture", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::owl::mojom::ContextMenuParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show_in_picture_in_picture"), in_show_in_picture_in_picture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kShowInPictureInPicture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ShowInPictureInPicture_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ContextMenuParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebView.ShowInPictureInPicture request");

  params->show_in_picture_in_picture = in_show_in_picture_in_picture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ShowInPictureInPicture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Undo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Redo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Redo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kRedo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Redo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Redo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Cut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Cut");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Cut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Cut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Copy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Copy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Copy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Copy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::Paste(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::Paste");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_Paste_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("Paste");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::SelectAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::SelectAll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSelectAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SelectAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SelectAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ReplaceMisspelledWord(
    const ::std::u16string& in_replacement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::ReplaceMisspelledWord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement"), in_replacement,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kReplaceMisspelledWord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ReplaceMisspelledWord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->replacement)::BaseType> replacement_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_replacement,
    replacement_fragment);

  params->replacement.Set(
      replacement_fragment.is_null() ? nullptr : replacement_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement in WebView.ReplaceMisspelledWord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ReplaceMisspelledWord");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::AddToDictionary(
    const ::std::u16string& in_word) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::AddToDictionary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("word"), in_word,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kAddToDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_AddToDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->word)::BaseType> word_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_word,
    word_fragment);

  params->word.Set(
      word_fragment.is_null() ? nullptr : word_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->word.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null word in WebView.AddToDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("AddToDictionary");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::CaptureCopy(
    CaptureCopyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::CaptureCopy");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCaptureCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CaptureCopy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CaptureCopy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_CaptureCopy_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::InsertViaPaste(
    ClipboardOverridePtr in_contents, InsertViaPasteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::InsertViaPaste", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contents"), in_contents,
                        "<value of type ClipboardOverridePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kInsertViaPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_InsertViaPaste_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->contents)::BaseType> contents_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ClipboardOverrideDataView>(
    in_contents,
    contents_fragment);

  params->contents.Set(
      contents_fragment.is_null() ? nullptr : contents_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->contents.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null contents in WebView.InsertViaPaste request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("InsertViaPaste");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_InsertViaPaste_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::SetCancelOffOriginLinkLoads(
    bool in_cancel_off_origin_link_loads) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::SetCancelOffOriginLinkLoads", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancel_off_origin_link_loads"), in_cancel_off_origin_link_loads,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSetCancelOffOriginLinkLoads), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SetCancelOffOriginLinkLoads_Params_Data> params(
          message);
  params.Allocate();

  params->cancel_off_origin_link_loads = in_cancel_off_origin_link_loads;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SetCancelOffOriginLinkLoads");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ForceRendererCrash(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::ForceRendererCrash");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kForceRendererCrash), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ForceRendererCrash_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ForceRendererCrash");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::FetchCertificateChain(
    FetchCertificateChainCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::FetchCertificateChain");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kFetchCertificateChain), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_FetchCertificateChain_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("FetchCertificateChain");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_FetchCertificateChain_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::DisablePasswordManagement(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::DisablePasswordManagement");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kDisablePasswordManagement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_DisablePasswordManagement_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("DisablePasswordManagement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::ExtractAnnotatedText(
    uint64_t in_char_count_goal, ExtractAnnotatedTextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::ExtractAnnotatedText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("char_count_goal"), in_char_count_goal,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kExtractAnnotatedText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ExtractAnnotatedText_Params_Data> params(
          message);
  params.Allocate();

  params->char_count_goal = in_char_count_goal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ExtractAnnotatedText");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_ExtractAnnotatedText_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::ExtractSerializedDom(
    ExtractSerializedDomCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::ExtractSerializedDom");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kExtractSerializedDom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ExtractSerializedDom_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ExtractSerializedDom");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_ExtractSerializedDom_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::ExtractSerializedDomElementInfo(
    const std::string& in_id, ExtractSerializedDomElementInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::ExtractSerializedDomElementInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kExtractSerializedDomElementInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ExtractSerializedDomElementInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in WebView.ExtractSerializedDomElementInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ExtractSerializedDomElementInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebView_ExtractSerializedDomElementInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewProxy::WillExitFullScreenMode(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::WillExitFullScreenMode");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kWillExitFullScreenMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_WillExitFullScreenMode_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("WillExitFullScreenMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::RequestPrintPreview(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::RequestPrintPreview");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kRequestPrintPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_RequestPrintPreview_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("RequestPrintPreview");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::RegisterProtocolHandler(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::RegisterProtocolHandler");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kRegisterProtocolHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_RegisterProtocolHandler_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("RegisterProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::SetBackgroundColor(
    ::SkColor in_color) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebView::SetBackgroundColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("color"), in_color,
                        "<value of type ::SkColor>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kSetBackgroundColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_SetBackgroundColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->color)::BaseType> color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_color,
    color_fragment);

  params->color.Set(
      color_fragment.is_null() ? nullptr : color_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->color.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null color in WebView.SetBackgroundColor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("SetBackgroundColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewProxy::NotifyUserActivation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebView::NotifyUserActivation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kNotifyUserActivation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_NotifyUserActivation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("NotifyUserActivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebView_LoadNavigationEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::LoadNavigationEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_LoadNavigationEntries_ProxyToResponder> proxy(
        new WebView_LoadNavigationEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_LoadNavigationEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_LoadNavigationEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_LoadNavigationEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::LoadNavigationEntriesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<NavigationEntryPtr> in_entries, int32_t in_current_index);
};

bool WebView_LoadNavigationEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_LoadNavigationEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_LoadNavigationEntries_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.7
  bool success = true;
  std::vector<NavigationEntryPtr> p_entries{};
  int32_t p_current_index{};
  WebView_LoadNavigationEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (success)
    p_current_index = input_data_view.current_index();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entries), 
std::move(p_current_index));
  }
  return true;
}

void WebView_LoadNavigationEntries_ProxyToResponder::Run(
    std::vector<NavigationEntryPtr> in_entries, int32_t in_current_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::LoadNavigationEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type std::vector<NavigationEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_index"), in_current_index,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kLoadNavigationEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_LoadNavigationEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::NavigationEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

  params->current_index = in_current_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("LoadNavigationEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_EvaluateJavaScript_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::EvaluateJavaScriptCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_EvaluateJavaScript_ProxyToResponder> proxy(
        new WebView_EvaluateJavaScript_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_EvaluateJavaScript_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_EvaluateJavaScript_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_EvaluateJavaScript_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::EvaluateJavaScriptCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);
};

bool WebView_EvaluateJavaScript_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_EvaluateJavaScript_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_EvaluateJavaScript_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.11
  bool success = true;
  ::base::Value p_result{};
  WebView_EvaluateJavaScript_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebView_EvaluateJavaScript_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::EvaluateJavaScript", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kEvaluateJavaScript), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_EvaluateJavaScript_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("EvaluateJavaScript");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_EvaluateJavaScriptWithArguments_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::EvaluateJavaScriptWithArgumentsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_EvaluateJavaScriptWithArguments_ProxyToResponder> proxy(
        new WebView_EvaluateJavaScriptWithArguments_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_EvaluateJavaScriptWithArguments_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_EvaluateJavaScriptWithArguments_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_EvaluateJavaScriptWithArguments_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::EvaluateJavaScriptWithArgumentsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_result);
};

bool WebView_EvaluateJavaScriptWithArguments_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.12
  bool success = true;
  ::base::Value p_result{};
  WebView_EvaluateJavaScriptWithArguments_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebView_EvaluateJavaScriptWithArguments_ProxyToResponder::Run(
    ::base::Value in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::EvaluateJavaScriptWithArguments", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::base::Value>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kEvaluateJavaScriptWithArguments), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("EvaluateJavaScriptWithArguments");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_TakeSnapshot_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::TakeSnapshotCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_TakeSnapshot_ProxyToResponder> proxy(
        new WebView_TakeSnapshot_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_TakeSnapshot_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_TakeSnapshot_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_TakeSnapshot_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::TakeSnapshotCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SnapshotResultPtr in_result);
};

bool WebView_TakeSnapshot_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_TakeSnapshot_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_TakeSnapshot_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.13
  bool success = true;
  SnapshotResultPtr p_result{};
  WebView_TakeSnapshot_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebView_TakeSnapshot_ProxyToResponder::Run(
    SnapshotResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::TakeSnapshot", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SnapshotResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kTakeSnapshot), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_TakeSnapshot_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::owl::mojom::SnapshotResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("TakeSnapshot");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_CaptureCopy_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::CaptureCopyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_CaptureCopy_ProxyToResponder> proxy(
        new WebView_CaptureCopy_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_CaptureCopy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_CaptureCopy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_CaptureCopy_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::CaptureCopyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ClipboardOverridePtr in_contents);
};

bool WebView_CaptureCopy_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_CaptureCopy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_CaptureCopy_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.39
  bool success = true;
  ClipboardOverridePtr p_contents{};
  WebView_CaptureCopy_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadContents(&p_contents))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_contents));
  }
  return true;
}

void WebView_CaptureCopy_ProxyToResponder::Run(
    ClipboardOverridePtr in_contents) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::CaptureCopy", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("contents"), in_contents,
                        "<value of type ClipboardOverridePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kCaptureCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_CaptureCopy_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->contents)::BaseType> contents_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::ClipboardOverrideDataView>(
    in_contents,
    contents_fragment);

  params->contents.Set(
      contents_fragment.is_null() ? nullptr : contents_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->contents.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null contents in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("CaptureCopy");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_InsertViaPaste_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::InsertViaPasteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_InsertViaPaste_ProxyToResponder> proxy(
        new WebView_InsertViaPaste_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_InsertViaPaste_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_InsertViaPaste_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_InsertViaPaste_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::InsertViaPasteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool WebView_InsertViaPaste_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_InsertViaPaste_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_InsertViaPaste_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.40
  bool success = true;
  bool p_success{};
  WebView_InsertViaPaste_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 40, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void WebView_InsertViaPaste_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::InsertViaPaste", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kInsertViaPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_InsertViaPaste_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("InsertViaPaste");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_FetchCertificateChain_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::FetchCertificateChainCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_FetchCertificateChain_ProxyToResponder> proxy(
        new WebView_FetchCertificateChain_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_FetchCertificateChain_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_FetchCertificateChain_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_FetchCertificateChain_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::FetchCertificateChainCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CertificateChainPtr in_certificate);
};

bool WebView_FetchCertificateChain_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_FetchCertificateChain_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_FetchCertificateChain_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.43
  bool success = true;
  CertificateChainPtr p_certificate{};
  WebView_FetchCertificateChain_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCertificate(&p_certificate))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 43, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_certificate));
  }
  return true;
}

void WebView_FetchCertificateChain_ProxyToResponder::Run(
    CertificateChainPtr in_certificate) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::FetchCertificateChain", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificate"), in_certificate,
                        "<value of type CertificateChainPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kFetchCertificateChain), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_FetchCertificateChain_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificate)::BaseType> certificate_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CertificateChainDataView>(
    in_certificate,
    certificate_fragment);

  params->certificate.Set(
      certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificate.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificate in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("FetchCertificateChain");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_ExtractAnnotatedText_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::ExtractAnnotatedTextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_ExtractAnnotatedText_ProxyToResponder> proxy(
        new WebView_ExtractAnnotatedText_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_ExtractAnnotatedText_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_ExtractAnnotatedText_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_ExtractAnnotatedText_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::ExtractAnnotatedTextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_text);
};

bool WebView_ExtractAnnotatedText_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_ExtractAnnotatedText_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_ExtractAnnotatedText_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.45
  bool success = true;
  std::string p_text{};
  WebView_ExtractAnnotatedText_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 45, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_text));
  }
  return true;
}

void WebView_ExtractAnnotatedText_ProxyToResponder::Run(
    const std::string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::ExtractAnnotatedText", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kExtractAnnotatedText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ExtractAnnotatedText_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ExtractAnnotatedText");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_ExtractSerializedDom_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::ExtractSerializedDomCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_ExtractSerializedDom_ProxyToResponder> proxy(
        new WebView_ExtractSerializedDom_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_ExtractSerializedDom_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_ExtractSerializedDom_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_ExtractSerializedDom_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::ExtractSerializedDomCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_text);
};

bool WebView_ExtractSerializedDom_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_ExtractSerializedDom_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_ExtractSerializedDom_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.46
  bool success = true;
  std::string p_text{};
  WebView_ExtractSerializedDom_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadText(&p_text))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 46, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_text));
  }
  return true;
}

void WebView_ExtractSerializedDom_ProxyToResponder::Run(
    const std::string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::ExtractSerializedDom", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kExtractSerializedDom), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ExtractSerializedDom_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ExtractSerializedDom");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebView_ExtractSerializedDomElementInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebView::ExtractSerializedDomElementInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebView_ExtractSerializedDomElementInfo_ProxyToResponder> proxy(
        new WebView_ExtractSerializedDomElementInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebView_ExtractSerializedDomElementInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebView_ExtractSerializedDomElementInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebView_ExtractSerializedDomElementInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebView::ExtractSerializedDomElementInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SerializedDomElementInfoPtr in_info);
};

bool WebView_ExtractSerializedDomElementInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebView_ExtractSerializedDomElementInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebView_ExtractSerializedDomElementInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebView.47
  bool success = true;
  SerializedDomElementInfoPtr p_info{};
  WebView_ExtractSerializedDomElementInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebView::Name_, 47, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void WebView_ExtractSerializedDomElementInfo_ProxyToResponder::Run(
    SerializedDomElementInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebView::ExtractSerializedDomElementInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type SerializedDomElementInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebView::kExtractSerializedDomElementInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebView_ExtractSerializedDomElementInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::SerializedDomElementInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebView::Name_);
  message.set_method_name("ExtractSerializedDomElementInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebViewStubDispatch::Accept(
    WebView* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebView>(message->header()->name)) {
    case messages::WebView::kMoveToGroup: {
      DCHECK(message->is_serialized());
      internal::WebView_MoveToGroup_Params_Data* params =
          reinterpret_cast<internal::WebView_MoveToGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.0
      bool success = true;
      std::string p_group_id{};
      WebView_MoveToGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveToGroup(        
        std::move(p_group_id));
      return true;
    }
    case messages::WebView::kNavigateTo: {
      DCHECK(message->is_serialized());
      internal::WebView_NavigateTo_Params_Data* params =
          reinterpret_cast<internal::WebView_NavigateTo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.1
      bool success = true;
      ::GURL p_url{};
      NavigationType p_type{};
      std::string p_additional_headers{};
      WebView_NavigateTo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadAdditionalHeaders(&p_additional_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateTo(        
        std::move(p_url), 
        std::move(p_type), 
        std::move(p_additional_headers));
      return true;
    }
    case messages::WebView::kSetStoragePartition: {
      DCHECK(message->is_serialized());
      internal::WebView_SetStoragePartition_Params_Data* params =
          reinterpret_cast<internal::WebView_SetStoragePartition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.2
      bool success = true;
      StoragePartitionDescriptorPtr p_partition{};
      WebView_SetStoragePartition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPartition(&p_partition))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetStoragePartition(        
        std::move(p_partition));
      return true;
    }
    case messages::WebView::kCloseNow: {
      DCHECK(message->is_serialized());
      internal::WebView_CloseNow_Params_Data* params =
          reinterpret_cast<internal::WebView_CloseNow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.3
      bool success = true;
      WebView_CloseNow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseNow(        );
      return true;
    }
    case messages::WebView::kGoBack: {
      DCHECK(message->is_serialized());
      internal::WebView_GoBack_Params_Data* params =
          reinterpret_cast<internal::WebView_GoBack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.4
      bool success = true;
      WebView_GoBack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoBack(        );
      return true;
    }
    case messages::WebView::kGoForward: {
      DCHECK(message->is_serialized());
      internal::WebView_GoForward_Params_Data* params =
          reinterpret_cast<internal::WebView_GoForward_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.5
      bool success = true;
      WebView_GoForward_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoForward(        );
      return true;
    }
    case messages::WebView::kGoToNavigationEntry: {
      DCHECK(message->is_serialized());
      internal::WebView_GoToNavigationEntry_Params_Data* params =
          reinterpret_cast<internal::WebView_GoToNavigationEntry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.6
      bool success = true;
      int32_t p_navigation_entry_id{};
      WebView_GoToNavigationEntry_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_navigation_entry_id = input_data_view.navigation_entry_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoToNavigationEntry(        
        std::move(p_navigation_entry_id));
      return true;
    }
    case messages::WebView::kLoadNavigationEntries: {
      break;
    }
    case messages::WebView::kClearForwardHistory: {
      DCHECK(message->is_serialized());
      internal::WebView_ClearForwardHistory_Params_Data* params =
          reinterpret_cast<internal::WebView_ClearForwardHistory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.8
      bool success = true;
      WebView_ClearForwardHistory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearForwardHistory(        );
      return true;
    }
    case messages::WebView::kStop: {
      DCHECK(message->is_serialized());
      internal::WebView_Stop_Params_Data* params =
          reinterpret_cast<internal::WebView_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.9
      bool success = true;
      WebView_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        );
      return true;
    }
    case messages::WebView::kReload: {
      DCHECK(message->is_serialized());
      internal::WebView_Reload_Params_Data* params =
          reinterpret_cast<internal::WebView_Reload_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.10
      bool success = true;
      bool p_skip_cache{};
      WebView_Reload_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_skip_cache = input_data_view.skip_cache();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reload(        
        std::move(p_skip_cache));
      return true;
    }
    case messages::WebView::kEvaluateJavaScript: {
      break;
    }
    case messages::WebView::kEvaluateJavaScriptWithArguments: {
      break;
    }
    case messages::WebView::kTakeSnapshot: {
      break;
    }
    case messages::WebView::kFindInPage: {
      DCHECK(message->is_serialized());
      internal::WebView_FindInPage_Params_Data* params =
          reinterpret_cast<internal::WebView_FindInPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.14
      bool success = true;
      std::string p_text{};
      FindDirection p_direction{};
      ::mojo::PendingAssociatedRemote<FindClient> p_client{};
      WebView_FindInPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FindInPage(        
        std::move(p_text), 
        std::move(p_direction), 
        std::move(p_client));
      return true;
    }
    case messages::WebView::kCancelFindInPage: {
      DCHECK(message->is_serialized());
      internal::WebView_CancelFindInPage_Params_Data* params =
          reinterpret_cast<internal::WebView_CancelFindInPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.15
      bool success = true;
      WebView_CancelFindInPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelFindInPage(        );
      return true;
    }
    case messages::WebView::kSetForeground: {
      DCHECK(message->is_serialized());
      internal::WebView_SetForeground_Params_Data* params =
          reinterpret_cast<internal::WebView_SetForeground_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.16
      bool success = true;
      bool p_foreground{};
      WebView_SetForeground_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_foreground = input_data_view.foreground();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetForeground(        
        std::move(p_foreground));
      return true;
    }
    case messages::WebView::kSetAuthenticationURLScheme: {
      DCHECK(message->is_serialized());
      internal::WebView_SetAuthenticationURLScheme_Params_Data* params =
          reinterpret_cast<internal::WebView_SetAuthenticationURLScheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.17
      bool success = true;
      std::string p_scheme{};
      WebView_SetAuthenticationURLScheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScheme(&p_scheme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAuthenticationURLScheme(        
        std::move(p_scheme));
      return true;
    }
    case messages::WebView::kCreateDevToolsSession: {
      DCHECK(message->is_serialized());
      internal::WebView_CreateDevToolsSession_Params_Data* params =
          reinterpret_cast<internal::WebView_CreateDevToolsSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.18
      bool success = true;
      ::mojo::PendingAssociatedReceiver<DevToolsSession> p_session{};
      ::mojo::PendingAssociatedRemote<DevToolsSessionClient> p_client{};
      WebView_CreateDevToolsSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDevToolsSession(        
        std::move(p_session), 
        std::move(p_client));
      return true;
    }
    case messages::WebView::kOpenDevTools: {
      DCHECK(message->is_serialized());
      internal::WebView_OpenDevTools_Params_Data* params =
          reinterpret_cast<internal::WebView_OpenDevTools_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.19
      bool success = true;
      DevToolsPanel p_panel{};
      DOMElementReferencePtr p_dom_element{};
      WebView_OpenDevTools_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPanel(&p_panel))
        success = false;
      if (success && !input_data_view.ReadDomElement(&p_dom_element))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDevTools(        
        std::move(p_panel), 
        std::move(p_dom_element));
      return true;
    }
    case messages::WebView::kZoomIn: {
      DCHECK(message->is_serialized());
      internal::WebView_ZoomIn_Params_Data* params =
          reinterpret_cast<internal::WebView_ZoomIn_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.20
      bool success = true;
      WebView_ZoomIn_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomIn(        );
      return true;
    }
    case messages::WebView::kZoomOut: {
      DCHECK(message->is_serialized());
      internal::WebView_ZoomOut_Params_Data* params =
          reinterpret_cast<internal::WebView_ZoomOut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.21
      bool success = true;
      WebView_ZoomOut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomOut(        );
      return true;
    }
    case messages::WebView::kResetZoom: {
      DCHECK(message->is_serialized());
      internal::WebView_ResetZoom_Params_Data* params =
          reinterpret_cast<internal::WebView_ResetZoom_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.22
      bool success = true;
      WebView_ResetZoom_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetZoom(        );
      return true;
    }
    case messages::WebView::kMute: {
      DCHECK(message->is_serialized());
      internal::WebView_Mute_Params_Data* params =
          reinterpret_cast<internal::WebView_Mute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.23
      bool success = true;
      WebView_Mute_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Mute(        );
      return true;
    }
    case messages::WebView::kUnmute: {
      DCHECK(message->is_serialized());
      internal::WebView_Unmute_Params_Data* params =
          reinterpret_cast<internal::WebView_Unmute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.24
      bool success = true;
      WebView_Unmute_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unmute(        );
      return true;
    }
    case messages::WebView::kCopyImage: {
      DCHECK(message->is_serialized());
      internal::WebView_CopyImage_Params_Data* params =
          reinterpret_cast<internal::WebView_CopyImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.25
      bool success = true;
      int32_t p_frame_routing_id{};
      int32_t p_frame_process_id{};
      int32_t p_x{};
      int32_t p_y{};
      WebView_CopyImage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_frame_routing_id = input_data_view.frame_routing_id();
      if (success)
        p_frame_process_id = input_data_view.frame_process_id();
      if (success)
        p_x = input_data_view.x();
      if (success)
        p_y = input_data_view.y();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyImage(        
        std::move(p_frame_routing_id), 
        std::move(p_frame_process_id), 
        std::move(p_x), 
        std::move(p_y));
      return true;
    }
    case messages::WebView::kSaveMedia: {
      DCHECK(message->is_serialized());
      internal::WebView_SaveMedia_Params_Data* params =
          reinterpret_cast<internal::WebView_SaveMedia_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.26
      bool success = true;
      ::owl::mojom::ContextMenuParamsPtr p_params{};
      WebView_SaveMedia_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveMedia(        
        std::move(p_params));
      return true;
    }
    case messages::WebView::kLoopPlayback: {
      DCHECK(message->is_serialized());
      internal::WebView_LoopPlayback_Params_Data* params =
          reinterpret_cast<internal::WebView_LoopPlayback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.27
      bool success = true;
      ::owl::mojom::ContextMenuParamsPtr p_params{};
      bool p_loop_playback{};
      WebView_LoopPlayback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_loop_playback = input_data_view.loop_playback();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoopPlayback(        
        std::move(p_params), 
        std::move(p_loop_playback));
      return true;
    }
    case messages::WebView::kShowPlaybackControls: {
      DCHECK(message->is_serialized());
      internal::WebView_ShowPlaybackControls_Params_Data* params =
          reinterpret_cast<internal::WebView_ShowPlaybackControls_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.28
      bool success = true;
      ::owl::mojom::ContextMenuParamsPtr p_params{};
      bool p_show_playback_controls{};
      WebView_ShowPlaybackControls_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_show_playback_controls = input_data_view.show_playback_controls();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPlaybackControls(        
        std::move(p_params), 
        std::move(p_show_playback_controls));
      return true;
    }
    case messages::WebView::kCopyVideoFrame: {
      DCHECK(message->is_serialized());
      internal::WebView_CopyVideoFrame_Params_Data* params =
          reinterpret_cast<internal::WebView_CopyVideoFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.29
      bool success = true;
      ::owl::mojom::ContextMenuParamsPtr p_params{};
      WebView_CopyVideoFrame_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyVideoFrame(        
        std::move(p_params));
      return true;
    }
    case messages::WebView::kShowInPictureInPicture: {
      DCHECK(message->is_serialized());
      internal::WebView_ShowInPictureInPicture_Params_Data* params =
          reinterpret_cast<internal::WebView_ShowInPictureInPicture_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.30
      bool success = true;
      ::owl::mojom::ContextMenuParamsPtr p_params{};
      bool p_show_in_picture_in_picture{};
      WebView_ShowInPictureInPicture_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success)
        p_show_in_picture_in_picture = input_data_view.show_in_picture_in_picture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowInPictureInPicture(        
        std::move(p_params), 
        std::move(p_show_in_picture_in_picture));
      return true;
    }
    case messages::WebView::kUndo: {
      DCHECK(message->is_serialized());
      internal::WebView_Undo_Params_Data* params =
          reinterpret_cast<internal::WebView_Undo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.31
      bool success = true;
      WebView_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(        );
      return true;
    }
    case messages::WebView::kRedo: {
      DCHECK(message->is_serialized());
      internal::WebView_Redo_Params_Data* params =
          reinterpret_cast<internal::WebView_Redo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.32
      bool success = true;
      WebView_Redo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Redo(        );
      return true;
    }
    case messages::WebView::kCut: {
      DCHECK(message->is_serialized());
      internal::WebView_Cut_Params_Data* params =
          reinterpret_cast<internal::WebView_Cut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.33
      bool success = true;
      WebView_Cut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cut(        );
      return true;
    }
    case messages::WebView::kCopy: {
      DCHECK(message->is_serialized());
      internal::WebView_Copy_Params_Data* params =
          reinterpret_cast<internal::WebView_Copy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.34
      bool success = true;
      WebView_Copy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Copy(        );
      return true;
    }
    case messages::WebView::kPaste: {
      DCHECK(message->is_serialized());
      internal::WebView_Paste_Params_Data* params =
          reinterpret_cast<internal::WebView_Paste_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.35
      bool success = true;
      WebView_Paste_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Paste(        );
      return true;
    }
    case messages::WebView::kSelectAll: {
      DCHECK(message->is_serialized());
      internal::WebView_SelectAll_Params_Data* params =
          reinterpret_cast<internal::WebView_SelectAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.36
      bool success = true;
      WebView_SelectAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAll(        );
      return true;
    }
    case messages::WebView::kReplaceMisspelledWord: {
      DCHECK(message->is_serialized());
      internal::WebView_ReplaceMisspelledWord_Params_Data* params =
          reinterpret_cast<internal::WebView_ReplaceMisspelledWord_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.37
      bool success = true;
      ::std::u16string p_replacement{};
      WebView_ReplaceMisspelledWord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReplacement(&p_replacement))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReplaceMisspelledWord(        
        std::move(p_replacement));
      return true;
    }
    case messages::WebView::kAddToDictionary: {
      DCHECK(message->is_serialized());
      internal::WebView_AddToDictionary_Params_Data* params =
          reinterpret_cast<internal::WebView_AddToDictionary_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.38
      bool success = true;
      ::std::u16string p_word{};
      WebView_AddToDictionary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWord(&p_word))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddToDictionary(        
        std::move(p_word));
      return true;
    }
    case messages::WebView::kCaptureCopy: {
      break;
    }
    case messages::WebView::kInsertViaPaste: {
      break;
    }
    case messages::WebView::kSetCancelOffOriginLinkLoads: {
      DCHECK(message->is_serialized());
      internal::WebView_SetCancelOffOriginLinkLoads_Params_Data* params =
          reinterpret_cast<internal::WebView_SetCancelOffOriginLinkLoads_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.41
      bool success = true;
      bool p_cancel_off_origin_link_loads{};
      WebView_SetCancelOffOriginLinkLoads_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_cancel_off_origin_link_loads = input_data_view.cancel_off_origin_link_loads();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 41, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCancelOffOriginLinkLoads(        
        std::move(p_cancel_off_origin_link_loads));
      return true;
    }
    case messages::WebView::kForceRendererCrash: {
      DCHECK(message->is_serialized());
      internal::WebView_ForceRendererCrash_Params_Data* params =
          reinterpret_cast<internal::WebView_ForceRendererCrash_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.42
      bool success = true;
      WebView_ForceRendererCrash_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 42, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceRendererCrash(        );
      return true;
    }
    case messages::WebView::kFetchCertificateChain: {
      break;
    }
    case messages::WebView::kDisablePasswordManagement: {
      DCHECK(message->is_serialized());
      internal::WebView_DisablePasswordManagement_Params_Data* params =
          reinterpret_cast<internal::WebView_DisablePasswordManagement_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.44
      bool success = true;
      WebView_DisablePasswordManagement_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisablePasswordManagement(        );
      return true;
    }
    case messages::WebView::kExtractAnnotatedText: {
      break;
    }
    case messages::WebView::kExtractSerializedDom: {
      break;
    }
    case messages::WebView::kExtractSerializedDomElementInfo: {
      break;
    }
    case messages::WebView::kWillExitFullScreenMode: {
      DCHECK(message->is_serialized());
      internal::WebView_WillExitFullScreenMode_Params_Data* params =
          reinterpret_cast<internal::WebView_WillExitFullScreenMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.48
      bool success = true;
      WebView_WillExitFullScreenMode_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 48, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WillExitFullScreenMode(        );
      return true;
    }
    case messages::WebView::kRequestPrintPreview: {
      DCHECK(message->is_serialized());
      internal::WebView_RequestPrintPreview_Params_Data* params =
          reinterpret_cast<internal::WebView_RequestPrintPreview_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.49
      bool success = true;
      WebView_RequestPrintPreview_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 49, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPrintPreview(        );
      return true;
    }
    case messages::WebView::kRegisterProtocolHandler: {
      DCHECK(message->is_serialized());
      internal::WebView_RegisterProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::WebView_RegisterProtocolHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.50
      bool success = true;
      WebView_RegisterProtocolHandler_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 50, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterProtocolHandler(        );
      return true;
    }
    case messages::WebView::kSetBackgroundColor: {
      DCHECK(message->is_serialized());
      internal::WebView_SetBackgroundColor_Params_Data* params =
          reinterpret_cast<internal::WebView_SetBackgroundColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.51
      bool success = true;
      ::SkColor p_color{};
      WebView_SetBackgroundColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadColor(&p_color))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 51, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundColor(        
        std::move(p_color));
      return true;
    }
    case messages::WebView::kNotifyUserActivation: {
      DCHECK(message->is_serialized());
      internal::WebView_NotifyUserActivation_Params_Data* params =
          reinterpret_cast<internal::WebView_NotifyUserActivation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebView.52
      bool success = true;
      WebView_NotifyUserActivation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 52, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyUserActivation(        );
      return true;
    }
  }
  return false;
}

// static
bool WebViewStubDispatch::AcceptWithResponder(
    WebView* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebView>(message->header()->name)) {
    case messages::WebView::kMoveToGroup: {
      break;
    }
    case messages::WebView::kNavigateTo: {
      break;
    }
    case messages::WebView::kSetStoragePartition: {
      break;
    }
    case messages::WebView::kCloseNow: {
      break;
    }
    case messages::WebView::kGoBack: {
      break;
    }
    case messages::WebView::kGoForward: {
      break;
    }
    case messages::WebView::kGoToNavigationEntry: {
      break;
    }
    case messages::WebView::kLoadNavigationEntries: {
      internal::WebView_LoadNavigationEntries_Params_Data* params =
          reinterpret_cast<
              internal::WebView_LoadNavigationEntries_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.7
      bool success = true;
      WebView_LoadNavigationEntries_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 7, false);
        return false;
      }
      auto callback =
          WebView_LoadNavigationEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadNavigationEntries(std::move(callback));
      return true;
    }
    case messages::WebView::kClearForwardHistory: {
      break;
    }
    case messages::WebView::kStop: {
      break;
    }
    case messages::WebView::kReload: {
      break;
    }
    case messages::WebView::kEvaluateJavaScript: {
      internal::WebView_EvaluateJavaScript_Params_Data* params =
          reinterpret_cast<
              internal::WebView_EvaluateJavaScript_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.11
      bool success = true;
      std::string p_script{};
      bool p_use_main_world{};
      WebView_EvaluateJavaScript_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScript(&p_script))
        success = false;
      if (success)
        p_use_main_world = input_data_view.use_main_world();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 11, false);
        return false;
      }
      auto callback =
          WebView_EvaluateJavaScript_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EvaluateJavaScript(        
        std::move(p_script), 
        std::move(p_use_main_world), std::move(callback));
      return true;
    }
    case messages::WebView::kEvaluateJavaScriptWithArguments: {
      internal::WebView_EvaluateJavaScriptWithArguments_Params_Data* params =
          reinterpret_cast<
              internal::WebView_EvaluateJavaScriptWithArguments_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.12
      bool success = true;
      std::string p_script{};
      bool p_use_main_world{};
      base::flat_map<std::string, ::base::Value> p_arguments{};
      bool p_should_await{};
      WebView_EvaluateJavaScriptWithArguments_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScript(&p_script))
        success = false;
      if (success)
        p_use_main_world = input_data_view.use_main_world();
      if (success && !input_data_view.ReadArguments(&p_arguments))
        success = false;
      if (success)
        p_should_await = input_data_view.should_await();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 12, false);
        return false;
      }
      auto callback =
          WebView_EvaluateJavaScriptWithArguments_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EvaluateJavaScriptWithArguments(        
        std::move(p_script), 
        std::move(p_use_main_world), 
        std::move(p_arguments), 
        std::move(p_should_await), std::move(callback));
      return true;
    }
    case messages::WebView::kTakeSnapshot: {
      internal::WebView_TakeSnapshot_Params_Data* params =
          reinterpret_cast<
              internal::WebView_TakeSnapshot_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.13
      bool success = true;
      std::optional<::base::TimeDelta> p_timeout{};
      WebView_TakeSnapshot_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTimeout(&p_timeout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 13, false);
        return false;
      }
      auto callback =
          WebView_TakeSnapshot_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeSnapshot(        
        std::move(p_timeout), std::move(callback));
      return true;
    }
    case messages::WebView::kFindInPage: {
      break;
    }
    case messages::WebView::kCancelFindInPage: {
      break;
    }
    case messages::WebView::kSetForeground: {
      break;
    }
    case messages::WebView::kSetAuthenticationURLScheme: {
      break;
    }
    case messages::WebView::kCreateDevToolsSession: {
      break;
    }
    case messages::WebView::kOpenDevTools: {
      break;
    }
    case messages::WebView::kZoomIn: {
      break;
    }
    case messages::WebView::kZoomOut: {
      break;
    }
    case messages::WebView::kResetZoom: {
      break;
    }
    case messages::WebView::kMute: {
      break;
    }
    case messages::WebView::kUnmute: {
      break;
    }
    case messages::WebView::kCopyImage: {
      break;
    }
    case messages::WebView::kSaveMedia: {
      break;
    }
    case messages::WebView::kLoopPlayback: {
      break;
    }
    case messages::WebView::kShowPlaybackControls: {
      break;
    }
    case messages::WebView::kCopyVideoFrame: {
      break;
    }
    case messages::WebView::kShowInPictureInPicture: {
      break;
    }
    case messages::WebView::kUndo: {
      break;
    }
    case messages::WebView::kRedo: {
      break;
    }
    case messages::WebView::kCut: {
      break;
    }
    case messages::WebView::kCopy: {
      break;
    }
    case messages::WebView::kPaste: {
      break;
    }
    case messages::WebView::kSelectAll: {
      break;
    }
    case messages::WebView::kReplaceMisspelledWord: {
      break;
    }
    case messages::WebView::kAddToDictionary: {
      break;
    }
    case messages::WebView::kCaptureCopy: {
      internal::WebView_CaptureCopy_Params_Data* params =
          reinterpret_cast<
              internal::WebView_CaptureCopy_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.39
      bool success = true;
      WebView_CaptureCopy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 39, false);
        return false;
      }
      auto callback =
          WebView_CaptureCopy_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CaptureCopy(std::move(callback));
      return true;
    }
    case messages::WebView::kInsertViaPaste: {
      internal::WebView_InsertViaPaste_Params_Data* params =
          reinterpret_cast<
              internal::WebView_InsertViaPaste_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.40
      bool success = true;
      ClipboardOverridePtr p_contents{};
      WebView_InsertViaPaste_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContents(&p_contents))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 40, false);
        return false;
      }
      auto callback =
          WebView_InsertViaPaste_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InsertViaPaste(        
        std::move(p_contents), std::move(callback));
      return true;
    }
    case messages::WebView::kSetCancelOffOriginLinkLoads: {
      break;
    }
    case messages::WebView::kForceRendererCrash: {
      break;
    }
    case messages::WebView::kFetchCertificateChain: {
      internal::WebView_FetchCertificateChain_Params_Data* params =
          reinterpret_cast<
              internal::WebView_FetchCertificateChain_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.43
      bool success = true;
      WebView_FetchCertificateChain_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 43, false);
        return false;
      }
      auto callback =
          WebView_FetchCertificateChain_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FetchCertificateChain(std::move(callback));
      return true;
    }
    case messages::WebView::kDisablePasswordManagement: {
      break;
    }
    case messages::WebView::kExtractAnnotatedText: {
      internal::WebView_ExtractAnnotatedText_Params_Data* params =
          reinterpret_cast<
              internal::WebView_ExtractAnnotatedText_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.45
      bool success = true;
      uint64_t p_char_count_goal{};
      WebView_ExtractAnnotatedText_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_char_count_goal = input_data_view.char_count_goal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 45, false);
        return false;
      }
      auto callback =
          WebView_ExtractAnnotatedText_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractAnnotatedText(        
        std::move(p_char_count_goal), std::move(callback));
      return true;
    }
    case messages::WebView::kExtractSerializedDom: {
      internal::WebView_ExtractSerializedDom_Params_Data* params =
          reinterpret_cast<
              internal::WebView_ExtractSerializedDom_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.46
      bool success = true;
      WebView_ExtractSerializedDom_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 46, false);
        return false;
      }
      auto callback =
          WebView_ExtractSerializedDom_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractSerializedDom(std::move(callback));
      return true;
    }
    case messages::WebView::kExtractSerializedDomElementInfo: {
      internal::WebView_ExtractSerializedDomElementInfo_Params_Data* params =
          reinterpret_cast<
              internal::WebView_ExtractSerializedDomElementInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebView.47
      bool success = true;
      std::string p_id{};
      WebView_ExtractSerializedDomElementInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebView::Name_, 47, false);
        return false;
      }
      auto callback =
          WebView_ExtractSerializedDomElementInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractSerializedDomElementInfo(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::WebView::kWillExitFullScreenMode: {
      break;
    }
    case messages::WebView::kRequestPrintPreview: {
      break;
    }
    case messages::WebView::kRegisterProtocolHandler: {
      break;
    }
    case messages::WebView::kSetBackgroundColor: {
      break;
    }
    case messages::WebView::kNotifyUserActivation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebViewValidationInfo[] = {
    { &internal::WebView_MoveToGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_NavigateTo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_SetStoragePartition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_CloseNow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_GoBack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_GoForward_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_GoToNavigationEntry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_LoadNavigationEntries_Params_Data::Validate,
     &internal::WebView_LoadNavigationEntries_ResponseParams_Data::Validate},
    { &internal::WebView_ClearForwardHistory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Stop_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Reload_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_EvaluateJavaScript_Params_Data::Validate,
     &internal::WebView_EvaluateJavaScript_ResponseParams_Data::Validate},
    { &internal::WebView_EvaluateJavaScriptWithArguments_Params_Data::Validate,
     &internal::WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data::Validate},
    { &internal::WebView_TakeSnapshot_Params_Data::Validate,
     &internal::WebView_TakeSnapshot_ResponseParams_Data::Validate},
    { &internal::WebView_FindInPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_CancelFindInPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_SetForeground_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_SetAuthenticationURLScheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_CreateDevToolsSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_OpenDevTools_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ZoomIn_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ZoomOut_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ResetZoom_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Mute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Unmute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_CopyImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_SaveMedia_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_LoopPlayback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ShowPlaybackControls_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_CopyVideoFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ShowInPictureInPicture_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Undo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Redo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Cut_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Copy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_Paste_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_SelectAll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ReplaceMisspelledWord_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_AddToDictionary_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_CaptureCopy_Params_Data::Validate,
     &internal::WebView_CaptureCopy_ResponseParams_Data::Validate},
    { &internal::WebView_InsertViaPaste_Params_Data::Validate,
     &internal::WebView_InsertViaPaste_ResponseParams_Data::Validate},
    { &internal::WebView_SetCancelOffOriginLinkLoads_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ForceRendererCrash_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_FetchCertificateChain_Params_Data::Validate,
     &internal::WebView_FetchCertificateChain_ResponseParams_Data::Validate},
    { &internal::WebView_DisablePasswordManagement_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_ExtractAnnotatedText_Params_Data::Validate,
     &internal::WebView_ExtractAnnotatedText_ResponseParams_Data::Validate},
    { &internal::WebView_ExtractSerializedDom_Params_Data::Validate,
     &internal::WebView_ExtractSerializedDom_ResponseParams_Data::Validate},
    { &internal::WebView_ExtractSerializedDomElementInfo_Params_Data::Validate,
     &internal::WebView_ExtractSerializedDomElementInfo_ResponseParams_Data::Validate},
    { &internal::WebView_WillExitFullScreenMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_RequestPrintPreview_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_RegisterProtocolHandler_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_SetBackgroundColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebView_NotifyUserActivation_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebViewRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebView::Name_,
    kWebViewValidationInfo);
}

bool WebViewResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebView::Name_,
    kWebViewValidationInfo);
}
// The declaration includes the definition on other builds.

TabSharingSession::IPCStableHashFunction TabSharingSession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TabSharingSession>(message.name())) {
    case messages::TabSharingSession::kStartSharingThisTab: {
      return &TabSharingSession::StartSharingThisTab_Sym::IPCStableHash;
    }
    case messages::TabSharingSession::kStopTabSharing: {
      return &TabSharingSession::StopTabSharing_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TabSharingSession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TabSharingSession>(message.name())) {
      case messages::TabSharingSession::kStartSharingThisTab:
            return "Receive owl::mojom::TabSharingSession::StartSharingThisTab";
      case messages::TabSharingSession::kStopTabSharing:
            return "Receive owl::mojom::TabSharingSession::StopTabSharing";
    }
  } else {
    switch (static_cast<messages::TabSharingSession>(message.name())) {
      case messages::TabSharingSession::kStartSharingThisTab:
            return "Receive reply owl::mojom::TabSharingSession::StartSharingThisTab";
      case messages::TabSharingSession::kStopTabSharing:
            return "Receive reply owl::mojom::TabSharingSession::StopTabSharing";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TabSharingSession::StartSharingThisTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25c87bf5;  // IPCStableHash for owl::mojom::TabSharingSession::StartSharingThisTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TabSharingSession::StopTabSharing_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc92f02e;  // IPCStableHash for owl::mojom::TabSharingSession::StopTabSharing
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TabSharingSessionProxy::TabSharingSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TabSharingSessionProxy::StartSharingThisTab(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::TabSharingSession::StartSharingThisTab");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabSharingSession::kStartSharingThisTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::TabSharingSession_StartSharingThisTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabSharingSession::Name_);
  message.set_method_name("StartSharingThisTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TabSharingSessionProxy::StopTabSharing(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::TabSharingSession::StopTabSharing");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TabSharingSession::kStopTabSharing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::TabSharingSession_StopTabSharing_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TabSharingSession::Name_);
  message.set_method_name("StopTabSharing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TabSharingSessionStubDispatch::Accept(
    TabSharingSession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TabSharingSession>(message->header()->name)) {
    case messages::TabSharingSession::kStartSharingThisTab: {
      DCHECK(message->is_serialized());
      internal::TabSharingSession_StartSharingThisTab_Params_Data* params =
          reinterpret_cast<internal::TabSharingSession_StartSharingThisTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TabSharingSession.0
      bool success = true;
      TabSharingSession_StartSharingThisTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabSharingSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSharingThisTab(        );
      return true;
    }
    case messages::TabSharingSession::kStopTabSharing: {
      DCHECK(message->is_serialized());
      internal::TabSharingSession_StopTabSharing_Params_Data* params =
          reinterpret_cast<internal::TabSharingSession_StopTabSharing_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TabSharingSession.1
      bool success = true;
      TabSharingSession_StopTabSharing_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TabSharingSession::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopTabSharing(        );
      return true;
    }
  }
  return false;
}

// static
bool TabSharingSessionStubDispatch::AcceptWithResponder(
    TabSharingSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TabSharingSession>(message->header()->name)) {
    case messages::TabSharingSession::kStartSharingThisTab: {
      break;
    }
    case messages::TabSharingSession::kStopTabSharing: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTabSharingSessionValidationInfo[] = {
    { &internal::TabSharingSession_StartSharingThisTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TabSharingSession_StopTabSharing_Params_Data::Validate,
     nullptr /* no response */},
};

bool TabSharingSessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::TabSharingSession::Name_,
    kTabSharingSessionValidationInfo);
}

// The declaration includes the definition on other builds.

CertSelectionCancellation::IPCStableHashFunction CertSelectionCancellation::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertSelectionCancellation>(message.name())) {
    case messages::CertSelectionCancellation::kCancelCertSelection: {
      return &CertSelectionCancellation::CancelCertSelection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertSelectionCancellation::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertSelectionCancellation>(message.name())) {
      case messages::CertSelectionCancellation::kCancelCertSelection:
            return "Receive owl::mojom::CertSelectionCancellation::CancelCertSelection";
    }
  } else {
    switch (static_cast<messages::CertSelectionCancellation>(message.name())) {
      case messages::CertSelectionCancellation::kCancelCertSelection:
            return "Receive reply owl::mojom::CertSelectionCancellation::CancelCertSelection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertSelectionCancellation::CancelCertSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2204282;  // IPCStableHash for owl::mojom::CertSelectionCancellation::CancelCertSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CertSelectionCancellationProxy::CertSelectionCancellationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertSelectionCancellationProxy::CancelCertSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::CertSelectionCancellation::CancelCertSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertSelectionCancellation::kCancelCertSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::CertSelectionCancellation_CancelCertSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertSelectionCancellation::Name_);
  message.set_method_name("CancelCertSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CertSelectionCancellationStubDispatch::Accept(
    CertSelectionCancellation* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertSelectionCancellation>(message->header()->name)) {
    case messages::CertSelectionCancellation::kCancelCertSelection: {
      DCHECK(message->is_serialized());
      internal::CertSelectionCancellation_CancelCertSelection_Params_Data* params =
          reinterpret_cast<internal::CertSelectionCancellation_CancelCertSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertSelectionCancellation.0
      bool success = true;
      CertSelectionCancellation_CancelCertSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertSelectionCancellation::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelCertSelection(        );
      return true;
    }
  }
  return false;
}

// static
bool CertSelectionCancellationStubDispatch::AcceptWithResponder(
    CertSelectionCancellation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertSelectionCancellation>(message->header()->name)) {
    case messages::CertSelectionCancellation::kCancelCertSelection: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertSelectionCancellationValidationInfo[] = {
    { &internal::CertSelectionCancellation_CancelCertSelection_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertSelectionCancellationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::CertSelectionCancellation::Name_,
    kCertSelectionCancellationValidationInfo);
}

// The declaration includes the definition on other builds.

WebViewClient::IPCStableHashFunction WebViewClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebViewClient>(message.name())) {
    case messages::WebViewClient::kCurrentURLChanged: {
      return &WebViewClient::CurrentURLChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCurrentTitleChanged: {
      return &WebViewClient::CurrentTitleChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCurrentFaviconChanged: {
      return &WebViewClient::CurrentFaviconChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCurrentMimeTypeChanged: {
      return &WebViewClient::CurrentMimeTypeChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCanGoBackForwardChanged: {
      return &WebViewClient::CanGoBackForwardChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kSessionDataChanged: {
      return &WebViewClient::SessionDataChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kDidCommit: {
      return &WebViewClient::DidCommit_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kLoadingStateChanged: {
      return &WebViewClient::LoadingStateChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kUpdateTargetURL: {
      return &WebViewClient::UpdateTargetURL_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kZoomStateChanged: {
      return &WebViewClient::ZoomStateChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kMuteStateChanged: {
      return &WebViewClient::MuteStateChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kOnVisibleSecurityStateChanged: {
      return &WebViewClient::OnVisibleSecurityStateChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowTabSharingButtons: {
      return &WebViewClient::ShowTabSharingButtons_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kRemoveTabSharingButtons: {
      return &WebViewClient::RemoveTabSharingButtons_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kOnCloseRequestedByHost: {
      return &WebViewClient::OnCloseRequestedByHost_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kActivateContent: {
      return &WebViewClient::ActivateContent_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kRenderProcessStatusChanged: {
      return &WebViewClient::RenderProcessStatusChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kPrimaryPageChanged: {
      return &WebViewClient::PrimaryPageChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kSelectClientCert: {
      return &WebViewClient::SelectClientCert_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kRunJavaScriptDialog: {
      return &WebViewClient::RunJavaScriptDialog_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kRunBeforeUnloadDialog: {
      return &WebViewClient::RunBeforeUnloadDialog_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowRepostFormWarningDialog: {
      return &WebViewClient::ShowRepostFormWarningDialog_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kEnterFullScreen: {
      return &WebViewClient::EnterFullScreen_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kExitFullScreen: {
      return &WebViewClient::ExitFullScreen_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kOnAuthenticationURLSchemeFound: {
      return &WebViewClient::OnAuthenticationURLSchemeFound_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCreatedNewWebView: {
      return &WebViewClient::CreatedNewWebView_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kDevToolsDockSideChanged: {
      return &WebViewClient::DevToolsDockSideChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kDevToolsClosed: {
      return &WebViewClient::DevToolsClosed_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kRedispatchKeyEvent: {
      return &WebViewClient::RedispatchKeyEvent_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCreateWindowBridge: {
      return &WebViewClient::CreateWindowBridge_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kBindFrontendHost: {
      return &WebViewClient::BindFrontendHost_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kOnTabRendererDataChanged: {
      return &WebViewClient::OnTabRendererDataChanged_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kOnFocusChangedInPage: {
      return &WebViewClient::OnFocusChangedInPage_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kOnOffOriginLinkLoadCanceled: {
      return &WebViewClient::OnOffOriginLinkLoadCanceled_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kGoBackOrLoadNewTab: {
      return &WebViewClient::GoBackOrLoadNewTab_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowPermissionPrompt: {
      return &WebViewClient::ShowPermissionPrompt_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowSavePasswordPrompt: {
      return &WebViewClient::ShowSavePasswordPrompt_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowSaveAddressPrompt: {
      return &WebViewClient::ShowSaveAddressPrompt_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowSaveCardPrompt: {
      return &WebViewClient::ShowSaveCardPrompt_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kShowAutofillPopup: {
      return &WebViewClient::ShowAutofillPopup_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kSetPreferredSizeFromAutoResize: {
      return &WebViewClient::SetPreferredSizeFromAutoResize_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kDeleteBrowsingData: {
      return &WebViewClient::DeleteBrowsingData_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kCanDeleteHistory: {
      return &WebViewClient::CanDeleteHistory_Sym::IPCStableHash;
    }
    case messages::WebViewClient::kSetHasPendingProtocolHandler: {
      return &WebViewClient::SetHasPendingProtocolHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebViewClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebViewClient>(message.name())) {
      case messages::WebViewClient::kCurrentURLChanged:
            return "Receive owl::mojom::WebViewClient::CurrentURLChanged";
      case messages::WebViewClient::kCurrentTitleChanged:
            return "Receive owl::mojom::WebViewClient::CurrentTitleChanged";
      case messages::WebViewClient::kCurrentFaviconChanged:
            return "Receive owl::mojom::WebViewClient::CurrentFaviconChanged";
      case messages::WebViewClient::kCurrentMimeTypeChanged:
            return "Receive owl::mojom::WebViewClient::CurrentMimeTypeChanged";
      case messages::WebViewClient::kCanGoBackForwardChanged:
            return "Receive owl::mojom::WebViewClient::CanGoBackForwardChanged";
      case messages::WebViewClient::kSessionDataChanged:
            return "Receive owl::mojom::WebViewClient::SessionDataChanged";
      case messages::WebViewClient::kDidCommit:
            return "Receive owl::mojom::WebViewClient::DidCommit";
      case messages::WebViewClient::kLoadingStateChanged:
            return "Receive owl::mojom::WebViewClient::LoadingStateChanged";
      case messages::WebViewClient::kUpdateTargetURL:
            return "Receive owl::mojom::WebViewClient::UpdateTargetURL";
      case messages::WebViewClient::kZoomStateChanged:
            return "Receive owl::mojom::WebViewClient::ZoomStateChanged";
      case messages::WebViewClient::kMuteStateChanged:
            return "Receive owl::mojom::WebViewClient::MuteStateChanged";
      case messages::WebViewClient::kOnVisibleSecurityStateChanged:
            return "Receive owl::mojom::WebViewClient::OnVisibleSecurityStateChanged";
      case messages::WebViewClient::kShowTabSharingButtons:
            return "Receive owl::mojom::WebViewClient::ShowTabSharingButtons";
      case messages::WebViewClient::kRemoveTabSharingButtons:
            return "Receive owl::mojom::WebViewClient::RemoveTabSharingButtons";
      case messages::WebViewClient::kOnCloseRequestedByHost:
            return "Receive owl::mojom::WebViewClient::OnCloseRequestedByHost";
      case messages::WebViewClient::kActivateContent:
            return "Receive owl::mojom::WebViewClient::ActivateContent";
      case messages::WebViewClient::kRenderProcessStatusChanged:
            return "Receive owl::mojom::WebViewClient::RenderProcessStatusChanged";
      case messages::WebViewClient::kPrimaryPageChanged:
            return "Receive owl::mojom::WebViewClient::PrimaryPageChanged";
      case messages::WebViewClient::kSelectClientCert:
            return "Receive owl::mojom::WebViewClient::SelectClientCert";
      case messages::WebViewClient::kRunJavaScriptDialog:
            return "Receive owl::mojom::WebViewClient::RunJavaScriptDialog";
      case messages::WebViewClient::kRunBeforeUnloadDialog:
            return "Receive owl::mojom::WebViewClient::RunBeforeUnloadDialog";
      case messages::WebViewClient::kShowRepostFormWarningDialog:
            return "Receive owl::mojom::WebViewClient::ShowRepostFormWarningDialog";
      case messages::WebViewClient::kEnterFullScreen:
            return "Receive owl::mojom::WebViewClient::EnterFullScreen";
      case messages::WebViewClient::kExitFullScreen:
            return "Receive owl::mojom::WebViewClient::ExitFullScreen";
      case messages::WebViewClient::kOnAuthenticationURLSchemeFound:
            return "Receive owl::mojom::WebViewClient::OnAuthenticationURLSchemeFound";
      case messages::WebViewClient::kCreatedNewWebView:
            return "Receive owl::mojom::WebViewClient::CreatedNewWebView";
      case messages::WebViewClient::kDevToolsDockSideChanged:
            return "Receive owl::mojom::WebViewClient::DevToolsDockSideChanged";
      case messages::WebViewClient::kDevToolsClosed:
            return "Receive owl::mojom::WebViewClient::DevToolsClosed";
      case messages::WebViewClient::kRedispatchKeyEvent:
            return "Receive owl::mojom::WebViewClient::RedispatchKeyEvent";
      case messages::WebViewClient::kCreateWindowBridge:
            return "Receive owl::mojom::WebViewClient::CreateWindowBridge";
      case messages::WebViewClient::kBindFrontendHost:
            return "Receive owl::mojom::WebViewClient::BindFrontendHost";
      case messages::WebViewClient::kOnTabRendererDataChanged:
            return "Receive owl::mojom::WebViewClient::OnTabRendererDataChanged";
      case messages::WebViewClient::kOnFocusChangedInPage:
            return "Receive owl::mojom::WebViewClient::OnFocusChangedInPage";
      case messages::WebViewClient::kOnOffOriginLinkLoadCanceled:
            return "Receive owl::mojom::WebViewClient::OnOffOriginLinkLoadCanceled";
      case messages::WebViewClient::kGoBackOrLoadNewTab:
            return "Receive owl::mojom::WebViewClient::GoBackOrLoadNewTab";
      case messages::WebViewClient::kShowPermissionPrompt:
            return "Receive owl::mojom::WebViewClient::ShowPermissionPrompt";
      case messages::WebViewClient::kShowSavePasswordPrompt:
            return "Receive owl::mojom::WebViewClient::ShowSavePasswordPrompt";
      case messages::WebViewClient::kShowSaveAddressPrompt:
            return "Receive owl::mojom::WebViewClient::ShowSaveAddressPrompt";
      case messages::WebViewClient::kShowSaveCardPrompt:
            return "Receive owl::mojom::WebViewClient::ShowSaveCardPrompt";
      case messages::WebViewClient::kShowAutofillPopup:
            return "Receive owl::mojom::WebViewClient::ShowAutofillPopup";
      case messages::WebViewClient::kSetPreferredSizeFromAutoResize:
            return "Receive owl::mojom::WebViewClient::SetPreferredSizeFromAutoResize";
      case messages::WebViewClient::kDeleteBrowsingData:
            return "Receive owl::mojom::WebViewClient::DeleteBrowsingData";
      case messages::WebViewClient::kCanDeleteHistory:
            return "Receive owl::mojom::WebViewClient::CanDeleteHistory";
      case messages::WebViewClient::kSetHasPendingProtocolHandler:
            return "Receive owl::mojom::WebViewClient::SetHasPendingProtocolHandler";
    }
  } else {
    switch (static_cast<messages::WebViewClient>(message.name())) {
      case messages::WebViewClient::kCurrentURLChanged:
            return "Receive reply owl::mojom::WebViewClient::CurrentURLChanged";
      case messages::WebViewClient::kCurrentTitleChanged:
            return "Receive reply owl::mojom::WebViewClient::CurrentTitleChanged";
      case messages::WebViewClient::kCurrentFaviconChanged:
            return "Receive reply owl::mojom::WebViewClient::CurrentFaviconChanged";
      case messages::WebViewClient::kCurrentMimeTypeChanged:
            return "Receive reply owl::mojom::WebViewClient::CurrentMimeTypeChanged";
      case messages::WebViewClient::kCanGoBackForwardChanged:
            return "Receive reply owl::mojom::WebViewClient::CanGoBackForwardChanged";
      case messages::WebViewClient::kSessionDataChanged:
            return "Receive reply owl::mojom::WebViewClient::SessionDataChanged";
      case messages::WebViewClient::kDidCommit:
            return "Receive reply owl::mojom::WebViewClient::DidCommit";
      case messages::WebViewClient::kLoadingStateChanged:
            return "Receive reply owl::mojom::WebViewClient::LoadingStateChanged";
      case messages::WebViewClient::kUpdateTargetURL:
            return "Receive reply owl::mojom::WebViewClient::UpdateTargetURL";
      case messages::WebViewClient::kZoomStateChanged:
            return "Receive reply owl::mojom::WebViewClient::ZoomStateChanged";
      case messages::WebViewClient::kMuteStateChanged:
            return "Receive reply owl::mojom::WebViewClient::MuteStateChanged";
      case messages::WebViewClient::kOnVisibleSecurityStateChanged:
            return "Receive reply owl::mojom::WebViewClient::OnVisibleSecurityStateChanged";
      case messages::WebViewClient::kShowTabSharingButtons:
            return "Receive reply owl::mojom::WebViewClient::ShowTabSharingButtons";
      case messages::WebViewClient::kRemoveTabSharingButtons:
            return "Receive reply owl::mojom::WebViewClient::RemoveTabSharingButtons";
      case messages::WebViewClient::kOnCloseRequestedByHost:
            return "Receive reply owl::mojom::WebViewClient::OnCloseRequestedByHost";
      case messages::WebViewClient::kActivateContent:
            return "Receive reply owl::mojom::WebViewClient::ActivateContent";
      case messages::WebViewClient::kRenderProcessStatusChanged:
            return "Receive reply owl::mojom::WebViewClient::RenderProcessStatusChanged";
      case messages::WebViewClient::kPrimaryPageChanged:
            return "Receive reply owl::mojom::WebViewClient::PrimaryPageChanged";
      case messages::WebViewClient::kSelectClientCert:
            return "Receive reply owl::mojom::WebViewClient::SelectClientCert";
      case messages::WebViewClient::kRunJavaScriptDialog:
            return "Receive reply owl::mojom::WebViewClient::RunJavaScriptDialog";
      case messages::WebViewClient::kRunBeforeUnloadDialog:
            return "Receive reply owl::mojom::WebViewClient::RunBeforeUnloadDialog";
      case messages::WebViewClient::kShowRepostFormWarningDialog:
            return "Receive reply owl::mojom::WebViewClient::ShowRepostFormWarningDialog";
      case messages::WebViewClient::kEnterFullScreen:
            return "Receive reply owl::mojom::WebViewClient::EnterFullScreen";
      case messages::WebViewClient::kExitFullScreen:
            return "Receive reply owl::mojom::WebViewClient::ExitFullScreen";
      case messages::WebViewClient::kOnAuthenticationURLSchemeFound:
            return "Receive reply owl::mojom::WebViewClient::OnAuthenticationURLSchemeFound";
      case messages::WebViewClient::kCreatedNewWebView:
            return "Receive reply owl::mojom::WebViewClient::CreatedNewWebView";
      case messages::WebViewClient::kDevToolsDockSideChanged:
            return "Receive reply owl::mojom::WebViewClient::DevToolsDockSideChanged";
      case messages::WebViewClient::kDevToolsClosed:
            return "Receive reply owl::mojom::WebViewClient::DevToolsClosed";
      case messages::WebViewClient::kRedispatchKeyEvent:
            return "Receive reply owl::mojom::WebViewClient::RedispatchKeyEvent";
      case messages::WebViewClient::kCreateWindowBridge:
            return "Receive reply owl::mojom::WebViewClient::CreateWindowBridge";
      case messages::WebViewClient::kBindFrontendHost:
            return "Receive reply owl::mojom::WebViewClient::BindFrontendHost";
      case messages::WebViewClient::kOnTabRendererDataChanged:
            return "Receive reply owl::mojom::WebViewClient::OnTabRendererDataChanged";
      case messages::WebViewClient::kOnFocusChangedInPage:
            return "Receive reply owl::mojom::WebViewClient::OnFocusChangedInPage";
      case messages::WebViewClient::kOnOffOriginLinkLoadCanceled:
            return "Receive reply owl::mojom::WebViewClient::OnOffOriginLinkLoadCanceled";
      case messages::WebViewClient::kGoBackOrLoadNewTab:
            return "Receive reply owl::mojom::WebViewClient::GoBackOrLoadNewTab";
      case messages::WebViewClient::kShowPermissionPrompt:
            return "Receive reply owl::mojom::WebViewClient::ShowPermissionPrompt";
      case messages::WebViewClient::kShowSavePasswordPrompt:
            return "Receive reply owl::mojom::WebViewClient::ShowSavePasswordPrompt";
      case messages::WebViewClient::kShowSaveAddressPrompt:
            return "Receive reply owl::mojom::WebViewClient::ShowSaveAddressPrompt";
      case messages::WebViewClient::kShowSaveCardPrompt:
            return "Receive reply owl::mojom::WebViewClient::ShowSaveCardPrompt";
      case messages::WebViewClient::kShowAutofillPopup:
            return "Receive reply owl::mojom::WebViewClient::ShowAutofillPopup";
      case messages::WebViewClient::kSetPreferredSizeFromAutoResize:
            return "Receive reply owl::mojom::WebViewClient::SetPreferredSizeFromAutoResize";
      case messages::WebViewClient::kDeleteBrowsingData:
            return "Receive reply owl::mojom::WebViewClient::DeleteBrowsingData";
      case messages::WebViewClient::kCanDeleteHistory:
            return "Receive reply owl::mojom::WebViewClient::CanDeleteHistory";
      case messages::WebViewClient::kSetHasPendingProtocolHandler:
            return "Receive reply owl::mojom::WebViewClient::SetHasPendingProtocolHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebViewClient::CurrentURLChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe15d57a1;  // IPCStableHash for owl::mojom::WebViewClient::CurrentURLChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CurrentTitleChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xca71b2c4;  // IPCStableHash for owl::mojom::WebViewClient::CurrentTitleChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CurrentFaviconChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2536ade;  // IPCStableHash for owl::mojom::WebViewClient::CurrentFaviconChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CurrentMimeTypeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x906c4224;  // IPCStableHash for owl::mojom::WebViewClient::CurrentMimeTypeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CanGoBackForwardChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf1fc4164;  // IPCStableHash for owl::mojom::WebViewClient::CanGoBackForwardChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::SessionDataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbec9c4c7;  // IPCStableHash for owl::mojom::WebViewClient::SessionDataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::DidCommit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc491f864;  // IPCStableHash for owl::mojom::WebViewClient::DidCommit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::LoadingStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x207406b6;  // IPCStableHash for owl::mojom::WebViewClient::LoadingStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::UpdateTargetURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d037f53;  // IPCStableHash for owl::mojom::WebViewClient::UpdateTargetURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ZoomStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0330c238;  // IPCStableHash for owl::mojom::WebViewClient::ZoomStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::MuteStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fedf8d7;  // IPCStableHash for owl::mojom::WebViewClient::MuteStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::OnVisibleSecurityStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x19020c79;  // IPCStableHash for owl::mojom::WebViewClient::OnVisibleSecurityStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowTabSharingButtons_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x650648ed;  // IPCStableHash for owl::mojom::WebViewClient::ShowTabSharingButtons
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::RemoveTabSharingButtons_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70334af0;  // IPCStableHash for owl::mojom::WebViewClient::RemoveTabSharingButtons
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::OnCloseRequestedByHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3889a2e8;  // IPCStableHash for owl::mojom::WebViewClient::OnCloseRequestedByHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ActivateContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfbf7d72c;  // IPCStableHash for owl::mojom::WebViewClient::ActivateContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::RenderProcessStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x170203d0;  // IPCStableHash for owl::mojom::WebViewClient::RenderProcessStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::PrimaryPageChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7fe5c03f;  // IPCStableHash for owl::mojom::WebViewClient::PrimaryPageChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::SelectClientCert_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7060b9f;  // IPCStableHash for owl::mojom::WebViewClient::SelectClientCert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::RunJavaScriptDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4395083d;  // IPCStableHash for owl::mojom::WebViewClient::RunJavaScriptDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::RunBeforeUnloadDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e1dbbdd;  // IPCStableHash for owl::mojom::WebViewClient::RunBeforeUnloadDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowRepostFormWarningDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74f9d563;  // IPCStableHash for owl::mojom::WebViewClient::ShowRepostFormWarningDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::EnterFullScreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ecf130f;  // IPCStableHash for owl::mojom::WebViewClient::EnterFullScreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ExitFullScreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf0e853b5;  // IPCStableHash for owl::mojom::WebViewClient::ExitFullScreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::OnAuthenticationURLSchemeFound_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x24e90912;  // IPCStableHash for owl::mojom::WebViewClient::OnAuthenticationURLSchemeFound
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CreatedNewWebView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb660804a;  // IPCStableHash for owl::mojom::WebViewClient::CreatedNewWebView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::DevToolsDockSideChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1327220;  // IPCStableHash for owl::mojom::WebViewClient::DevToolsDockSideChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::DevToolsClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xba8bf56e;  // IPCStableHash for owl::mojom::WebViewClient::DevToolsClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::RedispatchKeyEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e320578;  // IPCStableHash for owl::mojom::WebViewClient::RedispatchKeyEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CreateWindowBridge_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52f86803;  // IPCStableHash for owl::mojom::WebViewClient::CreateWindowBridge
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::BindFrontendHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x968e6d5d;  // IPCStableHash for owl::mojom::WebViewClient::BindFrontendHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::OnTabRendererDataChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7b367319;  // IPCStableHash for owl::mojom::WebViewClient::OnTabRendererDataChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::OnFocusChangedInPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8f5cfa8;  // IPCStableHash for owl::mojom::WebViewClient::OnFocusChangedInPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::OnOffOriginLinkLoadCanceled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a01690b;  // IPCStableHash for owl::mojom::WebViewClient::OnOffOriginLinkLoadCanceled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::GoBackOrLoadNewTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b362fa1;  // IPCStableHash for owl::mojom::WebViewClient::GoBackOrLoadNewTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowPermissionPrompt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4072745;  // IPCStableHash for owl::mojom::WebViewClient::ShowPermissionPrompt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowSavePasswordPrompt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d4caac8;  // IPCStableHash for owl::mojom::WebViewClient::ShowSavePasswordPrompt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowSaveAddressPrompt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x995246d5;  // IPCStableHash for owl::mojom::WebViewClient::ShowSaveAddressPrompt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowSaveCardPrompt_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1c8a8c7;  // IPCStableHash for owl::mojom::WebViewClient::ShowSaveCardPrompt
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::ShowAutofillPopup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42869afd;  // IPCStableHash for owl::mojom::WebViewClient::ShowAutofillPopup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::SetPreferredSizeFromAutoResize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d730022;  // IPCStableHash for owl::mojom::WebViewClient::SetPreferredSizeFromAutoResize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::DeleteBrowsingData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdff6e7c2;  // IPCStableHash for owl::mojom::WebViewClient::DeleteBrowsingData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::CanDeleteHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e98efcb;  // IPCStableHash for owl::mojom::WebViewClient::CanDeleteHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebViewClient::SetHasPendingProtocolHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e7ab203;  // IPCStableHash for owl::mojom::WebViewClient::SetHasPendingProtocolHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebViewClient_SelectClientCert_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewClient_SelectClientCert_ForwardToCallback(
      WebViewClient::SelectClientCertCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewClient_SelectClientCert_ForwardToCallback(const WebViewClient_SelectClientCert_ForwardToCallback&) = delete;
  WebViewClient_SelectClientCert_ForwardToCallback& operator=(const WebViewClient_SelectClientCert_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewClient::SelectClientCertCallback callback_;
};

class WebViewClient_RunJavaScriptDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewClient_RunJavaScriptDialog_ForwardToCallback(
      WebViewClient::RunJavaScriptDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewClient_RunJavaScriptDialog_ForwardToCallback(const WebViewClient_RunJavaScriptDialog_ForwardToCallback&) = delete;
  WebViewClient_RunJavaScriptDialog_ForwardToCallback& operator=(const WebViewClient_RunJavaScriptDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewClient::RunJavaScriptDialogCallback callback_;
};

class WebViewClient_RunBeforeUnloadDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewClient_RunBeforeUnloadDialog_ForwardToCallback(
      WebViewClient::RunBeforeUnloadDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewClient_RunBeforeUnloadDialog_ForwardToCallback(const WebViewClient_RunBeforeUnloadDialog_ForwardToCallback&) = delete;
  WebViewClient_RunBeforeUnloadDialog_ForwardToCallback& operator=(const WebViewClient_RunBeforeUnloadDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewClient::RunBeforeUnloadDialogCallback callback_;
};

class WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback(
      WebViewClient::ShowRepostFormWarningDialogCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback(const WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback&) = delete;
  WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback& operator=(const WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewClient::ShowRepostFormWarningDialogCallback callback_;
};

class WebViewClient_EnterFullScreen_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewClient_EnterFullScreen_ForwardToCallback(
      WebViewClient::EnterFullScreenCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewClient_EnterFullScreen_ForwardToCallback(const WebViewClient_EnterFullScreen_ForwardToCallback&) = delete;
  WebViewClient_EnterFullScreen_ForwardToCallback& operator=(const WebViewClient_EnterFullScreen_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewClient::EnterFullScreenCallback callback_;
};

class WebViewClient_CanDeleteHistory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebViewClient_CanDeleteHistory_ForwardToCallback(
      WebViewClient::CanDeleteHistoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebViewClient_CanDeleteHistory_ForwardToCallback(const WebViewClient_CanDeleteHistory_ForwardToCallback&) = delete;
  WebViewClient_CanDeleteHistory_ForwardToCallback& operator=(const WebViewClient_CanDeleteHistory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebViewClient::CanDeleteHistoryCallback callback_;
};

WebViewClientProxy::WebViewClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebViewClientProxy::CurrentURLChanged(
    NavigationEntryUrlPtr in_entryUrl) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CurrentURLChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entryUrl"), in_entryUrl,
                        "<value of type NavigationEntryUrlPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCurrentURLChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CurrentURLChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entryUrl)::BaseType> entryUrl_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::NavigationEntryUrlDataView>(
    in_entryUrl,
    entryUrl_fragment);

  params->entryUrl.Set(
      entryUrl_fragment.is_null() ? nullptr : entryUrl_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CurrentURLChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CurrentTitleChanged(
    const std::optional<::std::u16string>& in_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CurrentTitleChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::optional<::std::u16string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCurrentTitleChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CurrentTitleChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CurrentTitleChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CurrentFaviconChanged(
    const std::optional<::GURL>& in_favicon_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CurrentFaviconChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("favicon_url"), in_favicon_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCurrentFaviconChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CurrentFaviconChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->favicon_url)::BaseType> favicon_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_favicon_url,
    favicon_url_fragment);

  params->favicon_url.Set(
      favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CurrentFaviconChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CurrentMimeTypeChanged(
    const std::string& in_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CurrentMimeTypeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCurrentMimeTypeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CurrentMimeTypeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mime_type,
    mime_type_fragment);

  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mime_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mime_type in WebViewClient.CurrentMimeTypeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CurrentMimeTypeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CanGoBackForwardChanged(
    BackForwardStatePtr in_back_forward_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CanGoBackForwardChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("back_forward_state"), in_back_forward_state,
                        "<value of type BackForwardStatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCanGoBackForwardChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CanGoBackForwardChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->back_forward_state)::BaseType> back_forward_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::BackForwardStateDataView>(
    in_back_forward_state,
    back_forward_state_fragment);

  params->back_forward_state.Set(
      back_forward_state_fragment.is_null() ? nullptr : back_forward_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->back_forward_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null back_forward_state in WebViewClient.CanGoBackForwardChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CanGoBackForwardChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::SessionDataChanged(
    const std::vector<uint8_t>& in_session_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::SessionDataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_data"), in_session_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kSessionDataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_SessionDataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_data)::BaseType>
      session_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& session_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_session_data,
    session_data_fragment,
    &session_data_validate_params);

  params->session_data.Set(
      session_data_fragment.is_null() ? nullptr : session_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_data in WebViewClient.SessionDataChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("SessionDataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::DidCommit(
    CommitDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::DidCommit", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type CommitDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kDidCommit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_DidCommit_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::CommitDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebViewClient.DidCommit request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("DidCommit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::LoadingStateChanged(
    bool in_is_loading, double in_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::LoadingStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress"), in_progress,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kLoadingStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_LoadingStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_loading = in_is_loading;

  params->progress = in_progress;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("LoadingStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::UpdateTargetURL(
    const std::optional<::GURL>& in_target_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::UpdateTargetURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_url"), in_target_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kUpdateTargetURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_UpdateTargetURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->target_url)::BaseType> target_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_target_url,
    target_url_fragment);

  params->target_url.Set(
      target_url_fragment.is_null() ? nullptr : target_url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("UpdateTargetURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ZoomStateChanged(
    bool in_can_zoom_in, bool in_can_zoom_out, bool in_can_reset_zoom) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ZoomStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_zoom_in"), in_can_zoom_in,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_zoom_out"), in_can_zoom_out,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_reset_zoom"), in_can_reset_zoom,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kZoomStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ZoomStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->can_zoom_in = in_can_zoom_in;

  params->can_zoom_out = in_can_zoom_out;

  params->can_reset_zoom = in_can_reset_zoom;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ZoomStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::MuteStateChanged(
    bool in_is_muted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::MuteStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_muted"), in_is_muted,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kMuteStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_MuteStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_muted = in_is_muted;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("MuteStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::OnVisibleSecurityStateChanged(
    SecurityLevel in_security_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::OnVisibleSecurityStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("security_level"), in_security_level,
                        "<value of type SecurityLevel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kOnVisibleSecurityStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_OnVisibleSecurityStateChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::SecurityLevel>(
    in_security_level,
    &params->security_level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("OnVisibleSecurityStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ShowTabSharingButtons(
    uint64_t in_shared_tab_id, uint64_t in_capturer_id, TabSharingTabRole in_role, TabSharingButtonState in_share_this_tab_instead_button_state, ::mojo::PendingAssociatedRemote<TabSharingSession> in_tab_sharing_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ShowTabSharingButtons", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_tab_id"), in_shared_tab_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capturer_id"), in_capturer_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("role"), in_role,
                        "<value of type TabSharingTabRole>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("share_this_tab_instead_button_state"), in_share_this_tab_instead_button_state,
                        "<value of type TabSharingButtonState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_sharing_session"), in_tab_sharing_session,
                        "<value of type ::mojo::PendingAssociatedRemote<TabSharingSession>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowTabSharingButtons), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowTabSharingButtons_Params_Data> params(
          message);
  params.Allocate();

  params->shared_tab_id = in_shared_tab_id;

  params->capturer_id = in_capturer_id;

  
  mojo::internal::Serialize<::owl::mojom::TabSharingTabRole>(
    in_role,
    &params->role);

  
  mojo::internal::Serialize<::owl::mojom::TabSharingButtonState>(
    in_share_this_tab_instead_button_state,
    &params->share_this_tab_instead_button_state);

  
  mojo::internal::Serialize<::owl::mojom::TabSharingSessionAssociatedPtrInfoDataView>(
    in_tab_sharing_session,
    &params->tab_sharing_session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->tab_sharing_session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid tab_sharing_session in WebViewClient.ShowTabSharingButtons request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowTabSharingButtons");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::RemoveTabSharingButtons(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::RemoveTabSharingButtons");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRemoveTabSharingButtons), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RemoveTabSharingButtons_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RemoveTabSharingButtons");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::OnCloseRequestedByHost(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::OnCloseRequestedByHost");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kOnCloseRequestedByHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_OnCloseRequestedByHost_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("OnCloseRequestedByHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ActivateContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::ActivateContent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kActivateContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ActivateContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ActivateContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::RenderProcessStatusChanged(
    RenderProcessStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::RenderProcessStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type RenderProcessStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRenderProcessStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RenderProcessStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::RenderProcessStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RenderProcessStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::PrimaryPageChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::PrimaryPageChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kPrimaryPageChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_PrimaryPageChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("PrimaryPageChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::SelectClientCert(
    const std::string& in_host, uint16_t in_port, std::vector<ClientCertMetadataPtr> in_available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> in_cancellation_receiver, SelectClientCertCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::SelectClientCert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host"), in_host,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("port"), in_port,
                        "<value of type uint16_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available_certs"), in_available_certs,
                        "<value of type std::vector<ClientCertMetadataPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cancellation_receiver"), in_cancellation_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<CertSelectionCancellation>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kSelectClientCert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_SelectClientCert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host)::BaseType> host_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_host,
    host_fragment);

  params->host.Set(
      host_fragment.is_null() ? nullptr : host_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host in WebViewClient.SelectClientCert request");

  params->port = in_port;
  mojo::internal::MessageFragment<
      typename decltype(params->available_certs)::BaseType>
      available_certs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& available_certs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::ClientCertMetadataDataView>>(
    in_available_certs,
    available_certs_fragment,
    &available_certs_validate_params);

  params->available_certs.Set(
      available_certs_fragment.is_null() ? nullptr : available_certs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->available_certs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null available_certs in WebViewClient.SelectClientCert request");

  
  mojo::internal::Serialize<::owl::mojom::CertSelectionCancellationAssociatedRequestDataView>(
    in_cancellation_receiver,
    &params->cancellation_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->cancellation_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid cancellation_receiver in WebViewClient.SelectClientCert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("SelectClientCert");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewClient_SelectClientCert_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewClientProxy::RunJavaScriptDialog(
    const ::GURL& in_requesting_origin, JavaScriptDialogType in_dialog_type, const ::std::u16string& in_message, const ::std::u16string& in_default_prompt, RunJavaScriptDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::RunJavaScriptDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requesting_origin"), in_requesting_origin,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dialog_type"), in_dialog_type,
                        "<value of type JavaScriptDialogType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_prompt"), in_default_prompt,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRunJavaScriptDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RunJavaScriptDialog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requesting_origin)::BaseType> requesting_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_requesting_origin,
    requesting_origin_fragment);

  params->requesting_origin.Set(
      requesting_origin_fragment.is_null() ? nullptr : requesting_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requesting_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requesting_origin in WebViewClient.RunJavaScriptDialog request");

  
  mojo::internal::Serialize<::owl::mojom::JavaScriptDialogType>(
    in_dialog_type,
    &params->dialog_type);
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in WebViewClient.RunJavaScriptDialog request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_prompt)::BaseType> default_prompt_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_default_prompt,
    default_prompt_fragment);

  params->default_prompt.Set(
      default_prompt_fragment.is_null() ? nullptr : default_prompt_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->default_prompt.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null default_prompt in WebViewClient.RunJavaScriptDialog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RunJavaScriptDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewClient_RunJavaScriptDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewClientProxy::RunBeforeUnloadDialog(
    bool in_is_reload, RunBeforeUnloadDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::RunBeforeUnloadDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_reload"), in_is_reload,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRunBeforeUnloadDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RunBeforeUnloadDialog_Params_Data> params(
          message);
  params.Allocate();

  params->is_reload = in_is_reload;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RunBeforeUnloadDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewClient_RunBeforeUnloadDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewClientProxy::ShowRepostFormWarningDialog(
    ShowRepostFormWarningDialogCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::ShowRepostFormWarningDialog");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowRepostFormWarningDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowRepostFormWarningDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowRepostFormWarningDialog");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewClientProxy::EnterFullScreen(
    ::blink::mojom::FullscreenOptionsPtr in_options, EnterFullScreenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::EnterFullScreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kEnterFullScreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_EnterFullScreen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebViewClient.EnterFullScreen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("EnterFullScreen");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewClient_EnterFullScreen_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewClientProxy::ExitFullScreen(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::ExitFullScreen");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kExitFullScreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ExitFullScreen_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ExitFullScreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::OnAuthenticationURLSchemeFound(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::OnAuthenticationURLSchemeFound", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kOnAuthenticationURLSchemeFound), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_OnAuthenticationURLSchemeFound_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebViewClient.OnAuthenticationURLSchemeFound request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("OnAuthenticationURLSchemeFound");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CreatedNewWebView(
    uint64_t in_web_content_id, WebViewDispositionPtr in_disposition, ::mojo::PendingAssociatedRemote<WebView> in_web_view, ::mojo::PendingAssociatedReceiver<WebViewClient> in_web_view_client, const std::optional<std::string>& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CreatedNewWebView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_content_id"), in_web_content_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("disposition"), in_disposition,
                        "<value of type WebViewDispositionPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_view"), in_web_view,
                        "<value of type ::mojo::PendingAssociatedRemote<WebView>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_view_client"), in_web_view_client,
                        "<value of type ::mojo::PendingAssociatedReceiver<WebViewClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCreatedNewWebView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CreatedNewWebView_Params_Data> params(
          message);
  params.Allocate();

  params->web_content_id = in_web_content_id;
  mojo::internal::MessageFragment<decltype(params->disposition)>
      disposition_fragment(params.message());
  disposition_fragment.Claim(&params->disposition);
  
  mojo::internal::Serialize<::owl::mojom::WebViewDispositionDataView>(
    in_disposition,
    disposition_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->disposition.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null disposition in WebViewClient.CreatedNewWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewAssociatedPtrInfoDataView>(
    in_web_view,
    &params->web_view,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->web_view)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid web_view in WebViewClient.CreatedNewWebView request");

  
  mojo::internal::Serialize<::owl::mojom::WebViewClientAssociatedRequestDataView>(
    in_web_view_client,
    &params->web_view_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->web_view_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid web_view_client in WebViewClient.CreatedNewWebView request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CreatedNewWebView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::DevToolsDockSideChanged(
    DevToolsDockSide in_dock_side) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::DevToolsDockSideChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dock_side"), in_dock_side,
                        "<value of type DevToolsDockSide>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kDevToolsDockSideChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_DevToolsDockSideChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::DevToolsDockSide>(
    in_dock_side,
    &params->dock_side);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("DevToolsDockSideChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::DevToolsClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::DevToolsClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kDevToolsClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_DevToolsClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("DevToolsClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::RedispatchKeyEvent(
    const std::vector<uint8_t>& in_native_event_data, ::blink::mojom::InputSource in_original_input_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::RedispatchKeyEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_event_data"), in_native_event_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_input_source"), in_original_input_source,
                        "<value of type ::blink::mojom::InputSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRedispatchKeyEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RedispatchKeyEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->native_event_data)::BaseType>
      native_event_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_native_event_data,
    native_event_data_fragment,
    &native_event_data_validate_params);

  params->native_event_data.Set(
      native_event_data_fragment.is_null() ? nullptr : native_event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_event_data in WebViewClient.RedispatchKeyEvent request");

  
  mojo::internal::Serialize<::blink::mojom::InputSource>(
    in_original_input_source,
    &params->original_input_source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RedispatchKeyEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CreateWindowBridge(
    WindowBridgeSource in_source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CreateWindowBridge", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type WindowBridgeSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCreateWindowBridge), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CreateWindowBridge_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::WindowBridgeSource>(
    in_source,
    &params->source);

  
  mojo::internal::Serialize<::remote_cocoa::mojom::ApplicationAssociatedRequestDataView>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid receiver in WebViewClient.CreateWindowBridge request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CreateWindowBridge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::BindFrontendHost(
    ::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::BindFrontendHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kBindFrontendHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_BindFrontendHost_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::ChatGPTFrontendHostInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in WebViewClient.BindFrontendHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("BindFrontendHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::OnTabRendererDataChanged(
    TabRendererDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::OnTabRendererDataChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type TabRendererDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kOnTabRendererDataChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_OnTabRendererDataChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::TabRendererDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in WebViewClient.OnTabRendererDataChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("OnTabRendererDataChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::OnFocusChangedInPage(
    bool in_focused_element_is_editable, const ::gfx::Rect& in_node_bounds_in_view) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::OnFocusChangedInPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focused_element_is_editable"), in_focused_element_is_editable,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_bounds_in_view"), in_node_bounds_in_view,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kOnFocusChangedInPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_OnFocusChangedInPage_Params_Data> params(
          message);
  params.Allocate();

  params->focused_element_is_editable = in_focused_element_is_editable;
  mojo::internal::MessageFragment<
      typename decltype(params->node_bounds_in_view)::BaseType> node_bounds_in_view_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_node_bounds_in_view,
    node_bounds_in_view_fragment);

  params->node_bounds_in_view.Set(
      node_bounds_in_view_fragment.is_null() ? nullptr : node_bounds_in_view_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_bounds_in_view.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_bounds_in_view in WebViewClient.OnFocusChangedInPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("OnFocusChangedInPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::OnOffOriginLinkLoadCanceled(
    const ::GURL& in_link_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::OnOffOriginLinkLoadCanceled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_url"), in_link_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kOnOffOriginLinkLoadCanceled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->link_url)::BaseType> link_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_link_url,
    link_url_fragment);

  params->link_url.Set(
      link_url_fragment.is_null() ? nullptr : link_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->link_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null link_url in WebViewClient.OnOffOriginLinkLoadCanceled request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("OnOffOriginLinkLoadCanceled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::GoBackOrLoadNewTab(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::GoBackOrLoadNewTab");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kGoBackOrLoadNewTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_GoBackOrLoadNewTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("GoBackOrLoadNewTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ShowPermissionPrompt(
    ::owl::mojom::PermissionPromptDetailsPtr in_details, ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt> in_prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient> in_prompt_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ShowPermissionPrompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::owl::mojom::PermissionPromptDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt"), in_prompt,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt_client"), in_prompt_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowPermissionPrompt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowPermissionPrompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::PermissionPromptDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebViewClient.ShowPermissionPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::PermissionPromptAssociatedRequestDataView>(
    in_prompt,
    &params->prompt,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt in WebViewClient.ShowPermissionPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::PermissionPromptClientAssociatedPtrInfoDataView>(
    in_prompt_client,
    &params->prompt_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt_client in WebViewClient.ShowPermissionPrompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowPermissionPrompt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ShowSavePasswordPrompt(
    ::owl::mojom::SavePasswordPromptDetailsPtr in_details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt> in_prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient> in_prompt_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ShowSavePasswordPrompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::owl::mojom::SavePasswordPromptDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt"), in_prompt,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt_client"), in_prompt_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowSavePasswordPrompt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowSavePasswordPrompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::SavePasswordPromptDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebViewClient.ShowSavePasswordPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::SavePasswordPromptAssociatedRequestDataView>(
    in_prompt,
    &params->prompt,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt in WebViewClient.ShowSavePasswordPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::SavePasswordPromptClientAssociatedPtrInfoDataView>(
    in_prompt_client,
    &params->prompt_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt_client in WebViewClient.ShowSavePasswordPrompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowSavePasswordPrompt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ShowSaveAddressPrompt(
    ::owl::mojom::SaveAddressPromptDetailsPtr in_details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt> in_prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient> in_prompt_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ShowSaveAddressPrompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::owl::mojom::SaveAddressPromptDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt"), in_prompt,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt_client"), in_prompt_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowSaveAddressPrompt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowSaveAddressPrompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::SaveAddressPromptDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebViewClient.ShowSaveAddressPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::SaveAddressPromptAssociatedRequestDataView>(
    in_prompt,
    &params->prompt,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt in WebViewClient.ShowSaveAddressPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::SaveAddressPromptClientAssociatedPtrInfoDataView>(
    in_prompt_client,
    &params->prompt_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt_client in WebViewClient.ShowSaveAddressPrompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowSaveAddressPrompt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ShowSaveCardPrompt(
    ::owl::mojom::SaveCardPromptDetailsPtr in_details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt> in_prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient> in_prompt_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ShowSaveCardPrompt", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::owl::mojom::SaveCardPromptDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt"), in_prompt,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prompt_client"), in_prompt_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowSaveCardPrompt), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowSaveCardPrompt_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::SaveCardPromptDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebViewClient.ShowSaveCardPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::SaveCardPromptAssociatedRequestDataView>(
    in_prompt,
    &params->prompt,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt in WebViewClient.ShowSaveCardPrompt request");

  
  mojo::internal::Serialize<::owl::mojom::SaveCardPromptClientAssociatedPtrInfoDataView>(
    in_prompt_client,
    &params->prompt_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->prompt_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid prompt_client in WebViewClient.ShowSaveCardPrompt request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowSaveCardPrompt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::ShowAutofillPopup(
    ::owl::mojom::AutofillPopupDetailsPtr in_details, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup> in_popup, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient> in_popup_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::ShowAutofillPopup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type ::owl::mojom::AutofillPopupDetailsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup"), in_popup,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_client"), in_popup_client,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowAutofillPopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowAutofillPopup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::AutofillPopupDetailsDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in WebViewClient.ShowAutofillPopup request");

  
  mojo::internal::Serialize<::owl::mojom::AutofillPopupAssociatedRequestDataView>(
    in_popup,
    &params->popup,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->popup)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid popup in WebViewClient.ShowAutofillPopup request");

  
  mojo::internal::Serialize<::owl::mojom::AutofillPopupClientAssociatedPtrInfoDataView>(
    in_popup_client,
    &params->popup_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->popup_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid popup_client in WebViewClient.ShowAutofillPopup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowAutofillPopup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::SetPreferredSizeFromAutoResize(
    const ::gfx::Size& in_new_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::SetPreferredSizeFromAutoResize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_size"), in_new_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kSetPreferredSizeFromAutoResize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_SetPreferredSizeFromAutoResize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_size)::BaseType> new_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_new_size,
    new_size_fragment);

  params->new_size.Set(
      new_size_fragment.is_null() ? nullptr : new_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_size in WebViewClient.SetPreferredSizeFromAutoResize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("SetPreferredSizeFromAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::DeleteBrowsingData(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebViewClient::DeleteBrowsingData");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kDeleteBrowsingData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_DeleteBrowsingData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("DeleteBrowsingData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebViewClientProxy::CanDeleteHistory(
    int32_t in_page_count, CanDeleteHistoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::CanDeleteHistory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_count"), in_page_count,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCanDeleteHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CanDeleteHistory_Params_Data> params(
          message);
  params.Allocate();

  params->page_count = in_page_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CanDeleteHistory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebViewClient_CanDeleteHistory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebViewClientProxy::SetHasPendingProtocolHandler(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebViewClient::SetHasPendingProtocolHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kSetHasPendingProtocolHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_SetHasPendingProtocolHandler_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("SetHasPendingProtocolHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebViewClient_SelectClientCert_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewClient::SelectClientCertCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewClient_SelectClientCert_ProxyToResponder> proxy(
        new WebViewClient_SelectClientCert_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewClient_SelectClientCert_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewClient_SelectClientCert_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewClient_SelectClientCert_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewClient::SelectClientCertCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_index);
};

bool WebViewClient_SelectClientCert_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewClient_SelectClientCert_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewClient_SelectClientCert_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewClient.18
  bool success = true;
  std::optional<uint32_t> p_index{};
  WebViewClient_SelectClientCert_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_index = input_data_view.index();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewClient::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_index));
  }
  return true;
}

void WebViewClient_SelectClientCert_ProxyToResponder::Run(
    std::optional<uint32_t> in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewClient::SelectClientCert", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kSelectClientCert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_SelectClientCert_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->index_$flag = in_index.has_value();
  if (in_index.has_value()) {
    params->index_$value = in_index.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("SelectClientCert");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebViewClient_RunJavaScriptDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewClient::RunJavaScriptDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewClient_RunJavaScriptDialog_ProxyToResponder> proxy(
        new WebViewClient_RunJavaScriptDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewClient_RunJavaScriptDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewClient_RunJavaScriptDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewClient_RunJavaScriptDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewClient::RunJavaScriptDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::std::u16string& in_user_input);
};

bool WebViewClient_RunJavaScriptDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewClient_RunJavaScriptDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewClient_RunJavaScriptDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewClient.19
  bool success = true;
  bool p_success{};
  ::std::u16string p_user_input{};
  WebViewClient_RunJavaScriptDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadUserInput(&p_user_input))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewClient::Name_, 19, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_user_input));
  }
  return true;
}

void WebViewClient_RunJavaScriptDialog_ProxyToResponder::Run(
    bool in_success, const ::std::u16string& in_user_input) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewClient::RunJavaScriptDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_input"), in_user_input,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRunJavaScriptDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RunJavaScriptDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->user_input)::BaseType> user_input_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_user_input,
    user_input_fragment);

  params->user_input.Set(
      user_input_fragment.is_null() ? nullptr : user_input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_input in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RunJavaScriptDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebViewClient_RunBeforeUnloadDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewClient::RunBeforeUnloadDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewClient_RunBeforeUnloadDialog_ProxyToResponder> proxy(
        new WebViewClient_RunBeforeUnloadDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewClient_RunBeforeUnloadDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewClient_RunBeforeUnloadDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewClient_RunBeforeUnloadDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewClient::RunBeforeUnloadDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::std::u16string& in_user_input);
};

bool WebViewClient_RunBeforeUnloadDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewClient.20
  bool success = true;
  bool p_success{};
  ::std::u16string p_user_input{};
  WebViewClient_RunBeforeUnloadDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadUserInput(&p_user_input))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewClient::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_user_input));
  }
  return true;
}

void WebViewClient_RunBeforeUnloadDialog_ProxyToResponder::Run(
    bool in_success, const ::std::u16string& in_user_input) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewClient::RunBeforeUnloadDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_input"), in_user_input,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kRunBeforeUnloadDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->user_input)::BaseType> user_input_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_user_input,
    user_input_fragment);

  params->user_input.Set(
      user_input_fragment.is_null() ? nullptr : user_input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_input in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("RunBeforeUnloadDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewClient::ShowRepostFormWarningDialogCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder> proxy(
        new WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewClient::ShowRepostFormWarningDialogCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RepostFormWarningResponse in_response);
};

bool WebViewClient_ShowRepostFormWarningDialog_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewClient.21
  bool success = true;
  RepostFormWarningResponse p_response{};
  WebViewClient_ShowRepostFormWarningDialog_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewClient::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder::Run(
    RepostFormWarningResponse in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewClient::ShowRepostFormWarningDialog", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type RepostFormWarningResponse>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kShowRepostFormWarningDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::RepostFormWarningResponse>(
    in_response,
    &params->response);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("ShowRepostFormWarningDialog");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebViewClient_EnterFullScreen_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewClient::EnterFullScreenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewClient_EnterFullScreen_ProxyToResponder> proxy(
        new WebViewClient_EnterFullScreen_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewClient_EnterFullScreen_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewClient_EnterFullScreen_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewClient_EnterFullScreen_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewClient::EnterFullScreenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool WebViewClient_EnterFullScreen_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewClient_EnterFullScreen_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewClient_EnterFullScreen_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewClient.22
  bool success = true;
  bool p_success{};
  WebViewClient_EnterFullScreen_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewClient::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void WebViewClient_EnterFullScreen_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewClient::EnterFullScreen", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kEnterFullScreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_EnterFullScreen_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("EnterFullScreen");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebViewClient_CanDeleteHistory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebViewClient::CanDeleteHistoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebViewClient_CanDeleteHistory_ProxyToResponder> proxy(
        new WebViewClient_CanDeleteHistory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebViewClient_CanDeleteHistory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebViewClient_CanDeleteHistory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebViewClient_CanDeleteHistory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebViewClient::CanDeleteHistoryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_deletion_allowed);
};

bool WebViewClient_CanDeleteHistory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebViewClient_CanDeleteHistory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebViewClient_CanDeleteHistory_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebViewClient.42
  bool success = true;
  bool p_is_deletion_allowed{};
  WebViewClient_CanDeleteHistory_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_deletion_allowed = input_data_view.is_deletion_allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebViewClient::Name_, 42, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_deletion_allowed));
  }
  return true;
}

void WebViewClient_CanDeleteHistory_ProxyToResponder::Run(
    bool in_is_deletion_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebViewClient::CanDeleteHistory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_deletion_allowed"), in_is_deletion_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebViewClient::kCanDeleteHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebViewClient_CanDeleteHistory_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_deletion_allowed = in_is_deletion_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebViewClient::Name_);
  message.set_method_name("CanDeleteHistory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebViewClientStubDispatch::Accept(
    WebViewClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebViewClient>(message->header()->name)) {
    case messages::WebViewClient::kCurrentURLChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CurrentURLChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CurrentURLChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.0
      bool success = true;
      NavigationEntryUrlPtr p_entryUrl{};
      WebViewClient_CurrentURLChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntryUrl(&p_entryUrl))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CurrentURLChanged(        
        std::move(p_entryUrl));
      return true;
    }
    case messages::WebViewClient::kCurrentTitleChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CurrentTitleChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CurrentTitleChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.1
      bool success = true;
      std::optional<::std::u16string> p_title{};
      WebViewClient_CurrentTitleChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CurrentTitleChanged(        
        std::move(p_title));
      return true;
    }
    case messages::WebViewClient::kCurrentFaviconChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CurrentFaviconChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CurrentFaviconChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.2
      bool success = true;
      std::optional<::GURL> p_favicon_url{};
      WebViewClient_CurrentFaviconChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFaviconUrl(&p_favicon_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CurrentFaviconChanged(        
        std::move(p_favicon_url));
      return true;
    }
    case messages::WebViewClient::kCurrentMimeTypeChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CurrentMimeTypeChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CurrentMimeTypeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.3
      bool success = true;
      std::string p_mime_type{};
      WebViewClient_CurrentMimeTypeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMimeType(&p_mime_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CurrentMimeTypeChanged(        
        std::move(p_mime_type));
      return true;
    }
    case messages::WebViewClient::kCanGoBackForwardChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CanGoBackForwardChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CanGoBackForwardChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.4
      bool success = true;
      BackForwardStatePtr p_back_forward_state{};
      WebViewClient_CanGoBackForwardChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBackForwardState(&p_back_forward_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanGoBackForwardChanged(        
        std::move(p_back_forward_state));
      return true;
    }
    case messages::WebViewClient::kSessionDataChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_SessionDataChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_SessionDataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.5
      bool success = true;
      std::vector<uint8_t> p_session_data{};
      WebViewClient_SessionDataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionData(&p_session_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SessionDataChanged(        
        std::move(p_session_data));
      return true;
    }
    case messages::WebViewClient::kDidCommit: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_DidCommit_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_DidCommit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.6
      bool success = true;
      CommitDetailsPtr p_details{};
      WebViewClient_DidCommit_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCommit(        
        std::move(p_details));
      return true;
    }
    case messages::WebViewClient::kLoadingStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_LoadingStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_LoadingStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.7
      bool success = true;
      bool p_is_loading{};
      double p_progress{};
      WebViewClient_LoadingStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (success)
        p_progress = input_data_view.progress();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadingStateChanged(        
        std::move(p_is_loading), 
        std::move(p_progress));
      return true;
    }
    case messages::WebViewClient::kUpdateTargetURL: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_UpdateTargetURL_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_UpdateTargetURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.8
      bool success = true;
      std::optional<::GURL> p_target_url{};
      WebViewClient_UpdateTargetURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTargetUrl(&p_target_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTargetURL(        
        std::move(p_target_url));
      return true;
    }
    case messages::WebViewClient::kZoomStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ZoomStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ZoomStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.9
      bool success = true;
      bool p_can_zoom_in{};
      bool p_can_zoom_out{};
      bool p_can_reset_zoom{};
      WebViewClient_ZoomStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_can_zoom_in = input_data_view.can_zoom_in();
      if (success)
        p_can_zoom_out = input_data_view.can_zoom_out();
      if (success)
        p_can_reset_zoom = input_data_view.can_reset_zoom();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomStateChanged(        
        std::move(p_can_zoom_in), 
        std::move(p_can_zoom_out), 
        std::move(p_can_reset_zoom));
      return true;
    }
    case messages::WebViewClient::kMuteStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_MuteStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_MuteStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.10
      bool success = true;
      bool p_is_muted{};
      WebViewClient_MuteStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_muted = input_data_view.is_muted();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MuteStateChanged(        
        std::move(p_is_muted));
      return true;
    }
    case messages::WebViewClient::kOnVisibleSecurityStateChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_OnVisibleSecurityStateChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_OnVisibleSecurityStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.11
      bool success = true;
      SecurityLevel p_security_level{};
      WebViewClient_OnVisibleSecurityStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSecurityLevel(&p_security_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnVisibleSecurityStateChanged(        
        std::move(p_security_level));
      return true;
    }
    case messages::WebViewClient::kShowTabSharingButtons: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ShowTabSharingButtons_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ShowTabSharingButtons_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.12
      bool success = true;
      uint64_t p_shared_tab_id{};
      uint64_t p_capturer_id{};
      TabSharingTabRole p_role{};
      TabSharingButtonState p_share_this_tab_instead_button_state{};
      ::mojo::PendingAssociatedRemote<TabSharingSession> p_tab_sharing_session{};
      WebViewClient_ShowTabSharingButtons_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_shared_tab_id = input_data_view.shared_tab_id();
      if (success)
        p_capturer_id = input_data_view.capturer_id();
      if (success && !input_data_view.ReadRole(&p_role))
        success = false;
      if (success && !input_data_view.ReadShareThisTabInsteadButtonState(&p_share_this_tab_instead_button_state))
        success = false;
      if (success) {
        p_tab_sharing_session =
            input_data_view.TakeTabSharingSession<decltype(p_tab_sharing_session)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowTabSharingButtons(        
        std::move(p_shared_tab_id), 
        std::move(p_capturer_id), 
        std::move(p_role), 
        std::move(p_share_this_tab_instead_button_state), 
        std::move(p_tab_sharing_session));
      return true;
    }
    case messages::WebViewClient::kRemoveTabSharingButtons: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_RemoveTabSharingButtons_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_RemoveTabSharingButtons_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.13
      bool success = true;
      WebViewClient_RemoveTabSharingButtons_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveTabSharingButtons(        );
      return true;
    }
    case messages::WebViewClient::kOnCloseRequestedByHost: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_OnCloseRequestedByHost_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_OnCloseRequestedByHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.14
      bool success = true;
      WebViewClient_OnCloseRequestedByHost_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCloseRequestedByHost(        );
      return true;
    }
    case messages::WebViewClient::kActivateContent: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ActivateContent_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ActivateContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.15
      bool success = true;
      WebViewClient_ActivateContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateContent(        );
      return true;
    }
    case messages::WebViewClient::kRenderProcessStatusChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_RenderProcessStatusChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_RenderProcessStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.16
      bool success = true;
      RenderProcessStatus p_status{};
      WebViewClient_RenderProcessStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderProcessStatusChanged(        
        std::move(p_status));
      return true;
    }
    case messages::WebViewClient::kPrimaryPageChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_PrimaryPageChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_PrimaryPageChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.17
      bool success = true;
      WebViewClient_PrimaryPageChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrimaryPageChanged(        );
      return true;
    }
    case messages::WebViewClient::kSelectClientCert: {
      break;
    }
    case messages::WebViewClient::kRunJavaScriptDialog: {
      break;
    }
    case messages::WebViewClient::kRunBeforeUnloadDialog: {
      break;
    }
    case messages::WebViewClient::kShowRepostFormWarningDialog: {
      break;
    }
    case messages::WebViewClient::kEnterFullScreen: {
      break;
    }
    case messages::WebViewClient::kExitFullScreen: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ExitFullScreen_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ExitFullScreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.23
      bool success = true;
      WebViewClient_ExitFullScreen_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExitFullScreen(        );
      return true;
    }
    case messages::WebViewClient::kOnAuthenticationURLSchemeFound: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_OnAuthenticationURLSchemeFound_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_OnAuthenticationURLSchemeFound_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.24
      bool success = true;
      ::GURL p_url{};
      WebViewClient_OnAuthenticationURLSchemeFound_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthenticationURLSchemeFound(        
        std::move(p_url));
      return true;
    }
    case messages::WebViewClient::kCreatedNewWebView: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CreatedNewWebView_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CreatedNewWebView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.25
      bool success = true;
      uint64_t p_web_content_id{};
      WebViewDispositionPtr p_disposition{};
      ::mojo::PendingAssociatedRemote<WebView> p_web_view{};
      ::mojo::PendingAssociatedReceiver<WebViewClient> p_web_view_client{};
      std::optional<std::string> p_group_id{};
      WebViewClient_CreatedNewWebView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_web_content_id = input_data_view.web_content_id();
      if (success && !input_data_view.ReadDisposition(&p_disposition))
        success = false;
      if (success) {
        p_web_view =
            input_data_view.TakeWebView<decltype(p_web_view)>();
      }
      if (success) {
        p_web_view_client =
            input_data_view.TakeWebViewClient<decltype(p_web_view_client)>();
      }
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatedNewWebView(        
        std::move(p_web_content_id), 
        std::move(p_disposition), 
        std::move(p_web_view), 
        std::move(p_web_view_client), 
        std::move(p_group_id));
      return true;
    }
    case messages::WebViewClient::kDevToolsDockSideChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_DevToolsDockSideChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_DevToolsDockSideChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.26
      bool success = true;
      DevToolsDockSide p_dock_side{};
      WebViewClient_DevToolsDockSideChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDockSide(&p_dock_side))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DevToolsDockSideChanged(        
        std::move(p_dock_side));
      return true;
    }
    case messages::WebViewClient::kDevToolsClosed: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_DevToolsClosed_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_DevToolsClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.27
      bool success = true;
      WebViewClient_DevToolsClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DevToolsClosed(        );
      return true;
    }
    case messages::WebViewClient::kRedispatchKeyEvent: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_RedispatchKeyEvent_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_RedispatchKeyEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.28
      bool success = true;
      std::vector<uint8_t> p_native_event_data{};
      ::blink::mojom::InputSource p_original_input_source{};
      WebViewClient_RedispatchKeyEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNativeEventData(&p_native_event_data))
        success = false;
      if (success && !input_data_view.ReadOriginalInputSource(&p_original_input_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RedispatchKeyEvent(        
        std::move(p_native_event_data), 
        std::move(p_original_input_source));
      return true;
    }
    case messages::WebViewClient::kCreateWindowBridge: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_CreateWindowBridge_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_CreateWindowBridge_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.29
      bool success = true;
      WindowBridgeSource p_source{};
      ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> p_receiver{};
      WebViewClient_CreateWindowBridge_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWindowBridge(        
        std::move(p_source), 
        std::move(p_receiver));
      return true;
    }
    case messages::WebViewClient::kBindFrontendHost: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_BindFrontendHost_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_BindFrontendHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.30
      bool success = true;
      ::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost> p_receiver{};
      WebViewClient_BindFrontendHost_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindFrontendHost(        
        std::move(p_receiver));
      return true;
    }
    case messages::WebViewClient::kOnTabRendererDataChanged: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_OnTabRendererDataChanged_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_OnTabRendererDataChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.31
      bool success = true;
      TabRendererDataPtr p_data{};
      WebViewClient_OnTabRendererDataChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabRendererDataChanged(        
        std::move(p_data));
      return true;
    }
    case messages::WebViewClient::kOnFocusChangedInPage: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_OnFocusChangedInPage_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_OnFocusChangedInPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.32
      bool success = true;
      bool p_focused_element_is_editable{};
      ::gfx::Rect p_node_bounds_in_view{};
      WebViewClient_OnFocusChangedInPage_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_focused_element_is_editable = input_data_view.focused_element_is_editable();
      if (success && !input_data_view.ReadNodeBoundsInView(&p_node_bounds_in_view))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFocusChangedInPage(        
        std::move(p_focused_element_is_editable), 
        std::move(p_node_bounds_in_view));
      return true;
    }
    case messages::WebViewClient::kOnOffOriginLinkLoadCanceled: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.33
      bool success = true;
      ::GURL p_link_url{};
      WebViewClient_OnOffOriginLinkLoadCanceled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLinkUrl(&p_link_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnOffOriginLinkLoadCanceled(        
        std::move(p_link_url));
      return true;
    }
    case messages::WebViewClient::kGoBackOrLoadNewTab: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_GoBackOrLoadNewTab_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_GoBackOrLoadNewTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.34
      bool success = true;
      WebViewClient_GoBackOrLoadNewTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GoBackOrLoadNewTab(        );
      return true;
    }
    case messages::WebViewClient::kShowPermissionPrompt: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ShowPermissionPrompt_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ShowPermissionPrompt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.35
      bool success = true;
      ::owl::mojom::PermissionPromptDetailsPtr p_details{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt> p_prompt{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient> p_prompt_client{};
      WebViewClient_ShowPermissionPrompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success) {
        p_prompt =
            input_data_view.TakePrompt<decltype(p_prompt)>();
      }
      if (success) {
        p_prompt_client =
            input_data_view.TakePromptClient<decltype(p_prompt_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowPermissionPrompt(        
        std::move(p_details), 
        std::move(p_prompt), 
        std::move(p_prompt_client));
      return true;
    }
    case messages::WebViewClient::kShowSavePasswordPrompt: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ShowSavePasswordPrompt_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ShowSavePasswordPrompt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.36
      bool success = true;
      ::owl::mojom::SavePasswordPromptDetailsPtr p_details{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt> p_prompt{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient> p_prompt_client{};
      WebViewClient_ShowSavePasswordPrompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success) {
        p_prompt =
            input_data_view.TakePrompt<decltype(p_prompt)>();
      }
      if (success) {
        p_prompt_client =
            input_data_view.TakePromptClient<decltype(p_prompt_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSavePasswordPrompt(        
        std::move(p_details), 
        std::move(p_prompt), 
        std::move(p_prompt_client));
      return true;
    }
    case messages::WebViewClient::kShowSaveAddressPrompt: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ShowSaveAddressPrompt_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ShowSaveAddressPrompt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.37
      bool success = true;
      ::owl::mojom::SaveAddressPromptDetailsPtr p_details{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt> p_prompt{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient> p_prompt_client{};
      WebViewClient_ShowSaveAddressPrompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success) {
        p_prompt =
            input_data_view.TakePrompt<decltype(p_prompt)>();
      }
      if (success) {
        p_prompt_client =
            input_data_view.TakePromptClient<decltype(p_prompt_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 37, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSaveAddressPrompt(        
        std::move(p_details), 
        std::move(p_prompt), 
        std::move(p_prompt_client));
      return true;
    }
    case messages::WebViewClient::kShowSaveCardPrompt: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ShowSaveCardPrompt_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ShowSaveCardPrompt_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.38
      bool success = true;
      ::owl::mojom::SaveCardPromptDetailsPtr p_details{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt> p_prompt{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient> p_prompt_client{};
      WebViewClient_ShowSaveCardPrompt_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success) {
        p_prompt =
            input_data_view.TakePrompt<decltype(p_prompt)>();
      }
      if (success) {
        p_prompt_client =
            input_data_view.TakePromptClient<decltype(p_prompt_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSaveCardPrompt(        
        std::move(p_details), 
        std::move(p_prompt), 
        std::move(p_prompt_client));
      return true;
    }
    case messages::WebViewClient::kShowAutofillPopup: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_ShowAutofillPopup_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_ShowAutofillPopup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.39
      bool success = true;
      ::owl::mojom::AutofillPopupDetailsPtr p_details{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup> p_popup{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient> p_popup_client{};
      WebViewClient_ShowAutofillPopup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success) {
        p_popup =
            input_data_view.TakePopup<decltype(p_popup)>();
      }
      if (success) {
        p_popup_client =
            input_data_view.TakePopupClient<decltype(p_popup_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowAutofillPopup(        
        std::move(p_details), 
        std::move(p_popup), 
        std::move(p_popup_client));
      return true;
    }
    case messages::WebViewClient::kSetPreferredSizeFromAutoResize: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_SetPreferredSizeFromAutoResize_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_SetPreferredSizeFromAutoResize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.40
      bool success = true;
      ::gfx::Size p_new_size{};
      WebViewClient_SetPreferredSizeFromAutoResize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNewSize(&p_new_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 40, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreferredSizeFromAutoResize(        
        std::move(p_new_size));
      return true;
    }
    case messages::WebViewClient::kDeleteBrowsingData: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_DeleteBrowsingData_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_DeleteBrowsingData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.41
      bool success = true;
      WebViewClient_DeleteBrowsingData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 41, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteBrowsingData(        );
      return true;
    }
    case messages::WebViewClient::kCanDeleteHistory: {
      break;
    }
    case messages::WebViewClient::kSetHasPendingProtocolHandler: {
      DCHECK(message->is_serialized());
      internal::WebViewClient_SetHasPendingProtocolHandler_Params_Data* params =
          reinterpret_cast<internal::WebViewClient_SetHasPendingProtocolHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebViewClient.43
      bool success = true;
      bool p_value{};
      WebViewClient_SetHasPendingProtocolHandler_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasPendingProtocolHandler(        
        std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool WebViewClientStubDispatch::AcceptWithResponder(
    WebViewClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebViewClient>(message->header()->name)) {
    case messages::WebViewClient::kCurrentURLChanged: {
      break;
    }
    case messages::WebViewClient::kCurrentTitleChanged: {
      break;
    }
    case messages::WebViewClient::kCurrentFaviconChanged: {
      break;
    }
    case messages::WebViewClient::kCurrentMimeTypeChanged: {
      break;
    }
    case messages::WebViewClient::kCanGoBackForwardChanged: {
      break;
    }
    case messages::WebViewClient::kSessionDataChanged: {
      break;
    }
    case messages::WebViewClient::kDidCommit: {
      break;
    }
    case messages::WebViewClient::kLoadingStateChanged: {
      break;
    }
    case messages::WebViewClient::kUpdateTargetURL: {
      break;
    }
    case messages::WebViewClient::kZoomStateChanged: {
      break;
    }
    case messages::WebViewClient::kMuteStateChanged: {
      break;
    }
    case messages::WebViewClient::kOnVisibleSecurityStateChanged: {
      break;
    }
    case messages::WebViewClient::kShowTabSharingButtons: {
      break;
    }
    case messages::WebViewClient::kRemoveTabSharingButtons: {
      break;
    }
    case messages::WebViewClient::kOnCloseRequestedByHost: {
      break;
    }
    case messages::WebViewClient::kActivateContent: {
      break;
    }
    case messages::WebViewClient::kRenderProcessStatusChanged: {
      break;
    }
    case messages::WebViewClient::kPrimaryPageChanged: {
      break;
    }
    case messages::WebViewClient::kSelectClientCert: {
      internal::WebViewClient_SelectClientCert_Params_Data* params =
          reinterpret_cast<
              internal::WebViewClient_SelectClientCert_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewClient.18
      bool success = true;
      std::string p_host{};
      uint16_t p_port{};
      std::vector<ClientCertMetadataPtr> p_available_certs{};
      ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> p_cancellation_receiver{};
      WebViewClient_SelectClientCert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success)
        p_port = input_data_view.port();
      if (success && !input_data_view.ReadAvailableCerts(&p_available_certs))
        success = false;
      if (success) {
        p_cancellation_receiver =
            input_data_view.TakeCancellationReceiver<decltype(p_cancellation_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 18, false);
        return false;
      }
      auto callback =
          WebViewClient_SelectClientCert_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectClientCert(        
        std::move(p_host), 
        std::move(p_port), 
        std::move(p_available_certs), 
        std::move(p_cancellation_receiver), std::move(callback));
      return true;
    }
    case messages::WebViewClient::kRunJavaScriptDialog: {
      internal::WebViewClient_RunJavaScriptDialog_Params_Data* params =
          reinterpret_cast<
              internal::WebViewClient_RunJavaScriptDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewClient.19
      bool success = true;
      ::GURL p_requesting_origin{};
      JavaScriptDialogType p_dialog_type{};
      ::std::u16string p_message{};
      ::std::u16string p_default_prompt{};
      WebViewClient_RunJavaScriptDialog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestingOrigin(&p_requesting_origin))
        success = false;
      if (success && !input_data_view.ReadDialogType(&p_dialog_type))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadDefaultPrompt(&p_default_prompt))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 19, false);
        return false;
      }
      auto callback =
          WebViewClient_RunJavaScriptDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunJavaScriptDialog(        
        std::move(p_requesting_origin), 
        std::move(p_dialog_type), 
        std::move(p_message), 
        std::move(p_default_prompt), std::move(callback));
      return true;
    }
    case messages::WebViewClient::kRunBeforeUnloadDialog: {
      internal::WebViewClient_RunBeforeUnloadDialog_Params_Data* params =
          reinterpret_cast<
              internal::WebViewClient_RunBeforeUnloadDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewClient.20
      bool success = true;
      bool p_is_reload{};
      WebViewClient_RunBeforeUnloadDialog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_reload = input_data_view.is_reload();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 20, false);
        return false;
      }
      auto callback =
          WebViewClient_RunBeforeUnloadDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RunBeforeUnloadDialog(        
        std::move(p_is_reload), std::move(callback));
      return true;
    }
    case messages::WebViewClient::kShowRepostFormWarningDialog: {
      internal::WebViewClient_ShowRepostFormWarningDialog_Params_Data* params =
          reinterpret_cast<
              internal::WebViewClient_ShowRepostFormWarningDialog_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewClient.21
      bool success = true;
      WebViewClient_ShowRepostFormWarningDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 21, false);
        return false;
      }
      auto callback =
          WebViewClient_ShowRepostFormWarningDialog_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowRepostFormWarningDialog(std::move(callback));
      return true;
    }
    case messages::WebViewClient::kEnterFullScreen: {
      internal::WebViewClient_EnterFullScreen_Params_Data* params =
          reinterpret_cast<
              internal::WebViewClient_EnterFullScreen_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewClient.22
      bool success = true;
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      WebViewClient_EnterFullScreen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 22, false);
        return false;
      }
      auto callback =
          WebViewClient_EnterFullScreen_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnterFullScreen(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::WebViewClient::kExitFullScreen: {
      break;
    }
    case messages::WebViewClient::kOnAuthenticationURLSchemeFound: {
      break;
    }
    case messages::WebViewClient::kCreatedNewWebView: {
      break;
    }
    case messages::WebViewClient::kDevToolsDockSideChanged: {
      break;
    }
    case messages::WebViewClient::kDevToolsClosed: {
      break;
    }
    case messages::WebViewClient::kRedispatchKeyEvent: {
      break;
    }
    case messages::WebViewClient::kCreateWindowBridge: {
      break;
    }
    case messages::WebViewClient::kBindFrontendHost: {
      break;
    }
    case messages::WebViewClient::kOnTabRendererDataChanged: {
      break;
    }
    case messages::WebViewClient::kOnFocusChangedInPage: {
      break;
    }
    case messages::WebViewClient::kOnOffOriginLinkLoadCanceled: {
      break;
    }
    case messages::WebViewClient::kGoBackOrLoadNewTab: {
      break;
    }
    case messages::WebViewClient::kShowPermissionPrompt: {
      break;
    }
    case messages::WebViewClient::kShowSavePasswordPrompt: {
      break;
    }
    case messages::WebViewClient::kShowSaveAddressPrompt: {
      break;
    }
    case messages::WebViewClient::kShowSaveCardPrompt: {
      break;
    }
    case messages::WebViewClient::kShowAutofillPopup: {
      break;
    }
    case messages::WebViewClient::kSetPreferredSizeFromAutoResize: {
      break;
    }
    case messages::WebViewClient::kDeleteBrowsingData: {
      break;
    }
    case messages::WebViewClient::kCanDeleteHistory: {
      internal::WebViewClient_CanDeleteHistory_Params_Data* params =
          reinterpret_cast<
              internal::WebViewClient_CanDeleteHistory_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebViewClient.42
      bool success = true;
      int32_t p_page_count{};
      WebViewClient_CanDeleteHistory_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_page_count = input_data_view.page_count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebViewClient::Name_, 42, false);
        return false;
      }
      auto callback =
          WebViewClient_CanDeleteHistory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanDeleteHistory(        
        std::move(p_page_count), std::move(callback));
      return true;
    }
    case messages::WebViewClient::kSetHasPendingProtocolHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebViewClientValidationInfo[] = {
    { &internal::WebViewClient_CurrentURLChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CurrentTitleChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CurrentFaviconChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CurrentMimeTypeChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CanGoBackForwardChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_SessionDataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_DidCommit_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_LoadingStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_UpdateTargetURL_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ZoomStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_MuteStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_OnVisibleSecurityStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ShowTabSharingButtons_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_RemoveTabSharingButtons_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_OnCloseRequestedByHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ActivateContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_RenderProcessStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_PrimaryPageChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_SelectClientCert_Params_Data::Validate,
     &internal::WebViewClient_SelectClientCert_ResponseParams_Data::Validate},
    { &internal::WebViewClient_RunJavaScriptDialog_Params_Data::Validate,
     &internal::WebViewClient_RunJavaScriptDialog_ResponseParams_Data::Validate},
    { &internal::WebViewClient_RunBeforeUnloadDialog_Params_Data::Validate,
     &internal::WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data::Validate},
    { &internal::WebViewClient_ShowRepostFormWarningDialog_Params_Data::Validate,
     &internal::WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data::Validate},
    { &internal::WebViewClient_EnterFullScreen_Params_Data::Validate,
     &internal::WebViewClient_EnterFullScreen_ResponseParams_Data::Validate},
    { &internal::WebViewClient_ExitFullScreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_OnAuthenticationURLSchemeFound_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CreatedNewWebView_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_DevToolsDockSideChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_DevToolsClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_RedispatchKeyEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CreateWindowBridge_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_BindFrontendHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_OnTabRendererDataChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_OnFocusChangedInPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_GoBackOrLoadNewTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ShowPermissionPrompt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ShowSavePasswordPrompt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ShowSaveAddressPrompt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ShowSaveCardPrompt_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_ShowAutofillPopup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_SetPreferredSizeFromAutoResize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_DeleteBrowsingData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebViewClient_CanDeleteHistory_Params_Data::Validate,
     &internal::WebViewClient_CanDeleteHistory_ResponseParams_Data::Validate},
    { &internal::WebViewClient_SetHasPendingProtocolHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebViewClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebViewClient::Name_,
    kWebViewClientValidationInfo);
}

bool WebViewClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebViewClient::Name_,
    kWebViewClientValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::FindResult::DataView, ::owl::mojom::FindResultPtr>::Read(
    ::owl::mojom::FindResult::DataView input,
    ::owl::mojom::FindResultPtr* output) {
  bool success = true;
  ::owl::mojom::FindResultPtr result(::owl::mojom::FindResult::New());
  
      if (success)
        result->current_match_index = input.current_match_index();
      if (success)
        result->number_of_matches = input.number_of_matches();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::DOMElementReference::DataView, ::owl::mojom::DOMElementReferencePtr>::Read(
    ::owl::mojom::DOMElementReference::DataView input,
    ::owl::mojom::DOMElementReferencePtr* output) {
  bool success = true;
  ::owl::mojom::DOMElementReferencePtr result(::owl::mojom::DOMElementReference::New());
  
      if (success)
        result->frame_routing_id = input.frame_routing_id();
      if (success)
        result->frame_process_id = input.frame_process_id();
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::NavigationEntry::DataView, ::owl::mojom::NavigationEntryPtr>::Read(
    ::owl::mojom::NavigationEntry::DataView input,
    ::owl::mojom::NavigationEntryPtr* output) {
  bool success = true;
  ::owl::mojom::NavigationEntryPtr result(::owl::mojom::NavigationEntry::New());
  
      if (success)
        result->unique_id = input.unique_id();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::SerializedDomElementInfo::DataView, ::owl::mojom::SerializedDomElementInfoPtr>::Read(
    ::owl::mojom::SerializedDomElementInfo::DataView input,
    ::owl::mojom::SerializedDomElementInfoPtr* output) {
  bool success = true;
  ::owl::mojom::SerializedDomElementInfoPtr result(::owl::mojom::SerializedDomElementInfo::New());
  
      if (success && !input.ReadTag(&result->tag))
        success = false;
      if (success && !input.ReadSelector(&result->selector))
        success = false;
      if (success && !input.ReadVisibleBounds(&result->visible_bounds))
        success = false;
      if (success && !input.ReadClickPoint(&result->click_point))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::TabRendererData::DataView, ::owl::mojom::TabRendererDataPtr>::Read(
    ::owl::mojom::TabRendererData::DataView input,
    ::owl::mojom::TabRendererDataPtr* output) {
  bool success = true;
  ::owl::mojom::TabRendererDataPtr result(::owl::mojom::TabRendererData::New());
  
      if (success)
        result->blocked = input.blocked();
      if (success)
        result->crashed = input.crashed();
      if (success && !input.ReadAlertStates(&result->alert_states))
        success = false;
      if (success && !input.ReadFaviconImage(&result->favicon_image))
        success = false;
      if (success && !input.ReadNetworkState(&result->network_state))
        success = false;
      if (success)
        result->should_hide_loading_throbber = input.should_hide_loading_throbber();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadLastCommittedUrl(&result->last_committed_url))
        success = false;
      if (success && !input.ReadVisibleUrl(&result->visible_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ClipboardOverride::DataView, ::owl::mojom::ClipboardOverridePtr>::Read(
    ::owl::mojom::ClipboardOverride::DataView input,
    ::owl::mojom::ClipboardOverridePtr* output) {
  bool success = true;
  ::owl::mojom::ClipboardOverridePtr result(::owl::mojom::ClipboardOverride::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadHtml(&result->html))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CertificateChain::DataView, ::owl::mojom::CertificateChainPtr>::Read(
    ::owl::mojom::CertificateChain::DataView input,
    ::owl::mojom::CertificateChainPtr* output) {
  bool success = true;
  ::owl::mojom::CertificateChainPtr result(::owl::mojom::CertificateChain::New());
  
      if (success && !input.ReadDerChain(&result->der_chain))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::StoragePartitionDescriptor::DataView, ::owl::mojom::StoragePartitionDescriptorPtr>::Read(
    ::owl::mojom::StoragePartitionDescriptor::DataView input,
    ::owl::mojom::StoragePartitionDescriptorPtr* output) {
  bool success = true;
  ::owl::mojom::StoragePartitionDescriptorPtr result(::owl::mojom::StoragePartitionDescriptor::New());
  
      if (success && !input.ReadPartitionDomain(&result->partition_domain))
        success = false;
      if (success && !input.ReadPartitionName(&result->partition_name))
        success = false;
      if (success)
        result->in_memory = input.in_memory();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ClientCertMetadata::DataView, ::owl::mojom::ClientCertMetadataPtr>::Read(
    ::owl::mojom::ClientCertMetadata::DataView input,
    ::owl::mojom::ClientCertMetadataPtr* output) {
  bool success = true;
  ::owl::mojom::ClientCertMetadataPtr result(::owl::mojom::ClientCertMetadata::New());
  
      if (success && !input.ReadSubject(&result->subject))
        success = false;
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success && !input.ReadSerial(&result->serial))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::PictureInPictureConfig::DataView, ::owl::mojom::PictureInPictureConfigPtr>::Read(
    ::owl::mojom::PictureInPictureConfig::DataView input,
    ::owl::mojom::PictureInPictureConfigPtr* output) {
  bool success = true;
  ::owl::mojom::PictureInPictureConfigPtr result(::owl::mojom::PictureInPictureConfig::New());
  
      if (success && !input.ReadWindowOptions(&result->window_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::WindowOpenContext::DataView, ::owl::mojom::WindowOpenContextPtr>::Read(
    ::owl::mojom::WindowOpenContext::DataView input,
    ::owl::mojom::WindowOpenContextPtr* output) {
  bool success = true;
  ::owl::mojom::WindowOpenContextPtr result(::owl::mojom::WindowOpenContext::New());
  
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success && !input.ReadWindowFeatures(&result->window_features))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::ExtensionPopupContext::DataView, ::owl::mojom::ExtensionPopupContextPtr>::Read(
    ::owl::mojom::ExtensionPopupContext::DataView input,
    ::owl::mojom::ExtensionPopupContextPtr* output) {
  bool success = true;
  ::owl::mojom::ExtensionPopupContextPtr result(::owl::mojom::ExtensionPopupContext::New());
  
      if (success && !input.ReadExtensionId(&result->extension_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::DevToolsContext::DataView, ::owl::mojom::DevToolsContextPtr>::Read(
    ::owl::mojom::DevToolsContext::DataView input,
    ::owl::mojom::DevToolsContextPtr* output) {
  bool success = true;
  ::owl::mojom::DevToolsContextPtr result(::owl::mojom::DevToolsContext::New());
  
      if (success && !input.ReadDockSide(&result->dock_side))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::BackForwardState::DataView, ::owl::mojom::BackForwardStatePtr>::Read(
    ::owl::mojom::BackForwardState::DataView input,
    ::owl::mojom::BackForwardStatePtr* output) {
  bool success = true;
  ::owl::mojom::BackForwardStatePtr result(::owl::mojom::BackForwardState::New());
  
      if (success)
        result->can_go_back = input.can_go_back();
      if (success)
        result->can_go_forward = input.can_go_forward();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::NavigationEntryState::DataView, ::owl::mojom::NavigationEntryStatePtr>::Read(
    ::owl::mojom::NavigationEntryState::DataView input,
    ::owl::mojom::NavigationEntryStatePtr* output) {
  bool success = true;
  ::owl::mojom::NavigationEntryStatePtr result(::owl::mojom::NavigationEntryState::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadBackForwardState(&result->back_forward_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::CommitDetails::DataView, ::owl::mojom::CommitDetailsPtr>::Read(
    ::owl::mojom::CommitDetails::DataView input,
    ::owl::mojom::CommitDetailsPtr* output) {
  bool success = true;
  ::owl::mojom::CommitDetailsPtr result(::owl::mojom::CommitDetails::New());
  
      if (success && !input.ReadTransitionType(&result->transition_type))
        success = false;
      if (success)
        result->is_redirect = input.is_redirect();
      if (success)
        result->is_chatgpt_frontend = input.is_chatgpt_frontend();
      if (success)
        result->did_replace_entry = input.did_replace_entry();
      if (success)
        result->is_same_document = input.is_same_document();
      if (success)
        result->entry_id = input.entry_id();
      if (success && !input.ReadRemovedEntryIds(&result->removed_entry_ids))
        success = false;
      if (success)
        result->main_frame_document_id = input.main_frame_document_id();
      if (success && !input.ReadRemovedMainFrameDocumentIds(&result->removed_main_frame_document_ids))
        success = false;
      if (success && !input.ReadEntryState(&result->entry_state))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::NavigationEntryUrl::DataView, ::owl::mojom::NavigationEntryUrlPtr>::Read(
    ::owl::mojom::NavigationEntryUrl::DataView input,
    ::owl::mojom::NavigationEntryUrlPtr* output) {
  bool success = true;
  ::owl::mojom::NavigationEntryUrlPtr result(::owl::mojom::NavigationEntryUrl::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadRedirectChainStart(&result->redirect_chain_start))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::owl::mojom::SnapshotResult::DataView, ::owl::mojom::SnapshotResultPtr>::Read(
    ::owl::mojom::SnapshotResult::DataView input,
    ::owl::mojom::SnapshotResultPtr* output) {
  using UnionType = ::owl::mojom::SnapshotResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kImage: {
      ::SkBitmap result_image{};
      if (!input.ReadImage(&result_image))
        return false;

      *output = UnionType::NewImage(
          std::move(result_image));
      break;
    }
    case Tag::kError: {
      std::string result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::owl::mojom::WebViewDisposition::DataView, ::owl::mojom::WebViewDispositionPtr>::Read(
    ::owl::mojom::WebViewDisposition::DataView input,
    ::owl::mojom::WebViewDispositionPtr* output) {
  using UnionType = ::owl::mojom::WebViewDisposition;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kWindowOpen: {
      ::owl::mojom::WindowOpenContextPtr result_window_open{};
      if (!input.ReadWindowOpen(&result_window_open))
        return false;

      *output = UnionType::NewWindowOpen(
          std::move(result_window_open));
      break;
    }
    case Tag::kPictureInPicture: {
      ::owl::mojom::PictureInPictureConfigPtr result_picture_in_picture{};
      if (!input.ReadPictureInPicture(&result_picture_in_picture))
        return false;

      *output = UnionType::NewPictureInPicture(
          std::move(result_picture_in_picture));
      break;
    }
    case Tag::kPrintPreview: {
      *output = UnionType::NewPrintPreview(input.print_preview());
      break;
    }
    case Tag::kExtensionPopup: {
      ::owl::mojom::ExtensionPopupContextPtr result_extension_popup{};
      if (!input.ReadExtensionPopup(&result_extension_popup))
        return false;

      *output = UnionType::NewExtensionPopup(
          std::move(result_extension_popup));
      break;
    }
    case Tag::kDevTools: {
      ::owl::mojom::DevToolsContextPtr result_dev_tools{};
      if (!input.ReadDevTools(&result_dev_tools))
        return false;

      *output = UnionType::NewDevTools(
          std::move(result_dev_tools));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void FindClientInterceptorForTesting::OnFindResult(FindResultPtr result) {
  GetForwardingInterface()->OnFindResult(
    std::move(result)
    );
}
FindClientAsyncWaiter::FindClientAsyncWaiter(
    FindClient* proxy) : proxy_(proxy) {}

FindClientAsyncWaiter::~FindClientAsyncWaiter() = default;





void DevToolsSessionInterceptorForTesting::SendProtocolMessage(const std::string& message) {
  GetForwardingInterface()->SendProtocolMessage(
    std::move(message)
    );
}
DevToolsSessionAsyncWaiter::DevToolsSessionAsyncWaiter(
    DevToolsSession* proxy) : proxy_(proxy) {}

DevToolsSessionAsyncWaiter::~DevToolsSessionAsyncWaiter() = default;





void DevToolsSessionClientInterceptorForTesting::OnProtocolMessage(const std::string& message) {
  GetForwardingInterface()->OnProtocolMessage(
    std::move(message)
    );
}
DevToolsSessionClientAsyncWaiter::DevToolsSessionClientAsyncWaiter(
    DevToolsSessionClient* proxy) : proxy_(proxy) {}

DevToolsSessionClientAsyncWaiter::~DevToolsSessionClientAsyncWaiter() = default;





void WebViewInterceptorForTesting::MoveToGroup(const std::string& group_id) {
  GetForwardingInterface()->MoveToGroup(
    std::move(group_id)
    );
}
void WebViewInterceptorForTesting::NavigateTo(const ::GURL& url, NavigationType type, const std::string& additional_headers) {
  GetForwardingInterface()->NavigateTo(
    std::move(url)
    , 
    std::move(type)
    , 
    std::move(additional_headers)
    );
}
void WebViewInterceptorForTesting::SetStoragePartition(StoragePartitionDescriptorPtr partition) {
  GetForwardingInterface()->SetStoragePartition(
    std::move(partition)
    );
}
void WebViewInterceptorForTesting::CloseNow() {
  GetForwardingInterface()->CloseNow();
}
void WebViewInterceptorForTesting::GoBack() {
  GetForwardingInterface()->GoBack();
}
void WebViewInterceptorForTesting::GoForward() {
  GetForwardingInterface()->GoForward();
}
void WebViewInterceptorForTesting::GoToNavigationEntry(int32_t navigation_entry_id) {
  GetForwardingInterface()->GoToNavigationEntry(
    std::move(navigation_entry_id)
    );
}
void WebViewInterceptorForTesting::LoadNavigationEntries(LoadNavigationEntriesCallback callback) {
  GetForwardingInterface()->LoadNavigationEntries(std::move(callback));
}
void WebViewInterceptorForTesting::ClearForwardHistory() {
  GetForwardingInterface()->ClearForwardHistory();
}
void WebViewInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
void WebViewInterceptorForTesting::Reload(bool skip_cache) {
  GetForwardingInterface()->Reload(
    std::move(skip_cache)
    );
}
void WebViewInterceptorForTesting::EvaluateJavaScript(const std::string& script, bool use_main_world, EvaluateJavaScriptCallback callback) {
  GetForwardingInterface()->EvaluateJavaScript(
    std::move(script)
    , 
    std::move(use_main_world)
    , std::move(callback));
}
void WebViewInterceptorForTesting::EvaluateJavaScriptWithArguments(const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await, EvaluateJavaScriptWithArgumentsCallback callback) {
  GetForwardingInterface()->EvaluateJavaScriptWithArguments(
    std::move(script)
    , 
    std::move(use_main_world)
    , 
    std::move(arguments)
    , 
    std::move(should_await)
    , std::move(callback));
}
void WebViewInterceptorForTesting::TakeSnapshot(std::optional<::base::TimeDelta> timeout, TakeSnapshotCallback callback) {
  GetForwardingInterface()->TakeSnapshot(
    std::move(timeout)
    , std::move(callback));
}
void WebViewInterceptorForTesting::FindInPage(const std::string& text, FindDirection direction, ::mojo::PendingAssociatedRemote<FindClient> client) {
  GetForwardingInterface()->FindInPage(
    std::move(text)
    , 
    std::move(direction)
    , 
    std::move(client)
    );
}
void WebViewInterceptorForTesting::CancelFindInPage() {
  GetForwardingInterface()->CancelFindInPage();
}
void WebViewInterceptorForTesting::SetForeground(bool foreground) {
  GetForwardingInterface()->SetForeground(
    std::move(foreground)
    );
}
void WebViewInterceptorForTesting::SetAuthenticationURLScheme(const std::string& scheme) {
  GetForwardingInterface()->SetAuthenticationURLScheme(
    std::move(scheme)
    );
}
void WebViewInterceptorForTesting::CreateDevToolsSession(::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingAssociatedRemote<DevToolsSessionClient> client) {
  GetForwardingInterface()->CreateDevToolsSession(
    std::move(session)
    , 
    std::move(client)
    );
}
void WebViewInterceptorForTesting::OpenDevTools(DevToolsPanel panel, DOMElementReferencePtr dom_element) {
  GetForwardingInterface()->OpenDevTools(
    std::move(panel)
    , 
    std::move(dom_element)
    );
}
void WebViewInterceptorForTesting::ZoomIn() {
  GetForwardingInterface()->ZoomIn();
}
void WebViewInterceptorForTesting::ZoomOut() {
  GetForwardingInterface()->ZoomOut();
}
void WebViewInterceptorForTesting::ResetZoom() {
  GetForwardingInterface()->ResetZoom();
}
void WebViewInterceptorForTesting::Mute() {
  GetForwardingInterface()->Mute();
}
void WebViewInterceptorForTesting::Unmute() {
  GetForwardingInterface()->Unmute();
}
void WebViewInterceptorForTesting::CopyImage(int32_t frame_routing_id, int32_t frame_process_id, int32_t x, int32_t y) {
  GetForwardingInterface()->CopyImage(
    std::move(frame_routing_id)
    , 
    std::move(frame_process_id)
    , 
    std::move(x)
    , 
    std::move(y)
    );
}
void WebViewInterceptorForTesting::SaveMedia(::owl::mojom::ContextMenuParamsPtr params) {
  GetForwardingInterface()->SaveMedia(
    std::move(params)
    );
}
void WebViewInterceptorForTesting::LoopPlayback(::owl::mojom::ContextMenuParamsPtr params, bool loop_playback) {
  GetForwardingInterface()->LoopPlayback(
    std::move(params)
    , 
    std::move(loop_playback)
    );
}
void WebViewInterceptorForTesting::ShowPlaybackControls(::owl::mojom::ContextMenuParamsPtr params, bool show_playback_controls) {
  GetForwardingInterface()->ShowPlaybackControls(
    std::move(params)
    , 
    std::move(show_playback_controls)
    );
}
void WebViewInterceptorForTesting::CopyVideoFrame(::owl::mojom::ContextMenuParamsPtr params) {
  GetForwardingInterface()->CopyVideoFrame(
    std::move(params)
    );
}
void WebViewInterceptorForTesting::ShowInPictureInPicture(::owl::mojom::ContextMenuParamsPtr params, bool show_in_picture_in_picture) {
  GetForwardingInterface()->ShowInPictureInPicture(
    std::move(params)
    , 
    std::move(show_in_picture_in_picture)
    );
}
void WebViewInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void WebViewInterceptorForTesting::Redo() {
  GetForwardingInterface()->Redo();
}
void WebViewInterceptorForTesting::Cut() {
  GetForwardingInterface()->Cut();
}
void WebViewInterceptorForTesting::Copy() {
  GetForwardingInterface()->Copy();
}
void WebViewInterceptorForTesting::Paste() {
  GetForwardingInterface()->Paste();
}
void WebViewInterceptorForTesting::SelectAll() {
  GetForwardingInterface()->SelectAll();
}
void WebViewInterceptorForTesting::ReplaceMisspelledWord(const ::std::u16string& replacement) {
  GetForwardingInterface()->ReplaceMisspelledWord(
    std::move(replacement)
    );
}
void WebViewInterceptorForTesting::AddToDictionary(const ::std::u16string& word) {
  GetForwardingInterface()->AddToDictionary(
    std::move(word)
    );
}
void WebViewInterceptorForTesting::CaptureCopy(CaptureCopyCallback callback) {
  GetForwardingInterface()->CaptureCopy(std::move(callback));
}
void WebViewInterceptorForTesting::InsertViaPaste(ClipboardOverridePtr contents, InsertViaPasteCallback callback) {
  GetForwardingInterface()->InsertViaPaste(
    std::move(contents)
    , std::move(callback));
}
void WebViewInterceptorForTesting::SetCancelOffOriginLinkLoads(bool cancel_off_origin_link_loads) {
  GetForwardingInterface()->SetCancelOffOriginLinkLoads(
    std::move(cancel_off_origin_link_loads)
    );
}
void WebViewInterceptorForTesting::ForceRendererCrash() {
  GetForwardingInterface()->ForceRendererCrash();
}
void WebViewInterceptorForTesting::FetchCertificateChain(FetchCertificateChainCallback callback) {
  GetForwardingInterface()->FetchCertificateChain(std::move(callback));
}
void WebViewInterceptorForTesting::DisablePasswordManagement() {
  GetForwardingInterface()->DisablePasswordManagement();
}
void WebViewInterceptorForTesting::ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) {
  GetForwardingInterface()->ExtractAnnotatedText(
    std::move(char_count_goal)
    , std::move(callback));
}
void WebViewInterceptorForTesting::ExtractSerializedDom(ExtractSerializedDomCallback callback) {
  GetForwardingInterface()->ExtractSerializedDom(std::move(callback));
}
void WebViewInterceptorForTesting::ExtractSerializedDomElementInfo(const std::string& id, ExtractSerializedDomElementInfoCallback callback) {
  GetForwardingInterface()->ExtractSerializedDomElementInfo(
    std::move(id)
    , std::move(callback));
}
void WebViewInterceptorForTesting::WillExitFullScreenMode() {
  GetForwardingInterface()->WillExitFullScreenMode();
}
void WebViewInterceptorForTesting::RequestPrintPreview() {
  GetForwardingInterface()->RequestPrintPreview();
}
void WebViewInterceptorForTesting::RegisterProtocolHandler() {
  GetForwardingInterface()->RegisterProtocolHandler();
}
void WebViewInterceptorForTesting::SetBackgroundColor(::SkColor color) {
  GetForwardingInterface()->SetBackgroundColor(
    std::move(color)
    );
}
void WebViewInterceptorForTesting::NotifyUserActivation() {
  GetForwardingInterface()->NotifyUserActivation();
}
WebViewAsyncWaiter::WebViewAsyncWaiter(
    WebView* proxy) : proxy_(proxy) {}

WebViewAsyncWaiter::~WebViewAsyncWaiter() = default;


void WebViewAsyncWaiter::LoadNavigationEntries(
    std::vector<NavigationEntryPtr>* out_entries, int32_t* out_current_index) {
  base::RunLoop loop;
  proxy_->LoadNavigationEntries(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<NavigationEntryPtr>* out_entries
,
             int32_t* out_current_index
,
             std::vector<NavigationEntryPtr> entries,
             int32_t current_index) {*out_entries = std::move(entries);*out_current_index = std::move(current_index);
            loop->Quit();
          },
          &loop,
          out_entries,
          out_current_index));
  loop.Run();
}



void WebViewAsyncWaiter::EvaluateJavaScript(
    const std::string& script, bool use_main_world, ::base::Value* out_result) {
  base::RunLoop loop;
  proxy_->EvaluateJavaScript(
      std::move(script),
      std::move(use_main_world),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_result
,
             ::base::Value result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::base::Value WebViewAsyncWaiter::EvaluateJavaScript(
    const std::string& script, bool use_main_world) {
  ::base::Value async_wait_result;
  EvaluateJavaScript(std::move(script),std::move(use_main_world),&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::EvaluateJavaScriptWithArguments(
    const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await, ::base::Value* out_result) {
  base::RunLoop loop;
  proxy_->EvaluateJavaScriptWithArguments(
      std::move(script),
      std::move(use_main_world),
      std::move(arguments),
      std::move(should_await),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::Value* out_result
,
             ::base::Value result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::base::Value WebViewAsyncWaiter::EvaluateJavaScriptWithArguments(
    const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await) {
  ::base::Value async_wait_result;
  EvaluateJavaScriptWithArguments(std::move(script),std::move(use_main_world),std::move(arguments),std::move(should_await),&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::TakeSnapshot(
    std::optional<::base::TimeDelta> timeout, SnapshotResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->TakeSnapshot(
      std::move(timeout),
      base::BindOnce(
          [](base::RunLoop* loop,
             SnapshotResultPtr* out_result
,
             SnapshotResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SnapshotResultPtr WebViewAsyncWaiter::TakeSnapshot(
    std::optional<::base::TimeDelta> timeout) {
  SnapshotResultPtr async_wait_result;
  TakeSnapshot(std::move(timeout),&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::CaptureCopy(
    ClipboardOverridePtr* out_contents) {
  base::RunLoop loop;
  proxy_->CaptureCopy(
      base::BindOnce(
          [](base::RunLoop* loop,
             ClipboardOverridePtr* out_contents
,
             ClipboardOverridePtr contents) {*out_contents = std::move(contents);
            loop->Quit();
          },
          &loop,
          out_contents));
  loop.Run();
}

ClipboardOverridePtr WebViewAsyncWaiter::CaptureCopy(
    ) {
  ClipboardOverridePtr async_wait_result;
  CaptureCopy(&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::InsertViaPaste(
    ClipboardOverridePtr contents, bool* out_success) {
  base::RunLoop loop;
  proxy_->InsertViaPaste(
      std::move(contents),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool WebViewAsyncWaiter::InsertViaPaste(
    ClipboardOverridePtr contents) {
  bool async_wait_result;
  InsertViaPaste(std::move(contents),&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::FetchCertificateChain(
    CertificateChainPtr* out_certificate) {
  base::RunLoop loop;
  proxy_->FetchCertificateChain(
      base::BindOnce(
          [](base::RunLoop* loop,
             CertificateChainPtr* out_certificate
,
             CertificateChainPtr certificate) {*out_certificate = std::move(certificate);
            loop->Quit();
          },
          &loop,
          out_certificate));
  loop.Run();
}

CertificateChainPtr WebViewAsyncWaiter::FetchCertificateChain(
    ) {
  CertificateChainPtr async_wait_result;
  FetchCertificateChain(&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::ExtractAnnotatedText(
    uint64_t char_count_goal, std::string* out_text) {
  base::RunLoop loop;
  proxy_->ExtractAnnotatedText(
      std::move(char_count_goal),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_text
,
             const std::string& text) {*out_text = std::move(text);
            loop->Quit();
          },
          &loop,
          out_text));
  loop.Run();
}

std::string WebViewAsyncWaiter::ExtractAnnotatedText(
    uint64_t char_count_goal) {
  std::string async_wait_result;
  ExtractAnnotatedText(std::move(char_count_goal),&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::ExtractSerializedDom(
    std::string* out_text) {
  base::RunLoop loop;
  proxy_->ExtractSerializedDom(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_text
,
             const std::string& text) {*out_text = std::move(text);
            loop->Quit();
          },
          &loop,
          out_text));
  loop.Run();
}

std::string WebViewAsyncWaiter::ExtractSerializedDom(
    ) {
  std::string async_wait_result;
  ExtractSerializedDom(&async_wait_result);
  return async_wait_result;
}

void WebViewAsyncWaiter::ExtractSerializedDomElementInfo(
    const std::string& id, SerializedDomElementInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->ExtractSerializedDomElementInfo(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             SerializedDomElementInfoPtr* out_info
,
             SerializedDomElementInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

SerializedDomElementInfoPtr WebViewAsyncWaiter::ExtractSerializedDomElementInfo(
    const std::string& id) {
  SerializedDomElementInfoPtr async_wait_result;
  ExtractSerializedDomElementInfo(std::move(id),&async_wait_result);
  return async_wait_result;
}




void TabSharingSessionInterceptorForTesting::StartSharingThisTab() {
  GetForwardingInterface()->StartSharingThisTab();
}
void TabSharingSessionInterceptorForTesting::StopTabSharing() {
  GetForwardingInterface()->StopTabSharing();
}
TabSharingSessionAsyncWaiter::TabSharingSessionAsyncWaiter(
    TabSharingSession* proxy) : proxy_(proxy) {}

TabSharingSessionAsyncWaiter::~TabSharingSessionAsyncWaiter() = default;





void CertSelectionCancellationInterceptorForTesting::CancelCertSelection() {
  GetForwardingInterface()->CancelCertSelection();
}
CertSelectionCancellationAsyncWaiter::CertSelectionCancellationAsyncWaiter(
    CertSelectionCancellation* proxy) : proxy_(proxy) {}

CertSelectionCancellationAsyncWaiter::~CertSelectionCancellationAsyncWaiter() = default;





void WebViewClientInterceptorForTesting::CurrentURLChanged(NavigationEntryUrlPtr entryUrl) {
  GetForwardingInterface()->CurrentURLChanged(
    std::move(entryUrl)
    );
}
void WebViewClientInterceptorForTesting::CurrentTitleChanged(const std::optional<::std::u16string>& title) {
  GetForwardingInterface()->CurrentTitleChanged(
    std::move(title)
    );
}
void WebViewClientInterceptorForTesting::CurrentFaviconChanged(const std::optional<::GURL>& favicon_url) {
  GetForwardingInterface()->CurrentFaviconChanged(
    std::move(favicon_url)
    );
}
void WebViewClientInterceptorForTesting::CurrentMimeTypeChanged(const std::string& mime_type) {
  GetForwardingInterface()->CurrentMimeTypeChanged(
    std::move(mime_type)
    );
}
void WebViewClientInterceptorForTesting::CanGoBackForwardChanged(BackForwardStatePtr back_forward_state) {
  GetForwardingInterface()->CanGoBackForwardChanged(
    std::move(back_forward_state)
    );
}
void WebViewClientInterceptorForTesting::SessionDataChanged(const std::vector<uint8_t>& session_data) {
  GetForwardingInterface()->SessionDataChanged(
    std::move(session_data)
    );
}
void WebViewClientInterceptorForTesting::DidCommit(CommitDetailsPtr details) {
  GetForwardingInterface()->DidCommit(
    std::move(details)
    );
}
void WebViewClientInterceptorForTesting::LoadingStateChanged(bool is_loading, double progress) {
  GetForwardingInterface()->LoadingStateChanged(
    std::move(is_loading)
    , 
    std::move(progress)
    );
}
void WebViewClientInterceptorForTesting::UpdateTargetURL(const std::optional<::GURL>& target_url) {
  GetForwardingInterface()->UpdateTargetURL(
    std::move(target_url)
    );
}
void WebViewClientInterceptorForTesting::ZoomStateChanged(bool can_zoom_in, bool can_zoom_out, bool can_reset_zoom) {
  GetForwardingInterface()->ZoomStateChanged(
    std::move(can_zoom_in)
    , 
    std::move(can_zoom_out)
    , 
    std::move(can_reset_zoom)
    );
}
void WebViewClientInterceptorForTesting::MuteStateChanged(bool is_muted) {
  GetForwardingInterface()->MuteStateChanged(
    std::move(is_muted)
    );
}
void WebViewClientInterceptorForTesting::OnVisibleSecurityStateChanged(SecurityLevel security_level) {
  GetForwardingInterface()->OnVisibleSecurityStateChanged(
    std::move(security_level)
    );
}
void WebViewClientInterceptorForTesting::ShowTabSharingButtons(uint64_t shared_tab_id, uint64_t capturer_id, TabSharingTabRole role, TabSharingButtonState share_this_tab_instead_button_state, ::mojo::PendingAssociatedRemote<TabSharingSession> tab_sharing_session) {
  GetForwardingInterface()->ShowTabSharingButtons(
    std::move(shared_tab_id)
    , 
    std::move(capturer_id)
    , 
    std::move(role)
    , 
    std::move(share_this_tab_instead_button_state)
    , 
    std::move(tab_sharing_session)
    );
}
void WebViewClientInterceptorForTesting::RemoveTabSharingButtons() {
  GetForwardingInterface()->RemoveTabSharingButtons();
}
void WebViewClientInterceptorForTesting::OnCloseRequestedByHost() {
  GetForwardingInterface()->OnCloseRequestedByHost();
}
void WebViewClientInterceptorForTesting::ActivateContent() {
  GetForwardingInterface()->ActivateContent();
}
void WebViewClientInterceptorForTesting::RenderProcessStatusChanged(RenderProcessStatus status) {
  GetForwardingInterface()->RenderProcessStatusChanged(
    std::move(status)
    );
}
void WebViewClientInterceptorForTesting::PrimaryPageChanged() {
  GetForwardingInterface()->PrimaryPageChanged();
}
void WebViewClientInterceptorForTesting::SelectClientCert(const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver, SelectClientCertCallback callback) {
  GetForwardingInterface()->SelectClientCert(
    std::move(host)
    , 
    std::move(port)
    , 
    std::move(available_certs)
    , 
    std::move(cancellation_receiver)
    , std::move(callback));
}
void WebViewClientInterceptorForTesting::RunJavaScriptDialog(const ::GURL& requesting_origin, JavaScriptDialogType dialog_type, const ::std::u16string& message, const ::std::u16string& default_prompt, RunJavaScriptDialogCallback callback) {
  GetForwardingInterface()->RunJavaScriptDialog(
    std::move(requesting_origin)
    , 
    std::move(dialog_type)
    , 
    std::move(message)
    , 
    std::move(default_prompt)
    , std::move(callback));
}
void WebViewClientInterceptorForTesting::RunBeforeUnloadDialog(bool is_reload, RunBeforeUnloadDialogCallback callback) {
  GetForwardingInterface()->RunBeforeUnloadDialog(
    std::move(is_reload)
    , std::move(callback));
}
void WebViewClientInterceptorForTesting::ShowRepostFormWarningDialog(ShowRepostFormWarningDialogCallback callback) {
  GetForwardingInterface()->ShowRepostFormWarningDialog(std::move(callback));
}
void WebViewClientInterceptorForTesting::EnterFullScreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullScreenCallback callback) {
  GetForwardingInterface()->EnterFullScreen(
    std::move(options)
    , std::move(callback));
}
void WebViewClientInterceptorForTesting::ExitFullScreen() {
  GetForwardingInterface()->ExitFullScreen();
}
void WebViewClientInterceptorForTesting::OnAuthenticationURLSchemeFound(const ::GURL& url) {
  GetForwardingInterface()->OnAuthenticationURLSchemeFound(
    std::move(url)
    );
}
void WebViewClientInterceptorForTesting::CreatedNewWebView(uint64_t web_content_id, WebViewDispositionPtr disposition, ::mojo::PendingAssociatedRemote<WebView> web_view, ::mojo::PendingAssociatedReceiver<WebViewClient> web_view_client, const std::optional<std::string>& group_id) {
  GetForwardingInterface()->CreatedNewWebView(
    std::move(web_content_id)
    , 
    std::move(disposition)
    , 
    std::move(web_view)
    , 
    std::move(web_view_client)
    , 
    std::move(group_id)
    );
}
void WebViewClientInterceptorForTesting::DevToolsDockSideChanged(DevToolsDockSide dock_side) {
  GetForwardingInterface()->DevToolsDockSideChanged(
    std::move(dock_side)
    );
}
void WebViewClientInterceptorForTesting::DevToolsClosed() {
  GetForwardingInterface()->DevToolsClosed();
}
void WebViewClientInterceptorForTesting::RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data, ::blink::mojom::InputSource original_input_source) {
  GetForwardingInterface()->RedispatchKeyEvent(
    std::move(native_event_data)
    , 
    std::move(original_input_source)
    );
}
void WebViewClientInterceptorForTesting::CreateWindowBridge(WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) {
  GetForwardingInterface()->CreateWindowBridge(
    std::move(source)
    , 
    std::move(receiver)
    );
}
void WebViewClientInterceptorForTesting::BindFrontendHost(::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost> receiver) {
  GetForwardingInterface()->BindFrontendHost(
    std::move(receiver)
    );
}
void WebViewClientInterceptorForTesting::OnTabRendererDataChanged(TabRendererDataPtr data) {
  GetForwardingInterface()->OnTabRendererDataChanged(
    std::move(data)
    );
}
void WebViewClientInterceptorForTesting::OnFocusChangedInPage(bool focused_element_is_editable, const ::gfx::Rect& node_bounds_in_view) {
  GetForwardingInterface()->OnFocusChangedInPage(
    std::move(focused_element_is_editable)
    , 
    std::move(node_bounds_in_view)
    );
}
void WebViewClientInterceptorForTesting::OnOffOriginLinkLoadCanceled(const ::GURL& link_url) {
  GetForwardingInterface()->OnOffOriginLinkLoadCanceled(
    std::move(link_url)
    );
}
void WebViewClientInterceptorForTesting::GoBackOrLoadNewTab() {
  GetForwardingInterface()->GoBackOrLoadNewTab();
}
void WebViewClientInterceptorForTesting::ShowPermissionPrompt(::owl::mojom::PermissionPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient> prompt_client) {
  GetForwardingInterface()->ShowPermissionPrompt(
    std::move(details)
    , 
    std::move(prompt)
    , 
    std::move(prompt_client)
    );
}
void WebViewClientInterceptorForTesting::ShowSavePasswordPrompt(::owl::mojom::SavePasswordPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient> prompt_client) {
  GetForwardingInterface()->ShowSavePasswordPrompt(
    std::move(details)
    , 
    std::move(prompt)
    , 
    std::move(prompt_client)
    );
}
void WebViewClientInterceptorForTesting::ShowSaveAddressPrompt(::owl::mojom::SaveAddressPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient> prompt_client) {
  GetForwardingInterface()->ShowSaveAddressPrompt(
    std::move(details)
    , 
    std::move(prompt)
    , 
    std::move(prompt_client)
    );
}
void WebViewClientInterceptorForTesting::ShowSaveCardPrompt(::owl::mojom::SaveCardPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient> prompt_client) {
  GetForwardingInterface()->ShowSaveCardPrompt(
    std::move(details)
    , 
    std::move(prompt)
    , 
    std::move(prompt_client)
    );
}
void WebViewClientInterceptorForTesting::ShowAutofillPopup(::owl::mojom::AutofillPopupDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup> popup, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient> popup_client) {
  GetForwardingInterface()->ShowAutofillPopup(
    std::move(details)
    , 
    std::move(popup)
    , 
    std::move(popup_client)
    );
}
void WebViewClientInterceptorForTesting::SetPreferredSizeFromAutoResize(const ::gfx::Size& new_size) {
  GetForwardingInterface()->SetPreferredSizeFromAutoResize(
    std::move(new_size)
    );
}
void WebViewClientInterceptorForTesting::DeleteBrowsingData() {
  GetForwardingInterface()->DeleteBrowsingData();
}
void WebViewClientInterceptorForTesting::CanDeleteHistory(int32_t page_count, CanDeleteHistoryCallback callback) {
  GetForwardingInterface()->CanDeleteHistory(
    std::move(page_count)
    , std::move(callback));
}
void WebViewClientInterceptorForTesting::SetHasPendingProtocolHandler(bool value) {
  GetForwardingInterface()->SetHasPendingProtocolHandler(
    std::move(value)
    );
}
WebViewClientAsyncWaiter::WebViewClientAsyncWaiter(
    WebViewClient* proxy) : proxy_(proxy) {}

WebViewClientAsyncWaiter::~WebViewClientAsyncWaiter() = default;


void WebViewClientAsyncWaiter::SelectClientCert(
    const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver, std::optional<uint32_t>* out_index) {
  base::RunLoop loop;
  proxy_->SelectClientCert(
      std::move(host),
      std::move(port),
      std::move(available_certs),
      std::move(cancellation_receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_index
,
             std::optional<uint32_t> index) {*out_index = std::move(index);
            loop->Quit();
          },
          &loop,
          out_index));
  loop.Run();
}

std::optional<uint32_t> WebViewClientAsyncWaiter::SelectClientCert(
    const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver) {
  std::optional<uint32_t> async_wait_result;
  SelectClientCert(std::move(host),std::move(port),std::move(available_certs),std::move(cancellation_receiver),&async_wait_result);
  return async_wait_result;
}

void WebViewClientAsyncWaiter::RunJavaScriptDialog(
    const ::GURL& requesting_origin, JavaScriptDialogType dialog_type, const ::std::u16string& message, const ::std::u16string& default_prompt, bool* out_success, ::std::u16string* out_user_input) {
  base::RunLoop loop;
  proxy_->RunJavaScriptDialog(
      std::move(requesting_origin),
      std::move(dialog_type),
      std::move(message),
      std::move(default_prompt),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::std::u16string* out_user_input
,
             bool success,
             const ::std::u16string& user_input) {*out_success = std::move(success);*out_user_input = std::move(user_input);
            loop->Quit();
          },
          &loop,
          out_success,
          out_user_input));
  loop.Run();
}



void WebViewClientAsyncWaiter::RunBeforeUnloadDialog(
    bool is_reload, bool* out_success, ::std::u16string* out_user_input) {
  base::RunLoop loop;
  proxy_->RunBeforeUnloadDialog(
      std::move(is_reload),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::std::u16string* out_user_input
,
             bool success,
             const ::std::u16string& user_input) {*out_success = std::move(success);*out_user_input = std::move(user_input);
            loop->Quit();
          },
          &loop,
          out_success,
          out_user_input));
  loop.Run();
}



void WebViewClientAsyncWaiter::ShowRepostFormWarningDialog(
    RepostFormWarningResponse* out_response) {
  base::RunLoop loop;
  proxy_->ShowRepostFormWarningDialog(
      base::BindOnce(
          [](base::RunLoop* loop,
             RepostFormWarningResponse* out_response
,
             RepostFormWarningResponse response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

RepostFormWarningResponse WebViewClientAsyncWaiter::ShowRepostFormWarningDialog(
    ) {
  RepostFormWarningResponse async_wait_result;
  ShowRepostFormWarningDialog(&async_wait_result);
  return async_wait_result;
}

void WebViewClientAsyncWaiter::EnterFullScreen(
    ::blink::mojom::FullscreenOptionsPtr options, bool* out_success) {
  base::RunLoop loop;
  proxy_->EnterFullScreen(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool WebViewClientAsyncWaiter::EnterFullScreen(
    ::blink::mojom::FullscreenOptionsPtr options) {
  bool async_wait_result;
  EnterFullScreen(std::move(options),&async_wait_result);
  return async_wait_result;
}

void WebViewClientAsyncWaiter::CanDeleteHistory(
    int32_t page_count, bool* out_is_deletion_allowed) {
  base::RunLoop loop;
  proxy_->CanDeleteHistory(
      std::move(page_count),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_deletion_allowed
,
             bool is_deletion_allowed) {*out_is_deletion_allowed = std::move(is_deletion_allowed);
            loop->Quit();
          },
          &loop,
          out_is_deletion_allowed));
  loop.Run();
}

bool WebViewClientAsyncWaiter::CanDeleteHistory(
    int32_t page_count) {
  bool async_wait_result;
  CanDeleteHistory(std::move(page_count),&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif