// owl/mojom/web_view.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_WEB_VIEW_MOJOM_TEST_UTILS_H_

#include "owl/mojom/web_view.mojom.h"


namespace owl::mojom {


class  FindClientInterceptorForTesting : public FindClient {
  virtual FindClient* GetForwardingInterface() = 0;
  void OnFindResult(FindResultPtr result) override;
};
class  FindClientAsyncWaiter {
 public:
  explicit FindClientAsyncWaiter(FindClient* proxy);

  FindClientAsyncWaiter(const FindClientAsyncWaiter&) = delete;
  FindClientAsyncWaiter& operator=(const FindClientAsyncWaiter&) = delete;

  ~FindClientAsyncWaiter();

 private:
  FindClient* const proxy_;
};


class  DevToolsSessionInterceptorForTesting : public DevToolsSession {
  virtual DevToolsSession* GetForwardingInterface() = 0;
  void SendProtocolMessage(const std::string& message) override;
};
class  DevToolsSessionAsyncWaiter {
 public:
  explicit DevToolsSessionAsyncWaiter(DevToolsSession* proxy);

  DevToolsSessionAsyncWaiter(const DevToolsSessionAsyncWaiter&) = delete;
  DevToolsSessionAsyncWaiter& operator=(const DevToolsSessionAsyncWaiter&) = delete;

  ~DevToolsSessionAsyncWaiter();

 private:
  DevToolsSession* const proxy_;
};


class  DevToolsSessionClientInterceptorForTesting : public DevToolsSessionClient {
  virtual DevToolsSessionClient* GetForwardingInterface() = 0;
  void OnProtocolMessage(const std::string& message) override;
};
class  DevToolsSessionClientAsyncWaiter {
 public:
  explicit DevToolsSessionClientAsyncWaiter(DevToolsSessionClient* proxy);

  DevToolsSessionClientAsyncWaiter(const DevToolsSessionClientAsyncWaiter&) = delete;
  DevToolsSessionClientAsyncWaiter& operator=(const DevToolsSessionClientAsyncWaiter&) = delete;

  ~DevToolsSessionClientAsyncWaiter();

 private:
  DevToolsSessionClient* const proxy_;
};


class  WebViewInterceptorForTesting : public WebView {
  virtual WebView* GetForwardingInterface() = 0;
  void MoveToGroup(const std::string& group_id) override;
  void NavigateTo(const ::GURL& url, NavigationType type, const std::string& additional_headers) override;
  void SetStoragePartition(StoragePartitionDescriptorPtr partition) override;
  void CloseNow() override;
  void GoBack() override;
  void GoForward() override;
  void GoToNavigationEntry(int32_t navigation_entry_id) override;
  void LoadNavigationEntries(LoadNavigationEntriesCallback callback) override;
  void ClearForwardHistory() override;
  void Stop() override;
  void Reload(bool skip_cache) override;
  void EvaluateJavaScript(const std::string& script, bool use_main_world, EvaluateJavaScriptCallback callback) override;
  void EvaluateJavaScriptWithArguments(const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await, EvaluateJavaScriptWithArgumentsCallback callback) override;
  void TakeSnapshot(std::optional<::base::TimeDelta> timeout, TakeSnapshotCallback callback) override;
  void FindInPage(const std::string& text, FindDirection direction, ::mojo::PendingAssociatedRemote<FindClient> client) override;
  void CancelFindInPage() override;
  void SetForeground(bool foreground) override;
  void SetAuthenticationURLScheme(const std::string& scheme) override;
  void CreateDevToolsSession(::mojo::PendingAssociatedReceiver<DevToolsSession> session, ::mojo::PendingAssociatedRemote<DevToolsSessionClient> client) override;
  void OpenDevTools(DevToolsPanel panel, DOMElementReferencePtr dom_element) override;
  void ZoomIn() override;
  void ZoomOut() override;
  void ResetZoom() override;
  void Mute() override;
  void Unmute() override;
  void CopyImage(int32_t frame_routing_id, int32_t frame_process_id, int32_t x, int32_t y) override;
  void SaveMedia(::owl::mojom::ContextMenuParamsPtr params) override;
  void LoopPlayback(::owl::mojom::ContextMenuParamsPtr params, bool loop_playback) override;
  void ShowPlaybackControls(::owl::mojom::ContextMenuParamsPtr params, bool show_playback_controls) override;
  void CopyVideoFrame(::owl::mojom::ContextMenuParamsPtr params) override;
  void ShowInPictureInPicture(::owl::mojom::ContextMenuParamsPtr params, bool show_in_picture_in_picture) override;
  void Undo() override;
  void Redo() override;
  void Cut() override;
  void Copy() override;
  void Paste() override;
  void SelectAll() override;
  void ReplaceMisspelledWord(const ::std::u16string& replacement) override;
  void AddToDictionary(const ::std::u16string& word) override;
  void CaptureCopy(CaptureCopyCallback callback) override;
  void InsertViaPaste(ClipboardOverridePtr contents, InsertViaPasteCallback callback) override;
  void SetCancelOffOriginLinkLoads(bool cancel_off_origin_link_loads) override;
  void ForceRendererCrash() override;
  void FetchCertificateChain(FetchCertificateChainCallback callback) override;
  void DisablePasswordManagement() override;
  void ExtractAnnotatedText(uint64_t char_count_goal, ExtractAnnotatedTextCallback callback) override;
  void ExtractSerializedDom(ExtractSerializedDomCallback callback) override;
  void ExtractSerializedDomElementInfo(const std::string& id, ExtractSerializedDomElementInfoCallback callback) override;
  void WillExitFullScreenMode() override;
  void RequestPrintPreview() override;
  void RegisterProtocolHandler() override;
  void SetBackgroundColor(::SkColor color) override;
  void NotifyUserActivation() override;
};
class  WebViewAsyncWaiter {
 public:
  explicit WebViewAsyncWaiter(WebView* proxy);

  WebViewAsyncWaiter(const WebViewAsyncWaiter&) = delete;
  WebViewAsyncWaiter& operator=(const WebViewAsyncWaiter&) = delete;

  ~WebViewAsyncWaiter();
  void LoadNavigationEntries(
      std::vector<NavigationEntryPtr>* out_entries, int32_t* out_current_index);
  
  void EvaluateJavaScript(
      const std::string& script, bool use_main_world, ::base::Value* out_result);
  ::base::Value EvaluateJavaScript(const std::string& script, bool use_main_world);
  void EvaluateJavaScriptWithArguments(
      const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await, ::base::Value* out_result);
  ::base::Value EvaluateJavaScriptWithArguments(const std::string& script, bool use_main_world, base::flat_map<std::string, ::base::Value> arguments, bool should_await);
  void TakeSnapshot(
      std::optional<::base::TimeDelta> timeout, SnapshotResultPtr* out_result);
  SnapshotResultPtr TakeSnapshot(std::optional<::base::TimeDelta> timeout);
  void CaptureCopy(
      ClipboardOverridePtr* out_contents);
  ClipboardOverridePtr CaptureCopy();
  void InsertViaPaste(
      ClipboardOverridePtr contents, bool* out_success);
  bool InsertViaPaste(ClipboardOverridePtr contents);
  void FetchCertificateChain(
      CertificateChainPtr* out_certificate);
  CertificateChainPtr FetchCertificateChain();
  void ExtractAnnotatedText(
      uint64_t char_count_goal, std::string* out_text);
  std::string ExtractAnnotatedText(uint64_t char_count_goal);
  void ExtractSerializedDom(
      std::string* out_text);
  std::string ExtractSerializedDom();
  void ExtractSerializedDomElementInfo(
      const std::string& id, SerializedDomElementInfoPtr* out_info);
  SerializedDomElementInfoPtr ExtractSerializedDomElementInfo(const std::string& id);

 private:
  WebView* const proxy_;
};


class  TabSharingSessionInterceptorForTesting : public TabSharingSession {
  virtual TabSharingSession* GetForwardingInterface() = 0;
  void StartSharingThisTab() override;
  void StopTabSharing() override;
};
class  TabSharingSessionAsyncWaiter {
 public:
  explicit TabSharingSessionAsyncWaiter(TabSharingSession* proxy);

  TabSharingSessionAsyncWaiter(const TabSharingSessionAsyncWaiter&) = delete;
  TabSharingSessionAsyncWaiter& operator=(const TabSharingSessionAsyncWaiter&) = delete;

  ~TabSharingSessionAsyncWaiter();

 private:
  TabSharingSession* const proxy_;
};


class  CertSelectionCancellationInterceptorForTesting : public CertSelectionCancellation {
  virtual CertSelectionCancellation* GetForwardingInterface() = 0;
  void CancelCertSelection() override;
};
class  CertSelectionCancellationAsyncWaiter {
 public:
  explicit CertSelectionCancellationAsyncWaiter(CertSelectionCancellation* proxy);

  CertSelectionCancellationAsyncWaiter(const CertSelectionCancellationAsyncWaiter&) = delete;
  CertSelectionCancellationAsyncWaiter& operator=(const CertSelectionCancellationAsyncWaiter&) = delete;

  ~CertSelectionCancellationAsyncWaiter();

 private:
  CertSelectionCancellation* const proxy_;
};


class  WebViewClientInterceptorForTesting : public WebViewClient {
  virtual WebViewClient* GetForwardingInterface() = 0;
  void CurrentURLChanged(NavigationEntryUrlPtr entryUrl) override;
  void CurrentTitleChanged(const std::optional<::std::u16string>& title) override;
  void CurrentFaviconChanged(const std::optional<::GURL>& favicon_url) override;
  void CurrentMimeTypeChanged(const std::string& mime_type) override;
  void CanGoBackForwardChanged(BackForwardStatePtr back_forward_state) override;
  void SessionDataChanged(const std::vector<uint8_t>& session_data) override;
  void DidCommit(CommitDetailsPtr details) override;
  void LoadingStateChanged(bool is_loading, double progress) override;
  void UpdateTargetURL(const std::optional<::GURL>& target_url) override;
  void ZoomStateChanged(bool can_zoom_in, bool can_zoom_out, bool can_reset_zoom) override;
  void MuteStateChanged(bool is_muted) override;
  void OnVisibleSecurityStateChanged(SecurityLevel security_level) override;
  void ShowTabSharingButtons(uint64_t shared_tab_id, uint64_t capturer_id, TabSharingTabRole role, TabSharingButtonState share_this_tab_instead_button_state, ::mojo::PendingAssociatedRemote<TabSharingSession> tab_sharing_session) override;
  void RemoveTabSharingButtons() override;
  void OnCloseRequestedByHost() override;
  void ActivateContent() override;
  void RenderProcessStatusChanged(RenderProcessStatus status) override;
  void PrimaryPageChanged() override;
  void SelectClientCert(const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver, SelectClientCertCallback callback) override;
  void RunJavaScriptDialog(const ::GURL& requesting_origin, JavaScriptDialogType dialog_type, const ::std::u16string& message, const ::std::u16string& default_prompt, RunJavaScriptDialogCallback callback) override;
  void RunBeforeUnloadDialog(bool is_reload, RunBeforeUnloadDialogCallback callback) override;
  void ShowRepostFormWarningDialog(ShowRepostFormWarningDialogCallback callback) override;
  void EnterFullScreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullScreenCallback callback) override;
  void ExitFullScreen() override;
  void OnAuthenticationURLSchemeFound(const ::GURL& url) override;
  void CreatedNewWebView(uint64_t web_content_id, WebViewDispositionPtr disposition, ::mojo::PendingAssociatedRemote<WebView> web_view, ::mojo::PendingAssociatedReceiver<WebViewClient> web_view_client, const std::optional<std::string>& group_id) override;
  void DevToolsDockSideChanged(DevToolsDockSide dock_side) override;
  void DevToolsClosed() override;
  void RedispatchKeyEvent(const std::vector<uint8_t>& native_event_data, ::blink::mojom::InputSource original_input_source) override;
  void CreateWindowBridge(WindowBridgeSource source, ::mojo::PendingAssociatedReceiver<::remote_cocoa::mojom::Application> receiver) override;
  void BindFrontendHost(::mojo::PendingReceiver<::owl::mojom::ChatGPTFrontendHost> receiver) override;
  void OnTabRendererDataChanged(TabRendererDataPtr data) override;
  void OnFocusChangedInPage(bool focused_element_is_editable, const ::gfx::Rect& node_bounds_in_view) override;
  void OnOffOriginLinkLoadCanceled(const ::GURL& link_url) override;
  void GoBackOrLoadNewTab() override;
  void ShowPermissionPrompt(::owl::mojom::PermissionPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::PermissionPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::PermissionPromptClient> prompt_client) override;
  void ShowSavePasswordPrompt(::owl::mojom::SavePasswordPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SavePasswordPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SavePasswordPromptClient> prompt_client) override;
  void ShowSaveAddressPrompt(::owl::mojom::SaveAddressPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveAddressPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveAddressPromptClient> prompt_client) override;
  void ShowSaveCardPrompt(::owl::mojom::SaveCardPromptDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::SaveCardPrompt> prompt, ::mojo::PendingAssociatedRemote<::owl::mojom::SaveCardPromptClient> prompt_client) override;
  void ShowAutofillPopup(::owl::mojom::AutofillPopupDetailsPtr details, ::mojo::PendingAssociatedReceiver<::owl::mojom::AutofillPopup> popup, ::mojo::PendingAssociatedRemote<::owl::mojom::AutofillPopupClient> popup_client) override;
  void SetPreferredSizeFromAutoResize(const ::gfx::Size& new_size) override;
  void DeleteBrowsingData() override;
  void CanDeleteHistory(int32_t page_count, CanDeleteHistoryCallback callback) override;
  void SetHasPendingProtocolHandler(bool value) override;
};
class  WebViewClientAsyncWaiter {
 public:
  explicit WebViewClientAsyncWaiter(WebViewClient* proxy);

  WebViewClientAsyncWaiter(const WebViewClientAsyncWaiter&) = delete;
  WebViewClientAsyncWaiter& operator=(const WebViewClientAsyncWaiter&) = delete;

  ~WebViewClientAsyncWaiter();
  void SelectClientCert(
      const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver, std::optional<uint32_t>* out_index);
  std::optional<uint32_t> SelectClientCert(const std::string& host, uint16_t port, std::vector<ClientCertMetadataPtr> available_certs, ::mojo::PendingAssociatedReceiver<CertSelectionCancellation> cancellation_receiver);
  void RunJavaScriptDialog(
      const ::GURL& requesting_origin, JavaScriptDialogType dialog_type, const ::std::u16string& message, const ::std::u16string& default_prompt, bool* out_success, ::std::u16string* out_user_input);
  
  void RunBeforeUnloadDialog(
      bool is_reload, bool* out_success, ::std::u16string* out_user_input);
  
  void ShowRepostFormWarningDialog(
      RepostFormWarningResponse* out_response);
  RepostFormWarningResponse ShowRepostFormWarningDialog();
  void EnterFullScreen(
      ::blink::mojom::FullscreenOptionsPtr options, bool* out_success);
  bool EnterFullScreen(::blink::mojom::FullscreenOptionsPtr options);
  void CanDeleteHistory(
      int32_t page_count, bool* out_is_deletion_allowed);
  bool CanDeleteHistory(int32_t page_count);

 private:
  WebViewClient* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_WEB_VIEW_MOJOM_TEST_UTILS_H_