// owl/mojom/web_view.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/web_view.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_view.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* DevToolsPanelToStringHelper(DevToolsPanel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DevToolsPanel::kConsole:
      return "kConsole";
    case DevToolsPanel::kInspector:
      return "kInspector";
    case DevToolsPanel::kSources:
      return "kSources";
    default:
      return nullptr;
  }
}

std::string DevToolsPanelToString(DevToolsPanel value) {
  const char *str = DevToolsPanelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DevToolsPanel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DevToolsPanel value) {
  return os << DevToolsPanelToString(value);
}

NOINLINE static const char* TabAlertStateToStringHelper(TabAlertState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabAlertState::kMediaRecording:
      return "kMediaRecording";
    case TabAlertState::kTabCapturing:
      return "kTabCapturing";
    case TabAlertState::kAudioPlaying:
      return "kAudioPlaying";
    case TabAlertState::kAudioMuting:
      return "kAudioMuting";
    case TabAlertState::kBluetoothConnected:
      return "kBluetoothConnected";
    case TabAlertState::kBluetoothScanActive:
      return "kBluetoothScanActive";
    case TabAlertState::kUsbConnected:
      return "kUsbConnected";
    case TabAlertState::kHidConnected:
      return "kHidConnected";
    case TabAlertState::kSerialConnected:
      return "kSerialConnected";
    case TabAlertState::kPipPlaying:
      return "kPipPlaying";
    case TabAlertState::kDesktopCapturing:
      return "kDesktopCapturing";
    case TabAlertState::kVrPresentingInHeadset:
      return "kVrPresentingInHeadset";
    case TabAlertState::kAudioRecording:
      return "kAudioRecording";
    case TabAlertState::kVideoRecording:
      return "kVideoRecording";
    case TabAlertState::kGlicAccessing:
      return "kGlicAccessing";
    case TabAlertState::kActorAccessing:
      return "kActorAccessing";
    default:
      return nullptr;
  }
}

std::string TabAlertStateToString(TabAlertState value) {
  const char *str = TabAlertStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabAlertState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabAlertState value) {
  return os << TabAlertStateToString(value);
}

NOINLINE static const char* TabNetworkStateToStringHelper(TabNetworkState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabNetworkState::kNone:
      return "kNone";
    case TabNetworkState::kWaiting:
      return "kWaiting";
    case TabNetworkState::kLoading:
      return "kLoading";
    case TabNetworkState::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string TabNetworkStateToString(TabNetworkState value) {
  const char *str = TabNetworkStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabNetworkState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabNetworkState value) {
  return os << TabNetworkStateToString(value);
}

NOINLINE static const char* NavigationTypeToStringHelper(NavigationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NavigationType::kTyped:
      return "kTyped";
    case NavigationType::kBookmark:
      return "kBookmark";
    case NavigationType::kLink:
      return "kLink";
    case NavigationType::kSuggestion:
      return "kSuggestion";
    case NavigationType::kContextMenu:
      return "kContextMenu";
    case NavigationType::kKeyword:
      return "kKeyword";
    default:
      return nullptr;
  }
}

std::string NavigationTypeToString(NavigationType value) {
  const char *str = NavigationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NavigationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NavigationType value) {
  return os << NavigationTypeToString(value);
}

NOINLINE static const char* TransitionTypeToStringHelper(TransitionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TransitionType::kTyped:
      return "kTyped";
    case TransitionType::kLinkActivated:
      return "kLinkActivated";
    case TransitionType::kFormSubmitted:
      return "kFormSubmitted";
    case TransitionType::kBackForward:
      return "kBackForward";
    case TransitionType::kReload:
      return "kReload";
    case TransitionType::kFormResubmitted:
      return "kFormResubmitted";
    case TransitionType::kOther:
      return "kOther";
    default:
      return nullptr;
  }
}

std::string TransitionTypeToString(TransitionType value) {
  const char *str = TransitionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TransitionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TransitionType value) {
  return os << TransitionTypeToString(value);
}

NOINLINE static const char* SecurityLevelToStringHelper(SecurityLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SecurityLevel::kNone:
      return "kNone";
    case SecurityLevel::kSecure:
      return "kSecure";
    case SecurityLevel::kWarning:
      return "kWarning";
    case SecurityLevel::kDangerous:
      return "kDangerous";
    default:
      return nullptr;
  }
}

std::string SecurityLevelToString(SecurityLevel value) {
  const char *str = SecurityLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SecurityLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SecurityLevel value) {
  return os << SecurityLevelToString(value);
}

NOINLINE static const char* FindDirectionToStringHelper(FindDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FindDirection::kForward:
      return "kForward";
    case FindDirection::kBackward:
      return "kBackward";
    default:
      return nullptr;
  }
}

std::string FindDirectionToString(FindDirection value) {
  const char *str = FindDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FindDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FindDirection value) {
  return os << FindDirectionToString(value);
}

NOINLINE static const char* JavaScriptDialogTypeToStringHelper(JavaScriptDialogType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case JavaScriptDialogType::kAlert:
      return "kAlert";
    case JavaScriptDialogType::kConfirm:
      return "kConfirm";
    case JavaScriptDialogType::kPrompt:
      return "kPrompt";
    default:
      return nullptr;
  }
}

std::string JavaScriptDialogTypeToString(JavaScriptDialogType value) {
  const char *str = JavaScriptDialogTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown JavaScriptDialogType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, JavaScriptDialogType value) {
  return os << JavaScriptDialogTypeToString(value);
}

NOINLINE static const char* TabSharingButtonStateToStringHelper(TabSharingButtonState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabSharingButtonState::kEnabled:
      return "kEnabled";
    case TabSharingButtonState::kDisabled:
      return "kDisabled";
    case TabSharingButtonState::kNotShown:
      return "kNotShown";
    default:
      return nullptr;
  }
}

std::string TabSharingButtonStateToString(TabSharingButtonState value) {
  const char *str = TabSharingButtonStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabSharingButtonState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabSharingButtonState value) {
  return os << TabSharingButtonStateToString(value);
}

NOINLINE static const char* TabSharingTabRoleToStringHelper(TabSharingTabRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabSharingTabRole::kCapturingTab:
      return "kCapturingTab";
    case TabSharingTabRole::kCapturedTab:
      return "kCapturedTab";
    case TabSharingTabRole::kSelfCapturingTab:
      return "kSelfCapturingTab";
    case TabSharingTabRole::kOtherTab:
      return "kOtherTab";
    default:
      return nullptr;
  }
}

std::string TabSharingTabRoleToString(TabSharingTabRole value) {
  const char *str = TabSharingTabRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabSharingTabRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabSharingTabRole value) {
  return os << TabSharingTabRoleToString(value);
}

NOINLINE static const char* RepostFormWarningResponseToStringHelper(RepostFormWarningResponse value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RepostFormWarningResponse::kAccepted:
      return "kAccepted";
    case RepostFormWarningResponse::kCanceled:
      return "kCanceled";
    case RepostFormWarningResponse::kClosed:
      return "kClosed";
    default:
      return nullptr;
  }
}

std::string RepostFormWarningResponseToString(RepostFormWarningResponse value) {
  const char *str = RepostFormWarningResponseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RepostFormWarningResponse value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RepostFormWarningResponse value) {
  return os << RepostFormWarningResponseToString(value);
}

NOINLINE static const char* WindowBridgeSourceToStringHelper(WindowBridgeSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowBridgeSource::kWebModalDialog:
      return "kWebModalDialog";
    case WindowBridgeSource::kVideoPictureInPicture:
      return "kVideoPictureInPicture";
    case WindowBridgeSource::kEmbeddedPermissionPrompt:
      return "kEmbeddedPermissionPrompt";
    case WindowBridgeSource::kBubblePermissionPrompt:
      return "kBubblePermissionPrompt";
    case WindowBridgeSource::kExtensionDialog:
      return "kExtensionDialog";
    case WindowBridgeSource::kPasswordUpdateState:
      return "kPasswordUpdateState";
    case WindowBridgeSource::kWebBubbleDialog:
      return "kWebBubbleDialog";
    default:
      return nullptr;
  }
}

std::string WindowBridgeSourceToString(WindowBridgeSource value) {
  const char *str = WindowBridgeSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowBridgeSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowBridgeSource value) {
  return os << WindowBridgeSourceToString(value);
}

NOINLINE static const char* DevToolsDockSideToStringHelper(DevToolsDockSide value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DevToolsDockSide::kUndocked:
      return "kUndocked";
    case DevToolsDockSide::kBottom:
      return "kBottom";
    case DevToolsDockSide::kLeft:
      return "kLeft";
    case DevToolsDockSide::kRight:
      return "kRight";
    default:
      return nullptr;
  }
}

std::string DevToolsDockSideToString(DevToolsDockSide value) {
  const char *str = DevToolsDockSideToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DevToolsDockSide value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DevToolsDockSide value) {
  return os << DevToolsDockSideToString(value);
}

NOINLINE static const char* RenderProcessStatusToStringHelper(RenderProcessStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RenderProcessStatus::kCrashed:
      return "kCrashed";
    case RenderProcessStatus::kNotRunning:
      return "kNotRunning";
    case RenderProcessStatus::kUnresponsive:
      return "kUnresponsive";
    case RenderProcessStatus::kResponsive:
      return "kResponsive";
    default:
      return nullptr;
  }
}

std::string RenderProcessStatusToString(RenderProcessStatus value) {
  const char *str = RenderProcessStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RenderProcessStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RenderProcessStatus value) {
  return os << RenderProcessStatusToString(value);
}

namespace internal {
// static
bool SnapshotResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SnapshotResult_Data* object = static_cast<const SnapshotResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SnapshotResult_Tag::kImage: {

      if (!mojo::internal::ValidateStruct(object->data.f_image, validation_context))
        return false;
      return true;
    }
    case SnapshotResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error, validation_context,
                                             &error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SnapshotResult");
      return false;
    }
  }
}
// static
bool WebViewDisposition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebViewDisposition_Data* object = static_cast<const WebViewDisposition_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebViewDisposition_Tag::kWindowOpen: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_window_open, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_window_open, validation_context))
        return false;
      return true;
    }
    case WebViewDisposition_Tag::kPictureInPicture: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_picture_in_picture, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_picture_in_picture, validation_context))
        return false;
      return true;
    }
    case WebViewDisposition_Tag::kPrintPreview: {

      return true;
    }
    case WebViewDisposition_Tag::kExtensionPopup: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_extension_popup, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_extension_popup, validation_context))
        return false;
      return true;
    }
    case WebViewDisposition_Tag::kDevTools: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dev_tools, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dev_tools, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebViewDisposition");
      return false;
    }
  }
}


// static
bool FindResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindResult_Data* object =
      static_cast<const FindResult_Data*>(data);

  return true;
}

FindResult_Data::FindResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DOMElementReference_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DOMElementReference_Data* object =
      static_cast<const DOMElementReference_Data*>(data);

  return true;
}

DOMElementReference_Data::DOMElementReference_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NavigationEntry_Data* object =
      static_cast<const NavigationEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  return true;
}

NavigationEntry_Data::NavigationEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SerializedDomElementInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SerializedDomElementInfo_Data* object =
      static_cast<const SerializedDomElementInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tag, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tag_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tag, validation_context,
                                         &tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selector, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selector_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selector, validation_context,
                                         &selector_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->visible_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->click_point, validation_context))
    return false;

  return true;
}

SerializedDomElementInfo_Data::SerializedDomElementInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabRendererData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabRendererData_Data* object =
      static_cast<const TabRendererData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alert_states, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::owl::mojom::internal::TabAlertState_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->alert_states, validation_context,
                                         &alert_states_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->favicon_image, validation_context))
    return false;


  if (!::owl::mojom::internal::TabNetworkState_Data
        ::Validate(object->network_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_committed_url, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_committed_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_url, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_url, validation_context))
    return false;

  return true;
}

TabRendererData_Data::TabRendererData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClipboardOverride_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClipboardOverride_Data* object =
      static_cast<const ClipboardOverride_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->text, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->html, validation_context))
    return false;

  return true;
}

ClipboardOverride_Data::ClipboardOverride_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateChain_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateChain_Data* object =
      static_cast<const CertificateChain_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->der_chain, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& der_chain_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->der_chain, validation_context,
                                         &der_chain_validate_params)) {
    return false;
  }

  return true;
}

CertificateChain_Data::CertificateChain_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StoragePartitionDescriptor_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StoragePartitionDescriptor_Data* object =
      static_cast<const StoragePartitionDescriptor_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partition_domain, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& partition_domain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->partition_domain, validation_context,
                                         &partition_domain_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->partition_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& partition_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->partition_name, validation_context,
                                         &partition_name_validate_params)) {
    return false;
  }

  return true;
}

StoragePartitionDescriptor_Data::StoragePartitionDescriptor_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientCertMetadata_Data* object =
      static_cast<const ClientCertMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subject, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subject_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subject, validation_context,
                                         &subject_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issuer, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& issuer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->issuer, validation_context,
                                         &issuer_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serial, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& serial_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->serial, validation_context,
                                         &serial_validate_params)) {
    return false;
  }

  return true;
}

ClientCertMetadata_Data::ClientCertMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PictureInPictureConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PictureInPictureConfig_Data* object =
      static_cast<const PictureInPictureConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_options, validation_context))
    return false;

  return true;
}

PictureInPictureConfig_Data::PictureInPictureConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WindowOpenContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WindowOpenContext_Data* object =
      static_cast<const WindowOpenContext_Data*>(data);


  if (!::ui::mojom::internal::WindowOpenDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_features, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_features, validation_context))
    return false;

  return true;
}

WindowOpenContext_Data::WindowOpenContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExtensionPopupContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExtensionPopupContext_Data* object =
      static_cast<const ExtensionPopupContext_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->extension_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  return true;
}

ExtensionPopupContext_Data::ExtensionPopupContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsContext_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsContext_Data* object =
      static_cast<const DevToolsContext_Data*>(data);


  if (!::owl::mojom::internal::DevToolsDockSide_Data
        ::Validate(object->dock_side, validation_context))
    return false;

  return true;
}

DevToolsContext_Data::DevToolsContext_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackForwardState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackForwardState_Data* object =
      static_cast<const BackForwardState_Data*>(data);

  return true;
}

BackForwardState_Data::BackForwardState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationEntryState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NavigationEntryState_Data* object =
      static_cast<const NavigationEntryState_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->back_forward_state, validation_context))
    return false;

  return true;
}

NavigationEntryState_Data::NavigationEntryState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommitDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommitDetails_Data* object =
      static_cast<const CommitDetails_Data*>(data);


  if (!::owl::mojom::internal::TransitionType_Data
        ::Validate(object->transition_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->removed_entry_ids, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& removed_entry_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_entry_ids, validation_context,
                                         &removed_entry_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->removed_main_frame_document_ids, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& removed_main_frame_document_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->removed_main_frame_document_ids, validation_context,
                                         &removed_main_frame_document_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entry_state, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->entry_state, validation_context))
    return false;

  return true;
}

CommitDetails_Data::CommitDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationEntryUrl_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NavigationEntryUrl_Data* object =
      static_cast<const NavigationEntryUrl_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_chain_start, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_chain_start, validation_context))
    return false;

  return true;
}

NavigationEntryUrl_Data::NavigationEntryUrl_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindClient_OnFindResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindClient_OnFindResult_Params_Data* object =
      static_cast<const FindClient_OnFindResult_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

FindClient_OnFindResult_Params_Data::FindClient_OnFindResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsSession_SendProtocolMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsSession_SendProtocolMessage_Params_Data* object =
      static_cast<const DevToolsSession_SendProtocolMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

DevToolsSession_SendProtocolMessage_Params_Data::DevToolsSession_SendProtocolMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsSessionClient_OnProtocolMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsSessionClient_OnProtocolMessage_Params_Data* object =
      static_cast<const DevToolsSessionClient_OnProtocolMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

DevToolsSessionClient_OnProtocolMessage_Params_Data::DevToolsSessionClient_OnProtocolMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_MoveToGroup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_MoveToGroup_Params_Data* object =
      static_cast<const WebView_MoveToGroup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

WebView_MoveToGroup_Params_Data::WebView_MoveToGroup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_NavigateTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_NavigateTo_Params_Data* object =
      static_cast<const WebView_NavigateTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::owl::mojom::internal::NavigationType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_headers, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& additional_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->additional_headers, validation_context,
                                         &additional_headers_validate_params)) {
    return false;
  }

  return true;
}

WebView_NavigateTo_Params_Data::WebView_NavigateTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SetStoragePartition_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SetStoragePartition_Params_Data* object =
      static_cast<const WebView_SetStoragePartition_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->partition, validation_context))
    return false;

  return true;
}

WebView_SetStoragePartition_Params_Data::WebView_SetStoragePartition_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CloseNow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CloseNow_Params_Data* object =
      static_cast<const WebView_CloseNow_Params_Data*>(data);

  return true;
}

WebView_CloseNow_Params_Data::WebView_CloseNow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_GoBack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_GoBack_Params_Data* object =
      static_cast<const WebView_GoBack_Params_Data*>(data);

  return true;
}

WebView_GoBack_Params_Data::WebView_GoBack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_GoForward_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_GoForward_Params_Data* object =
      static_cast<const WebView_GoForward_Params_Data*>(data);

  return true;
}

WebView_GoForward_Params_Data::WebView_GoForward_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_GoToNavigationEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_GoToNavigationEntry_Params_Data* object =
      static_cast<const WebView_GoToNavigationEntry_Params_Data*>(data);

  return true;
}

WebView_GoToNavigationEntry_Params_Data::WebView_GoToNavigationEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_LoadNavigationEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_LoadNavigationEntries_Params_Data* object =
      static_cast<const WebView_LoadNavigationEntries_Params_Data*>(data);

  return true;
}

WebView_LoadNavigationEntries_Params_Data::WebView_LoadNavigationEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_LoadNavigationEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_LoadNavigationEntries_ResponseParams_Data* object =
      static_cast<const WebView_LoadNavigationEntries_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

WebView_LoadNavigationEntries_ResponseParams_Data::WebView_LoadNavigationEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ClearForwardHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ClearForwardHistory_Params_Data* object =
      static_cast<const WebView_ClearForwardHistory_Params_Data*>(data);

  return true;
}

WebView_ClearForwardHistory_Params_Data::WebView_ClearForwardHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Stop_Params_Data* object =
      static_cast<const WebView_Stop_Params_Data*>(data);

  return true;
}

WebView_Stop_Params_Data::WebView_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Reload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Reload_Params_Data* object =
      static_cast<const WebView_Reload_Params_Data*>(data);

  return true;
}

WebView_Reload_Params_Data::WebView_Reload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_EvaluateJavaScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_EvaluateJavaScript_Params_Data* object =
      static_cast<const WebView_EvaluateJavaScript_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& script_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->script, validation_context,
                                         &script_validate_params)) {
    return false;
  }

  return true;
}

WebView_EvaluateJavaScript_Params_Data::WebView_EvaluateJavaScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_EvaluateJavaScript_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_EvaluateJavaScript_ResponseParams_Data* object =
      static_cast<const WebView_EvaluateJavaScript_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebView_EvaluateJavaScript_ResponseParams_Data::WebView_EvaluateJavaScript_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_EvaluateJavaScriptWithArguments_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_EvaluateJavaScriptWithArguments_Params_Data* object =
      static_cast<const WebView_EvaluateJavaScriptWithArguments_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->script, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& script_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->script, validation_context,
                                         &script_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->arguments, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& arguments_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->arguments, validation_context,
                                         &arguments_validate_params)) {
    return false;
  }

  return true;
}

WebView_EvaluateJavaScriptWithArguments_Params_Data::WebView_EvaluateJavaScriptWithArguments_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data* object =
      static_cast<const WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data::WebView_EvaluateJavaScriptWithArguments_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_TakeSnapshot_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_TakeSnapshot_Params_Data* object =
      static_cast<const WebView_TakeSnapshot_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  return true;
}

WebView_TakeSnapshot_Params_Data::WebView_TakeSnapshot_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_TakeSnapshot_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_TakeSnapshot_ResponseParams_Data* object =
      static_cast<const WebView_TakeSnapshot_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebView_TakeSnapshot_ResponseParams_Data::WebView_TakeSnapshot_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_FindInPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_FindInPage_Params_Data* object =
      static_cast<const WebView_FindInPage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }


  if (!::owl::mojom::internal::FindDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebView_FindInPage_Params_Data::WebView_FindInPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CancelFindInPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CancelFindInPage_Params_Data* object =
      static_cast<const WebView_CancelFindInPage_Params_Data*>(data);

  return true;
}

WebView_CancelFindInPage_Params_Data::WebView_CancelFindInPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SetForeground_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SetForeground_Params_Data* object =
      static_cast<const WebView_SetForeground_Params_Data*>(data);

  return true;
}

WebView_SetForeground_Params_Data::WebView_SetForeground_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SetAuthenticationURLScheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SetAuthenticationURLScheme_Params_Data* object =
      static_cast<const WebView_SetAuthenticationURLScheme_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scheme, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& scheme_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->scheme, validation_context,
                                         &scheme_validate_params)) {
    return false;
  }

  return true;
}

WebView_SetAuthenticationURLScheme_Params_Data::WebView_SetAuthenticationURLScheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CreateDevToolsSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CreateDevToolsSession_Params_Data* object =
      static_cast<const WebView_CreateDevToolsSession_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebView_CreateDevToolsSession_Params_Data::WebView_CreateDevToolsSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_OpenDevTools_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_OpenDevTools_Params_Data* object =
      static_cast<const WebView_OpenDevTools_Params_Data*>(data);


  if (!::owl::mojom::internal::DevToolsPanel_Data
        ::Validate(object->panel, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dom_element, validation_context))
    return false;

  return true;
}

WebView_OpenDevTools_Params_Data::WebView_OpenDevTools_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ZoomIn_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ZoomIn_Params_Data* object =
      static_cast<const WebView_ZoomIn_Params_Data*>(data);

  return true;
}

WebView_ZoomIn_Params_Data::WebView_ZoomIn_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ZoomOut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ZoomOut_Params_Data* object =
      static_cast<const WebView_ZoomOut_Params_Data*>(data);

  return true;
}

WebView_ZoomOut_Params_Data::WebView_ZoomOut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ResetZoom_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ResetZoom_Params_Data* object =
      static_cast<const WebView_ResetZoom_Params_Data*>(data);

  return true;
}

WebView_ResetZoom_Params_Data::WebView_ResetZoom_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Mute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Mute_Params_Data* object =
      static_cast<const WebView_Mute_Params_Data*>(data);

  return true;
}

WebView_Mute_Params_Data::WebView_Mute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Unmute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Unmute_Params_Data* object =
      static_cast<const WebView_Unmute_Params_Data*>(data);

  return true;
}

WebView_Unmute_Params_Data::WebView_Unmute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CopyImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CopyImage_Params_Data* object =
      static_cast<const WebView_CopyImage_Params_Data*>(data);

  return true;
}

WebView_CopyImage_Params_Data::WebView_CopyImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SaveMedia_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SaveMedia_Params_Data* object =
      static_cast<const WebView_SaveMedia_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebView_SaveMedia_Params_Data::WebView_SaveMedia_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_LoopPlayback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_LoopPlayback_Params_Data* object =
      static_cast<const WebView_LoopPlayback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebView_LoopPlayback_Params_Data::WebView_LoopPlayback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ShowPlaybackControls_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ShowPlaybackControls_Params_Data* object =
      static_cast<const WebView_ShowPlaybackControls_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebView_ShowPlaybackControls_Params_Data::WebView_ShowPlaybackControls_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CopyVideoFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CopyVideoFrame_Params_Data* object =
      static_cast<const WebView_CopyVideoFrame_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebView_CopyVideoFrame_Params_Data::WebView_CopyVideoFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ShowInPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ShowInPictureInPicture_Params_Data* object =
      static_cast<const WebView_ShowInPictureInPicture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebView_ShowInPictureInPicture_Params_Data::WebView_ShowInPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Undo_Params_Data* object =
      static_cast<const WebView_Undo_Params_Data*>(data);

  return true;
}

WebView_Undo_Params_Data::WebView_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Redo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Redo_Params_Data* object =
      static_cast<const WebView_Redo_Params_Data*>(data);

  return true;
}

WebView_Redo_Params_Data::WebView_Redo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Cut_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Cut_Params_Data* object =
      static_cast<const WebView_Cut_Params_Data*>(data);

  return true;
}

WebView_Cut_Params_Data::WebView_Cut_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Copy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Copy_Params_Data* object =
      static_cast<const WebView_Copy_Params_Data*>(data);

  return true;
}

WebView_Copy_Params_Data::WebView_Copy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_Paste_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_Paste_Params_Data* object =
      static_cast<const WebView_Paste_Params_Data*>(data);

  return true;
}

WebView_Paste_Params_Data::WebView_Paste_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SelectAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SelectAll_Params_Data* object =
      static_cast<const WebView_SelectAll_Params_Data*>(data);

  return true;
}

WebView_SelectAll_Params_Data::WebView_SelectAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ReplaceMisspelledWord_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ReplaceMisspelledWord_Params_Data* object =
      static_cast<const WebView_ReplaceMisspelledWord_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->replacement, validation_context))
    return false;

  return true;
}

WebView_ReplaceMisspelledWord_Params_Data::WebView_ReplaceMisspelledWord_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_AddToDictionary_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_AddToDictionary_Params_Data* object =
      static_cast<const WebView_AddToDictionary_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->word, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->word, validation_context))
    return false;

  return true;
}

WebView_AddToDictionary_Params_Data::WebView_AddToDictionary_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CaptureCopy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CaptureCopy_Params_Data* object =
      static_cast<const WebView_CaptureCopy_Params_Data*>(data);

  return true;
}

WebView_CaptureCopy_Params_Data::WebView_CaptureCopy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_CaptureCopy_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_CaptureCopy_ResponseParams_Data* object =
      static_cast<const WebView_CaptureCopy_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->contents, validation_context))
    return false;

  return true;
}

WebView_CaptureCopy_ResponseParams_Data::WebView_CaptureCopy_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_InsertViaPaste_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_InsertViaPaste_Params_Data* object =
      static_cast<const WebView_InsertViaPaste_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->contents, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->contents, validation_context))
    return false;

  return true;
}

WebView_InsertViaPaste_Params_Data::WebView_InsertViaPaste_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_InsertViaPaste_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_InsertViaPaste_ResponseParams_Data* object =
      static_cast<const WebView_InsertViaPaste_ResponseParams_Data*>(data);

  return true;
}

WebView_InsertViaPaste_ResponseParams_Data::WebView_InsertViaPaste_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SetCancelOffOriginLinkLoads_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SetCancelOffOriginLinkLoads_Params_Data* object =
      static_cast<const WebView_SetCancelOffOriginLinkLoads_Params_Data*>(data);

  return true;
}

WebView_SetCancelOffOriginLinkLoads_Params_Data::WebView_SetCancelOffOriginLinkLoads_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ForceRendererCrash_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ForceRendererCrash_Params_Data* object =
      static_cast<const WebView_ForceRendererCrash_Params_Data*>(data);

  return true;
}

WebView_ForceRendererCrash_Params_Data::WebView_ForceRendererCrash_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_FetchCertificateChain_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_FetchCertificateChain_Params_Data* object =
      static_cast<const WebView_FetchCertificateChain_Params_Data*>(data);

  return true;
}

WebView_FetchCertificateChain_Params_Data::WebView_FetchCertificateChain_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_FetchCertificateChain_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_FetchCertificateChain_ResponseParams_Data* object =
      static_cast<const WebView_FetchCertificateChain_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  return true;
}

WebView_FetchCertificateChain_ResponseParams_Data::WebView_FetchCertificateChain_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_DisablePasswordManagement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_DisablePasswordManagement_Params_Data* object =
      static_cast<const WebView_DisablePasswordManagement_Params_Data*>(data);

  return true;
}

WebView_DisablePasswordManagement_Params_Data::WebView_DisablePasswordManagement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ExtractAnnotatedText_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ExtractAnnotatedText_Params_Data* object =
      static_cast<const WebView_ExtractAnnotatedText_Params_Data*>(data);

  return true;
}

WebView_ExtractAnnotatedText_Params_Data::WebView_ExtractAnnotatedText_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ExtractAnnotatedText_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ExtractAnnotatedText_ResponseParams_Data* object =
      static_cast<const WebView_ExtractAnnotatedText_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

WebView_ExtractAnnotatedText_ResponseParams_Data::WebView_ExtractAnnotatedText_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ExtractSerializedDom_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ExtractSerializedDom_Params_Data* object =
      static_cast<const WebView_ExtractSerializedDom_Params_Data*>(data);

  return true;
}

WebView_ExtractSerializedDom_Params_Data::WebView_ExtractSerializedDom_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ExtractSerializedDom_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ExtractSerializedDom_ResponseParams_Data* object =
      static_cast<const WebView_ExtractSerializedDom_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

WebView_ExtractSerializedDom_ResponseParams_Data::WebView_ExtractSerializedDom_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ExtractSerializedDomElementInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ExtractSerializedDomElementInfo_Params_Data* object =
      static_cast<const WebView_ExtractSerializedDomElementInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

WebView_ExtractSerializedDomElementInfo_Params_Data::WebView_ExtractSerializedDomElementInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_ExtractSerializedDomElementInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_ExtractSerializedDomElementInfo_ResponseParams_Data* object =
      static_cast<const WebView_ExtractSerializedDomElementInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

WebView_ExtractSerializedDomElementInfo_ResponseParams_Data::WebView_ExtractSerializedDomElementInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_WillExitFullScreenMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_WillExitFullScreenMode_Params_Data* object =
      static_cast<const WebView_WillExitFullScreenMode_Params_Data*>(data);

  return true;
}

WebView_WillExitFullScreenMode_Params_Data::WebView_WillExitFullScreenMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_RequestPrintPreview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_RequestPrintPreview_Params_Data* object =
      static_cast<const WebView_RequestPrintPreview_Params_Data*>(data);

  return true;
}

WebView_RequestPrintPreview_Params_Data::WebView_RequestPrintPreview_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_RegisterProtocolHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_RegisterProtocolHandler_Params_Data* object =
      static_cast<const WebView_RegisterProtocolHandler_Params_Data*>(data);

  return true;
}

WebView_RegisterProtocolHandler_Params_Data::WebView_RegisterProtocolHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_SetBackgroundColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_SetBackgroundColor_Params_Data* object =
      static_cast<const WebView_SetBackgroundColor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color, validation_context))
    return false;

  return true;
}

WebView_SetBackgroundColor_Params_Data::WebView_SetBackgroundColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebView_NotifyUserActivation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebView_NotifyUserActivation_Params_Data* object =
      static_cast<const WebView_NotifyUserActivation_Params_Data*>(data);

  return true;
}

WebView_NotifyUserActivation_Params_Data::WebView_NotifyUserActivation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabSharingSession_StartSharingThisTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabSharingSession_StartSharingThisTab_Params_Data* object =
      static_cast<const TabSharingSession_StartSharingThisTab_Params_Data*>(data);

  return true;
}

TabSharingSession_StartSharingThisTab_Params_Data::TabSharingSession_StartSharingThisTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabSharingSession_StopTabSharing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabSharingSession_StopTabSharing_Params_Data* object =
      static_cast<const TabSharingSession_StopTabSharing_Params_Data*>(data);

  return true;
}

TabSharingSession_StopTabSharing_Params_Data::TabSharingSession_StopTabSharing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertSelectionCancellation_CancelCertSelection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertSelectionCancellation_CancelCertSelection_Params_Data* object =
      static_cast<const CertSelectionCancellation_CancelCertSelection_Params_Data*>(data);

  return true;
}

CertSelectionCancellation_CancelCertSelection_Params_Data::CertSelectionCancellation_CancelCertSelection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CurrentURLChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CurrentURLChanged_Params_Data* object =
      static_cast<const WebViewClient_CurrentURLChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->entryUrl, validation_context))
    return false;

  return true;
}

WebViewClient_CurrentURLChanged_Params_Data::WebViewClient_CurrentURLChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CurrentTitleChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CurrentTitleChanged_Params_Data* object =
      static_cast<const WebViewClient_CurrentTitleChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  return true;
}

WebViewClient_CurrentTitleChanged_Params_Data::WebViewClient_CurrentTitleChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CurrentFaviconChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CurrentFaviconChanged_Params_Data* object =
      static_cast<const WebViewClient_CurrentFaviconChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->favicon_url, validation_context))
    return false;

  return true;
}

WebViewClient_CurrentFaviconChanged_Params_Data::WebViewClient_CurrentFaviconChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CurrentMimeTypeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CurrentMimeTypeChanged_Params_Data* object =
      static_cast<const WebViewClient_CurrentMimeTypeChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  return true;
}

WebViewClient_CurrentMimeTypeChanged_Params_Data::WebViewClient_CurrentMimeTypeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CanGoBackForwardChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CanGoBackForwardChanged_Params_Data* object =
      static_cast<const WebViewClient_CanGoBackForwardChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->back_forward_state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->back_forward_state, validation_context))
    return false;

  return true;
}

WebViewClient_CanGoBackForwardChanged_Params_Data::WebViewClient_CanGoBackForwardChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_SessionDataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_SessionDataChanged_Params_Data* object =
      static_cast<const WebViewClient_SessionDataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_data, validation_context,
                                         &session_data_validate_params)) {
    return false;
  }

  return true;
}

WebViewClient_SessionDataChanged_Params_Data::WebViewClient_SessionDataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_DidCommit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_DidCommit_Params_Data* object =
      static_cast<const WebViewClient_DidCommit_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  return true;
}

WebViewClient_DidCommit_Params_Data::WebViewClient_DidCommit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_LoadingStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_LoadingStateChanged_Params_Data* object =
      static_cast<const WebViewClient_LoadingStateChanged_Params_Data*>(data);

  return true;
}

WebViewClient_LoadingStateChanged_Params_Data::WebViewClient_LoadingStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_UpdateTargetURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_UpdateTargetURL_Params_Data* object =
      static_cast<const WebViewClient_UpdateTargetURL_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->target_url, validation_context))
    return false;

  return true;
}

WebViewClient_UpdateTargetURL_Params_Data::WebViewClient_UpdateTargetURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ZoomStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ZoomStateChanged_Params_Data* object =
      static_cast<const WebViewClient_ZoomStateChanged_Params_Data*>(data);

  return true;
}

WebViewClient_ZoomStateChanged_Params_Data::WebViewClient_ZoomStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_MuteStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_MuteStateChanged_Params_Data* object =
      static_cast<const WebViewClient_MuteStateChanged_Params_Data*>(data);

  return true;
}

WebViewClient_MuteStateChanged_Params_Data::WebViewClient_MuteStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_OnVisibleSecurityStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_OnVisibleSecurityStateChanged_Params_Data* object =
      static_cast<const WebViewClient_OnVisibleSecurityStateChanged_Params_Data*>(data);


  if (!::owl::mojom::internal::SecurityLevel_Data
        ::Validate(object->security_level, validation_context))
    return false;

  return true;
}

WebViewClient_OnVisibleSecurityStateChanged_Params_Data::WebViewClient_OnVisibleSecurityStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowTabSharingButtons_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowTabSharingButtons_Params_Data* object =
      static_cast<const WebViewClient_ShowTabSharingButtons_Params_Data*>(data);


  if (!::owl::mojom::internal::TabSharingTabRole_Data
        ::Validate(object->role, validation_context))
    return false;


  if (!::owl::mojom::internal::TabSharingButtonState_Data
        ::Validate(object->share_this_tab_instead_button_state, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->tab_sharing_session, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->tab_sharing_session,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_ShowTabSharingButtons_Params_Data::WebViewClient_ShowTabSharingButtons_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RemoveTabSharingButtons_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RemoveTabSharingButtons_Params_Data* object =
      static_cast<const WebViewClient_RemoveTabSharingButtons_Params_Data*>(data);

  return true;
}

WebViewClient_RemoveTabSharingButtons_Params_Data::WebViewClient_RemoveTabSharingButtons_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_OnCloseRequestedByHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_OnCloseRequestedByHost_Params_Data* object =
      static_cast<const WebViewClient_OnCloseRequestedByHost_Params_Data*>(data);

  return true;
}

WebViewClient_OnCloseRequestedByHost_Params_Data::WebViewClient_OnCloseRequestedByHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ActivateContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ActivateContent_Params_Data* object =
      static_cast<const WebViewClient_ActivateContent_Params_Data*>(data);

  return true;
}

WebViewClient_ActivateContent_Params_Data::WebViewClient_ActivateContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RenderProcessStatusChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RenderProcessStatusChanged_Params_Data* object =
      static_cast<const WebViewClient_RenderProcessStatusChanged_Params_Data*>(data);


  if (!::owl::mojom::internal::RenderProcessStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

WebViewClient_RenderProcessStatusChanged_Params_Data::WebViewClient_RenderProcessStatusChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_PrimaryPageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_PrimaryPageChanged_Params_Data* object =
      static_cast<const WebViewClient_PrimaryPageChanged_Params_Data*>(data);

  return true;
}

WebViewClient_PrimaryPageChanged_Params_Data::WebViewClient_PrimaryPageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_SelectClientCert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_SelectClientCert_Params_Data* object =
      static_cast<const WebViewClient_SelectClientCert_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->available_certs, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& available_certs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->available_certs, validation_context,
                                         &available_certs_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cancellation_receiver, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cancellation_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_SelectClientCert_Params_Data::WebViewClient_SelectClientCert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_SelectClientCert_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_SelectClientCert_ResponseParams_Data* object =
      static_cast<const WebViewClient_SelectClientCert_ResponseParams_Data*>(data);

  return true;
}

WebViewClient_SelectClientCert_ResponseParams_Data::WebViewClient_SelectClientCert_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RunJavaScriptDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RunJavaScriptDialog_Params_Data* object =
      static_cast<const WebViewClient_RunJavaScriptDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requesting_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requesting_origin, validation_context))
    return false;


  if (!::owl::mojom::internal::JavaScriptDialogType_Data
        ::Validate(object->dialog_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_prompt, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_prompt, validation_context))
    return false;

  return true;
}

WebViewClient_RunJavaScriptDialog_Params_Data::WebViewClient_RunJavaScriptDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RunJavaScriptDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RunJavaScriptDialog_ResponseParams_Data* object =
      static_cast<const WebViewClient_RunJavaScriptDialog_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_input, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_input, validation_context))
    return false;

  return true;
}

WebViewClient_RunJavaScriptDialog_ResponseParams_Data::WebViewClient_RunJavaScriptDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RunBeforeUnloadDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RunBeforeUnloadDialog_Params_Data* object =
      static_cast<const WebViewClient_RunBeforeUnloadDialog_Params_Data*>(data);

  return true;
}

WebViewClient_RunBeforeUnloadDialog_Params_Data::WebViewClient_RunBeforeUnloadDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data* object =
      static_cast<const WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_input, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->user_input, validation_context))
    return false;

  return true;
}

WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data::WebViewClient_RunBeforeUnloadDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowRepostFormWarningDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowRepostFormWarningDialog_Params_Data* object =
      static_cast<const WebViewClient_ShowRepostFormWarningDialog_Params_Data*>(data);

  return true;
}

WebViewClient_ShowRepostFormWarningDialog_Params_Data::WebViewClient_ShowRepostFormWarningDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data* object =
      static_cast<const WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data*>(data);


  if (!::owl::mojom::internal::RepostFormWarningResponse_Data
        ::Validate(object->response, validation_context))
    return false;

  return true;
}

WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data::WebViewClient_ShowRepostFormWarningDialog_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_EnterFullScreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_EnterFullScreen_Params_Data* object =
      static_cast<const WebViewClient_EnterFullScreen_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

WebViewClient_EnterFullScreen_Params_Data::WebViewClient_EnterFullScreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_EnterFullScreen_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_EnterFullScreen_ResponseParams_Data* object =
      static_cast<const WebViewClient_EnterFullScreen_ResponseParams_Data*>(data);

  return true;
}

WebViewClient_EnterFullScreen_ResponseParams_Data::WebViewClient_EnterFullScreen_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ExitFullScreen_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ExitFullScreen_Params_Data* object =
      static_cast<const WebViewClient_ExitFullScreen_Params_Data*>(data);

  return true;
}

WebViewClient_ExitFullScreen_Params_Data::WebViewClient_ExitFullScreen_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_OnAuthenticationURLSchemeFound_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_OnAuthenticationURLSchemeFound_Params_Data* object =
      static_cast<const WebViewClient_OnAuthenticationURLSchemeFound_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

WebViewClient_OnAuthenticationURLSchemeFound_Params_Data::WebViewClient_OnAuthenticationURLSchemeFound_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CreatedNewWebView_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CreatedNewWebView_Params_Data* object =
      static_cast<const WebViewClient_CreatedNewWebView_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->disposition, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->disposition, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->web_view, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->web_view,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->web_view_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->web_view_client,
                                                 validation_context)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  return true;
}

WebViewClient_CreatedNewWebView_Params_Data::WebViewClient_CreatedNewWebView_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_DevToolsDockSideChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_DevToolsDockSideChanged_Params_Data* object =
      static_cast<const WebViewClient_DevToolsDockSideChanged_Params_Data*>(data);


  if (!::owl::mojom::internal::DevToolsDockSide_Data
        ::Validate(object->dock_side, validation_context))
    return false;

  return true;
}

WebViewClient_DevToolsDockSideChanged_Params_Data::WebViewClient_DevToolsDockSideChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_DevToolsClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_DevToolsClosed_Params_Data* object =
      static_cast<const WebViewClient_DevToolsClosed_Params_Data*>(data);

  return true;
}

WebViewClient_DevToolsClosed_Params_Data::WebViewClient_DevToolsClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_RedispatchKeyEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_RedispatchKeyEvent_Params_Data* object =
      static_cast<const WebViewClient_RedispatchKeyEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_event_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_event_data, validation_context,
                                         &native_event_data_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::InputSource_Data
        ::Validate(object->original_input_source, validation_context))
    return false;

  return true;
}

WebViewClient_RedispatchKeyEvent_Params_Data::WebViewClient_RedispatchKeyEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CreateWindowBridge_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CreateWindowBridge_Params_Data* object =
      static_cast<const WebViewClient_CreateWindowBridge_Params_Data*>(data);


  if (!::owl::mojom::internal::WindowBridgeSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_CreateWindowBridge_Params_Data::WebViewClient_CreateWindowBridge_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_BindFrontendHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_BindFrontendHost_Params_Data* object =
      static_cast<const WebViewClient_BindFrontendHost_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_BindFrontendHost_Params_Data::WebViewClient_BindFrontendHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_OnTabRendererDataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_OnTabRendererDataChanged_Params_Data* object =
      static_cast<const WebViewClient_OnTabRendererDataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

WebViewClient_OnTabRendererDataChanged_Params_Data::WebViewClient_OnTabRendererDataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_OnFocusChangedInPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_OnFocusChangedInPage_Params_Data* object =
      static_cast<const WebViewClient_OnFocusChangedInPage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_bounds_in_view, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->node_bounds_in_view, validation_context))
    return false;

  return true;
}

WebViewClient_OnFocusChangedInPage_Params_Data::WebViewClient_OnFocusChangedInPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data* object =
      static_cast<const WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->link_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->link_url, validation_context))
    return false;

  return true;
}

WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data::WebViewClient_OnOffOriginLinkLoadCanceled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_GoBackOrLoadNewTab_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_GoBackOrLoadNewTab_Params_Data* object =
      static_cast<const WebViewClient_GoBackOrLoadNewTab_Params_Data*>(data);

  return true;
}

WebViewClient_GoBackOrLoadNewTab_Params_Data::WebViewClient_GoBackOrLoadNewTab_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowPermissionPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowPermissionPrompt_Params_Data* object =
      static_cast<const WebViewClient_ShowPermissionPrompt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_ShowPermissionPrompt_Params_Data::WebViewClient_ShowPermissionPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowSavePasswordPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowSavePasswordPrompt_Params_Data* object =
      static_cast<const WebViewClient_ShowSavePasswordPrompt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_ShowSavePasswordPrompt_Params_Data::WebViewClient_ShowSavePasswordPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowSaveAddressPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowSaveAddressPrompt_Params_Data* object =
      static_cast<const WebViewClient_ShowSaveAddressPrompt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_ShowSaveAddressPrompt_Params_Data::WebViewClient_ShowSaveAddressPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowSaveCardPrompt_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowSaveCardPrompt_Params_Data* object =
      static_cast<const WebViewClient_ShowSaveCardPrompt_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->prompt_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->prompt_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_ShowSaveCardPrompt_Params_Data::WebViewClient_ShowSaveCardPrompt_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_ShowAutofillPopup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_ShowAutofillPopup_Params_Data* object =
      static_cast<const WebViewClient_ShowAutofillPopup_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->details, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->popup, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->popup,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->popup_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->popup_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebViewClient_ShowAutofillPopup_Params_Data::WebViewClient_ShowAutofillPopup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_SetPreferredSizeFromAutoResize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_SetPreferredSizeFromAutoResize_Params_Data* object =
      static_cast<const WebViewClient_SetPreferredSizeFromAutoResize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_size, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_size, validation_context))
    return false;

  return true;
}

WebViewClient_SetPreferredSizeFromAutoResize_Params_Data::WebViewClient_SetPreferredSizeFromAutoResize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_DeleteBrowsingData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_DeleteBrowsingData_Params_Data* object =
      static_cast<const WebViewClient_DeleteBrowsingData_Params_Data*>(data);

  return true;
}

WebViewClient_DeleteBrowsingData_Params_Data::WebViewClient_DeleteBrowsingData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CanDeleteHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CanDeleteHistory_Params_Data* object =
      static_cast<const WebViewClient_CanDeleteHistory_Params_Data*>(data);

  return true;
}

WebViewClient_CanDeleteHistory_Params_Data::WebViewClient_CanDeleteHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_CanDeleteHistory_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_CanDeleteHistory_ResponseParams_Data* object =
      static_cast<const WebViewClient_CanDeleteHistory_ResponseParams_Data*>(data);

  return true;
}

WebViewClient_CanDeleteHistory_ResponseParams_Data::WebViewClient_CanDeleteHistory_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebViewClient_SetHasPendingProtocolHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebViewClient_SetHasPendingProtocolHandler_Params_Data* object =
      static_cast<const WebViewClient_SetHasPendingProtocolHandler_Params_Data*>(data);

  return true;
}

WebViewClient_SetHasPendingProtocolHandler_Params_Data::WebViewClient_SetHasPendingProtocolHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::DevToolsPanel>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::DevToolsPanel value) {
  return std::move(context).WriteString(::owl::mojom::DevToolsPanelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::TabAlertState>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::TabAlertState value) {
  return std::move(context).WriteString(::owl::mojom::TabAlertStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::TabNetworkState>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::TabNetworkState value) {
  return std::move(context).WriteString(::owl::mojom::TabNetworkStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::NavigationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::NavigationType value) {
  return std::move(context).WriteString(::owl::mojom::NavigationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::TransitionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::TransitionType value) {
  return std::move(context).WriteString(::owl::mojom::TransitionTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::SecurityLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::SecurityLevel value) {
  return std::move(context).WriteString(::owl::mojom::SecurityLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::FindDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::FindDirection value) {
  return std::move(context).WriteString(::owl::mojom::FindDirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::JavaScriptDialogType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::JavaScriptDialogType value) {
  return std::move(context).WriteString(::owl::mojom::JavaScriptDialogTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::TabSharingButtonState>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::TabSharingButtonState value) {
  return std::move(context).WriteString(::owl::mojom::TabSharingButtonStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::TabSharingTabRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::TabSharingTabRole value) {
  return std::move(context).WriteString(::owl::mojom::TabSharingTabRoleToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::RepostFormWarningResponse>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::RepostFormWarningResponse value) {
  return std::move(context).WriteString(::owl::mojom::RepostFormWarningResponseToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::WindowBridgeSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::WindowBridgeSource value) {
  return std::move(context).WriteString(::owl::mojom::WindowBridgeSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::DevToolsDockSide>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::DevToolsDockSide value) {
  return std::move(context).WriteString(::owl::mojom::DevToolsDockSideToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::RenderProcessStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::RenderProcessStatus value) {
  return std::move(context).WriteString(::owl::mojom::RenderProcessStatusToString(value));
}

} // namespace perfetto