// owl/mojom/web_view.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_MOJOM_DATA_VIEW_H_
#define OWL_MOJOM_WEB_VIEW_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "owl/mojom/web_view.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "owl/mojom/address_prompt.mojom-shared.h"
#include "owl/mojom/autofill_popup.mojom-shared.h"
#include "owl/mojom/card_prompt.mojom-shared.h"
#include "owl/mojom/chatgpt_frontend.mojom-shared.h"
#include "owl/mojom/context_menu_params.mojom-shared.h"
#include "owl/mojom/password_prompt.mojom-shared.h"
#include "owl/mojom/permission_prompt.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event.mojom-shared.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/remote_cocoa/common/application.mojom-shared.h"


namespace owl::mojom {
class FindResultDataView;

class DOMElementReferenceDataView;

class NavigationEntryDataView;

class SerializedDomElementInfoDataView;

class TabRendererDataDataView;

class ClipboardOverrideDataView;

class CertificateChainDataView;

class StoragePartitionDescriptorDataView;

class ClientCertMetadataDataView;

class PictureInPictureConfigDataView;

class WindowOpenContextDataView;

class ExtensionPopupContextDataView;

class DevToolsContextDataView;

class BackForwardStateDataView;

class NavigationEntryStateDataView;

class CommitDetailsDataView;

class NavigationEntryUrlDataView;

class SnapshotResultDataView;
class WebViewDispositionDataView;


}  // owl::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::owl::mojom::FindResultDataView> {
  using Data = ::owl::mojom::internal::FindResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::DOMElementReferenceDataView> {
  using Data = ::owl::mojom::internal::DOMElementReference_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::NavigationEntryDataView> {
  using Data = ::owl::mojom::internal::NavigationEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::SerializedDomElementInfoDataView> {
  using Data = ::owl::mojom::internal::SerializedDomElementInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::TabRendererDataDataView> {
  using Data = ::owl::mojom::internal::TabRendererData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ClipboardOverrideDataView> {
  using Data = ::owl::mojom::internal::ClipboardOverride_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CertificateChainDataView> {
  using Data = ::owl::mojom::internal::CertificateChain_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::StoragePartitionDescriptorDataView> {
  using Data = ::owl::mojom::internal::StoragePartitionDescriptor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ClientCertMetadataDataView> {
  using Data = ::owl::mojom::internal::ClientCertMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::PictureInPictureConfigDataView> {
  using Data = ::owl::mojom::internal::PictureInPictureConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::WindowOpenContextDataView> {
  using Data = ::owl::mojom::internal::WindowOpenContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::ExtensionPopupContextDataView> {
  using Data = ::owl::mojom::internal::ExtensionPopupContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::DevToolsContextDataView> {
  using Data = ::owl::mojom::internal::DevToolsContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::BackForwardStateDataView> {
  using Data = ::owl::mojom::internal::BackForwardState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::NavigationEntryStateDataView> {
  using Data = ::owl::mojom::internal::NavigationEntryState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::CommitDetailsDataView> {
  using Data = ::owl::mojom::internal::CommitDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::NavigationEntryUrlDataView> {
  using Data = ::owl::mojom::internal::NavigationEntryUrl_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::owl::mojom::SnapshotResultDataView> {
  using Data = ::owl::mojom::internal::SnapshotResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::owl::mojom::WebViewDispositionDataView> {
  using Data = ::owl::mojom::internal::WebViewDisposition_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace owl::mojom {


enum class DevToolsPanel : int32_t {
  
  kConsole = 0,
  
  kInspector = 1,
  
  kSources = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DevToolsPanel value);
inline bool IsKnownEnumValue(DevToolsPanel value) {
  return internal::DevToolsPanel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabAlertState : int32_t {
  
  kMediaRecording = 0,
  
  kTabCapturing = 1,
  
  kAudioPlaying = 2,
  
  kAudioMuting = 3,
  
  kBluetoothConnected = 4,
  
  kBluetoothScanActive = 5,
  
  kUsbConnected = 6,
  
  kHidConnected = 7,
  
  kSerialConnected = 8,
  
  kPipPlaying = 9,
  
  kDesktopCapturing = 10,
  
  kVrPresentingInHeadset = 11,
  
  kAudioRecording = 12,
  
  kVideoRecording = 13,
  
  kGlicAccessing = 14,
  
  kActorAccessing = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

 std::ostream& operator<<(std::ostream& os, TabAlertState value);
inline bool IsKnownEnumValue(TabAlertState value) {
  return internal::TabAlertState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabNetworkState : int32_t {
  
  kNone = 0,
  
  kWaiting = 1,
  
  kLoading = 2,
  
  kError = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, TabNetworkState value);
inline bool IsKnownEnumValue(TabNetworkState value) {
  return internal::TabNetworkState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NavigationType : int32_t {
  
  kTyped = 0,
  
  kBookmark = 1,
  
  kLink = 2,
  
  kSuggestion = 3,
  
  kContextMenu = 4,
  
  kKeyword = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, NavigationType value);
inline bool IsKnownEnumValue(NavigationType value) {
  return internal::NavigationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TransitionType : int32_t {
  
  kTyped = 0,
  
  kLinkActivated = 1,
  
  kFormSubmitted = 2,
  
  kBackForward = 3,
  
  kReload = 4,
  
  kFormResubmitted = 5,
  
  kOther = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, TransitionType value);
inline bool IsKnownEnumValue(TransitionType value) {
  return internal::TransitionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SecurityLevel : int32_t {
  
  kNone = 0,
  
  kSecure = 1,
  
  kWarning = 2,
  
  kDangerous = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SecurityLevel value);
inline bool IsKnownEnumValue(SecurityLevel value) {
  return internal::SecurityLevel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FindDirection : int32_t {
  
  kForward = 0,
  
  kBackward = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, FindDirection value);
inline bool IsKnownEnumValue(FindDirection value) {
  return internal::FindDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class JavaScriptDialogType : int32_t {
  
  kAlert = 0,
  
  kConfirm = 1,
  
  kPrompt = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, JavaScriptDialogType value);
inline bool IsKnownEnumValue(JavaScriptDialogType value) {
  return internal::JavaScriptDialogType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabSharingButtonState : int32_t {
  
  kEnabled = 0,
  
  kDisabled = 1,
  
  kNotShown = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TabSharingButtonState value);
inline bool IsKnownEnumValue(TabSharingButtonState value) {
  return internal::TabSharingButtonState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TabSharingTabRole : int32_t {
  
  kCapturingTab = 0,
  
  kCapturedTab = 1,
  
  kSelfCapturingTab = 2,
  
  kOtherTab = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, TabSharingTabRole value);
inline bool IsKnownEnumValue(TabSharingTabRole value) {
  return internal::TabSharingTabRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RepostFormWarningResponse : int32_t {
  
  kAccepted = 0,
  
  kCanceled = 1,
  
  kClosed = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RepostFormWarningResponse value);
inline bool IsKnownEnumValue(RepostFormWarningResponse value) {
  return internal::RepostFormWarningResponse_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WindowBridgeSource : int32_t {
  
  kWebModalDialog = 0,
  
  kVideoPictureInPicture = 1,
  
  kEmbeddedPermissionPrompt = 2,
  
  kBubblePermissionPrompt = 3,
  
  kExtensionDialog = 4,
  
  kPasswordUpdateState = 5,
  
  kWebBubbleDialog = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, WindowBridgeSource value);
inline bool IsKnownEnumValue(WindowBridgeSource value) {
  return internal::WindowBridgeSource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DevToolsDockSide : int32_t {
  
  kUndocked = 0,
  
  kBottom = 1,
  
  kLeft = 2,
  
  kRight = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DevToolsDockSide value);
inline bool IsKnownEnumValue(DevToolsDockSide value) {
  return internal::DevToolsDockSide_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RenderProcessStatus : int32_t {
  
  kCrashed = 0,
  
  kNotRunning = 1,
  
  kUnresponsive = 2,
  
  kResponsive = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, RenderProcessStatus value);
inline bool IsKnownEnumValue(RenderProcessStatus value) {
  return internal::RenderProcessStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FindClientInterfaceBase {};

using FindClientPtrDataView =
    mojo::InterfacePtrDataView<FindClientInterfaceBase>;
using FindClientRequestDataView =
    mojo::InterfaceRequestDataView<FindClientInterfaceBase>;
using FindClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FindClientInterfaceBase>;
using FindClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FindClientInterfaceBase>;
class DevToolsSessionInterfaceBase {};

using DevToolsSessionPtrDataView =
    mojo::InterfacePtrDataView<DevToolsSessionInterfaceBase>;
using DevToolsSessionRequestDataView =
    mojo::InterfaceRequestDataView<DevToolsSessionInterfaceBase>;
using DevToolsSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DevToolsSessionInterfaceBase>;
using DevToolsSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DevToolsSessionInterfaceBase>;
class DevToolsSessionClientInterfaceBase {};

using DevToolsSessionClientPtrDataView =
    mojo::InterfacePtrDataView<DevToolsSessionClientInterfaceBase>;
using DevToolsSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<DevToolsSessionClientInterfaceBase>;
using DevToolsSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DevToolsSessionClientInterfaceBase>;
using DevToolsSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DevToolsSessionClientInterfaceBase>;
class WebViewInterfaceBase {};

using WebViewPtrDataView =
    mojo::InterfacePtrDataView<WebViewInterfaceBase>;
using WebViewRequestDataView =
    mojo::InterfaceRequestDataView<WebViewInterfaceBase>;
using WebViewAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebViewInterfaceBase>;
using WebViewAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebViewInterfaceBase>;
class TabSharingSessionInterfaceBase {};

using TabSharingSessionPtrDataView =
    mojo::InterfacePtrDataView<TabSharingSessionInterfaceBase>;
using TabSharingSessionRequestDataView =
    mojo::InterfaceRequestDataView<TabSharingSessionInterfaceBase>;
using TabSharingSessionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TabSharingSessionInterfaceBase>;
using TabSharingSessionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TabSharingSessionInterfaceBase>;
class CertSelectionCancellationInterfaceBase {};

using CertSelectionCancellationPtrDataView =
    mojo::InterfacePtrDataView<CertSelectionCancellationInterfaceBase>;
using CertSelectionCancellationRequestDataView =
    mojo::InterfaceRequestDataView<CertSelectionCancellationInterfaceBase>;
using CertSelectionCancellationAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertSelectionCancellationInterfaceBase>;
using CertSelectionCancellationAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertSelectionCancellationInterfaceBase>;
class WebViewClientInterfaceBase {};

using WebViewClientPtrDataView =
    mojo::InterfacePtrDataView<WebViewClientInterfaceBase>;
using WebViewClientRequestDataView =
    mojo::InterfaceRequestDataView<WebViewClientInterfaceBase>;
using WebViewClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebViewClientInterfaceBase>;
using WebViewClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebViewClientInterfaceBase>;


class FindResultDataView {
 public:
  FindResultDataView() = default;

  FindResultDataView(
      internal::FindResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t current_match_index() const {
    return data_->current_match_index;
  }
  int32_t number_of_matches() const {
    return data_->number_of_matches;
  }
 private:
  internal::FindResult_Data* data_ = nullptr;
};


class DOMElementReferenceDataView {
 public:
  DOMElementReferenceDataView() = default;

  DOMElementReferenceDataView(
      internal::DOMElementReference_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t frame_routing_id() const {
    return data_->frame_routing_id;
  }
  int32_t frame_process_id() const {
    return data_->frame_process_id;
  }
  int32_t x() const {
    return data_->x;
  }
  int32_t y() const {
    return data_->y;
  }
 private:
  internal::DOMElementReference_Data* data_ = nullptr;
};


class NavigationEntryDataView {
 public:
  NavigationEntryDataView() = default;

  NavigationEntryDataView(
      internal::NavigationEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t unique_id() const {
    return data_->unique_id;
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `favicon_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFaviconUrl` instead "
    "of `ReadFaviconUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SerializedDomElementInfoDataView {
 public:
  SerializedDomElementInfoDataView() = default;

  SerializedDomElementInfoDataView(
      internal::SerializedDomElementInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSelectorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelector(UserType* output) {
    
    auto* pointer = data_->selector.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleBoundsDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleBounds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `visible_bounds` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadVisibleBounds` instead "
    "of `ReadVisibleBounds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->visible_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetClickPointDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClickPoint(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointDataView, UserType>(),
    "Attempting to read the optional `click_point` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClickPoint` instead "
    "of `ReadClickPoint if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->click_point.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
 private:
  internal::SerializedDomElementInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabRendererDataDataView {
 public:
  TabRendererDataDataView() = default;

  TabRendererDataDataView(
      internal::TabRendererData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool blocked() const {
    return data_->blocked;
  }
  bool crashed() const {
    return data_->crashed;
  }
  inline void GetAlertStatesDataView(
      mojo::ArrayDataView<TabAlertState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlertStates(UserType* output) {
    
    auto* pointer = data_->alert_states.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::owl::mojom::TabAlertState>>(
        pointer, output, message_);
  }
  inline void GetFaviconImageDataView(
      ::gfx::mojom::ImageSkiaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ImageSkiaDataView, UserType>(),
    "Attempting to read the optional `favicon_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFaviconImage` instead "
    "of `ReadFaviconImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->favicon_image.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ImageSkiaDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkState(UserType* output) const {
    auto data_value = data_->network_state;
    return mojo::internal::Deserialize<::owl::mojom::TabNetworkState>(
        data_value, output);
  }
  TabNetworkState network_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::TabNetworkState>(data_->network_state));
  }
  bool should_hide_loading_throbber() const {
    return data_->should_hide_loading_throbber;
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetLastCommittedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastCommittedUrl(UserType* output) {
    
    auto* pointer = data_->last_committed_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleUrl(UserType* output) {
    
    auto* pointer = data_->visible_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabRendererData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClipboardOverrideDataView {
 public:
  ClipboardOverrideDataView() = default;

  ClipboardOverrideDataView(
      internal::ClipboardOverride_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadText` instead "
    "of `ReadText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetHtmlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHtml(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `html` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHtml` instead "
    "of `ReadHtml if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->html.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::ClipboardOverride_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertificateChainDataView {
 public:
  CertificateChainDataView() = default;

  CertificateChainDataView(
      internal::CertificateChain_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDerChainDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDerChain(UserType* output) {
    
    auto* pointer = data_->der_chain.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::CertificateChain_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StoragePartitionDescriptorDataView {
 public:
  StoragePartitionDescriptorDataView() = default;

  StoragePartitionDescriptorDataView(
      internal::StoragePartitionDescriptor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPartitionDomainDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionDomain(UserType* output) {
    
    auto* pointer = data_->partition_domain.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPartitionNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionName(UserType* output) {
    
    auto* pointer = data_->partition_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool in_memory() const {
    return data_->in_memory;
  }
 private:
  internal::StoragePartitionDescriptor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClientCertMetadataDataView {
 public:
  ClientCertMetadataDataView() = default;

  ClientCertMetadataDataView(
      internal::ClientCertMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSubjectDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubject(UserType* output) {
    
    auto* pointer = data_->subject.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIssuerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssuer(UserType* output) {
    
    auto* pointer = data_->issuer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerialDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerial(UserType* output) {
    
    auto* pointer = data_->serial.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ClientCertMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PictureInPictureConfigDataView {
 public:
  PictureInPictureConfigDataView() = default;

  PictureInPictureConfigDataView(
      internal::PictureInPictureConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWindowOptionsDataView(
      ::blink::mojom::PictureInPictureWindowOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowOptions(UserType* output) {
    
    auto* pointer = data_->window_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PictureInPictureWindowOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PictureInPictureConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WindowOpenContextDataView {
 public:
  WindowOpenContextDataView() = default;

  WindowOpenContextDataView(
      internal::WindowOpenContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }
  ::ui::mojom::WindowOpenDisposition disposition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition));
  }
  inline void GetWindowFeaturesDataView(
      ::blink::mojom::WindowFeaturesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWindowFeatures(UserType* output) {
    
    auto* pointer = data_->window_features.Get();
    return mojo::internal::Deserialize<::blink::mojom::WindowFeaturesDataView>(
        pointer, output, message_);
  }
 private:
  internal::WindowOpenContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ExtensionPopupContextDataView {
 public:
  ExtensionPopupContextDataView() = default;

  ExtensionPopupContextDataView(
      internal::ExtensionPopupContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExtensionPopupContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsContextDataView {
 public:
  DevToolsContextDataView() = default;

  DevToolsContextDataView(
      internal::DevToolsContext_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDockSide(UserType* output) const {
    auto data_value = data_->dock_side;
    return mojo::internal::Deserialize<::owl::mojom::DevToolsDockSide>(
        data_value, output);
  }
  DevToolsDockSide dock_side() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::DevToolsDockSide>(data_->dock_side));
  }
 private:
  internal::DevToolsContext_Data* data_ = nullptr;
};


class BackForwardStateDataView {
 public:
  BackForwardStateDataView() = default;

  BackForwardStateDataView(
      internal::BackForwardState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool can_go_back() const {
    return data_->can_go_back;
  }
  bool can_go_forward() const {
    return data_->can_go_forward;
  }
 private:
  internal::BackForwardState_Data* data_ = nullptr;
};


class NavigationEntryStateDataView {
 public:
  NavigationEntryStateDataView() = default;

  NavigationEntryStateDataView(
      internal::NavigationEntryState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      NavigationEntryUrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::NavigationEntryUrlDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::owl::mojom::NavigationEntryUrlDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetBackForwardStateDataView(
      BackForwardStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackForwardState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::owl::mojom::BackForwardStateDataView, UserType>(),
    "Attempting to read the optional `back_forward_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBackForwardState` instead "
    "of `ReadBackForwardState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->back_forward_state.Get();
    return mojo::internal::Deserialize<::owl::mojom::BackForwardStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationEntryState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommitDetailsDataView {
 public:
  CommitDetailsDataView() = default;

  CommitDetailsDataView(
      internal::CommitDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadTransitionType(UserType* output) const {
    auto data_value = data_->transition_type;
    return mojo::internal::Deserialize<::owl::mojom::TransitionType>(
        data_value, output);
  }
  TransitionType transition_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::owl::mojom::TransitionType>(data_->transition_type));
  }
  bool is_redirect() const {
    return data_->is_redirect;
  }
  bool is_chatgpt_frontend() const {
    return data_->is_chatgpt_frontend;
  }
  bool did_replace_entry() const {
    return data_->did_replace_entry;
  }
  bool is_same_document() const {
    return data_->is_same_document;
  }
  int32_t entry_id() const {
    return data_->entry_id;
  }
  inline void GetRemovedEntryIdsDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedEntryIds(UserType* output) {
    
    auto* pointer = data_->removed_entry_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  int64_t main_frame_document_id() const {
    return data_->main_frame_document_id;
  }
  inline void GetRemovedMainFrameDocumentIdsDataView(
      mojo::ArrayDataView<int64_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedMainFrameDocumentIds(UserType* output) {
    
    auto* pointer = data_->removed_main_frame_document_ids.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        pointer, output, message_);
  }
  inline void GetEntryStateDataView(
      NavigationEntryStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEntryState(UserType* output) {
    
    auto* pointer = data_->entry_state.Get();
    return mojo::internal::Deserialize<::owl::mojom::NavigationEntryStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::CommitDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NavigationEntryUrlDataView {
 public:
  NavigationEntryUrlDataView() = default;

  NavigationEntryUrlDataView(
      internal::NavigationEntryUrl_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetRedirectChainStartDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectChainStart(UserType* output) {
    
    auto* pointer = data_->redirect_chain_start.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::NavigationEntryUrl_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SnapshotResultDataView {
 public:
  using Tag = internal::SnapshotResult_Data::SnapshotResult_Tag;

  SnapshotResultDataView() = default;

  SnapshotResultDataView(
      internal::SnapshotResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_image() const { return data_->tag == Tag::kImage; }
  inline void GetImageDataView(
      ::skia::mojom::BitmapN32DataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) const {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImage` instead "
    "of `ReadImage if you're fine with null values being "
    "silently ignored in this case.");
    CHECK(is_image());
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        data_->data.f_image.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::SnapshotResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class WebViewDispositionDataView {
 public:
  using Tag = internal::WebViewDisposition_Data::WebViewDisposition_Tag;

  WebViewDispositionDataView() = default;

  WebViewDispositionDataView(
      internal::WebViewDisposition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_window_open() const { return data_->tag == Tag::kWindowOpen; }
  inline void GetWindowOpenDataView(
      WindowOpenContextDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadWindowOpen(UserType* output) const {
    
    CHECK(is_window_open());
    return mojo::internal::Deserialize<::owl::mojom::WindowOpenContextDataView>(
        data_->data.f_window_open.Get(), output, message_);
  }
  bool is_picture_in_picture() const { return data_->tag == Tag::kPictureInPicture; }
  inline void GetPictureInPictureDataView(
      PictureInPictureConfigDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPictureInPicture(UserType* output) const {
    
    CHECK(is_picture_in_picture());
    return mojo::internal::Deserialize<::owl::mojom::PictureInPictureConfigDataView>(
        data_->data.f_picture_in_picture.Get(), output, message_);
  }
  bool is_print_preview() const { return data_->tag == Tag::kPrintPreview; }
  bool print_preview() const {
    CHECK(is_print_preview());
    return data_->data.f_print_preview;
  }
  bool is_extension_popup() const { return data_->tag == Tag::kExtensionPopup; }
  inline void GetExtensionPopupDataView(
      ExtensionPopupContextDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionPopup(UserType* output) const {
    
    CHECK(is_extension_popup());
    return mojo::internal::Deserialize<::owl::mojom::ExtensionPopupContextDataView>(
        data_->data.f_extension_popup.Get(), output, message_);
  }
  bool is_dev_tools() const { return data_->tag == Tag::kDevTools; }
  inline void GetDevToolsDataView(
      DevToolsContextDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDevTools(UserType* output) const {
    
    CHECK(is_dev_tools());
    return mojo::internal::Deserialize<::owl::mojom::DevToolsContextDataView>(
        data_->data.f_dev_tools.Get(), output, message_);
  }

 private:
  internal::WebViewDisposition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // owl::mojom

#endif  // OWL_MOJOM_WEB_VIEW_MOJOM_DATA_VIEW_H_