// owl/mojom/web_content_renderer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/web_content_renderer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_content_renderer.mojom-params-data.h"
#include "owl/mojom/web_content_renderer.mojom-shared-message-ids.h"

#include "owl/mojom/web_content_renderer.mojom-import-headers.h"
#include "owl/mojom/web_content_renderer.mojom-test-utils.h"


namespace owl::mojom {
RectWithRange::RectWithRange()
    : rect(),
      range() {}

RectWithRange::RectWithRange(
    const ::gfx::Rect& rect_in,
    const ::gfx::Range& range_in)
    : rect(std::move(rect_in)),
      range(std::move(range_in)) {}

RectWithRange::~RectWithRange() = default;

void RectWithRange::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rect"), this->rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "range"), this->range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Range&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RectWithRange::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PopupMenu::PopupMenu()
    : items(),
      bounds(),
      item_font_size(),
      right_aligned(),
      selected_item(),
      receiver() {}

PopupMenu::PopupMenu(
    std::vector<::blink::mojom::MenuItemPtr> items_in,
    const ::gfx::Rect& bounds_in,
    double item_font_size_in,
    bool right_aligned_in,
    uint32_t selected_item_in,
    ::mojo::PendingReceiver<PopupMenuRunner> receiver_in)
    : items(std::move(items_in)),
      bounds(std::move(bounds_in)),
      item_font_size(std::move(item_font_size_in)),
      right_aligned(std::move(right_aligned_in)),
      selected_item(std::move(selected_item_in)),
      receiver(std::move(receiver_in)) {}

PopupMenu::~PopupMenu() = default;

void PopupMenu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::blink::mojom::MenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item_font_size"), this->item_font_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "right_aligned"), this->right_aligned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_item"), this->selected_item,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "receiver"), this->receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<PopupMenuRunner>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PopupMenu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WebContentRenderer::IPCStableHashFunction WebContentRenderer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebContentRenderer>(message.name())) {
    case messages::WebContentRenderer::kIsWidgetForMainFrame: {
      return &WebContentRenderer::IsWidgetForMainFrame_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kRequestShutdown: {
      return &WebContentRenderer::RequestShutdown_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kSetFocusLock: {
      return &WebContentRenderer::SetFocusLock_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kOnFirstResponderChanged: {
      return &WebContentRenderer::OnFirstResponderChanged_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kOnWindowIsKeyChanged: {
      return &WebContentRenderer::OnWindowIsKeyChanged_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kBeginKeyboardEvent: {
      return &WebContentRenderer::BeginKeyboardEvent_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kEndKeyboardEvent: {
      return &WebContentRenderer::EndKeyboardEvent_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kForwardKeyboardEventWithCommands: {
      return &WebContentRenderer::ForwardKeyboardEventWithCommands_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck: {
      return &WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kRouteOrProcessMouseEvent: {
      return &WebContentRenderer::RouteOrProcessMouseEvent_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kRouteOrProcessTouchEvent: {
      return &WebContentRenderer::RouteOrProcessTouchEvent_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kRouteOrProcessWheelEvent: {
      return &WebContentRenderer::RouteOrProcessWheelEvent_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kGestureBegin: {
      return &WebContentRenderer::GestureBegin_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kGestureUpdate: {
      return &WebContentRenderer::GestureUpdate_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kGestureEnd: {
      return &WebContentRenderer::GestureEnd_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kSmartMagnify: {
      return &WebContentRenderer::SmartMagnify_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kImeSetComposition: {
      return &WebContentRenderer::ImeSetComposition_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kImeCommitText: {
      return &WebContentRenderer::ImeCommitText_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kImeFinishComposingText: {
      return &WebContentRenderer::ImeFinishComposingText_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kImeCancelCompositionFromClient: {
      return &WebContentRenderer::ImeCancelCompositionFromClient_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kLookUpDictionaryOverlayAtPoint: {
      return &WebContentRenderer::LookUpDictionaryOverlayAtPoint_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kLookUpDictionaryOverlayFromRange: {
      return &WebContentRenderer::LookUpDictionaryOverlayFromRange_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kGetCharacterIndexAtPoint: {
      return &WebContentRenderer::GetCharacterIndexAtPoint_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kGetFirstRectForRange: {
      return &WebContentRenderer::GetFirstRectForRange_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kExecuteEditCommand: {
      return &WebContentRenderer::ExecuteEditCommand_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kUndo: {
      return &WebContentRenderer::Undo_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kRedo: {
      return &WebContentRenderer::Redo_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kCut: {
      return &WebContentRenderer::Cut_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kCopy: {
      return &WebContentRenderer::Copy_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kCopyToFindPboard: {
      return &WebContentRenderer::CopyToFindPboard_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kCenterSelection: {
      return &WebContentRenderer::CenterSelection_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kPaste: {
      return &WebContentRenderer::Paste_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kPasteAndMatchStyle: {
      return &WebContentRenderer::PasteAndMatchStyle_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kSelectAll: {
      return &WebContentRenderer::SelectAll_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kStartSpeaking: {
      return &WebContentRenderer::StartSpeaking_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kStopSpeaking: {
      return &WebContentRenderer::StopSpeaking_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kIsSpeaking: {
      return &WebContentRenderer::IsSpeaking_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken: {
      return &WebContentRenderer::GetWebContentRendererAccessibilityToken_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kSetRemoteAccessibilityTokens: {
      return &WebContentRenderer::SetRemoteAccessibilityTokens_Sym::IPCStableHash;
    }
    case messages::WebContentRenderer::kPingHostView: {
      return &WebContentRenderer::PingHostView_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebContentRenderer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebContentRenderer>(message.name())) {
      case messages::WebContentRenderer::kIsWidgetForMainFrame:
            return "Receive owl::mojom::WebContentRenderer::IsWidgetForMainFrame";
      case messages::WebContentRenderer::kRequestShutdown:
            return "Receive owl::mojom::WebContentRenderer::RequestShutdown";
      case messages::WebContentRenderer::kSetFocusLock:
            return "Receive owl::mojom::WebContentRenderer::SetFocusLock";
      case messages::WebContentRenderer::kOnFirstResponderChanged:
            return "Receive owl::mojom::WebContentRenderer::OnFirstResponderChanged";
      case messages::WebContentRenderer::kOnWindowIsKeyChanged:
            return "Receive owl::mojom::WebContentRenderer::OnWindowIsKeyChanged";
      case messages::WebContentRenderer::kBeginKeyboardEvent:
            return "Receive owl::mojom::WebContentRenderer::BeginKeyboardEvent";
      case messages::WebContentRenderer::kEndKeyboardEvent:
            return "Receive owl::mojom::WebContentRenderer::EndKeyboardEvent";
      case messages::WebContentRenderer::kForwardKeyboardEventWithCommands:
            return "Receive owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommands";
      case messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck:
            return "Receive owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck";
      case messages::WebContentRenderer::kRouteOrProcessMouseEvent:
            return "Receive owl::mojom::WebContentRenderer::RouteOrProcessMouseEvent";
      case messages::WebContentRenderer::kRouteOrProcessTouchEvent:
            return "Receive owl::mojom::WebContentRenderer::RouteOrProcessTouchEvent";
      case messages::WebContentRenderer::kRouteOrProcessWheelEvent:
            return "Receive owl::mojom::WebContentRenderer::RouteOrProcessWheelEvent";
      case messages::WebContentRenderer::kGestureBegin:
            return "Receive owl::mojom::WebContentRenderer::GestureBegin";
      case messages::WebContentRenderer::kGestureUpdate:
            return "Receive owl::mojom::WebContentRenderer::GestureUpdate";
      case messages::WebContentRenderer::kGestureEnd:
            return "Receive owl::mojom::WebContentRenderer::GestureEnd";
      case messages::WebContentRenderer::kSmartMagnify:
            return "Receive owl::mojom::WebContentRenderer::SmartMagnify";
      case messages::WebContentRenderer::kImeSetComposition:
            return "Receive owl::mojom::WebContentRenderer::ImeSetComposition";
      case messages::WebContentRenderer::kImeCommitText:
            return "Receive owl::mojom::WebContentRenderer::ImeCommitText";
      case messages::WebContentRenderer::kImeFinishComposingText:
            return "Receive owl::mojom::WebContentRenderer::ImeFinishComposingText";
      case messages::WebContentRenderer::kImeCancelCompositionFromClient:
            return "Receive owl::mojom::WebContentRenderer::ImeCancelCompositionFromClient";
      case messages::WebContentRenderer::kLookUpDictionaryOverlayAtPoint:
            return "Receive owl::mojom::WebContentRenderer::LookUpDictionaryOverlayAtPoint";
      case messages::WebContentRenderer::kLookUpDictionaryOverlayFromRange:
            return "Receive owl::mojom::WebContentRenderer::LookUpDictionaryOverlayFromRange";
      case messages::WebContentRenderer::kGetCharacterIndexAtPoint:
            return "Receive owl::mojom::WebContentRenderer::GetCharacterIndexAtPoint";
      case messages::WebContentRenderer::kGetFirstRectForRange:
            return "Receive owl::mojom::WebContentRenderer::GetFirstRectForRange";
      case messages::WebContentRenderer::kExecuteEditCommand:
            return "Receive owl::mojom::WebContentRenderer::ExecuteEditCommand";
      case messages::WebContentRenderer::kUndo:
            return "Receive owl::mojom::WebContentRenderer::Undo";
      case messages::WebContentRenderer::kRedo:
            return "Receive owl::mojom::WebContentRenderer::Redo";
      case messages::WebContentRenderer::kCut:
            return "Receive owl::mojom::WebContentRenderer::Cut";
      case messages::WebContentRenderer::kCopy:
            return "Receive owl::mojom::WebContentRenderer::Copy";
      case messages::WebContentRenderer::kCopyToFindPboard:
            return "Receive owl::mojom::WebContentRenderer::CopyToFindPboard";
      case messages::WebContentRenderer::kCenterSelection:
            return "Receive owl::mojom::WebContentRenderer::CenterSelection";
      case messages::WebContentRenderer::kPaste:
            return "Receive owl::mojom::WebContentRenderer::Paste";
      case messages::WebContentRenderer::kPasteAndMatchStyle:
            return "Receive owl::mojom::WebContentRenderer::PasteAndMatchStyle";
      case messages::WebContentRenderer::kSelectAll:
            return "Receive owl::mojom::WebContentRenderer::SelectAll";
      case messages::WebContentRenderer::kStartSpeaking:
            return "Receive owl::mojom::WebContentRenderer::StartSpeaking";
      case messages::WebContentRenderer::kStopSpeaking:
            return "Receive owl::mojom::WebContentRenderer::StopSpeaking";
      case messages::WebContentRenderer::kIsSpeaking:
            return "Receive owl::mojom::WebContentRenderer::IsSpeaking";
      case messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken:
            return "Receive owl::mojom::WebContentRenderer::GetWebContentRendererAccessibilityToken";
      case messages::WebContentRenderer::kSetRemoteAccessibilityTokens:
            return "Receive owl::mojom::WebContentRenderer::SetRemoteAccessibilityTokens";
      case messages::WebContentRenderer::kPingHostView:
            return "Receive owl::mojom::WebContentRenderer::PingHostView";
    }
  } else {
    switch (static_cast<messages::WebContentRenderer>(message.name())) {
      case messages::WebContentRenderer::kIsWidgetForMainFrame:
            return "Receive reply owl::mojom::WebContentRenderer::IsWidgetForMainFrame";
      case messages::WebContentRenderer::kRequestShutdown:
            return "Receive reply owl::mojom::WebContentRenderer::RequestShutdown";
      case messages::WebContentRenderer::kSetFocusLock:
            return "Receive reply owl::mojom::WebContentRenderer::SetFocusLock";
      case messages::WebContentRenderer::kOnFirstResponderChanged:
            return "Receive reply owl::mojom::WebContentRenderer::OnFirstResponderChanged";
      case messages::WebContentRenderer::kOnWindowIsKeyChanged:
            return "Receive reply owl::mojom::WebContentRenderer::OnWindowIsKeyChanged";
      case messages::WebContentRenderer::kBeginKeyboardEvent:
            return "Receive reply owl::mojom::WebContentRenderer::BeginKeyboardEvent";
      case messages::WebContentRenderer::kEndKeyboardEvent:
            return "Receive reply owl::mojom::WebContentRenderer::EndKeyboardEvent";
      case messages::WebContentRenderer::kForwardKeyboardEventWithCommands:
            return "Receive reply owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommands";
      case messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck:
            return "Receive reply owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck";
      case messages::WebContentRenderer::kRouteOrProcessMouseEvent:
            return "Receive reply owl::mojom::WebContentRenderer::RouteOrProcessMouseEvent";
      case messages::WebContentRenderer::kRouteOrProcessTouchEvent:
            return "Receive reply owl::mojom::WebContentRenderer::RouteOrProcessTouchEvent";
      case messages::WebContentRenderer::kRouteOrProcessWheelEvent:
            return "Receive reply owl::mojom::WebContentRenderer::RouteOrProcessWheelEvent";
      case messages::WebContentRenderer::kGestureBegin:
            return "Receive reply owl::mojom::WebContentRenderer::GestureBegin";
      case messages::WebContentRenderer::kGestureUpdate:
            return "Receive reply owl::mojom::WebContentRenderer::GestureUpdate";
      case messages::WebContentRenderer::kGestureEnd:
            return "Receive reply owl::mojom::WebContentRenderer::GestureEnd";
      case messages::WebContentRenderer::kSmartMagnify:
            return "Receive reply owl::mojom::WebContentRenderer::SmartMagnify";
      case messages::WebContentRenderer::kImeSetComposition:
            return "Receive reply owl::mojom::WebContentRenderer::ImeSetComposition";
      case messages::WebContentRenderer::kImeCommitText:
            return "Receive reply owl::mojom::WebContentRenderer::ImeCommitText";
      case messages::WebContentRenderer::kImeFinishComposingText:
            return "Receive reply owl::mojom::WebContentRenderer::ImeFinishComposingText";
      case messages::WebContentRenderer::kImeCancelCompositionFromClient:
            return "Receive reply owl::mojom::WebContentRenderer::ImeCancelCompositionFromClient";
      case messages::WebContentRenderer::kLookUpDictionaryOverlayAtPoint:
            return "Receive reply owl::mojom::WebContentRenderer::LookUpDictionaryOverlayAtPoint";
      case messages::WebContentRenderer::kLookUpDictionaryOverlayFromRange:
            return "Receive reply owl::mojom::WebContentRenderer::LookUpDictionaryOverlayFromRange";
      case messages::WebContentRenderer::kGetCharacterIndexAtPoint:
            return "Receive reply owl::mojom::WebContentRenderer::GetCharacterIndexAtPoint";
      case messages::WebContentRenderer::kGetFirstRectForRange:
            return "Receive reply owl::mojom::WebContentRenderer::GetFirstRectForRange";
      case messages::WebContentRenderer::kExecuteEditCommand:
            return "Receive reply owl::mojom::WebContentRenderer::ExecuteEditCommand";
      case messages::WebContentRenderer::kUndo:
            return "Receive reply owl::mojom::WebContentRenderer::Undo";
      case messages::WebContentRenderer::kRedo:
            return "Receive reply owl::mojom::WebContentRenderer::Redo";
      case messages::WebContentRenderer::kCut:
            return "Receive reply owl::mojom::WebContentRenderer::Cut";
      case messages::WebContentRenderer::kCopy:
            return "Receive reply owl::mojom::WebContentRenderer::Copy";
      case messages::WebContentRenderer::kCopyToFindPboard:
            return "Receive reply owl::mojom::WebContentRenderer::CopyToFindPboard";
      case messages::WebContentRenderer::kCenterSelection:
            return "Receive reply owl::mojom::WebContentRenderer::CenterSelection";
      case messages::WebContentRenderer::kPaste:
            return "Receive reply owl::mojom::WebContentRenderer::Paste";
      case messages::WebContentRenderer::kPasteAndMatchStyle:
            return "Receive reply owl::mojom::WebContentRenderer::PasteAndMatchStyle";
      case messages::WebContentRenderer::kSelectAll:
            return "Receive reply owl::mojom::WebContentRenderer::SelectAll";
      case messages::WebContentRenderer::kStartSpeaking:
            return "Receive reply owl::mojom::WebContentRenderer::StartSpeaking";
      case messages::WebContentRenderer::kStopSpeaking:
            return "Receive reply owl::mojom::WebContentRenderer::StopSpeaking";
      case messages::WebContentRenderer::kIsSpeaking:
            return "Receive reply owl::mojom::WebContentRenderer::IsSpeaking";
      case messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken:
            return "Receive reply owl::mojom::WebContentRenderer::GetWebContentRendererAccessibilityToken";
      case messages::WebContentRenderer::kSetRemoteAccessibilityTokens:
            return "Receive reply owl::mojom::WebContentRenderer::SetRemoteAccessibilityTokens";
      case messages::WebContentRenderer::kPingHostView:
            return "Receive reply owl::mojom::WebContentRenderer::PingHostView";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebContentRenderer::IsWidgetForMainFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x440e89ce;  // IPCStableHash for owl::mojom::WebContentRenderer::IsWidgetForMainFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::RequestShutdown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf562f55f;  // IPCStableHash for owl::mojom::WebContentRenderer::RequestShutdown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::SetFocusLock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x933b3f4b;  // IPCStableHash for owl::mojom::WebContentRenderer::SetFocusLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::OnFirstResponderChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a9f805d;  // IPCStableHash for owl::mojom::WebContentRenderer::OnFirstResponderChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::OnWindowIsKeyChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d6ffdd7;  // IPCStableHash for owl::mojom::WebContentRenderer::OnWindowIsKeyChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::BeginKeyboardEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc5e0fa98;  // IPCStableHash for owl::mojom::WebContentRenderer::BeginKeyboardEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::EndKeyboardEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95e92bd1;  // IPCStableHash for owl::mojom::WebContentRenderer::EndKeyboardEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ForwardKeyboardEventWithCommands_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7dbfea8;  // IPCStableHash for owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommands
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb22df33f;  // IPCStableHash for owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::RouteOrProcessMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf04d835a;  // IPCStableHash for owl::mojom::WebContentRenderer::RouteOrProcessMouseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::RouteOrProcessTouchEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17655978;  // IPCStableHash for owl::mojom::WebContentRenderer::RouteOrProcessTouchEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::RouteOrProcessWheelEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x173642bd;  // IPCStableHash for owl::mojom::WebContentRenderer::RouteOrProcessWheelEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::GestureBegin_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x858e9a2a;  // IPCStableHash for owl::mojom::WebContentRenderer::GestureBegin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::GestureUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8eda20d;  // IPCStableHash for owl::mojom::WebContentRenderer::GestureUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::GestureEnd_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeea1d8c8;  // IPCStableHash for owl::mojom::WebContentRenderer::GestureEnd
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::SmartMagnify_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5be7d7a2;  // IPCStableHash for owl::mojom::WebContentRenderer::SmartMagnify
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ImeSetComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd77665bc;  // IPCStableHash for owl::mojom::WebContentRenderer::ImeSetComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ImeCommitText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94336f25;  // IPCStableHash for owl::mojom::WebContentRenderer::ImeCommitText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ImeFinishComposingText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ce0364b;  // IPCStableHash for owl::mojom::WebContentRenderer::ImeFinishComposingText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ImeCancelCompositionFromClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15364dd9;  // IPCStableHash for owl::mojom::WebContentRenderer::ImeCancelCompositionFromClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::LookUpDictionaryOverlayAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x69b211b8;  // IPCStableHash for owl::mojom::WebContentRenderer::LookUpDictionaryOverlayAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::LookUpDictionaryOverlayFromRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x221e8dc3;  // IPCStableHash for owl::mojom::WebContentRenderer::LookUpDictionaryOverlayFromRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::GetCharacterIndexAtPoint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20f4b410;  // IPCStableHash for owl::mojom::WebContentRenderer::GetCharacterIndexAtPoint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::GetFirstRectForRange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x654899b8;  // IPCStableHash for owl::mojom::WebContentRenderer::GetFirstRectForRange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::ExecuteEditCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd499e13f;  // IPCStableHash for owl::mojom::WebContentRenderer::ExecuteEditCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9f336db;  // IPCStableHash for owl::mojom::WebContentRenderer::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::Redo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x473d9613;  // IPCStableHash for owl::mojom::WebContentRenderer::Redo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::Cut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x017ae313;  // IPCStableHash for owl::mojom::WebContentRenderer::Cut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::Copy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa8f441a6;  // IPCStableHash for owl::mojom::WebContentRenderer::Copy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::CopyToFindPboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4ebbfcec;  // IPCStableHash for owl::mojom::WebContentRenderer::CopyToFindPboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::CenterSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x116368c3;  // IPCStableHash for owl::mojom::WebContentRenderer::CenterSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::Paste_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc819f4bc;  // IPCStableHash for owl::mojom::WebContentRenderer::Paste
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::PasteAndMatchStyle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50900ea8;  // IPCStableHash for owl::mojom::WebContentRenderer::PasteAndMatchStyle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::SelectAll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30cad47e;  // IPCStableHash for owl::mojom::WebContentRenderer::SelectAll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::StartSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x501d8067;  // IPCStableHash for owl::mojom::WebContentRenderer::StartSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::StopSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f75c9c5;  // IPCStableHash for owl::mojom::WebContentRenderer::StopSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::IsSpeaking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe07fa0ee;  // IPCStableHash for owl::mojom::WebContentRenderer::IsSpeaking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::GetWebContentRendererAccessibilityToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x48da160c;  // IPCStableHash for owl::mojom::WebContentRenderer::GetWebContentRendererAccessibilityToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::SetRemoteAccessibilityTokens_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd7c25791;  // IPCStableHash for owl::mojom::WebContentRenderer::SetRemoteAccessibilityTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRenderer::PingHostView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3a20d31e;  // IPCStableHash for owl::mojom::WebContentRenderer::PingHostView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool WebContentRenderer::IsWidgetForMainFrame(bool* out_is_for_main_frame) {
  NOTREACHED();
}
bool WebContentRenderer::GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, std::optional<uint32_t>* out_index) {
  NOTREACHED();
}
bool WebContentRenderer::GetFirstRectForRange(const ::gfx::Range& requested_range, RectWithRangePtr* out_result) {
  NOTREACHED();
}
bool WebContentRenderer::IsSpeaking(bool* out_is_speaking) {
  NOTREACHED();
}
class WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse(
      bool* result, bool* out_is_for_main_frame)
      : result_(result), out_is_for_main_frame_(out_is_for_main_frame) {
    DCHECK(!*result_);
  }

  WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse(const WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse&) = delete;
  WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse& operator=(const WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_is_for_main_frame_;};

class WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback(
      WebContentRenderer::IsWidgetForMainFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback(const WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback&) = delete;
  WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback& operator=(const WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::IsWidgetForMainFrameCallback callback_;
};

class WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback(
      WebContentRenderer::ForwardKeyboardEventWithCommandsAndAckCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback(const WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback&) = delete;
  WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback& operator=(const WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::ForwardKeyboardEventWithCommandsAndAckCallback callback_;
};
class WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse(
      bool* result, std::optional<uint32_t>* out_index)
      : result_(result), out_index_(out_index) {
    DCHECK(!*result_);
  }

  WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse(const WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse&) = delete;
  WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse& operator=(const WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::optional<uint32_t>* out_index_;};

class WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback(
      WebContentRenderer::GetCharacterIndexAtPointCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback(const WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback&) = delete;
  WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback& operator=(const WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::GetCharacterIndexAtPointCallback callback_;
};
class WebContentRenderer_GetFirstRectForRange_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_GetFirstRectForRange_HandleSyncResponse(
      bool* result, RectWithRangePtr* out_result)
      : result_(result), out_result_(out_result) {
    DCHECK(!*result_);
  }

  WebContentRenderer_GetFirstRectForRange_HandleSyncResponse(const WebContentRenderer_GetFirstRectForRange_HandleSyncResponse&) = delete;
  WebContentRenderer_GetFirstRectForRange_HandleSyncResponse& operator=(const WebContentRenderer_GetFirstRectForRange_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  RectWithRangePtr* out_result_;};

class WebContentRenderer_GetFirstRectForRange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_GetFirstRectForRange_ForwardToCallback(
      WebContentRenderer::GetFirstRectForRangeCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_GetFirstRectForRange_ForwardToCallback(const WebContentRenderer_GetFirstRectForRange_ForwardToCallback&) = delete;
  WebContentRenderer_GetFirstRectForRange_ForwardToCallback& operator=(const WebContentRenderer_GetFirstRectForRange_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::GetFirstRectForRangeCallback callback_;
};
class WebContentRenderer_IsSpeaking_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_IsSpeaking_HandleSyncResponse(
      bool* result, bool* out_is_speaking)
      : result_(result), out_is_speaking_(out_is_speaking) {
    DCHECK(!*result_);
  }

  WebContentRenderer_IsSpeaking_HandleSyncResponse(const WebContentRenderer_IsSpeaking_HandleSyncResponse&) = delete;
  WebContentRenderer_IsSpeaking_HandleSyncResponse& operator=(const WebContentRenderer_IsSpeaking_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_is_speaking_;};

class WebContentRenderer_IsSpeaking_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_IsSpeaking_ForwardToCallback(
      WebContentRenderer::IsSpeakingCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_IsSpeaking_ForwardToCallback(const WebContentRenderer_IsSpeaking_ForwardToCallback&) = delete;
  WebContentRenderer_IsSpeaking_ForwardToCallback& operator=(const WebContentRenderer_IsSpeaking_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::IsSpeakingCallback callback_;
};

class WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback(
      WebContentRenderer::GetWebContentRendererAccessibilityTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback(const WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback&) = delete;
  WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback& operator=(const WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::GetWebContentRendererAccessibilityTokenCallback callback_;
};

class WebContentRenderer_PingHostView_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRenderer_PingHostView_ForwardToCallback(
      WebContentRenderer::PingHostViewCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRenderer_PingHostView_ForwardToCallback(const WebContentRenderer_PingHostView_ForwardToCallback&) = delete;
  WebContentRenderer_PingHostView_ForwardToCallback& operator=(const WebContentRenderer_PingHostView_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRenderer::PingHostViewCallback callback_;
};

WebContentRendererProxy::WebContentRendererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool WebContentRendererProxy::IsWidgetForMainFrame(
    bool* out_param_is_for_main_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call owl::mojom::WebContentRenderer::IsWidgetForMainFrame (sync)");
#else
  TRACE_EVENT0("mojom", "WebContentRenderer::IsWidgetForMainFrame");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kIsWidgetForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_IsWidgetForMainFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("IsWidgetForMainFrame");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse(
          &result, out_param_is_for_main_frame));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentRenderer::IsWidgetForMainFrame", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_for_main_frame"), out_param_is_for_main_frame,
                        "<value of type bool>");
   });
#endif
  return result;
}

void WebContentRendererProxy::IsWidgetForMainFrame(
    IsWidgetForMainFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::IsWidgetForMainFrame");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kIsWidgetForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_IsWidgetForMainFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("IsWidgetForMainFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentRendererProxy::RequestShutdown(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::RequestShutdown");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kRequestShutdown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_RequestShutdown_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("RequestShutdown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::SetFocusLock(
    bool in_is_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::SetFocusLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_locked"), in_is_locked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kSetFocusLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_SetFocusLock_Params_Data> params(
          message);
  params.Allocate();

  params->is_locked = in_is_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("SetFocusLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::OnFirstResponderChanged(
    bool in_is_first_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::OnFirstResponderChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_first_responder"), in_is_first_responder,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kOnFirstResponderChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_OnFirstResponderChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_first_responder = in_is_first_responder;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("OnFirstResponderChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::OnWindowIsKeyChanged(
    bool in_is_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::OnWindowIsKeyChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_key"), in_is_key,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kOnWindowIsKeyChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_OnWindowIsKeyChanged_Params_Data> params(
          message);
  params.Allocate();

  params->is_key = in_is_key;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("OnWindowIsKeyChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::BeginKeyboardEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::BeginKeyboardEvent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kBeginKeyboardEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_BeginKeyboardEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("BeginKeyboardEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::EndKeyboardEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::EndKeyboardEvent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kEndKeyboardEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_EndKeyboardEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("EndKeyboardEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::ForwardKeyboardEventWithCommands(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, const std::vector<uint8_t>& in_native_event_data, bool in_skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> in_commands) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommands", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_event_data"), in_native_event_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("skip_if_unhandled"), in_skip_if_unhandled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commands"), in_commands,
                        "<value of type std::vector<::blink::mojom::EditCommandPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kForwardKeyboardEventWithCommands), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.ForwardKeyboardEventWithCommands request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_event_data)::BaseType>
      native_event_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_native_event_data,
    native_event_data_fragment,
    &native_event_data_validate_params);

  params->native_event_data.Set(
      native_event_data_fragment.is_null() ? nullptr : native_event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_event_data in WebContentRenderer.ForwardKeyboardEventWithCommands request");

  params->skip_if_unhandled = in_skip_if_unhandled;
  mojo::internal::MessageFragment<
      typename decltype(params->commands)::BaseType>
      commands_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::EditCommandDataView>>(
    in_commands,
    commands_fragment,
    &commands_validate_params);

  params->commands.Set(
      commands_fragment.is_null() ? nullptr : commands_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->commands.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null commands in WebContentRenderer.ForwardKeyboardEventWithCommands request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ForwardKeyboardEventWithCommands");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::ForwardKeyboardEventWithCommandsAndAck(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, const std::vector<uint8_t>& in_native_event_data, bool in_skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> in_commands, ForwardKeyboardEventWithCommandsAndAckCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("native_event_data"), in_native_event_data,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("skip_if_unhandled"), in_skip_if_unhandled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("commands"), in_commands,
                        "<value of type std::vector<::blink::mojom::EditCommandPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.ForwardKeyboardEventWithCommandsAndAck request");
  mojo::internal::MessageFragment<
      typename decltype(params->native_event_data)::BaseType>
      native_event_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& native_event_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_native_event_data,
    native_event_data_fragment,
    &native_event_data_validate_params);

  params->native_event_data.Set(
      native_event_data_fragment.is_null() ? nullptr : native_event_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->native_event_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null native_event_data in WebContentRenderer.ForwardKeyboardEventWithCommandsAndAck request");

  params->skip_if_unhandled = in_skip_if_unhandled;
  mojo::internal::MessageFragment<
      typename decltype(params->commands)::BaseType>
      commands_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& commands_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::EditCommandDataView>>(
    in_commands,
    commands_fragment,
    &commands_validate_params);

  params->commands.Set(
      commands_fragment.is_null() ? nullptr : commands_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->commands.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null commands in WebContentRenderer.ForwardKeyboardEventWithCommandsAndAck request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ForwardKeyboardEventWithCommandsAndAck");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentRendererProxy::RouteOrProcessMouseEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::RouteOrProcessMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kRouteOrProcessMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_RouteOrProcessMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.RouteOrProcessMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("RouteOrProcessMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::RouteOrProcessTouchEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::RouteOrProcessTouchEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kRouteOrProcessTouchEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_RouteOrProcessTouchEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.RouteOrProcessTouchEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("RouteOrProcessTouchEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::RouteOrProcessWheelEvent(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::RouteOrProcessWheelEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kRouteOrProcessWheelEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_RouteOrProcessWheelEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.RouteOrProcessWheelEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("RouteOrProcessWheelEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::GestureBegin(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, bool in_is_synthetically_injected) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::GestureBegin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_synthetically_injected"), in_is_synthetically_injected,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGestureBegin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GestureBegin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.GestureBegin request");

  params->is_synthetically_injected = in_is_synthetically_injected;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GestureBegin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::GestureUpdate(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::GestureUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGestureUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GestureUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.GestureUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GestureUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::GestureEnd(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::GestureEnd", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGestureEnd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GestureEnd_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.GestureEnd request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GestureEnd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::SmartMagnify(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::SmartMagnify", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kSmartMagnify), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_SmartMagnify_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRenderer.SmartMagnify request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("SmartMagnify");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::ImeSetComposition(
    const ::std::u16string& in_text, const std::vector<::ui::ImeTextSpan>& in_ime_text_spans, const ::gfx::Range& in_replacement_range, int32_t in_selection_start, int32_t in_selection_end) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::ImeSetComposition", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ime_text_spans"), in_ime_text_spans,
                        "<value of type const std::vector<::ui::ImeTextSpan>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_range"), in_replacement_range,
                        "<value of type const ::gfx::Range&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_start"), in_selection_start,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_end"), in_selection_end,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kImeSetComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ImeSetComposition_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WebContentRenderer.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->ime_text_spans)::BaseType>
      ime_text_spans_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ime_text_spans_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ui::mojom::ImeTextSpanDataView>>(
    in_ime_text_spans,
    ime_text_spans_fragment,
    &ime_text_spans_validate_params);

  params->ime_text_spans.Set(
      ime_text_spans_fragment.is_null() ? nullptr : ime_text_spans_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ime_text_spans.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ime_text_spans in WebContentRenderer.ImeSetComposition request");
  mojo::internal::MessageFragment<
      typename decltype(params->replacement_range)::BaseType> replacement_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_replacement_range,
    replacement_range_fragment);

  params->replacement_range.Set(
      replacement_range_fragment.is_null() ? nullptr : replacement_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement_range in WebContentRenderer.ImeSetComposition request");

  params->selection_start = in_selection_start;

  params->selection_end = in_selection_end;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ImeSetComposition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::ImeCommitText(
    const ::std::u16string& in_text, const ::gfx::Range& in_replacement_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::ImeCommitText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_range"), in_replacement_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kImeCommitText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ImeCommitText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WebContentRenderer.ImeCommitText request");
  mojo::internal::MessageFragment<
      typename decltype(params->replacement_range)::BaseType> replacement_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_replacement_range,
    replacement_range_fragment);

  params->replacement_range.Set(
      replacement_range_fragment.is_null() ? nullptr : replacement_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replacement_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replacement_range in WebContentRenderer.ImeCommitText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ImeCommitText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::ImeFinishComposingText(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::ImeFinishComposingText");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kImeFinishComposingText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ImeFinishComposingText_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ImeFinishComposingText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::ImeCancelCompositionFromClient(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::ImeCancelCompositionFromClient");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kImeCancelCompositionFromClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ImeCancelCompositionFromClient_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ImeCancelCompositionFromClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::LookUpDictionaryOverlayAtPoint(
    const ::gfx::PointF& in_root_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::LookUpDictionaryOverlayAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_point"), in_root_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kLookUpDictionaryOverlayAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_point)::BaseType> root_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_root_point,
    root_point_fragment);

  params->root_point.Set(
      root_point_fragment.is_null() ? nullptr : root_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_point in WebContentRenderer.LookUpDictionaryOverlayAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("LookUpDictionaryOverlayAtPoint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::LookUpDictionaryOverlayFromRange(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::LookUpDictionaryOverlayFromRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kLookUpDictionaryOverlayFromRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in WebContentRenderer.LookUpDictionaryOverlayFromRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("LookUpDictionaryOverlayFromRange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool WebContentRendererProxy::GetCharacterIndexAtPoint(
    const ::gfx::PointF& param_root_point, std::optional<uint32_t>* out_param_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call owl::mojom::WebContentRenderer::GetCharacterIndexAtPoint (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_point"), param_root_point,
                        "<value of type const ::gfx::PointF&>");
   });
#else
  TRACE_EVENT0("mojom", "WebContentRenderer::GetCharacterIndexAtPoint");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetCharacterIndexAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_point)::BaseType> root_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    param_root_point,
    root_point_fragment);

  params->root_point.Set(
      root_point_fragment.is_null() ? nullptr : root_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_point in WebContentRenderer.GetCharacterIndexAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetCharacterIndexAtPoint");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse(
          &result, out_param_index));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentRenderer::GetCharacterIndexAtPoint", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), out_param_index,
                        "<value of type std::optional<uint32_t>>");
   });
#endif
  return result;
}

void WebContentRendererProxy::GetCharacterIndexAtPoint(
    const ::gfx::PointF& in_root_point, GetCharacterIndexAtPointCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::GetCharacterIndexAtPoint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_point"), in_root_point,
                        "<value of type const ::gfx::PointF&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetCharacterIndexAtPoint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_point)::BaseType> root_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
    in_root_point,
    root_point_fragment);

  params->root_point.Set(
      root_point_fragment.is_null() ? nullptr : root_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_point in WebContentRenderer.GetCharacterIndexAtPoint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetCharacterIndexAtPoint");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool WebContentRendererProxy::GetFirstRectForRange(
    const ::gfx::Range& param_requested_range, RectWithRangePtr* out_param_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call owl::mojom::WebContentRenderer::GetFirstRectForRange (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), param_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#else
  TRACE_EVENT0("mojom", "WebContentRenderer::GetFirstRectForRange");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    param_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in WebContentRenderer.GetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_GetFirstRectForRange_HandleSyncResponse(
          &result, out_param_result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentRenderer::GetFirstRectForRange", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type RectWithRangePtr>");
   });
#endif
  return result;
}

void WebContentRendererProxy::GetFirstRectForRange(
    const ::gfx::Range& in_requested_range, GetFirstRectForRangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::GetFirstRectForRange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_range"), in_requested_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetFirstRectForRange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->requested_range)::BaseType> requested_range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_requested_range,
    requested_range_fragment);

  params->requested_range.Set(
      requested_range_fragment.is_null() ? nullptr : requested_range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_range in WebContentRenderer.GetFirstRectForRange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_GetFirstRectForRange_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentRendererProxy::ExecuteEditCommand(
    const std::string& in_command) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::ExecuteEditCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("command"), in_command,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kExecuteEditCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ExecuteEditCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->command)::BaseType> command_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_command,
    command_fragment);

  params->command.Set(
      command_fragment.is_null() ? nullptr : command_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->command.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null command in WebContentRenderer.ExecuteEditCommand request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ExecuteEditCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::Undo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::Redo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::Redo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kRedo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_Redo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("Redo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::Cut(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::Cut");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kCut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_Cut_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("Cut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::Copy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::Copy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_Copy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("Copy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::CopyToFindPboard(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::CopyToFindPboard");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kCopyToFindPboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_CopyToFindPboard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("CopyToFindPboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::CenterSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::CenterSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kCenterSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_CenterSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("CenterSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::Paste(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::Paste");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kPaste), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_Paste_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("Paste");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::PasteAndMatchStyle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::PasteAndMatchStyle");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kPasteAndMatchStyle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_PasteAndMatchStyle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("PasteAndMatchStyle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::SelectAll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::SelectAll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kSelectAll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_SelectAll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("SelectAll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::StartSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::StartSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kStartSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_StartSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("StartSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::StopSpeaking(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::StopSpeaking");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kStopSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_StopSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("StopSpeaking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool WebContentRendererProxy::IsSpeaking(
    bool* out_param_is_speaking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call owl::mojom::WebContentRenderer::IsSpeaking (sync)");
#else
  TRACE_EVENT0("mojom", "WebContentRenderer::IsSpeaking");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kIsSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_IsSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("IsSpeaking");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_IsSpeaking_HandleSyncResponse(
          &result, out_param_is_speaking));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "WebContentRenderer::IsSpeaking", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_speaking"), out_param_is_speaking,
                        "<value of type bool>");
   });
#endif
  return result;
}

void WebContentRendererProxy::IsSpeaking(
    IsSpeakingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::IsSpeaking");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kIsSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_IsSpeaking_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("IsSpeaking");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_IsSpeaking_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentRendererProxy::GetWebContentRendererAccessibilityToken(
    GetWebContentRendererAccessibilityTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::GetWebContentRendererAccessibilityToken");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetWebContentRendererAccessibilityToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentRendererProxy::SetRemoteAccessibilityTokens(
    const std::vector<uint8_t>& in_window_token, const std::vector<uint8_t>& in_view_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRenderer::SetRemoteAccessibilityTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("window_token"), in_window_token,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_token"), in_view_token,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kSetRemoteAccessibilityTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->window_token)::BaseType>
      window_token_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& window_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_window_token,
    window_token_fragment,
    &window_token_validate_params);

  params->window_token.Set(
      window_token_fragment.is_null() ? nullptr : window_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->window_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null window_token in WebContentRenderer.SetRemoteAccessibilityTokens request");
  mojo::internal::MessageFragment<
      typename decltype(params->view_token)::BaseType>
      view_token_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& view_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_view_token,
    view_token_fragment,
    &view_token_validate_params);

  params->view_token.Set(
      view_token_fragment.is_null() ? nullptr : view_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->view_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null view_token in WebContentRenderer.SetRemoteAccessibilityTokens request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("SetRemoteAccessibilityTokens");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererProxy::PingHostView(
    PingHostViewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRenderer::PingHostView");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kPingHostView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_PingHostView_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("PingHostView");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRenderer_PingHostView_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::IsWidgetForMainFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder> proxy(
        new WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::IsWidgetForMainFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_for_main_frame);
};

bool WebContentRenderer_IsWidgetForMainFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.0
  bool success = true;
  bool p_is_for_main_frame{};
  WebContentRenderer_IsWidgetForMainFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_for_main_frame = input_data_view.is_for_main_frame();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_for_main_frame));
  }
  return true;
}

void WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder::Run(
    bool in_is_for_main_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRenderer::IsWidgetForMainFrame", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_for_main_frame"), in_is_for_main_frame,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kIsWidgetForMainFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_for_main_frame = in_is_for_main_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("IsWidgetForMainFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentRenderer_IsWidgetForMainFrame_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentRenderer.0
  bool success = true;
  bool p_is_for_main_frame{};
  WebContentRenderer_IsWidgetForMainFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_for_main_frame = input_data_view.is_for_main_frame();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 0, true);
    return false;
  }
  *out_is_for_main_frame_ = std::move(p_is_for_main_frame);
  *result_ = true;
  return true;
}
class WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::ForwardKeyboardEventWithCommandsAndAckCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder> proxy(
        new WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::ForwardKeyboardEventWithCommandsAndAckCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.8
  bool success = true;
  WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::WebContentRenderer::ForwardKeyboardEventWithCommandsAndAck");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("ForwardKeyboardEventWithCommandsAndAck");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::GetCharacterIndexAtPointCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder> proxy(
        new WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::GetCharacterIndexAtPointCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_index);
};

bool WebContentRenderer_GetCharacterIndexAtPoint_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.22
  bool success = true;
  std::optional<uint32_t> p_index{};
  WebContentRenderer_GetCharacterIndexAtPoint_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_index = input_data_view.index();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_index));
  }
  return true;
}

void WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder::Run(
    std::optional<uint32_t> in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRenderer::GetCharacterIndexAtPoint", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetCharacterIndexAtPoint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->index_$flag = in_index.has_value();
  if (in_index.has_value()) {
    params->index_$value = in_index.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetCharacterIndexAtPoint");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentRenderer_GetCharacterIndexAtPoint_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentRenderer.22
  bool success = true;
  std::optional<uint32_t> p_index{};
  WebContentRenderer_GetCharacterIndexAtPoint_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_index = input_data_view.index();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 22, true);
    return false;
  }
  *out_index_ = std::move(p_index);
  *result_ = true;
  return true;
}
class WebContentRenderer_GetFirstRectForRange_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::GetFirstRectForRangeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_GetFirstRectForRange_ProxyToResponder> proxy(
        new WebContentRenderer_GetFirstRectForRange_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_GetFirstRectForRange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_GetFirstRectForRange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_GetFirstRectForRange_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::GetFirstRectForRangeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      RectWithRangePtr in_result);
};

bool WebContentRenderer_GetFirstRectForRange_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.23
  bool success = true;
  RectWithRangePtr p_result{};
  WebContentRenderer_GetFirstRectForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebContentRenderer_GetFirstRectForRange_ProxyToResponder::Run(
    RectWithRangePtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRenderer::GetFirstRectForRange", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type RectWithRangePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetFirstRectForRange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::RectWithRangeDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetFirstRectForRange");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentRenderer_GetFirstRectForRange_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentRenderer.23
  bool success = true;
  RectWithRangePtr p_result{};
  WebContentRenderer_GetFirstRectForRange_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 23, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *result_ = true;
  return true;
}
class WebContentRenderer_IsSpeaking_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::IsSpeakingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_IsSpeaking_ProxyToResponder> proxy(
        new WebContentRenderer_IsSpeaking_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_IsSpeaking_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_IsSpeaking_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_IsSpeaking_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::IsSpeakingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_speaking);
};

bool WebContentRenderer_IsSpeaking_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_IsSpeaking_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_IsSpeaking_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.36
  bool success = true;
  bool p_is_speaking{};
  WebContentRenderer_IsSpeaking_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_speaking = input_data_view.is_speaking();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 36, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_speaking));
  }
  return true;
}

void WebContentRenderer_IsSpeaking_ProxyToResponder::Run(
    bool in_is_speaking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRenderer::IsSpeaking", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_speaking"), in_is_speaking,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kIsSpeaking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_IsSpeaking_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_speaking = in_is_speaking;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("IsSpeaking");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool WebContentRenderer_IsSpeaking_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_IsSpeaking_ResponseParams_Data* params =
      reinterpret_cast<internal::WebContentRenderer_IsSpeaking_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for WebContentRenderer.36
  bool success = true;
  bool p_is_speaking{};
  WebContentRenderer_IsSpeaking_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_speaking = input_data_view.is_speaking();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 36, true);
    return false;
  }
  *out_is_speaking_ = std::move(p_is_speaking);
  *result_ = true;
  return true;
}
class WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::GetWebContentRendererAccessibilityTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder> proxy(
        new WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::GetWebContentRendererAccessibilityTokenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ProcessId in_host_pid, const std::vector<uint8_t>& in_element_token);
};

bool WebContentRenderer_GetWebContentRendererAccessibilityToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.37
  bool success = true;
  ::base::ProcessId p_host_pid{};
  std::vector<uint8_t> p_element_token{};
  WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHostPid(&p_host_pid))
    success = false;
  if (success && !input_data_view.ReadElementToken(&p_element_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_host_pid), 
std::move(p_element_token));
  }
  return true;
}

void WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder::Run(
    ::base::ProcessId in_host_pid, const std::vector<uint8_t>& in_element_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRenderer::GetWebContentRendererAccessibilityToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_pid"), in_host_pid,
                        "<value of type ::base::ProcessId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_token"), in_element_token,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->host_pid)::BaseType> host_pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_host_pid,
    host_pid_fragment);

  params->host_pid.Set(
      host_pid_fragment.is_null() ? nullptr : host_pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->host_pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null host_pid in ");
  mojo::internal::MessageFragment<
      typename decltype(params->element_token)::BaseType>
      element_token_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& element_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_element_token,
    element_token_fragment,
    &element_token_validate_params);

  params->element_token.Set(
      element_token_fragment.is_null() ? nullptr : element_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->element_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null element_token in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("GetWebContentRendererAccessibilityToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebContentRenderer_PingHostView_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRenderer::PingHostViewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRenderer_PingHostView_ProxyToResponder> proxy(
        new WebContentRenderer_PingHostView_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRenderer_PingHostView_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRenderer_PingHostView_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRenderer_PingHostView_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRenderer::PingHostViewCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool WebContentRenderer_PingHostView_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRenderer_PingHostView_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRenderer_PingHostView_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRenderer.39
  bool success = true;
  WebContentRenderer_PingHostView_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRenderer::Name_, 39, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void WebContentRenderer_PingHostView_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply owl::mojom::WebContentRenderer::PingHostView");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRenderer::kPingHostView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRenderer_PingHostView_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRenderer::Name_);
  message.set_method_name("PingHostView");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebContentRendererStubDispatch::Accept(
    WebContentRenderer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebContentRenderer>(message->header()->name)) {
    case messages::WebContentRenderer::kIsWidgetForMainFrame: {
      break;
    }
    case messages::WebContentRenderer::kRequestShutdown: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_RequestShutdown_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_RequestShutdown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.1
      bool success = true;
      WebContentRenderer_RequestShutdown_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestShutdown(        );
      return true;
    }
    case messages::WebContentRenderer::kSetFocusLock: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_SetFocusLock_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_SetFocusLock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.2
      bool success = true;
      bool p_is_locked{};
      WebContentRenderer_SetFocusLock_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_locked = input_data_view.is_locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFocusLock(        
        std::move(p_is_locked));
      return true;
    }
    case messages::WebContentRenderer::kOnFirstResponderChanged: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_OnFirstResponderChanged_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_OnFirstResponderChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.3
      bool success = true;
      bool p_is_first_responder{};
      WebContentRenderer_OnFirstResponderChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_first_responder = input_data_view.is_first_responder();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFirstResponderChanged(        
        std::move(p_is_first_responder));
      return true;
    }
    case messages::WebContentRenderer::kOnWindowIsKeyChanged: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_OnWindowIsKeyChanged_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_OnWindowIsKeyChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.4
      bool success = true;
      bool p_is_key{};
      WebContentRenderer_OnWindowIsKeyChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_key = input_data_view.is_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowIsKeyChanged(        
        std::move(p_is_key));
      return true;
    }
    case messages::WebContentRenderer::kBeginKeyboardEvent: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_BeginKeyboardEvent_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_BeginKeyboardEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.5
      bool success = true;
      WebContentRenderer_BeginKeyboardEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginKeyboardEvent(        );
      return true;
    }
    case messages::WebContentRenderer::kEndKeyboardEvent: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_EndKeyboardEvent_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_EndKeyboardEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.6
      bool success = true;
      WebContentRenderer_EndKeyboardEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndKeyboardEvent(        );
      return true;
    }
    case messages::WebContentRenderer::kForwardKeyboardEventWithCommands: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.7
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      std::vector<uint8_t> p_native_event_data{};
      bool p_skip_if_unhandled{};
      std::vector<::blink::mojom::EditCommandPtr> p_commands{};
      WebContentRenderer_ForwardKeyboardEventWithCommands_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success && !input_data_view.ReadNativeEventData(&p_native_event_data))
        success = false;
      if (success)
        p_skip_if_unhandled = input_data_view.skip_if_unhandled();
      if (success && !input_data_view.ReadCommands(&p_commands))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardKeyboardEventWithCommands(        
        std::move(p_event), 
        std::move(p_native_event_data), 
        std::move(p_skip_if_unhandled), 
        std::move(p_commands));
      return true;
    }
    case messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck: {
      break;
    }
    case messages::WebContentRenderer::kRouteOrProcessMouseEvent: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_RouteOrProcessMouseEvent_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_RouteOrProcessMouseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.9
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WebContentRenderer_RouteOrProcessMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteOrProcessMouseEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentRenderer::kRouteOrProcessTouchEvent: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_RouteOrProcessTouchEvent_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_RouteOrProcessTouchEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.10
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WebContentRenderer_RouteOrProcessTouchEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteOrProcessTouchEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentRenderer::kRouteOrProcessWheelEvent: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_RouteOrProcessWheelEvent_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_RouteOrProcessWheelEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.11
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WebContentRenderer_RouteOrProcessWheelEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteOrProcessWheelEvent(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentRenderer::kGestureBegin: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_GestureBegin_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_GestureBegin_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.12
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      bool p_is_synthetically_injected{};
      WebContentRenderer_GestureBegin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success)
        p_is_synthetically_injected = input_data_view.is_synthetically_injected();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GestureBegin(        
        std::move(p_event), 
        std::move(p_is_synthetically_injected));
      return true;
    }
    case messages::WebContentRenderer::kGestureUpdate: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_GestureUpdate_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_GestureUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.13
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WebContentRenderer_GestureUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GestureUpdate(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentRenderer::kGestureEnd: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_GestureEnd_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_GestureEnd_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.14
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WebContentRenderer_GestureEnd_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GestureEnd(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentRenderer::kSmartMagnify: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_SmartMagnify_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_SmartMagnify_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.15
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      WebContentRenderer_SmartMagnify_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SmartMagnify(        
        std::move(p_event));
      return true;
    }
    case messages::WebContentRenderer::kImeSetComposition: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_ImeSetComposition_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_ImeSetComposition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.16
      bool success = true;
      ::std::u16string p_text{};
      std::vector<::ui::ImeTextSpan> p_ime_text_spans{};
      ::gfx::Range p_replacement_range{};
      int32_t p_selection_start{};
      int32_t p_selection_end{};
      WebContentRenderer_ImeSetComposition_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadImeTextSpans(&p_ime_text_spans))
        success = false;
      if (success && !input_data_view.ReadReplacementRange(&p_replacement_range))
        success = false;
      if (success)
        p_selection_start = input_data_view.selection_start();
      if (success)
        p_selection_end = input_data_view.selection_end();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeSetComposition(        
        std::move(p_text), 
        std::move(p_ime_text_spans), 
        std::move(p_replacement_range), 
        std::move(p_selection_start), 
        std::move(p_selection_end));
      return true;
    }
    case messages::WebContentRenderer::kImeCommitText: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_ImeCommitText_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_ImeCommitText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.17
      bool success = true;
      ::std::u16string p_text{};
      ::gfx::Range p_replacement_range{};
      WebContentRenderer_ImeCommitText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadReplacementRange(&p_replacement_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCommitText(        
        std::move(p_text), 
        std::move(p_replacement_range));
      return true;
    }
    case messages::WebContentRenderer::kImeFinishComposingText: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_ImeFinishComposingText_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_ImeFinishComposingText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.18
      bool success = true;
      WebContentRenderer_ImeFinishComposingText_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeFinishComposingText(        );
      return true;
    }
    case messages::WebContentRenderer::kImeCancelCompositionFromClient: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_ImeCancelCompositionFromClient_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_ImeCancelCompositionFromClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.19
      bool success = true;
      WebContentRenderer_ImeCancelCompositionFromClient_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ImeCancelCompositionFromClient(        );
      return true;
    }
    case messages::WebContentRenderer::kLookUpDictionaryOverlayAtPoint: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.20
      bool success = true;
      ::gfx::PointF p_root_point{};
      WebContentRenderer_LookUpDictionaryOverlayAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootPoint(&p_root_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookUpDictionaryOverlayAtPoint(        
        std::move(p_root_point));
      return true;
    }
    case messages::WebContentRenderer::kLookUpDictionaryOverlayFromRange: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.21
      bool success = true;
      ::gfx::Range p_range{};
      WebContentRenderer_LookUpDictionaryOverlayFromRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookUpDictionaryOverlayFromRange(        
        std::move(p_range));
      return true;
    }
    case messages::WebContentRenderer::kGetCharacterIndexAtPoint: {
      break;
    }
    case messages::WebContentRenderer::kGetFirstRectForRange: {
      break;
    }
    case messages::WebContentRenderer::kExecuteEditCommand: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_ExecuteEditCommand_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_ExecuteEditCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.24
      bool success = true;
      std::string p_command{};
      WebContentRenderer_ExecuteEditCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCommand(&p_command))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteEditCommand(        
        std::move(p_command));
      return true;
    }
    case messages::WebContentRenderer::kUndo: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_Undo_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_Undo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.25
      bool success = true;
      WebContentRenderer_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(        );
      return true;
    }
    case messages::WebContentRenderer::kRedo: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_Redo_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_Redo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.26
      bool success = true;
      WebContentRenderer_Redo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Redo(        );
      return true;
    }
    case messages::WebContentRenderer::kCut: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_Cut_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_Cut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.27
      bool success = true;
      WebContentRenderer_Cut_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cut(        );
      return true;
    }
    case messages::WebContentRenderer::kCopy: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_Copy_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_Copy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.28
      bool success = true;
      WebContentRenderer_Copy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Copy(        );
      return true;
    }
    case messages::WebContentRenderer::kCopyToFindPboard: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_CopyToFindPboard_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_CopyToFindPboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.29
      bool success = true;
      WebContentRenderer_CopyToFindPboard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyToFindPboard(        );
      return true;
    }
    case messages::WebContentRenderer::kCenterSelection: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_CenterSelection_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_CenterSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.30
      bool success = true;
      WebContentRenderer_CenterSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CenterSelection(        );
      return true;
    }
    case messages::WebContentRenderer::kPaste: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_Paste_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_Paste_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.31
      bool success = true;
      WebContentRenderer_Paste_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Paste(        );
      return true;
    }
    case messages::WebContentRenderer::kPasteAndMatchStyle: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_PasteAndMatchStyle_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_PasteAndMatchStyle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.32
      bool success = true;
      WebContentRenderer_PasteAndMatchStyle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PasteAndMatchStyle(        );
      return true;
    }
    case messages::WebContentRenderer::kSelectAll: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_SelectAll_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_SelectAll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.33
      bool success = true;
      WebContentRenderer_SelectAll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAll(        );
      return true;
    }
    case messages::WebContentRenderer::kStartSpeaking: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_StartSpeaking_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_StartSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.34
      bool success = true;
      WebContentRenderer_StartSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSpeaking(        );
      return true;
    }
    case messages::WebContentRenderer::kStopSpeaking: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_StopSpeaking_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_StopSpeaking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.35
      bool success = true;
      WebContentRenderer_StopSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopSpeaking(        );
      return true;
    }
    case messages::WebContentRenderer::kIsSpeaking: {
      break;
    }
    case messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken: {
      break;
    }
    case messages::WebContentRenderer::kSetRemoteAccessibilityTokens: {
      DCHECK(message->is_serialized());
      internal::WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data* params =
          reinterpret_cast<internal::WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRenderer.38
      bool success = true;
      std::vector<uint8_t> p_window_token{};
      std::vector<uint8_t> p_view_token{};
      WebContentRenderer_SetRemoteAccessibilityTokens_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWindowToken(&p_window_token))
        success = false;
      if (success && !input_data_view.ReadViewToken(&p_view_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRemoteAccessibilityTokens(        
        std::move(p_window_token), 
        std::move(p_view_token));
      return true;
    }
    case messages::WebContentRenderer::kPingHostView: {
      break;
    }
  }
  return false;
}

// static
bool WebContentRendererStubDispatch::AcceptWithResponder(
    WebContentRenderer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebContentRenderer>(message->header()->name)) {
    case messages::WebContentRenderer::kIsWidgetForMainFrame: {
      internal::WebContentRenderer_IsWidgetForMainFrame_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_IsWidgetForMainFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.0
      bool success = true;
      WebContentRenderer_IsWidgetForMainFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 0, false);
        return false;
      }
      auto callback =
          WebContentRenderer_IsWidgetForMainFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsWidgetForMainFrame(std::move(callback));
      return true;
    }
    case messages::WebContentRenderer::kRequestShutdown: {
      break;
    }
    case messages::WebContentRenderer::kSetFocusLock: {
      break;
    }
    case messages::WebContentRenderer::kOnFirstResponderChanged: {
      break;
    }
    case messages::WebContentRenderer::kOnWindowIsKeyChanged: {
      break;
    }
    case messages::WebContentRenderer::kBeginKeyboardEvent: {
      break;
    }
    case messages::WebContentRenderer::kEndKeyboardEvent: {
      break;
    }
    case messages::WebContentRenderer::kForwardKeyboardEventWithCommands: {
      break;
    }
    case messages::WebContentRenderer::kForwardKeyboardEventWithCommandsAndAck: {
      internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.8
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      std::vector<uint8_t> p_native_event_data{};
      bool p_skip_if_unhandled{};
      std::vector<::blink::mojom::EditCommandPtr> p_commands{};
      WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success && !input_data_view.ReadNativeEventData(&p_native_event_data))
        success = false;
      if (success)
        p_skip_if_unhandled = input_data_view.skip_if_unhandled();
      if (success && !input_data_view.ReadCommands(&p_commands))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 8, false);
        return false;
      }
      auto callback =
          WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardKeyboardEventWithCommandsAndAck(        
        std::move(p_event), 
        std::move(p_native_event_data), 
        std::move(p_skip_if_unhandled), 
        std::move(p_commands), std::move(callback));
      return true;
    }
    case messages::WebContentRenderer::kRouteOrProcessMouseEvent: {
      break;
    }
    case messages::WebContentRenderer::kRouteOrProcessTouchEvent: {
      break;
    }
    case messages::WebContentRenderer::kRouteOrProcessWheelEvent: {
      break;
    }
    case messages::WebContentRenderer::kGestureBegin: {
      break;
    }
    case messages::WebContentRenderer::kGestureUpdate: {
      break;
    }
    case messages::WebContentRenderer::kGestureEnd: {
      break;
    }
    case messages::WebContentRenderer::kSmartMagnify: {
      break;
    }
    case messages::WebContentRenderer::kImeSetComposition: {
      break;
    }
    case messages::WebContentRenderer::kImeCommitText: {
      break;
    }
    case messages::WebContentRenderer::kImeFinishComposingText: {
      break;
    }
    case messages::WebContentRenderer::kImeCancelCompositionFromClient: {
      break;
    }
    case messages::WebContentRenderer::kLookUpDictionaryOverlayAtPoint: {
      break;
    }
    case messages::WebContentRenderer::kLookUpDictionaryOverlayFromRange: {
      break;
    }
    case messages::WebContentRenderer::kGetCharacterIndexAtPoint: {
      internal::WebContentRenderer_GetCharacterIndexAtPoint_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_GetCharacterIndexAtPoint_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.22
      bool success = true;
      ::gfx::PointF p_root_point{};
      WebContentRenderer_GetCharacterIndexAtPoint_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootPoint(&p_root_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 22, false);
        return false;
      }
      auto callback =
          WebContentRenderer_GetCharacterIndexAtPoint_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCharacterIndexAtPoint(        
        std::move(p_root_point), std::move(callback));
      return true;
    }
    case messages::WebContentRenderer::kGetFirstRectForRange: {
      internal::WebContentRenderer_GetFirstRectForRange_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_GetFirstRectForRange_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.23
      bool success = true;
      ::gfx::Range p_requested_range{};
      WebContentRenderer_GetFirstRectForRange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequestedRange(&p_requested_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 23, false);
        return false;
      }
      auto callback =
          WebContentRenderer_GetFirstRectForRange_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFirstRectForRange(        
        std::move(p_requested_range), std::move(callback));
      return true;
    }
    case messages::WebContentRenderer::kExecuteEditCommand: {
      break;
    }
    case messages::WebContentRenderer::kUndo: {
      break;
    }
    case messages::WebContentRenderer::kRedo: {
      break;
    }
    case messages::WebContentRenderer::kCut: {
      break;
    }
    case messages::WebContentRenderer::kCopy: {
      break;
    }
    case messages::WebContentRenderer::kCopyToFindPboard: {
      break;
    }
    case messages::WebContentRenderer::kCenterSelection: {
      break;
    }
    case messages::WebContentRenderer::kPaste: {
      break;
    }
    case messages::WebContentRenderer::kPasteAndMatchStyle: {
      break;
    }
    case messages::WebContentRenderer::kSelectAll: {
      break;
    }
    case messages::WebContentRenderer::kStartSpeaking: {
      break;
    }
    case messages::WebContentRenderer::kStopSpeaking: {
      break;
    }
    case messages::WebContentRenderer::kIsSpeaking: {
      internal::WebContentRenderer_IsSpeaking_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_IsSpeaking_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.36
      bool success = true;
      WebContentRenderer_IsSpeaking_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 36, false);
        return false;
      }
      auto callback =
          WebContentRenderer_IsSpeaking_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsSpeaking(std::move(callback));
      return true;
    }
    case messages::WebContentRenderer::kGetWebContentRendererAccessibilityToken: {
      internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.37
      bool success = true;
      WebContentRenderer_GetWebContentRendererAccessibilityToken_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 37, false);
        return false;
      }
      auto callback =
          WebContentRenderer_GetWebContentRendererAccessibilityToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWebContentRendererAccessibilityToken(std::move(callback));
      return true;
    }
    case messages::WebContentRenderer::kSetRemoteAccessibilityTokens: {
      break;
    }
    case messages::WebContentRenderer::kPingHostView: {
      internal::WebContentRenderer_PingHostView_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRenderer_PingHostView_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRenderer.39
      bool success = true;
      WebContentRenderer_PingHostView_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRenderer::Name_, 39, false);
        return false;
      }
      auto callback =
          WebContentRenderer_PingHostView_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PingHostView(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebContentRendererValidationInfo[] = {
    { &internal::WebContentRenderer_IsWidgetForMainFrame_Params_Data::Validate,
     &internal::WebContentRenderer_IsWidgetForMainFrame_ResponseParams_Data::Validate},
    { &internal::WebContentRenderer_RequestShutdown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_SetFocusLock_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_OnFirstResponderChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_OnWindowIsKeyChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_BeginKeyboardEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_EndKeyboardEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_ForwardKeyboardEventWithCommands_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_Params_Data::Validate,
     &internal::WebContentRenderer_ForwardKeyboardEventWithCommandsAndAck_ResponseParams_Data::Validate},
    { &internal::WebContentRenderer_RouteOrProcessMouseEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_RouteOrProcessTouchEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_RouteOrProcessWheelEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_GestureBegin_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_GestureUpdate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_GestureEnd_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_SmartMagnify_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_ImeSetComposition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_ImeCommitText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_ImeFinishComposingText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_ImeCancelCompositionFromClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_LookUpDictionaryOverlayAtPoint_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_LookUpDictionaryOverlayFromRange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_GetCharacterIndexAtPoint_Params_Data::Validate,
     &internal::WebContentRenderer_GetCharacterIndexAtPoint_ResponseParams_Data::Validate},
    { &internal::WebContentRenderer_GetFirstRectForRange_Params_Data::Validate,
     &internal::WebContentRenderer_GetFirstRectForRange_ResponseParams_Data::Validate},
    { &internal::WebContentRenderer_ExecuteEditCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_Undo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_Redo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_Cut_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_Copy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_CopyToFindPboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_CenterSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_Paste_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_PasteAndMatchStyle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_SelectAll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_StartSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_StopSpeaking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_IsSpeaking_Params_Data::Validate,
     &internal::WebContentRenderer_IsSpeaking_ResponseParams_Data::Validate},
    { &internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_Params_Data::Validate,
     &internal::WebContentRenderer_GetWebContentRendererAccessibilityToken_ResponseParams_Data::Validate},
    { &internal::WebContentRenderer_SetRemoteAccessibilityTokens_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRenderer_PingHostView_Params_Data::Validate,
     &internal::WebContentRenderer_PingHostView_ResponseParams_Data::Validate},
};

bool WebContentRendererRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebContentRenderer::Name_,
    kWebContentRendererValidationInfo);
}

bool WebContentRendererResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebContentRenderer::Name_,
    kWebContentRendererValidationInfo);
}
// The declaration includes the definition on other builds.

PopupMenuRunner::IPCStableHashFunction PopupMenuRunner::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PopupMenuRunner>(message.name())) {
    case messages::PopupMenuRunner::kHide: {
      return &PopupMenuRunner::Hide_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PopupMenuRunner::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PopupMenuRunner>(message.name())) {
      case messages::PopupMenuRunner::kHide:
            return "Receive owl::mojom::PopupMenuRunner::Hide";
    }
  } else {
    switch (static_cast<messages::PopupMenuRunner>(message.name())) {
      case messages::PopupMenuRunner::kHide:
            return "Receive reply owl::mojom::PopupMenuRunner::Hide";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PopupMenuRunner::Hide_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7198c72f;  // IPCStableHash for owl::mojom::PopupMenuRunner::Hide
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PopupMenuRunnerProxy::PopupMenuRunnerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PopupMenuRunnerProxy::Hide(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::PopupMenuRunner::Hide");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PopupMenuRunner::kHide), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::PopupMenuRunner_Hide_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupMenuRunner::Name_);
  message.set_method_name("Hide");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PopupMenuRunnerStubDispatch::Accept(
    PopupMenuRunner* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PopupMenuRunner>(message->header()->name)) {
    case messages::PopupMenuRunner::kHide: {
      DCHECK(message->is_serialized());
      internal::PopupMenuRunner_Hide_Params_Data* params =
          reinterpret_cast<internal::PopupMenuRunner_Hide_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PopupMenuRunner.0
      bool success = true;
      PopupMenuRunner_Hide_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupMenuRunner::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Hide(        );
      return true;
    }
  }
  return false;
}

// static
bool PopupMenuRunnerStubDispatch::AcceptWithResponder(
    PopupMenuRunner* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PopupMenuRunner>(message->header()->name)) {
    case messages::PopupMenuRunner::kHide: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPopupMenuRunnerValidationInfo[] = {
    { &internal::PopupMenuRunner_Hide_Params_Data::Validate,
     nullptr /* no response */},
};

bool PopupMenuRunnerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::PopupMenuRunner::Name_,
    kPopupMenuRunnerValidationInfo);
}

// The declaration includes the definition on other builds.

WebContentRendererClient::IPCStableHashFunction WebContentRendererClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebContentRendererClient>(message.name())) {
    case messages::WebContentRendererClient::kInitAsPopup: {
      return &WebContentRendererClient::InitAsPopup_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetPopupBounds: {
      return &WebContentRendererClient::SetPopupBounds_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kTakeFocus: {
      return &WebContentRendererClient::TakeFocus_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetVisible: {
      return &WebContentRendererClient::SetVisible_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetTooltipText: {
      return &WebContentRendererClient::SetTooltipText_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetTextInputState: {
      return &WebContentRendererClient::SetTextInputState_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetTextSelection: {
      return &WebContentRendererClient::SetTextSelection_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetCompositionRangeInfo: {
      return &WebContentRendererClient::SetCompositionRangeInfo_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kCancelComposition: {
      return &WebContentRendererClient::CancelComposition_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kOnSelectionBoundsChanged: {
      return &WebContentRendererClient::OnSelectionBoundsChanged_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetShowingContextMenu: {
      return &WebContentRendererClient::SetShowingContextMenu_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kDisplayCursor: {
      return &WebContentRendererClient::DisplayCursor_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetCursorLocked: {
      return &WebContentRendererClient::SetCursorLocked_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kSetCursorLockedUnacceleratedMovement: {
      return &WebContentRendererClient::SetCursorLockedUnacceleratedMovement_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kShowDictionaryOverlayForSelection: {
      return &WebContentRendererClient::ShowDictionaryOverlayForSelection_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kShowDictionaryOverlay: {
      return &WebContentRendererClient::ShowDictionaryOverlay_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kLockKeyboard: {
      return &WebContentRendererClient::LockKeyboard_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kUnlockKeyboard: {
      return &WebContentRendererClient::UnlockKeyboard_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kShowSharingServicePicker: {
      return &WebContentRendererClient::ShowSharingServicePicker_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kDestroy: {
      return &WebContentRendererClient::Destroy_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kGestureScrollEventAck: {
      return &WebContentRendererClient::GestureScrollEventAck_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kDidOverscroll: {
      return &WebContentRendererClient::DidOverscroll_Sym::IPCStableHash;
    }
    case messages::WebContentRendererClient::kDisplayPopupMenu: {
      return &WebContentRendererClient::DisplayPopupMenu_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebContentRendererClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebContentRendererClient>(message.name())) {
      case messages::WebContentRendererClient::kInitAsPopup:
            return "Receive owl::mojom::WebContentRendererClient::InitAsPopup";
      case messages::WebContentRendererClient::kSetPopupBounds:
            return "Receive owl::mojom::WebContentRendererClient::SetPopupBounds";
      case messages::WebContentRendererClient::kTakeFocus:
            return "Receive owl::mojom::WebContentRendererClient::TakeFocus";
      case messages::WebContentRendererClient::kSetVisible:
            return "Receive owl::mojom::WebContentRendererClient::SetVisible";
      case messages::WebContentRendererClient::kSetTooltipText:
            return "Receive owl::mojom::WebContentRendererClient::SetTooltipText";
      case messages::WebContentRendererClient::kSetTextInputState:
            return "Receive owl::mojom::WebContentRendererClient::SetTextInputState";
      case messages::WebContentRendererClient::kSetTextSelection:
            return "Receive owl::mojom::WebContentRendererClient::SetTextSelection";
      case messages::WebContentRendererClient::kSetCompositionRangeInfo:
            return "Receive owl::mojom::WebContentRendererClient::SetCompositionRangeInfo";
      case messages::WebContentRendererClient::kCancelComposition:
            return "Receive owl::mojom::WebContentRendererClient::CancelComposition";
      case messages::WebContentRendererClient::kOnSelectionBoundsChanged:
            return "Receive owl::mojom::WebContentRendererClient::OnSelectionBoundsChanged";
      case messages::WebContentRendererClient::kSetShowingContextMenu:
            return "Receive owl::mojom::WebContentRendererClient::SetShowingContextMenu";
      case messages::WebContentRendererClient::kDisplayCursor:
            return "Receive owl::mojom::WebContentRendererClient::DisplayCursor";
      case messages::WebContentRendererClient::kSetCursorLocked:
            return "Receive owl::mojom::WebContentRendererClient::SetCursorLocked";
      case messages::WebContentRendererClient::kSetCursorLockedUnacceleratedMovement:
            return "Receive owl::mojom::WebContentRendererClient::SetCursorLockedUnacceleratedMovement";
      case messages::WebContentRendererClient::kShowDictionaryOverlayForSelection:
            return "Receive owl::mojom::WebContentRendererClient::ShowDictionaryOverlayForSelection";
      case messages::WebContentRendererClient::kShowDictionaryOverlay:
            return "Receive owl::mojom::WebContentRendererClient::ShowDictionaryOverlay";
      case messages::WebContentRendererClient::kLockKeyboard:
            return "Receive owl::mojom::WebContentRendererClient::LockKeyboard";
      case messages::WebContentRendererClient::kUnlockKeyboard:
            return "Receive owl::mojom::WebContentRendererClient::UnlockKeyboard";
      case messages::WebContentRendererClient::kShowSharingServicePicker:
            return "Receive owl::mojom::WebContentRendererClient::ShowSharingServicePicker";
      case messages::WebContentRendererClient::kDestroy:
            return "Receive owl::mojom::WebContentRendererClient::Destroy";
      case messages::WebContentRendererClient::kGestureScrollEventAck:
            return "Receive owl::mojom::WebContentRendererClient::GestureScrollEventAck";
      case messages::WebContentRendererClient::kDidOverscroll:
            return "Receive owl::mojom::WebContentRendererClient::DidOverscroll";
      case messages::WebContentRendererClient::kDisplayPopupMenu:
            return "Receive owl::mojom::WebContentRendererClient::DisplayPopupMenu";
    }
  } else {
    switch (static_cast<messages::WebContentRendererClient>(message.name())) {
      case messages::WebContentRendererClient::kInitAsPopup:
            return "Receive reply owl::mojom::WebContentRendererClient::InitAsPopup";
      case messages::WebContentRendererClient::kSetPopupBounds:
            return "Receive reply owl::mojom::WebContentRendererClient::SetPopupBounds";
      case messages::WebContentRendererClient::kTakeFocus:
            return "Receive reply owl::mojom::WebContentRendererClient::TakeFocus";
      case messages::WebContentRendererClient::kSetVisible:
            return "Receive reply owl::mojom::WebContentRendererClient::SetVisible";
      case messages::WebContentRendererClient::kSetTooltipText:
            return "Receive reply owl::mojom::WebContentRendererClient::SetTooltipText";
      case messages::WebContentRendererClient::kSetTextInputState:
            return "Receive reply owl::mojom::WebContentRendererClient::SetTextInputState";
      case messages::WebContentRendererClient::kSetTextSelection:
            return "Receive reply owl::mojom::WebContentRendererClient::SetTextSelection";
      case messages::WebContentRendererClient::kSetCompositionRangeInfo:
            return "Receive reply owl::mojom::WebContentRendererClient::SetCompositionRangeInfo";
      case messages::WebContentRendererClient::kCancelComposition:
            return "Receive reply owl::mojom::WebContentRendererClient::CancelComposition";
      case messages::WebContentRendererClient::kOnSelectionBoundsChanged:
            return "Receive reply owl::mojom::WebContentRendererClient::OnSelectionBoundsChanged";
      case messages::WebContentRendererClient::kSetShowingContextMenu:
            return "Receive reply owl::mojom::WebContentRendererClient::SetShowingContextMenu";
      case messages::WebContentRendererClient::kDisplayCursor:
            return "Receive reply owl::mojom::WebContentRendererClient::DisplayCursor";
      case messages::WebContentRendererClient::kSetCursorLocked:
            return "Receive reply owl::mojom::WebContentRendererClient::SetCursorLocked";
      case messages::WebContentRendererClient::kSetCursorLockedUnacceleratedMovement:
            return "Receive reply owl::mojom::WebContentRendererClient::SetCursorLockedUnacceleratedMovement";
      case messages::WebContentRendererClient::kShowDictionaryOverlayForSelection:
            return "Receive reply owl::mojom::WebContentRendererClient::ShowDictionaryOverlayForSelection";
      case messages::WebContentRendererClient::kShowDictionaryOverlay:
            return "Receive reply owl::mojom::WebContentRendererClient::ShowDictionaryOverlay";
      case messages::WebContentRendererClient::kLockKeyboard:
            return "Receive reply owl::mojom::WebContentRendererClient::LockKeyboard";
      case messages::WebContentRendererClient::kUnlockKeyboard:
            return "Receive reply owl::mojom::WebContentRendererClient::UnlockKeyboard";
      case messages::WebContentRendererClient::kShowSharingServicePicker:
            return "Receive reply owl::mojom::WebContentRendererClient::ShowSharingServicePicker";
      case messages::WebContentRendererClient::kDestroy:
            return "Receive reply owl::mojom::WebContentRendererClient::Destroy";
      case messages::WebContentRendererClient::kGestureScrollEventAck:
            return "Receive reply owl::mojom::WebContentRendererClient::GestureScrollEventAck";
      case messages::WebContentRendererClient::kDidOverscroll:
            return "Receive reply owl::mojom::WebContentRendererClient::DidOverscroll";
      case messages::WebContentRendererClient::kDisplayPopupMenu:
            return "Receive reply owl::mojom::WebContentRendererClient::DisplayPopupMenu";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebContentRendererClient::InitAsPopup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8111819;  // IPCStableHash for owl::mojom::WebContentRendererClient::InitAsPopup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetPopupBounds_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b25d735;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetPopupBounds
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::TakeFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa76f1925;  // IPCStableHash for owl::mojom::WebContentRendererClient::TakeFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17f3c25a;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetTooltipText_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb6ef223;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetTooltipText
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetTextInputState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x314281fd;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetTextInputState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetTextSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ed577be;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetTextSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetCompositionRangeInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf2296daa;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetCompositionRangeInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::CancelComposition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76e60159;  // IPCStableHash for owl::mojom::WebContentRendererClient::CancelComposition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::OnSelectionBoundsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8de2b91;  // IPCStableHash for owl::mojom::WebContentRendererClient::OnSelectionBoundsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetShowingContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2583c24b;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetShowingContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::DisplayCursor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x144c3be4;  // IPCStableHash for owl::mojom::WebContentRendererClient::DisplayCursor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetCursorLocked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x111dd07d;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetCursorLocked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::SetCursorLockedUnacceleratedMovement_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ebba73c;  // IPCStableHash for owl::mojom::WebContentRendererClient::SetCursorLockedUnacceleratedMovement
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::ShowDictionaryOverlayForSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5316cc2e;  // IPCStableHash for owl::mojom::WebContentRendererClient::ShowDictionaryOverlayForSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::ShowDictionaryOverlay_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4df996e;  // IPCStableHash for owl::mojom::WebContentRendererClient::ShowDictionaryOverlay
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::LockKeyboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x068cb07a;  // IPCStableHash for owl::mojom::WebContentRendererClient::LockKeyboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::UnlockKeyboard_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a91859e;  // IPCStableHash for owl::mojom::WebContentRendererClient::UnlockKeyboard
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::ShowSharingServicePicker_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x070a200e;  // IPCStableHash for owl::mojom::WebContentRendererClient::ShowSharingServicePicker
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::Destroy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x208f39ab;  // IPCStableHash for owl::mojom::WebContentRendererClient::Destroy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::GestureScrollEventAck_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51a150b8;  // IPCStableHash for owl::mojom::WebContentRendererClient::GestureScrollEventAck
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::DidOverscroll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4679e713;  // IPCStableHash for owl::mojom::WebContentRendererClient::DidOverscroll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebContentRendererClient::DisplayPopupMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3fc1043;  // IPCStableHash for owl::mojom::WebContentRendererClient::DisplayPopupMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback(
      WebContentRendererClient::ShowSharingServicePickerCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback(const WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback&) = delete;
  WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback& operator=(const WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRendererClient::ShowSharingServicePickerCallback callback_;
};

class WebContentRendererClient_DisplayPopupMenu_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebContentRendererClient_DisplayPopupMenu_ForwardToCallback(
      WebContentRendererClient::DisplayPopupMenuCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebContentRendererClient_DisplayPopupMenu_ForwardToCallback(const WebContentRendererClient_DisplayPopupMenu_ForwardToCallback&) = delete;
  WebContentRendererClient_DisplayPopupMenu_ForwardToCallback& operator=(const WebContentRendererClient_DisplayPopupMenu_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebContentRendererClient::DisplayPopupMenuCallback callback_;
};

WebContentRendererClientProxy::WebContentRendererClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebContentRendererClientProxy::InitAsPopup(
    const ::gfx::Rect& in_content_rect, uint64_t in_popup_parent_id, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost> in_layer_host_remote, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient> in_layer_host_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::InitAsPopup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_rect"), in_content_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("popup_parent_id"), in_popup_parent_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_host_remote"), in_layer_host_remote,
                        "<value of type ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layer_host_client"), in_layer_host_client,
                        "<value of type ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kInitAsPopup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_InitAsPopup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_rect)::BaseType> content_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_content_rect,
    content_rect_fragment);

  params->content_rect.Set(
      content_rect_fragment.is_null() ? nullptr : content_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_rect in WebContentRendererClient.InitAsPopup request");

  params->popup_parent_id = in_popup_parent_id;

  
  mojo::internal::Serialize<::owl::mojom::LayerHostAssociatedPtrInfoDataView>(
    in_layer_host_remote,
    &params->layer_host_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->layer_host_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid layer_host_remote in WebContentRendererClient.InitAsPopup request");

  
  mojo::internal::Serialize<::owl::mojom::LayerHostClientAssociatedRequestDataView>(
    in_layer_host_client,
    &params->layer_host_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->layer_host_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid layer_host_client in WebContentRendererClient.InitAsPopup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("InitAsPopup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetPopupBounds(
    const ::gfx::Rect& in_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetPopupBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetPopupBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetPopupBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in WebContentRendererClient.SetPopupBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetPopupBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::TakeFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRendererClient::TakeFocus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kTakeFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_TakeFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("TakeFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetVisible(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetTooltipText(
    const ::std::u16string& in_display_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetTooltipText", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_text"), in_display_text,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetTooltipText), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetTooltipText_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->display_text)::BaseType> display_text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_display_text,
    display_text_fragment);

  params->display_text.Set(
      display_text_fragment.is_null() ? nullptr : display_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->display_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null display_text in WebContentRendererClient.SetTooltipText request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetTooltipText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetTextInputState(
    ::ui::TextInputType in_text_input_type, uint32_t in_flags, const std::optional<::gfx::Rect>& in_edit_context_selection_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetTextInputState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_input_type"), in_text_input_type,
                        "<value of type ::ui::TextInputType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("flags"), in_flags,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("edit_context_selection_bounds"), in_edit_context_selection_bounds,
                        "<value of type const std::optional<::gfx::Rect>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetTextInputState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetTextInputState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::ui::mojom::TextInputType>(
    in_text_input_type,
    &params->text_input_type);

  params->flags = in_flags;
  mojo::internal::MessageFragment<
      typename decltype(params->edit_context_selection_bounds)::BaseType> edit_context_selection_bounds_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_edit_context_selection_bounds,
    edit_context_selection_bounds_fragment);

  params->edit_context_selection_bounds.Set(
      edit_context_selection_bounds_fragment.is_null() ? nullptr : edit_context_selection_bounds_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetTextInputState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetTextSelection(
    const ::std::u16string& in_text, uint64_t in_offset, const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetTextSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetTextSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetTextSelection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WebContentRendererClient.SetTextSelection request");

  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in WebContentRendererClient.SetTextSelection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetTextSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetCompositionRangeInfo(
    const ::gfx::Range& in_range) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetCompositionRangeInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("range"), in_range,
                        "<value of type const ::gfx::Range&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetCompositionRangeInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetCompositionRangeInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->range)::BaseType> range_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
    in_range,
    range_fragment);

  params->range.Set(
      range_fragment.is_null() ? nullptr : range_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->range.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null range in WebContentRendererClient.SetCompositionRangeInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetCompositionRangeInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::CancelComposition(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRendererClient::CancelComposition");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kCancelComposition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_CancelComposition_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("CancelComposition");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::OnSelectionBoundsChanged(
    const ::gfx::Rect& in_selection_rect, const ::gfx::Rect& in_focus_rect, const ::gfx::Rect& in_anchor_rect) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::OnSelectionBoundsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selection_rect"), in_selection_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_rect"), in_focus_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("anchor_rect"), in_anchor_rect,
                        "<value of type const ::gfx::Rect&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kOnSelectionBoundsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_OnSelectionBoundsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->selection_rect)::BaseType> selection_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_selection_rect,
    selection_rect_fragment);

  params->selection_rect.Set(
      selection_rect_fragment.is_null() ? nullptr : selection_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selection_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selection_rect in WebContentRendererClient.OnSelectionBoundsChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->focus_rect)::BaseType> focus_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_focus_rect,
    focus_rect_fragment);

  params->focus_rect.Set(
      focus_rect_fragment.is_null() ? nullptr : focus_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->focus_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null focus_rect in WebContentRendererClient.OnSelectionBoundsChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->anchor_rect)::BaseType> anchor_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_anchor_rect,
    anchor_rect_fragment);

  params->anchor_rect.Set(
      anchor_rect_fragment.is_null() ? nullptr : anchor_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->anchor_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null anchor_rect in WebContentRendererClient.OnSelectionBoundsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("OnSelectionBoundsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetShowingContextMenu(
    bool in_showing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetShowingContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("showing"), in_showing,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetShowingContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetShowingContextMenu_Params_Data> params(
          message);
  params.Allocate();

  params->showing = in_showing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetShowingContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::DisplayCursor(
    const ::ui::Cursor& in_cursor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::DisplayCursor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor"), in_cursor,
                        "<value of type const ::ui::Cursor&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kDisplayCursor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_DisplayCursor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cursor)::BaseType> cursor_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::CursorDataView>(
    in_cursor,
    cursor_fragment);

  params->cursor.Set(
      cursor_fragment.is_null() ? nullptr : cursor_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cursor.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cursor in WebContentRendererClient.DisplayCursor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("DisplayCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetCursorLocked(
    bool in_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetCursorLocked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locked"), in_locked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetCursorLocked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetCursorLocked_Params_Data> params(
          message);
  params.Allocate();

  params->locked = in_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetCursorLocked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::SetCursorLockedUnacceleratedMovement(
    bool in_unaccelerated_movement) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::SetCursorLockedUnacceleratedMovement", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unaccelerated_movement"), in_unaccelerated_movement,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kSetCursorLockedUnacceleratedMovement), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data> params(
          message);
  params.Allocate();

  params->unaccelerated_movement = in_unaccelerated_movement;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("SetCursorLockedUnacceleratedMovement");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::ShowDictionaryOverlayForSelection(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRendererClient::ShowDictionaryOverlayForSelection");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kShowDictionaryOverlayForSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("ShowDictionaryOverlayForSelection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::ShowDictionaryOverlay(
    ::ui::mojom::AttributedStringPtr in_attributed_string, const ::gfx::Point& in_baseline_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::ShowDictionaryOverlay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attributed_string"), in_attributed_string,
                        "<value of type ::ui::mojom::AttributedStringPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("baseline_point"), in_baseline_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kShowDictionaryOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_ShowDictionaryOverlay_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->attributed_string)::BaseType> attributed_string_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::AttributedStringDataView>(
    in_attributed_string,
    attributed_string_fragment);

  params->attributed_string.Set(
      attributed_string_fragment.is_null() ? nullptr : attributed_string_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->attributed_string.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null attributed_string in WebContentRendererClient.ShowDictionaryOverlay request");
  mojo::internal::MessageFragment<
      typename decltype(params->baseline_point)::BaseType> baseline_point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_baseline_point,
    baseline_point_fragment);

  params->baseline_point.Set(
      baseline_point_fragment.is_null() ? nullptr : baseline_point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->baseline_point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null baseline_point in WebContentRendererClient.ShowDictionaryOverlay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("ShowDictionaryOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::LockKeyboard(
    const std::optional<std::vector<uint32_t>>& in_dom_codes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::LockKeyboard", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_codes"), in_dom_codes,
                        "<value of type const std::optional<std::vector<uint32_t>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kLockKeyboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_LockKeyboard_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->dom_codes)::BaseType>
      dom_codes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& dom_codes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_dom_codes,
    dom_codes_fragment,
    &dom_codes_validate_params);

  params->dom_codes.Set(
      dom_codes_fragment.is_null() ? nullptr : dom_codes_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("LockKeyboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::UnlockKeyboard(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRendererClient::UnlockKeyboard");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kUnlockKeyboard), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_UnlockKeyboard_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("UnlockKeyboard");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::ShowSharingServicePicker(
    const std::string& in_title, const std::string& in_text, const std::string& in_url, const std::vector<std::string>& in_file_paths, ShowSharingServicePickerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::ShowSharingServicePicker", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_paths"), in_file_paths,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kShowSharingServicePicker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_ShowSharingServicePicker_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in WebContentRendererClient.ShowSharingServicePicker request");
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in WebContentRendererClient.ShowSharingServicePicker request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebContentRendererClient.ShowSharingServicePicker request");
  mojo::internal::MessageFragment<
      typename decltype(params->file_paths)::BaseType>
      file_paths_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& file_paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_file_paths,
    file_paths_fragment,
    &file_paths_validate_params);

  params->file_paths.Set(
      file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_paths.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_paths in WebContentRendererClient.ShowSharingServicePicker request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("ShowSharingServicePicker");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebContentRendererClientProxy::Destroy(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::WebContentRendererClient::Destroy");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kDestroy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_Destroy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("Destroy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::GestureScrollEventAck(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> in_event, bool in_consumed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::GestureScrollEventAck", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::std::unique_ptr<::blink::WebCoalescedInputEvent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumed"), in_consumed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kGestureScrollEventAck), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_GestureScrollEventAck_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event)::BaseType> event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::EventDataView>(
    in_event,
    event_fragment);

  params->event.Set(
      event_fragment.is_null() ? nullptr : event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event in WebContentRendererClient.GestureScrollEventAck request");

  params->consumed = in_consumed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("GestureScrollEventAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::DidOverscroll(
    OverscrollType in_x, OverscrollType in_y) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::DidOverscroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("x"), in_x,
                        "<value of type OverscrollType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("y"), in_y,
                        "<value of type OverscrollType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kDidOverscroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_DidOverscroll_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::owl::mojom::OverscrollType>(
    in_x,
    &params->x);

  
  mojo::internal::Serialize<::owl::mojom::OverscrollType>(
    in_y,
    &params->y);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("DidOverscroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebContentRendererClientProxy::DisplayPopupMenu(
    PopupMenuPtr in_menu, DisplayPopupMenuCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::WebContentRendererClient::DisplayPopupMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("menu"), in_menu,
                        "<value of type PopupMenuPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kDisplayPopupMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_DisplayPopupMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->menu)::BaseType> menu_fragment(
          params.message());
  
  mojo::internal::Serialize<::owl::mojom::PopupMenuDataView>(
    in_menu,
    menu_fragment);

  params->menu.Set(
      menu_fragment.is_null() ? nullptr : menu_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->menu.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null menu in WebContentRendererClient.DisplayPopupMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("DisplayPopupMenu");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebContentRendererClient_DisplayPopupMenu_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRendererClient::ShowSharingServicePickerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder> proxy(
        new WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRendererClient::ShowSharingServicePickerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::ShareError in_error);
};

bool WebContentRendererClient_ShowSharingServicePicker_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRendererClient.18
  bool success = true;
  ::blink::mojom::ShareError p_error{};
  WebContentRendererClient_ShowSharingServicePicker_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRendererClient::Name_, 18, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder::Run(
    ::blink::mojom::ShareError in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRendererClient::ShowSharingServicePicker", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::blink::mojom::ShareError>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kShowSharingServicePicker), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ShareError>(
    in_error,
    &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("ShowSharingServicePicker");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebContentRendererClient_DisplayPopupMenu_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebContentRendererClient::DisplayPopupMenuCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebContentRendererClient_DisplayPopupMenu_ProxyToResponder> proxy(
        new WebContentRendererClient_DisplayPopupMenu_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebContentRendererClient_DisplayPopupMenu_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebContentRendererClient_DisplayPopupMenu_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebContentRendererClient_DisplayPopupMenu_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebContentRendererClient::DisplayPopupMenuCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<uint32_t> in_selected_item);
};

bool WebContentRendererClient_DisplayPopupMenu_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebContentRendererClient.22
  bool success = true;
  std::optional<uint32_t> p_selected_item{};
  WebContentRendererClient_DisplayPopupMenu_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_selected_item = input_data_view.selected_item();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebContentRendererClient::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_selected_item));
  }
  return true;
}

void WebContentRendererClient_DisplayPopupMenu_ProxyToResponder::Run(
    std::optional<uint32_t> in_selected_item) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply owl::mojom::WebContentRendererClient::DisplayPopupMenu", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_item"), in_selected_item,
                        "<value of type std::optional<uint32_t>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebContentRendererClient::kDisplayPopupMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->selected_item_$flag = in_selected_item.has_value();
  if (in_selected_item.has_value()) {
    params->selected_item_$value = in_selected_item.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebContentRendererClient::Name_);
  message.set_method_name("DisplayPopupMenu");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebContentRendererClientStubDispatch::Accept(
    WebContentRendererClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebContentRendererClient>(message->header()->name)) {
    case messages::WebContentRendererClient::kInitAsPopup: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_InitAsPopup_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_InitAsPopup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.0
      bool success = true;
      ::gfx::Rect p_content_rect{};
      uint64_t p_popup_parent_id{};
      ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost> p_layer_host_remote{};
      ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient> p_layer_host_client{};
      WebContentRendererClient_InitAsPopup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentRect(&p_content_rect))
        success = false;
      if (success)
        p_popup_parent_id = input_data_view.popup_parent_id();
      if (success) {
        p_layer_host_remote =
            input_data_view.TakeLayerHostRemote<decltype(p_layer_host_remote)>();
      }
      if (success) {
        p_layer_host_client =
            input_data_view.TakeLayerHostClient<decltype(p_layer_host_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitAsPopup(        
        std::move(p_content_rect), 
        std::move(p_popup_parent_id), 
        std::move(p_layer_host_remote), 
        std::move(p_layer_host_client));
      return true;
    }
    case messages::WebContentRendererClient::kSetPopupBounds: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetPopupBounds_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetPopupBounds_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.1
      bool success = true;
      ::gfx::Rect p_rect{};
      WebContentRendererClient_SetPopupBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPopupBounds(        
        std::move(p_rect));
      return true;
    }
    case messages::WebContentRendererClient::kTakeFocus: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_TakeFocus_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_TakeFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.2
      bool success = true;
      WebContentRendererClient_TakeFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeFocus(        );
      return true;
    }
    case messages::WebContentRendererClient::kSetVisible: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetVisible_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.3
      bool success = true;
      bool p_visible{};
      WebContentRendererClient_SetVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVisible(        
        std::move(p_visible));
      return true;
    }
    case messages::WebContentRendererClient::kSetTooltipText: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetTooltipText_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetTooltipText_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.4
      bool success = true;
      ::std::u16string p_display_text{};
      WebContentRendererClient_SetTooltipText_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDisplayText(&p_display_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTooltipText(        
        std::move(p_display_text));
      return true;
    }
    case messages::WebContentRendererClient::kSetTextInputState: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetTextInputState_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetTextInputState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.5
      bool success = true;
      ::ui::TextInputType p_text_input_type{};
      uint32_t p_flags{};
      std::optional<::gfx::Rect> p_edit_context_selection_bounds{};
      WebContentRendererClient_SetTextInputState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTextInputType(&p_text_input_type))
        success = false;
      if (success)
        p_flags = input_data_view.flags();
      if (success && !input_data_view.ReadEditContextSelectionBounds(&p_edit_context_selection_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextInputState(        
        std::move(p_text_input_type), 
        std::move(p_flags), 
        std::move(p_edit_context_selection_bounds));
      return true;
    }
    case messages::WebContentRendererClient::kSetTextSelection: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetTextSelection_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetTextSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.6
      bool success = true;
      ::std::u16string p_text{};
      uint64_t p_offset{};
      ::gfx::Range p_range{};
      WebContentRendererClient_SetTextSelection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextSelection(        
        std::move(p_text), 
        std::move(p_offset), 
        std::move(p_range));
      return true;
    }
    case messages::WebContentRendererClient::kSetCompositionRangeInfo: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetCompositionRangeInfo_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetCompositionRangeInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.7
      bool success = true;
      ::gfx::Range p_range{};
      WebContentRendererClient_SetCompositionRangeInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRange(&p_range))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCompositionRangeInfo(        
        std::move(p_range));
      return true;
    }
    case messages::WebContentRendererClient::kCancelComposition: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_CancelComposition_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_CancelComposition_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.8
      bool success = true;
      WebContentRendererClient_CancelComposition_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelComposition(        );
      return true;
    }
    case messages::WebContentRendererClient::kOnSelectionBoundsChanged: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_OnSelectionBoundsChanged_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_OnSelectionBoundsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.9
      bool success = true;
      ::gfx::Rect p_selection_rect{};
      ::gfx::Rect p_focus_rect{};
      ::gfx::Rect p_anchor_rect{};
      WebContentRendererClient_OnSelectionBoundsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSelectionRect(&p_selection_rect))
        success = false;
      if (success && !input_data_view.ReadFocusRect(&p_focus_rect))
        success = false;
      if (success && !input_data_view.ReadAnchorRect(&p_anchor_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSelectionBoundsChanged(        
        std::move(p_selection_rect), 
        std::move(p_focus_rect), 
        std::move(p_anchor_rect));
      return true;
    }
    case messages::WebContentRendererClient::kSetShowingContextMenu: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetShowingContextMenu_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetShowingContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.10
      bool success = true;
      bool p_showing{};
      WebContentRendererClient_SetShowingContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_showing = input_data_view.showing();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetShowingContextMenu(        
        std::move(p_showing));
      return true;
    }
    case messages::WebContentRendererClient::kDisplayCursor: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_DisplayCursor_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_DisplayCursor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.11
      bool success = true;
      ::ui::Cursor p_cursor{};
      WebContentRendererClient_DisplayCursor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCursor(&p_cursor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayCursor(        
        std::move(p_cursor));
      return true;
    }
    case messages::WebContentRendererClient::kSetCursorLocked: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetCursorLocked_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetCursorLocked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.12
      bool success = true;
      bool p_locked{};
      WebContentRendererClient_SetCursorLocked_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_locked = input_data_view.locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursorLocked(        
        std::move(p_locked));
      return true;
    }
    case messages::WebContentRendererClient::kSetCursorLockedUnacceleratedMovement: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.13
      bool success = true;
      bool p_unaccelerated_movement{};
      WebContentRendererClient_SetCursorLockedUnacceleratedMovement_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_unaccelerated_movement = input_data_view.unaccelerated_movement();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursorLockedUnacceleratedMovement(        
        std::move(p_unaccelerated_movement));
      return true;
    }
    case messages::WebContentRendererClient::kShowDictionaryOverlayForSelection: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.14
      bool success = true;
      WebContentRendererClient_ShowDictionaryOverlayForSelection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowDictionaryOverlayForSelection(        );
      return true;
    }
    case messages::WebContentRendererClient::kShowDictionaryOverlay: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_ShowDictionaryOverlay_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_ShowDictionaryOverlay_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.15
      bool success = true;
      ::ui::mojom::AttributedStringPtr p_attributed_string{};
      ::gfx::Point p_baseline_point{};
      WebContentRendererClient_ShowDictionaryOverlay_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAttributedString(&p_attributed_string))
        success = false;
      if (success && !input_data_view.ReadBaselinePoint(&p_baseline_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowDictionaryOverlay(        
        std::move(p_attributed_string), 
        std::move(p_baseline_point));
      return true;
    }
    case messages::WebContentRendererClient::kLockKeyboard: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_LockKeyboard_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_LockKeyboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.16
      bool success = true;
      std::optional<std::vector<uint32_t>> p_dom_codes{};
      WebContentRendererClient_LockKeyboard_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDomCodes(&p_dom_codes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LockKeyboard(        
        std::move(p_dom_codes));
      return true;
    }
    case messages::WebContentRendererClient::kUnlockKeyboard: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_UnlockKeyboard_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_UnlockKeyboard_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.17
      bool success = true;
      WebContentRendererClient_UnlockKeyboard_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnlockKeyboard(        );
      return true;
    }
    case messages::WebContentRendererClient::kShowSharingServicePicker: {
      break;
    }
    case messages::WebContentRendererClient::kDestroy: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_Destroy_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_Destroy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.19
      bool success = true;
      WebContentRendererClient_Destroy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Destroy(        );
      return true;
    }
    case messages::WebContentRendererClient::kGestureScrollEventAck: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_GestureScrollEventAck_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_GestureScrollEventAck_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.20
      bool success = true;
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> p_event{};
      bool p_consumed{};
      WebContentRendererClient_GestureScrollEventAck_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (success)
        p_consumed = input_data_view.consumed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GestureScrollEventAck(        
        std::move(p_event), 
        std::move(p_consumed));
      return true;
    }
    case messages::WebContentRendererClient::kDidOverscroll: {
      DCHECK(message->is_serialized());
      internal::WebContentRendererClient_DidOverscroll_Params_Data* params =
          reinterpret_cast<internal::WebContentRendererClient_DidOverscroll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebContentRendererClient.21
      bool success = true;
      OverscrollType p_x{};
      OverscrollType p_y{};
      WebContentRendererClient_DidOverscroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadX(&p_x))
        success = false;
      if (success && !input_data_view.ReadY(&p_y))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidOverscroll(        
        std::move(p_x), 
        std::move(p_y));
      return true;
    }
    case messages::WebContentRendererClient::kDisplayPopupMenu: {
      break;
    }
  }
  return false;
}

// static
bool WebContentRendererClientStubDispatch::AcceptWithResponder(
    WebContentRendererClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebContentRendererClient>(message->header()->name)) {
    case messages::WebContentRendererClient::kInitAsPopup: {
      break;
    }
    case messages::WebContentRendererClient::kSetPopupBounds: {
      break;
    }
    case messages::WebContentRendererClient::kTakeFocus: {
      break;
    }
    case messages::WebContentRendererClient::kSetVisible: {
      break;
    }
    case messages::WebContentRendererClient::kSetTooltipText: {
      break;
    }
    case messages::WebContentRendererClient::kSetTextInputState: {
      break;
    }
    case messages::WebContentRendererClient::kSetTextSelection: {
      break;
    }
    case messages::WebContentRendererClient::kSetCompositionRangeInfo: {
      break;
    }
    case messages::WebContentRendererClient::kCancelComposition: {
      break;
    }
    case messages::WebContentRendererClient::kOnSelectionBoundsChanged: {
      break;
    }
    case messages::WebContentRendererClient::kSetShowingContextMenu: {
      break;
    }
    case messages::WebContentRendererClient::kDisplayCursor: {
      break;
    }
    case messages::WebContentRendererClient::kSetCursorLocked: {
      break;
    }
    case messages::WebContentRendererClient::kSetCursorLockedUnacceleratedMovement: {
      break;
    }
    case messages::WebContentRendererClient::kShowDictionaryOverlayForSelection: {
      break;
    }
    case messages::WebContentRendererClient::kShowDictionaryOverlay: {
      break;
    }
    case messages::WebContentRendererClient::kLockKeyboard: {
      break;
    }
    case messages::WebContentRendererClient::kUnlockKeyboard: {
      break;
    }
    case messages::WebContentRendererClient::kShowSharingServicePicker: {
      internal::WebContentRendererClient_ShowSharingServicePicker_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRendererClient_ShowSharingServicePicker_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRendererClient.18
      bool success = true;
      std::string p_title{};
      std::string p_text{};
      std::string p_url{};
      std::vector<std::string> p_file_paths{};
      WebContentRendererClient_ShowSharingServicePicker_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadFilePaths(&p_file_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 18, false);
        return false;
      }
      auto callback =
          WebContentRendererClient_ShowSharingServicePicker_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowSharingServicePicker(        
        std::move(p_title), 
        std::move(p_text), 
        std::move(p_url), 
        std::move(p_file_paths), std::move(callback));
      return true;
    }
    case messages::WebContentRendererClient::kDestroy: {
      break;
    }
    case messages::WebContentRendererClient::kGestureScrollEventAck: {
      break;
    }
    case messages::WebContentRendererClient::kDidOverscroll: {
      break;
    }
    case messages::WebContentRendererClient::kDisplayPopupMenu: {
      internal::WebContentRendererClient_DisplayPopupMenu_Params_Data* params =
          reinterpret_cast<
              internal::WebContentRendererClient_DisplayPopupMenu_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebContentRendererClient.22
      bool success = true;
      PopupMenuPtr p_menu{};
      WebContentRendererClient_DisplayPopupMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMenu(&p_menu))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebContentRendererClient::Name_, 22, false);
        return false;
      }
      auto callback =
          WebContentRendererClient_DisplayPopupMenu_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisplayPopupMenu(        
        std::move(p_menu), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebContentRendererClientValidationInfo[] = {
    { &internal::WebContentRendererClient_InitAsPopup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetPopupBounds_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_TakeFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetTooltipText_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetTextInputState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetTextSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetCompositionRangeInfo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_CancelComposition_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_OnSelectionBoundsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetShowingContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_DisplayCursor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetCursorLocked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_SetCursorLockedUnacceleratedMovement_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_ShowDictionaryOverlayForSelection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_ShowDictionaryOverlay_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_LockKeyboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_UnlockKeyboard_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_ShowSharingServicePicker_Params_Data::Validate,
     &internal::WebContentRendererClient_ShowSharingServicePicker_ResponseParams_Data::Validate},
    { &internal::WebContentRendererClient_Destroy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_GestureScrollEventAck_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_DidOverscroll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebContentRendererClient_DisplayPopupMenu_Params_Data::Validate,
     &internal::WebContentRendererClient_DisplayPopupMenu_ResponseParams_Data::Validate},
};

bool WebContentRendererClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::WebContentRendererClient::Name_,
    kWebContentRendererClientValidationInfo);
}

bool WebContentRendererClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::owl::mojom::WebContentRendererClient::Name_,
    kWebContentRendererClientValidationInfo);
}


}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::RectWithRange::DataView, ::owl::mojom::RectWithRangePtr>::Read(
    ::owl::mojom::RectWithRange::DataView input,
    ::owl::mojom::RectWithRangePtr* output) {
  bool success = true;
  ::owl::mojom::RectWithRangePtr result(::owl::mojom::RectWithRange::New());
  
      if (success && !input.ReadRect(&result->rect))
        success = false;
      if (success && !input.ReadRange(&result->range))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::PopupMenu::DataView, ::owl::mojom::PopupMenuPtr>::Read(
    ::owl::mojom::PopupMenu::DataView input,
    ::owl::mojom::PopupMenuPtr* output) {
  bool success = true;
  ::owl::mojom::PopupMenuPtr result(::owl::mojom::PopupMenu::New());
  
      if (success && !input.ReadItems(&result->items))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
      if (success)
        result->item_font_size = input.item_font_size();
      if (success)
        result->right_aligned = input.right_aligned();
      if (success)
        result->selected_item = input.selected_item();
      if (success) {
        result->receiver =
            input.TakeReceiver<decltype(result->receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void WebContentRendererInterceptorForTesting::IsWidgetForMainFrame(IsWidgetForMainFrameCallback callback) {
  GetForwardingInterface()->IsWidgetForMainFrame(std::move(callback));
}
void WebContentRendererInterceptorForTesting::RequestShutdown() {
  GetForwardingInterface()->RequestShutdown();
}
void WebContentRendererInterceptorForTesting::SetFocusLock(bool is_locked) {
  GetForwardingInterface()->SetFocusLock(
    std::move(is_locked)
    );
}
void WebContentRendererInterceptorForTesting::OnFirstResponderChanged(bool is_first_responder) {
  GetForwardingInterface()->OnFirstResponderChanged(
    std::move(is_first_responder)
    );
}
void WebContentRendererInterceptorForTesting::OnWindowIsKeyChanged(bool is_key) {
  GetForwardingInterface()->OnWindowIsKeyChanged(
    std::move(is_key)
    );
}
void WebContentRendererInterceptorForTesting::BeginKeyboardEvent() {
  GetForwardingInterface()->BeginKeyboardEvent();
}
void WebContentRendererInterceptorForTesting::EndKeyboardEvent() {
  GetForwardingInterface()->EndKeyboardEvent();
}
void WebContentRendererInterceptorForTesting::ForwardKeyboardEventWithCommands(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) {
  GetForwardingInterface()->ForwardKeyboardEventWithCommands(
    std::move(event)
    , 
    std::move(native_event_data)
    , 
    std::move(skip_if_unhandled)
    , 
    std::move(commands)
    );
}
void WebContentRendererInterceptorForTesting::ForwardKeyboardEventWithCommandsAndAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands, ForwardKeyboardEventWithCommandsAndAckCallback callback) {
  GetForwardingInterface()->ForwardKeyboardEventWithCommandsAndAck(
    std::move(event)
    , 
    std::move(native_event_data)
    , 
    std::move(skip_if_unhandled)
    , 
    std::move(commands)
    , std::move(callback));
}
void WebContentRendererInterceptorForTesting::RouteOrProcessMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->RouteOrProcessMouseEvent(
    std::move(event)
    );
}
void WebContentRendererInterceptorForTesting::RouteOrProcessTouchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->RouteOrProcessTouchEvent(
    std::move(event)
    );
}
void WebContentRendererInterceptorForTesting::RouteOrProcessWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->RouteOrProcessWheelEvent(
    std::move(event)
    );
}
void WebContentRendererInterceptorForTesting::GestureBegin(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool is_synthetically_injected) {
  GetForwardingInterface()->GestureBegin(
    std::move(event)
    , 
    std::move(is_synthetically_injected)
    );
}
void WebContentRendererInterceptorForTesting::GestureUpdate(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->GestureUpdate(
    std::move(event)
    );
}
void WebContentRendererInterceptorForTesting::GestureEnd(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->GestureEnd(
    std::move(event)
    );
}
void WebContentRendererInterceptorForTesting::SmartMagnify(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) {
  GetForwardingInterface()->SmartMagnify(
    std::move(event)
    );
}
void WebContentRendererInterceptorForTesting::ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& replacement_range, int32_t selection_start, int32_t selection_end) {
  GetForwardingInterface()->ImeSetComposition(
    std::move(text)
    , 
    std::move(ime_text_spans)
    , 
    std::move(replacement_range)
    , 
    std::move(selection_start)
    , 
    std::move(selection_end)
    );
}
void WebContentRendererInterceptorForTesting::ImeCommitText(const ::std::u16string& text, const ::gfx::Range& replacement_range) {
  GetForwardingInterface()->ImeCommitText(
    std::move(text)
    , 
    std::move(replacement_range)
    );
}
void WebContentRendererInterceptorForTesting::ImeFinishComposingText() {
  GetForwardingInterface()->ImeFinishComposingText();
}
void WebContentRendererInterceptorForTesting::ImeCancelCompositionFromClient() {
  GetForwardingInterface()->ImeCancelCompositionFromClient();
}
void WebContentRendererInterceptorForTesting::LookUpDictionaryOverlayAtPoint(const ::gfx::PointF& root_point) {
  GetForwardingInterface()->LookUpDictionaryOverlayAtPoint(
    std::move(root_point)
    );
}
void WebContentRendererInterceptorForTesting::LookUpDictionaryOverlayFromRange(const ::gfx::Range& range) {
  GetForwardingInterface()->LookUpDictionaryOverlayFromRange(
    std::move(range)
    );
}
void WebContentRendererInterceptorForTesting::GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, GetCharacterIndexAtPointCallback callback) {
  GetForwardingInterface()->GetCharacterIndexAtPoint(
    std::move(root_point)
    , std::move(callback));
}
void WebContentRendererInterceptorForTesting::GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) {
  GetForwardingInterface()->GetFirstRectForRange(
    std::move(requested_range)
    , std::move(callback));
}
void WebContentRendererInterceptorForTesting::ExecuteEditCommand(const std::string& command) {
  GetForwardingInterface()->ExecuteEditCommand(
    std::move(command)
    );
}
void WebContentRendererInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void WebContentRendererInterceptorForTesting::Redo() {
  GetForwardingInterface()->Redo();
}
void WebContentRendererInterceptorForTesting::Cut() {
  GetForwardingInterface()->Cut();
}
void WebContentRendererInterceptorForTesting::Copy() {
  GetForwardingInterface()->Copy();
}
void WebContentRendererInterceptorForTesting::CopyToFindPboard() {
  GetForwardingInterface()->CopyToFindPboard();
}
void WebContentRendererInterceptorForTesting::CenterSelection() {
  GetForwardingInterface()->CenterSelection();
}
void WebContentRendererInterceptorForTesting::Paste() {
  GetForwardingInterface()->Paste();
}
void WebContentRendererInterceptorForTesting::PasteAndMatchStyle() {
  GetForwardingInterface()->PasteAndMatchStyle();
}
void WebContentRendererInterceptorForTesting::SelectAll() {
  GetForwardingInterface()->SelectAll();
}
void WebContentRendererInterceptorForTesting::StartSpeaking() {
  GetForwardingInterface()->StartSpeaking();
}
void WebContentRendererInterceptorForTesting::StopSpeaking() {
  GetForwardingInterface()->StopSpeaking();
}
void WebContentRendererInterceptorForTesting::IsSpeaking(IsSpeakingCallback callback) {
  GetForwardingInterface()->IsSpeaking(std::move(callback));
}
void WebContentRendererInterceptorForTesting::GetWebContentRendererAccessibilityToken(GetWebContentRendererAccessibilityTokenCallback callback) {
  GetForwardingInterface()->GetWebContentRendererAccessibilityToken(std::move(callback));
}
void WebContentRendererInterceptorForTesting::SetRemoteAccessibilityTokens(const std::vector<uint8_t>& window_token, const std::vector<uint8_t>& view_token) {
  GetForwardingInterface()->SetRemoteAccessibilityTokens(
    std::move(window_token)
    , 
    std::move(view_token)
    );
}
void WebContentRendererInterceptorForTesting::PingHostView(PingHostViewCallback callback) {
  GetForwardingInterface()->PingHostView(std::move(callback));
}
WebContentRendererAsyncWaiter::WebContentRendererAsyncWaiter(
    WebContentRenderer* proxy) : proxy_(proxy) {}

WebContentRendererAsyncWaiter::~WebContentRendererAsyncWaiter() = default;


void WebContentRendererAsyncWaiter::IsWidgetForMainFrame(
    bool* out_is_for_main_frame) {
  base::RunLoop loop;
  proxy_->IsWidgetForMainFrame(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_for_main_frame
,
             bool is_for_main_frame) {*out_is_for_main_frame = std::move(is_for_main_frame);
            loop->Quit();
          },
          &loop,
          out_is_for_main_frame));
  loop.Run();
}

bool WebContentRendererAsyncWaiter::IsWidgetForMainFrame(
    ) {
  bool async_wait_result;
  IsWidgetForMainFrame(&async_wait_result);
  return async_wait_result;
}

void WebContentRendererAsyncWaiter::ForwardKeyboardEventWithCommandsAndAck(
    ::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) {
  base::RunLoop loop;
  proxy_->ForwardKeyboardEventWithCommandsAndAck(
      std::move(event),
      std::move(native_event_data),
      std::move(skip_if_unhandled),
      std::move(commands),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void WebContentRendererAsyncWaiter::GetCharacterIndexAtPoint(
    const ::gfx::PointF& root_point, std::optional<uint32_t>* out_index) {
  base::RunLoop loop;
  proxy_->GetCharacterIndexAtPoint(
      std::move(root_point),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_index
,
             std::optional<uint32_t> index) {*out_index = std::move(index);
            loop->Quit();
          },
          &loop,
          out_index));
  loop.Run();
}

std::optional<uint32_t> WebContentRendererAsyncWaiter::GetCharacterIndexAtPoint(
    const ::gfx::PointF& root_point) {
  std::optional<uint32_t> async_wait_result;
  GetCharacterIndexAtPoint(std::move(root_point),&async_wait_result);
  return async_wait_result;
}

void WebContentRendererAsyncWaiter::GetFirstRectForRange(
    const ::gfx::Range& requested_range, RectWithRangePtr* out_result) {
  base::RunLoop loop;
  proxy_->GetFirstRectForRange(
      std::move(requested_range),
      base::BindOnce(
          [](base::RunLoop* loop,
             RectWithRangePtr* out_result
,
             RectWithRangePtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

RectWithRangePtr WebContentRendererAsyncWaiter::GetFirstRectForRange(
    const ::gfx::Range& requested_range) {
  RectWithRangePtr async_wait_result;
  GetFirstRectForRange(std::move(requested_range),&async_wait_result);
  return async_wait_result;
}

void WebContentRendererAsyncWaiter::IsSpeaking(
    bool* out_is_speaking) {
  base::RunLoop loop;
  proxy_->IsSpeaking(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_speaking
,
             bool is_speaking) {*out_is_speaking = std::move(is_speaking);
            loop->Quit();
          },
          &loop,
          out_is_speaking));
  loop.Run();
}

bool WebContentRendererAsyncWaiter::IsSpeaking(
    ) {
  bool async_wait_result;
  IsSpeaking(&async_wait_result);
  return async_wait_result;
}

void WebContentRendererAsyncWaiter::GetWebContentRendererAccessibilityToken(
    ::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token) {
  base::RunLoop loop;
  proxy_->GetWebContentRendererAccessibilityToken(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ProcessId* out_host_pid
,
             std::vector<uint8_t>* out_element_token
,
             ::base::ProcessId host_pid,
             const std::vector<uint8_t>& element_token) {*out_host_pid = std::move(host_pid);*out_element_token = std::move(element_token);
            loop->Quit();
          },
          &loop,
          out_host_pid,
          out_element_token));
  loop.Run();
}



void WebContentRendererAsyncWaiter::PingHostView(
    ) {
  base::RunLoop loop;
  proxy_->PingHostView(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void PopupMenuRunnerInterceptorForTesting::Hide() {
  GetForwardingInterface()->Hide();
}
PopupMenuRunnerAsyncWaiter::PopupMenuRunnerAsyncWaiter(
    PopupMenuRunner* proxy) : proxy_(proxy) {}

PopupMenuRunnerAsyncWaiter::~PopupMenuRunnerAsyncWaiter() = default;





void WebContentRendererClientInterceptorForTesting::InitAsPopup(const ::gfx::Rect& content_rect, uint64_t popup_parent_id, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost> layer_host_remote, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient> layer_host_client) {
  GetForwardingInterface()->InitAsPopup(
    std::move(content_rect)
    , 
    std::move(popup_parent_id)
    , 
    std::move(layer_host_remote)
    , 
    std::move(layer_host_client)
    );
}
void WebContentRendererClientInterceptorForTesting::SetPopupBounds(const ::gfx::Rect& rect) {
  GetForwardingInterface()->SetPopupBounds(
    std::move(rect)
    );
}
void WebContentRendererClientInterceptorForTesting::TakeFocus() {
  GetForwardingInterface()->TakeFocus();
}
void WebContentRendererClientInterceptorForTesting::SetVisible(bool visible) {
  GetForwardingInterface()->SetVisible(
    std::move(visible)
    );
}
void WebContentRendererClientInterceptorForTesting::SetTooltipText(const ::std::u16string& display_text) {
  GetForwardingInterface()->SetTooltipText(
    std::move(display_text)
    );
}
void WebContentRendererClientInterceptorForTesting::SetTextInputState(::ui::TextInputType text_input_type, uint32_t flags, const std::optional<::gfx::Rect>& edit_context_selection_bounds) {
  GetForwardingInterface()->SetTextInputState(
    std::move(text_input_type)
    , 
    std::move(flags)
    , 
    std::move(edit_context_selection_bounds)
    );
}
void WebContentRendererClientInterceptorForTesting::SetTextSelection(const ::std::u16string& text, uint64_t offset, const ::gfx::Range& range) {
  GetForwardingInterface()->SetTextSelection(
    std::move(text)
    , 
    std::move(offset)
    , 
    std::move(range)
    );
}
void WebContentRendererClientInterceptorForTesting::SetCompositionRangeInfo(const ::gfx::Range& range) {
  GetForwardingInterface()->SetCompositionRangeInfo(
    std::move(range)
    );
}
void WebContentRendererClientInterceptorForTesting::CancelComposition() {
  GetForwardingInterface()->CancelComposition();
}
void WebContentRendererClientInterceptorForTesting::OnSelectionBoundsChanged(const ::gfx::Rect& selection_rect, const ::gfx::Rect& focus_rect, const ::gfx::Rect& anchor_rect) {
  GetForwardingInterface()->OnSelectionBoundsChanged(
    std::move(selection_rect)
    , 
    std::move(focus_rect)
    , 
    std::move(anchor_rect)
    );
}
void WebContentRendererClientInterceptorForTesting::SetShowingContextMenu(bool showing) {
  GetForwardingInterface()->SetShowingContextMenu(
    std::move(showing)
    );
}
void WebContentRendererClientInterceptorForTesting::DisplayCursor(const ::ui::Cursor& cursor) {
  GetForwardingInterface()->DisplayCursor(
    std::move(cursor)
    );
}
void WebContentRendererClientInterceptorForTesting::SetCursorLocked(bool locked) {
  GetForwardingInterface()->SetCursorLocked(
    std::move(locked)
    );
}
void WebContentRendererClientInterceptorForTesting::SetCursorLockedUnacceleratedMovement(bool unaccelerated_movement) {
  GetForwardingInterface()->SetCursorLockedUnacceleratedMovement(
    std::move(unaccelerated_movement)
    );
}
void WebContentRendererClientInterceptorForTesting::ShowDictionaryOverlayForSelection() {
  GetForwardingInterface()->ShowDictionaryOverlayForSelection();
}
void WebContentRendererClientInterceptorForTesting::ShowDictionaryOverlay(::ui::mojom::AttributedStringPtr attributed_string, const ::gfx::Point& baseline_point) {
  GetForwardingInterface()->ShowDictionaryOverlay(
    std::move(attributed_string)
    , 
    std::move(baseline_point)
    );
}
void WebContentRendererClientInterceptorForTesting::LockKeyboard(const std::optional<std::vector<uint32_t>>& dom_codes) {
  GetForwardingInterface()->LockKeyboard(
    std::move(dom_codes)
    );
}
void WebContentRendererClientInterceptorForTesting::UnlockKeyboard() {
  GetForwardingInterface()->UnlockKeyboard();
}
void WebContentRendererClientInterceptorForTesting::ShowSharingServicePicker(const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths, ShowSharingServicePickerCallback callback) {
  GetForwardingInterface()->ShowSharingServicePicker(
    std::move(title)
    , 
    std::move(text)
    , 
    std::move(url)
    , 
    std::move(file_paths)
    , std::move(callback));
}
void WebContentRendererClientInterceptorForTesting::Destroy() {
  GetForwardingInterface()->Destroy();
}
void WebContentRendererClientInterceptorForTesting::GestureScrollEventAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool consumed) {
  GetForwardingInterface()->GestureScrollEventAck(
    std::move(event)
    , 
    std::move(consumed)
    );
}
void WebContentRendererClientInterceptorForTesting::DidOverscroll(OverscrollType x, OverscrollType y) {
  GetForwardingInterface()->DidOverscroll(
    std::move(x)
    , 
    std::move(y)
    );
}
void WebContentRendererClientInterceptorForTesting::DisplayPopupMenu(PopupMenuPtr menu, DisplayPopupMenuCallback callback) {
  GetForwardingInterface()->DisplayPopupMenu(
    std::move(menu)
    , std::move(callback));
}
WebContentRendererClientAsyncWaiter::WebContentRendererClientAsyncWaiter(
    WebContentRendererClient* proxy) : proxy_(proxy) {}

WebContentRendererClientAsyncWaiter::~WebContentRendererClientAsyncWaiter() = default;


void WebContentRendererClientAsyncWaiter::ShowSharingServicePicker(
    const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths, ::blink::mojom::ShareError* out_error) {
  base::RunLoop loop;
  proxy_->ShowSharingServicePicker(
      std::move(title),
      std::move(text),
      std::move(url),
      std::move(file_paths),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::ShareError* out_error
,
             ::blink::mojom::ShareError error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::blink::mojom::ShareError WebContentRendererClientAsyncWaiter::ShowSharingServicePicker(
    const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths) {
  ::blink::mojom::ShareError async_wait_result;
  ShowSharingServicePicker(std::move(title),std::move(text),std::move(url),std::move(file_paths),&async_wait_result);
  return async_wait_result;
}

void WebContentRendererClientAsyncWaiter::DisplayPopupMenu(
    PopupMenuPtr menu, std::optional<uint32_t>* out_selected_item) {
  base::RunLoop loop;
  proxy_->DisplayPopupMenu(
      std::move(menu),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<uint32_t>* out_selected_item
,
             std::optional<uint32_t> selected_item) {*out_selected_item = std::move(selected_item);
            loop->Quit();
          },
          &loop,
          out_selected_item));
  loop.Run();
}

std::optional<uint32_t> WebContentRendererClientAsyncWaiter::DisplayPopupMenu(
    PopupMenuPtr menu) {
  std::optional<uint32_t> async_wait_result;
  DisplayPopupMenu(std::move(menu),&async_wait_result);
  return async_wait_result;
}






}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif