// owl/mojom/web_content_renderer.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_TEST_UTILS_H_
#define OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_TEST_UTILS_H_

#include "owl/mojom/web_content_renderer.mojom.h"


namespace owl::mojom {


class  WebContentRendererInterceptorForTesting : public WebContentRenderer {
  virtual WebContentRenderer* GetForwardingInterface() = 0;
  void IsWidgetForMainFrame(IsWidgetForMainFrameCallback callback) override;
  void RequestShutdown() override;
  void SetFocusLock(bool is_locked) override;
  void OnFirstResponderChanged(bool is_first_responder) override;
  void OnWindowIsKeyChanged(bool is_key) override;
  void BeginKeyboardEvent() override;
  void EndKeyboardEvent() override;
  void ForwardKeyboardEventWithCommands(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands) override;
  void ForwardKeyboardEventWithCommandsAndAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands, ForwardKeyboardEventWithCommandsAndAckCallback callback) override;
  void RouteOrProcessMouseEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void RouteOrProcessTouchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void RouteOrProcessWheelEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void GestureBegin(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool is_synthetically_injected) override;
  void GestureUpdate(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void GestureEnd(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void SmartMagnify(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& replacement_range, int32_t selection_start, int32_t selection_end) override;
  void ImeCommitText(const ::std::u16string& text, const ::gfx::Range& replacement_range) override;
  void ImeFinishComposingText() override;
  void ImeCancelCompositionFromClient() override;
  void LookUpDictionaryOverlayAtPoint(const ::gfx::PointF& root_point) override;
  void LookUpDictionaryOverlayFromRange(const ::gfx::Range& range) override;
  void GetCharacterIndexAtPoint(const ::gfx::PointF& root_point, GetCharacterIndexAtPointCallback callback) override;
  void GetFirstRectForRange(const ::gfx::Range& requested_range, GetFirstRectForRangeCallback callback) override;
  void ExecuteEditCommand(const std::string& command) override;
  void Undo() override;
  void Redo() override;
  void Cut() override;
  void Copy() override;
  void CopyToFindPboard() override;
  void CenterSelection() override;
  void Paste() override;
  void PasteAndMatchStyle() override;
  void SelectAll() override;
  void StartSpeaking() override;
  void StopSpeaking() override;
  void IsSpeaking(IsSpeakingCallback callback) override;
  void GetWebContentRendererAccessibilityToken(GetWebContentRendererAccessibilityTokenCallback callback) override;
  void SetRemoteAccessibilityTokens(const std::vector<uint8_t>& window_token, const std::vector<uint8_t>& view_token) override;
  void PingHostView(PingHostViewCallback callback) override;
};
class  WebContentRendererAsyncWaiter {
 public:
  explicit WebContentRendererAsyncWaiter(WebContentRenderer* proxy);

  WebContentRendererAsyncWaiter(const WebContentRendererAsyncWaiter&) = delete;
  WebContentRendererAsyncWaiter& operator=(const WebContentRendererAsyncWaiter&) = delete;

  ~WebContentRendererAsyncWaiter();
  void IsWidgetForMainFrame(
      bool* out_is_for_main_frame);
  bool IsWidgetForMainFrame();
  void ForwardKeyboardEventWithCommandsAndAck(
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> event, const std::vector<uint8_t>& native_event_data, bool skip_if_unhandled, std::vector<::blink::mojom::EditCommandPtr> commands);
  
  void GetCharacterIndexAtPoint(
      const ::gfx::PointF& root_point, std::optional<uint32_t>* out_index);
  std::optional<uint32_t> GetCharacterIndexAtPoint(const ::gfx::PointF& root_point);
  void GetFirstRectForRange(
      const ::gfx::Range& requested_range, RectWithRangePtr* out_result);
  RectWithRangePtr GetFirstRectForRange(const ::gfx::Range& requested_range);
  void IsSpeaking(
      bool* out_is_speaking);
  bool IsSpeaking();
  void GetWebContentRendererAccessibilityToken(
      ::base::ProcessId* out_host_pid, std::vector<uint8_t>* out_element_token);
  
  void PingHostView(
      );
  

 private:
  WebContentRenderer* const proxy_;
};


class  PopupMenuRunnerInterceptorForTesting : public PopupMenuRunner {
  virtual PopupMenuRunner* GetForwardingInterface() = 0;
  void Hide() override;
};
class  PopupMenuRunnerAsyncWaiter {
 public:
  explicit PopupMenuRunnerAsyncWaiter(PopupMenuRunner* proxy);

  PopupMenuRunnerAsyncWaiter(const PopupMenuRunnerAsyncWaiter&) = delete;
  PopupMenuRunnerAsyncWaiter& operator=(const PopupMenuRunnerAsyncWaiter&) = delete;

  ~PopupMenuRunnerAsyncWaiter();

 private:
  PopupMenuRunner* const proxy_;
};


class  WebContentRendererClientInterceptorForTesting : public WebContentRendererClient {
  virtual WebContentRendererClient* GetForwardingInterface() = 0;
  void InitAsPopup(const ::gfx::Rect& content_rect, uint64_t popup_parent_id, ::mojo::PendingAssociatedRemote<::owl::mojom::LayerHost> layer_host_remote, ::mojo::PendingAssociatedReceiver<::owl::mojom::LayerHostClient> layer_host_client) override;
  void SetPopupBounds(const ::gfx::Rect& rect) override;
  void TakeFocus() override;
  void SetVisible(bool visible) override;
  void SetTooltipText(const ::std::u16string& display_text) override;
  void SetTextInputState(::ui::TextInputType text_input_type, uint32_t flags, const std::optional<::gfx::Rect>& edit_context_selection_bounds) override;
  void SetTextSelection(const ::std::u16string& text, uint64_t offset, const ::gfx::Range& range) override;
  void SetCompositionRangeInfo(const ::gfx::Range& range) override;
  void CancelComposition() override;
  void OnSelectionBoundsChanged(const ::gfx::Rect& selection_rect, const ::gfx::Rect& focus_rect, const ::gfx::Rect& anchor_rect) override;
  void SetShowingContextMenu(bool showing) override;
  void DisplayCursor(const ::ui::Cursor& cursor) override;
  void SetCursorLocked(bool locked) override;
  void SetCursorLockedUnacceleratedMovement(bool unaccelerated_movement) override;
  void ShowDictionaryOverlayForSelection() override;
  void ShowDictionaryOverlay(::ui::mojom::AttributedStringPtr attributed_string, const ::gfx::Point& baseline_point) override;
  void LockKeyboard(const std::optional<std::vector<uint32_t>>& dom_codes) override;
  void UnlockKeyboard() override;
  void ShowSharingServicePicker(const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths, ShowSharingServicePickerCallback callback) override;
  void Destroy() override;
  void GestureScrollEventAck(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool consumed) override;
  void DidOverscroll(OverscrollType x, OverscrollType y) override;
  void DisplayPopupMenu(PopupMenuPtr menu, DisplayPopupMenuCallback callback) override;
};
class  WebContentRendererClientAsyncWaiter {
 public:
  explicit WebContentRendererClientAsyncWaiter(WebContentRendererClient* proxy);

  WebContentRendererClientAsyncWaiter(const WebContentRendererClientAsyncWaiter&) = delete;
  WebContentRendererClientAsyncWaiter& operator=(const WebContentRendererClientAsyncWaiter&) = delete;

  ~WebContentRendererClientAsyncWaiter();
  void ShowSharingServicePicker(
      const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths, ::blink::mojom::ShareError* out_error);
  ::blink::mojom::ShareError ShowSharingServicePicker(const std::string& title, const std::string& text, const std::string& url, const std::vector<std::string>& file_paths);
  void DisplayPopupMenu(
      PopupMenuPtr menu, std::optional<uint32_t>* out_selected_item);
  std::optional<uint32_t> DisplayPopupMenu(PopupMenuPtr menu);

 private:
  WebContentRendererClient* const proxy_;
};




}  // owl::mojom

#endif  // OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_TEST_UTILS_H_