// owl/mojom/web_content.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "owl/mojom/web_content.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/web_content.mojom-params-data.h"
namespace owl {
namespace mojom {

NOINLINE static const char* WindowSelectionMethodToStringHelper(WindowSelectionMethod value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowSelectionMethod::kDirect:
      return "kDirect";
    case WindowSelectionMethod::kForwardIteration:
      return "kForwardIteration";
    case WindowSelectionMethod::kReverseIteration:
      return "kReverseIteration";
    default:
      return nullptr;
  }
}

std::string WindowSelectionMethodToString(WindowSelectionMethod value) {
  const char *str = WindowSelectionMethodToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowSelectionMethod value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowSelectionMethod value) {
  return os << WindowSelectionMethodToString(value);
}

NOINLINE static const char* WindowVisibilityToStringHelper(WindowVisibility value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WindowVisibility::kVisible:
      return "kVisible";
    case WindowVisibility::kOccluded:
      return "kOccluded";
    case WindowVisibility::kHidden:
      return "kHidden";
    default:
      return nullptr;
  }
}

std::string WindowVisibilityToString(WindowVisibility value) {
  const char *str = WindowVisibilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WindowVisibility value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WindowVisibility value) {
  return os << WindowVisibilityToString(value);
}

NOINLINE static const char* InputModeToStringHelper(InputMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputMode::kUser:
      return "kUser";
    case InputMode::kAgent:
      return "kAgent";
    default:
      return nullptr;
  }
}

std::string InputModeToString(InputMode value) {
  const char *str = InputModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputMode value) {
  return os << InputModeToString(value);
}

NOINLINE static const char* WebContentRendererTypeToStringHelper(WebContentRendererType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebContentRendererType::kMain:
      return "kMain";
    case WebContentRendererType::kChild:
      return "kChild";
    default:
      return nullptr;
  }
}

std::string WebContentRendererTypeToString(WebContentRendererType value) {
  const char *str = WebContentRendererTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebContentRendererType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebContentRendererType value) {
  return os << WebContentRendererTypeToString(value);
}

namespace internal {


// static
bool FileSystemFileInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemFileInfo_Data* object =
      static_cast<const FileSystemFileInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filesystem_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& filesystem_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->filesystem_id, validation_context,
                                         &filesystem_id_validate_params)) {
    return false;
  }

  return true;
}

FileSystemFileInfo_Data::FileSystemFileInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DropData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DropData_Data* object =
      static_cast<const DropData_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& url_title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_title, validation_context,
                                         &url_title_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& download_metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->download_metadata, validation_context,
                                         &download_metadata_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->filenames, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& filenames_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->filenames, validation_context,
                                         &filenames_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_mime_types, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_mime_types_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->file_mime_types, validation_context,
                                         &file_mime_types_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& filesystem_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->filesystem_id, validation_context,
                                         &filesystem_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_system_files, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_system_files_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_system_files, validation_context,
                                         &file_system_files_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& html_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->html, validation_context,
                                         &html_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->html_base_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& file_contents_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_contents, validation_context,
                                         &file_contents_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->file_contents_source_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_contents_filename_extension, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_contents_filename_extension_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_contents_filename_extension, validation_context,
                                         &file_contents_filename_extension_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_contents_content_disposition, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_contents_content_disposition_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_contents_content_disposition, validation_context,
                                         &file_contents_content_disposition_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->custom_data, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& custom_data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->custom_data, validation_context,
                                         &custom_data_validate_params)) {
    return false;
  }


  if (!::ui::mojom::internal::DragOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  return true;
}

DropData_Data::DropData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DraggingInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DraggingInfo_Data* object =
      static_cast<const DraggingInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location_in_view, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location_in_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->location_in_screen, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->location_in_screen, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

DraggingInfo_Data::DraggingInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_SetInputMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_SetInputMode_Params_Data* object =
      static_cast<const WebContent_SetInputMode_Params_Data*>(data);


  if (!::owl::mojom::internal::InputMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

WebContent_SetInputMode_Params_Data::WebContent_SetInputMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_OnMouseEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_OnMouseEvent_Params_Data* object =
      static_cast<const WebContent_OnMouseEvent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->event, validation_context))
    return false;

  return true;
}

WebContent_OnMouseEvent_Params_Data::WebContent_OnMouseEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_OnBecameFirstResponder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_OnBecameFirstResponder_Params_Data* object =
      static_cast<const WebContent_OnBecameFirstResponder_Params_Data*>(data);


  if (!::owl::mojom::internal::WindowSelectionMethod_Data
        ::Validate(object->method, validation_context))
    return false;

  return true;
}

WebContent_OnBecameFirstResponder_Params_Data::WebContent_OnBecameFirstResponder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_OnWindowVisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_OnWindowVisibilityChanged_Params_Data* object =
      static_cast<const WebContent_OnWindowVisibilityChanged_Params_Data*>(data);


  if (!::owl::mojom::internal::WindowVisibility_Data
        ::Validate(object->visibility, validation_context))
    return false;

  return true;
}

WebContent_OnWindowVisibilityChanged_Params_Data::WebContent_OnWindowVisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_DraggingEntered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_DraggingEntered_Params_Data* object =
      static_cast<const WebContent_DraggingEntered_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dragging_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dragging_info, validation_context))
    return false;

  return true;
}

WebContent_DraggingEntered_Params_Data::WebContent_DraggingEntered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_DraggingExited_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_DraggingExited_Params_Data* object =
      static_cast<const WebContent_DraggingExited_Params_Data*>(data);

  return true;
}

WebContent_DraggingExited_Params_Data::WebContent_DraggingExited_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_DraggingUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_DraggingUpdated_Params_Data* object =
      static_cast<const WebContent_DraggingUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dragging_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dragging_info, validation_context))
    return false;

  return true;
}

WebContent_DraggingUpdated_Params_Data::WebContent_DraggingUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_PerformDragOperation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_PerformDragOperation_Params_Data* object =
      static_cast<const WebContent_PerformDragOperation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dragging_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dragging_info, validation_context))
    return false;

  return true;
}

WebContent_PerformDragOperation_Params_Data::WebContent_PerformDragOperation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContent_EndDrag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContent_EndDrag_Params_Data* object =
      static_cast<const WebContent_EndDrag_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->screen_point, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->screen_point, validation_context))
    return false;

  return true;
}

WebContent_EndDrag_Params_Data::WebContent_EndDrag_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_CreateRendererClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_CreateRendererClient_Params_Data* object =
      static_cast<const WebContentClient_CreateRendererClient_Params_Data*>(data);


  if (!::owl::mojom::internal::WebContentRendererType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->renderer, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->renderer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

WebContentClient_CreateRendererClient_Params_Data::WebContentClient_CreateRendererClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_TakeFocus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_TakeFocus_Params_Data* object =
      static_cast<const WebContentClient_TakeFocus_Params_Data*>(data);

  return true;
}

WebContentClient_TakeFocus_Params_Data::WebContentClient_TakeFocus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_Destroy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_Destroy_Params_Data* object =
      static_cast<const WebContentClient_Destroy_Params_Data*>(data);

  return true;
}

WebContentClient_Destroy_Params_Data::WebContentClient_Destroy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_ShowContextMenu_Params_Data* object =
      static_cast<const WebContentClient_ShowContextMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

WebContentClient_ShowContextMenu_Params_Data::WebContentClient_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_StartDrag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_StartDrag_Params_Data* object =
      static_cast<const WebContentClient_StartDrag_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->drop_data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->drop_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_offset, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_offset, validation_context))
    return false;

  return true;
}

WebContentClient_StartDrag_Params_Data::WebContentClient_StartDrag_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_StartNativeDrag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_StartNativeDrag_Params_Data* object =
      static_cast<const WebContentClient_StartNativeDrag_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pasteboard_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pasteboard_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pasteboard_name, validation_context,
                                         &pasteboard_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

WebContentClient_StartNativeDrag_Params_Data::WebContentClient_StartNativeDrag_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_StartNativeDrag_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_StartNativeDrag_ResponseParams_Data* object =
      static_cast<const WebContentClient_StartNativeDrag_ResponseParams_Data*>(data);

  return true;
}

WebContentClient_StartNativeDrag_ResponseParams_Data::WebContentClient_StartNativeDrag_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebContentClient_UpdateDragOperation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebContentClient_UpdateDragOperation_Params_Data* object =
      static_cast<const WebContentClient_UpdateDragOperation_Params_Data*>(data);


  if (!::ui::mojom::internal::DragOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  return true;
}

WebContentClient_UpdateDragOperation_Params_Data::WebContentClient_UpdateDragOperation_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace owl

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::WindowSelectionMethod>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::WindowSelectionMethod value) {
  return std::move(context).WriteString(::owl::mojom::WindowSelectionMethodToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::WindowVisibility>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::WindowVisibility value) {
  return std::move(context).WriteString(::owl::mojom::WindowVisibilityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::InputMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::InputMode value) {
  return std::move(context).WriteString(::owl::mojom::InputModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::owl::mojom::WebContentRendererType>::WriteIntoTrace(
   perfetto::TracedValue context, ::owl::mojom::WebContentRendererType value) {
  return std::move(context).WriteString(::owl::mojom::WebContentRendererTypeToString(value));
}

} // namespace perfetto